
 /****************************************************************************
 *                       THIS FILE WAS GENERATED                             *
 * Script: common/generate_packets.py                                        *
 * Input:  common/networking/packets.def                                     *
 *                       DO NOT CHANGE THIS FILE                             *
 ****************************************************************************/


#ifdef HAVE_CONFIG_H
#include <fc_config.h>
#endif

#include <string.h>

/* utility */
#include "bitvector.h"
#include "capability.h"
#include "genhash.h"
#include "log.h"
#include "mem.h"
#include "support.h"

/* common */
#include "capstr.h"
#include "connection.h"
#include "dataio.h"
#include "game.h"

#include "packets.h"

const char *const packet_functional_capability = "ids32 city-original rsdesc32";

#ifdef FREECIV_DELTA_PROTOCOL
static genhash_val_t hash_const(const void *vkey)
{
  return 0;
}

static bool cmp_const(const void *vkey1, const void *vkey2)
{
  return TRUE;
}
#endif /* FREECIV_DELTA_PROTOCOL */
void delta_stats_report(void) {}

void delta_stats_reset(void) {}

const char *packet_name(enum packet_type type)
{
  static const char *const names[PACKET_LAST] = {
    "PACKET_PROCESSING_STARTED",
    "PACKET_PROCESSING_FINISHED",
    "unknown",
    "unknown",
    "PACKET_SERVER_JOIN_REQ",
    "PACKET_SERVER_JOIN_REPLY",
    "PACKET_AUTHENTICATION_REQ",
    "PACKET_AUTHENTICATION_REPLY",
    "PACKET_SERVER_SHUTDOWN",
    "PACKET_RULESET_TECH_CLASS",
    "PACKET_NATION_SELECT_REQ",
    "PACKET_PLAYER_READY",
    "PACKET_ENDGAME_REPORT",
    "PACKET_SCENARIO_DESCRIPTION",
    "PACKET_EDIT_SCENARIO_DESC",
    "PACKET_TILE_INFO",
    "PACKET_GAME_INFO",
    "PACKET_MAP_INFO",
    "PACKET_NUKE_TILE_INFO",
    "PACKET_TEAM_NAME_INFO",
    "unknown",
    "PACKET_INVESTIGATE_STARTED",
    "PACKET_INVESTIGATE_FINISHED",
    "unknown",
    "unknown",
    "PACKET_CHAT_MSG",
    "PACKET_CHAT_MSG_REQ",
    "PACKET_CONNECT_MSG",
    "PACKET_EARLY_CHAT_MSG",
    "PACKET_SERVER_INFO",
    "PACKET_CITY_REMOVE",
    "PACKET_CITY_INFO",
    "PACKET_CITY_SHORT_INFO",
    "PACKET_CITY_SELL",
    "PACKET_CITY_BUY",
    "PACKET_CITY_CHANGE",
    "PACKET_CITY_WORKLIST",
    "PACKET_CITY_MAKE_SPECIALIST",
    "PACKET_CITY_MAKE_WORKER",
    "PACKET_CITY_CHANGE_SPECIALIST",
    "PACKET_CITY_RENAME",
    "PACKET_CITY_OPTIONS_REQ",
    "PACKET_CITY_REFRESH",
    "PACKET_CITY_NAME_SUGGESTION_REQ",
    "PACKET_CITY_NAME_SUGGESTION_INFO",
    "PACKET_CITY_SABOTAGE_LIST",
    "PACKET_CITY_NATIONALITIES",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_PLAYER_REMOVE",
    "PACKET_PLAYER_INFO",
    "PACKET_PLAYER_PHASE_DONE",
    "PACKET_PLAYER_RATES",
    "PACKET_PLAYER_CHANGE_GOVERNMENT",
    "PACKET_PLAYER_RESEARCH",
    "PACKET_PLAYER_TECH_GOAL",
    "PACKET_PLAYER_ATTRIBUTE_BLOCK",
    "PACKET_PLAYER_ATTRIBUTE_CHUNK",
    "PACKET_PLAYER_DIPLSTATE",
    "PACKET_RESEARCH_INFO",
    "PACKET_PLAYER_PLACE_INFRA",
    "PACKET_UNIT_REMOVE",
    "PACKET_UNIT_INFO",
    "PACKET_UNIT_SHORT_INFO",
    "PACKET_UNIT_COMBAT_INFO",
    "PACKET_UNKNOWN_RESEARCH",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_UNIT_SSCS_SET",
    "unknown",
    "PACKET_UNIT_ORDERS",
    "PACKET_UNIT_SERVER_SIDE_AGENT_SET",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_UNIT_ACTION_QUERY",
    "PACKET_UNIT_TYPE_UPGRADE",
    "PACKET_UNIT_DO_ACTION",
    "PACKET_UNIT_ACTION_ANSWER",
    "unknown",
    "PACKET_UNIT_GET_ACTIONS",
    "PACKET_CONN_PING",
    "PACKET_CONN_PONG",
    "PACKET_UNIT_ACTIONS",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_DIPLOMACY_INIT_MEETING_REQ",
    "PACKET_DIPLOMACY_INIT_MEETING",
    "PACKET_DIPLOMACY_CANCEL_MEETING_REQ",
    "PACKET_DIPLOMACY_CANCEL_MEETING",
    "PACKET_DIPLOMACY_CREATE_CLAUSE_REQ",
    "PACKET_DIPLOMACY_CREATE_CLAUSE",
    "PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ",
    "PACKET_DIPLOMACY_REMOVE_CLAUSE",
    "PACKET_DIPLOMACY_ACCEPT_TREATY_REQ",
    "PACKET_DIPLOMACY_ACCEPT_TREATY",
    "PACKET_DIPLOMACY_CANCEL_PACT",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_PAGE_MSG",
    "PACKET_REPORT_REQ",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_CONN_INFO",
    "PACKET_CONN_PING_INFO",
    "unknown",
    "unknown",
    "PACKET_CLIENT_INFO",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_END_PHASE",
    "PACKET_START_PHASE",
    "PACKET_NEW_YEAR",
    "PACKET_BEGIN_TURN",
    "PACKET_END_TURN",
    "PACKET_FREEZE_CLIENT",
    "PACKET_THAW_CLIENT",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_SPACESHIP_LAUNCH",
    "PACKET_SPACESHIP_PLACE",
    "PACKET_SPACESHIP_INFO",
    "PACKET_CITY_RALLY_POINT",
    "unknown",
    "PACKET_RULESET_UNIT",
    "PACKET_RULESET_GAME",
    "PACKET_RULESET_SPECIALIST",
    "PACKET_RULESET_GOVERNMENT_RULER_TITLE",
    "PACKET_RULESET_TECH",
    "PACKET_RULESET_GOVERNMENT",
    "PACKET_RULESET_TERRAIN_CONTROL",
    "PACKET_RULESET_NATION_GROUPS",
    "PACKET_RULESET_NATION",
    "PACKET_RULESET_CITY",
    "PACKET_RULESET_BUILDING",
    "PACKET_RULESET_TERRAIN",
    "PACKET_RULESET_UNIT_CLASS",
    "PACKET_RULESET_BASE",
    "unknown",
    "PACKET_RULESET_CONTROL",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_SINGLE_WANT_HACK_REQ",
    "PACKET_SINGLE_WANT_HACK_REPLY",
    "PACKET_RULESET_CHOICES",
    "PACKET_GAME_LOAD",
    "PACKET_SERVER_SETTING_CONTROL",
    "PACKET_SERVER_SETTING_CONST",
    "PACKET_SERVER_SETTING_BOOL",
    "PACKET_SERVER_SETTING_INT",
    "PACKET_SERVER_SETTING_STR",
    "PACKET_SERVER_SETTING_ENUM",
    "PACKET_SERVER_SETTING_BITWISE",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_RULESET_EFFECT",
    "unknown",
    "PACKET_RULESET_RESOURCE",
    "unknown",
    "unknown",
    "PACKET_SCENARIO_INFO",
    "PACKET_SAVE_SCENARIO",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_VOTE_NEW",
    "PACKET_VOTE_UPDATE",
    "PACKET_VOTE_REMOVE",
    "PACKET_VOTE_RESOLVE",
    "PACKET_VOTE_SUBMIT",
    "PACKET_EDIT_MODE",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_EDIT_RECALCULATE_BORDERS",
    "PACKET_EDIT_CHECK_TILES",
    "PACKET_EDIT_TOGGLE_FOGOFWAR",
    "PACKET_EDIT_TILE_TERRAIN",
    "unknown",
    "PACKET_EDIT_TILE_EXTRA",
    "unknown",
    "PACKET_EDIT_STARTPOS",
    "PACKET_EDIT_STARTPOS_FULL",
    "PACKET_EDIT_TILE",
    "PACKET_EDIT_UNIT_CREATE",
    "PACKET_EDIT_UNIT_REMOVE",
    "PACKET_EDIT_UNIT_REMOVE_BY_ID",
    "PACKET_EDIT_UNIT",
    "PACKET_EDIT_CITY_CREATE",
    "PACKET_EDIT_CITY_REMOVE",
    "PACKET_EDIT_CITY",
    "PACKET_EDIT_PLAYER_CREATE",
    "PACKET_EDIT_PLAYER_REMOVE",
    "PACKET_EDIT_PLAYER",
    "PACKET_EDIT_PLAYER_VISION",
    "PACKET_EDIT_GAME",
    "PACKET_EDIT_OBJECT_CREATED",
    "PACKET_RULESET_ROAD",
    "unknown",
    "PACKET_UNIT_CHANGE_ACTIVITY",
    "PACKET_ENDGAME_PLAYER",
    "PACKET_RULESET_DISASTER",
    "PACKET_RULESETS_READY",
    "PACKET_RULESET_EXTRA_FLAG",
    "PACKET_RULESET_TRADE",
    "PACKET_RULESET_UNIT_BONUS",
    "PACKET_RULESET_UNIT_FLAG",
    "PACKET_RULESET_UNIT_CLASS_FLAG",
    "PACKET_RULESET_TERRAIN_FLAG",
    "PACKET_RULESET_EXTRA",
    "PACKET_RULESET_ACHIEVEMENT",
    "PACKET_RULESET_TECH_FLAG",
    "PACKET_RULESET_ACTION_ENABLER",
    "PACKET_RULESET_NATION_SETS",
    "PACKET_NATION_AVAILABILITY",
    "PACKET_ACHIEVEMENT_INFO",
    "PACKET_RULESET_STYLE",
    "PACKET_RULESET_MUSIC",
    "PACKET_WORKER_TASK",
    "PACKET_PLAYER_MULTIPLIER",
    "PACKET_RULESET_MULTIPLIER",
    "PACKET_TIMEOUT_INFO",
    "PACKET_PLAY_MUSIC",
    "PACKET_RULESET_ACTION",
    "PACKET_RULESET_DESCRIPTION_PART",
    "PACKET_RULESET_GOODS",
    "PACKET_TRADE_ROUTE_INFO",
    "PACKET_PAGE_MSG_PART",
    "PACKET_RULESET_SUMMARY",
    "PACKET_RULESET_ACTION_AUTO",
    "PACKET_SET_TOPOLOGY",
    "PACKET_CLIENT_HEARTBEAT",
    "PACKET_CALENDAR_INFO",
    "PACKET_WEB_CITY_INFO_ADDITION",
    "PACKET_WEB_PLAYER_INFO_ADDITION",
    "PACKET_WEB_RULESET_UNIT_ADDITION",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_RULESET_CLAUSE",
  };

  return (type < PACKET_LAST ? names[type] : "unknown");
}

bool packet_has_game_info_flag(enum packet_type type)
{
  static const bool flag[PACKET_LAST] = {
    FALSE, /* PACKET_PROCESSING_STARTED */
    FALSE, /* PACKET_PROCESSING_FINISHED */
    FALSE,
    FALSE,
    FALSE, /* PACKET_SERVER_JOIN_REQ */
    FALSE, /* PACKET_SERVER_JOIN_REPLY */
    FALSE, /* PACKET_AUTHENTICATION_REQ */
    FALSE, /* PACKET_AUTHENTICATION_REPLY */
    FALSE, /* PACKET_SERVER_SHUTDOWN */
    FALSE, /* PACKET_RULESET_TECH_CLASS */
    FALSE, /* PACKET_NATION_SELECT_REQ */
    FALSE, /* PACKET_PLAYER_READY */
    FALSE, /* PACKET_ENDGAME_REPORT */
    FALSE, /* PACKET_SCENARIO_DESCRIPTION */
    FALSE, /* PACKET_EDIT_SCENARIO_DESC */
    TRUE, /* PACKET_TILE_INFO */
    FALSE, /* PACKET_GAME_INFO */
    FALSE, /* PACKET_MAP_INFO */
    FALSE, /* PACKET_NUKE_TILE_INFO */
    FALSE, /* PACKET_TEAM_NAME_INFO */
    FALSE,
    FALSE, /* PACKET_INVESTIGATE_STARTED */
    FALSE, /* PACKET_INVESTIGATE_FINISHED */
    FALSE,
    FALSE,
    FALSE, /* PACKET_CHAT_MSG */
    FALSE, /* PACKET_CHAT_MSG_REQ */
    FALSE, /* PACKET_CONNECT_MSG */
    FALSE, /* PACKET_EARLY_CHAT_MSG */
    FALSE, /* PACKET_SERVER_INFO */
    FALSE, /* PACKET_CITY_REMOVE */
    TRUE, /* PACKET_CITY_INFO */
    TRUE, /* PACKET_CITY_SHORT_INFO */
    FALSE, /* PACKET_CITY_SELL */
    FALSE, /* PACKET_CITY_BUY */
    FALSE, /* PACKET_CITY_CHANGE */
    FALSE, /* PACKET_CITY_WORKLIST */
    FALSE, /* PACKET_CITY_MAKE_SPECIALIST */
    FALSE, /* PACKET_CITY_MAKE_WORKER */
    FALSE, /* PACKET_CITY_CHANGE_SPECIALIST */
    FALSE, /* PACKET_CITY_RENAME */
    FALSE, /* PACKET_CITY_OPTIONS_REQ */
    FALSE, /* PACKET_CITY_REFRESH */
    FALSE, /* PACKET_CITY_NAME_SUGGESTION_REQ */
    FALSE, /* PACKET_CITY_NAME_SUGGESTION_INFO */
    FALSE, /* PACKET_CITY_SABOTAGE_LIST */
    TRUE, /* PACKET_CITY_NATIONALITIES */
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_PLAYER_REMOVE */
    FALSE, /* PACKET_PLAYER_INFO */
    FALSE, /* PACKET_PLAYER_PHASE_DONE */
    FALSE, /* PACKET_PLAYER_RATES */
    FALSE, /* PACKET_PLAYER_CHANGE_GOVERNMENT */
    FALSE, /* PACKET_PLAYER_RESEARCH */
    FALSE, /* PACKET_PLAYER_TECH_GOAL */
    FALSE, /* PACKET_PLAYER_ATTRIBUTE_BLOCK */
    FALSE, /* PACKET_PLAYER_ATTRIBUTE_CHUNK */
    FALSE, /* PACKET_PLAYER_DIPLSTATE */
    TRUE, /* PACKET_RESEARCH_INFO */
    FALSE, /* PACKET_PLAYER_PLACE_INFRA */
    FALSE, /* PACKET_UNIT_REMOVE */
    TRUE, /* PACKET_UNIT_INFO */
    TRUE, /* PACKET_UNIT_SHORT_INFO */
    FALSE, /* PACKET_UNIT_COMBAT_INFO */
    TRUE, /* PACKET_UNKNOWN_RESEARCH */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_UNIT_SSCS_SET */
    FALSE,
    FALSE, /* PACKET_UNIT_ORDERS */
    FALSE, /* PACKET_UNIT_SERVER_SIDE_AGENT_SET */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_UNIT_ACTION_QUERY */
    FALSE, /* PACKET_UNIT_TYPE_UPGRADE */
    FALSE, /* PACKET_UNIT_DO_ACTION */
    FALSE, /* PACKET_UNIT_ACTION_ANSWER */
    FALSE,
    FALSE, /* PACKET_UNIT_GET_ACTIONS */
    FALSE, /* PACKET_CONN_PING */
    FALSE, /* PACKET_CONN_PONG */
    FALSE, /* PACKET_UNIT_ACTIONS */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_DIPLOMACY_INIT_MEETING_REQ */
    FALSE, /* PACKET_DIPLOMACY_INIT_MEETING */
    FALSE, /* PACKET_DIPLOMACY_CANCEL_MEETING_REQ */
    FALSE, /* PACKET_DIPLOMACY_CANCEL_MEETING */
    FALSE, /* PACKET_DIPLOMACY_CREATE_CLAUSE_REQ */
    FALSE, /* PACKET_DIPLOMACY_CREATE_CLAUSE */
    FALSE, /* PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ */
    FALSE, /* PACKET_DIPLOMACY_REMOVE_CLAUSE */
    FALSE, /* PACKET_DIPLOMACY_ACCEPT_TREATY_REQ */
    FALSE, /* PACKET_DIPLOMACY_ACCEPT_TREATY */
    FALSE, /* PACKET_DIPLOMACY_CANCEL_PACT */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_PAGE_MSG */
    FALSE, /* PACKET_REPORT_REQ */
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_CONN_INFO */
    FALSE, /* PACKET_CONN_PING_INFO */
    FALSE,
    FALSE,
    FALSE, /* PACKET_CLIENT_INFO */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_END_PHASE */
    FALSE, /* PACKET_START_PHASE */
    FALSE, /* PACKET_NEW_YEAR */
    FALSE, /* PACKET_BEGIN_TURN */
    FALSE, /* PACKET_END_TURN */
    FALSE, /* PACKET_FREEZE_CLIENT */
    FALSE, /* PACKET_THAW_CLIENT */
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_SPACESHIP_LAUNCH */
    FALSE, /* PACKET_SPACESHIP_PLACE */
    TRUE, /* PACKET_SPACESHIP_INFO */
    TRUE, /* PACKET_CITY_RALLY_POINT */
    FALSE,
    FALSE, /* PACKET_RULESET_UNIT */
    FALSE, /* PACKET_RULESET_GAME */
    FALSE, /* PACKET_RULESET_SPECIALIST */
    FALSE, /* PACKET_RULESET_GOVERNMENT_RULER_TITLE */
    FALSE, /* PACKET_RULESET_TECH */
    FALSE, /* PACKET_RULESET_GOVERNMENT */
    FALSE, /* PACKET_RULESET_TERRAIN_CONTROL */
    FALSE, /* PACKET_RULESET_NATION_GROUPS */
    FALSE, /* PACKET_RULESET_NATION */
    FALSE, /* PACKET_RULESET_CITY */
    FALSE, /* PACKET_RULESET_BUILDING */
    FALSE, /* PACKET_RULESET_TERRAIN */
    FALSE, /* PACKET_RULESET_UNIT_CLASS */
    FALSE, /* PACKET_RULESET_BASE */
    FALSE,
    FALSE, /* PACKET_RULESET_CONTROL */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_SINGLE_WANT_HACK_REQ */
    FALSE, /* PACKET_SINGLE_WANT_HACK_REPLY */
    FALSE, /* PACKET_RULESET_CHOICES */
    FALSE, /* PACKET_GAME_LOAD */
    FALSE, /* PACKET_SERVER_SETTING_CONTROL */
    FALSE, /* PACKET_SERVER_SETTING_CONST */
    FALSE, /* PACKET_SERVER_SETTING_BOOL */
    FALSE, /* PACKET_SERVER_SETTING_INT */
    FALSE, /* PACKET_SERVER_SETTING_STR */
    FALSE, /* PACKET_SERVER_SETTING_ENUM */
    FALSE, /* PACKET_SERVER_SETTING_BITWISE */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_RULESET_EFFECT */
    FALSE,
    FALSE, /* PACKET_RULESET_RESOURCE */
    FALSE,
    FALSE,
    FALSE, /* PACKET_SCENARIO_INFO */
    FALSE, /* PACKET_SAVE_SCENARIO */
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_VOTE_NEW */
    FALSE, /* PACKET_VOTE_UPDATE */
    FALSE, /* PACKET_VOTE_REMOVE */
    FALSE, /* PACKET_VOTE_RESOLVE */
    FALSE, /* PACKET_VOTE_SUBMIT */
    FALSE, /* PACKET_EDIT_MODE */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_EDIT_RECALCULATE_BORDERS */
    FALSE, /* PACKET_EDIT_CHECK_TILES */
    FALSE, /* PACKET_EDIT_TOGGLE_FOGOFWAR */
    FALSE, /* PACKET_EDIT_TILE_TERRAIN */
    FALSE,
    FALSE, /* PACKET_EDIT_TILE_EXTRA */
    FALSE,
    FALSE, /* PACKET_EDIT_STARTPOS */
    FALSE, /* PACKET_EDIT_STARTPOS_FULL */
    FALSE, /* PACKET_EDIT_TILE */
    FALSE, /* PACKET_EDIT_UNIT_CREATE */
    FALSE, /* PACKET_EDIT_UNIT_REMOVE */
    FALSE, /* PACKET_EDIT_UNIT_REMOVE_BY_ID */
    FALSE, /* PACKET_EDIT_UNIT */
    FALSE, /* PACKET_EDIT_CITY_CREATE */
    FALSE, /* PACKET_EDIT_CITY_REMOVE */
    FALSE, /* PACKET_EDIT_CITY */
    FALSE, /* PACKET_EDIT_PLAYER_CREATE */
    FALSE, /* PACKET_EDIT_PLAYER_REMOVE */
    FALSE, /* PACKET_EDIT_PLAYER */
    FALSE, /* PACKET_EDIT_PLAYER_VISION */
    FALSE, /* PACKET_EDIT_GAME */
    FALSE, /* PACKET_EDIT_OBJECT_CREATED */
    FALSE, /* PACKET_RULESET_ROAD */
    FALSE,
    FALSE, /* PACKET_UNIT_CHANGE_ACTIVITY */
    FALSE, /* PACKET_ENDGAME_PLAYER */
    FALSE, /* PACKET_RULESET_DISASTER */
    FALSE, /* PACKET_RULESETS_READY */
    FALSE, /* PACKET_RULESET_EXTRA_FLAG */
    FALSE, /* PACKET_RULESET_TRADE */
    FALSE, /* PACKET_RULESET_UNIT_BONUS */
    FALSE, /* PACKET_RULESET_UNIT_FLAG */
    FALSE, /* PACKET_RULESET_UNIT_CLASS_FLAG */
    FALSE, /* PACKET_RULESET_TERRAIN_FLAG */
    FALSE, /* PACKET_RULESET_EXTRA */
    FALSE, /* PACKET_RULESET_ACHIEVEMENT */
    FALSE, /* PACKET_RULESET_TECH_FLAG */
    FALSE, /* PACKET_RULESET_ACTION_ENABLER */
    FALSE, /* PACKET_RULESET_NATION_SETS */
    FALSE, /* PACKET_NATION_AVAILABILITY */
    FALSE, /* PACKET_ACHIEVEMENT_INFO */
    FALSE, /* PACKET_RULESET_STYLE */
    FALSE, /* PACKET_RULESET_MUSIC */
    FALSE, /* PACKET_WORKER_TASK */
    FALSE, /* PACKET_PLAYER_MULTIPLIER */
    FALSE, /* PACKET_RULESET_MULTIPLIER */
    FALSE, /* PACKET_TIMEOUT_INFO */
    FALSE, /* PACKET_PLAY_MUSIC */
    FALSE, /* PACKET_RULESET_ACTION */
    FALSE, /* PACKET_RULESET_DESCRIPTION_PART */
    FALSE, /* PACKET_RULESET_GOODS */
    FALSE, /* PACKET_TRADE_ROUTE_INFO */
    FALSE, /* PACKET_PAGE_MSG_PART */
    FALSE, /* PACKET_RULESET_SUMMARY */
    FALSE, /* PACKET_RULESET_ACTION_AUTO */
    FALSE, /* PACKET_SET_TOPOLOGY */
    FALSE, /* PACKET_CLIENT_HEARTBEAT */
    FALSE, /* PACKET_CALENDAR_INFO */
    TRUE, /* PACKET_WEB_CITY_INFO_ADDITION */
    FALSE, /* PACKET_WEB_PLAYER_INFO_ADDITION */
    FALSE, /* PACKET_WEB_RULESET_UNIT_ADDITION */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_RULESET_CLAUSE */
  };

  return (type < PACKET_LAST ? flag[type] : FALSE);
}

static struct packet_processing_started *receive_packet_processing_started_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_processing_started, real_packet);
#if 1 /* To match endif */
  real_packet->__dummy = 0xff;
#endif
  log_packet_detailed("packet_processing_started_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_processing_started_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PROCESSING_STARTED);

  log_packet_detailed("packet_processing_started_100: sending info about ()");
  SEND_PACKET_END(PACKET_PROCESSING_STARTED);
}

int send_packet_processing_started(struct connection *pc)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PROCESSING_STARTED].no_packet != NULL, -1,
                        "Handler for PACKET_PROCESSING_STARTED not installed");
  return pc->phs.handlers->send[PACKET_PROCESSING_STARTED].no_packet(pc);
}

static struct packet_processing_finished *receive_packet_processing_finished_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_processing_finished, real_packet);
#if 1 /* To match endif */
  real_packet->__dummy = 0xff;
#endif
  log_packet_detailed("packet_processing_finished_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_processing_finished_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PROCESSING_FINISHED);

  log_packet_detailed("packet_processing_finished_100: sending info about ()");
  SEND_PACKET_END(PACKET_PROCESSING_FINISHED);
}

int send_packet_processing_finished(struct connection *pc)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PROCESSING_FINISHED].no_packet != NULL, -1,
                        "Handler for PACKET_PROCESSING_FINISHED not installed");
  return pc->phs.handlers->send[PACKET_PROCESSING_FINISHED].no_packet(pc);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_investigate_started_100 hash_const

#define cmp_packet_investigate_started_100 cmp_const

BV_DEFINE(packet_investigate_started_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_investigate_started *receive_packet_investigate_started_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_investigate_started_100_fields fields;
  struct packet_investigate_started *old;
  struct genhash **hash = pc->phs.received + PACKET_INVESTIGATE_STARTED;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_investigate_started, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->unit_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(unit_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }

#endif
  log_packet_detailed("packet_investigate_started_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_investigate_started_100, cmp_packet_investigate_started_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unit_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->unit_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_investigate_started_100(struct connection *pc, const struct packet_investigate_started *packet)
{
  const struct packet_investigate_started *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_investigate_started_100_fields fields;
  struct packet_investigate_started *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_INVESTIGATE_STARTED;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_INVESTIGATE_STARTED);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_investigate_started_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_investigate_started_100, cmp_packet_investigate_started_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->unit_id32 != real_packet->unit_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->unit_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->unit_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);

#endif
  SEND_PACKET_END(PACKET_INVESTIGATE_STARTED);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_investigate_started_101 hash_const

#define cmp_packet_investigate_started_101 cmp_const

BV_DEFINE(packet_investigate_started_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_investigate_started *receive_packet_investigate_started_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_investigate_started_101_fields fields;
  struct packet_investigate_started *old;
  struct genhash **hash = pc->phs.received + PACKET_INVESTIGATE_STARTED;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_investigate_started, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->unit_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(unit_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }

#endif
  log_packet_detailed("packet_investigate_started_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_investigate_started_101, cmp_packet_investigate_started_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unit_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->unit_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_investigate_started_101(struct connection *pc, const struct packet_investigate_started *packet)
{
  const struct packet_investigate_started *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_investigate_started_101_fields fields;
  struct packet_investigate_started *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_INVESTIGATE_STARTED;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_INVESTIGATE_STARTED);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_investigate_started_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_investigate_started_101, cmp_packet_investigate_started_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->unit_id16 != real_packet->unit_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->unit_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->unit_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);

#endif
  SEND_PACKET_END(PACKET_INVESTIGATE_STARTED);
}

int send_packet_investigate_started(struct connection *pc, const struct packet_investigate_started *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_INVESTIGATE_STARTED].packet != NULL, -1,
                        "Handler for PACKET_INVESTIGATE_STARTED not installed");
  return pc->phs.handlers->send[PACKET_INVESTIGATE_STARTED].packet(pc, packet);
}

int dsend_packet_investigate_started(struct connection *pc, int unit_id16, int unit_id32, int city_id16, int city_id32)
{
  struct packet_investigate_started packet, *real_packet = &packet;

  real_packet->unit_id16 = unit_id16;
  real_packet->unit_id32 = unit_id32;
  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  
  return send_packet_investigate_started(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_investigate_finished_100 hash_const

#define cmp_packet_investigate_finished_100 cmp_const

BV_DEFINE(packet_investigate_finished_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_investigate_finished *receive_packet_investigate_finished_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_investigate_finished_100_fields fields;
  struct packet_investigate_finished *old;
  struct genhash **hash = pc->phs.received + PACKET_INVESTIGATE_FINISHED;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_investigate_finished, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->unit_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(unit_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }

#endif
  log_packet_detailed("packet_investigate_finished_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_investigate_finished_100, cmp_packet_investigate_finished_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unit_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->unit_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_investigate_finished_100(struct connection *pc, const struct packet_investigate_finished *packet)
{
  const struct packet_investigate_finished *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_investigate_finished_100_fields fields;
  struct packet_investigate_finished *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_INVESTIGATE_FINISHED;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_INVESTIGATE_FINISHED);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_investigate_finished_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_investigate_finished_100, cmp_packet_investigate_finished_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->unit_id32 != real_packet->unit_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->unit_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->unit_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);

#endif
  SEND_PACKET_END(PACKET_INVESTIGATE_FINISHED);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_investigate_finished_101 hash_const

#define cmp_packet_investigate_finished_101 cmp_const

BV_DEFINE(packet_investigate_finished_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_investigate_finished *receive_packet_investigate_finished_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_investigate_finished_101_fields fields;
  struct packet_investigate_finished *old;
  struct genhash **hash = pc->phs.received + PACKET_INVESTIGATE_FINISHED;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_investigate_finished, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->unit_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(unit_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }

#endif
  log_packet_detailed("packet_investigate_finished_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_investigate_finished_101, cmp_packet_investigate_finished_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unit_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->unit_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_investigate_finished_101(struct connection *pc, const struct packet_investigate_finished *packet)
{
  const struct packet_investigate_finished *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_investigate_finished_101_fields fields;
  struct packet_investigate_finished *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_INVESTIGATE_FINISHED;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_INVESTIGATE_FINISHED);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_investigate_finished_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_investigate_finished_101, cmp_packet_investigate_finished_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->unit_id16 != real_packet->unit_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->unit_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->unit_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);

#endif
  SEND_PACKET_END(PACKET_INVESTIGATE_FINISHED);
}

int send_packet_investigate_finished(struct connection *pc, const struct packet_investigate_finished *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_INVESTIGATE_FINISHED].packet != NULL, -1,
                        "Handler for PACKET_INVESTIGATE_FINISHED not installed");
  return pc->phs.handlers->send[PACKET_INVESTIGATE_FINISHED].packet(pc, packet);
}

int dsend_packet_investigate_finished(struct connection *pc, int unit_id16, int unit_id32, int city_id16, int city_id32)
{
  struct packet_investigate_finished packet, *real_packet = &packet;

  real_packet->unit_id16 = unit_id16;
  real_packet->unit_id32 = unit_id32;
  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  
  return send_packet_investigate_finished(pc, real_packet);
}

static struct packet_server_join_req *receive_packet_server_join_req_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_join_req, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */
#if 1 /* To match endif */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "username";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->username, sizeof(real_packet->username))) {
    RECEIVE_PACKET_FIELD_ERROR(username);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capability";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->capability, sizeof(real_packet->capability))) {
    RECEIVE_PACKET_FIELD_ERROR(capability);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "version_label";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->version_label, sizeof(real_packet->version_label))) {
    RECEIVE_PACKET_FIELD_ERROR(version_label);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "major_version";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->major_version)) {
    RECEIVE_PACKET_FIELD_ERROR(major_version);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "minor_version";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->minor_version)) {
    RECEIVE_PACKET_FIELD_ERROR(minor_version);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "patch_version";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->patch_version)) {
    RECEIVE_PACKET_FIELD_ERROR(patch_version);
  }

#endif
  log_packet_detailed("packet_server_join_req_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_join_req_100(struct connection *pc, const struct packet_server_join_req *packet)
{
  const struct packet_server_join_req *real_packet = packet;
  SEND_PACKET_START(PACKET_SERVER_JOIN_REQ);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_server_join_req_100: sending info about ()");
#if 1 /* To match endif */
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "username";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->username);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capability";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->capability);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "version_label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->version_label);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "major_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->major_version);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "minor_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->minor_version);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "patch_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->patch_version);

#endif
  SEND_PACKET_END(PACKET_SERVER_JOIN_REQ);
}

int send_packet_server_join_req(struct connection *pc, const struct packet_server_join_req *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_JOIN_REQ].packet != NULL, -1,
                        "Handler for PACKET_SERVER_JOIN_REQ not installed");
  return pc->phs.handlers->send[PACKET_SERVER_JOIN_REQ].packet(pc, packet);
}

int dsend_packet_server_join_req(struct connection *pc, const char *username, const char *capability, const char *version_label, int major_version, int minor_version, int patch_version)
{
  struct packet_server_join_req packet, *real_packet = &packet;

  sz_strlcpy(real_packet->username, username);
  sz_strlcpy(real_packet->capability, capability);
  sz_strlcpy(real_packet->version_label, version_label);
  real_packet->major_version = major_version;
  real_packet->minor_version = minor_version;
  real_packet->patch_version = patch_version;
  
  return send_packet_server_join_req(pc, real_packet);
}

static struct packet_server_join_reply *receive_packet_server_join_reply_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_join_reply, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */
#if 1 /* To match endif */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "you_can_join";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->you_can_join)) {
    RECEIVE_PACKET_FIELD_ERROR(you_can_join);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
    RECEIVE_PACKET_FIELD_ERROR(message);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capability";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->capability, sizeof(real_packet->capability))) {
    RECEIVE_PACKET_FIELD_ERROR(capability);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "challenge_file";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->challenge_file, sizeof(real_packet->challenge_file))) {
    RECEIVE_PACKET_FIELD_ERROR(challenge_file);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conn_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->conn_id)) {
    RECEIVE_PACKET_FIELD_ERROR(conn_id);
  }

#endif
  log_packet_detailed("packet_server_join_reply_100: got info about ()");
  post_receive_packet_server_join_reply(pc, real_packet);
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_join_reply_100(struct connection *pc, const struct packet_server_join_reply *packet)
{
  const struct packet_server_join_reply *real_packet = packet;
  SEND_PACKET_START(PACKET_SERVER_JOIN_REPLY);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_server_join_reply_100: sending info about ()");
#if 1 /* To match endif */
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "you_can_join";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->you_can_join);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capability";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->capability);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "challenge_file";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->challenge_file);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conn_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->conn_id);

#endif
  post_send_packet_server_join_reply(pc, real_packet);
  SEND_PACKET_END(PACKET_SERVER_JOIN_REPLY);
}

int send_packet_server_join_reply(struct connection *pc, const struct packet_server_join_reply *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_JOIN_REPLY].packet != NULL, -1,
                        "Handler for PACKET_SERVER_JOIN_REPLY not installed");
  return pc->phs.handlers->send[PACKET_SERVER_JOIN_REPLY].packet(pc, packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_authentication_req_100 hash_const

#define cmp_packet_authentication_req_100 cmp_const

BV_DEFINE(packet_authentication_req_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_authentication_req *receive_packet_authentication_req_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_authentication_req_100_fields fields;
  struct packet_authentication_req *old;
  struct genhash **hash = pc->phs.received + PACKET_AUTHENTICATION_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_authentication_req, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "type";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(type);
    }
    real_packet->type = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
    RECEIVE_PACKET_FIELD_ERROR(message);
  }

#endif
  log_packet_detailed("packet_authentication_req_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_req_100, cmp_packet_authentication_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "type";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'message'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "message";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_authentication_req_100(struct connection *pc, const struct packet_authentication_req *packet)
{
  const struct packet_authentication_req *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_authentication_req_100_fields fields;
  struct packet_authentication_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_AUTHENTICATION_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_AUTHENTICATION_REQ);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_authentication_req_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_req_100, cmp_packet_authentication_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->type != real_packet->type);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "type";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'message' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "type";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->type);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);

#endif
  SEND_PACKET_END(PACKET_AUTHENTICATION_REQ);
}

int send_packet_authentication_req(struct connection *pc, const struct packet_authentication_req *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_AUTHENTICATION_REQ].packet != NULL, -1,
                        "Handler for PACKET_AUTHENTICATION_REQ not installed");
  return pc->phs.handlers->send[PACKET_AUTHENTICATION_REQ].packet(pc, packet);
}

int dsend_packet_authentication_req(struct connection *pc, enum authentication_type type, const char *message)
{
  struct packet_authentication_req packet, *real_packet = &packet;

  real_packet->type = type;
  sz_strlcpy(real_packet->message, message);
  
  return send_packet_authentication_req(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_authentication_reply_100 hash_const

#define cmp_packet_authentication_reply_100 cmp_const

BV_DEFINE(packet_authentication_reply_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_authentication_reply *receive_packet_authentication_reply_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_authentication_reply_100_fields fields;
  struct packet_authentication_reply *old;
  struct genhash **hash = pc->phs.received + PACKET_AUTHENTICATION_REPLY;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_authentication_reply, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "password";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->password, sizeof(real_packet->password))) {
    RECEIVE_PACKET_FIELD_ERROR(password);
  }

#endif
  log_packet_detailed("packet_authentication_reply_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_reply_100, cmp_packet_authentication_reply_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'password'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "password";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->password, sizeof(real_packet->password))) {
      RECEIVE_PACKET_FIELD_ERROR(password);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_authentication_reply_100(struct connection *pc, const struct packet_authentication_reply *packet)
{
  const struct packet_authentication_reply *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_authentication_reply_100_fields fields;
  struct packet_authentication_reply *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_AUTHENTICATION_REPLY;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_AUTHENTICATION_REPLY);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_authentication_reply_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_reply_100, cmp_packet_authentication_reply_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (strcmp(old->password, real_packet->password) != 0);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'password' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "password";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->password);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "password";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->password);

#endif
  SEND_PACKET_END(PACKET_AUTHENTICATION_REPLY);
}

int send_packet_authentication_reply(struct connection *pc, const struct packet_authentication_reply *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_AUTHENTICATION_REPLY].packet != NULL, -1,
                        "Handler for PACKET_AUTHENTICATION_REPLY not installed");
  return pc->phs.handlers->send[PACKET_AUTHENTICATION_REPLY].packet(pc, packet);
}

static struct packet_server_shutdown *receive_packet_server_shutdown_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_shutdown, real_packet);
#if 1 /* To match endif */
  real_packet->__dummy = 0xff;
#endif
  log_packet_detailed("packet_server_shutdown_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_shutdown_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_SERVER_SHUTDOWN);

  log_packet_detailed("packet_server_shutdown_100: sending info about ()");
  SEND_PACKET_END(PACKET_SERVER_SHUTDOWN);
}

int send_packet_server_shutdown(struct connection *pc)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SHUTDOWN].no_packet != NULL, -1,
                        "Handler for PACKET_SERVER_SHUTDOWN not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SHUTDOWN].no_packet(pc);
}

void lsend_packet_server_shutdown(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_server_shutdown(pconn);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_nation_select_req_100 hash_const

#define cmp_packet_nation_select_req_100 cmp_const

BV_DEFINE(packet_nation_select_req_100_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_nation_select_req *receive_packet_nation_select_req_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_nation_select_req_100_fields fields;
  struct packet_nation_select_req *old;
  struct genhash **hash = pc->phs.received + PACKET_NATION_SELECT_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_nation_select_req, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_no";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->player_no)) {
    RECEIVE_PACKET_FIELD_ERROR(player_no);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_no";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(nation_no);
    }
    real_packet->nation_no = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "is_male";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->is_male)) {
    RECEIVE_PACKET_FIELD_ERROR(is_male);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
    RECEIVE_PACKET_FIELD_ERROR(style);
  }

#endif
  log_packet_detailed("packet_nation_select_req_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_select_req_100, cmp_packet_nation_select_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'player_no'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "player_no";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->player_no)) {
      RECEIVE_PACKET_FIELD_ERROR(player_no);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nation_no'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nation_no";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(nation_no);
      }
      real_packet->nation_no = readin;
    }
  }
  real_packet->is_male = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "style";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nation_select_req_100(struct connection *pc, const struct packet_nation_select_req *packet)
{
  const struct packet_nation_select_req *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_nation_select_req_100_fields fields;
  struct packet_nation_select_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NATION_SELECT_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_NATION_SELECT_REQ);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_nation_select_req_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_select_req_100, cmp_packet_nation_select_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->player_no != real_packet->player_no);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->nation_no != real_packet->nation_no);
  if (differ) {
    BV_SET(fields, 1);
  }

  if (packet->is_male) {
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    BV_SET(fields, 4);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'player_no' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_no";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->player_no);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nation_no' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_no";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->nation_no);
  }
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_no";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->player_no);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_no";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->nation_no);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "is_male";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->is_male);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->name);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);

#endif
  SEND_PACKET_END(PACKET_NATION_SELECT_REQ);
}

int send_packet_nation_select_req(struct connection *pc, const struct packet_nation_select_req *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_NATION_SELECT_REQ].packet != NULL, -1,
                        "Handler for PACKET_NATION_SELECT_REQ not installed");
  return pc->phs.handlers->send[PACKET_NATION_SELECT_REQ].packet(pc, packet);
}

int dsend_packet_nation_select_req(struct connection *pc, int player_no, Nation_type_id nation_no, bool is_male, const char *name, int style)
{
  struct packet_nation_select_req packet, *real_packet = &packet;

  real_packet->player_no = player_no;
  real_packet->nation_no = nation_no;
  real_packet->is_male = is_male;
  sz_strlcpy(real_packet->name, name);
  real_packet->style = style;
  
  return send_packet_nation_select_req(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_player_ready_100 hash_const

#define cmp_packet_player_ready_100 cmp_const

BV_DEFINE(packet_player_ready_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_player_ready *receive_packet_player_ready_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_player_ready_100_fields fields;
  struct packet_player_ready *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_READY;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_player_ready, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_no";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->player_no)) {
    RECEIVE_PACKET_FIELD_ERROR(player_no);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "is_ready";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->is_ready)) {
    RECEIVE_PACKET_FIELD_ERROR(is_ready);
  }

#endif
  log_packet_detailed("packet_player_ready_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_ready_100, cmp_packet_player_ready_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'player_no'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "player_no";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->player_no)) {
      RECEIVE_PACKET_FIELD_ERROR(player_no);
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 1);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_ready_100(struct connection *pc, const struct packet_player_ready *packet)
{
  const struct packet_player_ready *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_player_ready_100_fields fields;
  struct packet_player_ready *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_READY;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_PLAYER_READY);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_player_ready_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_ready_100, cmp_packet_player_ready_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->player_no != real_packet->player_no);
  if (differ) {
    BV_SET(fields, 0);
  }

  if (packet->is_ready) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'player_no' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_no";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->player_no);
  }
  /* field 1 is folded into the header */

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_no";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->player_no);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "is_ready";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->is_ready);

#endif
  SEND_PACKET_END(PACKET_PLAYER_READY);
}

int send_packet_player_ready(struct connection *pc, const struct packet_player_ready *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_READY].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_READY not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_READY].packet(pc, packet);
}

int dsend_packet_player_ready(struct connection *pc, int player_no, bool is_ready)
{
  struct packet_player_ready packet, *real_packet = &packet;

  real_packet->player_no = player_no;
  real_packet->is_ready = is_ready;
  
  return send_packet_player_ready(pc, real_packet);
}

static struct packet_endgame_report *receive_packet_endgame_report_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_endgame_report, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */
#if 1 /* To match endif */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "category_num";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->category_num)) {
    RECEIVE_PACKET_FIELD_ERROR(category_num);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "category_name";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->category_num > 32) {
      RECEIVE_PACKET_FIELD_ERROR(category_name, ": truncation array");
    }
    for (i = 0; i < real_packet->category_num; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(string, &din, &field_addr, real_packet->category_name[i], sizeof(real_packet->category_name[i]))) {
        RECEIVE_PACKET_FIELD_ERROR(category_name);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_num";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->player_num)) {
    RECEIVE_PACKET_FIELD_ERROR(player_num);
  }

#endif
  log_packet_detailed("packet_endgame_report_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_endgame_report_100(struct connection *pc, const struct packet_endgame_report *packet)
{
  const struct packet_endgame_report *real_packet = packet;
  SEND_PACKET_START(PACKET_ENDGAME_REPORT);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_endgame_report_100: sending info about ()");
#if 1 /* To match endif */
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "category_num";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->category_num);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "category_name";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->category_num);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->category_num; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(string, &dout, &field_addr, real_packet->category_name[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_num";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->player_num);

#endif
  SEND_PACKET_END(PACKET_ENDGAME_REPORT);
}

int send_packet_endgame_report(struct connection *pc, const struct packet_endgame_report *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_ENDGAME_REPORT].packet != NULL, -1,
                        "Handler for PACKET_ENDGAME_REPORT not installed");
  return pc->phs.handlers->send[PACKET_ENDGAME_REPORT].packet(pc, packet);
}

void lsend_packet_endgame_report(struct conn_list *dest, const struct packet_endgame_report *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_endgame_report(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_endgame_player *receive_packet_endgame_player_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_endgame_player, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */
#if 1 /* To match endif */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "category_num";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->category_num)) {
    RECEIVE_PACKET_FIELD_ERROR(category_num);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->player_id)) {
    RECEIVE_PACKET_FIELD_ERROR(player_id);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "score";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->score)) {
    RECEIVE_PACKET_FIELD_ERROR(score);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "category_score";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->category_num > 32) {
      RECEIVE_PACKET_FIELD_ERROR(category_score, ": truncation array");
    }
    for (i = 0; i < real_packet->category_num; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint32, &din, &field_addr, &real_packet->category_score[i])) {
        RECEIVE_PACKET_FIELD_ERROR(category_score);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "winner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->winner)) {
    RECEIVE_PACKET_FIELD_ERROR(winner);
  }

#endif
  log_packet_detailed("packet_endgame_player_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_endgame_player_100(struct connection *pc, const struct packet_endgame_player *packet)
{
  const struct packet_endgame_player *real_packet = packet;
  SEND_PACKET_START(PACKET_ENDGAME_PLAYER);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_endgame_player_100: sending info about ()");
#if 1 /* To match endif */
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "category_num";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->category_num);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "player_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->player_id);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "score";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->score);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "category_score";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->category_num);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->category_num; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint32, &dout, &field_addr, real_packet->category_score[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "winner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->winner);

#endif
  SEND_PACKET_END(PACKET_ENDGAME_PLAYER);
}

int send_packet_endgame_player(struct connection *pc, const struct packet_endgame_player *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_ENDGAME_PLAYER].packet != NULL, -1,
                        "Handler for PACKET_ENDGAME_PLAYER not installed");
  return pc->phs.handlers->send[PACKET_ENDGAME_PLAYER].packet(pc, packet);
}

void lsend_packet_endgame_player(struct conn_list *dest, const struct packet_endgame_player *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_endgame_player(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
static genhash_val_t hash_packet_tile_info_100(const void *vkey)
{
  const struct packet_tile_info *key = (const struct packet_tile_info *) vkey;

  return key->tile;
}

static bool cmp_packet_tile_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_tile_info *key1 = (const struct packet_tile_info *) vkey1;
  const struct packet_tile_info *key2 = (const struct packet_tile_info *) vkey2;

  return key1->tile == key2->tile;
}
BV_DEFINE(packet_tile_info_100_fields, 12);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_tile_info *receive_packet_tile_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_tile_info_100_fields fields;
  struct packet_tile_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TILE_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_tile_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
    #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }

#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "continent";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(continent);
    }
    real_packet->continent = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "known";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(known);
    }
    real_packet->known = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
    RECEIVE_PACKET_FIELD_ERROR(owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras_owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->extras_owner)) {
    RECEIVE_PACKET_FIELD_ERROR(extras_owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worked32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->worked32)) {
    RECEIVE_PACKET_FIELD_ERROR(worked32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "terrain";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(terrain);
    }
    real_packet->terrain = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "resource";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(resource);
    }
    real_packet->resource = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->extras)) {
    RECEIVE_PACKET_FIELD_ERROR(extras);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "placing";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->placing)) {
    RECEIVE_PACKET_FIELD_ERROR(placing);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "place_turn";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->place_turn)) {
    RECEIVE_PACKET_FIELD_ERROR(place_turn);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "spec_sprite";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->spec_sprite, sizeof(real_packet->spec_sprite))) {
    RECEIVE_PACKET_FIELD_ERROR(spec_sprite);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "label";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->label, sizeof(real_packet->label))) {
    RECEIVE_PACKET_FIELD_ERROR(label);
  }

#endif
  log_packet_detailed("packet_tile_info_100: got info about (%d)",
    real_packet->tile);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_100, cmp_packet_tile_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int tile = real_packet->tile;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->tile = tile;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'continent'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "continent";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(continent);
      }
      real_packet->continent = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'known'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "known";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(known);
      }
      real_packet->known = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'extras_owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "extras_owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->extras_owner)) {
      RECEIVE_PACKET_FIELD_ERROR(extras_owner);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'worked32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "worked32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->worked32)) {
      RECEIVE_PACKET_FIELD_ERROR(worked32);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'terrain'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "terrain";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(terrain);
      }
      real_packet->terrain = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'resource'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "resource";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(resource);
      }
      real_packet->resource = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'extras'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "extras";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->extras)) {
      RECEIVE_PACKET_FIELD_ERROR(extras);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'placing'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "placing";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->placing)) {
      RECEIVE_PACKET_FIELD_ERROR(placing);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'place_turn'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "place_turn";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->place_turn)) {
      RECEIVE_PACKET_FIELD_ERROR(place_turn);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'spec_sprite'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "spec_sprite";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->spec_sprite, sizeof(real_packet->spec_sprite))) {
      RECEIVE_PACKET_FIELD_ERROR(spec_sprite);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'label'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "label";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->label, sizeof(real_packet->label))) {
      RECEIVE_PACKET_FIELD_ERROR(label);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_tile_info_100(struct connection *pc, const struct packet_tile_info *packet)
{
  const struct packet_tile_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_tile_info_100_fields fields;
  struct packet_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TILE_INFO;
  int different = 0;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_TILE_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_tile_info_100: sending info about (%d)",
    real_packet->tile);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_100, cmp_packet_tile_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->continent != real_packet->continent);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->known != real_packet->known);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->extras_owner != real_packet->extras_owner);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->worked32 != real_packet->worked32);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->terrain != real_packet->terrain);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->resource != real_packet->resource);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->extras, real_packet->extras);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->placing != real_packet->placing);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->place_turn != real_packet->place_turn);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->spec_sprite, real_packet->spec_sprite) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (strcmp(old->label, real_packet->label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'continent' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "continent";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->continent);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'known' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "known";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->known);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'extras_owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras_owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->extras_owner);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'worked32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worked32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->worked32);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'terrain' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "terrain";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->terrain);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'resource' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "resource";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->resource);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'extras' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->extras);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'placing' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "placing";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->placing);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'place_turn' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "place_turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->place_turn);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'spec_sprite' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "spec_sprite";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->spec_sprite);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'label' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->label);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "continent";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->continent);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "known";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->known);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras_owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->extras_owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worked32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->worked32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "terrain";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->terrain);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "resource";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->resource);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->extras);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "placing";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->placing);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "place_turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->place_turn);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "spec_sprite";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->spec_sprite);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->label);

#endif
  SEND_PACKET_END(PACKET_TILE_INFO);
}

#ifdef FREECIV_DELTA_PROTOCOL
static genhash_val_t hash_packet_tile_info_101(const void *vkey)
{
  const struct packet_tile_info *key = (const struct packet_tile_info *) vkey;

  return key->tile;
}

static bool cmp_packet_tile_info_101(const void *vkey1, const void *vkey2)
{
  const struct packet_tile_info *key1 = (const struct packet_tile_info *) vkey1;
  const struct packet_tile_info *key2 = (const struct packet_tile_info *) vkey2;

  return key1->tile == key2->tile;
}
BV_DEFINE(packet_tile_info_101_fields, 12);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_tile_info *receive_packet_tile_info_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_tile_info_101_fields fields;
  struct packet_tile_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TILE_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_tile_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
    #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }

#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "continent";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(continent);
    }
    real_packet->continent = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "known";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(known);
    }
    real_packet->known = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
    RECEIVE_PACKET_FIELD_ERROR(owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras_owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->extras_owner)) {
    RECEIVE_PACKET_FIELD_ERROR(extras_owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worked16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->worked16)) {
    RECEIVE_PACKET_FIELD_ERROR(worked16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "terrain";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(terrain);
    }
    real_packet->terrain = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "resource";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(resource);
    }
    real_packet->resource = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->extras)) {
    RECEIVE_PACKET_FIELD_ERROR(extras);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "placing";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->placing)) {
    RECEIVE_PACKET_FIELD_ERROR(placing);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "place_turn";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->place_turn)) {
    RECEIVE_PACKET_FIELD_ERROR(place_turn);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "spec_sprite";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->spec_sprite, sizeof(real_packet->spec_sprite))) {
    RECEIVE_PACKET_FIELD_ERROR(spec_sprite);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "label";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->label, sizeof(real_packet->label))) {
    RECEIVE_PACKET_FIELD_ERROR(label);
  }

#endif
  log_packet_detailed("packet_tile_info_101: got info about (%d)",
    real_packet->tile);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_101, cmp_packet_tile_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int tile = real_packet->tile;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->tile = tile;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'continent'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "continent";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(continent);
      }
      real_packet->continent = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'known'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "known";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(known);
      }
      real_packet->known = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'extras_owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "extras_owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->extras_owner)) {
      RECEIVE_PACKET_FIELD_ERROR(extras_owner);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'worked16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "worked16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->worked16)) {
      RECEIVE_PACKET_FIELD_ERROR(worked16);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'terrain'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "terrain";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(terrain);
      }
      real_packet->terrain = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'resource'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "resource";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(resource);
      }
      real_packet->resource = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'extras'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "extras";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->extras)) {
      RECEIVE_PACKET_FIELD_ERROR(extras);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'placing'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "placing";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->placing)) {
      RECEIVE_PACKET_FIELD_ERROR(placing);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'place_turn'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "place_turn";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->place_turn)) {
      RECEIVE_PACKET_FIELD_ERROR(place_turn);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'spec_sprite'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "spec_sprite";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->spec_sprite, sizeof(real_packet->spec_sprite))) {
      RECEIVE_PACKET_FIELD_ERROR(spec_sprite);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'label'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "label";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->label, sizeof(real_packet->label))) {
      RECEIVE_PACKET_FIELD_ERROR(label);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_tile_info_101(struct connection *pc, const struct packet_tile_info *packet)
{
  const struct packet_tile_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_tile_info_101_fields fields;
  struct packet_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TILE_INFO;
  int different = 0;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_TILE_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_tile_info_101: sending info about (%d)",
    real_packet->tile);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_101, cmp_packet_tile_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->continent != real_packet->continent);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->known != real_packet->known);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->extras_owner != real_packet->extras_owner);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->worked16 != real_packet->worked16);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->terrain != real_packet->terrain);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->resource != real_packet->resource);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->extras, real_packet->extras);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->placing != real_packet->placing);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->place_turn != real_packet->place_turn);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->spec_sprite, real_packet->spec_sprite) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (strcmp(old->label, real_packet->label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'continent' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "continent";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->continent);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'known' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "known";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->known);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'extras_owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras_owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->extras_owner);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'worked16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worked16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->worked16);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'terrain' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "terrain";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->terrain);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'resource' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "resource";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->resource);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'extras' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->extras);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'placing' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "placing";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->placing);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'place_turn' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "place_turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->place_turn);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'spec_sprite' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "spec_sprite";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->spec_sprite);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'label' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->label);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "continent";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->continent);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "known";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->known);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras_owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->extras_owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worked16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->worked16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "terrain";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->terrain);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "resource";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->resource);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "extras";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->extras);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "placing";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->placing);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "place_turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->place_turn);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "spec_sprite";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->spec_sprite);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->label);

#endif
  SEND_PACKET_END(PACKET_TILE_INFO);
}

int send_packet_tile_info(struct connection *pc, const struct packet_tile_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_TILE_INFO].packet != NULL, -1,
                        "Handler for PACKET_TILE_INFO not installed");
  return pc->phs.handlers->send[PACKET_TILE_INFO].packet(pc, packet);
}

void lsend_packet_tile_info(struct conn_list *dest, const struct packet_tile_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_tile_info(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_game_info_100 hash_const

#define cmp_packet_game_info_100 cmp_const

BV_DEFINE(packet_game_info_100_fields, 131);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_game_info *receive_packet_game_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_game_info_100_fields fields;
  struct packet_game_info *old;
  struct genhash **hash = pc->phs.received + PACKET_GAME_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_game_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "add_to_size_limit";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->add_to_size_limit)) {
    RECEIVE_PACKET_FIELD_ERROR(add_to_size_limit);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "aifill";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->aifill)) {
    RECEIVE_PACKET_FIELD_ERROR(aifill);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "persistent_ready";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(persistent_ready);
    }
    real_packet->persistent_ready = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlifting_style";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(airlifting_style);
    }
    real_packet->airlifting_style = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift_from_always_enabled";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->airlift_from_always_enabled)) {
    RECEIVE_PACKET_FIELD_ERROR(airlift_from_always_enabled);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift_to_always_enabled";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->airlift_to_always_enabled)) {
    RECEIVE_PACKET_FIELD_ERROR(airlift_to_always_enabled);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "angrycitizen";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->angrycitizen)) {
    RECEIVE_PACKET_FIELD_ERROR(angrycitizen);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_pollution";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->base_pollution)) {
    RECEIVE_PACKET_FIELD_ERROR(base_pollution);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_tech_cost";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->base_tech_cost)) {
    RECEIVE_PACKET_FIELD_ERROR(base_tech_cost);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_leak_pct";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->tech_leak_pct)) {
    RECEIVE_PACKET_FIELD_ERROR(tech_leak_pct);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_city_radius_sq";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->border_city_radius_sq)) {
    RECEIVE_PACKET_FIELD_ERROR(border_city_radius_sq);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_size_effect";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->border_size_effect)) {
    RECEIVE_PACKET_FIELD_ERROR(border_size_effect);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_city_permanent_radius_sq";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->border_city_permanent_radius_sq)) {
    RECEIVE_PACKET_FIELD_ERROR(border_city_permanent_radius_sq);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "borders";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(borders);
    }
    real_packet->borders = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_bribe_cost";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->base_bribe_cost)) {
    RECEIVE_PACKET_FIELD_ERROR(base_bribe_cost);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_bonus_style";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(caravan_bonus_style);
    }
    real_packet->caravan_bonus_style = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_vic_points";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture_vic_points)) {
    RECEIVE_PACKET_FIELD_ERROR(culture_vic_points);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_vic_lead";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->culture_vic_lead)) {
    RECEIVE_PACKET_FIELD_ERROR(culture_vic_lead);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_migration_pml";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->culture_migration_pml)) {
    RECEIVE_PACKET_FIELD_ERROR(culture_migration_pml);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history_interest_pml";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->history_interest_pml)) {
    RECEIVE_PACKET_FIELD_ERROR(history_interest_pml);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "celebratesize";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->celebratesize)) {
    RECEIVE_PACKET_FIELD_ERROR(celebratesize);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changable_tax";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->changable_tax)) {
    RECEIVE_PACKET_FIELD_ERROR(changable_tax);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pop_report_zeroes";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->pop_report_zeroes)) {
    RECEIVE_PACKET_FIELD_ERROR(pop_report_zeroes);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_nationality";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->citizen_nationality)) {
    RECEIVE_PACKET_FIELD_ERROR(citizen_nationality);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_convert_speed";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->citizen_convert_speed)) {
    RECEIVE_PACKET_FIELD_ERROR(citizen_convert_speed);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conquest_convert_pct";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->conquest_convert_pct)) {
    RECEIVE_PACKET_FIELD_ERROR(conquest_convert_pct);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_partisans_pct";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->citizen_partisans_pct)) {
    RECEIVE_PACKET_FIELD_ERROR(citizen_partisans_pct);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citymindist";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->citymindist)) {
    RECEIVE_PACKET_FIELD_ERROR(citymindist);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "cooling";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->cooling)) {
    RECEIVE_PACKET_FIELD_ERROR(cooling);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "coolinglevel";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->coolinglevel)) {
    RECEIVE_PACKET_FIELD_ERROR(coolinglevel);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplchance_initial_odds";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->diplchance_initial_odds)) {
    RECEIVE_PACKET_FIELD_ERROR(diplchance_initial_odds);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomacy";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(diplomacy);
    }
    real_packet->diplomacy = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fogofwar";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->fogofwar)) {
    RECEIVE_PACKET_FIELD_ERROR(fogofwar);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_cost";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->food_cost)) {
    RECEIVE_PACKET_FIELD_ERROR(food_cost);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "foodbox";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->foodbox)) {
    RECEIVE_PACKET_FIELD_ERROR(foodbox);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_gold";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->forced_gold)) {
    RECEIVE_PACKET_FIELD_ERROR(forced_gold);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_luxury";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->forced_luxury)) {
    RECEIVE_PACKET_FIELD_ERROR(forced_luxury);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_science";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->forced_science)) {
    RECEIVE_PACKET_FIELD_ERROR(forced_science);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fulltradesize";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->fulltradesize)) {
    RECEIVE_PACKET_FIELD_ERROR(fulltradesize);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_world_rel_pct";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_world_rel_pct)) {
    RECEIVE_PACKET_FIELD_ERROR(trade_world_rel_pct);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "min_trade_route_val";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->min_trade_route_val)) {
    RECEIVE_PACKET_FIELD_ERROR(min_trade_route_val);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods_selection";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(goods_selection);
    }
    real_packet->goods_selection = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "global_advance_count";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->global_advance_count)) {
    RECEIVE_PACKET_FIELD_ERROR(global_advance_count);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "global_advances";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
    for (i = 0; i < A_LAST; i++) {
      if (!DIO_GET(bool8, &din, &field_addr, &real_packet->global_advances[i])) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances);
      }
    }
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "global_warming";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->global_warming)) {
    RECEIVE_PACKET_FIELD_ERROR(global_warming);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "globalwarming";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->globalwarming)) {
    RECEIVE_PACKET_FIELD_ERROR(globalwarming);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gold";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->gold)) {
    RECEIVE_PACKET_FIELD_ERROR(gold);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gold_upkeep_style";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(gold_upkeep_style);
    }
    real_packet->gold_upkeep_style = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "infrapoints";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->infrapoints)) {
    RECEIVE_PACKET_FIELD_ERROR(infrapoints);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "revolentype";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(revolentype);
    }
    real_packet->revolentype = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "default_government_id";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(sint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(default_government_id);
    }
    real_packet->default_government_id = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "government_during_revolution_id";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(sint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(government_during_revolution_id);
    }
    real_packet->government_during_revolution_id = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_food_inc";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->granary_food_inc)) {
    RECEIVE_PACKET_FIELD_ERROR(granary_food_inc);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_food_ini";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < MAX_GRANARY_INIS; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->granary_food_ini[i])) {
        RECEIVE_PACKET_FIELD_ERROR(granary_food_ini);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_num_inis";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->granary_num_inis)) {
    RECEIVE_PACKET_FIELD_ERROR(granary_num_inis);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "great_wonder_owners";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
    for (i = 0; i < B_LAST; i++) {
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->great_wonder_owners[i])) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
      }
    }
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happy_cost";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->happy_cost)) {
    RECEIVE_PACKET_FIELD_ERROR(happy_cost);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happyborders";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(happyborders);
    }
    real_packet->happyborders = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "heating";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->heating)) {
    RECEIVE_PACKET_FIELD_ERROR(heating);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_base_factor";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_base_factor)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_base_factor);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_min_size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->illness_min_size)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_min_size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_on";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->illness_on)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_on);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_pollution_factor";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_pollution_factor)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_pollution_factor);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade_infection";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade_infection)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_trade_infection);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "init_city_radius_sq";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->init_city_radius_sq)) {
    RECEIVE_PACKET_FIELD_ERROR(init_city_radius_sq);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "is_edit_mode";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->is_edit_mode)) {
    RECEIVE_PACKET_FIELD_ERROR(is_edit_mode);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "is_new_game";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->is_new_game)) {
    RECEIVE_PACKET_FIELD_ERROR(is_new_game);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "killcitizen";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->killcitizen)) {
    RECEIVE_PACKET_FIELD_ERROR(killcitizen);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "killstack";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->killstack)) {
    RECEIVE_PACKET_FIELD_ERROR(killstack);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "only_killing_makes_veteran";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->only_killing_makes_veteran)) {
    RECEIVE_PACKET_FIELD_ERROR(only_killing_makes_veteran);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "only_real_fight_makes_veteran";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->only_real_fight_makes_veteran)) {
    RECEIVE_PACKET_FIELD_ERROR(only_real_fight_makes_veteran);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "combat_odds_scaled_veterancy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->combat_odds_scaled_veterancy)) {
    RECEIVE_PACKET_FIELD_ERROR(combat_odds_scaled_veterancy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "damage_reduces_bombard_rate";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->damage_reduces_bombard_rate)) {
    RECEIVE_PACKET_FIELD_ERROR(damage_reduces_bombard_rate);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_badwallattacker";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->low_firepower_badwallattacker)) {
    RECEIVE_PACKET_FIELD_ERROR(low_firepower_badwallattacker);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_pearl_harbour";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->low_firepower_pearl_harbour)) {
    RECEIVE_PACKET_FIELD_ERROR(low_firepower_pearl_harbour);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_combat_bonus";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->low_firepower_combat_bonus)) {
    RECEIVE_PACKET_FIELD_ERROR(low_firepower_combat_bonus);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_nonnat_bombard";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->low_firepower_nonnat_bombard)) {
    RECEIVE_PACKET_FIELD_ERROR(low_firepower_nonnat_bombard);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuke_pop_loss_pct";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nuke_pop_loss_pct)) {
    RECEIVE_PACKET_FIELD_ERROR(nuke_pop_loss_pct);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuke_defender_survival_chance_pct";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nuke_defender_survival_chance_pct)) {
    RECEIVE_PACKET_FIELD_ERROR(nuke_defender_survival_chance_pct);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "min_city_center_output";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->min_city_center_output[i])) {
        RECEIVE_PACKET_FIELD_ERROR(min_city_center_output);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "muuk_food_wipe";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->muuk_food_wipe)) {
    RECEIVE_PACKET_FIELD_ERROR(muuk_food_wipe);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "muuk_gold_wipe";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->muuk_gold_wipe)) {
    RECEIVE_PACKET_FIELD_ERROR(muuk_gold_wipe);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "muuk_shield_wipe";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->muuk_shield_wipe)) {
    RECEIVE_PACKET_FIELD_ERROR(muuk_shield_wipe);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "notradesize";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->notradesize)) {
    RECEIVE_PACKET_FIELD_ERROR(notradesize);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuclear_winter";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->nuclear_winter)) {
    RECEIVE_PACKET_FIELD_ERROR(nuclear_winter);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuclearwinter";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->nuclearwinter)) {
    RECEIVE_PACKET_FIELD_ERROR(nuclearwinter);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->phase)) {
    RECEIVE_PACKET_FIELD_ERROR(phase);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase_mode";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(phase_mode);
    }
    real_packet->phase_mode = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pillage_select";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->pillage_select)) {
    RECEIVE_PACKET_FIELD_ERROR(pillage_select);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal_maps_reveals_all_cities";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->steal_maps_reveals_all_cities)) {
    RECEIVE_PACKET_FIELD_ERROR(steal_maps_reveals_all_cities);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "poison_empties_food_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->poison_empties_food_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(poison_empties_food_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_steal_allow_holes";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->tech_steal_allow_holes)) {
    RECEIVE_PACKET_FIELD_ERROR(tech_steal_allow_holes);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_trade_allow_holes";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->tech_trade_allow_holes)) {
    RECEIVE_PACKET_FIELD_ERROR(tech_trade_allow_holes);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_trade_loss_allow_holes";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->tech_trade_loss_allow_holes)) {
    RECEIVE_PACKET_FIELD_ERROR(tech_trade_loss_allow_holes);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_parasite_allow_holes";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->tech_parasite_allow_holes)) {
    RECEIVE_PACKET_FIELD_ERROR(tech_parasite_allow_holes);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_loss_allow_holes";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->tech_loss_allow_holes)) {
    RECEIVE_PACKET_FIELD_ERROR(tech_loss_allow_holes);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "rapturedelay";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->rapturedelay)) {
    RECEIVE_PACKET_FIELD_ERROR(rapturedelay);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disasters";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disasters)) {
    RECEIVE_PACKET_FIELD_ERROR(disasters);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "restrictinfra";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->restrictinfra)) {
    RECEIVE_PACKET_FIELD_ERROR(restrictinfra);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unreachable_protects";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->unreachable_protects)) {
    RECEIVE_PACKET_FIELD_ERROR(unreachable_protects);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "sciencebox";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->sciencebox)) {
    RECEIVE_PACKET_FIELD_ERROR(sciencebox);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shieldbox";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->shieldbox)) {
    RECEIVE_PACKET_FIELD_ERROR(shieldbox);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "skill_level";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(skill_level);
    }
    real_packet->skill_level = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "victory_conditions";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(victory_conditions);
    }
    real_packet->victory_conditions = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_pooled_research";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->team_pooled_research)) {
    RECEIVE_PACKET_FIELD_ERROR(team_pooled_research);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->tech)) {
    RECEIVE_PACKET_FIELD_ERROR(tech);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_cost_style";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_cost_style);
    }
    real_packet->tech_cost_style = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_leakage";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_leakage);
    }
    real_packet->tech_leakage = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_upkeep_divider";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->tech_upkeep_divider)) {
    RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_divider);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_upkeep_style";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_style);
    }
    real_packet->tech_upkeep_style = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "techloss_forgiveness";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->techloss_forgiveness)) {
    RECEIVE_PACKET_FIELD_ERROR(techloss_forgiveness);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "free_tech_method";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(free_tech_method);
    }
    real_packet->free_tech_method = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gameloss_style";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(gameloss_style);
    }
    real_packet->gameloss_style = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "timeout";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->timeout)) {
    RECEIVE_PACKET_FIELD_ERROR(timeout);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "first_timeout";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->first_timeout)) {
    RECEIVE_PACKET_FIELD_ERROR(first_timeout);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tired_attack";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->tired_attack)) {
    RECEIVE_PACKET_FIELD_ERROR(tired_attack);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trademindist";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->trademindist)) {
    RECEIVE_PACKET_FIELD_ERROR(trademindist);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_revenue_style";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(trade_revenue_style);
    }
    real_packet->trade_revenue_style = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trading_city";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->trading_city)) {
    RECEIVE_PACKET_FIELD_ERROR(trading_city);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trading_gold";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->trading_gold)) {
    RECEIVE_PACKET_FIELD_ERROR(trading_gold);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trading_tech";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->trading_tech)) {
    RECEIVE_PACKET_FIELD_ERROR(trading_tech);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn)) {
    RECEIVE_PACKET_FIELD_ERROR(turn);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "warminglevel";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->warminglevel)) {
    RECEIVE_PACKET_FIELD_ERROR(warminglevel);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "year";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->year)) {
    RECEIVE_PACKET_FIELD_ERROR(year);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "year_0_hack";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->year_0_hack)) {
    RECEIVE_PACKET_FIELD_ERROR(year_0_hack);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fragment_count";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->fragment_count)) {
    RECEIVE_PACKET_FIELD_ERROR(fragment_count);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "civil_war_enabled";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->civil_war_enabled)) {
    RECEIVE_PACKET_FIELD_ERROR(civil_war_enabled);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "civil_war_bonus_celebrating";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->civil_war_bonus_celebrating)) {
    RECEIVE_PACKET_FIELD_ERROR(civil_war_bonus_celebrating);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "civil_war_bonus_unhappy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->civil_war_bonus_unhappy)) {
    RECEIVE_PACKET_FIELD_ERROR(civil_war_bonus_unhappy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granularity";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->granularity)) {
    RECEIVE_PACKET_FIELD_ERROR(granularity);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "small_wonder_visibility";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(small_wonder_visibility);
    }
    real_packet->small_wonder_visibility = readin;
  }

#endif
  log_packet_detailed("packet_game_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_100, cmp_packet_game_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'add_to_size_limit'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "add_to_size_limit";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->add_to_size_limit)) {
      RECEIVE_PACKET_FIELD_ERROR(add_to_size_limit);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'aifill'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "aifill";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->aifill)) {
      RECEIVE_PACKET_FIELD_ERROR(aifill);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'persistent_ready'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "persistent_ready";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(persistent_ready);
      }
      real_packet->persistent_ready = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'airlifting_style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "airlifting_style";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(airlifting_style);
      }
      real_packet->airlifting_style = readin;
    }
  }
  real_packet->airlift_from_always_enabled = BV_ISSET(fields, 4);
  real_packet->airlift_to_always_enabled = BV_ISSET(fields, 5);
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'angrycitizen'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "angrycitizen";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->angrycitizen)) {
      RECEIVE_PACKET_FIELD_ERROR(angrycitizen);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'base_pollution'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "base_pollution";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->base_pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(base_pollution);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'base_tech_cost'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "base_tech_cost";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->base_tech_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(base_tech_cost);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'tech_leak_pct'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tech_leak_pct";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->tech_leak_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_leak_pct);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'border_city_radius_sq'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "border_city_radius_sq";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->border_city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'border_size_effect'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "border_size_effect";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->border_size_effect)) {
      RECEIVE_PACKET_FIELD_ERROR(border_size_effect);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'border_city_permanent_radius_sq'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "border_city_permanent_radius_sq";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->border_city_permanent_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_city_permanent_radius_sq);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'borders'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "borders";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(borders);
      }
      real_packet->borders = readin;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'base_bribe_cost'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "base_bribe_cost";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->base_bribe_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(base_bribe_cost);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'caravan_bonus_style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "caravan_bonus_style";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(caravan_bonus_style);
      }
      real_packet->caravan_bonus_style = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'culture_vic_points'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "culture_vic_points";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture_vic_points)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_vic_points);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'culture_vic_lead'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "culture_vic_lead";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->culture_vic_lead)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_vic_lead);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'culture_migration_pml'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "culture_migration_pml";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->culture_migration_pml)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_migration_pml);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'history_interest_pml'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "history_interest_pml";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->history_interest_pml)) {
      RECEIVE_PACKET_FIELD_ERROR(history_interest_pml);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'celebratesize'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "celebratesize";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->celebratesize)) {
      RECEIVE_PACKET_FIELD_ERROR(celebratesize);
    }
  }
  real_packet->changable_tax = BV_ISSET(fields, 21);
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'pop_report_zeroes'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "pop_report_zeroes";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->pop_report_zeroes)) {
      RECEIVE_PACKET_FIELD_ERROR(pop_report_zeroes);
    }
  }
  real_packet->citizen_nationality = BV_ISSET(fields, 23);
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'citizen_convert_speed'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "citizen_convert_speed";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->citizen_convert_speed)) {
      RECEIVE_PACKET_FIELD_ERROR(citizen_convert_speed);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'conquest_convert_pct'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "conquest_convert_pct";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->conquest_convert_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(conquest_convert_pct);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'citizen_partisans_pct'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "citizen_partisans_pct";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->citizen_partisans_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(citizen_partisans_pct);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'citymindist'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "citymindist";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->citymindist)) {
      RECEIVE_PACKET_FIELD_ERROR(citymindist);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'cooling'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "cooling";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->cooling)) {
      RECEIVE_PACKET_FIELD_ERROR(cooling);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'coolinglevel'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "coolinglevel";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->coolinglevel)) {
      RECEIVE_PACKET_FIELD_ERROR(coolinglevel);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'diplchance_initial_odds'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "diplchance_initial_odds";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->diplchance_initial_odds)) {
      RECEIVE_PACKET_FIELD_ERROR(diplchance_initial_odds);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'diplomacy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "diplomacy";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(diplomacy);
      }
      real_packet->diplomacy = readin;
    }
  }
  real_packet->fogofwar = BV_ISSET(fields, 32);
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'food_cost'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "food_cost";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->food_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(food_cost);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'foodbox'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "foodbox";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->foodbox)) {
      RECEIVE_PACKET_FIELD_ERROR(foodbox);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'forced_gold'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "forced_gold";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->forced_gold)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_gold);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'forced_luxury'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "forced_luxury";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->forced_luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_luxury);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'forced_science'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "forced_science";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->forced_science)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_science);
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'fulltradesize'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "fulltradesize";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->fulltradesize)) {
      RECEIVE_PACKET_FIELD_ERROR(fulltradesize);
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'trade_world_rel_pct'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "trade_world_rel_pct";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_world_rel_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(trade_world_rel_pct);
    }
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'min_trade_route_val'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "min_trade_route_val";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->min_trade_route_val)) {
      RECEIVE_PACKET_FIELD_ERROR(min_trade_route_val);
    }
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'goods_selection'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "goods_selection";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(goods_selection);
      }
      real_packet->goods_selection = readin;
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'global_advance_count'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "global_advance_count";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->global_advance_count)) {
      RECEIVE_PACKET_FIELD_ERROR(global_advance_count);
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'global_advances'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "global_advances";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
    #ifdef FREECIV_JSON_CONNECTION
    int count;
    
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
    
    for (count = 0;; count++) {
      int i;
    
      field_addr.sub_location->number = count;
    
      /* Enter diff array element (start at the index address). */
      field_addr.sub_location->sub_location = plocation_elem_new(0);
    #else /* FREECIV_JSON_CONNECTION */
    while (TRUE) {
      int i;
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (!DIO_GET(uint8, &din, &field_addr, &i)) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances);
      }
      if (i == 255) {
    #ifdef FREECIV_JSON_CONNECTION
        /* Exit diff array element. */
        free(field_addr.sub_location->sub_location);
        field_addr.sub_location->sub_location = NULL;
    
        /* Exit diff array. */
        free(field_addr.sub_location);
        field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    
        break;
      }
      if (i > A_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances,
                                   ": unexpected value %d "
                                   "(> A_LAST) in array diff",
                                   i);
      } else {
    #ifdef FREECIV_JSON_CONNECTION
        /* Content address. */
        field_addr.sub_location->sub_location->number = 1;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(bool8, &din, &field_addr, &real_packet->global_advances[i])) {
          RECEIVE_PACKET_FIELD_ERROR(global_advances);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit diff array element. */
      free(field_addr.sub_location->sub_location);
      field_addr.sub_location->sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
    
    #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  real_packet->global_warming = BV_ISSET(fields, 44);
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'globalwarming'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "globalwarming";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->globalwarming)) {
      RECEIVE_PACKET_FIELD_ERROR(globalwarming);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'gold'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "gold";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->gold)) {
      RECEIVE_PACKET_FIELD_ERROR(gold);
    }
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  got field 'gold_upkeep_style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "gold_upkeep_style";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gold_upkeep_style);
      }
      real_packet->gold_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'infrapoints'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "infrapoints";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->infrapoints)) {
      RECEIVE_PACKET_FIELD_ERROR(infrapoints);
    }
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  got field 'revolentype'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "revolentype";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(revolentype);
      }
      real_packet->revolentype = readin;
    }
  }
  if (BV_ISSET(fields, 50)) {
    log_packet_detailed("  got field 'default_government_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "default_government_id";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(sint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(default_government_id);
      }
      real_packet->default_government_id = readin;
    }
  }
  if (BV_ISSET(fields, 51)) {
    log_packet_detailed("  got field 'government_during_revolution_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "government_during_revolution_id";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(sint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(government_during_revolution_id);
      }
      real_packet->government_during_revolution_id = readin;
    }
  }
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  got field 'granary_food_inc'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "granary_food_inc";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->granary_food_inc)) {
      RECEIVE_PACKET_FIELD_ERROR(granary_food_inc);
    }
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  got field 'granary_food_ini'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "granary_food_ini";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < MAX_GRANARY_INIS; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->granary_food_ini[i])) {
          RECEIVE_PACKET_FIELD_ERROR(granary_food_ini);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 54)) {
    log_packet_detailed("  got field 'granary_num_inis'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "granary_num_inis";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->granary_num_inis)) {
      RECEIVE_PACKET_FIELD_ERROR(granary_num_inis);
    }
  }
  if (BV_ISSET(fields, 55)) {
    log_packet_detailed("  got field 'great_wonder_owners'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "great_wonder_owners";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
    #ifdef FREECIV_JSON_CONNECTION
    int count;
    
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
    
    for (count = 0;; count++) {
      int i;
    
      field_addr.sub_location->number = count;
    
      /* Enter diff array element (start at the index address). */
      field_addr.sub_location->sub_location = plocation_elem_new(0);
    #else /* FREECIV_JSON_CONNECTION */
    while (TRUE) {
      int i;
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (!DIO_GET(uint8, &din, &field_addr, &i)) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
      }
      if (i == 255) {
    #ifdef FREECIV_JSON_CONNECTION
        /* Exit diff array element. */
        free(field_addr.sub_location->sub_location);
        field_addr.sub_location->sub_location = NULL;
    
        /* Exit diff array. */
        free(field_addr.sub_location);
        field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    
        break;
      }
      if (i > B_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners,
                                   ": unexpected value %d "
                                   "(> B_LAST) in array diff",
                                   i);
      } else {
    #ifdef FREECIV_JSON_CONNECTION
        /* Content address. */
        field_addr.sub_location->sub_location->number = 1;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->great_wonder_owners[i])) {
          RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit diff array element. */
      free(field_addr.sub_location->sub_location);
      field_addr.sub_location->sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
    
    #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 56)) {
    log_packet_detailed("  got field 'happy_cost'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "happy_cost";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->happy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(happy_cost);
    }
  }
  if (BV_ISSET(fields, 57)) {
    log_packet_detailed("  got field 'happyborders'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "happyborders";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(happyborders);
      }
      real_packet->happyborders = readin;
    }
  }
  if (BV_ISSET(fields, 58)) {
    log_packet_detailed("  got field 'heating'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "heating";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->heating)) {
      RECEIVE_PACKET_FIELD_ERROR(heating);
    }
  }
  if (BV_ISSET(fields, 59)) {
    log_packet_detailed("  got field 'illness_base_factor'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "illness_base_factor";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_base_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_base_factor);
    }
  }
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  got field 'illness_min_size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "illness_min_size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->illness_min_size)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_min_size);
    }
  }
  real_packet->illness_on = BV_ISSET(fields, 61);
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  got field 'illness_pollution_factor'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "illness_pollution_factor";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_pollution_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_pollution_factor);
    }
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  got field 'illness_trade_infection'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "illness_trade_infection";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade_infection)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade_infection);
    }
  }
  if (BV_ISSET(fields, 64)) {
    log_packet_detailed("  got field 'init_city_radius_sq'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "init_city_radius_sq";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->init_city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(init_city_radius_sq);
    }
  }
  real_packet->is_edit_mode = BV_ISSET(fields, 65);
  real_packet->is_new_game = BV_ISSET(fields, 66);
  real_packet->killcitizen = BV_ISSET(fields, 67);
  real_packet->killstack = BV_ISSET(fields, 68);
  real_packet->only_killing_makes_veteran = BV_ISSET(fields, 69);
  real_packet->only_real_fight_makes_veteran = BV_ISSET(fields, 70);
  real_packet->combat_odds_scaled_veterancy = BV_ISSET(fields, 71);
  real_packet->damage_reduces_bombard_rate = BV_ISSET(fields, 72);
  if (BV_ISSET(fields, 73)) {
    log_packet_detailed("  got field 'low_firepower_badwallattacker'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "low_firepower_badwallattacker";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->low_firepower_badwallattacker)) {
      RECEIVE_PACKET_FIELD_ERROR(low_firepower_badwallattacker);
    }
  }
  if (BV_ISSET(fields, 74)) {
    log_packet_detailed("  got field 'low_firepower_pearl_harbour'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "low_firepower_pearl_harbour";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->low_firepower_pearl_harbour)) {
      RECEIVE_PACKET_FIELD_ERROR(low_firepower_pearl_harbour);
    }
  }
  if (BV_ISSET(fields, 75)) {
    log_packet_detailed("  got field 'low_firepower_combat_bonus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "low_firepower_combat_bonus";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->low_firepower_combat_bonus)) {
      RECEIVE_PACKET_FIELD_ERROR(low_firepower_combat_bonus);
    }
  }
  if (BV_ISSET(fields, 76)) {
    log_packet_detailed("  got field 'low_firepower_nonnat_bombard'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "low_firepower_nonnat_bombard";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->low_firepower_nonnat_bombard)) {
      RECEIVE_PACKET_FIELD_ERROR(low_firepower_nonnat_bombard);
    }
  }
  if (BV_ISSET(fields, 77)) {
    log_packet_detailed("  got field 'nuke_pop_loss_pct'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nuke_pop_loss_pct";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nuke_pop_loss_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(nuke_pop_loss_pct);
    }
  }
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  got field 'nuke_defender_survival_chance_pct'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nuke_defender_survival_chance_pct";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nuke_defender_survival_chance_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(nuke_defender_survival_chance_pct);
    }
  }
  if (BV_ISSET(fields, 79)) {
    log_packet_detailed("  got field 'min_city_center_output'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "min_city_center_output";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->min_city_center_output[i])) {
          RECEIVE_PACKET_FIELD_ERROR(min_city_center_output);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  real_packet->muuk_food_wipe = BV_ISSET(fields, 80);
  real_packet->muuk_gold_wipe = BV_ISSET(fields, 81);
  real_packet->muuk_shield_wipe = BV_ISSET(fields, 82);
  if (BV_ISSET(fields, 83)) {
    log_packet_detailed("  got field 'notradesize'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "notradesize";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->notradesize)) {
      RECEIVE_PACKET_FIELD_ERROR(notradesize);
    }
  }
  real_packet->nuclear_winter = BV_ISSET(fields, 84);
  if (BV_ISSET(fields, 85)) {
    log_packet_detailed("  got field 'nuclearwinter'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nuclearwinter";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->nuclearwinter)) {
      RECEIVE_PACKET_FIELD_ERROR(nuclearwinter);
    }
  }
  if (BV_ISSET(fields, 86)) {
    log_packet_detailed("  got field 'phase'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "phase";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }
  if (BV_ISSET(fields, 87)) {
    log_packet_detailed("  got field 'phase_mode'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "phase_mode";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(phase_mode);
      }
      real_packet->phase_mode = readin;
    }
  }
  real_packet->pillage_select = BV_ISSET(fields, 88);
  real_packet->steal_maps_reveals_all_cities = BV_ISSET(fields, 89);
  real_packet->poison_empties_food_stock = BV_ISSET(fields, 90);
  real_packet->tech_steal_allow_holes = BV_ISSET(fields, 91);
  real_packet->tech_trade_allow_holes = BV_ISSET(fields, 92);
  real_packet->tech_trade_loss_allow_holes = BV_ISSET(fields, 93);
  real_packet->tech_parasite_allow_holes = BV_ISSET(fields, 94);
  real_packet->tech_loss_allow_holes = BV_ISSET(fields, 95);
  if (BV_ISSET(fields, 96)) {
    log_packet_detailed("  got field 'rapturedelay'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "rapturedelay";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->rapturedelay)) {
      RECEIVE_PACKET_FIELD_ERROR(rapturedelay);
    }
  }
  if (BV_ISSET(fields, 97)) {
    log_packet_detailed("  got field 'disasters'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "disasters";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disasters)) {
      RECEIVE_PACKET_FIELD_ERROR(disasters);
    }
  }
  real_packet->restrictinfra = BV_ISSET(fields, 98);
  real_packet->unreachable_protects = BV_ISSET(fields, 99);
  if (BV_ISSET(fields, 100)) {
    log_packet_detailed("  got field 'sciencebox'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "sciencebox";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->sciencebox)) {
      RECEIVE_PACKET_FIELD_ERROR(sciencebox);
    }
  }
  if (BV_ISSET(fields, 101)) {
    log_packet_detailed("  got field 'shieldbox'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "shieldbox";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->shieldbox)) {
      RECEIVE_PACKET_FIELD_ERROR(shieldbox);
    }
  }
  if (BV_ISSET(fields, 102)) {
    log_packet_detailed("  got field 'skill_level'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "skill_level";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(skill_level);
      }
      real_packet->skill_level = readin;
    }
  }
  if (BV_ISSET(fields, 103)) {
    log_packet_detailed("  got field 'victory_conditions'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "victory_conditions";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(victory_conditions);
      }
      real_packet->victory_conditions = readin;
    }
  }
  real_packet->team_pooled_research = BV_ISSET(fields, 104);
  if (BV_ISSET(fields, 105)) {
    log_packet_detailed("  got field 'tech'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tech";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }
  if (BV_ISSET(fields, 106)) {
    log_packet_detailed("  got field 'tech_cost_style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tech_cost_style";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_cost_style);
      }
      real_packet->tech_cost_style = readin;
    }
  }
  if (BV_ISSET(fields, 107)) {
    log_packet_detailed("  got field 'tech_leakage'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tech_leakage";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_leakage);
      }
      real_packet->tech_leakage = readin;
    }
  }
  if (BV_ISSET(fields, 108)) {
    log_packet_detailed("  got field 'tech_upkeep_divider'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tech_upkeep_divider";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->tech_upkeep_divider)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_divider);
    }
  }
  if (BV_ISSET(fields, 109)) {
    log_packet_detailed("  got field 'tech_upkeep_style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tech_upkeep_style";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_style);
      }
      real_packet->tech_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 110)) {
    log_packet_detailed("  got field 'techloss_forgiveness'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "techloss_forgiveness";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->techloss_forgiveness)) {
      RECEIVE_PACKET_FIELD_ERROR(techloss_forgiveness);
    }
  }
  if (BV_ISSET(fields, 111)) {
    log_packet_detailed("  got field 'free_tech_method'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "free_tech_method";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(free_tech_method);
      }
      real_packet->free_tech_method = readin;
    }
  }
  if (BV_ISSET(fields, 112)) {
    log_packet_detailed("  got field 'gameloss_style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "gameloss_style";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gameloss_style);
      }
      real_packet->gameloss_style = readin;
    }
  }
  if (BV_ISSET(fields, 113)) {
    log_packet_detailed("  got field 'timeout'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "timeout";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->timeout)) {
      RECEIVE_PACKET_FIELD_ERROR(timeout);
    }
  }
  if (BV_ISSET(fields, 114)) {
    log_packet_detailed("  got field 'first_timeout'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "first_timeout";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->first_timeout)) {
      RECEIVE_PACKET_FIELD_ERROR(first_timeout);
    }
  }
  real_packet->tired_attack = BV_ISSET(fields, 115);
  if (BV_ISSET(fields, 116)) {
    log_packet_detailed("  got field 'trademindist'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "trademindist";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->trademindist)) {
      RECEIVE_PACKET_FIELD_ERROR(trademindist);
    }
  }
  if (BV_ISSET(fields, 117)) {
    log_packet_detailed("  got field 'trade_revenue_style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "trade_revenue_style";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(trade_revenue_style);
      }
      real_packet->trade_revenue_style = readin;
    }
  }
  real_packet->trading_city = BV_ISSET(fields, 118);
  real_packet->trading_gold = BV_ISSET(fields, 119);
  real_packet->trading_tech = BV_ISSET(fields, 120);
  if (BV_ISSET(fields, 121)) {
    log_packet_detailed("  got field 'turn'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }
  if (BV_ISSET(fields, 122)) {
    log_packet_detailed("  got field 'warminglevel'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "warminglevel";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->warminglevel)) {
      RECEIVE_PACKET_FIELD_ERROR(warminglevel);
    }
  }
  if (BV_ISSET(fields, 123)) {
    log_packet_detailed("  got field 'year'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "year";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->year)) {
      RECEIVE_PACKET_FIELD_ERROR(year);
    }
  }
  real_packet->year_0_hack = BV_ISSET(fields, 124);
  if (BV_ISSET(fields, 125)) {
    log_packet_detailed("  got field 'fragment_count'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "fragment_count";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->fragment_count)) {
      RECEIVE_PACKET_FIELD_ERROR(fragment_count);
    }
  }
  real_packet->civil_war_enabled = BV_ISSET(fields, 126);
  if (BV_ISSET(fields, 127)) {
    log_packet_detailed("  got field 'civil_war_bonus_celebrating'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "civil_war_bonus_celebrating";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->civil_war_bonus_celebrating)) {
      RECEIVE_PACKET_FIELD_ERROR(civil_war_bonus_celebrating);
    }
  }
  if (BV_ISSET(fields, 128)) {
    log_packet_detailed("  got field 'civil_war_bonus_unhappy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "civil_war_bonus_unhappy";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->civil_war_bonus_unhappy)) {
      RECEIVE_PACKET_FIELD_ERROR(civil_war_bonus_unhappy);
    }
  }
  if (BV_ISSET(fields, 129)) {
    log_packet_detailed("  got field 'granularity'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "granularity";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->granularity)) {
      RECEIVE_PACKET_FIELD_ERROR(granularity);
    }
  }
  if (BV_ISSET(fields, 130)) {
    log_packet_detailed("  got field 'small_wonder_visibility'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "small_wonder_visibility";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(small_wonder_visibility);
      }
      real_packet->small_wonder_visibility = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_game_info_100(struct connection *pc, const struct packet_game_info *packet)
{
  const struct packet_game_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_game_info_100_fields fields;
  struct packet_game_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_GAME_INFO;
  int different = 0;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_GAME_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_game_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_100, cmp_packet_game_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->add_to_size_limit != real_packet->add_to_size_limit);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->aifill != real_packet->aifill);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->persistent_ready != real_packet->persistent_ready);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->airlifting_style != real_packet->airlifting_style);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->airlift_from_always_enabled != real_packet->airlift_from_always_enabled);
  if (differ) {
    different++;
  }
  if (packet->airlift_from_always_enabled) {
    BV_SET(fields, 4);
  }

  differ = (old->airlift_to_always_enabled != real_packet->airlift_to_always_enabled);
  if (differ) {
    different++;
  }
  if (packet->airlift_to_always_enabled) {
    BV_SET(fields, 5);
  }

  differ = (old->angrycitizen != real_packet->angrycitizen);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->base_pollution != real_packet->base_pollution);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->base_tech_cost != real_packet->base_tech_cost);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->tech_leak_pct != real_packet->tech_leak_pct);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->border_city_radius_sq != real_packet->border_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->border_size_effect != real_packet->border_size_effect);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->border_city_permanent_radius_sq != real_packet->border_city_permanent_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->borders != real_packet->borders);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->base_bribe_cost != real_packet->base_bribe_cost);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->caravan_bonus_style != real_packet->caravan_bonus_style);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->culture_vic_points != real_packet->culture_vic_points);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->culture_vic_lead != real_packet->culture_vic_lead);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->culture_migration_pml != real_packet->culture_migration_pml);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->history_interest_pml != real_packet->history_interest_pml);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->celebratesize != real_packet->celebratesize);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->changable_tax != real_packet->changable_tax);
  if (differ) {
    different++;
  }
  if (packet->changable_tax) {
    BV_SET(fields, 21);
  }

  differ = (old->pop_report_zeroes != real_packet->pop_report_zeroes);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->citizen_nationality != real_packet->citizen_nationality);
  if (differ) {
    different++;
  }
  if (packet->citizen_nationality) {
    BV_SET(fields, 23);
  }

  differ = (old->citizen_convert_speed != real_packet->citizen_convert_speed);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->conquest_convert_pct != real_packet->conquest_convert_pct);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->citizen_partisans_pct != real_packet->citizen_partisans_pct);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->citymindist != real_packet->citymindist);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->cooling != real_packet->cooling);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->coolinglevel != real_packet->coolinglevel);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = !BV_ARE_EQUAL(old->diplchance_initial_odds, real_packet->diplchance_initial_odds);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->diplomacy != real_packet->diplomacy);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->fogofwar != real_packet->fogofwar);
  if (differ) {
    different++;
  }
  if (packet->fogofwar) {
    BV_SET(fields, 32);
  }

  differ = (old->food_cost != real_packet->food_cost);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->foodbox != real_packet->foodbox);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->forced_gold != real_packet->forced_gold);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->forced_luxury != real_packet->forced_luxury);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->forced_science != real_packet->forced_science);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->fulltradesize != real_packet->fulltradesize);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->trade_world_rel_pct != real_packet->trade_world_rel_pct);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = (old->min_trade_route_val != real_packet->min_trade_route_val);
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }

  differ = (old->goods_selection != real_packet->goods_selection);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = (old->global_advance_count != real_packet->global_advance_count);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < A_LAST; i++) {
          if (old->global_advances[i] != real_packet->global_advances[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = (old->global_warming != real_packet->global_warming);
  if (differ) {
    different++;
  }
  if (packet->global_warming) {
    BV_SET(fields, 44);
  }

  differ = (old->globalwarming != real_packet->globalwarming);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = (old->gold_upkeep_style != real_packet->gold_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 47);
  }

  differ = (old->infrapoints != real_packet->infrapoints);
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }

  differ = (old->revolentype != real_packet->revolentype);
  if (differ) {
    different++;
    BV_SET(fields, 49);
  }

  differ = (old->default_government_id != real_packet->default_government_id);
  if (differ) {
    different++;
    BV_SET(fields, 50);
  }

  differ = (old->government_during_revolution_id != real_packet->government_during_revolution_id);
  if (differ) {
    different++;
    BV_SET(fields, 51);
  }

  differ = (old->granary_food_inc != real_packet->granary_food_inc);
  if (differ) {
    different++;
    BV_SET(fields, 52);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < MAX_GRANARY_INIS; i++) {
          if (old->granary_food_ini[i] != real_packet->granary_food_ini[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 53);
  }

  differ = (old->granary_num_inis != real_packet->granary_num_inis);
  if (differ) {
    different++;
    BV_SET(fields, 54);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < B_LAST; i++) {
          if (old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 55);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 56);
  }

  differ = (old->happyborders != real_packet->happyborders);
  if (differ) {
    different++;
    BV_SET(fields, 57);
  }

  differ = (old->heating != real_packet->heating);
  if (differ) {
    different++;
    BV_SET(fields, 58);
  }

  differ = (old->illness_base_factor != real_packet->illness_base_factor);
  if (differ) {
    different++;
    BV_SET(fields, 59);
  }

  differ = (old->illness_min_size != real_packet->illness_min_size);
  if (differ) {
    different++;
    BV_SET(fields, 60);
  }

  differ = (old->illness_on != real_packet->illness_on);
  if (differ) {
    different++;
  }
  if (packet->illness_on) {
    BV_SET(fields, 61);
  }

  differ = (old->illness_pollution_factor != real_packet->illness_pollution_factor);
  if (differ) {
    different++;
    BV_SET(fields, 62);
  }

  differ = (old->illness_trade_infection != real_packet->illness_trade_infection);
  if (differ) {
    different++;
    BV_SET(fields, 63);
  }

  differ = (old->init_city_radius_sq != real_packet->init_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 64);
  }

  differ = (old->is_edit_mode != real_packet->is_edit_mode);
  if (differ) {
    different++;
  }
  if (packet->is_edit_mode) {
    BV_SET(fields, 65);
  }

  differ = (old->is_new_game != real_packet->is_new_game);
  if (differ) {
    different++;
  }
  if (packet->is_new_game) {
    BV_SET(fields, 66);
  }

  differ = (old->killcitizen != real_packet->killcitizen);
  if (differ) {
    different++;
  }
  if (packet->killcitizen) {
    BV_SET(fields, 67);
  }

  differ = (old->killstack != real_packet->killstack);
  if (differ) {
    different++;
  }
  if (packet->killstack) {
    BV_SET(fields, 68);
  }

  differ = (old->only_killing_makes_veteran != real_packet->only_killing_makes_veteran);
  if (differ) {
    different++;
  }
  if (packet->only_killing_makes_veteran) {
    BV_SET(fields, 69);
  }

  differ = (old->only_real_fight_makes_veteran != real_packet->only_real_fight_makes_veteran);
  if (differ) {
    different++;
  }
  if (packet->only_real_fight_makes_veteran) {
    BV_SET(fields, 70);
  }

  differ = (old->combat_odds_scaled_veterancy != real_packet->combat_odds_scaled_veterancy);
  if (differ) {
    different++;
  }
  if (packet->combat_odds_scaled_veterancy) {
    BV_SET(fields, 71);
  }

  differ = (old->damage_reduces_bombard_rate != real_packet->damage_reduces_bombard_rate);
  if (differ) {
    different++;
  }
  if (packet->damage_reduces_bombard_rate) {
    BV_SET(fields, 72);
  }

  differ = (old->low_firepower_badwallattacker != real_packet->low_firepower_badwallattacker);
  if (differ) {
    different++;
    BV_SET(fields, 73);
  }

  differ = (old->low_firepower_pearl_harbour != real_packet->low_firepower_pearl_harbour);
  if (differ) {
    different++;
    BV_SET(fields, 74);
  }

  differ = (old->low_firepower_combat_bonus != real_packet->low_firepower_combat_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 75);
  }

  differ = (old->low_firepower_nonnat_bombard != real_packet->low_firepower_nonnat_bombard);
  if (differ) {
    different++;
    BV_SET(fields, 76);
  }

  differ = (old->nuke_pop_loss_pct != real_packet->nuke_pop_loss_pct);
  if (differ) {
    different++;
    BV_SET(fields, 77);
  }

  differ = (old->nuke_defender_survival_chance_pct != real_packet->nuke_defender_survival_chance_pct);
  if (differ) {
    different++;
    BV_SET(fields, 78);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->min_city_center_output[i] != real_packet->min_city_center_output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 79);
  }

  differ = (old->muuk_food_wipe != real_packet->muuk_food_wipe);
  if (differ) {
    different++;
  }
  if (packet->muuk_food_wipe) {
    BV_SET(fields, 80);
  }

  differ = (old->muuk_gold_wipe != real_packet->muuk_gold_wipe);
  if (differ) {
    different++;
  }
  if (packet->muuk_gold_wipe) {
    BV_SET(fields, 81);
  }

  differ = (old->muuk_shield_wipe != real_packet->muuk_shield_wipe);
  if (differ) {
    different++;
  }
  if (packet->muuk_shield_wipe) {
    BV_SET(fields, 82);
  }

  differ = (old->notradesize != real_packet->notradesize);
  if (differ) {
    different++;
    BV_SET(fields, 83);
  }

  differ = (old->nuclear_winter != real_packet->nuclear_winter);
  if (differ) {
    different++;
  }
  if (packet->nuclear_winter) {
    BV_SET(fields, 84);
  }

  differ = (old->nuclearwinter != real_packet->nuclearwinter);
  if (differ) {
    different++;
    BV_SET(fields, 85);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 86);
  }

  differ = (old->phase_mode != real_packet->phase_mode);
  if (differ) {
    different++;
    BV_SET(fields, 87);
  }

  differ = (old->pillage_select != real_packet->pillage_select);
  if (differ) {
    different++;
  }
  if (packet->pillage_select) {
    BV_SET(fields, 88);
  }

  differ = (old->steal_maps_reveals_all_cities != real_packet->steal_maps_reveals_all_cities);
  if (differ) {
    different++;
  }
  if (packet->steal_maps_reveals_all_cities) {
    BV_SET(fields, 89);
  }

  differ = (old->poison_empties_food_stock != real_packet->poison_empties_food_stock);
  if (differ) {
    different++;
  }
  if (packet->poison_empties_food_stock) {
    BV_SET(fields, 90);
  }

  differ = (old->tech_steal_allow_holes != real_packet->tech_steal_allow_holes);
  if (differ) {
    different++;
  }
  if (packet->tech_steal_allow_holes) {
    BV_SET(fields, 91);
  }

  differ = (old->tech_trade_allow_holes != real_packet->tech_trade_allow_holes);
  if (differ) {
    different++;
  }
  if (packet->tech_trade_allow_holes) {
    BV_SET(fields, 92);
  }

  differ = (old->tech_trade_loss_allow_holes != real_packet->tech_trade_loss_allow_holes);
  if (differ) {
    different++;
  }
  if (packet->tech_trade_loss_allow_holes) {
    BV_SET(fields, 93);
  }

  differ = (old->tech_parasite_allow_holes != real_packet->tech_parasite_allow_holes);
  if (differ) {
    different++;
  }
  if (packet->tech_parasite_allow_holes) {
    BV_SET(fields, 94);
  }

  differ = (old->tech_loss_allow_holes != real_packet->tech_loss_allow_holes);
  if (differ) {
    different++;
  }
  if (packet->tech_loss_allow_holes) {
    BV_SET(fields, 95);
  }

  differ = (old->rapturedelay != real_packet->rapturedelay);
  if (differ) {
    different++;
    BV_SET(fields, 96);
  }

  differ = (old->disasters != real_packet->disasters);
  if (differ) {
    different++;
    BV_SET(fields, 97);
  }

  differ = (old->restrictinfra != real_packet->restrictinfra);
  if (differ) {
    different++;
  }
  if (packet->restrictinfra) {
    BV_SET(fields, 98);
  }

  differ = (old->unreachable_protects != real_packet->unreachable_protects);
  if (differ) {
    different++;
  }
  if (packet->unreachable_protects) {
    BV_SET(fields, 99);
  }

  differ = (old->sciencebox != real_packet->sciencebox);
  if (differ) {
    different++;
    BV_SET(fields, 100);
  }

  differ = (old->shieldbox != real_packet->shieldbox);
  if (differ) {
    different++;
    BV_SET(fields, 101);
  }

  differ = (old->skill_level != real_packet->skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 102);
  }

  differ = (old->victory_conditions != real_packet->victory_conditions);
  if (differ) {
    different++;
    BV_SET(fields, 103);
  }

  differ = (old->team_pooled_research != real_packet->team_pooled_research);
  if (differ) {
    different++;
  }
  if (packet->team_pooled_research) {
    BV_SET(fields, 104);
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 105);
  }

  differ = (old->tech_cost_style != real_packet->tech_cost_style);
  if (differ) {
    different++;
    BV_SET(fields, 106);
  }

  differ = (old->tech_leakage != real_packet->tech_leakage);
  if (differ) {
    different++;
    BV_SET(fields, 107);
  }

  differ = (old->tech_upkeep_divider != real_packet->tech_upkeep_divider);
  if (differ) {
    different++;
    BV_SET(fields, 108);
  }

  differ = (old->tech_upkeep_style != real_packet->tech_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 109);
  }

  differ = (old->techloss_forgiveness != real_packet->techloss_forgiveness);
  if (differ) {
    different++;
    BV_SET(fields, 110);
  }

  differ = (old->free_tech_method != real_packet->free_tech_method);
  if (differ) {
    different++;
    BV_SET(fields, 111);
  }

  differ = (old->gameloss_style != real_packet->gameloss_style);
  if (differ) {
    different++;
    BV_SET(fields, 112);
  }

  differ = (old->timeout != real_packet->timeout);
  if (differ) {
    different++;
    BV_SET(fields, 113);
  }

  differ = (old->first_timeout != real_packet->first_timeout);
  if (differ) {
    different++;
    BV_SET(fields, 114);
  }

  differ = (old->tired_attack != real_packet->tired_attack);
  if (differ) {
    different++;
  }
  if (packet->tired_attack) {
    BV_SET(fields, 115);
  }

  differ = (old->trademindist != real_packet->trademindist);
  if (differ) {
    different++;
    BV_SET(fields, 116);
  }

  differ = (old->trade_revenue_style != real_packet->trade_revenue_style);
  if (differ) {
    different++;
    BV_SET(fields, 117);
  }

  differ = (old->trading_city != real_packet->trading_city);
  if (differ) {
    different++;
  }
  if (packet->trading_city) {
    BV_SET(fields, 118);
  }

  differ = (old->trading_gold != real_packet->trading_gold);
  if (differ) {
    different++;
  }
  if (packet->trading_gold) {
    BV_SET(fields, 119);
  }

  differ = (old->trading_tech != real_packet->trading_tech);
  if (differ) {
    different++;
  }
  if (packet->trading_tech) {
    BV_SET(fields, 120);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 121);
  }

  differ = (old->warminglevel != real_packet->warminglevel);
  if (differ) {
    different++;
    BV_SET(fields, 122);
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 123);
  }

  differ = (old->year_0_hack != real_packet->year_0_hack);
  if (differ) {
    different++;
  }
  if (packet->year_0_hack) {
    BV_SET(fields, 124);
  }

  differ = (old->fragment_count != real_packet->fragment_count);
  if (differ) {
    different++;
    BV_SET(fields, 125);
  }

  differ = (old->civil_war_enabled != real_packet->civil_war_enabled);
  if (differ) {
    different++;
  }
  if (packet->civil_war_enabled) {
    BV_SET(fields, 126);
  }

  differ = (old->civil_war_bonus_celebrating != real_packet->civil_war_bonus_celebrating);
  if (differ) {
    different++;
    BV_SET(fields, 127);
  }

  differ = (old->civil_war_bonus_unhappy != real_packet->civil_war_bonus_unhappy);
  if (differ) {
    different++;
    BV_SET(fields, 128);
  }

  differ = (old->granularity != real_packet->granularity);
  if (differ) {
    different++;
    BV_SET(fields, 129);
  }

  differ = (old->small_wonder_visibility != real_packet->small_wonder_visibility);
  if (differ) {
    different++;
    BV_SET(fields, 130);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'add_to_size_limit' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "add_to_size_limit";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->add_to_size_limit);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'aifill' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "aifill";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->aifill);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'persistent_ready' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "persistent_ready";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->persistent_ready);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'airlifting_style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlifting_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlifting_style);
  }
  /* field 4 is folded into the header */
  /* field 5 is folded into the header */
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'angrycitizen' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "angrycitizen";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->angrycitizen);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'base_pollution' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->base_pollution);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'base_tech_cost' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_tech_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->base_tech_cost);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'tech_leak_pct' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_leak_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->tech_leak_pct);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'border_city_radius_sq' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->border_city_radius_sq);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'border_size_effect' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_size_effect";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->border_size_effect);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'border_city_permanent_radius_sq' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_city_permanent_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->border_city_permanent_radius_sq);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'borders' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "borders";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->borders);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'base_bribe_cost' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_bribe_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->base_bribe_cost);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'caravan_bonus_style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_bonus_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->caravan_bonus_style);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'culture_vic_points' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_vic_points";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture_vic_points);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'culture_vic_lead' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_vic_lead";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->culture_vic_lead);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'culture_migration_pml' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_migration_pml";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->culture_migration_pml);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'history_interest_pml' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history_interest_pml";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->history_interest_pml);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'celebratesize' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "celebratesize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->celebratesize);
  }
  /* field 21 is folded into the header */
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'pop_report_zeroes' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pop_report_zeroes";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->pop_report_zeroes);
  }
  /* field 23 is folded into the header */
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'citizen_convert_speed' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_convert_speed";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->citizen_convert_speed);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'conquest_convert_pct' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conquest_convert_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->conquest_convert_pct);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'citizen_partisans_pct' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_partisans_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->citizen_partisans_pct);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'citymindist' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citymindist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->citymindist);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'cooling' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "cooling";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->cooling);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'coolinglevel' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "coolinglevel";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->coolinglevel);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'diplchance_initial_odds' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplchance_initial_odds";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->diplchance_initial_odds);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'diplomacy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomacy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->diplomacy);
  }
  /* field 32 is folded into the header */
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'food_cost' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->food_cost);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'foodbox' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "foodbox";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->foodbox);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'forced_gold' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_gold";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->forced_gold);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'forced_luxury' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_luxury";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->forced_luxury);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'forced_science' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_science";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->forced_science);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'fulltradesize' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fulltradesize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->fulltradesize);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'trade_world_rel_pct' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_world_rel_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_world_rel_pct);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'min_trade_route_val' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "min_trade_route_val";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->min_trade_route_val);
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'goods_selection' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods_selection";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->goods_selection);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'global_advance_count' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "global_advance_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->global_advance_count);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'global_advances' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "global_advances";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      int count = 0;

      for (i = 0; i < A_LAST; i++) {
        if (old->global_advances[i] != real_packet->global_advances[i]) {
          count++;
        }
      }
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, count + 1);

      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);

      count = 0;
#endif /* FREECIV_JSON_CONNECTION */

      fc_assert(A_LAST < 255);

      for (i = 0; i < A_LAST; i++) {
        if (old->global_advances[i] != real_packet->global_advances[i]) {
#ifdef FREECIV_JSON_CONNECTION
          /* Next diff array element. */
          field_addr.sub_location->number = count - 1;

          /* Create the diff array element. */
          DIO_PUT(farray, &dout, &field_addr, 2);

          /* Enter diff array element (start at the index address). */
          field_addr.sub_location->sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */
          DIO_PUT(uint8, &dout, &field_addr, i);

#ifdef FREECIV_JSON_CONNECTION
          /* Content address. */
          field_addr.sub_location->sub_location->number = 1;
#endif /* FREECIV_JSON_CONNECTION */
          DIO_PUT(bool8, &dout, &field_addr, real_packet->global_advances[i]);

#ifdef FREECIV_JSON_CONNECTION
          /* Exit diff array element. */
          free(field_addr.sub_location->sub_location);
          field_addr.sub_location->sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
        }
      }
#ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = count - 1;

      /* Create the diff array element. */
      DIO_PUT(farray, &dout, &field_addr, A_LAST);

      /* Enter diff array element. Point to index address. */
      field_addr.sub_location->sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */
      DIO_PUT(uint8, &dout, &field_addr, 255);

#ifdef FREECIV_JSON_CONNECTION
      /* Exit diff array element. */
      free(field_addr.sub_location->sub_location);
      field_addr.sub_location->sub_location = NULL;

      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  /* field 44 is folded into the header */
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'globalwarming' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "globalwarming";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->globalwarming);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'gold' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gold";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->gold);
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  field 'gold_upkeep_style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gold_upkeep_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->gold_upkeep_style);
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'infrapoints' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "infrapoints";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->infrapoints);
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  field 'revolentype' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "revolentype";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->revolentype);
  }
  if (BV_ISSET(fields, 50)) {
    log_packet_detailed("  field 'default_government_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "default_government_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->default_government_id);
  }
  if (BV_ISSET(fields, 51)) {
    log_packet_detailed("  field 'government_during_revolution_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "government_during_revolution_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->government_during_revolution_id);
  }
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  field 'granary_food_inc' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_food_inc";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->granary_food_inc);
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  field 'granary_food_ini' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_food_ini";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, MAX_GRANARY_INIS);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < MAX_GRANARY_INIS; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->granary_food_ini[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 54)) {
    log_packet_detailed("  field 'granary_num_inis' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_num_inis";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->granary_num_inis);
  }
  if (BV_ISSET(fields, 55)) {
    log_packet_detailed("  field 'great_wonder_owners' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "great_wonder_owners";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      int count = 0;

      for (i = 0; i < B_LAST; i++) {
        if (old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
          count++;
        }
      }
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, count + 1);

      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);

      count = 0;
#endif /* FREECIV_JSON_CONNECTION */

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if (old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
#ifdef FREECIV_JSON_CONNECTION
          /* Next diff array element. */
          field_addr.sub_location->number = count - 1;

          /* Create the diff array element. */
          DIO_PUT(farray, &dout, &field_addr, 2);

          /* Enter diff array element (start at the index address). */
          field_addr.sub_location->sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */
          DIO_PUT(uint8, &dout, &field_addr, i);

#ifdef FREECIV_JSON_CONNECTION
          /* Content address. */
          field_addr.sub_location->sub_location->number = 1;
#endif /* FREECIV_JSON_CONNECTION */
          DIO_PUT(uint16, &dout, &field_addr, real_packet->great_wonder_owners[i]);

#ifdef FREECIV_JSON_CONNECTION
          /* Exit diff array element. */
          free(field_addr.sub_location->sub_location);
          field_addr.sub_location->sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
        }
      }
#ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = count - 1;

      /* Create the diff array element. */
      DIO_PUT(farray, &dout, &field_addr, B_LAST);

      /* Enter diff array element. Point to index address. */
      field_addr.sub_location->sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */
      DIO_PUT(uint8, &dout, &field_addr, 255);

#ifdef FREECIV_JSON_CONNECTION
      /* Exit diff array element. */
      free(field_addr.sub_location->sub_location);
      field_addr.sub_location->sub_location = NULL;

      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 56)) {
    log_packet_detailed("  field 'happy_cost' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->happy_cost);
  }
  if (BV_ISSET(fields, 57)) {
    log_packet_detailed("  field 'happyborders' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happyborders";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->happyborders);
  }
  if (BV_ISSET(fields, 58)) {
    log_packet_detailed("  field 'heating' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "heating";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->heating);
  }
  if (BV_ISSET(fields, 59)) {
    log_packet_detailed("  field 'illness_base_factor' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_base_factor";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_base_factor);
  }
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  field 'illness_min_size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_min_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->illness_min_size);
  }
  /* field 61 is folded into the header */
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  field 'illness_pollution_factor' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_pollution_factor";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_pollution_factor);
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  field 'illness_trade_infection' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade_infection";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade_infection);
  }
  if (BV_ISSET(fields, 64)) {
    log_packet_detailed("  field 'init_city_radius_sq' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "init_city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->init_city_radius_sq);
  }
  /* field 65 is folded into the header */
  /* field 66 is folded into the header */
  /* field 67 is folded into the header */
  /* field 68 is folded into the header */
  /* field 69 is folded into the header */
  /* field 70 is folded into the header */
  /* field 71 is folded into the header */
  /* field 72 is folded into the header */
  if (BV_ISSET(fields, 73)) {
    log_packet_detailed("  field 'low_firepower_badwallattacker' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_badwallattacker";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->low_firepower_badwallattacker);
  }
  if (BV_ISSET(fields, 74)) {
    log_packet_detailed("  field 'low_firepower_pearl_harbour' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_pearl_harbour";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->low_firepower_pearl_harbour);
  }
  if (BV_ISSET(fields, 75)) {
    log_packet_detailed("  field 'low_firepower_combat_bonus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_combat_bonus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->low_firepower_combat_bonus);
  }
  if (BV_ISSET(fields, 76)) {
    log_packet_detailed("  field 'low_firepower_nonnat_bombard' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_nonnat_bombard";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->low_firepower_nonnat_bombard);
  }
  if (BV_ISSET(fields, 77)) {
    log_packet_detailed("  field 'nuke_pop_loss_pct' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuke_pop_loss_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->nuke_pop_loss_pct);
  }
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  field 'nuke_defender_survival_chance_pct' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuke_defender_survival_chance_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->nuke_defender_survival_chance_pct);
  }
  if (BV_ISSET(fields, 79)) {
    log_packet_detailed("  field 'min_city_center_output' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "min_city_center_output";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->min_city_center_output[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  /* field 80 is folded into the header */
  /* field 81 is folded into the header */
  /* field 82 is folded into the header */
  if (BV_ISSET(fields, 83)) {
    log_packet_detailed("  field 'notradesize' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "notradesize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->notradesize);
  }
  /* field 84 is folded into the header */
  if (BV_ISSET(fields, 85)) {
    log_packet_detailed("  field 'nuclearwinter' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuclearwinter";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->nuclearwinter);
  }
  if (BV_ISSET(fields, 86)) {
    log_packet_detailed("  field 'phase' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->phase);
  }
  if (BV_ISSET(fields, 87)) {
    log_packet_detailed("  field 'phase_mode' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase_mode";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->phase_mode);
  }
  /* field 88 is folded into the header */
  /* field 89 is folded into the header */
  /* field 90 is folded into the header */
  /* field 91 is folded into the header */
  /* field 92 is folded into the header */
  /* field 93 is folded into the header */
  /* field 94 is folded into the header */
  /* field 95 is folded into the header */
  if (BV_ISSET(fields, 96)) {
    log_packet_detailed("  field 'rapturedelay' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "rapturedelay";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->rapturedelay);
  }
  if (BV_ISSET(fields, 97)) {
    log_packet_detailed("  field 'disasters' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disasters";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disasters);
  }
  /* field 98 is folded into the header */
  /* field 99 is folded into the header */
  if (BV_ISSET(fields, 100)) {
    log_packet_detailed("  field 'sciencebox' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "sciencebox";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->sciencebox);
  }
  if (BV_ISSET(fields, 101)) {
    log_packet_detailed("  field 'shieldbox' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shieldbox";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->shieldbox);
  }
  if (BV_ISSET(fields, 102)) {
    log_packet_detailed("  field 'skill_level' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "skill_level";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->skill_level);
  }
  if (BV_ISSET(fields, 103)) {
    log_packet_detailed("  field 'victory_conditions' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "victory_conditions";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->victory_conditions);
  }
  /* field 104 is folded into the header */
  if (BV_ISSET(fields, 105)) {
    log_packet_detailed("  field 'tech' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->tech);
  }
  if (BV_ISSET(fields, 106)) {
    log_packet_detailed("  field 'tech_cost_style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_cost_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->tech_cost_style);
  }
  if (BV_ISSET(fields, 107)) {
    log_packet_detailed("  field 'tech_leakage' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_leakage";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->tech_leakage);
  }
  if (BV_ISSET(fields, 108)) {
    log_packet_detailed("  field 'tech_upkeep_divider' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_upkeep_divider";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->tech_upkeep_divider);
  }
  if (BV_ISSET(fields, 109)) {
    log_packet_detailed("  field 'tech_upkeep_style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_upkeep_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->tech_upkeep_style);
  }
  if (BV_ISSET(fields, 110)) {
    log_packet_detailed("  field 'techloss_forgiveness' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "techloss_forgiveness";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->techloss_forgiveness);
  }
  if (BV_ISSET(fields, 111)) {
    log_packet_detailed("  field 'free_tech_method' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "free_tech_method";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->free_tech_method);
  }
  if (BV_ISSET(fields, 112)) {
    log_packet_detailed("  field 'gameloss_style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gameloss_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->gameloss_style);
  }
  if (BV_ISSET(fields, 113)) {
    log_packet_detailed("  field 'timeout' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "timeout";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->timeout);
  }
  if (BV_ISSET(fields, 114)) {
    log_packet_detailed("  field 'first_timeout' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "first_timeout";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->first_timeout);
  }
  /* field 115 is folded into the header */
  if (BV_ISSET(fields, 116)) {
    log_packet_detailed("  field 'trademindist' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trademindist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->trademindist);
  }
  if (BV_ISSET(fields, 117)) {
    log_packet_detailed("  field 'trade_revenue_style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_revenue_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_revenue_style);
  }
  /* field 118 is folded into the header */
  /* field 119 is folded into the header */
  /* field 120 is folded into the header */
  if (BV_ISSET(fields, 121)) {
    log_packet_detailed("  field 'turn' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn);
  }
  if (BV_ISSET(fields, 122)) {
    log_packet_detailed("  field 'warminglevel' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "warminglevel";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->warminglevel);
  }
  if (BV_ISSET(fields, 123)) {
    log_packet_detailed("  field 'year' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "year";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->year);
  }
  /* field 124 is folded into the header */
  if (BV_ISSET(fields, 125)) {
    log_packet_detailed("  field 'fragment_count' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fragment_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->fragment_count);
  }
  /* field 126 is folded into the header */
  if (BV_ISSET(fields, 127)) {
    log_packet_detailed("  field 'civil_war_bonus_celebrating' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "civil_war_bonus_celebrating";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->civil_war_bonus_celebrating);
  }
  if (BV_ISSET(fields, 128)) {
    log_packet_detailed("  field 'civil_war_bonus_unhappy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "civil_war_bonus_unhappy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->civil_war_bonus_unhappy);
  }
  if (BV_ISSET(fields, 129)) {
    log_packet_detailed("  field 'granularity' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granularity";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->granularity);
  }
  if (BV_ISSET(fields, 130)) {
    log_packet_detailed("  field 'small_wonder_visibility' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "small_wonder_visibility";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->small_wonder_visibility);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "add_to_size_limit";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->add_to_size_limit);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "aifill";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->aifill);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "persistent_ready";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->persistent_ready);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlifting_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlifting_style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift_from_always_enabled";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->airlift_from_always_enabled);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift_to_always_enabled";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->airlift_to_always_enabled);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "angrycitizen";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->angrycitizen);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->base_pollution);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_tech_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->base_tech_cost);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_leak_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->tech_leak_pct);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->border_city_radius_sq);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_size_effect";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->border_size_effect);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "border_city_permanent_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->border_city_permanent_radius_sq);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "borders";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->borders);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "base_bribe_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->base_bribe_cost);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_bonus_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->caravan_bonus_style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_vic_points";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture_vic_points);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_vic_lead";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->culture_vic_lead);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture_migration_pml";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->culture_migration_pml);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history_interest_pml";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->history_interest_pml);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "celebratesize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->celebratesize);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changable_tax";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->changable_tax);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pop_report_zeroes";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->pop_report_zeroes);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_nationality";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->citizen_nationality);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_convert_speed";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->citizen_convert_speed);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conquest_convert_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->conquest_convert_pct);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_partisans_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->citizen_partisans_pct);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citymindist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->citymindist);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "cooling";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->cooling);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "coolinglevel";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->coolinglevel);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplchance_initial_odds";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->diplchance_initial_odds);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomacy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->diplomacy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fogofwar";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->fogofwar);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->food_cost);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "foodbox";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->foodbox);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_gold";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->forced_gold);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_luxury";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->forced_luxury);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "forced_science";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->forced_science);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fulltradesize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->fulltradesize);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_world_rel_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_world_rel_pct);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "min_trade_route_val";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->min_trade_route_val);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods_selection";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->goods_selection);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "global_advance_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->global_advance_count);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "global_advances";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, A_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < A_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(bool8, &dout, &field_addr, real_packet->global_advances[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "global_warming";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->global_warming);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "globalwarming";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->globalwarming);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gold";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->gold);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gold_upkeep_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->gold_upkeep_style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "infrapoints";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->infrapoints);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "revolentype";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->revolentype);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "default_government_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->default_government_id);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "government_during_revolution_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->government_during_revolution_id);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_food_inc";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->granary_food_inc);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_food_ini";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, MAX_GRANARY_INIS);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < MAX_GRANARY_INIS; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->granary_food_ini[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granary_num_inis";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->granary_num_inis);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "great_wonder_owners";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, B_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < B_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->great_wonder_owners[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->happy_cost);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happyborders";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->happyborders);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "heating";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->heating);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_base_factor";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_base_factor);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_min_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->illness_min_size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_on";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->illness_on);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_pollution_factor";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_pollution_factor);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade_infection";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade_infection);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "init_city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->init_city_radius_sq);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "is_edit_mode";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->is_edit_mode);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "is_new_game";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->is_new_game);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "killcitizen";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->killcitizen);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "killstack";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->killstack);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "only_killing_makes_veteran";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->only_killing_makes_veteran);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "only_real_fight_makes_veteran";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->only_real_fight_makes_veteran);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "combat_odds_scaled_veterancy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->combat_odds_scaled_veterancy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "damage_reduces_bombard_rate";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->damage_reduces_bombard_rate);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_badwallattacker";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->low_firepower_badwallattacker);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_pearl_harbour";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->low_firepower_pearl_harbour);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_combat_bonus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->low_firepower_combat_bonus);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "low_firepower_nonnat_bombard";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->low_firepower_nonnat_bombard);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuke_pop_loss_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->nuke_pop_loss_pct);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuke_defender_survival_chance_pct";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->nuke_defender_survival_chance_pct);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "min_city_center_output";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->min_city_center_output[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "muuk_food_wipe";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->muuk_food_wipe);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "muuk_gold_wipe";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->muuk_gold_wipe);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "muuk_shield_wipe";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->muuk_shield_wipe);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "notradesize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->notradesize);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuclear_winter";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->nuclear_winter);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nuclearwinter";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->nuclearwinter);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->phase);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase_mode";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->phase_mode);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pillage_select";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->pillage_select);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal_maps_reveals_all_cities";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->steal_maps_reveals_all_cities);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "poison_empties_food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->poison_empties_food_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_steal_allow_holes";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->tech_steal_allow_holes);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_trade_allow_holes";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->tech_trade_allow_holes);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_trade_loss_allow_holes";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->tech_trade_loss_allow_holes);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_parasite_allow_holes";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->tech_parasite_allow_holes);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_loss_allow_holes";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->tech_loss_allow_holes);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "rapturedelay";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->rapturedelay);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disasters";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disasters);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "restrictinfra";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->restrictinfra);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unreachable_protects";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->unreachable_protects);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "sciencebox";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->sciencebox);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shieldbox";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->shieldbox);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "skill_level";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->skill_level);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "victory_conditions";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->victory_conditions);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_pooled_research";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->team_pooled_research);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->tech);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_cost_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->tech_cost_style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_leakage";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->tech_leakage);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_upkeep_divider";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->tech_upkeep_divider);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tech_upkeep_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->tech_upkeep_style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "techloss_forgiveness";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->techloss_forgiveness);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "free_tech_method";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->free_tech_method);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gameloss_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->gameloss_style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "timeout";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->timeout);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "first_timeout";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->first_timeout);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tired_attack";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->tired_attack);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trademindist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->trademindist);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_revenue_style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_revenue_style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trading_city";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->trading_city);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trading_gold";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->trading_gold);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trading_tech";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->trading_tech);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "warminglevel";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->warminglevel);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "year";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->year);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "year_0_hack";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->year_0_hack);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fragment_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->fragment_count);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "civil_war_enabled";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->civil_war_enabled);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "civil_war_bonus_celebrating";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->civil_war_bonus_celebrating);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "civil_war_bonus_unhappy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->civil_war_bonus_unhappy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "granularity";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->granularity);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "small_wonder_visibility";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->small_wonder_visibility);

#endif
  SEND_PACKET_END(PACKET_GAME_INFO);
}

int send_packet_game_info(struct connection *pc, const struct packet_game_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_GAME_INFO].packet != NULL, -1,
                        "Handler for PACKET_GAME_INFO not installed");
  return pc->phs.handlers->send[PACKET_GAME_INFO].packet(pc, packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_calendar_info_100 hash_const

#define cmp_packet_calendar_info_100 cmp_const

BV_DEFINE(packet_calendar_info_100_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_calendar_info *receive_packet_calendar_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_calendar_info_100_fields fields;
  struct packet_calendar_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CALENDAR_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_calendar_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "positive_year_label";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->positive_year_label, sizeof(real_packet->positive_year_label))) {
    RECEIVE_PACKET_FIELD_ERROR(positive_year_label);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "negative_year_label";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->negative_year_label, sizeof(real_packet->negative_year_label))) {
    RECEIVE_PACKET_FIELD_ERROR(negative_year_label);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "calendar_fragments";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->calendar_fragments)) {
    RECEIVE_PACKET_FIELD_ERROR(calendar_fragments);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "calendar_fragment_name";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(string, &din, &field_addr, real_packet->calendar_fragment_name[i], sizeof(real_packet->calendar_fragment_name[i]))) {
        RECEIVE_PACKET_FIELD_ERROR(calendar_fragment_name);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "calendar_skip_0";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->calendar_skip_0)) {
    RECEIVE_PACKET_FIELD_ERROR(calendar_skip_0);
  }

#endif
  log_packet_detailed("packet_calendar_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_calendar_info_100, cmp_packet_calendar_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'positive_year_label'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "positive_year_label";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->positive_year_label, sizeof(real_packet->positive_year_label))) {
      RECEIVE_PACKET_FIELD_ERROR(positive_year_label);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'negative_year_label'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "negative_year_label";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->negative_year_label, sizeof(real_packet->negative_year_label))) {
      RECEIVE_PACKET_FIELD_ERROR(negative_year_label);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'calendar_fragments'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "calendar_fragments";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->calendar_fragments)) {
      RECEIVE_PACKET_FIELD_ERROR(calendar_fragments);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'calendar_fragment_name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "calendar_fragment_name";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(string, &din, &field_addr, real_packet->calendar_fragment_name[i], sizeof(real_packet->calendar_fragment_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(calendar_fragment_name);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  real_packet->calendar_skip_0 = BV_ISSET(fields, 4);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_calendar_info_100(struct connection *pc, const struct packet_calendar_info *packet)
{
  const struct packet_calendar_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_calendar_info_100_fields fields;
  struct packet_calendar_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CALENDAR_INFO;
  int different = 0;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CALENDAR_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_calendar_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_calendar_info_100, cmp_packet_calendar_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (strcmp(old->positive_year_label, real_packet->positive_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->negative_year_label, real_packet->negative_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->calendar_fragments != real_packet->calendar_fragments);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
          if (strcmp(old->calendar_fragment_name[i], real_packet->calendar_fragment_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->calendar_skip_0 != real_packet->calendar_skip_0);
  if (differ) {
    different++;
  }
  if (packet->calendar_skip_0) {
    BV_SET(fields, 4);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'positive_year_label' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "positive_year_label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->positive_year_label);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'negative_year_label' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "negative_year_label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->negative_year_label);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'calendar_fragments' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "calendar_fragments";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->calendar_fragments);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'calendar_fragment_name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "calendar_fragment_name";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, MAX_CALENDAR_FRAGMENTS);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(string, &dout, &field_addr, real_packet->calendar_fragment_name[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  /* field 4 is folded into the header */

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "positive_year_label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->positive_year_label);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "negative_year_label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->negative_year_label);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "calendar_fragments";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->calendar_fragments);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "calendar_fragment_name";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, MAX_CALENDAR_FRAGMENTS);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(string, &dout, &field_addr, real_packet->calendar_fragment_name[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "calendar_skip_0";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->calendar_skip_0);

#endif
  SEND_PACKET_END(PACKET_CALENDAR_INFO);
}

int send_packet_calendar_info(struct connection *pc, const struct packet_calendar_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CALENDAR_INFO].packet != NULL, -1,
                        "Handler for PACKET_CALENDAR_INFO not installed");
  return pc->phs.handlers->send[PACKET_CALENDAR_INFO].packet(pc, packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_timeout_info_100 hash_const

#define cmp_packet_timeout_info_100 cmp_const

BV_DEFINE(packet_timeout_info_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_timeout_info *receive_packet_timeout_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_timeout_info_100_fields fields;
  struct packet_timeout_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TIMEOUT_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_timeout_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "seconds_to_phasedone";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sfloat, &din, &field_addr, &real_packet->seconds_to_phasedone, 100)) {
    RECEIVE_PACKET_FIELD_ERROR(seconds_to_phasedone);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turn_change_time";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sfloat, &din, &field_addr, &real_packet->last_turn_change_time, 100)) {
    RECEIVE_PACKET_FIELD_ERROR(last_turn_change_time);
  }

#endif
  log_packet_detailed("packet_timeout_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_timeout_info_100, cmp_packet_timeout_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'seconds_to_phasedone'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "seconds_to_phasedone";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sfloat, &din, &field_addr, &real_packet->seconds_to_phasedone, 100)) {
      RECEIVE_PACKET_FIELD_ERROR(seconds_to_phasedone);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'last_turn_change_time'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "last_turn_change_time";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sfloat, &din, &field_addr, &real_packet->last_turn_change_time, 100)) {
      RECEIVE_PACKET_FIELD_ERROR(last_turn_change_time);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_timeout_info_100(struct connection *pc, const struct packet_timeout_info *packet)
{
  const struct packet_timeout_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_timeout_info_100_fields fields;
  struct packet_timeout_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TIMEOUT_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_TIMEOUT_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_timeout_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_timeout_info_100, cmp_packet_timeout_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->seconds_to_phasedone != real_packet->seconds_to_phasedone);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->last_turn_change_time != real_packet->last_turn_change_time);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'seconds_to_phasedone' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "seconds_to_phasedone";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sfloat, &dout, &field_addr, real_packet->seconds_to_phasedone, 100);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'last_turn_change_time' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turn_change_time";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sfloat, &dout, &field_addr, real_packet->last_turn_change_time, 100);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "seconds_to_phasedone";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sfloat, &dout, &field_addr, real_packet->seconds_to_phasedone, 100);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turn_change_time";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sfloat, &dout, &field_addr, real_packet->last_turn_change_time, 100);

#endif
  SEND_PACKET_END(PACKET_TIMEOUT_INFO);
}

int send_packet_timeout_info(struct connection *pc, const struct packet_timeout_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_TIMEOUT_INFO].packet != NULL, -1,
                        "Handler for PACKET_TIMEOUT_INFO not installed");
  return pc->phs.handlers->send[PACKET_TIMEOUT_INFO].packet(pc, packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_map_info_100 hash_const

#define cmp_packet_map_info_100 cmp_const

BV_DEFINE(packet_map_info_100_fields, 3);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_map_info *receive_packet_map_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_map_info_100_fields fields;
  struct packet_map_info *old;
  struct genhash **hash = pc->phs.received + PACKET_MAP_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_map_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "xsize";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->xsize)) {
    RECEIVE_PACKET_FIELD_ERROR(xsize);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ysize";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->ysize)) {
    RECEIVE_PACKET_FIELD_ERROR(ysize);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "topology_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->topology_id)) {
    RECEIVE_PACKET_FIELD_ERROR(topology_id);
  }

#endif
  log_packet_detailed("packet_map_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_map_info_100, cmp_packet_map_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'xsize'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "xsize";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->xsize)) {
      RECEIVE_PACKET_FIELD_ERROR(xsize);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'ysize'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ysize";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->ysize)) {
      RECEIVE_PACKET_FIELD_ERROR(ysize);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'topology_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "topology_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->topology_id)) {
      RECEIVE_PACKET_FIELD_ERROR(topology_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_map_info_100(struct connection *pc, const struct packet_map_info *packet)
{
  const struct packet_map_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_map_info_100_fields fields;
  struct packet_map_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_MAP_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_MAP_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_map_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_map_info_100, cmp_packet_map_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->xsize != real_packet->xsize);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->ysize != real_packet->ysize);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->topology_id != real_packet->topology_id);
  if (differ) {
    BV_SET(fields, 2);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'xsize' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "xsize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->xsize);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'ysize' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ysize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->ysize);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'topology_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "topology_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->topology_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "xsize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->xsize);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ysize";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->ysize);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "topology_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->topology_id);

#endif
  SEND_PACKET_END(PACKET_MAP_INFO);
}

int send_packet_map_info(struct connection *pc, const struct packet_map_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_MAP_INFO].packet != NULL, -1,
                        "Handler for PACKET_MAP_INFO not installed");
  return pc->phs.handlers->send[PACKET_MAP_INFO].packet(pc, packet);
}

void lsend_packet_map_info(struct conn_list *dest, const struct packet_map_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_map_info(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_nuke_tile_info_100 hash_const

#define cmp_packet_nuke_tile_info_100 cmp_const

BV_DEFINE(packet_nuke_tile_info_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_nuke_tile_info *receive_packet_nuke_tile_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_nuke_tile_info_100_fields fields;
  struct packet_nuke_tile_info *old;
  struct genhash **hash = pc->phs.received + PACKET_NUKE_TILE_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_nuke_tile_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }

#endif
  log_packet_detailed("packet_nuke_tile_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nuke_tile_info_100, cmp_packet_nuke_tile_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nuke_tile_info_100(struct connection *pc, const struct packet_nuke_tile_info *packet)
{
  const struct packet_nuke_tile_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_nuke_tile_info_100_fields fields;
  struct packet_nuke_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NUKE_TILE_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_NUKE_TILE_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_nuke_tile_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nuke_tile_info_100, cmp_packet_nuke_tile_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->tile != real_packet->tile);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);

#endif
  SEND_PACKET_END(PACKET_NUKE_TILE_INFO);
}

int send_packet_nuke_tile_info(struct connection *pc, const struct packet_nuke_tile_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_NUKE_TILE_INFO].packet != NULL, -1,
                        "Handler for PACKET_NUKE_TILE_INFO not installed");
  return pc->phs.handlers->send[PACKET_NUKE_TILE_INFO].packet(pc, packet);
}

void lsend_packet_nuke_tile_info(struct conn_list *dest, const struct packet_nuke_tile_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_nuke_tile_info(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_nuke_tile_info(struct connection *pc, int tile)
{
  struct packet_nuke_tile_info packet, *real_packet = &packet;

  real_packet->tile = tile;
  
  return send_packet_nuke_tile_info(pc, real_packet);
}

void dlsend_packet_nuke_tile_info(struct conn_list *dest, int tile)
{
  struct packet_nuke_tile_info packet, *real_packet = &packet;

  real_packet->tile = tile;
  
  lsend_packet_nuke_tile_info(dest, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
static genhash_val_t hash_packet_team_name_info_100(const void *vkey)
{
  const struct packet_team_name_info *key = (const struct packet_team_name_info *) vkey;

  return key->team_id;
}

static bool cmp_packet_team_name_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_team_name_info *key1 = (const struct packet_team_name_info *) vkey1;
  const struct packet_team_name_info *key2 = (const struct packet_team_name_info *) vkey2;

  return key1->team_id == key2->team_id;
}
BV_DEFINE(packet_team_name_info_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_team_name_info *receive_packet_team_name_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_team_name_info_100_fields fields;
  struct packet_team_name_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TEAM_NAME_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_team_name_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
    #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->team_id)) {
    RECEIVE_PACKET_FIELD_ERROR(team_id);
  }

#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->team_id)) {
    RECEIVE_PACKET_FIELD_ERROR(team_id);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->team_name, sizeof(real_packet->team_name))) {
    RECEIVE_PACKET_FIELD_ERROR(team_name);
  }

#endif
  log_packet_detailed("packet_team_name_info_100: got info about (%d)",
    real_packet->team_id);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_team_name_info_100, cmp_packet_team_name_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int team_id = real_packet->team_id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->team_id = team_id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'team_name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "team_name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->team_name, sizeof(real_packet->team_name))) {
      RECEIVE_PACKET_FIELD_ERROR(team_name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_team_name_info_100(struct connection *pc, const struct packet_team_name_info *packet)
{
  const struct packet_team_name_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_team_name_info_100_fields fields;
  struct packet_team_name_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TEAM_NAME_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_TEAM_NAME_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_team_name_info_100: sending info about (%d)",
    real_packet->team_id);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_team_name_info_100, cmp_packet_team_name_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (strcmp(old->team_name, real_packet->team_name) != 0);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->team_id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'team_name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->team_name);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->team_id);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "team_name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->team_name);

#endif
  SEND_PACKET_END(PACKET_TEAM_NAME_INFO);
}

int send_packet_team_name_info(struct connection *pc, const struct packet_team_name_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_TEAM_NAME_INFO].packet != NULL, -1,
                        "Handler for PACKET_TEAM_NAME_INFO not installed");
  return pc->phs.handlers->send[PACKET_TEAM_NAME_INFO].packet(pc, packet);
}

void lsend_packet_team_name_info(struct conn_list *dest, const struct packet_team_name_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_team_name_info(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_achievement_info_100 hash_const

#define cmp_packet_achievement_info_100 cmp_const

BV_DEFINE(packet_achievement_info_100_fields, 3);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_achievement_info *receive_packet_achievement_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_achievement_info_100_fields fields;
  struct packet_achievement_info *old;
  struct genhash **hash = pc->phs.received + PACKET_ACHIEVEMENT_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_achievement_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gained";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->gained)) {
    RECEIVE_PACKET_FIELD_ERROR(gained);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "first";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->first)) {
    RECEIVE_PACKET_FIELD_ERROR(first);
  }

#endif
  log_packet_detailed("packet_achievement_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_achievement_info_100, cmp_packet_achievement_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  real_packet->gained = BV_ISSET(fields, 1);
  real_packet->first = BV_ISSET(fields, 2);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_achievement_info_100(struct connection *pc, const struct packet_achievement_info *packet)
{
  const struct packet_achievement_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_achievement_info_100_fields fields;
  struct packet_achievement_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_ACHIEVEMENT_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_ACHIEVEMENT_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_achievement_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_achievement_info_100, cmp_packet_achievement_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->id != real_packet->id);
  if (differ) {
    BV_SET(fields, 0);
  }

  if (packet->gained) {
    BV_SET(fields, 1);
  }

  if (packet->first) {
    BV_SET(fields, 2);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->id);
  }
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->id);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "gained";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->gained);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "first";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->first);

#endif
  SEND_PACKET_END(PACKET_ACHIEVEMENT_INFO);
}

int send_packet_achievement_info(struct connection *pc, const struct packet_achievement_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_ACHIEVEMENT_INFO].packet != NULL, -1,
                        "Handler for PACKET_ACHIEVEMENT_INFO not installed");
  return pc->phs.handlers->send[PACKET_ACHIEVEMENT_INFO].packet(pc, packet);
}

void lsend_packet_achievement_info(struct conn_list *dest, const struct packet_achievement_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_achievement_info(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_chat_msg_100 hash_const

#define cmp_packet_chat_msg_100 cmp_const

BV_DEFINE(packet_chat_msg_100_fields, 6);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_chat_msg *receive_packet_chat_msg_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_chat_msg_100_fields fields;
  struct packet_chat_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_CHAT_MSG;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_chat_msg, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
    RECEIVE_PACKET_FIELD_ERROR(message);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "event";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(event);
    }
    real_packet->event = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn)) {
    RECEIVE_PACKET_FIELD_ERROR(turn);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->phase)) {
    RECEIVE_PACKET_FIELD_ERROR(phase);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conn_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->conn_id)) {
    RECEIVE_PACKET_FIELD_ERROR(conn_id);
  }

#endif
  log_packet_detailed("packet_chat_msg_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_100, cmp_packet_chat_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "message";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'event'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "event";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(event);
      }
      real_packet->event = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'turn'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'phase'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "phase";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'conn_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "conn_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->conn_id)) {
      RECEIVE_PACKET_FIELD_ERROR(conn_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_chat_msg_100(struct connection *pc, const struct packet_chat_msg *packet)
{
  const struct packet_chat_msg *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_chat_msg_100_fields fields;
  struct packet_chat_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CHAT_MSG;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CHAT_MSG);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_chat_msg_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_100, cmp_packet_chat_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    BV_SET(fields, 4);
  }

  differ = (old->conn_id != real_packet->conn_id);
  if (differ) {
    BV_SET(fields, 5);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'event' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "event";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->event);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'turn' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'phase' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->phase);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'conn_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conn_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->conn_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "event";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->event);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->phase);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conn_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->conn_id);

#endif
  SEND_PACKET_END(PACKET_CHAT_MSG);
}

int send_packet_chat_msg(struct connection *pc, const struct packet_chat_msg *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CHAT_MSG].packet != NULL, -1,
                        "Handler for PACKET_CHAT_MSG not installed");
  return pc->phs.handlers->send[PACKET_CHAT_MSG].packet(pc, packet);
}

void lsend_packet_chat_msg(struct conn_list *dest, const struct packet_chat_msg *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_chat_msg(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_early_chat_msg_100 hash_const

#define cmp_packet_early_chat_msg_100 cmp_const

BV_DEFINE(packet_early_chat_msg_100_fields, 6);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_early_chat_msg *receive_packet_early_chat_msg_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_early_chat_msg_100_fields fields;
  struct packet_early_chat_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_EARLY_CHAT_MSG;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_early_chat_msg, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
    RECEIVE_PACKET_FIELD_ERROR(message);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "event";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(event);
    }
    real_packet->event = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn)) {
    RECEIVE_PACKET_FIELD_ERROR(turn);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->phase)) {
    RECEIVE_PACKET_FIELD_ERROR(phase);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conn_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->conn_id)) {
    RECEIVE_PACKET_FIELD_ERROR(conn_id);
  }

#endif
  log_packet_detailed("packet_early_chat_msg_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_early_chat_msg_100, cmp_packet_early_chat_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "message";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'event'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "event";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(sint16, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(event);
      }
      real_packet->event = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'turn'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'phase'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "phase";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'conn_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "conn_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->conn_id)) {
      RECEIVE_PACKET_FIELD_ERROR(conn_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_early_chat_msg_100(struct connection *pc, const struct packet_early_chat_msg *packet)
{
  const struct packet_early_chat_msg *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_early_chat_msg_100_fields fields;
  struct packet_early_chat_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_EARLY_CHAT_MSG;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_EARLY_CHAT_MSG);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_early_chat_msg_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_early_chat_msg_100, cmp_packet_early_chat_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    BV_SET(fields, 4);
  }

  differ = (old->conn_id != real_packet->conn_id);
  if (differ) {
    BV_SET(fields, 5);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'event' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "event";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->event);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'turn' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'phase' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->phase);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'conn_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conn_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->conn_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "event";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->event);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "phase";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->phase);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "conn_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->conn_id);

#endif
  SEND_PACKET_END(PACKET_EARLY_CHAT_MSG);
}

int send_packet_early_chat_msg(struct connection *pc, const struct packet_early_chat_msg *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_EARLY_CHAT_MSG].packet != NULL, -1,
                        "Handler for PACKET_EARLY_CHAT_MSG not installed");
  return pc->phs.handlers->send[PACKET_EARLY_CHAT_MSG].packet(pc, packet);
}

void lsend_packet_early_chat_msg(struct conn_list *dest, const struct packet_early_chat_msg *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_early_chat_msg(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_chat_msg_req_100 hash_const

#define cmp_packet_chat_msg_req_100 cmp_const

BV_DEFINE(packet_chat_msg_req_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_chat_msg_req *receive_packet_chat_msg_req_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_chat_msg_req_100_fields fields;
  struct packet_chat_msg_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CHAT_MSG_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_chat_msg_req, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
    RECEIVE_PACKET_FIELD_ERROR(message);
  }

#endif
  log_packet_detailed("packet_chat_msg_req_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_req_100, cmp_packet_chat_msg_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "message";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_chat_msg_req_100(struct connection *pc, const struct packet_chat_msg_req *packet)
{
  const struct packet_chat_msg_req *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_chat_msg_req_100_fields fields;
  struct packet_chat_msg_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CHAT_MSG_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CHAT_MSG_REQ);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_chat_msg_req_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_req_100, cmp_packet_chat_msg_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->message);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->message);

#endif
  SEND_PACKET_END(PACKET_CHAT_MSG_REQ);
}

int send_packet_chat_msg_req(struct connection *pc, const struct packet_chat_msg_req *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CHAT_MSG_REQ].packet != NULL, -1,
                        "Handler for PACKET_CHAT_MSG_REQ not installed");
  return pc->phs.handlers->send[PACKET_CHAT_MSG_REQ].packet(pc, packet);
}

int dsend_packet_chat_msg_req(struct connection *pc, const char *message)
{
  struct packet_chat_msg_req packet, *real_packet = &packet;

  sz_strlcpy(real_packet->message, message);
  
  return send_packet_chat_msg_req(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_connect_msg_100 hash_const

#define cmp_packet_connect_msg_100 cmp_const

BV_DEFINE(packet_connect_msg_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_connect_msg *receive_packet_connect_msg_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_connect_msg_100_fields fields;
  struct packet_connect_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_CONNECT_MSG;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_connect_msg, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
    RECEIVE_PACKET_FIELD_ERROR(message);
  }

#endif
  log_packet_detailed("packet_connect_msg_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_connect_msg_100, cmp_packet_connect_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "message";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_connect_msg_100(struct connection *pc, const struct packet_connect_msg *packet)
{
  const struct packet_connect_msg *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_connect_msg_100_fields fields;
  struct packet_connect_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONNECT_MSG;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CONNECT_MSG);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_connect_msg_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_connect_msg_100, cmp_packet_connect_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "message";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->message);

#endif
  SEND_PACKET_END(PACKET_CONNECT_MSG);
}

int send_packet_connect_msg(struct connection *pc, const struct packet_connect_msg *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CONNECT_MSG].packet != NULL, -1,
                        "Handler for PACKET_CONNECT_MSG not installed");
  return pc->phs.handlers->send[PACKET_CONNECT_MSG].packet(pc, packet);
}

int dsend_packet_connect_msg(struct connection *pc, const char *message)
{
  struct packet_connect_msg packet, *real_packet = &packet;

  sz_strlcpy(real_packet->message, message);
  
  return send_packet_connect_msg(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_server_info_100 hash_const

#define cmp_packet_server_info_100 cmp_const

BV_DEFINE(packet_server_info_100_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_server_info *receive_packet_server_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_server_info_100_fields fields;
  struct packet_server_info *old;
  struct genhash **hash = pc->phs.received + PACKET_SERVER_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_server_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "version_label";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(string, &din, &field_addr, real_packet->version_label, sizeof(real_packet->version_label))) {
    RECEIVE_PACKET_FIELD_ERROR(version_label);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "major_version";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->major_version)) {
    RECEIVE_PACKET_FIELD_ERROR(major_version);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "minor_version";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->minor_version)) {
    RECEIVE_PACKET_FIELD_ERROR(minor_version);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "patch_version";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->patch_version)) {
    RECEIVE_PACKET_FIELD_ERROR(patch_version);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "emerg_version";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->emerg_version)) {
    RECEIVE_PACKET_FIELD_ERROR(emerg_version);
  }

#endif
  log_packet_detailed("packet_server_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_info_100, cmp_packet_server_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'version_label'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "version_label";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(string, &din, &field_addr, real_packet->version_label, sizeof(real_packet->version_label))) {
      RECEIVE_PACKET_FIELD_ERROR(version_label);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'major_version'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "major_version";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->major_version)) {
      RECEIVE_PACKET_FIELD_ERROR(major_version);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'minor_version'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "minor_version";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->minor_version)) {
      RECEIVE_PACKET_FIELD_ERROR(minor_version);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'patch_version'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "patch_version";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->patch_version)) {
      RECEIVE_PACKET_FIELD_ERROR(patch_version);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'emerg_version'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "emerg_version";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->emerg_version)) {
      RECEIVE_PACKET_FIELD_ERROR(emerg_version);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_info_100(struct connection *pc, const struct packet_server_info *packet)
{
  const struct packet_server_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_server_info_100_fields fields;
  struct packet_server_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_SERVER_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_server_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_info_100, cmp_packet_server_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (strcmp(old->version_label, real_packet->version_label) != 0);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->major_version != real_packet->major_version);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->minor_version != real_packet->minor_version);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->patch_version != real_packet->patch_version);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->emerg_version != real_packet->emerg_version);
  if (differ) {
    BV_SET(fields, 4);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'version_label' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "version_label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->version_label);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'major_version' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "major_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->major_version);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'minor_version' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "minor_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->minor_version);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'patch_version' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "patch_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->patch_version);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'emerg_version' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "emerg_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->emerg_version);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "version_label";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(string, &dout, &field_addr, real_packet->version_label);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "major_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->major_version);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "minor_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->minor_version);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "patch_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->patch_version);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "emerg_version";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->emerg_version);

#endif
  SEND_PACKET_END(PACKET_SERVER_INFO);
}

int send_packet_server_info(struct connection *pc, const struct packet_server_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_INFO].packet != NULL, -1,
                        "Handler for PACKET_SERVER_INFO not installed");
  return pc->phs.handlers->send[PACKET_SERVER_INFO].packet(pc, packet);
}

int dsend_packet_server_info(struct connection *pc, const char *version_label, int major_version, int minor_version, int patch_version, int emerg_version)
{
  struct packet_server_info packet, *real_packet = &packet;

  sz_strlcpy(real_packet->version_label, version_label);
  real_packet->major_version = major_version;
  real_packet->minor_version = minor_version;
  real_packet->patch_version = patch_version;
  real_packet->emerg_version = emerg_version;
  
  return send_packet_server_info(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_remove_100 hash_const

#define cmp_packet_city_remove_100 cmp_const

BV_DEFINE(packet_city_remove_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_remove *receive_packet_city_remove_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_remove_100_fields fields;
  struct packet_city_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_REMOVE;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_remove, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }

#endif
  log_packet_detailed("packet_city_remove_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_100, cmp_packet_city_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_WEB_CITY_INFO_ADDITION;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_NATIONALITIES;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_RALLY_POINT;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_remove_100(struct connection *pc, const struct packet_city_remove *packet)
{
  const struct packet_city_remove *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_remove_100_fields fields;
  struct packet_city_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REMOVE;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_REMOVE);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_remove_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_100, cmp_packet_city_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_WEB_CITY_INFO_ADDITION;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_NATIONALITIES;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_RALLY_POINT;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);

#endif
  SEND_PACKET_END(PACKET_CITY_REMOVE);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_remove_101 hash_const

#define cmp_packet_city_remove_101 cmp_const

BV_DEFINE(packet_city_remove_101_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_remove *receive_packet_city_remove_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_remove_101_fields fields;
  struct packet_city_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_REMOVE;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_remove, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }

#endif
  log_packet_detailed("packet_city_remove_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_101, cmp_packet_city_remove_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_WEB_CITY_INFO_ADDITION;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_NATIONALITIES;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_RALLY_POINT;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_remove_101(struct connection *pc, const struct packet_city_remove *packet)
{
  const struct packet_city_remove *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_remove_101_fields fields;
  struct packet_city_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REMOVE;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_REMOVE);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_remove_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_101, cmp_packet_city_remove_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_WEB_CITY_INFO_ADDITION;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_NATIONALITIES;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_RALLY_POINT;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);

#endif
  SEND_PACKET_END(PACKET_CITY_REMOVE);
}

int send_packet_city_remove(struct connection *pc, const struct packet_city_remove *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_REMOVE].packet != NULL, -1,
                        "Handler for PACKET_CITY_REMOVE not installed");
  return pc->phs.handlers->send[PACKET_CITY_REMOVE].packet(pc, packet);
}

void lsend_packet_city_remove(struct conn_list *dest, const struct packet_city_remove *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_remove(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_city_remove(struct connection *pc, int city_id16, int city_id32)
{
  struct packet_city_remove packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  
  return send_packet_city_remove(pc, real_packet);
}

void dlsend_packet_city_remove(struct conn_list *dest, int city_id16, int city_id32)
{
  struct packet_city_remove packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  
  lsend_packet_city_remove(dest, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_info_100 hash_const

#define cmp_packet_city_info_100 cmp_const

BV_DEFINE(packet_city_info_100_fields, 50);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_info *receive_packet_city_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_info_100_fields fields;
  struct packet_city_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->id32)) {
    RECEIVE_PACKET_FIELD_ERROR(id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
    RECEIVE_PACKET_FIELD_ERROR(owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "original";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->original)) {
    RECEIVE_PACKET_FIELD_ERROR(original);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
    RECEIVE_PACKET_FIELD_ERROR(size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->city_radius_sq)) {
    RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
    RECEIVE_PACKET_FIELD_ERROR(style);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(capital);
    }
    real_packet->capital = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_happy[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_content[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_content);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_unhappy[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_angry[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists_size)) {
    RECEIVE_PACKET_FIELD_ERROR(specialists_size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->specialists_size > SP_MAX) {
      RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
    }
    for (i = 0; i < real_packet->specialists_size; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists[i])) {
        RECEIVE_PACKET_FIELD_ERROR(specialists);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->history)) {
    RECEIVE_PACKET_FIELD_ERROR(history);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture)) {
    RECEIVE_PACKET_FIELD_ERROR(culture);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->buy_cost)) {
    RECEIVE_PACKET_FIELD_ERROR(buy_cost);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->surplus[i])) {
        RECEIVE_PACKET_FIELD_ERROR(surplus);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->waste[i])) {
        RECEIVE_PACKET_FIELD_ERROR(waste);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->unhappy_penalty[i])) {
        RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->prod[i])) {
        RECEIVE_PACKET_FIELD_ERROR(prod);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->citizen_base[i])) {
        RECEIVE_PACKET_FIELD_ERROR(citizen_base);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->usage[i])) {
        RECEIVE_PACKET_FIELD_ERROR(usage);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->food_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(food_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->shield_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(shield_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_route_count)) {
    RECEIVE_PACKET_FIELD_ERROR(trade_route_count);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->pollution)) {
    RECEIVE_PACKET_FIELD_ERROR(pollution);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_trade);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(production_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
    RECEIVE_PACKET_FIELD_ERROR(production_value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_founded)) {
    RECEIVE_PACKET_FIELD_ERROR(turn_founded);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_last_built)) {
    RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_value)) {
    RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->before_change_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disbanded_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->caravan_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->last_turns_shield_surplus)) {
    RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->airlift)) {
    RECEIVE_PACKET_FIELD_ERROR(airlift);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_buy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->did_buy)) {
    RECEIVE_PACKET_FIELD_ERROR(did_buy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_sell";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->did_sell)) {
    RECEIVE_PACKET_FIELD_ERROR(did_sell);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "was_happy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->was_happy)) {
    RECEIVE_PACKET_FIELD_ERROR(was_happy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomat_investigate";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->diplomat_investigate)) {
    RECEIVE_PACKET_FIELD_ERROR(diplomat_investigate);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
    RECEIVE_PACKET_FIELD_ERROR(walls);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
    RECEIVE_PACKET_FIELD_ERROR(city_image);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->steal)) {
    RECEIVE_PACKET_FIELD_ERROR(steal);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
    RECEIVE_PACKET_FIELD_ERROR(worklist);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
    RECEIVE_PACKET_FIELD_ERROR(improvements);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->city_options)) {
    RECEIVE_PACKET_FIELD_ERROR(city_options);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_100, cmp_packet_city_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->id32)) {
      RECEIVE_PACKET_FIELD_ERROR(id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'original'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "original";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->original)) {
      RECEIVE_PACKET_FIELD_ERROR(original);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'city_radius_sq'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_radius_sq";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "style";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'capital'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "capital";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(capital);
      }
      real_packet->capital = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'ppl_happy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_happy";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_happy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'ppl_content'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_content";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_content[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_content);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'ppl_unhappy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_unhappy";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_unhappy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'ppl_angry'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_angry";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_angry[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'specialists_size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "specialists_size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists_size)) {
      RECEIVE_PACKET_FIELD_ERROR(specialists_size);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'specialists'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "specialists";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->specialists_size > SP_MAX) {
        RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
      }
      for (i = 0; i < real_packet->specialists_size; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists[i])) {
          RECEIVE_PACKET_FIELD_ERROR(specialists);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'history'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "history";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->history)) {
      RECEIVE_PACKET_FIELD_ERROR(history);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'culture'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "culture";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture)) {
      RECEIVE_PACKET_FIELD_ERROR(culture);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'buy_cost'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "buy_cost";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->buy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(buy_cost);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'surplus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "surplus";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->surplus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(surplus);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'waste'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "waste";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->waste[i])) {
          RECEIVE_PACKET_FIELD_ERROR(waste);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'unhappy_penalty'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unhappy_penalty";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->unhappy_penalty[i])) {
          RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'prod'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "prod";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->prod[i])) {
          RECEIVE_PACKET_FIELD_ERROR(prod);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'citizen_base'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "citizen_base";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->citizen_base[i])) {
          RECEIVE_PACKET_FIELD_ERROR(citizen_base);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'usage'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "usage";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->usage[i])) {
          RECEIVE_PACKET_FIELD_ERROR(usage);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'food_stock'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "food_stock";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->food_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(food_stock);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'shield_stock'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "shield_stock";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->shield_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(shield_stock);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'trade_route_count'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "trade_route_count";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_route_count)) {
      RECEIVE_PACKET_FIELD_ERROR(trade_route_count);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'pollution'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "pollution";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(pollution);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'illness_trade'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "illness_trade";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'production_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'production_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'turn_founded'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn_founded";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_founded)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_founded);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'turn_last_built'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn_last_built";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_last_built)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'changed_from_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "changed_from_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'changed_from_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "changed_from_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_value)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'before_change_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "before_change_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->before_change_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'disbanded_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "disbanded_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disbanded_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'caravan_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "caravan_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->caravan_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'last_turns_shield_surplus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "last_turns_shield_surplus";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->last_turns_shield_surplus)) {
      RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'airlift'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "airlift";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->airlift)) {
      RECEIVE_PACKET_FIELD_ERROR(airlift);
    }
  }
  real_packet->did_buy = BV_ISSET(fields, 39);
  real_packet->did_sell = BV_ISSET(fields, 40);
  real_packet->was_happy = BV_ISSET(fields, 41);
  real_packet->diplomat_investigate = BV_ISSET(fields, 42);
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'walls'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "walls";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
      RECEIVE_PACKET_FIELD_ERROR(walls);
    }
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'city_image'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_image";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'steal'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "steal";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->steal)) {
      RECEIVE_PACKET_FIELD_ERROR(steal);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'worklist'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "worklist";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  got field 'improvements'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "improvements";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'city_options'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_options";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->city_options)) {
      RECEIVE_PACKET_FIELD_ERROR(city_options);
    }
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_info_100(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  const struct packet_city_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_info_100_fields fields;
  struct packet_city_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_INFO;
  int different = force_to_send;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_100, cmp_packet_city_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->id32 != real_packet->id32);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->original != real_packet->original);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->city_radius_sq != real_packet->city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->capital != real_packet->capital);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_happy[i] != real_packet->ppl_happy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_content[i] != real_packet->ppl_content[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_unhappy[i] != real_packet->ppl_unhappy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_angry[i] != real_packet->ppl_angry[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->specialists_size != real_packet->specialists_size);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


    {
      differ = (old->specialists_size != real_packet->specialists_size);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->specialists_size; i++) {
          if (old->specialists[i] != real_packet->specialists[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->history != real_packet->history);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->culture != real_packet->culture);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->buy_cost != real_packet->buy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->surplus[i] != real_packet->surplus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->waste[i] != real_packet->waste[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->unhappy_penalty[i] != real_packet->unhappy_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->prod[i] != real_packet->prod[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->citizen_base[i] != real_packet->citizen_base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->usage[i] != real_packet->usage[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->food_stock != real_packet->food_stock);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->shield_stock != real_packet->shield_stock);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->trade_route_count != real_packet->trade_route_count);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->pollution != real_packet->pollution);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->illness_trade != real_packet->illness_trade);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->turn_founded != real_packet->turn_founded);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->turn_last_built != real_packet->turn_last_built);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->changed_from_kind != real_packet->changed_from_kind);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->changed_from_value != real_packet->changed_from_value);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->before_change_shields != real_packet->before_change_shields);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->disbanded_shields != real_packet->disbanded_shields);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->caravan_shields != real_packet->caravan_shields);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->last_turns_shield_surplus != real_packet->last_turns_shield_surplus);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->airlift != real_packet->airlift);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->did_buy != real_packet->did_buy);
  if (differ) {
    different++;
  }
  if (packet->did_buy) {
    BV_SET(fields, 39);
  }

  differ = (old->did_sell != real_packet->did_sell);
  if (differ) {
    different++;
  }
  if (packet->did_sell) {
    BV_SET(fields, 40);
  }

  differ = (old->was_happy != real_packet->was_happy);
  if (differ) {
    different++;
  }
  if (packet->was_happy) {
    BV_SET(fields, 41);
  }

  differ = (old->diplomat_investigate != real_packet->diplomat_investigate);
  if (differ) {
    different++;
  }
  if (packet->diplomat_investigate) {
    BV_SET(fields, 42);
  }

  differ = (old->walls != real_packet->walls);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = (old->steal != real_packet->steal);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 47);
  }

  differ = !BV_ARE_EQUAL(old->city_options, real_packet->city_options);
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 49);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'original' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "original";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->original);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'city_radius_sq' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->city_radius_sq);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'capital' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'ppl_happy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_happy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'ppl_content' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_content[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'ppl_unhappy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_unhappy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'ppl_angry' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_angry[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'specialists_size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists_size);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'specialists' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->specialists_size);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->specialists_size; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'history' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->history);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'culture' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'buy_cost' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->buy_cost);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'surplus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->surplus[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'waste' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->waste[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'unhappy_penalty' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->unhappy_penalty[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'prod' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->prod[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'citizen_base' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->citizen_base[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'usage' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->usage[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'food_stock' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->food_stock);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'shield_stock' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->shield_stock);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'trade_route_count' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_route_count);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'pollution' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->pollution);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'illness_trade' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'production_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'production_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'turn_founded' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_founded);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'turn_last_built' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_last_built);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'changed_from_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_kind);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'changed_from_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_value);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'before_change_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->before_change_shields);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'disbanded_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disbanded_shields);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'caravan_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->caravan_shields);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'last_turns_shield_surplus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->last_turns_shield_surplus);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'airlift' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlift);
  }
  /* field 39 is folded into the header */
  /* field 40 is folded into the header */
  /* field 41 is folded into the header */
  /* field 42 is folded into the header */
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'walls' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'city_image' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'steal' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->steal);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'worklist' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  field 'improvements' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'city_options' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->city_options);
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "original";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->original);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->city_radius_sq);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_happy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_content[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_unhappy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_angry[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists_size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->specialists_size);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->specialists_size; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->history);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->buy_cost);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->surplus[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->waste[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->unhappy_penalty[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->prod[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->citizen_base[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->usage[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->food_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->shield_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_route_count);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->pollution);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_founded);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_last_built);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->before_change_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disbanded_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->caravan_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->last_turns_shield_surplus);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlift);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_buy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->did_buy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_sell";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->did_sell);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "was_happy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->was_happy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomat_investigate";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->diplomat_investigate);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->steal);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->city_options);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_INFO);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_info_101 hash_const

#define cmp_packet_city_info_101 cmp_const

BV_DEFINE(packet_city_info_101_fields, 49);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_info *receive_packet_city_info_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_info_101_fields fields;
  struct packet_city_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->id32)) {
    RECEIVE_PACKET_FIELD_ERROR(id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
    RECEIVE_PACKET_FIELD_ERROR(owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
    RECEIVE_PACKET_FIELD_ERROR(size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->city_radius_sq)) {
    RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
    RECEIVE_PACKET_FIELD_ERROR(style);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(capital);
    }
    real_packet->capital = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_happy[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_content[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_content);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_unhappy[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_angry[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists_size)) {
    RECEIVE_PACKET_FIELD_ERROR(specialists_size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->specialists_size > SP_MAX) {
      RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
    }
    for (i = 0; i < real_packet->specialists_size; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists[i])) {
        RECEIVE_PACKET_FIELD_ERROR(specialists);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->history)) {
    RECEIVE_PACKET_FIELD_ERROR(history);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture)) {
    RECEIVE_PACKET_FIELD_ERROR(culture);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->buy_cost)) {
    RECEIVE_PACKET_FIELD_ERROR(buy_cost);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->surplus[i])) {
        RECEIVE_PACKET_FIELD_ERROR(surplus);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->waste[i])) {
        RECEIVE_PACKET_FIELD_ERROR(waste);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->unhappy_penalty[i])) {
        RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->prod[i])) {
        RECEIVE_PACKET_FIELD_ERROR(prod);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->citizen_base[i])) {
        RECEIVE_PACKET_FIELD_ERROR(citizen_base);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->usage[i])) {
        RECEIVE_PACKET_FIELD_ERROR(usage);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->food_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(food_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->shield_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(shield_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_route_count)) {
    RECEIVE_PACKET_FIELD_ERROR(trade_route_count);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->pollution)) {
    RECEIVE_PACKET_FIELD_ERROR(pollution);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_trade);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(production_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
    RECEIVE_PACKET_FIELD_ERROR(production_value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_founded)) {
    RECEIVE_PACKET_FIELD_ERROR(turn_founded);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_last_built)) {
    RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_value)) {
    RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->before_change_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disbanded_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->caravan_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->last_turns_shield_surplus)) {
    RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->airlift)) {
    RECEIVE_PACKET_FIELD_ERROR(airlift);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_buy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->did_buy)) {
    RECEIVE_PACKET_FIELD_ERROR(did_buy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_sell";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->did_sell)) {
    RECEIVE_PACKET_FIELD_ERROR(did_sell);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "was_happy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->was_happy)) {
    RECEIVE_PACKET_FIELD_ERROR(was_happy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomat_investigate";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->diplomat_investigate)) {
    RECEIVE_PACKET_FIELD_ERROR(diplomat_investigate);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
    RECEIVE_PACKET_FIELD_ERROR(walls);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
    RECEIVE_PACKET_FIELD_ERROR(city_image);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->steal)) {
    RECEIVE_PACKET_FIELD_ERROR(steal);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
    RECEIVE_PACKET_FIELD_ERROR(worklist);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
    RECEIVE_PACKET_FIELD_ERROR(improvements);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->city_options)) {
    RECEIVE_PACKET_FIELD_ERROR(city_options);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_info_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_101, cmp_packet_city_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->id32)) {
      RECEIVE_PACKET_FIELD_ERROR(id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'city_radius_sq'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_radius_sq";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "style";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'capital'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "capital";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(capital);
      }
      real_packet->capital = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'ppl_happy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_happy";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_happy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'ppl_content'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_content";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_content[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_content);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'ppl_unhappy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_unhappy";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_unhappy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'ppl_angry'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_angry";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_angry[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'specialists_size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "specialists_size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists_size)) {
      RECEIVE_PACKET_FIELD_ERROR(specialists_size);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'specialists'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "specialists";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->specialists_size > SP_MAX) {
        RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
      }
      for (i = 0; i < real_packet->specialists_size; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists[i])) {
          RECEIVE_PACKET_FIELD_ERROR(specialists);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'history'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "history";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->history)) {
      RECEIVE_PACKET_FIELD_ERROR(history);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'culture'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "culture";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture)) {
      RECEIVE_PACKET_FIELD_ERROR(culture);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'buy_cost'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "buy_cost";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->buy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(buy_cost);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'surplus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "surplus";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->surplus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(surplus);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'waste'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "waste";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->waste[i])) {
          RECEIVE_PACKET_FIELD_ERROR(waste);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'unhappy_penalty'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unhappy_penalty";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->unhappy_penalty[i])) {
          RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'prod'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "prod";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->prod[i])) {
          RECEIVE_PACKET_FIELD_ERROR(prod);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'citizen_base'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "citizen_base";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->citizen_base[i])) {
          RECEIVE_PACKET_FIELD_ERROR(citizen_base);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'usage'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "usage";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->usage[i])) {
          RECEIVE_PACKET_FIELD_ERROR(usage);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'food_stock'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "food_stock";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->food_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(food_stock);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'shield_stock'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "shield_stock";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->shield_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(shield_stock);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'trade_route_count'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "trade_route_count";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_route_count)) {
      RECEIVE_PACKET_FIELD_ERROR(trade_route_count);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'pollution'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "pollution";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(pollution);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'illness_trade'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "illness_trade";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'production_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'production_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'turn_founded'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn_founded";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_founded)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_founded);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'turn_last_built'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn_last_built";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_last_built)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'changed_from_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "changed_from_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'changed_from_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "changed_from_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_value)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'before_change_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "before_change_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->before_change_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'disbanded_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "disbanded_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disbanded_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'caravan_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "caravan_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->caravan_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'last_turns_shield_surplus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "last_turns_shield_surplus";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->last_turns_shield_surplus)) {
      RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'airlift'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "airlift";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->airlift)) {
      RECEIVE_PACKET_FIELD_ERROR(airlift);
    }
  }
  real_packet->did_buy = BV_ISSET(fields, 38);
  real_packet->did_sell = BV_ISSET(fields, 39);
  real_packet->was_happy = BV_ISSET(fields, 40);
  real_packet->diplomat_investigate = BV_ISSET(fields, 41);
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'walls'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "walls";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
      RECEIVE_PACKET_FIELD_ERROR(walls);
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'city_image'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_image";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'steal'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "steal";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->steal)) {
      RECEIVE_PACKET_FIELD_ERROR(steal);
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'worklist'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "worklist";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'improvements'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "improvements";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  got field 'city_options'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_options";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->city_options)) {
      RECEIVE_PACKET_FIELD_ERROR(city_options);
    }
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_info_101(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  const struct packet_city_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_info_101_fields fields;
  struct packet_city_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_INFO;
  int different = force_to_send;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_info_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_101, cmp_packet_city_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->id32 != real_packet->id32);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->city_radius_sq != real_packet->city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->capital != real_packet->capital);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_happy[i] != real_packet->ppl_happy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_content[i] != real_packet->ppl_content[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_unhappy[i] != real_packet->ppl_unhappy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_angry[i] != real_packet->ppl_angry[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->specialists_size != real_packet->specialists_size);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


    {
      differ = (old->specialists_size != real_packet->specialists_size);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->specialists_size; i++) {
          if (old->specialists[i] != real_packet->specialists[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->history != real_packet->history);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->culture != real_packet->culture);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->buy_cost != real_packet->buy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->surplus[i] != real_packet->surplus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->waste[i] != real_packet->waste[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->unhappy_penalty[i] != real_packet->unhappy_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->prod[i] != real_packet->prod[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->citizen_base[i] != real_packet->citizen_base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->usage[i] != real_packet->usage[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->food_stock != real_packet->food_stock);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->shield_stock != real_packet->shield_stock);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->trade_route_count != real_packet->trade_route_count);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->pollution != real_packet->pollution);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->illness_trade != real_packet->illness_trade);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->turn_founded != real_packet->turn_founded);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->turn_last_built != real_packet->turn_last_built);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->changed_from_kind != real_packet->changed_from_kind);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->changed_from_value != real_packet->changed_from_value);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->before_change_shields != real_packet->before_change_shields);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->disbanded_shields != real_packet->disbanded_shields);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->caravan_shields != real_packet->caravan_shields);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->last_turns_shield_surplus != real_packet->last_turns_shield_surplus);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->airlift != real_packet->airlift);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->did_buy != real_packet->did_buy);
  if (differ) {
    different++;
  }
  if (packet->did_buy) {
    BV_SET(fields, 38);
  }

  differ = (old->did_sell != real_packet->did_sell);
  if (differ) {
    different++;
  }
  if (packet->did_sell) {
    BV_SET(fields, 39);
  }

  differ = (old->was_happy != real_packet->was_happy);
  if (differ) {
    different++;
  }
  if (packet->was_happy) {
    BV_SET(fields, 40);
  }

  differ = (old->diplomat_investigate != real_packet->diplomat_investigate);
  if (differ) {
    different++;
  }
  if (packet->diplomat_investigate) {
    BV_SET(fields, 41);
  }

  differ = (old->walls != real_packet->walls);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = (old->steal != real_packet->steal);
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = !BV_ARE_EQUAL(old->city_options, real_packet->city_options);
  if (differ) {
    different++;
    BV_SET(fields, 47);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'city_radius_sq' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->city_radius_sq);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'capital' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'ppl_happy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_happy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'ppl_content' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_content[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'ppl_unhappy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_unhappy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'ppl_angry' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_angry[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'specialists_size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists_size);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'specialists' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->specialists_size);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->specialists_size; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'history' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->history);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'culture' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'buy_cost' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->buy_cost);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'surplus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->surplus[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'waste' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->waste[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'unhappy_penalty' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->unhappy_penalty[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'prod' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->prod[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'citizen_base' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->citizen_base[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'usage' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->usage[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'food_stock' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->food_stock);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'shield_stock' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->shield_stock);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'trade_route_count' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_route_count);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'pollution' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->pollution);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'illness_trade' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'production_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'production_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'turn_founded' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_founded);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'turn_last_built' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_last_built);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'changed_from_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_kind);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'changed_from_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_value);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'before_change_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->before_change_shields);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'disbanded_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disbanded_shields);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'caravan_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->caravan_shields);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'last_turns_shield_surplus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->last_turns_shield_surplus);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'airlift' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlift);
  }
  /* field 38 is folded into the header */
  /* field 39 is folded into the header */
  /* field 40 is folded into the header */
  /* field 41 is folded into the header */
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'walls' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'city_image' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'steal' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->steal);
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'worklist' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'improvements' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  field 'city_options' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->city_options);
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->city_radius_sq);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_happy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_content[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_unhappy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_angry[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists_size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->specialists_size);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->specialists_size; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->history);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->buy_cost);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->surplus[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->waste[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->unhappy_penalty[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->prod[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->citizen_base[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->usage[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->food_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->shield_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_route_count);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->pollution);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_founded);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_last_built);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->before_change_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disbanded_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->caravan_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->last_turns_shield_surplus);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlift);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_buy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->did_buy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_sell";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->did_sell);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "was_happy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->was_happy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomat_investigate";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->diplomat_investigate);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->steal);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->city_options);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_INFO);
}

#ifdef FREECIV_DELTA_PROTOCOL
static genhash_val_t hash_packet_city_info_102(const void *vkey)
{
  const struct packet_city_info *key = (const struct packet_city_info *) vkey;

  return key->id16;
}

static bool cmp_packet_city_info_102(const void *vkey1, const void *vkey2)
{
  const struct packet_city_info *key1 = (const struct packet_city_info *) vkey1;
  const struct packet_city_info *key2 = (const struct packet_city_info *) vkey2;

  return key1->id16 == key2->id16;
}
BV_DEFINE(packet_city_info_102_fields, 49);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_info *receive_packet_city_info_102(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_info_102_fields fields;
  struct packet_city_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
    #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->id16)) {
    RECEIVE_PACKET_FIELD_ERROR(id16);
  }

#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->id16)) {
    RECEIVE_PACKET_FIELD_ERROR(id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
    RECEIVE_PACKET_FIELD_ERROR(owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "original";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->original)) {
    RECEIVE_PACKET_FIELD_ERROR(original);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
    RECEIVE_PACKET_FIELD_ERROR(size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->city_radius_sq)) {
    RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
    RECEIVE_PACKET_FIELD_ERROR(style);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(capital);
    }
    real_packet->capital = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_happy[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_content[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_content);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_unhappy[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_angry[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists_size)) {
    RECEIVE_PACKET_FIELD_ERROR(specialists_size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->specialists_size > SP_MAX) {
      RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
    }
    for (i = 0; i < real_packet->specialists_size; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists[i])) {
        RECEIVE_PACKET_FIELD_ERROR(specialists);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->history)) {
    RECEIVE_PACKET_FIELD_ERROR(history);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture)) {
    RECEIVE_PACKET_FIELD_ERROR(culture);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->buy_cost)) {
    RECEIVE_PACKET_FIELD_ERROR(buy_cost);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->surplus[i])) {
        RECEIVE_PACKET_FIELD_ERROR(surplus);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->waste[i])) {
        RECEIVE_PACKET_FIELD_ERROR(waste);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->unhappy_penalty[i])) {
        RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->prod[i])) {
        RECEIVE_PACKET_FIELD_ERROR(prod);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->citizen_base[i])) {
        RECEIVE_PACKET_FIELD_ERROR(citizen_base);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->usage[i])) {
        RECEIVE_PACKET_FIELD_ERROR(usage);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->food_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(food_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->shield_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(shield_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_route_count)) {
    RECEIVE_PACKET_FIELD_ERROR(trade_route_count);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->pollution)) {
    RECEIVE_PACKET_FIELD_ERROR(pollution);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_trade);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(production_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
    RECEIVE_PACKET_FIELD_ERROR(production_value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_founded)) {
    RECEIVE_PACKET_FIELD_ERROR(turn_founded);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_last_built)) {
    RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_value)) {
    RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->before_change_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disbanded_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->caravan_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->last_turns_shield_surplus)) {
    RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->airlift)) {
    RECEIVE_PACKET_FIELD_ERROR(airlift);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_buy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->did_buy)) {
    RECEIVE_PACKET_FIELD_ERROR(did_buy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_sell";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->did_sell)) {
    RECEIVE_PACKET_FIELD_ERROR(did_sell);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "was_happy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->was_happy)) {
    RECEIVE_PACKET_FIELD_ERROR(was_happy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomat_investigate";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->diplomat_investigate)) {
    RECEIVE_PACKET_FIELD_ERROR(diplomat_investigate);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
    RECEIVE_PACKET_FIELD_ERROR(walls);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
    RECEIVE_PACKET_FIELD_ERROR(city_image);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->steal)) {
    RECEIVE_PACKET_FIELD_ERROR(steal);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
    RECEIVE_PACKET_FIELD_ERROR(worklist);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
    RECEIVE_PACKET_FIELD_ERROR(improvements);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->city_options)) {
    RECEIVE_PACKET_FIELD_ERROR(city_options);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_info_102: got info about (%d)",
    real_packet->id16);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_102, cmp_packet_city_info_102,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id16 = real_packet->id16;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id16 = id16;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'original'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "original";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->original)) {
      RECEIVE_PACKET_FIELD_ERROR(original);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'city_radius_sq'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_radius_sq";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "style";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'capital'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "capital";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(capital);
      }
      real_packet->capital = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'ppl_happy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_happy";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_happy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'ppl_content'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_content";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_content[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_content);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'ppl_unhappy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_unhappy";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_unhappy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'ppl_angry'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_angry";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_angry[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'specialists_size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "specialists_size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists_size)) {
      RECEIVE_PACKET_FIELD_ERROR(specialists_size);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'specialists'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "specialists";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->specialists_size > SP_MAX) {
        RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
      }
      for (i = 0; i < real_packet->specialists_size; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists[i])) {
          RECEIVE_PACKET_FIELD_ERROR(specialists);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'history'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "history";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->history)) {
      RECEIVE_PACKET_FIELD_ERROR(history);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'culture'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "culture";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture)) {
      RECEIVE_PACKET_FIELD_ERROR(culture);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'buy_cost'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "buy_cost";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->buy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(buy_cost);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'surplus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "surplus";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->surplus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(surplus);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'waste'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "waste";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->waste[i])) {
          RECEIVE_PACKET_FIELD_ERROR(waste);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'unhappy_penalty'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unhappy_penalty";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->unhappy_penalty[i])) {
          RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'prod'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "prod";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->prod[i])) {
          RECEIVE_PACKET_FIELD_ERROR(prod);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'citizen_base'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "citizen_base";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->citizen_base[i])) {
          RECEIVE_PACKET_FIELD_ERROR(citizen_base);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'usage'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "usage";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->usage[i])) {
          RECEIVE_PACKET_FIELD_ERROR(usage);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'food_stock'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "food_stock";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->food_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(food_stock);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'shield_stock'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "shield_stock";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->shield_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(shield_stock);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'trade_route_count'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "trade_route_count";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_route_count)) {
      RECEIVE_PACKET_FIELD_ERROR(trade_route_count);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'pollution'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "pollution";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(pollution);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'illness_trade'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "illness_trade";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'production_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'production_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'turn_founded'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn_founded";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_founded)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_founded);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'turn_last_built'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn_last_built";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_last_built)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'changed_from_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "changed_from_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'changed_from_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "changed_from_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_value)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'before_change_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "before_change_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->before_change_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'disbanded_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "disbanded_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disbanded_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'caravan_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "caravan_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->caravan_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'last_turns_shield_surplus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "last_turns_shield_surplus";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->last_turns_shield_surplus)) {
      RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'airlift'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "airlift";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->airlift)) {
      RECEIVE_PACKET_FIELD_ERROR(airlift);
    }
  }
  real_packet->did_buy = BV_ISSET(fields, 38);
  real_packet->did_sell = BV_ISSET(fields, 39);
  real_packet->was_happy = BV_ISSET(fields, 40);
  real_packet->diplomat_investigate = BV_ISSET(fields, 41);
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'walls'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "walls";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
      RECEIVE_PACKET_FIELD_ERROR(walls);
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'city_image'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_image";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'steal'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "steal";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->steal)) {
      RECEIVE_PACKET_FIELD_ERROR(steal);
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'worklist'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "worklist";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'improvements'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "improvements";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  got field 'city_options'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_options";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->city_options)) {
      RECEIVE_PACKET_FIELD_ERROR(city_options);
    }
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_info_102(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  const struct packet_city_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_info_102_fields fields;
  struct packet_city_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_INFO;
  int different = force_to_send;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_info_102: sending info about (%d)",
    real_packet->id16);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_102, cmp_packet_city_info_102,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->original != real_packet->original);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->city_radius_sq != real_packet->city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->capital != real_packet->capital);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_happy[i] != real_packet->ppl_happy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_content[i] != real_packet->ppl_content[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_unhappy[i] != real_packet->ppl_unhappy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_angry[i] != real_packet->ppl_angry[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->specialists_size != real_packet->specialists_size);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


    {
      differ = (old->specialists_size != real_packet->specialists_size);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->specialists_size; i++) {
          if (old->specialists[i] != real_packet->specialists[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->history != real_packet->history);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->culture != real_packet->culture);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->buy_cost != real_packet->buy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->surplus[i] != real_packet->surplus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->waste[i] != real_packet->waste[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->unhappy_penalty[i] != real_packet->unhappy_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->prod[i] != real_packet->prod[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->citizen_base[i] != real_packet->citizen_base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->usage[i] != real_packet->usage[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->food_stock != real_packet->food_stock);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->shield_stock != real_packet->shield_stock);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->trade_route_count != real_packet->trade_route_count);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->pollution != real_packet->pollution);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->illness_trade != real_packet->illness_trade);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->turn_founded != real_packet->turn_founded);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->turn_last_built != real_packet->turn_last_built);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->changed_from_kind != real_packet->changed_from_kind);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->changed_from_value != real_packet->changed_from_value);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->before_change_shields != real_packet->before_change_shields);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->disbanded_shields != real_packet->disbanded_shields);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->caravan_shields != real_packet->caravan_shields);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->last_turns_shield_surplus != real_packet->last_turns_shield_surplus);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->airlift != real_packet->airlift);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->did_buy != real_packet->did_buy);
  if (differ) {
    different++;
  }
  if (packet->did_buy) {
    BV_SET(fields, 38);
  }

  differ = (old->did_sell != real_packet->did_sell);
  if (differ) {
    different++;
  }
  if (packet->did_sell) {
    BV_SET(fields, 39);
  }

  differ = (old->was_happy != real_packet->was_happy);
  if (differ) {
    different++;
  }
  if (packet->was_happy) {
    BV_SET(fields, 40);
  }

  differ = (old->diplomat_investigate != real_packet->diplomat_investigate);
  if (differ) {
    different++;
  }
  if (packet->diplomat_investigate) {
    BV_SET(fields, 41);
  }

  differ = (old->walls != real_packet->walls);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = (old->steal != real_packet->steal);
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = !BV_ARE_EQUAL(old->city_options, real_packet->city_options);
  if (differ) {
    different++;
    BV_SET(fields, 47);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->id16);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'original' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "original";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->original);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'city_radius_sq' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->city_radius_sq);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'capital' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'ppl_happy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_happy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'ppl_content' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_content[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'ppl_unhappy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_unhappy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'ppl_angry' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_angry[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'specialists_size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists_size);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'specialists' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->specialists_size);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->specialists_size; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'history' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->history);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'culture' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'buy_cost' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->buy_cost);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'surplus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->surplus[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'waste' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->waste[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'unhappy_penalty' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->unhappy_penalty[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'prod' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->prod[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'citizen_base' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->citizen_base[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'usage' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->usage[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'food_stock' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->food_stock);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'shield_stock' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->shield_stock);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'trade_route_count' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_route_count);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'pollution' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->pollution);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'illness_trade' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'production_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'production_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'turn_founded' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_founded);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'turn_last_built' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_last_built);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'changed_from_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_kind);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'changed_from_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_value);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'before_change_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->before_change_shields);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'disbanded_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disbanded_shields);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'caravan_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->caravan_shields);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'last_turns_shield_surplus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->last_turns_shield_surplus);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'airlift' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlift);
  }
  /* field 38 is folded into the header */
  /* field 39 is folded into the header */
  /* field 40 is folded into the header */
  /* field 41 is folded into the header */
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'walls' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'city_image' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'steal' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->steal);
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'worklist' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'improvements' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  field 'city_options' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->city_options);
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "original";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->original);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->city_radius_sq);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_happy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_content[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_unhappy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_angry[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists_size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->specialists_size);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->specialists_size; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->history);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->buy_cost);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->surplus[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->waste[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->unhappy_penalty[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->prod[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->citizen_base[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->usage[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->food_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->shield_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_route_count);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->pollution);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_founded);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_last_built);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->before_change_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disbanded_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->caravan_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->last_turns_shield_surplus);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlift);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_buy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->did_buy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_sell";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->did_sell);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "was_happy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->was_happy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomat_investigate";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->diplomat_investigate);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->steal);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->city_options);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_INFO);
}

#ifdef FREECIV_DELTA_PROTOCOL
static genhash_val_t hash_packet_city_info_103(const void *vkey)
{
  const struct packet_city_info *key = (const struct packet_city_info *) vkey;

  return key->id16;
}

static bool cmp_packet_city_info_103(const void *vkey1, const void *vkey2)
{
  const struct packet_city_info *key1 = (const struct packet_city_info *) vkey1;
  const struct packet_city_info *key2 = (const struct packet_city_info *) vkey2;

  return key1->id16 == key2->id16;
}
BV_DEFINE(packet_city_info_103_fields, 48);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_info *receive_packet_city_info_103(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_info_103_fields fields;
  struct packet_city_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
    #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->id16)) {
    RECEIVE_PACKET_FIELD_ERROR(id16);
  }

#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->id16)) {
    RECEIVE_PACKET_FIELD_ERROR(id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
    RECEIVE_PACKET_FIELD_ERROR(owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
    RECEIVE_PACKET_FIELD_ERROR(size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->city_radius_sq)) {
    RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
    RECEIVE_PACKET_FIELD_ERROR(style);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(capital);
    }
    real_packet->capital = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_happy[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_content[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_content);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_unhappy[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < FEELING_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_angry[i])) {
        RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists_size)) {
    RECEIVE_PACKET_FIELD_ERROR(specialists_size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->specialists_size > SP_MAX) {
      RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
    }
    for (i = 0; i < real_packet->specialists_size; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists[i])) {
        RECEIVE_PACKET_FIELD_ERROR(specialists);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->history)) {
    RECEIVE_PACKET_FIELD_ERROR(history);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture)) {
    RECEIVE_PACKET_FIELD_ERROR(culture);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->buy_cost)) {
    RECEIVE_PACKET_FIELD_ERROR(buy_cost);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->surplus[i])) {
        RECEIVE_PACKET_FIELD_ERROR(surplus);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->waste[i])) {
        RECEIVE_PACKET_FIELD_ERROR(waste);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->unhappy_penalty[i])) {
        RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->prod[i])) {
        RECEIVE_PACKET_FIELD_ERROR(prod);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->citizen_base[i])) {
        RECEIVE_PACKET_FIELD_ERROR(citizen_base);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    for (i = 0; i < O_LAST; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(sint16, &din, &field_addr, &real_packet->usage[i])) {
        RECEIVE_PACKET_FIELD_ERROR(usage);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->food_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(food_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->shield_stock)) {
    RECEIVE_PACKET_FIELD_ERROR(shield_stock);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_route_count)) {
    RECEIVE_PACKET_FIELD_ERROR(trade_route_count);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->pollution)) {
    RECEIVE_PACKET_FIELD_ERROR(pollution);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade)) {
    RECEIVE_PACKET_FIELD_ERROR(illness_trade);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(production_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
    RECEIVE_PACKET_FIELD_ERROR(production_value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_founded)) {
    RECEIVE_PACKET_FIELD_ERROR(turn_founded);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_last_built)) {
    RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_value)) {
    RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->before_change_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disbanded_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->caravan_shields)) {
    RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->last_turns_shield_surplus)) {
    RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->airlift)) {
    RECEIVE_PACKET_FIELD_ERROR(airlift);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_buy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->did_buy)) {
    RECEIVE_PACKET_FIELD_ERROR(did_buy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_sell";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->did_sell)) {
    RECEIVE_PACKET_FIELD_ERROR(did_sell);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "was_happy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->was_happy)) {
    RECEIVE_PACKET_FIELD_ERROR(was_happy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomat_investigate";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->diplomat_investigate)) {
    RECEIVE_PACKET_FIELD_ERROR(diplomat_investigate);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
    RECEIVE_PACKET_FIELD_ERROR(walls);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
    RECEIVE_PACKET_FIELD_ERROR(city_image);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->steal)) {
    RECEIVE_PACKET_FIELD_ERROR(steal);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
    RECEIVE_PACKET_FIELD_ERROR(worklist);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
    RECEIVE_PACKET_FIELD_ERROR(improvements);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->city_options)) {
    RECEIVE_PACKET_FIELD_ERROR(city_options);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_info_103: got info about (%d)",
    real_packet->id16);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_103, cmp_packet_city_info_103,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id16 = real_packet->id16;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id16 = id16;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'city_radius_sq'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_radius_sq";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "style";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'capital'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "capital";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(capital);
      }
      real_packet->capital = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'ppl_happy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_happy";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_happy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'ppl_content'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_content";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_content[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_content);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'ppl_unhappy'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_unhappy";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_unhappy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'ppl_angry'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "ppl_angry";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < FEELING_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->ppl_angry[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'specialists_size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "specialists_size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists_size)) {
      RECEIVE_PACKET_FIELD_ERROR(specialists_size);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'specialists'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "specialists";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->specialists_size > SP_MAX) {
        RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
      }
      for (i = 0; i < real_packet->specialists_size; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->specialists[i])) {
          RECEIVE_PACKET_FIELD_ERROR(specialists);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'history'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "history";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->history)) {
      RECEIVE_PACKET_FIELD_ERROR(history);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'culture'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "culture";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->culture)) {
      RECEIVE_PACKET_FIELD_ERROR(culture);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'buy_cost'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "buy_cost";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->buy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(buy_cost);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'surplus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "surplus";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->surplus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(surplus);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'waste'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "waste";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->waste[i])) {
          RECEIVE_PACKET_FIELD_ERROR(waste);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'unhappy_penalty'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unhappy_penalty";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->unhappy_penalty[i])) {
          RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'prod'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "prod";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->prod[i])) {
          RECEIVE_PACKET_FIELD_ERROR(prod);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'citizen_base'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "citizen_base";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->citizen_base[i])) {
          RECEIVE_PACKET_FIELD_ERROR(citizen_base);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'usage'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "usage";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      for (i = 0; i < O_LAST; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(sint16, &din, &field_addr, &real_packet->usage[i])) {
          RECEIVE_PACKET_FIELD_ERROR(usage);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'food_stock'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "food_stock";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->food_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(food_stock);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'shield_stock'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "shield_stock";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->shield_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(shield_stock);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'trade_route_count'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "trade_route_count";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->trade_route_count)) {
      RECEIVE_PACKET_FIELD_ERROR(trade_route_count);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'pollution'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "pollution";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(pollution);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'illness_trade'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "illness_trade";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->illness_trade)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'production_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'production_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'turn_founded'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn_founded";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_founded)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_founded);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'turn_last_built'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "turn_last_built";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint16, &din, &field_addr, &real_packet->turn_last_built)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'changed_from_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "changed_from_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'changed_from_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "changed_from_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->changed_from_value)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'before_change_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "before_change_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->before_change_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'disbanded_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "disbanded_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->disbanded_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'caravan_shields'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "caravan_shields";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->caravan_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'last_turns_shield_surplus'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "last_turns_shield_surplus";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->last_turns_shield_surplus)) {
      RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'airlift'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "airlift";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->airlift)) {
      RECEIVE_PACKET_FIELD_ERROR(airlift);
    }
  }
  real_packet->did_buy = BV_ISSET(fields, 37);
  real_packet->did_sell = BV_ISSET(fields, 38);
  real_packet->was_happy = BV_ISSET(fields, 39);
  real_packet->diplomat_investigate = BV_ISSET(fields, 40);
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'walls'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "walls";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
      RECEIVE_PACKET_FIELD_ERROR(walls);
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'city_image'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_image";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'steal'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "steal";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->steal)) {
      RECEIVE_PACKET_FIELD_ERROR(steal);
    }
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'worklist'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "worklist";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'improvements'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "improvements";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'city_options'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_options";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->city_options)) {
      RECEIVE_PACKET_FIELD_ERROR(city_options);
    }
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_info_103(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  const struct packet_city_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_info_103_fields fields;
  struct packet_city_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_INFO;
  int different = force_to_send;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_info_103: sending info about (%d)",
    real_packet->id16);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_103, cmp_packet_city_info_103,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->city_radius_sq != real_packet->city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->capital != real_packet->capital);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_happy[i] != real_packet->ppl_happy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_content[i] != real_packet->ppl_content[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_unhappy[i] != real_packet->ppl_unhappy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_angry[i] != real_packet->ppl_angry[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->specialists_size != real_packet->specialists_size);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


    {
      differ = (old->specialists_size != real_packet->specialists_size);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->specialists_size; i++) {
          if (old->specialists[i] != real_packet->specialists[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->history != real_packet->history);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->culture != real_packet->culture);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->buy_cost != real_packet->buy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->surplus[i] != real_packet->surplus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->waste[i] != real_packet->waste[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->unhappy_penalty[i] != real_packet->unhappy_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->prod[i] != real_packet->prod[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->citizen_base[i] != real_packet->citizen_base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }


    {
      differ = FALSE;
      {
        int i;

        for (i = 0; i < O_LAST; i++) {
          if (old->usage[i] != real_packet->usage[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->food_stock != real_packet->food_stock);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->shield_stock != real_packet->shield_stock);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->trade_route_count != real_packet->trade_route_count);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->pollution != real_packet->pollution);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->illness_trade != real_packet->illness_trade);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->turn_founded != real_packet->turn_founded);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->turn_last_built != real_packet->turn_last_built);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->changed_from_kind != real_packet->changed_from_kind);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->changed_from_value != real_packet->changed_from_value);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->before_change_shields != real_packet->before_change_shields);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->disbanded_shields != real_packet->disbanded_shields);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->caravan_shields != real_packet->caravan_shields);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->last_turns_shield_surplus != real_packet->last_turns_shield_surplus);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->airlift != real_packet->airlift);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->did_buy != real_packet->did_buy);
  if (differ) {
    different++;
  }
  if (packet->did_buy) {
    BV_SET(fields, 37);
  }

  differ = (old->did_sell != real_packet->did_sell);
  if (differ) {
    different++;
  }
  if (packet->did_sell) {
    BV_SET(fields, 38);
  }

  differ = (old->was_happy != real_packet->was_happy);
  if (differ) {
    different++;
  }
  if (packet->was_happy) {
    BV_SET(fields, 39);
  }

  differ = (old->diplomat_investigate != real_packet->diplomat_investigate);
  if (differ) {
    different++;
  }
  if (packet->diplomat_investigate) {
    BV_SET(fields, 40);
  }

  differ = (old->walls != real_packet->walls);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = (old->steal != real_packet->steal);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = !BV_ARE_EQUAL(old->city_options, real_packet->city_options);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 47);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->id16);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'city_radius_sq' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->city_radius_sq);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'capital' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'ppl_happy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_happy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'ppl_content' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_content[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'ppl_unhappy' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_unhappy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'ppl_angry' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_angry[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'specialists_size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists_size);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'specialists' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->specialists_size);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->specialists_size; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'history' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->history);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'culture' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'buy_cost' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->buy_cost);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'surplus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->surplus[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'waste' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->waste[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'unhappy_penalty' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->unhappy_penalty[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'prod' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->prod[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'citizen_base' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->citizen_base[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'usage' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->usage[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'food_stock' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->food_stock);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'shield_stock' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->shield_stock);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'trade_route_count' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_route_count);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'pollution' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->pollution);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'illness_trade' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'production_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'production_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'turn_founded' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_founded);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'turn_last_built' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_last_built);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'changed_from_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_kind);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'changed_from_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_value);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'before_change_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->before_change_shields);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'disbanded_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disbanded_shields);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'caravan_shields' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->caravan_shields);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'last_turns_shield_surplus' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->last_turns_shield_surplus);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'airlift' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlift);
  }
  /* field 37 is folded into the header */
  /* field 38 is folded into the header */
  /* field 39 is folded into the header */
  /* field 40 is folded into the header */
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'walls' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'city_image' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'steal' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->steal);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'worklist' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'improvements' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'city_options' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->city_options);
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_radius_sq";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->city_radius_sq);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_happy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_happy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_content";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_content[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_unhappy";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_unhappy[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "ppl_angry";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, FEELING_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < FEELING_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->ppl_angry[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists_size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists_size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "specialists";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->specialists_size);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->specialists_size; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->specialists[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "history";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->history);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "culture";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->culture);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "buy_cost";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->buy_cost);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "surplus";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->surplus[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "waste";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->waste[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy_penalty";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->unhappy_penalty[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "prod";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->prod[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "citizen_base";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->citizen_base[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "usage";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, O_LAST);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < O_LAST; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(sint16, &dout, &field_addr, real_packet->usage[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "food_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->food_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "shield_stock";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->shield_stock);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "trade_route_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->trade_route_count);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "pollution";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->pollution);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "illness_trade";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->illness_trade);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_founded";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_founded);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "turn_last_built";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint16, &dout, &field_addr, real_packet->turn_last_built);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "changed_from_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->changed_from_value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "before_change_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->before_change_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "disbanded_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->disbanded_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "caravan_shields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->caravan_shields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "last_turns_shield_surplus";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->last_turns_shield_surplus);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "airlift";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->airlift);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_buy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->did_buy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "did_sell";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->did_sell);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "was_happy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->was_happy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "diplomat_investigate";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->diplomat_investigate);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "steal";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->steal);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->city_options);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_INFO);
}

int send_packet_city_info(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_INFO].force_to_send != NULL, -1,
                        "Handler for PACKET_CITY_INFO not installed");
  return pc->phs.handlers->send[PACKET_CITY_INFO].force_to_send(pc, packet, force_to_send);
}

void lsend_packet_city_info(struct conn_list *dest, const struct packet_city_info *packet, bool force_to_send)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_info(pconn, packet, force_to_send);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_nationalities_100 hash_const

#define cmp_packet_city_nationalities_100 cmp_const

BV_DEFINE(packet_city_nationalities_100_fields, 4);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_nationalities *receive_packet_city_nationalities_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_nationalities_100_fields fields;
  struct packet_city_nationalities *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NATIONALITIES;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_nationalities, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->id32)) {
    RECEIVE_PACKET_FIELD_ERROR(id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nationalities_count";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nationalities_count)) {
    RECEIVE_PACKET_FIELD_ERROR(nationalities_count);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_id";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->nationalities_count > MAX_CITY_NATIONALITIES) {
      RECEIVE_PACKET_FIELD_ERROR(nation_id, ": truncation array");
    }
    for (i = 0; i < real_packet->nationalities_count; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->nation_id[i])) {
        RECEIVE_PACKET_FIELD_ERROR(nation_id);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_citizens";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->nationalities_count > MAX_CITY_NATIONALITIES) {
      RECEIVE_PACKET_FIELD_ERROR(nation_citizens, ": truncation array");
    }
    for (i = 0; i < real_packet->nationalities_count; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nation_citizens[i])) {
        RECEIVE_PACKET_FIELD_ERROR(nation_citizens);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }

#endif
  log_packet_detailed("packet_city_nationalities_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_nationalities_100, cmp_packet_city_nationalities_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->id32)) {
      RECEIVE_PACKET_FIELD_ERROR(id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nationalities_count'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nationalities_count";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nationalities_count)) {
      RECEIVE_PACKET_FIELD_ERROR(nationalities_count);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'nation_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nation_id";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->nationalities_count > MAX_CITY_NATIONALITIES) {
        RECEIVE_PACKET_FIELD_ERROR(nation_id, ": truncation array");
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->nation_id[i])) {
          RECEIVE_PACKET_FIELD_ERROR(nation_id);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'nation_citizens'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nation_citizens";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->nationalities_count > MAX_CITY_NATIONALITIES) {
        RECEIVE_PACKET_FIELD_ERROR(nation_citizens, ": truncation array");
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nation_citizens[i])) {
          RECEIVE_PACKET_FIELD_ERROR(nation_citizens);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_nationalities_100(struct connection *pc, const struct packet_city_nationalities *packet, bool force_to_send)
{
  const struct packet_city_nationalities *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_nationalities_100_fields fields;
  struct packet_city_nationalities *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NATIONALITIES;
  int different = force_to_send;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_NATIONALITIES);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_nationalities_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_nationalities_100, cmp_packet_city_nationalities_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->id32 != real_packet->id32);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nationalities_count != real_packet->nationalities_count);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_id[i] != real_packet->nation_id[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_citizens[i] != real_packet->nation_citizens[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nationalities_count' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nationalities_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->nationalities_count);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'nation_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_id";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->nationalities_count);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->nationalities_count; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->nation_id[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'nation_citizens' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_citizens";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->nationalities_count);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->nationalities_count; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->nation_citizens[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nationalities_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->nationalities_count);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_id";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->nationalities_count);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->nationalities_count; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->nation_id[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_citizens";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->nationalities_count);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->nationalities_count; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->nation_citizens[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }

#endif
  SEND_PACKET_END(PACKET_CITY_NATIONALITIES);
}

#ifdef FREECIV_DELTA_PROTOCOL
static genhash_val_t hash_packet_city_nationalities_101(const void *vkey)
{
  const struct packet_city_nationalities *key = (const struct packet_city_nationalities *) vkey;

  return key->id16;
}

static bool cmp_packet_city_nationalities_101(const void *vkey1, const void *vkey2)
{
  const struct packet_city_nationalities *key1 = (const struct packet_city_nationalities *) vkey1;
  const struct packet_city_nationalities *key2 = (const struct packet_city_nationalities *) vkey2;

  return key1->id16 == key2->id16;
}
BV_DEFINE(packet_city_nationalities_101_fields, 3);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_nationalities *receive_packet_city_nationalities_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_nationalities_101_fields fields;
  struct packet_city_nationalities *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NATIONALITIES;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_nationalities, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
    #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->id16)) {
    RECEIVE_PACKET_FIELD_ERROR(id16);
  }

#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->id16)) {
    RECEIVE_PACKET_FIELD_ERROR(id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nationalities_count";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nationalities_count)) {
    RECEIVE_PACKET_FIELD_ERROR(nationalities_count);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_id";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->nationalities_count > MAX_CITY_NATIONALITIES) {
      RECEIVE_PACKET_FIELD_ERROR(nation_id, ": truncation array");
    }
    for (i = 0; i < real_packet->nationalities_count; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint16, &din, &field_addr, &real_packet->nation_id[i])) {
        RECEIVE_PACKET_FIELD_ERROR(nation_id);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_citizens";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->nationalities_count > MAX_CITY_NATIONALITIES) {
      RECEIVE_PACKET_FIELD_ERROR(nation_citizens, ": truncation array");
    }
    for (i = 0; i < real_packet->nationalities_count; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nation_citizens[i])) {
        RECEIVE_PACKET_FIELD_ERROR(nation_citizens);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }

#endif
  log_packet_detailed("packet_city_nationalities_101: got info about (%d)",
    real_packet->id16);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_nationalities_101, cmp_packet_city_nationalities_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id16 = real_packet->id16;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id16 = id16;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'nationalities_count'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nationalities_count";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nationalities_count)) {
      RECEIVE_PACKET_FIELD_ERROR(nationalities_count);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nation_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nation_id";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->nationalities_count > MAX_CITY_NATIONALITIES) {
        RECEIVE_PACKET_FIELD_ERROR(nation_id, ": truncation array");
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint16, &din, &field_addr, &real_packet->nation_id[i])) {
          RECEIVE_PACKET_FIELD_ERROR(nation_id);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'nation_citizens'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "nation_citizens";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->nationalities_count > MAX_CITY_NATIONALITIES) {
        RECEIVE_PACKET_FIELD_ERROR(nation_citizens, ": truncation array");
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(uint8, &din, &field_addr, &real_packet->nation_citizens[i])) {
          RECEIVE_PACKET_FIELD_ERROR(nation_citizens);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_nationalities_101(struct connection *pc, const struct packet_city_nationalities *packet, bool force_to_send)
{
  const struct packet_city_nationalities *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_nationalities_101_fields fields;
  struct packet_city_nationalities *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NATIONALITIES;
  int different = force_to_send;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_NATIONALITIES);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_nationalities_101: sending info about (%d)",
    real_packet->id16);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_nationalities_101, cmp_packet_city_nationalities_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->nationalities_count != real_packet->nationalities_count);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_id[i] != real_packet->nation_id[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_citizens[i] != real_packet->nation_citizens[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->id16);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'nationalities_count' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nationalities_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->nationalities_count);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nation_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_id";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->nationalities_count);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->nationalities_count; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->nation_id[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'nation_citizens' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_citizens";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->nationalities_count);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->nationalities_count; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->nation_citizens[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nationalities_count";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->nationalities_count);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_id";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->nationalities_count);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->nationalities_count; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint16, &dout, &field_addr, real_packet->nation_id[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "nation_citizens";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->nationalities_count);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->nationalities_count; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(uint8, &dout, &field_addr, real_packet->nation_citizens[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }

#endif
  SEND_PACKET_END(PACKET_CITY_NATIONALITIES);
}

int send_packet_city_nationalities(struct connection *pc, const struct packet_city_nationalities *packet, bool force_to_send)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_NATIONALITIES].force_to_send != NULL, -1,
                        "Handler for PACKET_CITY_NATIONALITIES not installed");
  return pc->phs.handlers->send[PACKET_CITY_NATIONALITIES].force_to_send(pc, packet, force_to_send);
}

void lsend_packet_city_nationalities(struct conn_list *dest, const struct packet_city_nationalities *packet, bool force_to_send)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_nationalities(pconn, packet, force_to_send);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_short_info_100 hash_const

#define cmp_packet_city_short_info_100 cmp_const

BV_DEFINE(packet_city_short_info_100_fields, 13);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_short_info *receive_packet_city_short_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_short_info_100_fields fields;
  struct packet_city_short_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_short_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->id32)) {
    RECEIVE_PACKET_FIELD_ERROR(id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
    RECEIVE_PACKET_FIELD_ERROR(owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
    RECEIVE_PACKET_FIELD_ERROR(size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
    RECEIVE_PACKET_FIELD_ERROR(style);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(capital);
    }
    real_packet->capital = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "occupied";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->occupied)) {
    RECEIVE_PACKET_FIELD_ERROR(occupied);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
    RECEIVE_PACKET_FIELD_ERROR(walls);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->happy)) {
    RECEIVE_PACKET_FIELD_ERROR(happy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->unhappy)) {
    RECEIVE_PACKET_FIELD_ERROR(unhappy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
    RECEIVE_PACKET_FIELD_ERROR(city_image);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
    RECEIVE_PACKET_FIELD_ERROR(improvements);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_short_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_100, cmp_packet_city_short_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->id32)) {
      RECEIVE_PACKET_FIELD_ERROR(id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "style";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'capital'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "capital";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(capital);
      }
      real_packet->capital = readin;
    }
  }
  real_packet->occupied = BV_ISSET(fields, 6);
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'walls'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "walls";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
      RECEIVE_PACKET_FIELD_ERROR(walls);
    }
  }
  real_packet->happy = BV_ISSET(fields, 8);
  real_packet->unhappy = BV_ISSET(fields, 9);
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'city_image'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_image";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'improvements'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "improvements";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_WEB_CITY_INFO_ADDITION;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_NATIONALITIES;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_RALLY_POINT;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_short_info_100(struct connection *pc, const struct packet_city_short_info *packet)
{
  const struct packet_city_short_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_short_info_100_fields fields;
  struct packet_city_short_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  int different = 0;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_SHORT_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_short_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_100, cmp_packet_city_short_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->id32 != real_packet->id32);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->capital != real_packet->capital);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->occupied != real_packet->occupied);
  if (differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 6);
  }

  differ = (old->walls != real_packet->walls);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->happy != real_packet->happy);
  if (differ) {
    different++;
  }
  if (packet->happy) {
    BV_SET(fields, 8);
  }

  differ = (old->unhappy != real_packet->unhappy);
  if (differ) {
    different++;
  }
  if (packet->unhappy) {
    BV_SET(fields, 9);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'capital' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
  }
  /* field 6 is folded into the header */
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'walls' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
  }
  /* field 8 is folded into the header */
  /* field 9 is folded into the header */
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'city_image' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'improvements' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_WEB_CITY_INFO_ADDITION;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_NATIONALITIES;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_RALLY_POINT;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "occupied";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->occupied);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->happy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->unhappy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_SHORT_INFO);
}

#ifdef FREECIV_DELTA_PROTOCOL
static genhash_val_t hash_packet_city_short_info_101(const void *vkey)
{
  const struct packet_city_short_info *key = (const struct packet_city_short_info *) vkey;

  return key->id16;
}

static bool cmp_packet_city_short_info_101(const void *vkey1, const void *vkey2)
{
  const struct packet_city_short_info *key1 = (const struct packet_city_short_info *) vkey1;
  const struct packet_city_short_info *key2 = (const struct packet_city_short_info *) vkey2;

  return key1->id16 == key2->id16;
}
BV_DEFINE(packet_city_short_info_101_fields, 12);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_short_info *receive_packet_city_short_info_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_short_info_101_fields fields;
  struct packet_city_short_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_short_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
    #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->id16)) {
    RECEIVE_PACKET_FIELD_ERROR(id16);
  }

#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->id16)) {
    RECEIVE_PACKET_FIELD_ERROR(id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
    RECEIVE_PACKET_FIELD_ERROR(owner);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
    RECEIVE_PACKET_FIELD_ERROR(size);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
    RECEIVE_PACKET_FIELD_ERROR(style);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(capital);
    }
    real_packet->capital = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "occupied";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->occupied)) {
    RECEIVE_PACKET_FIELD_ERROR(occupied);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
    RECEIVE_PACKET_FIELD_ERROR(walls);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->happy)) {
    RECEIVE_PACKET_FIELD_ERROR(happy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->unhappy)) {
    RECEIVE_PACKET_FIELD_ERROR(unhappy);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
    RECEIVE_PACKET_FIELD_ERROR(city_image);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
    RECEIVE_PACKET_FIELD_ERROR(improvements);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_short_info_101: got info about (%d)",
    real_packet->id16);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_101, cmp_packet_city_short_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id16 = real_packet->id16;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id16 = id16;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "owner";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'size'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "size";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'style'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "style";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'capital'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "capital";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(capital);
      }
      real_packet->capital = readin;
    }
  }
  real_packet->occupied = BV_ISSET(fields, 5);
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'walls'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "walls";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->walls)) {
      RECEIVE_PACKET_FIELD_ERROR(walls);
    }
  }
  real_packet->happy = BV_ISSET(fields, 7);
  real_packet->unhappy = BV_ISSET(fields, 8);
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'city_image'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_image";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'improvements'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "improvements";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_WEB_CITY_INFO_ADDITION;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_NATIONALITIES;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_RALLY_POINT;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_short_info_101(struct connection *pc, const struct packet_city_short_info *packet)
{
  const struct packet_city_short_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_short_info_101_fields fields;
  struct packet_city_short_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  int different = 0;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_SHORT_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_short_info_101: sending info about (%d)",
    real_packet->id16);

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_101, cmp_packet_city_short_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->capital != real_packet->capital);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->occupied != real_packet->occupied);
  if (differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 5);
  }

  differ = (old->walls != real_packet->walls);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->happy != real_packet->happy);
  if (differ) {
    different++;
  }
  if (packet->happy) {
    BV_SET(fields, 7);
  }

  differ = (old->unhappy != real_packet->unhappy);
  if (differ) {
    different++;
  }
  if (packet->unhappy) {
    BV_SET(fields, 8);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->id16);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'size' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'style' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'capital' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
  }
  /* field 5 is folded into the header */
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'walls' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
  }
  /* field 7 is folded into the header */
  /* field 8 is folded into the header */
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'city_image' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'improvements' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_WEB_CITY_INFO_ADDITION;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_NATIONALITIES;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_RALLY_POINT;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "owner";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->owner);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "size";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->size);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "style";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->style);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "capital";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->capital);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "occupied";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->occupied);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "walls";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->walls);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "happy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->happy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unhappy";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->unhappy);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_image";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->city_image);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_SHORT_INFO);
}

int send_packet_city_short_info(struct connection *pc, const struct packet_city_short_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_SHORT_INFO].packet != NULL, -1,
                        "Handler for PACKET_CITY_SHORT_INFO not installed");
  return pc->phs.handlers->send[PACKET_CITY_SHORT_INFO].packet(pc, packet);
}

void lsend_packet_city_short_info(struct conn_list *dest, const struct packet_city_short_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_short_info(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_trade_route_info_100 hash_const

#define cmp_packet_trade_route_info_100 cmp_const

BV_DEFINE(packet_trade_route_info_100_fields, 6);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_trade_route_info *receive_packet_trade_route_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_trade_route_info_100_fields fields;
  struct packet_trade_route_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TRADE_ROUTE_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_trade_route_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city32)) {
    RECEIVE_PACKET_FIELD_ERROR(city32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "index";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->index)) {
    RECEIVE_PACKET_FIELD_ERROR(index);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "partner32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->partner32)) {
    RECEIVE_PACKET_FIELD_ERROR(partner32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->value)) {
    RECEIVE_PACKET_FIELD_ERROR(value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "direction";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(direction);
    }
    real_packet->direction = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(goods);
    }
    real_packet->goods = readin;
  }

#endif
  log_packet_detailed("packet_trade_route_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_trade_route_info_100, cmp_packet_trade_route_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city32)) {
      RECEIVE_PACKET_FIELD_ERROR(city32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'index'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "index";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->index)) {
      RECEIVE_PACKET_FIELD_ERROR(index);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'partner32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "partner32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->partner32)) {
      RECEIVE_PACKET_FIELD_ERROR(partner32);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'direction'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "direction";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(direction);
      }
      real_packet->direction = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'goods'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "goods";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(goods);
      }
      real_packet->goods = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_trade_route_info_100(struct connection *pc, const struct packet_trade_route_info *packet)
{
  const struct packet_trade_route_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_trade_route_info_100_fields fields;
  struct packet_trade_route_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TRADE_ROUTE_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_TRADE_ROUTE_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_trade_route_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_trade_route_info_100, cmp_packet_trade_route_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city32 != real_packet->city32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->index != real_packet->index);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->partner32 != real_packet->partner32);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->direction != real_packet->direction);
  if (differ) {
    BV_SET(fields, 4);
  }

  differ = (old->goods != real_packet->goods);
  if (differ) {
    BV_SET(fields, 5);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'index' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "index";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->index);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'partner32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "partner32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->partner32);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->value);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'direction' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "direction";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->direction);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'goods' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->goods);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "index";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->index);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "partner32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->partner32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "direction";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->direction);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->goods);

#endif
  SEND_PACKET_END(PACKET_TRADE_ROUTE_INFO);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_trade_route_info_101 hash_const

#define cmp_packet_trade_route_info_101 cmp_const

BV_DEFINE(packet_trade_route_info_101_fields, 6);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_trade_route_info *receive_packet_trade_route_info_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_trade_route_info_101_fields fields;
  struct packet_trade_route_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TRADE_ROUTE_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_trade_route_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city16)) {
    RECEIVE_PACKET_FIELD_ERROR(city16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "index";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->index)) {
    RECEIVE_PACKET_FIELD_ERROR(index);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "partner16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->partner16)) {
    RECEIVE_PACKET_FIELD_ERROR(partner16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->value)) {
    RECEIVE_PACKET_FIELD_ERROR(value);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "direction";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(direction);
    }
    real_packet->direction = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(goods);
    }
    real_packet->goods = readin;
  }

#endif
  log_packet_detailed("packet_trade_route_info_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_trade_route_info_101, cmp_packet_trade_route_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city16)) {
      RECEIVE_PACKET_FIELD_ERROR(city16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'index'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "index";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->index)) {
      RECEIVE_PACKET_FIELD_ERROR(index);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'partner16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "partner16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->partner16)) {
      RECEIVE_PACKET_FIELD_ERROR(partner16);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'direction'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "direction";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(direction);
      }
      real_packet->direction = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'goods'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "goods";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(goods);
      }
      real_packet->goods = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_trade_route_info_101(struct connection *pc, const struct packet_trade_route_info *packet)
{
  const struct packet_trade_route_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_trade_route_info_101_fields fields;
  struct packet_trade_route_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TRADE_ROUTE_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_TRADE_ROUTE_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_trade_route_info_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_trade_route_info_101, cmp_packet_trade_route_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city16 != real_packet->city16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->index != real_packet->index);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->partner16 != real_packet->partner16);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->direction != real_packet->direction);
  if (differ) {
    BV_SET(fields, 4);
  }

  differ = (old->goods != real_packet->goods);
  if (differ) {
    BV_SET(fields, 5);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'index' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "index";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->index);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'partner16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "partner16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->partner16);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->value);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'direction' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "direction";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->direction);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'goods' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->goods);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "index";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->index);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "partner16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->partner16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->value);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "direction";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->direction);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "goods";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->goods);

#endif
  SEND_PACKET_END(PACKET_TRADE_ROUTE_INFO);
}

int send_packet_trade_route_info(struct connection *pc, const struct packet_trade_route_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_TRADE_ROUTE_INFO].packet != NULL, -1,
                        "Handler for PACKET_TRADE_ROUTE_INFO not installed");
  return pc->phs.handlers->send[PACKET_TRADE_ROUTE_INFO].packet(pc, packet);
}

void lsend_packet_trade_route_info(struct conn_list *dest, const struct packet_trade_route_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_trade_route_info(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_sell_100 hash_const

#define cmp_packet_city_sell_100 cmp_const

BV_DEFINE(packet_city_sell_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_sell *receive_packet_city_sell_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_sell_100_fields fields;
  struct packet_city_sell *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SELL;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_sell, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "build_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->build_id)) {
    RECEIVE_PACKET_FIELD_ERROR(build_id);
  }

#endif
  log_packet_detailed("packet_city_sell_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_100, cmp_packet_city_sell_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'build_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "build_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->build_id)) {
      RECEIVE_PACKET_FIELD_ERROR(build_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sell_100(struct connection *pc, const struct packet_city_sell *packet)
{
  const struct packet_city_sell *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_sell_100_fields fields;
  struct packet_city_sell *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SELL;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_SELL);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_sell_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_100, cmp_packet_city_sell_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->build_id != real_packet->build_id);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'build_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "build_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->build_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "build_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->build_id);

#endif
  SEND_PACKET_END(PACKET_CITY_SELL);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_sell_101 hash_const

#define cmp_packet_city_sell_101 cmp_const

BV_DEFINE(packet_city_sell_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_sell *receive_packet_city_sell_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_sell_101_fields fields;
  struct packet_city_sell *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SELL;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_sell, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "build_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->build_id)) {
    RECEIVE_PACKET_FIELD_ERROR(build_id);
  }

#endif
  log_packet_detailed("packet_city_sell_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_101, cmp_packet_city_sell_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'build_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "build_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->build_id)) {
      RECEIVE_PACKET_FIELD_ERROR(build_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sell_101(struct connection *pc, const struct packet_city_sell *packet)
{
  const struct packet_city_sell *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_sell_101_fields fields;
  struct packet_city_sell *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SELL;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_SELL);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_sell_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_101, cmp_packet_city_sell_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->build_id != real_packet->build_id);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'build_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "build_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->build_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "build_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->build_id);

#endif
  SEND_PACKET_END(PACKET_CITY_SELL);
}

int send_packet_city_sell(struct connection *pc, const struct packet_city_sell *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_SELL].packet != NULL, -1,
                        "Handler for PACKET_CITY_SELL not installed");
  return pc->phs.handlers->send[PACKET_CITY_SELL].packet(pc, packet);
}

int dsend_packet_city_sell(struct connection *pc, int city_id16, int city_id32, int build_id)
{
  struct packet_city_sell packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  real_packet->build_id = build_id;
  
  return send_packet_city_sell(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_buy_100 hash_const

#define cmp_packet_city_buy_100 cmp_const

BV_DEFINE(packet_city_buy_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_buy *receive_packet_city_buy_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_buy_100_fields fields;
  struct packet_city_buy *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_BUY;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_buy, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }

#endif
  log_packet_detailed("packet_city_buy_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_100, cmp_packet_city_buy_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_buy_100(struct connection *pc, const struct packet_city_buy *packet)
{
  const struct packet_city_buy *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_buy_100_fields fields;
  struct packet_city_buy *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_BUY;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_BUY);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_buy_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_100, cmp_packet_city_buy_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);

#endif
  SEND_PACKET_END(PACKET_CITY_BUY);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_buy_101 hash_const

#define cmp_packet_city_buy_101 cmp_const

BV_DEFINE(packet_city_buy_101_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_buy *receive_packet_city_buy_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_buy_101_fields fields;
  struct packet_city_buy *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_BUY;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_buy, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }

#endif
  log_packet_detailed("packet_city_buy_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_101, cmp_packet_city_buy_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_buy_101(struct connection *pc, const struct packet_city_buy *packet)
{
  const struct packet_city_buy *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_buy_101_fields fields;
  struct packet_city_buy *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_BUY;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_BUY);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_buy_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_101, cmp_packet_city_buy_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);

#endif
  SEND_PACKET_END(PACKET_CITY_BUY);
}

int send_packet_city_buy(struct connection *pc, const struct packet_city_buy *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_BUY].packet != NULL, -1,
                        "Handler for PACKET_CITY_BUY not installed");
  return pc->phs.handlers->send[PACKET_CITY_BUY].packet(pc, packet);
}

int dsend_packet_city_buy(struct connection *pc, int city_id16, int city_id32)
{
  struct packet_city_buy packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  
  return send_packet_city_buy(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_change_100 hash_const

#define cmp_packet_city_change_100 cmp_const

BV_DEFINE(packet_city_change_100_fields, 3);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_change *receive_packet_city_change_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_change_100_fields fields;
  struct packet_city_change *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_CHANGE;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_change, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(production_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
    RECEIVE_PACKET_FIELD_ERROR(production_value);
  }

#endif
  log_packet_detailed("packet_city_change_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_100, cmp_packet_city_change_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'production_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'production_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_100(struct connection *pc, const struct packet_city_change *packet)
{
  const struct packet_city_change *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_change_100_fields fields;
  struct packet_city_change *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_CHANGE);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_change_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_100, cmp_packet_city_change_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    BV_SET(fields, 2);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'production_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'production_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);

#endif
  SEND_PACKET_END(PACKET_CITY_CHANGE);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_change_101 hash_const

#define cmp_packet_city_change_101 cmp_const

BV_DEFINE(packet_city_change_101_fields, 3);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_change *receive_packet_city_change_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_change_101_fields fields;
  struct packet_city_change *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_CHANGE;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_change, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(production_kind);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
    RECEIVE_PACKET_FIELD_ERROR(production_value);
  }

#endif
  log_packet_detailed("packet_city_change_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_101, cmp_packet_city_change_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'production_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'production_value'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "production_value";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_101(struct connection *pc, const struct packet_city_change *packet)
{
  const struct packet_city_change *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_change_101_fields fields;
  struct packet_city_change *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_CHANGE);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_change_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_101, cmp_packet_city_change_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    BV_SET(fields, 2);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'production_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'production_value' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_kind);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "production_value";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->production_value);

#endif
  SEND_PACKET_END(PACKET_CITY_CHANGE);
}

int send_packet_city_change(struct connection *pc, const struct packet_city_change *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_CHANGE].packet != NULL, -1,
                        "Handler for PACKET_CITY_CHANGE not installed");
  return pc->phs.handlers->send[PACKET_CITY_CHANGE].packet(pc, packet);
}

int dsend_packet_city_change(struct connection *pc, int city_id16, int city_id32, int production_kind, int production_value)
{
  struct packet_city_change packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  real_packet->production_kind = production_kind;
  real_packet->production_value = production_value;
  
  return send_packet_city_change(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_worklist_100 hash_const

#define cmp_packet_city_worklist_100 cmp_const

BV_DEFINE(packet_city_worklist_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_worklist *receive_packet_city_worklist_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_worklist_100_fields fields;
  struct packet_city_worklist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_WORKLIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_worklist, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
    RECEIVE_PACKET_FIELD_ERROR(worklist);
  }

#endif
  log_packet_detailed("packet_city_worklist_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_100, cmp_packet_city_worklist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worklist'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "worklist";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_worklist_100(struct connection *pc, const struct packet_city_worklist *packet)
{
  const struct packet_city_worklist *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_worklist_100_fields fields;
  struct packet_city_worklist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_WORKLIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_WORKLIST);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_worklist_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_100, cmp_packet_city_worklist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worklist' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);

#endif
  SEND_PACKET_END(PACKET_CITY_WORKLIST);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_worklist_101 hash_const

#define cmp_packet_city_worklist_101 cmp_const

BV_DEFINE(packet_city_worklist_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_worklist *receive_packet_city_worklist_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_worklist_101_fields fields;
  struct packet_city_worklist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_WORKLIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_worklist, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
    RECEIVE_PACKET_FIELD_ERROR(worklist);
  }

#endif
  log_packet_detailed("packet_city_worklist_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_101, cmp_packet_city_worklist_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worklist'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "worklist";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(worklist, &din, &field_addr, &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_worklist_101(struct connection *pc, const struct packet_city_worklist *packet)
{
  const struct packet_city_worklist *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_worklist_101_fields fields;
  struct packet_city_worklist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_WORKLIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_WORKLIST);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_worklist_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_101, cmp_packet_city_worklist_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worklist' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "worklist";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(worklist, &dout, &field_addr, &real_packet->worklist);

#endif
  SEND_PACKET_END(PACKET_CITY_WORKLIST);
}

int send_packet_city_worklist(struct connection *pc, const struct packet_city_worklist *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_WORKLIST].packet != NULL, -1,
                        "Handler for PACKET_CITY_WORKLIST not installed");
  return pc->phs.handlers->send[PACKET_CITY_WORKLIST].packet(pc, packet);
}

int dsend_packet_city_worklist(struct connection *pc, int city_id16, int city_id32, const struct worklist *worklist)
{
  struct packet_city_worklist packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  worklist_copy(&real_packet->worklist, worklist);
  
  return send_packet_city_worklist(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_make_specialist_100 hash_const

#define cmp_packet_city_make_specialist_100 cmp_const

BV_DEFINE(packet_city_make_specialist_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_make_specialist *receive_packet_city_make_specialist_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_make_specialist_100_fields fields;
  struct packet_city_make_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_MAKE_SPECIALIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_make_specialist, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
    RECEIVE_PACKET_FIELD_ERROR(tile_id);
  }

#endif
  log_packet_detailed("packet_city_make_specialist_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_100, cmp_packet_city_make_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(tile_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_specialist_100(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  const struct packet_city_make_specialist *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_make_specialist_100_fields fields;
  struct packet_city_make_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_SPECIALIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_MAKE_SPECIALIST);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_make_specialist_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_100, cmp_packet_city_make_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->tile_id != real_packet->tile_id);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);

#endif
  SEND_PACKET_END(PACKET_CITY_MAKE_SPECIALIST);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_make_specialist_101 hash_const

#define cmp_packet_city_make_specialist_101 cmp_const

BV_DEFINE(packet_city_make_specialist_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_make_specialist *receive_packet_city_make_specialist_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_make_specialist_101_fields fields;
  struct packet_city_make_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_MAKE_SPECIALIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_make_specialist, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
    RECEIVE_PACKET_FIELD_ERROR(tile_id);
  }

#endif
  log_packet_detailed("packet_city_make_specialist_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_101, cmp_packet_city_make_specialist_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(tile_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_specialist_101(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  const struct packet_city_make_specialist *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_make_specialist_101_fields fields;
  struct packet_city_make_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_SPECIALIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_MAKE_SPECIALIST);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_make_specialist_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_101, cmp_packet_city_make_specialist_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->tile_id != real_packet->tile_id);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);

#endif
  SEND_PACKET_END(PACKET_CITY_MAKE_SPECIALIST);
}

int send_packet_city_make_specialist(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_MAKE_SPECIALIST].packet != NULL, -1,
                        "Handler for PACKET_CITY_MAKE_SPECIALIST not installed");
  return pc->phs.handlers->send[PACKET_CITY_MAKE_SPECIALIST].packet(pc, packet);
}

int dsend_packet_city_make_specialist(struct connection *pc, int city_id16, int city_id32, int tile_id)
{
  struct packet_city_make_specialist packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  real_packet->tile_id = tile_id;
  
  return send_packet_city_make_specialist(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_make_worker_100 hash_const

#define cmp_packet_city_make_worker_100 cmp_const

BV_DEFINE(packet_city_make_worker_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_make_worker *receive_packet_city_make_worker_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_make_worker_100_fields fields;
  struct packet_city_make_worker *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_MAKE_WORKER;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_make_worker, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
    RECEIVE_PACKET_FIELD_ERROR(tile_id);
  }

#endif
  log_packet_detailed("packet_city_make_worker_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_100, cmp_packet_city_make_worker_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(tile_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_worker_100(struct connection *pc, const struct packet_city_make_worker *packet)
{
  const struct packet_city_make_worker *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_make_worker_100_fields fields;
  struct packet_city_make_worker *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_WORKER;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_MAKE_WORKER);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_make_worker_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_100, cmp_packet_city_make_worker_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->tile_id != real_packet->tile_id);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);

#endif
  SEND_PACKET_END(PACKET_CITY_MAKE_WORKER);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_make_worker_101 hash_const

#define cmp_packet_city_make_worker_101 cmp_const

BV_DEFINE(packet_city_make_worker_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_make_worker *receive_packet_city_make_worker_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_make_worker_101_fields fields;
  struct packet_city_make_worker *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_MAKE_WORKER;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_make_worker, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
    RECEIVE_PACKET_FIELD_ERROR(tile_id);
  }

#endif
  log_packet_detailed("packet_city_make_worker_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_101, cmp_packet_city_make_worker_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(tile_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_worker_101(struct connection *pc, const struct packet_city_make_worker *packet)
{
  const struct packet_city_make_worker *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_make_worker_101_fields fields;
  struct packet_city_make_worker *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_WORKER;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_MAKE_WORKER);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_make_worker_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_101, cmp_packet_city_make_worker_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->tile_id != real_packet->tile_id);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);

#endif
  SEND_PACKET_END(PACKET_CITY_MAKE_WORKER);
}

int send_packet_city_make_worker(struct connection *pc, const struct packet_city_make_worker *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_MAKE_WORKER].packet != NULL, -1,
                        "Handler for PACKET_CITY_MAKE_WORKER not installed");
  return pc->phs.handlers->send[PACKET_CITY_MAKE_WORKER].packet(pc, packet);
}

int dsend_packet_city_make_worker(struct connection *pc, int city_id16, int city_id32, int tile_id)
{
  struct packet_city_make_worker packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  real_packet->tile_id = tile_id;
  
  return send_packet_city_make_worker(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_change_specialist_100 hash_const

#define cmp_packet_city_change_specialist_100 cmp_const

BV_DEFINE(packet_city_change_specialist_100_fields, 3);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_change_specialist *receive_packet_city_change_specialist_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_change_specialist_100_fields fields;
  struct packet_city_change_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_CHANGE_SPECIALIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_change_specialist, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "from";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(from);
    }
    real_packet->from = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "to";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(to);
    }
    real_packet->to = readin;
  }

#endif
  log_packet_detailed("packet_city_change_specialist_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_100, cmp_packet_city_change_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'from'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "from";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(from);
      }
      real_packet->from = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'to'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "to";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(to);
      }
      real_packet->to = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_specialist_100(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  const struct packet_city_change_specialist *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_change_specialist_100_fields fields;
  struct packet_city_change_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE_SPECIALIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_CHANGE_SPECIALIST);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_change_specialist_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_100, cmp_packet_city_change_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->from != real_packet->from);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->to != real_packet->to);
  if (differ) {
    BV_SET(fields, 2);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'from' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "from";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->from);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'to' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "to";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->to);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "from";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->from);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "to";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->to);

#endif
  SEND_PACKET_END(PACKET_CITY_CHANGE_SPECIALIST);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_change_specialist_101 hash_const

#define cmp_packet_city_change_specialist_101 cmp_const

BV_DEFINE(packet_city_change_specialist_101_fields, 3);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_change_specialist *receive_packet_city_change_specialist_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_change_specialist_101_fields fields;
  struct packet_city_change_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_CHANGE_SPECIALIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_change_specialist, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "from";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(from);
    }
    real_packet->from = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "to";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(to);
    }
    real_packet->to = readin;
  }

#endif
  log_packet_detailed("packet_city_change_specialist_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_101, cmp_packet_city_change_specialist_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'from'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "from";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(from);
      }
      real_packet->from = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'to'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "to";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(to);
      }
      real_packet->to = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_specialist_101(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  const struct packet_city_change_specialist *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_change_specialist_101_fields fields;
  struct packet_city_change_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE_SPECIALIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_CHANGE_SPECIALIST);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_change_specialist_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_101, cmp_packet_city_change_specialist_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->from != real_packet->from);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->to != real_packet->to);
  if (differ) {
    BV_SET(fields, 2);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'from' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "from";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->from);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'to' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "to";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->to);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "from";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->from);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "to";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->to);

#endif
  SEND_PACKET_END(PACKET_CITY_CHANGE_SPECIALIST);
}

int send_packet_city_change_specialist(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_CHANGE_SPECIALIST].packet != NULL, -1,
                        "Handler for PACKET_CITY_CHANGE_SPECIALIST not installed");
  return pc->phs.handlers->send[PACKET_CITY_CHANGE_SPECIALIST].packet(pc, packet);
}

int dsend_packet_city_change_specialist(struct connection *pc, int city_id16, int city_id32, Specialist_type_id from, Specialist_type_id to)
{
  struct packet_city_change_specialist packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  real_packet->from = from;
  real_packet->to = to;
  
  return send_packet_city_change_specialist(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_rename_100 hash_const

#define cmp_packet_city_rename_100 cmp_const

BV_DEFINE(packet_city_rename_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_rename *receive_packet_city_rename_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_rename_100_fields fields;
  struct packet_city_rename *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_RENAME;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_rename, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_rename_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_100, cmp_packet_city_rename_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_rename_100(struct connection *pc, const struct packet_city_rename *packet)
{
  const struct packet_city_rename *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_rename_100_fields fields;
  struct packet_city_rename *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_RENAME;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_RENAME);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_rename_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_100, cmp_packet_city_rename_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_RENAME);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_rename_101 hash_const

#define cmp_packet_city_rename_101 cmp_const

BV_DEFINE(packet_city_rename_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_rename *receive_packet_city_rename_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_rename_101_fields fields;
  struct packet_city_rename *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_RENAME;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_rename, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_rename_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_101, cmp_packet_city_rename_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_rename_101(struct connection *pc, const struct packet_city_rename *packet)
{
  const struct packet_city_rename *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_rename_101_fields fields;
  struct packet_city_rename *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_RENAME;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_RENAME);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_rename_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_101, cmp_packet_city_rename_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_RENAME);
}

int send_packet_city_rename(struct connection *pc, const struct packet_city_rename *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_RENAME].packet != NULL, -1,
                        "Handler for PACKET_CITY_RENAME not installed");
  return pc->phs.handlers->send[PACKET_CITY_RENAME].packet(pc, packet);
}

int dsend_packet_city_rename(struct connection *pc, int city_id16, int city_id32, const char *name)
{
  struct packet_city_rename packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_city_rename(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_options_req_100 hash_const

#define cmp_packet_city_options_req_100 cmp_const

BV_DEFINE(packet_city_options_req_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_options_req *receive_packet_city_options_req_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_options_req_100_fields fields;
  struct packet_city_options_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_OPTIONS_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_options_req, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "options";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->options)) {
    RECEIVE_PACKET_FIELD_ERROR(options);
  }

#endif
  log_packet_detailed("packet_city_options_req_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_100, cmp_packet_city_options_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'options'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "options";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->options)) {
      RECEIVE_PACKET_FIELD_ERROR(options);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_options_req_100(struct connection *pc, const struct packet_city_options_req *packet)
{
  const struct packet_city_options_req *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_options_req_100_fields fields;
  struct packet_city_options_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_OPTIONS_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_OPTIONS_REQ);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_options_req_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_100, cmp_packet_city_options_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = !BV_ARE_EQUAL(old->options, real_packet->options);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'options' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->options);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->options);

#endif
  SEND_PACKET_END(PACKET_CITY_OPTIONS_REQ);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_options_req_101 hash_const

#define cmp_packet_city_options_req_101 cmp_const

BV_DEFINE(packet_city_options_req_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_options_req *receive_packet_city_options_req_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_options_req_101_fields fields;
  struct packet_city_options_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_OPTIONS_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_options_req, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "options";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->options)) {
    RECEIVE_PACKET_FIELD_ERROR(options);
  }

#endif
  log_packet_detailed("packet_city_options_req_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_101, cmp_packet_city_options_req_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'options'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "options";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->options)) {
      RECEIVE_PACKET_FIELD_ERROR(options);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_options_req_101(struct connection *pc, const struct packet_city_options_req *packet)
{
  const struct packet_city_options_req *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_options_req_101_fields fields;
  struct packet_city_options_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_OPTIONS_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_OPTIONS_REQ);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_options_req_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_101, cmp_packet_city_options_req_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = !BV_ARE_EQUAL(old->options, real_packet->options);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'options' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->options);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "options";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->options);

#endif
  SEND_PACKET_END(PACKET_CITY_OPTIONS_REQ);
}

int send_packet_city_options_req(struct connection *pc, const struct packet_city_options_req *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_OPTIONS_REQ].packet != NULL, -1,
                        "Handler for PACKET_CITY_OPTIONS_REQ not installed");
  return pc->phs.handlers->send[PACKET_CITY_OPTIONS_REQ].packet(pc, packet);
}

int dsend_packet_city_options_req(struct connection *pc, int city_id16, int city_id32, bv_city_options options)
{
  struct packet_city_options_req packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  real_packet->options = options;
  
  return send_packet_city_options_req(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_refresh_100 hash_const

#define cmp_packet_city_refresh_100 cmp_const

BV_DEFINE(packet_city_refresh_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_refresh *receive_packet_city_refresh_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_refresh_100_fields fields;
  struct packet_city_refresh *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_REFRESH;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_refresh, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }

#endif
  log_packet_detailed("packet_city_refresh_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_100, cmp_packet_city_refresh_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_refresh_100(struct connection *pc, const struct packet_city_refresh *packet)
{
  const struct packet_city_refresh *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_refresh_100_fields fields;
  struct packet_city_refresh *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REFRESH;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_REFRESH);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_refresh_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_100, cmp_packet_city_refresh_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);

#endif
  SEND_PACKET_END(PACKET_CITY_REFRESH);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_refresh_101 hash_const

#define cmp_packet_city_refresh_101 cmp_const

BV_DEFINE(packet_city_refresh_101_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_refresh *receive_packet_city_refresh_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_refresh_101_fields fields;
  struct packet_city_refresh *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_REFRESH;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_refresh, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }

#endif
  log_packet_detailed("packet_city_refresh_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_101, cmp_packet_city_refresh_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_refresh_101(struct connection *pc, const struct packet_city_refresh *packet)
{
  const struct packet_city_refresh *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_refresh_101_fields fields;
  struct packet_city_refresh *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REFRESH;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_REFRESH);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_refresh_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_101, cmp_packet_city_refresh_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);

#endif
  SEND_PACKET_END(PACKET_CITY_REFRESH);
}

int send_packet_city_refresh(struct connection *pc, const struct packet_city_refresh *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_REFRESH].packet != NULL, -1,
                        "Handler for PACKET_CITY_REFRESH not installed");
  return pc->phs.handlers->send[PACKET_CITY_REFRESH].packet(pc, packet);
}

int dsend_packet_city_refresh(struct connection *pc, int city_id16, int city_id32)
{
  struct packet_city_refresh packet, *real_packet = &packet;

  real_packet->city_id16 = city_id16;
  real_packet->city_id32 = city_id32;
  
  return send_packet_city_refresh(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_name_suggestion_req_100 hash_const

#define cmp_packet_city_name_suggestion_req_100 cmp_const

BV_DEFINE(packet_city_name_suggestion_req_100_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_name_suggestion_req *receive_packet_city_name_suggestion_req_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_name_suggestion_req_100_fields fields;
  struct packet_city_name_suggestion_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NAME_SUGGESTION_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_name_suggestion_req, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->unit_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(unit_id32);
  }

#endif
  log_packet_detailed("packet_city_name_suggestion_req_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_100, cmp_packet_city_name_suggestion_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unit_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->unit_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id32);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_req_100(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  const struct packet_city_name_suggestion_req *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_name_suggestion_req_100_fields fields;
  struct packet_city_name_suggestion_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_REQ);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_name_suggestion_req_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_100, cmp_packet_city_name_suggestion_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->unit_id32 != real_packet->unit_id32);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->unit_id32);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->unit_id32);

#endif
  SEND_PACKET_END(PACKET_CITY_NAME_SUGGESTION_REQ);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_name_suggestion_req_101 hash_const

#define cmp_packet_city_name_suggestion_req_101 cmp_const

BV_DEFINE(packet_city_name_suggestion_req_101_fields, 1);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_name_suggestion_req *receive_packet_city_name_suggestion_req_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_name_suggestion_req_101_fields fields;
  struct packet_city_name_suggestion_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NAME_SUGGESTION_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_name_suggestion_req, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->unit_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(unit_id16);
  }

#endif
  log_packet_detailed("packet_city_name_suggestion_req_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_101, cmp_packet_city_name_suggestion_req_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unit_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->unit_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id16);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_req_101(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  const struct packet_city_name_suggestion_req *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_name_suggestion_req_101_fields fields;
  struct packet_city_name_suggestion_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_REQ;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_REQ);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_name_suggestion_req_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_101, cmp_packet_city_name_suggestion_req_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->unit_id16 != real_packet->unit_id16);
  if (differ) {
    BV_SET(fields, 0);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->unit_id16);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->unit_id16);

#endif
  SEND_PACKET_END(PACKET_CITY_NAME_SUGGESTION_REQ);
}

int send_packet_city_name_suggestion_req(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_NAME_SUGGESTION_REQ].packet != NULL, -1,
                        "Handler for PACKET_CITY_NAME_SUGGESTION_REQ not installed");
  return pc->phs.handlers->send[PACKET_CITY_NAME_SUGGESTION_REQ].packet(pc, packet);
}

int dsend_packet_city_name_suggestion_req(struct connection *pc, int unit_id16, int unit_id32)
{
  struct packet_city_name_suggestion_req packet, *real_packet = &packet;

  real_packet->unit_id16 = unit_id16;
  real_packet->unit_id32 = unit_id32;
  
  return send_packet_city_name_suggestion_req(pc, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_name_suggestion_info_100 hash_const

#define cmp_packet_city_name_suggestion_info_100 cmp_const

BV_DEFINE(packet_city_name_suggestion_info_100_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_name_suggestion_info *receive_packet_city_name_suggestion_info_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_name_suggestion_info_100_fields fields;
  struct packet_city_name_suggestion_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NAME_SUGGESTION_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_name_suggestion_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->unit_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(unit_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_name_suggestion_info_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_100, cmp_packet_city_name_suggestion_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unit_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->unit_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_info_100(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  const struct packet_city_name_suggestion_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_name_suggestion_info_100_fields fields;
  struct packet_city_name_suggestion_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_name_suggestion_info_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_100, cmp_packet_city_name_suggestion_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->unit_id32 != real_packet->unit_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->unit_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->unit_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_NAME_SUGGESTION_INFO);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_name_suggestion_info_101 hash_const

#define cmp_packet_city_name_suggestion_info_101 cmp_const

BV_DEFINE(packet_city_name_suggestion_info_101_fields, 2);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_name_suggestion_info *receive_packet_city_name_suggestion_info_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_name_suggestion_info_101_fields fields;
  struct packet_city_name_suggestion_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NAME_SUGGESTION_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_name_suggestion_info, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->unit_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(unit_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
    RECEIVE_PACKET_FIELD_ERROR(name);
  }

#endif
  log_packet_detailed("packet_city_name_suggestion_info_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_101, cmp_packet_city_name_suggestion_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "unit_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->unit_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "name";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(estring, &din, &field_addr, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_info_101(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  const struct packet_city_name_suggestion_info *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_name_suggestion_info_101_fields fields;
  struct packet_city_name_suggestion_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_INFO;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_INFO);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_name_suggestion_info_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_101, cmp_packet_city_name_suggestion_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->unit_id16 != real_packet->unit_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    BV_SET(fields, 1);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->unit_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "unit_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->unit_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "name";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(estring, &dout, &field_addr, real_packet->name);

#endif
  SEND_PACKET_END(PACKET_CITY_NAME_SUGGESTION_INFO);
}

int send_packet_city_name_suggestion_info(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_NAME_SUGGESTION_INFO].packet != NULL, -1,
                        "Handler for PACKET_CITY_NAME_SUGGESTION_INFO not installed");
  return pc->phs.handlers->send[PACKET_CITY_NAME_SUGGESTION_INFO].packet(pc, packet);
}

void lsend_packet_city_name_suggestion_info(struct conn_list *dest, const struct packet_city_name_suggestion_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_name_suggestion_info(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_city_name_suggestion_info(struct connection *pc, int unit_id16, int unit_id32, const char *name)
{
  struct packet_city_name_suggestion_info packet, *real_packet = &packet;

  real_packet->unit_id16 = unit_id16;
  real_packet->unit_id32 = unit_id32;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_city_name_suggestion_info(pc, real_packet);
}

void dlsend_packet_city_name_suggestion_info(struct conn_list *dest, int unit_id16, int unit_id32, const char *name)
{
  struct packet_city_name_suggestion_info packet, *real_packet = &packet;

  real_packet->unit_id16 = unit_id16;
  real_packet->unit_id32 = unit_id32;
  sz_strlcpy(real_packet->name, name);
  
  lsend_packet_city_name_suggestion_info(dest, real_packet);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_sabotage_list_100 hash_const

#define cmp_packet_city_sabotage_list_100 cmp_const

BV_DEFINE(packet_city_sabotage_list_100_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_sabotage_list *receive_packet_city_sabotage_list_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_sabotage_list_100_fields fields;
  struct packet_city_sabotage_list *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SABOTAGE_LIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_sabotage_list, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "actor_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->actor_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(actor_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
    RECEIVE_PACKET_FIELD_ERROR(improvements);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "act_id";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(act_id);
    }
    real_packet->act_id = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "request_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->request_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(request_kind);
  }

#endif
  log_packet_detailed("packet_city_sabotage_list_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_100, cmp_packet_city_sabotage_list_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'actor_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "actor_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->actor_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(actor_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'improvements'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "improvements";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'act_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "act_id";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(act_id);
      }
      real_packet->act_id = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'request_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "request_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->request_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(request_kind);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sabotage_list_100(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  const struct packet_city_sabotage_list *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_sabotage_list_100_fields fields;
  struct packet_city_sabotage_list *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SABOTAGE_LIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_SABOTAGE_LIST);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_sabotage_list_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_100, cmp_packet_city_sabotage_list_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->actor_id32 != real_packet->actor_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->act_id != real_packet->act_id);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->request_kind != real_packet->request_kind);
  if (differ) {
    BV_SET(fields, 4);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'actor_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "actor_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->actor_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'improvements' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'act_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "act_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->act_id);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'request_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "request_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->request_kind);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "actor_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->actor_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "act_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->act_id);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "request_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->request_kind);

#endif
  SEND_PACKET_END(PACKET_CITY_SABOTAGE_LIST);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_sabotage_list_101 hash_const

#define cmp_packet_city_sabotage_list_101 cmp_const

BV_DEFINE(packet_city_sabotage_list_101_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_sabotage_list *receive_packet_city_sabotage_list_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_sabotage_list_101_fields fields;
  struct packet_city_sabotage_list *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SABOTAGE_LIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_sabotage_list, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "actor_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->actor_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(actor_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
    RECEIVE_PACKET_FIELD_ERROR(improvements);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "act_id";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(act_id);
    }
    real_packet->act_id = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "request_kind";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint8, &din, &field_addr, &real_packet->request_kind)) {
    RECEIVE_PACKET_FIELD_ERROR(request_kind);
  }

#endif
  log_packet_detailed("packet_city_sabotage_list_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_101, cmp_packet_city_sabotage_list_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'actor_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "actor_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->actor_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(actor_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'improvements'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "improvements";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_BV_GET(&din, &field_addr, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'act_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "act_id";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(act_id);
      }
      real_packet->act_id = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'request_kind'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "request_kind";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint8, &din, &field_addr, &real_packet->request_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(request_kind);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sabotage_list_101(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  const struct packet_city_sabotage_list *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_sabotage_list_101_fields fields;
  struct packet_city_sabotage_list *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SABOTAGE_LIST;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_SABOTAGE_LIST);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_sabotage_list_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_101, cmp_packet_city_sabotage_list_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->actor_id16 != real_packet->actor_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->act_id != real_packet->act_id);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->request_kind != real_packet->request_kind);
  if (differ) {
    BV_SET(fields, 4);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'actor_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "actor_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->actor_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'improvements' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'act_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "act_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->act_id);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'request_kind' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "request_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->request_kind);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "actor_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->actor_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "improvements";
#endif /* FREECIV_JSON_CONNECTION */
DIO_BV_PUT(&dout, &field_addr, packet->improvements);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "act_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->act_id);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "request_kind";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->request_kind);

#endif
  SEND_PACKET_END(PACKET_CITY_SABOTAGE_LIST);
}

int send_packet_city_sabotage_list(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_SABOTAGE_LIST].packet != NULL, -1,
                        "Handler for PACKET_CITY_SABOTAGE_LIST not installed");
  return pc->phs.handlers->send[PACKET_CITY_SABOTAGE_LIST].packet(pc, packet);
}

void lsend_packet_city_sabotage_list(struct conn_list *dest, const struct packet_city_sabotage_list *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_sabotage_list(pconn, packet);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_rally_point_100 hash_const

#define cmp_packet_city_rally_point_100 cmp_const

BV_DEFINE(packet_city_rally_point_100_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_rally_point *receive_packet_city_rally_point_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_rally_point_100_fields fields;
  struct packet_city_rally_point *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_RALLY_POINT;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_rally_point, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "length";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->length)) {
    RECEIVE_PACKET_FIELD_ERROR(length);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "persistent";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->persistent)) {
    RECEIVE_PACKET_FIELD_ERROR(persistent);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "vigilant";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->vigilant)) {
    RECEIVE_PACKET_FIELD_ERROR(vigilant);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "orders";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->length > MAX_LEN_ROUTE) {
      RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
    }
    for (i = 0; i < real_packet->length; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(unit_order, &din, &field_addr, &real_packet->orders[i])) {
        RECEIVE_PACKET_FIELD_ERROR(orders);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }

#endif
  log_packet_detailed("packet_city_rally_point_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rally_point_100, cmp_packet_city_rally_point_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'length'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "length";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->length)) {
      RECEIVE_PACKET_FIELD_ERROR(length);
    }
  }
  real_packet->persistent = BV_ISSET(fields, 2);
  real_packet->vigilant = BV_ISSET(fields, 3);
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'orders'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "orders";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(unit_order, &din, &field_addr, &real_packet->orders[i])) {
          RECEIVE_PACKET_FIELD_ERROR(orders);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_rally_point_100(struct connection *pc, const struct packet_city_rally_point *packet, bool force_to_send)
{
  const struct packet_city_rally_point *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_rally_point_100_fields fields;
  struct packet_city_rally_point *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_RALLY_POINT;
  int different = force_to_send;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_RALLY_POINT);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_rally_point_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rally_point_100, cmp_packet_city_rally_point_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->length != real_packet->length);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->persistent != real_packet->persistent);
  if (differ) {
    different++;
  }
  if (packet->persistent) {
    BV_SET(fields, 2);
  }

  differ = (old->vigilant != real_packet->vigilant);
  if (differ) {
    different++;
  }
  if (packet->vigilant) {
    BV_SET(fields, 3);
  }


    {
      differ = (old->length != real_packet->length);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->length; i++) {
          if (!are_unit_orders_equal(&old->orders[i], &real_packet->orders[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'length' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "length";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->length);
  }
  /* field 2 is folded into the header */
  /* field 3 is folded into the header */
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'orders' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "orders";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->length);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->length; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(unit_order, &dout, &field_addr, &real_packet->orders[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "length";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->length);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "persistent";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->persistent);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "vigilant";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->vigilant);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "orders";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->length);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->length; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(unit_order, &dout, &field_addr, &real_packet->orders[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }

#endif
  SEND_PACKET_END(PACKET_CITY_RALLY_POINT);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_city_rally_point_101 hash_const

#define cmp_packet_city_rally_point_101 cmp_const

BV_DEFINE(packet_city_rally_point_101_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_city_rally_point *receive_packet_city_rally_point_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_rally_point_101_fields fields;
  struct packet_city_rally_point *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_RALLY_POINT;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_city_rally_point, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "length";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->length)) {
    RECEIVE_PACKET_FIELD_ERROR(length);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "persistent";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->persistent)) {
    RECEIVE_PACKET_FIELD_ERROR(persistent);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "vigilant";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(bool8, &din, &field_addr, &real_packet->vigilant)) {
    RECEIVE_PACKET_FIELD_ERROR(vigilant);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "orders";
  #endif /* FREECIV_JSON_CONNECTION */
  
  {
    int i;
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Enter array. */
    field_addr.sub_location = plocation_elem_new(0);
  #endif /* FREECIV_JSON_CONNECTION */
  
    if (real_packet->length > MAX_LEN_ROUTE) {
      RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
    }
    for (i = 0; i < real_packet->length; i++) {
  #ifdef FREECIV_JSON_CONNECTION
      field_addr.sub_location->number = i;
  #endif /* FREECIV_JSON_CONNECTION */
      if (!DIO_GET(unit_order, &din, &field_addr, &real_packet->orders[i])) {
        RECEIVE_PACKET_FIELD_ERROR(orders);
      }
    }
  
  #ifdef FREECIV_JSON_CONNECTION
    /* Exit array. */
    free(field_addr.sub_location);
    field_addr.sub_location = NULL;
  #endif /* FREECIV_JSON_CONNECTION */
  }

#endif
  log_packet_detailed("packet_city_rally_point_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rally_point_101, cmp_packet_city_rally_point_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'length'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "length";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->length)) {
      RECEIVE_PACKET_FIELD_ERROR(length);
    }
  }
  real_packet->persistent = BV_ISSET(fields, 2);
  real_packet->vigilant = BV_ISSET(fields, 3);
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'orders'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "orders";
    #endif /* FREECIV_JSON_CONNECTION */
    
    {
      int i;
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Enter array. */
      field_addr.sub_location = plocation_elem_new(0);
    #endif /* FREECIV_JSON_CONNECTION */
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
    #ifdef FREECIV_JSON_CONNECTION
        field_addr.sub_location->number = i;
    #endif /* FREECIV_JSON_CONNECTION */
        if (!DIO_GET(unit_order, &din, &field_addr, &real_packet->orders[i])) {
          RECEIVE_PACKET_FIELD_ERROR(orders);
        }
      }
    
    #ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
    #endif /* FREECIV_JSON_CONNECTION */
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_rally_point_101(struct connection *pc, const struct packet_city_rally_point *packet, bool force_to_send)
{
  const struct packet_city_rally_point *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_city_rally_point_101_fields fields;
  struct packet_city_rally_point *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_RALLY_POINT;
  int different = force_to_send;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_CITY_RALLY_POINT);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_city_rally_point_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rally_point_101, cmp_packet_city_rally_point_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->length != real_packet->length);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->persistent != real_packet->persistent);
  if (differ) {
    different++;
  }
  if (packet->persistent) {
    BV_SET(fields, 2);
  }

  differ = (old->vigilant != real_packet->vigilant);
  if (differ) {
    different++;
  }
  if (packet->vigilant) {
    BV_SET(fields, 3);
  }


    {
      differ = (old->length != real_packet->length);
      if (!differ) {
        int i;

        for (i = 0; i < real_packet->length; i++) {
          if (!are_unit_orders_equal(&old->orders[i], &real_packet->orders[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'length' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "length";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->length);
  }
  /* field 2 is folded into the header */
  /* field 3 is folded into the header */
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'orders' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "orders";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->length);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->length; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(unit_order, &dout, &field_addr, &real_packet->orders[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->city_id16);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "length";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->length);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "persistent";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->persistent);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "vigilant";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(bool8, &dout, &field_addr, real_packet->vigilant);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "orders";
#endif /* FREECIV_JSON_CONNECTION */

    {
      int i;

#ifdef FREECIV_JSON_CONNECTION
      /* Create the array. */
      DIO_PUT(farray, &dout, &field_addr, real_packet->length);

      /* Enter the array. */
      field_addr.sub_location = plocation_elem_new(0);
#endif /* FREECIV_JSON_CONNECTION */

      for (i = 0; i < real_packet->length; i++) {
#ifdef FREECIV_JSON_CONNECTION
        /* Next array element. */
        field_addr.sub_location->number = i;
#endif /* FREECIV_JSON_CONNECTION */
        DIO_PUT(unit_order, &dout, &field_addr, &real_packet->orders[i]);
      }

#ifdef FREECIV_JSON_CONNECTION
      /* Exit array. */
      free(field_addr.sub_location);
      field_addr.sub_location = NULL;
#endif /* FREECIV_JSON_CONNECTION */
    }

#endif
  SEND_PACKET_END(PACKET_CITY_RALLY_POINT);
}

int send_packet_city_rally_point(struct connection *pc, const struct packet_city_rally_point *packet, bool force_to_send)
{
  if (!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_RALLY_POINT].force_to_send != NULL, -1,
                        "Handler for PACKET_CITY_RALLY_POINT not installed");
  return pc->phs.handlers->send[PACKET_CITY_RALLY_POINT].force_to_send(pc, packet, force_to_send);
}

void lsend_packet_city_rally_point(struct conn_list *dest, const struct packet_city_rally_point *packet, bool force_to_send)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_rally_point(pconn, packet, force_to_send);
  } conn_list_iterate_end;
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_worker_task_100 hash_const

#define cmp_packet_worker_task_100 cmp_const

BV_DEFINE(packet_worker_task_100_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_worker_task *receive_packet_worker_task_100(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_worker_task_100_fields fields;
  struct packet_worker_task *old;
  struct genhash **hash = pc->phs.received + PACKET_WORKER_TASK;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_worker_task, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id32);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
    RECEIVE_PACKET_FIELD_ERROR(tile_id);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "activity";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(activity);
    }
    real_packet->activity = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tgt";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->tgt)) {
    RECEIVE_PACKET_FIELD_ERROR(tgt);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "want";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->want)) {
    RECEIVE_PACKET_FIELD_ERROR(want);
  }

#endif
  log_packet_detailed("packet_worker_task_100: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_worker_task_100, cmp_packet_worker_task_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id32'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id32";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint32, &din, &field_addr, &real_packet->city_id32)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id32);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(tile_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'activity'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "activity";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'tgt'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tgt";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->tgt)) {
      RECEIVE_PACKET_FIELD_ERROR(tgt);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'want'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "want";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->want)) {
      RECEIVE_PACKET_FIELD_ERROR(want);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_worker_task_100(struct connection *pc, const struct packet_worker_task *packet)
{
  const struct packet_worker_task *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_worker_task_100_fields fields;
  struct packet_worker_task *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_WORKER_TASK;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_WORKER_TASK);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_worker_task_100: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_worker_task_100, cmp_packet_worker_task_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id32 != real_packet->city_id32);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->tile_id != real_packet->tile_id);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->tgt != real_packet->tgt);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->want != real_packet->want);
  if (differ) {
    BV_SET(fields, 4);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id32' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile_id' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'activity' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "activity";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->activity);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'tgt' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tgt";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->tgt);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'want' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "want";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->want);
  }

  *old = *real_packet;
#endif /* FREECIV_DELTA_PROTOCOL */
#ifndef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id32";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint32, &dout, &field_addr, real_packet->city_id32);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint32, &dout, &field_addr, real_packet->tile_id);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "activity";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint8, &dout, &field_addr, real_packet->activity);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tgt";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(sint8, &dout, &field_addr, real_packet->tgt);
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "want";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_PUT(uint16, &dout, &field_addr, real_packet->want);

#endif
  SEND_PACKET_END(PACKET_WORKER_TASK);
}

#ifdef FREECIV_DELTA_PROTOCOL
#define hash_packet_worker_task_101 hash_const

#define cmp_packet_worker_task_101 cmp_const

BV_DEFINE(packet_worker_task_101_fields, 5);
#endif /* FREECIV_DELTA_PROTOCOL */

static struct packet_worker_task *receive_packet_worker_task_101(struct connection *pc)
{
#ifdef FREECIV_DELTA_PROTOCOL
  packet_worker_task_101_fields fields;
  struct packet_worker_task *old;
  struct genhash **hash = pc->phs.received + PACKET_WORKER_TASK;
#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_START(packet_worker_task, real_packet);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

#ifdef FREECIV_DELTA_PROTOCOL
#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_GET(&din, &field_addr, fields);
  
#else /* FREECIV_DELTA_PROTOCOL */
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "city_id16";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
    RECEIVE_PACKET_FIELD_ERROR(city_id16);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tile_id";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
    RECEIVE_PACKET_FIELD_ERROR(tile_id);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "activity";
  #endif /* FREECIV_JSON_CONNECTION */
  {
    int readin;
  
    if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(activity);
    }
    real_packet->activity = readin;
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "tgt";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(sint8, &din, &field_addr, &real_packet->tgt)) {
    RECEIVE_PACKET_FIELD_ERROR(tgt);
  }
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "want";
  #endif /* FREECIV_JSON_CONNECTION */
  if (!DIO_GET(uint16, &din, &field_addr, &real_packet->want)) {
    RECEIVE_PACKET_FIELD_ERROR(want);
  }

#endif
  log_packet_detailed("packet_worker_task_101: got info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_worker_task_101, cmp_packet_worker_task_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id16'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "city_id16";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->city_id16)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id16);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile_id'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tile_id";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint32, &din, &field_addr, &real_packet->tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(tile_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'activity'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "activity";
    #endif /* FREECIV_JSON_CONNECTION */
    {
      int readin;
    
      if (!DIO_GET(uint8, &din, &field_addr, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'tgt'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "tgt";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(sint8, &din, &field_addr, &real_packet->tgt)) {
      RECEIVE_PACKET_FIELD_ERROR(tgt);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'want'");
    #ifdef FREECIV_JSON_CONNECTION
    field_addr.name = "want";
    #endif /* FREECIV_JSON_CONNECTION */
    if (!DIO_GET(uint16, &din, &field_addr, &real_packet->want)) {
      RECEIVE_PACKET_FIELD_ERROR(want);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

#endif /* FREECIV_DELTA_PROTOCOL */
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_worker_task_101(struct connection *pc, const struct packet_worker_task *packet)
{
  const struct packet_worker_task *real_packet = packet;
#ifdef FREECIV_DELTA_PROTOCOL
  packet_worker_task_101_fields fields;
  struct packet_worker_task *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_WORKER_TASK;
#endif /* FREECIV_DELTA_PROTOCOL */
  SEND_PACKET_START(PACKET_WORKER_TASK);
#ifdef FREECIV_JSON_CONNECTION
  struct plocation field_addr;
  {
    struct plocation *field_addr_tmp = plocation_field_new(NULL);
    field_addr = *field_addr_tmp;
    FC_FREE(field_addr_tmp);
  }
#endif /* FREECIV_JSON_CONNECTION */

  log_packet_detailed("packet_worker_task_101: sending info about ()");

#ifdef FREECIV_DELTA_PROTOCOL
  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_worker_task_101, cmp_packet_worker_task_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
  }
  differ = (old->city_id16 != real_packet->city_id16);
  if (differ) {
    BV_SET(fields, 0);
  }

  differ = (old->tile_id != real_packet->tile_id);
  if (differ) {
    BV_SET(fields, 1);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    BV_SET(fields, 2);
  }

  differ = (old->tgt != real_packet->tgt);
  if (differ) {
    BV_SET(fields, 3);
  }

  differ = (old->want != real_packet->want);
  if (differ) {
    BV_SET(fields, 4);
  }


#ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "fields";
#endif /* FREECIV_JSON_CONNECTION */
  DIO_BV_PUT(&dout, &field_addr, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id16' has changed");
  #ifdef FREECIV_JSON_CONNECTION
  field_addr.name = "cit