/*===========================================================================*
 *                                                                           *
 *  smthead.h - Header for generated smt3.h                                  *
 *                                                                           *
 *  Copyright (c) 1991-2010 iMatix Corporation                               *
 *                                                                           *
 *  ------------------ GPL Licensed Source Code ------------------           *
 *  iMatix makes this software available under the GNU General               *
 *  Public License (GPL) license for open source projects.  For              *
 *  details of the GPL license please see www.gnu.org or read the            *
 *  file license.gpl provided in this package.                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License as           *
 *  published by the Free Software Foundation; either version 3 of           *
 *  the License, or (at your option) any later version.                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public                *
 *  License along with this program in the file 'license.gpl'; if            *
 *  not, see <http://www.gnu.org/licenses/>.                                 *
 *                                                                           *
 *  You can also license this software under iMatix's General Terms          *
 *  of Business (GTB) for commercial projects.  If you have not              *
 *  explicitly licensed this software under the iMatix GTB you may           *
 *  only use it under the terms of the GNU General Public License.           *
 *                                                                           *
 *  For more information, send an email to info@imatix.com.                  *
 *  --------------------------------------------------------------           *
 *===========================================================================*/
/*  ----------------------------------------------------------------<Prolog>-
    Synopsis:   This header file is GENERATED by the Boom installer.  DO NOT
                MODIFY THIS FILE.  If you change any of the SMT header files,
                re-run boomake to recreate this file.
 ------------------------------------------------------------------</Prolog>-*/
/*===========================================================================*
 *                                                                           *
 *  smtlib.h - SMT kernel prototypes                                         *
 *                                                                           *
 *  Copyright (c) 1991-2010 iMatix Corporation                               *
 *                                                                           *
 *  ------------------ GPL Licensed Source Code ------------------           *
 *  iMatix makes this software available under the GNU General               *
 *  Public License (GPL) license for open source projects.  For              *
 *  details of the GPL license please see www.gnu.org or read the            *
 *  file license.gpl provided in this package.                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License as           *
 *  published by the Free Software Foundation; either version 3 of           *
 *  the License, or (at your option) any later version.                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public                *
 *  License along with this program in the file 'license.gpl'; if            *
 *  not, see <http://www.gnu.org/licenses/>.                                 *
 *                                                                           *
 *  You can also license this software under iMatix's General Terms          *
 *  of Business (GTB) for commercial projects.  If you have not              *
 *  explicitly licensed this software under the iMatix GTB you may           *
 *  only use it under the terms of the GNU General Public License.           *
 *                                                                           *
 *  For more information, send an email to info@imatix.com.                  *
 *  --------------------------------------------------------------           *
 *===========================================================================*/

#ifndef _SMTLIB_INCLUDED                /*  Allow multiple inclusions        */
#define _SMTLIB_INCLUDED



/*---------------------------------------------------------------------------
 *  Structures used by the SMT API
 */

typedef struct _AGENT       AGENT;      /*  Agent descriptor                 */
typedef struct _METHOD      METHOD;     /*  Method descriptor                */
typedef struct _QID         QID;        /*  Queue ID descriptor              */
typedef struct _QUEUE       QUEUE;      /*  Queue descriptor                 */
typedef struct _EVENT       EVENT;      /*  Event descriptor                 */
typedef struct _LR_LOCATION LR_LOCATION;/*  Dialog location descriptor       */
typedef struct _THREAD      THREAD;     /*  Thread descriptor                */
typedef struct _SEMAPH      SEMAPH;     /*  Semaphore descriptor             */
typedef struct _ASYNC       ASYNC;      /*  Asynchronous descriptor          */
typedef struct _POLL        POLL;       /*  Polling descriptor               */


/*---------------------------------------------------------------------------
 *  Type definitions
 */

typedef short int event_t;              /*  Dialog FSM event type            */
typedef short int state_t;              /*  Dialog FSM state type            */
typedef void  (HOOK)  (THREAD *);       /*  Agent thread function            */

/*  Asynchronous functions enable an asynchronous interface to an agent.     */
/*  They are typically used for timeouts, and background processing.         */
/*  They set the arguments next_date and next_time to the moment when this   */
/*  thread next needs asynchronous attention.  If they don't need any such   */
/*  attention at any particular time soon they set the date to 99999999.     */
/*  Threads that require "immediate" attention, for polling for things,      */
/*  should using the polling interface (below).  They return one if a thread */
/*  was activated, -1 if an error occured, zero otherwise.                   */
typedef int   (ASYNCFN) (long wait_date,
                         long wait_time,
                         void *arg);

/*  Polling functions enable an "immediate" asynchronous interface to an     */
/*  agent.  They are used for polling for changes in external data, such as  */
/*  the availability of new data from a socket, which needs to be performed  */
/*  frequently, even while other threads are running.  Threads specify an    */
/*  interval in the number of state changes they should be activated, and    */
/*  the polling function will be called after that number of state changes   */
/*  has occurred, then rescheduled after that number of state changes.  The  */
/*  thread can alter the number of state changes it wishes to wait at any    */
/*  point.  When called these polling functions return one if a thread was   */
/*  activated, -1 if an error occured, and zero otherwise.                   */
typedef int   (POLLFN)  (int  state_interval,
                         void *arg);

/*  Execution types.                                                         */

typedef enum {
    SMT_EXEC_STEP,
    SMT_EXEC_NOBLOCK,
    SMT_EXEC_FULL
} SMT_EXEC_TYPE;

/*---------------------------------------------------------------------------
 *  Global variables
 */

extern int
    smt_errno;                          /*  Set when API detects an error    */
extern char
    *smt_errlist [];                    /*  Corresponding error messages     */
extern event_t
    _the_next_event,                    /*  May be set by thread code        */
    _the_external_event,                /*  Set by event_wait()              */
    _the_exception_event;               /*  May be set by thread code        */
extern Bool
    _exception_raised,                  /*  May be set by thread code        */
    _io_completed,                      /*  Last lazy I/O completed          */
    _repeat_module;                     /*  Repeat current action module     */

extern Bool
    signal_raised,                      /*  True after interrupt             */
    shutdown_pending;                   /*  When kill signal in progress     */
extern int
    signal_value;                       /*  Value of signal                  */
extern MEMTRN
    *smt_memtrn_;                       /*  Current transaction              */
extern LR_LOCATION 
    *LR_location_cache;                 /*  Cache for dialog locations       */
    

/*  A agent corresponds to one finite-state-machine, i.e. one program.       */
/*  All agents are linked into a list that is managed by the kernel.         */
/*  For each agent we must:                                                  */
/*      - declare the methods that the agent accepts                         */
/*      - create one or more threads to do the work                          */
/*      - tell the kernel how these threads use their event queues           */

struct _AGENT {                         /*  Agent descriptor                 */
    /*- Public -------------------------                                     */
    AGENT  *next, *prev;                /*    Doubly-linked list             */
    LIST    methods;                    /*    Methods accepted by agent      */
    LIST    queues;                     /*    Queues defined for agent       */
    char   *name;                       /*    Agent's name                   */
    Bool    router;                     /*    True if multi-thread/queue     */
    int     priority;                   /*    50=Low, 100=Normal, 200=High   */
    long    max_threads;                /*    Max. permitted threads, or 0   */
    long    cur_threads;                /*    Current number of threads      */
    long    top_threads;                /*    Max. number threads we had     */
    long    thread_tally;               /*    How many threads created       */
    long    switch_tally;               /*    How many context switches      */
    /*- Private ------------------------                                     */
    SYMBOL *symbol;                     /*    Entry into dictionary          */
    size_t  tcb_size;                   /*    Common tcb size for agent      */
    HOOK   *initialise;                 /*    Initialise-the-thread          */
    word   *LR_nextst;                  /*    Dialog next state table        */
    word   *LR_action;                  /*    Dialog action table            */
    word   *LR_offset;                  /*    Dialog vector offset table     */
    word   *LR_vector;                  /*    Dialog vector table            */
#if (defined (SMT_PROFILE))
    word   *LR_count;                   /*    Module execution count         */
    clock_t *LR_time;                   /*    Total module execution time    */
    word   *LR_flow;                    /*    Dialog flow count              */
#endif
    HOOK  **LR_module;                  /*    Dialog module table            */
    char  **LR_mname;                   /*    Module names, or null          */
    char  **LR_sname;                   /*    State names, or null           */
    char  **LR_ename;                   /*    Event names, or null           */
    event_t LR_defaults;                /*    Defaults state, or zero        */
    int     maxevent;                   /*    Number of events defined       */
    int     maxmodule;                  /*    Number of modules defined      */
    int     maxstate;                   /*    Number of states defined       */
    Bool    animate;                    /*    Animation permitted            */
};

/*  The method descriptor defines all the information for a method declared  */
/*  for an agent.  Methods are linked into a list attached to one agent.     */
/*  Each method points to its parent agent.   The method priority is used    */
/*  to order method event delivery to a agent thread.                        */

struct _METHOD {                        /*  Method descriptor                */
    /*- Public -------------------------                                     */
    METHOD *next, *prev;                /*    Doubly-linked list             */
    AGENT  *agent;                      /*    Parent agent descriptor        */
    char   *name;                       /*    Name of method                 */
    int     priority;                   /*    50=Low, 100=Normal, 200=High   */
    event_t event_number;               /*    Internal event number          */
    /*- Private ------------------------                                     */
    SYMBOL *symbol;                     /*    Entry into dictionary          */
};

/*  The queue ID block is a portable definition of a queue.  We can send     */
/*  this to other parties.  The lookup_queue() function lets us access a     */
/*  queue descriptor given the queue ID.                                     */

struct _QID {                           /*  Queue ID block                   */
    /*- Public -------------------------                                     */
    long node;                          /*    Location of queue (zero)       */
    long ident;                         /*    Queue ID number (1..n)         */
};

/*  The queue descriptor defines all the information for a queue.  Queues    */
/*  are linked into a list attached to one agent.  Each queue points to      */
/*  its parent agent.  Each queue holds a list of events stored in the       */
/*  queue, and a list of threads that can process the queue.  When this      */
/*  list holds more than one thread, events are routed depending on which    */
/*  threads are ready to handle them.                                        */

struct _QUEUE {                         /*  Queue descriptor                 */
    /*- Public -------------------------                                     */
    QUEUE  *next, *prev;                /*    Doubly-linked list             */
    AGENT  *agent;                      /*    Parent agent descriptor        */
    LIST    events;                     /*    Events in queue                */
    LIST    threads;                    /*    Threads for queue              */
    QID     qid;                        /*    Queue ID descriptor            */
    int     max_events;                 /*    Maximum allowed events         */
    int     cur_events;                 /*    Current number of events       */
    /*- Private ------------------------                                     */
    SYMBOL *symbol;                     /*    Entry into dictionary          */
    int     timed_events;               /*    Nbr of events with timeout     */
    Bool    shutdown;                   /*    Shutdown event sent?           */
};

/*  The queued event descriptor defines all the information for a queued     */
/*  event.  Events are linked into a list attached to one queue.  Each       */
/*  event points to its parent queue.                                        */

struct _EVENT {                         /*  Event descriptor                 */
    /*- Public -------------------------                                     */
    EVENT  *next, *prev;                /*    Doubly-linked list             */
    QUEUE  *queue;                      /*    Parent queue descriptor        */
    QID     sender;                     /*    Replies come back here         */
    char   *name;                       /*    Name of event                  */
    size_t  body_size;                  /*    Size of event body in bytes    */
    byte   *body;                       /*    Event body                     */
    char   *accept_event;               /*    Reply if we accept event       */
    char   *reject_event;               /*    Reply if we reject event       */
    char   *expire_event;               /*    Reply if we expire event       */
    time_t  timeout;                    /*    Expires at this time (or 0)    */
    /*- Private ------------------------                                     */
    size_t  size;                       /*    Size of complete event block   */
    int     priority;                   /*    When known from method         */
    event_t event_number;               /*    When known from method         */
};


/*  The location descriptor defines a place in the dialog.  Thread           */
/*  descriptors contain a stack of these.                                    */

struct _LR_LOCATION {                   /*   To store position for           */
    LR_LOCATION *next;                  /*   Dialog-Call/Dialog-Return       */
    state_t state;
    event_t event;
    int     number;
};


/*  The thread descriptor defines all the information for a thread.          */
/*  Threads are linked into a list attached to one queue.  Each thread       */
/*  points to its parent queue.                                              */

struct _THREAD {                        /*  Thread block                     */
    /*- Public -------------------------                                     */
    THREAD  *next, *prev;               /*    Doubly-linked list             */
    QUEUE   *queue;                     /*    Parent queue descriptor        */
    long     thread_id;                 /*    Thread identifier number       */
    char    *name;                      /*    Name of thread                 */
    Bool     animate;                   /*    Animate this thread            */
    void    *tcb;                       /*    Thread context block (TCB)     */
    EVENT   *event;                     /*    Last-received event            */
    MEMTRN  *memtrn;                    /*    Transaction for mem allocat'n  */
    HOOK    *atdestroy;                 /*    Called when thread destroyed   */
    /*- Private ------------------------                                     */
    SYMBOL  *symbol;                    /*    Entry into dictionary          */
    THREAD  *left, *right;              /*    Active/passive linked list     */
    int      state;                     /*    Thread activity state          */
    LR_LOCATION
            *LR_location_stack;         /*    Subdialog stack comes here     */
    event_t  LR_event;                  /*    Event for state transition     */
    state_t  LR_state;                  /*    Current dialog state           */
    word     LR_index;                  /*    Index into LR vector           */
    word     LR_number;                 /*    Number of next module          */
    state_t  LR_savest;                 /*    Saved dialog state             */
    event_t  the_next_event;            /*    Saved the_next_event           */
    event_t  the_external_event;        /*    Saved the_external_event       */
    /* - Loop monitoring stuff --------                                      */
    event_t *loop_event;                /*  Preceding events                 */
    int      loop_index,                /*    Current position in list       */
             loop_length;               /*    Current loop length            */
    long     loop_count;                /*    Event count in current loop    */
};

/*---------------------------------------------------------------------------
*  Function prototypes
 */

#ifdef __cplusplus
extern "C" {
#endif

int      smt_init           (void);
int      smt_term           (void);
int      smt_exec_full      (void);
Bool     smt_exec_step      (void);
Bool     smt_exec           (SMT_EXEC_TYPE exec_type);
Bool     smt_active         (void);
void     smt_set_console    (const QID *qid);
void     smt_set_timer      (const QID *qid);
int      smt_atexit         (function exit_function);
void     smt_shutdown       (void);
char    *smt_crash_report   (void);
void     smt_set_step       (const char *step);

int      schedule_async_nonblock   (ASYNCFN *asyncfn, void *arg, 
                                    int priority, long date, long time);
int      deschedule_async_nonblock (ASYNCFN *asyncfn, void *arg);
void     register_async_blocking   (ASYNCFN *asyncfn, void *arg);

int      schedule_polling_function   (POLLFN  *pollfn,  void *arg,
                                      int poll_interval);
int      deschedule_polling_function (POLLFN *pollfn, void *arg);

AGENT   *agent_declare      (const char *agent_name);
AGENT   *agent_lookup       (const char *agent);
int      agent_destroy      (AGENT *agent);

METHOD  *method_declare     (AGENT *agent, const char *method_name,
                             event_t number, int priority);
METHOD  *method_lookup      (const AGENT *agent, const char *method);
int      method_destroy     (METHOD *method);

QUEUE   *queue_create       (AGENT *agent, int max_events);
QUEUE   *queue_lookup       (const QID *qid);
int      queue_destroy      (QUEUE *queue);
int      queue_flush        (QUEUE *queue);
int      queue_deliver      (QUEUE *queue, THREAD *thread);

int      event_send         (const QID *to, const QID *from, char *name,
                             void *body, size_t body_size, char *accept,
                             char *reject, char *expire, word timeout);
EVENT   *event_accept       (QUEUE *queue, EVENT *event);
int      event_reject       (QUEUE *queue, EVENT *event);
int      event_expire       (QUEUE *queue, EVENT *event);
int      event_discard      (QUEUE *queue, EVENT *event);
EVENT   *event_iterate      (QUEUE *queue, EVENT *event);
int      event_destroy      (EVENT *event);
void     event_wait         (void);

THREAD  *thread_create_     (const char *agent, const char *thread);
/* On some platforms thread_create is an existing system call                */
#define thread_create(a,t) thread_create_(a,t)
THREAD  *thread_lookup      (const char *agent, const char *thread);
int      thread_destroy     (THREAD *thread, Bool cleanup);

SEMAPH  *semaph_create      (const char *name, int value);
SEMAPH  *semaph_lookup      (const char *name);
int      semaph_destroy     (SEMAPH *semaph);
int      semaph_wait        (SEMAPH *semaph);
int      semaph_signal      (SEMAPH *semaph);

int      lazy_creat         (char *path, int mode);
int      lazy_creat_text    (char *path, int mode);
int      lazy_open          (char *path, int flags);
int      lazy_open_text     (char *path, int flags);
int      lazy_read          (int handle, char *buffer, size_t count);
int      lazy_write         (int handle, char *buffer, size_t count);
int      lazy_close         (int handle);

void     raise_exception    (event_t event);
void     _call_exception    (THREAD *thread, event_t event);
void     recycle_module     (Bool wanted);
void     _dialog_push       (THREAD *thread);
void     _dialog_return     (THREAD *thread);
void     _dialog_pop        (THREAD *thread);

#ifdef __cplusplus
}
#endif


/*---------------------------------------------------------------------------
 *  Macros
 */

/*  Send an simple event: just a name, and string body                       */
#define SEND(q,name,s)      event_send ((q), NULL, (name), (byte *) (s), \
                                        strlen(s) + 1, NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Constants
 */

/*  Possible values for smt_errno                                            */

#define SMT_NOERRORS        0           /*  No errors                        */
#define SMT_EVENTEXISTS     1           /*  Event already declared           */
#define SMT_INTERNALERROR   2           /*  Agent had internal error         */
#define SMT_METHODEXISTS    3           /*  Method already declared          */
#define SMT_NOSUCHEVENT     4           /*  Unknown event name               */
#define SMT_NOSUCHMETHOD    5           /*  Unknown method name              */
#define SMT_NOSUCHQUEUE     6           /*  Event queue not defined          */
#define SMT_NOSUCHSEMAPH    7           /*  Unknown semaphore name           */
#define SMT_NOSUCHAGENT     8           /*  Agent not defined                */
#define SMT_NOSUCHTHREAD    9           /*  Thread not declared              */
#define SMT_NOTREADY        10          /*  SMT API not initialised          */
#define SMT_OUTOFMEMORY     11          /*  Not enough heap memory left      */
#define SMT_QUEUEISEMPTY    12          /*  Event queue is empty             */
#define SMT_QUEUEISFULL     13          /*  Event queue is full              */
#define SMT_SEMAPHEXISTS    14          /*  Semaphore already exists         */
#define SMT_AGENTEXISTS     15          /*  Agent already declared           */
#define SMT_AGENTNOTREADY   16          /*  Agent not initialised            */
#define SMT_THREADEXISTS    17          /*  Thread already declared          */
#define SMT_TOOMANYTHREADS  18          /*  Too many threads                 */

/*  Values for priority arguments                                            */

#define SMT_PRIORITY_NULL   0           /*  Illegal (null) priority          */
#define SMT_PRIORITY_MIN    1           /*  Lowest priority                  */
#define SMT_PRIORITY_LOW    50          /*  Low priority                     */
#define SMT_PRIORITY_NORMAL 100         /*  Default priority                 */
#define SMT_PRIORITY_HIGH   200         /*  High priority                    */
#define SMT_PRIORITY_MAX    255         /*  Highest priority                 */

/*  Values for agent_declare () type argument                                */

#define SMT_AGENT_NORMAL    0           /*  1 queue for 1 thread             */
#define SMT_AGENT_ROUTER    1           /*  1 queue for n threads            */

/*  Dialog constants (event is signed integer)                               */

#define SMT_NULL_STATE      -1          /*  Thread not initialised           */
#define SMT_TERM_EVENT      -1          /*  Terminate the thread             */
#define SMT_NULL_EVENT      -2          /*  No event provided                */
#define SMT_ACTION_STOP     0xFFFFL     /*  End of module list               */

/*  Values for thread activity state                                         */

#define SMT_THREAD_ACTIVE       1       /*  Active and executing             */
#define SMT_THREAD_PASSIVE      2       /*  Passive, between states          */
#define SMT_THREAD_WAIT_EVENT   3       /*  Waiting for an event             */
#define SMT_THREAD_WAIT_SEMAPH  4       /*  Waiting for a semaphore          */

/*  Maximum time, in seconds, allowed for a normal shutdown                  */

#define SMT_LOOP_DETECTION      2       /*  After this, we abort             */

#define SMT_SIGNAL_INT      1           /*  SIGINT - interrupted             */
#define SMT_SIGNAL_TERM     2           /*  SIGTERM - cancelled              */
#define SMT_SIGNAL_SEGV     3           /*  SIGSEGV - segment violation      */
#define SMT_SIGNAL_ALRM     4           /*  SIGALRM - timer signal           */
#define SMT_SIGNAL_USER     5           /*  User shutdown request            */

#define call_exception(event) _call_exception (thread, event)

#endif                                  /*  Include smtlib.h                 */
/*===========================================================================*
 *                                                                           *
 *  smtdefn.h - SMT agents and definitions                                   *
 *                                                                           *
 *  Copyright (c) 1991-2010 iMatix Corporation                               *
 *                                                                           *
 *  ------------------ GPL Licensed Source Code ------------------           *
 *  iMatix makes this software available under the GNU General               *
 *  Public License (GPL) license for open source projects.  For              *
 *  details of the GPL license please see www.gnu.org or read the            *
 *  file license.gpl provided in this package.                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License as           *
 *  published by the Free Software Foundation; either version 3 of           *
 *  the License, or (at your option) any later version.                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public                *
 *  License along with this program in the file 'license.gpl'; if            *
 *  not, see <http://www.gnu.org/licenses/>.                                 *
 *                                                                           *
 *  You can also license this software under iMatix's General Terms          *
 *  of Business (GTB) for commercial projects.  If you have not              *
 *  explicitly licensed this software under the iMatix GTB you may           *
 *  only use it under the terms of the GNU General Public License.           *
 *                                                                           *
 *  For more information, send an email to info@imatix.com.                  *
 *  --------------------------------------------------------------           *
 *===========================================================================*/

#ifndef _SMTDEFN_INCLUDED               /*  Allow multiple inclusions        */
#define _SMTDEFN_INCLUDED


/*---------------------------------------------------------------------------
 *  Standard SMT agents
 */

/*  Prototypes                                                               */

#ifdef __cplusplus
extern "C" {
#endif

int  smtecho_init    (void);            /*  TCP/IP echo agent                */
int  smtlog_init     (void);            /*  Logging agent                    */
int  smtoper_init    (void);            /*  Operator agent                   */
int  smtslot_init    (void);            /*  Time slot agent                  */
int  smtsock_init    (void);            /*  Socket i/o agent                 */
void smtsock_trace   (Bool trace);      /*  Socket i/o agent trace on/off    */
void smtsock_process_asynchronously
                     (void);
Bool smtsock_wait_forever
                     (void);
void smttime_process_asynchronously
                     (void);
int  smttran_init    (void);            /*  TCP/IP transfer agent            */
int  smtrdns_init    (void);            /*  Reverse DNS agent                */
int  smtpipe_init    (char *pipefile);  /*  Transfer pipe agent              */
int  smtsmtp_init    (void);            /*  SMTP agent                       */
int  smtpop_init     (void);            /*  POP3 agent                       */


#ifdef __cplusplus
}
#endif


/*---------------------------------------------------------------------------
 *  SMTLOG - Logging Agent
 *      One thread per log file; create thread with log file name, or supply
 *      log file name in CYCLE, OPEN, APPEND events.  Filename "" or "NULL"
 *      means discard all log file output.  Errors are sent to SMTOPER.
 *
 *  Method:                         Body:           Replies:
 *  CYCLE    Cycle log file         [file name]     -
 *  OPEN     Open new log file      [file name]     -
 *  APPEND   Append to existing     [file name]     -
 *  PUT      Write line to log      Line of text    -
 *  PLAIN    Do not timestamp log   -               -
 *  STAMP    Timestamp each line    -               -
 *  CLOSE    Close log file         -               -
 */

#define SMT_LOGGING     "smtlog"        /*  Name of logging agent            */


/*---------------------------------------------------------------------------
 *  SMTOPER - Operator Console Agent
 *      Single unnamed thread created automatically when agent initialises.
 *      Send messages to console device or log file if specified.
 *
 *  Method:                         Body:             Replies:
 *  ERROR    Error message          Message           -
 *  WARNING  Warning message        Message           -
 *  INFO     Information message    Message           -
 *  LOG      Redirect to log file   SMTLOG thread name  -
 */

#define SMT_OPERATOR    "smtoper"       /*  Name of operator agent           */


/*---------------------------------------------------------------------------
 *  SMTSLOT - Time Slot Agent
 *      One thread per application; create thread with application name.
 *      Send SPECIFY events, then ON or OFF to set timer initial state.
 *      Specification is "name values..."; name is "mon" to "sun", or date
 *      in MM/DD, YY/MM/DD, or YYYY/MM/DD format.  Values are hh:mm[-hh:mm]
 *      in 24-hour clock format, delimited by spaces.
 *
 *  Method:                         Body:             Replies:
 *  SPECIFY  Specify time slot      Specification     SLOT_ERROR, if error
 *  ON       Error message          -                 SWITCH_ON, SWITCH_OFF
 *  OFF      Error message          -                 SWITCH_ON, SWITCH_OFF
 */

#define SMT_SLOT        "smtslot"       /*  Name of time slot agent          */


/*---------------------------------------------------------------------------
 *  SMTSOCK - Socket I/O Agent
 *      Single unnamed thread created automatically when agent initialises.
 *      Multiple writes are processed in order; multiple reads are collapsed.
 *
 *  Method:                         Body:             Replies:
 *  READ     Read socket data       SMT_SOCK_READ     SOCK_READ_OK, ...
 *  READR    Read, repeat for ever  SMT_SOCK_READ     SOCK_READ_OK, ...
 *  WRITE    Write socket data      SMT_SOCK_WRITE    SOCK_WRITE_OK, ...
 *  INPUT    Wait for input         SMT_SOCK_INPUT    SOCK_INPUT_OK, ...
 *  INPUTR   Wait input, repeat     SMT_SOCK_INPUT    SOCK_INPUT_OK, ...
 *  OUTPUT   Wait for output        SMT_SOCK_OUTPUT   SOCK_OUTPUT_OK, ...
 *  CONNECT  Connect to host        SMT_SOCK_CONNECT  SOCK_WRITE_OK, ...
 *  FLUSH    Flush requests         SMT_SOCK_FLUSH    -
 *
 *  Replies:                                    Body:
 *  SOCK_READ_OK    Data read okay              SMT_SOCK_READ_OK
 *  SOCK_WRITE_OK   Data written okay           SMT_SOCK_OK
 *  SOCK_INPUT_OK   Socket has input ready      SMT_SOCK_OK
 *  SOCK_OUTPUT_OK  Socket ready for output     SMT_SOCK_OK
 *  SOCK_CLOSED     Socket was closed           SMT_SOCK_READ_OK
 *  SOCK_TIMEOUT    Request timed-out           SMT_SOCK_READ_OK
 *  SOCK_ERROR      Socket error during read    SMT_SOCK_ERROR
 */

#define SMT_SOCKET      "smtsock"       /*  Name of socket i/o agent         */


/*---------------------------------------------------------------------------
 *  SMTTIME - Timer Agent
 *      Single unnamed thread created automatically when agent initialises.
 *      Accurate to 1/100th second.
 *
 *  Method:                         Body:             Replies:
 *  ALARM    Alarm after delay      SMT_TIME_ALARM    TIME_ALARM, TIME_ERROR
 *  WAKEUP   Alarm at some time     SMT_TIME_ALARM    TIME_ALARM, TIME_ERROR
 *  CLOCK    Alarm at intervals     SMT_TIME_CLOCK    TIME_ALARM, TIME_ERROR
 *
 *  Replies:                                    Body:
 *  TIME_ALARM      Alarm went off              SMT_TIME_REPLY
 *  TIME_ERROR      Insufficient memory         Error message
 */

#define SMT_TIMER       "smttime"       /*  Name of timer agent              */


/*---------------------------------------------------------------------------
 *  SMTTRAN - Transfer Agent
 *      Single unnamed thread created automatically when agent initialises.
 *      Transfers fixed-size blocks or complete files.
 *
 *  Method:                         Body:             Replies:
 *  PUT_BLOCK   Write block         SMT_TRAN_PUTB     TRAN_PUTB_OK, ...
 *  GET_BLOCK   Read block          SMT_TRAN_GETB     TRAN_GETB_OK, ...
 *  PUT_FILE    Write file          SMT_TRAN_PUTF     TRAN_PUTF_OK, ...
 *  GET_FILE    Read file           SMT_TRAN_GETF     TRAN_GETF_OK, ...
 *  PUT_TEXT    Write text file     SMT_TRAN_PUTT     TRAN_PUTF_OK, ...
 *  GET_TEXT    Read text file      SMT_TRAN_GETT     TRAN_GETF_OK, ...
 *  PUT_SLICE   Write file slice    SMT_TRAN_PUTS     TRAN_PUTF_OK, ...
 *  GET_SLICE   Read file slice     SMT_TRAN_GETS     TRAN_GETF_OK, ...
 *  COMMIT      Finish transfers    -                 -
 */

#define SMT_TRANSFER    "smttran"       /*  Name of transfer agent           */


/*---------------------------------------------------------------------------
 *  SMTRDNS - Reverse DNS Agent
 *      One thread per request.  A main thread creates child threads with
 *      the type of request.
 *
 *  Method:                         Body:             Replies:
 *  GET_HOST Get host name          SMT_GET_HOST_NAME RDNS_OK,...
 *
 *  Replies:
 *  HOST_NAME  Host name
 *  HOST_IP    Host IP address
 */

#define SMT_RDNS        "smtrdns"       /*  Name of reverse dns agent        */


/*---------------------------------------------------------------------------
 *  SMTPOP - POP 3 agent
 *      One thread per request.  A main thread creates child threads to handle
 *      _one_ connection.
 *      
 *  Method:                         Body:             Replies:
 *      XXX TODO
 *  Replies:
 *      XXX TODO
 */

#define SMT_POP        "smtpop"       /*  Name of the POP 3 agent            */
#define SMT_SMTP       "smtsmtp"      /*  Name of the SMTP agent             */


#define SMTXLOG_AGENT  "smtxlog"        /* Name of extended log agent        */
/*  Other Agents                                                             */

#define SMT_ECHO        "smtecho"       /*  Name of TCP/IP echo agent        */
#define SMT_ECHO_PORT   "7"             /*  Port for echo agent              */

#endif                                  /*  Include smtdefn.h                */
/*===========================================================================*
 *                                                                           *
 *  smttime.h - Timer pseudo-agent                                           *
 *                                                                           *
 *  Copyright (c) 1991-2010 iMatix Corporation                               *
 *                                                                           *
 *  ------------------ GPL Licensed Source Code ------------------           *
 *  iMatix makes this software available under the GNU General               *
 *  Public License (GPL) license for open source projects.  For              *
 *  details of the GPL license please see www.gnu.org or read the            *
 *  file license.gpl provided in this package.                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License as           *
 *  published by the Free Software Foundation; either version 3 of           *
 *  the License, or (at your option) any later version.                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public                *
 *  License along with this program in the file 'license.gpl'; if            *
 *  not, see <http://www.gnu.org/licenses/>.                                 *
 *                                                                           *
 *  You can also license this software under iMatix's General Terms          *
 *  of Business (GTB) for commercial projects.  If you have not              *
 *  explicitly licensed this software under the iMatix GTB you may           *
 *  only use it under the terms of the GNU General Public License.           *
 *                                                                           *
 *  For more information, send an email to info@imatix.com.                  *
 *  --------------------------------------------------------------           *
 *===========================================================================*/
/*  ----------------------------------------------------------------<Prolog>-
    Synopsis:   Defines the functions to communicate with the SMT timer
                agent.  These include the deprecated functions which to
                keep compatibility with the old dialog-based timer agent.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef _SMTTIME_INCLUDED               /*  Allow multiple inclusions        */
#define _SMTTIME_INCLUDED


int  smttime_init (void);
int
create_single_alarm_request (
    QID  *reply_to,                     /*  Queue to receive reply           */
    qbyte days,                         /*  Time/delay in days               */
    qbyte csecs,                        /*  Time/delay in 1/100th seconds    */
    void *tag);                         /*  User-defined request tag         */
void
flush_requests_for_client (QID *clientq);
int
create_cycled_clock_request (
    QID  *reply_to,                     /*  Queue to receive reply           */
    qbyte days,                         /*  Time/delay in days               */
    qbyte csecs,                        /*  Time/delay in 1/100th seconds    */
    word  cycles,                       /*  Cycle count; zero = forever      */
    void *tag);                         /*  User-defined request tag         */
int
create_single_wakeup_request (
    QID  *reply_to,                     /*  Queue to receive reply           */
    long  date,                         /*  Date of request                  */
    long  time,                         /*  Time of request                  */
    void *tag);                         /*  User-defined request tag         */
void
clear_requests_matching_tag (
    QID  *reply_to,                     /*  Queue to receive reply           */
    void *tag);                         /*  User-defined request tag         */
void smttime_term (void);


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smttime - Timer agent.
 *
 *  The send_....() and lsend_.....() macros are provided for backwards
 *  compatibility, and are deprecated.  Use of the smttime_request_....() 
 *  macros is encouraged in new code. 
 *
 *  NOTE: Use of the send_....() and lsend_....() macros may result in
 *  compiler warnings about unused variables, as the _to parameter to
 *  the macros is unused (but retained for backwards compatibility).
 *
 *---------------------------------------------------------------------------*/

/*  Send event - alarm                                                       */

#define lsend_smttime_alarm(_to, _from,                                      \
        _accept, _reject, _expire, _timeout,                                 \
        days,                                                                \
        csecs,                                                               \
        tag)                                                                 \
    if (! create_single_alarm_request (_from, days, csecs, tag))             \
      {                                                                      \
        if (_accept)                                                         \
            event_send (_from, NULL, _accept, NULL, 0, NULL, NULL, NULL, 0); \
      }                                                                      \
    else                                                                     \
      {                                                                      \
        if (_reject)                                                         \
            event_send (_from, NULL, _reject, NULL, 0, NULL, NULL, NULL, 0); \
      }

#define send_smttime_alarm(_to,                                              \
        days,                                                                \
        csecs,                                                               \
        tag)                                                                 \
    create_single_alarm_request (&thread-> queue-> qid, days, csecs, tag)

#define smttime_request_alarm(                                               \
        days,                                                                \
        csecs,                                                               \
        tag)                                                                 \
    create_single_alarm_request (&thread-> queue-> qid, days, csecs, tag)

#define smttime_request_alarm_with_reply(                                    \
        _reply_to, _accept, _reject, _expire, _timeout,                      \
        days,                                                                \
        csecs,                                                               \
        tag)                                                                 \
    if (! create_single_alarm_request (_reply_to, days, csecs, tag))         \
      {                                                                      \
        if (_accept)                                                         \
            event_send (_reply_to, NULL, _accept,                            \
		        NULL, 0, NULL, NULL, NULL, 0);                               \
      }                                                                      \
    else                                                                     \
      {                                                                      \
        if (_reject)                                                         \
            event_send (_reply_to, NULL, _reject,                            \
		        NULL, 0, NULL, NULL, NULL, 0);                               \
      }

/*  Send event - wakeup                                                      */

#define lsend_smttime_wakeup(_to, _from,                                     \
        _accept, _reject, _expire, _timeout,                                 \
        date,                                                                \
        time,                                                                \
        tag)                                                                 \
    if (! create_single_wakeup_request (_from, date, time, tag))             \
      {                                                                      \
        if (_accept)                                                         \
            event_send (_from, NULL, _accept, NULL, 0, NULL, NULL, NULL, 0); \
      }                                                                      \
    else                                                                     \
      {                                                                      \
        if (_reject)                                                         \
            event_send (_from, NULL, _reject, NULL, 0, NULL, NULL, NULL, 0); \
      }

#define send_smttime_wakeup(_to,                                             \
        date,                                                                \
        time,                                                                \
        tag)                                                                 \
    create_single_wakeup_request (&thread-> queue-> qid, date, time, tag)

#define smttime_request_wakeup(                                              \
        date,                                                                \
        time,                                                                \
        tag)                                                                 \
    create_single_wakeup_request (&thread-> queue-> qid, date, time, tag)

#define smttime_request_wakekup_with_reply(                                  \
        _reply_to, _accept, _reject, _expire, _timeout,                      \
        date,                                                                \
        time,                                                                \
        tag)                                                                 \
    if (! create_single_wakeup_request (_reply_to, date, time, tag))         \
      {                                                                      \
        if (_accept)                                                         \
            event_send (_reply_to, NULL, _accept,                            \
		        NULL, 0, NULL, NULL, NULL, 0);                               \
      }                                                                      \
    else                                                                     \
      {                                                                      \
        if (_reject)                                                         \
            event_send (_reply_to, NULL, _reject,                            \
		        NULL, 0, NULL, NULL, NULL, 0);                               \
      }

/*  Send event - clock                                                       */

#define lsend_smttime_clock(_to, _from,                                      \
        _accept, _reject, _expire, _timeout,                                 \
        days,                                                                \
        csecs,                                                               \
        cycles,                                                              \
        tag)                                                                 \
    if (! create_cycled_clock_request (_from, days, csecs, cycles tag))      \
      {                                                                      \
        if (_accept)                                                         \
            event_send (_from, NULL, _accept, NULL, 0, NULL, NULL, NULL, 0); \
      }                                                                      \
    else                                                                     \
      {                                                                      \
        if (_reject)                                                         \
            event_send (_from, NULL, _reject, NULL, 0, NULL, NULL, NULL, 0); \
      }

#define send_smttime_clock(_to,                                              \
        days,                                                                \
        csecs,                                                               \
        cycles,                                                              \
        tag)                                                                 \
    create_cycled_clock_request (&thread-> queue-> qid,                      \
                                 days, csecs, cycles, tag)

#define smttime_request_clock(                                               \
        days,                                                                \
        csecs,                                                               \
        cycles,                                                              \
        tag)                                                                 \
    create_cycled_clock_request (&thread-> queue-> qid,                      \
                                 days, csecs, cycles, tag)

#define smttime_request_clock_with_reply(                                    \
        _reply_to, _accept, _reject, _expire, _timeout,                      \
        days,                                                                \
        csecs,                                                               \
        cycles,                                                              \
        tag)                                                                 \
    if (! create_cycled_clock_request (_reply_to, days, csecs, cycles tag))  \
      {                                                                      \
        if (_accept)                                                         \
            event_send (_reply_to, NULL, _accept,                            \
		        NULL, 0, NULL, NULL, NULL, 0);                               \
      }                                                                      \
    else                                                                     \
      {                                                                      \
        if (_reject)                                                         \
            event_send (_reply_to, NULL, _reject,                            \
		        NULL, 0, NULL, NULL, NULL, 0);                               \
      }

/*  Send event - flush                                                       */

#define lsend_smttime_flush(_to, _from,                                      \
        _accept, _reject, _expire, _timeout)                                 \
    flush_requests_for_client (_from);                                       \
    if (_accept)                                                             \
        event_send (_from, NULL, _accept, NULL, 0, NULL, NULL, NULL, 0);

#define send_smttime_flush(_to)                                              \
    flush_requests_for_client (&thread-> queue-> qid)

#define smttime_request_flush()                                              \
    flush_requests_for_client (&thread-> queue-> qid)

#define smttime_request_flush_with_reply(                                    \
        _reply_to, _accept, _reject, _expire, _timeout)                      \
    flush_requests_for_client (_reply_to);                                   \
    if (_accept)                                                             \
        event_send (_reply_to, NULL, _accept, NULL, 0, NULL, NULL, NULL, 0);

/*  Send event - clear                                                       */

#define lsend_smttime_clear(_to, _from,                                      \
        _accept, _reject, _expire, _timeout,                                 \
        tag)                                                                 \
    clear_requests_matching_tag (_from, tag);                                \
    if (_accept)                                                             \
        event_send (_from, NULL, _accept, NULL, 0, NULL, NULL, NULL, 0);

#define send_smttime_clear(_to,                                              \
        tag)                                                                 \
    clear_requests_matching_tag (&thread-> queue-> qid,                      \
                                 tag)

#define smttime_request_clear(                                               \
        tag)                                                                 \
    clear_requests_matching_tag (&thread-> queue-> qid, tag)

#define smttime_request_clear_with_reply(                                    \
        _reply_to, _accept, _reject, _expire, _timeout,                      \
        tag)                                                                 \
    clear_requests_matching_tag (_reply_to, tag);                            \
    if (_accept)                                                             \
        event_send (_reply_to, NULL, _accept, NULL, 0, NULL, NULL, NULL, 0);

/*  Structure for reply                                                      */

typedef struct {
    void *tag;                          /*  User-defined request tag         */
} struct_smttime_tag;

int  get_smttime_tag                       (byte *_buffer,
                                            struct_smttime_tag **params);

void free_smttime_tag                      (struct_smttime_tag **params);
extern char *SMTTIME_REPLY;

#define declare_smttime_reply(_event, _priority)                             \
    method_declare (agent, SMTTIME_REPLY, _event, _priority)

typedef struct {
    char *message;                      /*  Error message                    */
} struct_smttime_error;

int  get_smttime_error                     (byte *_buffer,
                                            struct_smttime_error **params);
void free_smttime_error                    (struct_smttime_error **params);

extern char *SMTTIME_ERROR;

#define declare_smttime_error(_event, _priority)                             \
    method_declare (agent, SMTTIME_ERROR, _event, _priority)

#endif                                  /*  Include smttime.h                */
/*===========================================================================*
 *                                                                           *
 *  smtserv.h - Windows service wrapper                                      *
 *                                                                           *
 *  Copyright (c) 1991-2010 iMatix Corporation                               *
 *                                                                           *
 *  ------------------ GPL Licensed Source Code ------------------           *
 *  iMatix makes this software available under the GNU General               *
 *  Public License (GPL) license for open source projects.  For              *
 *  details of the GPL license please see www.gnu.org or read the            *
 *  file license.gpl provided in this package.                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License as           *
 *  published by the Free Software Foundation; either version 3 of           *
 *  the License, or (at your option) any later version.                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public                *
 *  License along with this program in the file 'license.gpl'; if            *
 *  not, see <http://www.gnu.org/licenses/>.                                 *
 *                                                                           *
 *  You can also license this software under iMatix's General Terms          *
 *  of Business (GTB) for commercial projects.  If you have not              *
 *  explicitly licensed this software under the iMatix GTB you may           *
 *  only use it under the terms of the GNU General Public License.           *
 *                                                                           *
 *  For more information, send an email to info@imatix.com.                  *
 *  --------------------------------------------------------------           *
 *===========================================================================*/

#ifndef SMT_SERVICE_INCLUDED
#define SMT_SERVICE_INCLUDED

typedef int (SMT_AGENTS_INIT_FCT)(const char *config_filename);
typedef int (SMT_AGENTS_TERM_FCT)(void);

int service_begin (
    int                   argc, 
    char                **argv,
    SMT_AGENTS_INIT_FCT  *init_fct, 
    SMT_AGENTS_TERM_FCT  *term_fct,
    const char           *appl_version);

#endif                  /* SMT_SERVICE_INCLUDED */
 
/*---------------------------------------------------------------------------
 *  smtmsg.h - prototypes for SMT standard messages.
 *
 *  Generated from smtmsg.xml by smtmesg.gsl using GSL.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/
#ifndef INCLUDE_SMTMSG
#define INCLUDE_SMTMSG

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtlib - SMT kernel.
 *---------------------------------------------------------------------------*/

typedef struct {
    word  signal;                       /*  Signal that provoked shutdown    */
} struct_smtlib_shutdown;

int
put_smtlib_shutdown (
          byte **_buffer,
    const word  signal);                /*  Signal that provoked shutdown    */

int
get_smtlib_shutdown (
    byte *_buffer,
    struct_smtlib_shutdown **params);

void
free_smtlib_shutdown (
    struct_smtlib_shutdown **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for shutdown - .
 *---------------------------------------------------------------------------*/

extern char *SMTLIB_SHUTDOWN;

#define declare_smtlib_shutdown(_event, _priority)                            \
    method_declare (agent, SMTLIB_SHUTDOWN, _event, _priority)

/*  Send event - shutdown                                                    */

int 
lsend_smtlib_shutdown (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const word  signal);            /*  Signal that provoked shutdown    */

#define send_smtlib_shutdown(_to,                                             \
            signal)                                                           \
       lsend_smtlib_shutdown(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            signal)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtlog - SMT Log agent.
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for plain - .
 *---------------------------------------------------------------------------*/

extern char *SMTLOG_PLAIN;

#define declare_smtlog_plain(_event, _priority)                               \
    method_declare (agent, SMTLOG_PLAIN, _event, _priority)

/*  Send event - plain                                                       */

#define lsend_smtlog_plain(_to, _from,                                        \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTLOG_PLAIN,                                             \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtlog_plain(_to)                                                \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTLOG_PLAIN,                                             \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for stamp - .
 *---------------------------------------------------------------------------*/

extern char *SMTLOG_STAMP;

#define declare_smtlog_stamp(_event, _priority)                               \
    method_declare (agent, SMTLOG_STAMP, _event, _priority)

/*  Send event - stamp                                                       */

#define lsend_smtlog_stamp(_to, _from,                                        \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTLOG_STAMP,                                             \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtlog_stamp(_to)                                                \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTLOG_STAMP,                                             \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for close - .
 *---------------------------------------------------------------------------*/

extern char *SMTLOG_CLOSE;

#define declare_smtlog_close(_event, _priority)                               \
    method_declare (agent, SMTLOG_CLOSE, _event, _priority)

/*  Send event - close                                                       */

#define lsend_smtlog_close(_to, _from,                                        \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTLOG_CLOSE,                                             \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtlog_close(_to)                                                \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTLOG_CLOSE,                                             \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


typedef struct {
    char *filename;                     /*                                   */
} struct_smtlog_filename;

int
put_smtlog_filename (
          byte **_buffer,
    const char *filename);              /*                                   */

int
get_smtlog_filename (
    byte *_buffer,
    struct_smtlog_filename **params);

void
free_smtlog_filename (
    struct_smtlog_filename **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for cycle - .
 *---------------------------------------------------------------------------*/

extern char *SMTLOG_CYCLE;

#define declare_smtlog_cycle(_event, _priority)                               \
    method_declare (agent, SMTLOG_CYCLE, _event, _priority)

/*  Send event - cycle                                                       */

int 
lsend_smtlog_cycle (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *filename);          /*                                   */

#define send_smtlog_cycle(_to,                                                \
            filename)                                                         \
       lsend_smtlog_cycle(_to,                                                \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            filename)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for open - .
 *---------------------------------------------------------------------------*/

extern char *SMTLOG_OPEN;

#define declare_smtlog_open(_event, _priority)                                \
    method_declare (agent, SMTLOG_OPEN, _event, _priority)

/*  Send event - open                                                        */

int 
lsend_smtlog_open (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *filename);          /*                                   */

#define send_smtlog_open(_to,                                                 \
            filename)                                                         \
       lsend_smtlog_open(_to,                                                 \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            filename)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for append - .
 *---------------------------------------------------------------------------*/

extern char *SMTLOG_APPEND;

#define declare_smtlog_append(_event, _priority)                              \
    method_declare (agent, SMTLOG_APPEND, _event, _priority)

/*  Send event - append                                                      */

int 
lsend_smtlog_append (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *filename);          /*                                   */

#define send_smtlog_append(_to,                                               \
            filename)                                                         \
       lsend_smtlog_append(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            filename)


typedef struct {
    char *text;                         /*                                   */
} struct_smtlog_text;

int
put_smtlog_text (
          byte **_buffer,
    const char *text);                  /*                                   */

int
get_smtlog_text (
    byte *_buffer,
    struct_smtlog_text **params);

void
free_smtlog_text (
    struct_smtlog_text **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for put - .
 *---------------------------------------------------------------------------*/

extern char *SMTLOG_PUT;

#define declare_smtlog_put(_event, _priority)                                 \
    method_declare (agent, SMTLOG_PUT, _event, _priority)

/*  Send event - put                                                         */

int 
lsend_smtlog_put (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *text);              /*                                   */

#define send_smtlog_put(_to,                                                  \
            text)                                                             \
       lsend_smtlog_put(_to,                                                  \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            text)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtxlog - SMT Extended Logging Agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    char *log_path;                     /*  Path for logfiles, or empty      */
    char *log_file;                     /*  Name of logfile                  */
    char *log_format;                   /*  Desired logging format           */
    char *cycle_when;                   /*  When to cycle logfile            */
    char *cycle_how;                    /*  How to cycle logfile             */
    char *cycle_time;                   /*  For time-based cycling           */
    char *cycle_date;                   /*  For date-based cycling           */
    char *cycle_size;                   /*  For size-based cycling           */
    char *cycle_lines;                  /*  For size-based cycling           */
    char *cycle_argument;               /*  For other cycle methods          */
} struct_smtxlog_open;

int
put_smtxlog_open (
          byte **_buffer,
    const char *log_path,               /*  Path for logfiles, or empty      */
    const char *log_file,               /*  Name of logfile                  */
    const char *log_format,             /*  Desired logging format           */
    const char *cycle_when,             /*  When to cycle logfile            */
    const char *cycle_how,              /*  How to cycle logfile             */
    const char *cycle_time,             /*  For time-based cycling           */
    const char *cycle_date,             /*  For date-based cycling           */
    const char *cycle_size,             /*  For size-based cycling           */
    const char *cycle_lines,            /*  For size-based cycling           */
    const char *cycle_argument);        /*  For other cycle methods          */

int
get_smtxlog_open (
    byte *_buffer,
    struct_smtxlog_open **params);

void
free_smtxlog_open (
    struct_smtxlog_open **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for open - .
 *---------------------------------------------------------------------------*/

extern char *SMTXLOG_OPEN;

#define declare_smtxlog_open(_event, _priority)                               \
    method_declare (agent, SMTXLOG_OPEN, _event, _priority)

/*  Send event - open                                                        */

int 
lsend_smtxlog_open (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *log_path,           /*  Path for logfiles, or empty      */
    const char *log_file,           /*  Name of logfile                  */
    const char *log_format,         /*  Desired logging format           */
    const char *cycle_when,         /*  When to cycle logfile            */
    const char *cycle_how,          /*  How to cycle logfile             */
    const char *cycle_time,         /*  For time-based cycling           */
    const char *cycle_date,         /*  For date-based cycling           */
    const char *cycle_size,         /*  For size-based cycling           */
    const char *cycle_lines,        /*  For size-based cycling           */
    const char *cycle_argument);    /*  For other cycle methods          */

#define send_smtxlog_open(_to,                                                \
            log_path,                                                         \
            log_file,                                                         \
            log_format,                                                       \
            cycle_when,                                                       \
            cycle_how,                                                        \
            cycle_time,                                                       \
            cycle_date,                                                       \
            cycle_size,                                                       \
            cycle_lines,                                                      \
            cycle_argument)                                                   \
       lsend_smtxlog_open(_to,                                                \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            log_path,                                                         \
            log_file,                                                         \
            log_format,                                                       \
            cycle_when,                                                       \
            cycle_how,                                                        \
            cycle_time,                                                       \
            cycle_date,                                                       \
            cycle_size,                                                       \
            cycle_lines,                                                      \
            cycle_argument)


typedef struct {
    char *file_name;                    /*  Filename used for request        */
    word  value_size;                   /*  Value size                       */
    void *value;                        /*  Value to log                     */
} struct_smtxlog_log;

int
put_smtxlog_log (
          byte **_buffer,
    const char *file_name,              /*  Filename used for request        */
    const word  value_size,             /*  Value size                       */
    const void *value);                 /*  Value to log                     */

int
get_smtxlog_log (
    byte *_buffer,
    struct_smtxlog_log **params);

void
free_smtxlog_log (
    struct_smtxlog_log **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for log - .
 *---------------------------------------------------------------------------*/

extern char *SMTXLOG_LOG;

#define declare_smtxlog_log(_event, _priority)                                \
    method_declare (agent, SMTXLOG_LOG, _event, _priority)

/*  Send event - log                                                         */

int 
lsend_smtxlog_log (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *file_name,          /*  Filename used for request        */
    const word  value_size,         /*  Value size                       */
    const void *value);             /*  Value to log                     */

#define send_smtxlog_log(_to,                                                 \
            file_name,                                                        \
            value_size,                                                       \
            value)                                                            \
       lsend_smtxlog_log(_to,                                                 \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            file_name,                                                        \
            value_size,                                                       \
            value)


typedef struct {
    char *message;                      /*  Line of text to log              */
} struct_smtxlog_put;

int
put_smtxlog_put (
          byte **_buffer,
    const char *message);               /*  Line of text to log              */

int
get_smtxlog_put (
    byte *_buffer,
    struct_smtxlog_put **params);

void
free_smtxlog_put (
    struct_smtxlog_put **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for put - .
 *---------------------------------------------------------------------------*/

extern char *SMTXLOG_PUT;

#define declare_smtxlog_put(_event, _priority)                                \
    method_declare (agent, SMTXLOG_PUT, _event, _priority)

/*  Send event - put                                                         */

int 
lsend_smtxlog_put (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *message);           /*  Line of text to log              */

#define send_smtxlog_put(_to,                                                 \
            message)                                                          \
       lsend_smtxlog_put(_to,                                                 \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            message)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for cycle - .
 *---------------------------------------------------------------------------*/

extern char *SMTXLOG_CYCLE;

#define declare_smtxlog_cycle(_event, _priority)                              \
    method_declare (agent, SMTXLOG_CYCLE, _event, _priority)

/*  Send event - cycle                                                       */

#define lsend_smtxlog_cycle(_to, _from,                                       \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTXLOG_CYCLE,                                            \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtxlog_cycle(_to)                                               \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTXLOG_CYCLE,                                            \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for clear - .
 *---------------------------------------------------------------------------*/

extern char *SMTXLOG_CLEAR;

#define declare_smtxlog_clear(_event, _priority)                              \
    method_declare (agent, SMTXLOG_CLEAR, _event, _priority)

/*  Send event - clear                                                       */

#define lsend_smtxlog_clear(_to, _from,                                       \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTXLOG_CLEAR,                                            \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtxlog_clear(_to)                                               \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTXLOG_CLEAR,                                            \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for close - .
 *---------------------------------------------------------------------------*/

extern char *SMTXLOG_CLOSE;

#define declare_smtxlog_close(_event, _priority)                              \
    method_declare (agent, SMTXLOG_CLOSE, _event, _priority)

/*  Send event - close                                                       */

#define lsend_smtxlog_close(_to, _from,                                       \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTXLOG_CLOSE,                                            \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtxlog_close(_to)                                               \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTXLOG_CLOSE,                                            \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtoper - Operator agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    char *agent_name;                   /*  Name of logging agent            */
    char *thread_name;                  /*  Name of logging thread           */
} struct_smtoper_set_log;

int
put_smtoper_set_log (
          byte **_buffer,
    const char *agent_name,             /*  Name of logging agent            */
    const char *thread_name);           /*  Name of logging thread           */

int
get_smtoper_set_log (
    byte *_buffer,
    struct_smtoper_set_log **params);

void
free_smtoper_set_log (
    struct_smtoper_set_log **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for set log - .
 *---------------------------------------------------------------------------*/

extern char *SMTOPER_SET_LOG;

#define declare_smtoper_set_log(_event, _priority)                            \
    method_declare (agent, SMTOPER_SET_LOG, _event, _priority)

/*  Send event - set log                                                     */

int 
lsend_smtoper_set_log (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *agent_name,         /*  Name of logging agent            */
    const char *thread_name);       /*  Name of logging thread           */

#define send_smtoper_set_log(_to,                                             \
            agent_name,                                                       \
            thread_name)                                                      \
       lsend_smtoper_set_log(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            agent_name,                                                       \
            thread_name)


typedef struct {
    char *text;                         /*  Text of message                  */
} struct_smtoper_message;

int
put_smtoper_message (
          byte **_buffer,
    const char *text);                  /*  Text of message                  */

int
get_smtoper_message (
    byte *_buffer,
    struct_smtoper_message **params);

void
free_smtoper_message (
    struct_smtoper_message **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - .
 *---------------------------------------------------------------------------*/

extern char *SMTOPER_ERROR;

#define declare_smtoper_error(_event, _priority)                              \
    method_declare (agent, SMTOPER_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_smtoper_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *text);              /*  Text of message                  */

#define send_smtoper_error(_to,                                               \
            text)                                                             \
       lsend_smtoper_error(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            text)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for warning - .
 *---------------------------------------------------------------------------*/

extern char *SMTOPER_WARNING;

#define declare_smtoper_warning(_event, _priority)                            \
    method_declare (agent, SMTOPER_WARNING, _event, _priority)

/*  Send event - warning                                                     */

int 
lsend_smtoper_warning (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *text);              /*  Text of message                  */

#define send_smtoper_warning(_to,                                             \
            text)                                                             \
       lsend_smtoper_warning(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            text)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for info - .
 *---------------------------------------------------------------------------*/

extern char *SMTOPER_INFO;

#define declare_smtoper_info(_event, _priority)                               \
    method_declare (agent, SMTOPER_INFO, _event, _priority)

/*  Send event - info                                                        */

int 
lsend_smtoper_info (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *text);              /*  Text of message                  */

#define send_smtoper_info(_to,                                                \
            text)                                                             \
       lsend_smtoper_info(_to,                                                \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            text)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for enable - .
 *---------------------------------------------------------------------------*/

extern char *SMTOPER_ENABLE;

#define declare_smtoper_enable(_event, _priority)                             \
    method_declare (agent, SMTOPER_ENABLE, _event, _priority)

/*  Send event - enable                                                      */

#define lsend_smtoper_enable(_to, _from,                                      \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTOPER_ENABLE,                                           \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtoper_enable(_to)                                              \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTOPER_ENABLE,                                           \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for disable - .
 *---------------------------------------------------------------------------*/

extern char *SMTOPER_DISABLE;

#define declare_smtoper_disable(_event, _priority)                            \
    method_declare (agent, SMTOPER_DISABLE, _event, _priority)

/*  Send event - disable                                                     */

#define lsend_smtoper_disable(_to, _from,                                     \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTOPER_DISABLE,                                          \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtoper_disable(_to)                                             \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTOPER_DISABLE,                                          \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtrdns - Reverse DNS agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    qbyte ip_address;              /*  IP address in network order           */
    char *ip_string;               /*  Alternative address in string format  */
    qbyte request_tag;             /*  User-defined request tag              */
} struct_smtrdns_get_host_name;

int
put_smtrdns_get_host_name (
          byte **_buffer,
    const qbyte ip_address,        /*  IP address in network order           */
    const char *ip_string,         /*  Alternative address in string format  */
    const qbyte request_tag);      /*  User-defined request tag              */

int
get_smtrdns_get_host_name (
    byte *_buffer,
    struct_smtrdns_get_host_name **params);

void
free_smtrdns_get_host_name (
    struct_smtrdns_get_host_name **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get host name - .
 *---------------------------------------------------------------------------*/

extern char *SMTRDNS_GET_HOST_NAME;

#define declare_smtrdns_get_host_name(_event, _priority)                      \
    method_declare (agent, SMTRDNS_GET_HOST_NAME, _event, _priority)

/*  Send event - get host name                                               */

int 
lsend_smtrdns_get_host_name (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte ip_address,         /*  IP address in network order      */
    const char *ip_string,          /*  Alternative address in string format  */
    const qbyte request_tag);       /*  User-defined request tag         */

#define send_smtrdns_get_host_name(_to,                                       \
            ip_address,                                                       \
            ip_string,                                                        \
            request_tag)                                                      \
       lsend_smtrdns_get_host_name(_to,                                       \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            ip_address,                                                       \
            ip_string,                                                        \
            request_tag)


typedef struct {
    char *host_name;                    /*  Host name to look-up             */
    qbyte request_tag;                  /*  User-defined request tag         */
} struct_smtrdns_get_host_ip;

int
put_smtrdns_get_host_ip (
          byte **_buffer,
    const char *host_name,              /*  Host name to look-up             */
    const qbyte request_tag);           /*  User-defined request tag         */

int
get_smtrdns_get_host_ip (
    byte *_buffer,
    struct_smtrdns_get_host_ip **params);

void
free_smtrdns_get_host_ip (
    struct_smtrdns_get_host_ip **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get host ip - .
 *---------------------------------------------------------------------------*/

extern char *SMTRDNS_GET_HOST_IP;

#define declare_smtrdns_get_host_ip(_event, _priority)                        \
    method_declare (agent, SMTRDNS_GET_HOST_IP, _event, _priority)

/*  Send event - get host ip                                                 */

int 
lsend_smtrdns_get_host_ip (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *host_name,          /*  Host name to look-up             */
    const qbyte request_tag);       /*  User-defined request tag         */

#define send_smtrdns_get_host_ip(_to,                                         \
            host_name,                                                        \
            request_tag)                                                      \
       lsend_smtrdns_get_host_ip(_to,                                         \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            host_name,                                                        \
            request_tag)


typedef struct {
    qbyte ip_address;                   /*  IP address in network order      */
    char *host_name;                    /*  Host name                        */
    qbyte request_tag;                  /*  User-defined request tag         */
} struct_smtrdns_host_name;

int
put_smtrdns_host_name (
          byte **_buffer,
    const qbyte ip_address,             /*  IP address in network order      */
    const char *host_name,              /*  Host name                        */
    const qbyte request_tag);           /*  User-defined request tag         */

int
get_smtrdns_host_name (
    byte *_buffer,
    struct_smtrdns_host_name **params);

void
free_smtrdns_host_name (
    struct_smtrdns_host_name **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for host name - .
 *---------------------------------------------------------------------------*/

extern char *SMTRDNS_HOST_NAME;

#define declare_smtrdns_host_name(_event, _priority)                          \
    method_declare (agent, SMTRDNS_HOST_NAME, _event, _priority)

/*  Send event - host name                                                   */

int 
lsend_smtrdns_host_name (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte ip_address,         /*  IP address in network order      */
    const char *host_name,          /*  Host name                        */
    const qbyte request_tag);       /*  User-defined request tag         */

#define send_smtrdns_host_name(_to,                                           \
            ip_address,                                                       \
            host_name,                                                        \
            request_tag)                                                      \
       lsend_smtrdns_host_name(_to,                                           \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            ip_address,                                                       \
            host_name,                                                        \
            request_tag)


typedef struct {
    qbyte ip_address;                   /*  IP address in network order      */
    char *host_name;                    /*  Host name                        */
    qbyte request_tag;                  /*  User-defined request tag         */
} struct_smtrdns_host_ip;

int
put_smtrdns_host_ip (
          byte **_buffer,
    const qbyte ip_address,             /*  IP address in network order      */
    const char *host_name,              /*  Host name                        */
    const qbyte request_tag);           /*  User-defined request tag         */

int
get_smtrdns_host_ip (
    byte *_buffer,
    struct_smtrdns_host_ip **params);

void
free_smtrdns_host_ip (
    struct_smtrdns_host_ip **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for host ip - .
 *---------------------------------------------------------------------------*/

extern char *SMTRDNS_HOST_IP;

#define declare_smtrdns_host_ip(_event, _priority)                            \
    method_declare (agent, SMTRDNS_HOST_IP, _event, _priority)

/*  Send event - host ip                                                     */

int 
lsend_smtrdns_host_ip (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte ip_address,         /*  IP address in network order      */
    const char *host_name,          /*  Host name                        */
    const qbyte request_tag);       /*  User-defined request tag         */

#define send_smtrdns_host_ip(_to,                                             \
            ip_address,                                                       \
            host_name,                                                        \
            request_tag)                                                      \
       lsend_smtrdns_host_ip(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            ip_address,                                                       \
            host_name,                                                        \
            request_tag)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for host error - .
 *---------------------------------------------------------------------------*/

extern char *SMTRDNS_HOST_ERROR;

#define declare_smtrdns_host_error(_event, _priority)                         \
    method_declare (agent, SMTRDNS_HOST_ERROR, _event, _priority)

/*  Send event - host error                                                  */

#define lsend_smtrdns_host_error(_to, _from,                                  \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTRDNS_HOST_ERROR,                                       \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtrdns_host_error(_to)                                          \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTRDNS_HOST_ERROR,                                       \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for host end - .
 *---------------------------------------------------------------------------*/

extern char *SMTRDNS_HOST_END;

#define declare_smtrdns_host_end(_event, _priority)                           \
    method_declare (agent, SMTRDNS_HOST_END, _event, _priority)

/*  Send event - host end                                                    */

#define lsend_smtrdns_host_end(_to, _from,                                    \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTRDNS_HOST_END,                                         \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtrdns_host_end(_to)                                            \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTRDNS_HOST_END,                                         \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for host timeout - .
 *---------------------------------------------------------------------------*/

extern char *SMTRDNS_HOST_TIMEOUT;

#define declare_smtrdns_host_timeout(_event, _priority)                       \
    method_declare (agent, SMTRDNS_HOST_TIMEOUT, _event, _priority)

/*  Send event - host timeout                                                */

#define lsend_smtrdns_host_timeout(_to, _from,                                \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTRDNS_HOST_TIMEOUT,                                     \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtrdns_host_timeout(_to)                                        \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTRDNS_HOST_TIMEOUT,                                     \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtslot - Time slot agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    char *times;                        /*  Time slot specification          */
} struct_smtslot_specification;

int
put_smtslot_specification (
          byte **_buffer,
    const char *times);                 /*  Time slot specification          */

int
get_smtslot_specification (
    byte *_buffer,
    struct_smtslot_specification **params);

void
free_smtslot_specification (
    struct_smtslot_specification **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for specify - .
 *---------------------------------------------------------------------------*/

extern char *SMTSLOT_SPECIFY;

#define declare_smtslot_specify(_event, _priority)                            \
    method_declare (agent, SMTSLOT_SPECIFY, _event, _priority)

/*  Send event - specify                                                     */

int 
lsend_smtslot_specify (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *times);             /*  Time slot specification          */

#define send_smtslot_specify(_to,                                             \
            times)                                                            \
       lsend_smtslot_specify(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            times)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for reset - .
 *---------------------------------------------------------------------------*/

extern char *SMTSLOT_RESET;

#define declare_smtslot_reset(_event, _priority)                              \
    method_declare (agent, SMTSLOT_RESET, _event, _priority)

/*  Send event - reset                                                       */

#define lsend_smtslot_reset(_to, _from,                                       \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSLOT_RESET,                                            \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtslot_reset(_to)                                               \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSLOT_RESET,                                            \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for on - .
 *---------------------------------------------------------------------------*/

extern char *SMTSLOT_ON;

#define declare_smtslot_on(_event, _priority)                                 \
    method_declare (agent, SMTSLOT_ON, _event, _priority)

/*  Send event - on                                                          */

#define lsend_smtslot_on(_to, _from,                                          \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSLOT_ON,                                               \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtslot_on(_to)                                                  \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSLOT_ON,                                               \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for off - .
 *---------------------------------------------------------------------------*/

extern char *SMTSLOT_OFF;

#define declare_smtslot_off(_event, _priority)                                \
    method_declare (agent, SMTSLOT_OFF, _event, _priority)

/*  Send event - off                                                         */

#define lsend_smtslot_off(_to, _from,                                         \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSLOT_OFF,                                              \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtslot_off(_to)                                                 \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSLOT_OFF,                                              \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for finish - .
 *---------------------------------------------------------------------------*/

extern char *SMTSLOT_FINISH;

#define declare_smtslot_finish(_event, _priority)                             \
    method_declare (agent, SMTSLOT_FINISH, _event, _priority)

/*  Send event - finish                                                      */

#define lsend_smtslot_finish(_to, _from,                                      \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSLOT_FINISH,                                           \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtslot_finish(_to)                                              \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSLOT_FINISH,                                           \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


typedef struct {
    char *message;                      /*  Error message                    */
} struct_smtslot_error;

int
put_smtslot_error (
          byte **_buffer,
    const char *message);               /*  Error message                    */

int
get_smtslot_error (
    byte *_buffer,
    struct_smtslot_error **params);

void
free_smtslot_error (
    struct_smtslot_error **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - .
 *---------------------------------------------------------------------------*/

extern char *SMTSLOT_ERROR;

#define declare_smtslot_error(_event, _priority)                              \
    method_declare (agent, SMTSLOT_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_smtslot_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *message);           /*  Error message                    */

#define send_smtslot_error(_to,                                               \
            message)                                                          \
       lsend_smtslot_error(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            message)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for switch on - .
 *---------------------------------------------------------------------------*/

extern char *SMTSLOT_SWITCH_ON;

#define declare_smtslot_switch_on(_event, _priority)                          \
    method_declare (agent, SMTSLOT_SWITCH_ON, _event, _priority)

/*  Send event - switch on                                                   */

#define lsend_smtslot_switch_on(_to, _from,                                   \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSLOT_SWITCH_ON,                                        \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtslot_switch_on(_to)                                           \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSLOT_SWITCH_ON,                                        \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for switch off - .
 *---------------------------------------------------------------------------*/

extern char *SMTSLOT_SWITCH_OFF;

#define declare_smtslot_switch_off(_event, _priority)                         \
    method_declare (agent, SMTSLOT_SWITCH_OFF, _event, _priority)

/*  Send event - switch off                                                  */

#define lsend_smtslot_switch_off(_to, _from,                                  \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSLOT_SWITCH_OFF,                                       \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtslot_switch_off(_to)                                          \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSLOT_SWITCH_OFF,                                       \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtsock - Socket i/o agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    qbyte socket;                       /*  Socket to read from              */
    dbyte max_size;                     /*  Size of receiving buffer         */
    dbyte min_size;                     /*  Minimum data to read, zero = all */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_read;

int
put_smtsock_read (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const qbyte socket,                 /*  Socket to read from              */
    const dbyte max_size,               /*  Size of receiving buffer         */
    const dbyte min_size,               /*  Minimum data to read, zero = all */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_read (
    byte *_buffer,
    struct_smtsock_read **params);

void
free_smtsock_read (
    struct_smtsock_read **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for read - Read from socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READ;

#define declare_smtsock_read(_event, _priority)                               \
    method_declare (agent, SMTSOCK_READ, _event, _priority)

/*  Send event - read                                                        */

int 
lsend_smtsock_read (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to read from              */
    const dbyte max_size,           /*  Size of receiving buffer         */
    const dbyte min_size,           /*  Minimum data to read, zero = all */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_read(_to,                                                \
            timeout,                                                          \
            socket,                                                           \
            max_size,                                                         \
            min_size,                                                         \
            tag)                                                              \
       lsend_smtsock_read(_to,                                                \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            max_size,                                                         \
            min_size,                                                         \
            tag)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for readr - Repeated read from socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READR;

#define declare_smtsock_readr(_event, _priority)                              \
    method_declare (agent, SMTSOCK_READR, _event, _priority)

/*  Send event - readr                                                       */

int 
lsend_smtsock_readr (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to read from              */
    const dbyte max_size,           /*  Size of receiving buffer         */
    const dbyte min_size,           /*  Minimum data to read, zero = all  */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_readr(_to,                                               \
            timeout,                                                          \
            socket,                                                           \
            max_size,                                                         \
            min_size,                                                         \
            tag)                                                              \
       lsend_smtsock_readr(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            max_size,                                                         \
            min_size,                                                         \
            tag)


typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    qbyte socket;                       /*  Socket to write to               */
    word  size;                         /*  Amount of data to write          */
    void *data;                         /*  Block of data to write           */
    Bool  reply;                        /*  Whether OK reply is required     */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_write;

int
put_smtsock_write (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const qbyte socket,                 /*  Socket to write to               */
    const word  size,                   /*  Amount of data to write          */
    const void *data,                   /*  Block of data to write           */
    const Bool  reply,                  /*  Whether OK reply is required     */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_write (
    byte *_buffer,
    struct_smtsock_write **params);

void
free_smtsock_write (
    struct_smtsock_write **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for write - Write to socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_WRITE;

#define declare_smtsock_write(_event, _priority)                              \
    method_declare (agent, SMTSOCK_WRITE, _event, _priority)

/*  Send event - write                                                       */

int 
lsend_smtsock_write (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to write to               */
    const word  size,               /*  Amount of data to write          */
    const void *data,               /*  Block of data to write           */
    const Bool  reply,              /*  Whether OK reply is required     */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_write(_to,                                               \
            timeout,                                                          \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            reply,                                                            \
            tag)                                                              \
       lsend_smtsock_write(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            reply,                                                            \
            tag)


typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    qbyte socket;                       /*  Socket to write to               */
    Bool  reply;                        /*  Whether OK reply is required     */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_close;

int
put_smtsock_close (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const qbyte socket,                 /*  Socket to write to               */
    const Bool  reply,                  /*  Whether OK reply is required     */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_close (
    byte *_buffer,
    struct_smtsock_close **params);

void
free_smtsock_close (
    struct_smtsock_close **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for close - Close socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_CLOSE;

#define declare_smtsock_close(_event, _priority)                              \
    method_declare (agent, SMTSOCK_CLOSE, _event, _priority)

/*  Send event - close                                                       */

int 
lsend_smtsock_close (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to write to               */
    const Bool  reply,              /*  Whether OK reply is required     */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_close(_to,                                               \
            timeout,                                                          \
            socket,                                                           \
            reply,                                                            \
            tag)                                                              \
       lsend_smtsock_close(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            reply,                                                            \
            tag)


typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    qbyte socket;                       /*  Socket to read from              */
    qbyte max_size;                     /*  Size of receiving buffer         */
    qbyte min_size;                     /*  Minimum data to read, zero = all */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_readh;

int
put_smtsock_readh (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const qbyte socket,                 /*  Socket to read from              */
    const qbyte max_size,               /*  Size of receiving buffer         */
    const qbyte min_size,               /*  Minimum data to read, zero = all */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_readh (
    byte *_buffer,
    struct_smtsock_readh **params);

void
free_smtsock_readh (
    struct_smtsock_readh **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for readh - Huge read from socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READH;

#define declare_smtsock_readh(_event, _priority)                              \
    method_declare (agent, SMTSOCK_READH, _event, _priority)

/*  Send event - readh                                                       */

int 
lsend_smtsock_readh (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to read from              */
    const qbyte max_size,           /*  Size of receiving buffer         */
    const qbyte min_size,           /*  Minimum data to read, zero = all */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_readh(_to,                                               \
            timeout,                                                          \
            socket,                                                           \
            max_size,                                                         \
            min_size,                                                         \
            tag)                                                              \
       lsend_smtsock_readh(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            max_size,                                                         \
            min_size,                                                         \
            tag)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for readrh - Repeated huge read from socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READRH;

#define declare_smtsock_readrh(_event, _priority)                             \
    method_declare (agent, SMTSOCK_READRH, _event, _priority)

/*  Send event - readrh                                                      */

int 
lsend_smtsock_readrh (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to read from              */
    const qbyte max_size,           /*  Size of receiving buffer         */
    const qbyte min_size,           /*  Minimum data to read, zero = all */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_readrh(_to,                                              \
            timeout,                                                          \
            socket,                                                           \
            max_size,                                                         \
            min_size,                                                         \
            tag)                                                              \
       lsend_smtsock_readrh(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            max_size,                                                         \
            min_size,                                                         \
            tag)


typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    qbyte socket;                       /*  Socket to write to               */
    qbyte size;                         /*  Amount of data to write          */
    byte *data;                         /*  Block of data to write           */
    Bool  reply;                        /*  Whether OK reply is required     */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_writeh;

int
put_smtsock_writeh (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const qbyte socket,                 /*  Socket to write to               */
    const qbyte size,                   /*  Amount of data to write          */
    const byte *data,                   /*  Block of data to write           */
    const Bool  reply,                  /*  Whether OK reply is required     */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_writeh (
    byte *_buffer,
    struct_smtsock_writeh **params);

void
free_smtsock_writeh (
    struct_smtsock_writeh **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for writeh - Huge write to socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_WRITEH;

#define declare_smtsock_writeh(_event, _priority)                             \
    method_declare (agent, SMTSOCK_WRITEH, _event, _priority)

/*  Send event - writeh                                                      */

int 
lsend_smtsock_writeh (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to write to               */
    const qbyte size,               /*  Amount of data to write          */
    const byte *data,               /*  Block of data to write           */
    const Bool  reply,              /*  Whether OK reply is required     */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_writeh(_to,                                              \
            timeout,                                                          \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            reply,                                                            \
            tag)                                                              \
       lsend_smtsock_writeh(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            reply,                                                            \
            tag)


typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    qbyte socket;                       /*  Socket to wait on                */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_input;

int
put_smtsock_input (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const qbyte socket,                 /*  Socket to wait on                */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_input (
    byte *_buffer,
    struct_smtsock_input **params);

void
free_smtsock_input (
    struct_smtsock_input **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for input - Wait for socket input.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_INPUT;

#define declare_smtsock_input(_event, _priority)                              \
    method_declare (agent, SMTSOCK_INPUT, _event, _priority)

/*  Send event - input                                                       */

int 
lsend_smtsock_input (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to wait on                */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_input(_to,                                               \
            timeout,                                                          \
            socket,                                                           \
            tag)                                                              \
       lsend_smtsock_input(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            tag)


typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    qbyte socket;                       /*  Socket to wait on                */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_output;

int
put_smtsock_output (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const qbyte socket,                 /*  Socket to wait on                */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_output (
    byte *_buffer,
    struct_smtsock_output **params);

void
free_smtsock_output (
    struct_smtsock_output **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for output - Wait for socket output.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_OUTPUT;

#define declare_smtsock_output(_event, _priority)                             \
    method_declare (agent, SMTSOCK_OUTPUT, _event, _priority)

/*  Send event - output                                                      */

int 
lsend_smtsock_output (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to wait on                */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_output(_to,                                              \
            timeout,                                                          \
            socket,                                                           \
            tag)                                                              \
       lsend_smtsock_output(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            tag)


typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    char *type;                         /*  Type, UDP or TCP                 */
    char *host;                         /*  Host, name or dotted address, or NULL  */
    char *service;                      /*  Service, as name or port in ASCII, or NULL  */
    dbyte port;                         /*  16-bit host port, or 0           */
    qbyte address;                      /*  32-bit host address, or 0        */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_connect;

int
put_smtsock_connect (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const char *type,                   /*  Type, UDP or TCP                 */
    const char *host,                   /*  Host, name or dotted address, or NULL  */
    const char *service,                /*  Service, as name or port in ASCII, or NULL  */
    const dbyte port,                   /*  16-bit host port, or 0           */
    const qbyte address,                /*  32-bit host address, or 0        */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_connect (
    byte *_buffer,
    struct_smtsock_connect **params);

void
free_smtsock_connect (
    struct_smtsock_connect **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for connect - Connect to socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_CONNECT;

#define declare_smtsock_connect(_event, _priority)                            \
    method_declare (agent, SMTSOCK_CONNECT, _event, _priority)

/*  Send event - connect                                                     */

int 
lsend_smtsock_connect (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const char *type,               /*  Type, UDP or TCP                 */
    const char *host,               /*  Host, name or dotted address, or NULL  */
    const char *service,            /*  Service, as name or port in ASCII, or NULL  */
    const dbyte port,               /*  16-bit host port, or 0           */
    const qbyte address,            /*  32-bit host address, or 0        */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_connect(_to,                                             \
            timeout,                                                          \
            type,                                                             \
            host,                                                             \
            service,                                                          \
            port,                                                             \
            address,                                                          \
            tag)                                                              \
       lsend_smtsock_connect(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            type,                                                             \
            host,                                                             \
            service,                                                          \
            port,                                                             \
            address,                                                          \
            tag)


typedef struct {
    qbyte socket;                       /*  Socket for operation             */
    Bool  alltypes;                     /*  All request types, or just read? */
} struct_smtsock_flush;

int
put_smtsock_flush (
          byte **_buffer,
    const qbyte socket,                 /*  Socket for operation             */
    const Bool  alltypes);              /*  All request types, or just read? */

int
get_smtsock_flush (
    byte *_buffer,
    struct_smtsock_flush **params);

void
free_smtsock_flush (
    struct_smtsock_flush **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for flush - Flush socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_FLUSH;

#define declare_smtsock_flush(_event, _priority)                              \
    method_declare (agent, SMTSOCK_FLUSH, _event, _priority)

/*  Send event - flush                                                       */

int 
lsend_smtsock_flush (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket for operation              */
    const Bool  alltypes);          /*  All request types, or just read?  */

#define send_smtsock_flush(_to,                                               \
            socket,                                                           \
            alltypes)                                                         \
       lsend_smtsock_flush(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            alltypes)


typedef struct {
    word  size;                         /*  Amount of data read              */
    void *data;                         /*  Block of data read               */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_read_reply;

int
put_smtsock_read_reply (
          byte **_buffer,
    const word  size,                   /*  Amount of data read              */
    const void *data,                   /*  Block of data read               */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_read_reply (
    byte *_buffer,
    struct_smtsock_read_reply **params);

void
free_smtsock_read_reply (
    struct_smtsock_read_reply **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for read ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READ_OK;

#define declare_smtsock_read_ok(_event, _priority)                            \
    method_declare (agent, SMTSOCK_READ_OK, _event, _priority)

/*  Send event - read ok                                                     */

int 
lsend_smtsock_read_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const word  size,               /*  Amount of data read              */
    const void *data,               /*  Block of data read               */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_read_ok(_to,                                             \
            size,                                                             \
            data,                                                             \
            tag)                                                              \
       lsend_smtsock_read_ok(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data,                                                             \
            tag)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for read closed - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READ_CLOSED;

#define declare_smtsock_read_closed(_event, _priority)                        \
    method_declare (agent, SMTSOCK_READ_CLOSED, _event, _priority)

/*  Send event - read closed                                                 */

int 
lsend_smtsock_read_closed (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const word  size,               /*  Amount of data read              */
    const void *data,               /*  Block of data read               */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_read_closed(_to,                                         \
            size,                                                             \
            data,                                                             \
            tag)                                                              \
       lsend_smtsock_read_closed(_to,                                         \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data,                                                             \
            tag)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for read timeout - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READ_TIMEOUT;

#define declare_smtsock_read_timeout(_event, _priority)                       \
    method_declare (agent, SMTSOCK_READ_TIMEOUT, _event, _priority)

/*  Send event - read timeout                                                */

int 
lsend_smtsock_read_timeout (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const word  size,               /*  Amount of data read              */
    const void *data,               /*  Block of data read               */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_read_timeout(_to,                                        \
            size,                                                             \
            data,                                                             \
            tag)                                                              \
       lsend_smtsock_read_timeout(_to,                                        \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data,                                                             \
            tag)


typedef struct {
    qbyte size;                         /*  Amount of data read              */
    byte *data;                         /*  Block of data read               */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_readh_reply;

int
put_smtsock_readh_reply (
          byte **_buffer,
    const qbyte size,                   /*  Amount of data read              */
    const byte *data,                   /*  Block of data read               */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_readh_reply (
    byte *_buffer,
    struct_smtsock_readh_reply **params);

void
free_smtsock_readh_reply (
    struct_smtsock_readh_reply **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for readh ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READH_OK;

#define declare_smtsock_readh_ok(_event, _priority)                           \
    method_declare (agent, SMTSOCK_READH_OK, _event, _priority)

/*  Send event - readh ok                                                    */

int 
lsend_smtsock_readh_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size,               /*  Amount of data read              */
    const byte *data,               /*  Block of data read               */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_readh_ok(_to,                                            \
            size,                                                             \
            data,                                                             \
            tag)                                                              \
       lsend_smtsock_readh_ok(_to,                                            \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data,                                                             \
            tag)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for readh closed - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READH_CLOSED;

#define declare_smtsock_readh_closed(_event, _priority)                       \
    method_declare (agent, SMTSOCK_READH_CLOSED, _event, _priority)

/*  Send event - readh closed                                                */

int 
lsend_smtsock_readh_closed (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size,               /*  Amount of data read              */
    const byte *data,               /*  Block of data read               */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_readh_closed(_to,                                        \
            size,                                                             \
            data,                                                             \
            tag)                                                              \
       lsend_smtsock_readh_closed(_to,                                        \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data,                                                             \
            tag)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for readh timeout - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_READH_TIMEOUT;

#define declare_smtsock_readh_timeout(_event, _priority)                      \
    method_declare (agent, SMTSOCK_READH_TIMEOUT, _event, _priority)

/*  Send event - readh timeout                                               */

int 
lsend_smtsock_readh_timeout (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size,               /*  Amount of data read              */
    const byte *data,               /*  Block of data read               */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_readh_timeout(_to,                                       \
            size,                                                             \
            data,                                                             \
            tag)                                                              \
       lsend_smtsock_readh_timeout(_to,                                       \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data,                                                             \
            tag)


typedef struct {
    qbyte socket;                       /*  New socket                       */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_connect_ok;

int
put_smtsock_connect_ok (
          byte **_buffer,
    const qbyte socket,                 /*  New socket                       */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_connect_ok (
    byte *_buffer,
    struct_smtsock_connect_ok **params);

void
free_smtsock_connect_ok (
    struct_smtsock_connect_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for connect ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_CONNECT_OK;

#define declare_smtsock_connect_ok(_event, _priority)                         \
    method_declare (agent, SMTSOCK_CONNECT_OK, _event, _priority)

/*  Send event - connect ok                                                  */

int 
lsend_smtsock_connect_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  New socket                       */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_connect_ok(_to,                                          \
            socket,                                                           \
            tag)                                                              \
       lsend_smtsock_connect_ok(_to,                                          \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            tag)


typedef struct {
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_reply;

int
put_smtsock_reply (
          byte **_buffer,
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_reply (
    byte *_buffer,
    struct_smtsock_reply **params);

void
free_smtsock_reply (
    struct_smtsock_reply **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_OK;

#define declare_smtsock_ok(_event, _priority)                                 \
    method_declare (agent, SMTSOCK_OK, _event, _priority)

/*  Send event - ok                                                          */

int 
lsend_smtsock_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_ok(_to,                                                  \
            tag)                                                              \
       lsend_smtsock_ok(_to,                                                  \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            tag)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for closed - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_CLOSED;

#define declare_smtsock_closed(_event, _priority)                             \
    method_declare (agent, SMTSOCK_CLOSED, _event, _priority)

/*  Send event - closed                                                      */

int 
lsend_smtsock_closed (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_closed(_to,                                              \
            tag)                                                              \
       lsend_smtsock_closed(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            tag)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for timeout - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_TIMEOUT;

#define declare_smtsock_timeout(_event, _priority)                            \
    method_declare (agent, SMTSOCK_TIMEOUT, _event, _priority)

/*  Send event - timeout                                                     */

int 
lsend_smtsock_timeout (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_timeout(_to,                                             \
            tag)                                                              \
       lsend_smtsock_timeout(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            tag)


typedef struct {
    char *message;                      /*  Error message                    */
    void *tag;                          /*  User-defined request tag         */
} struct_smtsock_error;

int
put_smtsock_error (
          byte **_buffer,
    const char *message,                /*  Error message                    */
    const void *tag);                   /*  User-defined request tag         */

int
get_smtsock_error (
    byte *_buffer,
    struct_smtsock_error **params);

void
free_smtsock_error (
    struct_smtsock_error **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - .
 *---------------------------------------------------------------------------*/

extern char *SMTSOCK_ERROR;

#define declare_smtsock_error(_event, _priority)                              \
    method_declare (agent, SMTSOCK_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_smtsock_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *message,            /*  Error message                    */
    const void *tag);               /*  User-defined request tag         */

#define send_smtsock_error(_to,                                               \
            message,                                                          \
            tag)                                                              \
       lsend_smtsock_error(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            message,                                                          \
            tag)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smttran - Transfer agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    qbyte socket;                       /*  Socket for output                */
    word  size;                         /*  Amount of data to send           */
    void *data;                         /*  Block of data to send            */
    char *pipe;                         /*  Transfer pipe, if any            */
} struct_smttran_putb;

int
put_smttran_putb (
          byte **_buffer,
    const qbyte socket,                 /*  Socket for output                */
    const word  size,                   /*  Amount of data to send           */
    const void *data,                   /*  Block of data to send            */
    const char *pipe);                  /*  Transfer pipe, if any            */

int
get_smttran_putb (
    byte *_buffer,
    struct_smttran_putb **params);

void
free_smttran_putb (
    struct_smttran_putb **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for put block - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_PUT_BLOCK;

#define declare_smttran_put_block(_event, _priority)                          \
    method_declare (agent, SMTTRAN_PUT_BLOCK, _event, _priority)

/*  Send event - put block                                                   */

int 
lsend_smttran_put_block (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket for output                */
    const word  size,               /*  Amount of data to send           */
    const void *data,               /*  Block of data to send            */
    const char *pipe);              /*  Transfer pipe, if any            */

#define send_smttran_put_block(_to,                                           \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            pipe)                                                             \
       lsend_smttran_put_block(_to,                                           \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            pipe)


typedef struct {
    qbyte socket;                       /*  Socket for input                 */
    char *pipe;                         /*  Transfer pipe, if any            */
} struct_smttran_getb;

int
put_smttran_getb (
          byte **_buffer,
    const qbyte socket,                 /*  Socket for input                 */
    const char *pipe);                  /*  Transfer pipe, if any            */

int
get_smttran_getb (
    byte *_buffer,
    struct_smttran_getb **params);

void
free_smttran_getb (
    struct_smttran_getb **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get block - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_GET_BLOCK;

#define declare_smttran_get_block(_event, _priority)                          \
    method_declare (agent, SMTTRAN_GET_BLOCK, _event, _priority)

/*  Send event - get block                                                   */

int 
lsend_smttran_get_block (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket for input                 */
    const char *pipe);              /*  Transfer pipe, if any            */

#define send_smttran_get_block(_to,                                           \
            socket,                                                           \
            pipe)                                                             \
       lsend_smttran_get_block(_to,                                           \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            pipe)


typedef struct {
    qbyte socket;                       /*  Socket for output                */
    qbyte size;                         /*  Amount of data to send           */
    byte *data;                         /*  Block of data to send            */
    char *pipe;                         /*  Transfer pipe, if any            */
} struct_smttran_puth;

int
put_smttran_puth (
          byte **_buffer,
    const qbyte socket,                 /*  Socket for output                */
    const qbyte size,                   /*  Amount of data to send           */
    const byte *data,                   /*  Block of data to send            */
    const char *pipe);                  /*  Transfer pipe, if any            */

int
get_smttran_puth (
    byte *_buffer,
    struct_smttran_puth **params);

void
free_smttran_puth (
    struct_smttran_puth **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for put huge - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_PUT_HUGE;

#define declare_smttran_put_huge(_event, _priority)                           \
    method_declare (agent, SMTTRAN_PUT_HUGE, _event, _priority)

/*  Send event - put huge                                                    */

int 
lsend_smttran_put_huge (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket for output                */
    const qbyte size,               /*  Amount of data to send           */
    const byte *data,               /*  Block of data to send            */
    const char *pipe);              /*  Transfer pipe, if any            */

#define send_smttran_put_huge(_to,                                            \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            pipe)                                                             \
       lsend_smttran_put_huge(_to,                                            \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            pipe)


typedef struct {
    qbyte socket;                       /*  Socket for input                 */
    char *pipe;                         /*  Transfer pipe, if any            */
} struct_smttran_geth;

int
put_smttran_geth (
          byte **_buffer,
    const qbyte socket,                 /*  Socket for input                 */
    const char *pipe);                  /*  Transfer pipe, if any            */

int
get_smttran_geth (
    byte *_buffer,
    struct_smttran_geth **params);

void
free_smttran_geth (
    struct_smttran_geth **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get huge - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_GET_HUGE;

#define declare_smttran_get_huge(_event, _priority)                           \
    method_declare (agent, SMTTRAN_GET_HUGE, _event, _priority)

/*  Send event - get huge                                                    */

int 
lsend_smttran_get_huge (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket for input                 */
    const char *pipe);              /*  Transfer pipe, if any            */

#define send_smttran_get_huge(_to,                                            \
            socket,                                                           \
            pipe)                                                             \
       lsend_smttran_get_huge(_to,                                            \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            pipe)


typedef struct {
    qbyte socket;                       /*  Socket for output                */
    char *filename;                     /*  Name of file to send             */
    dbyte filetype;                     /*  0=binary, 1=ASCII                */
    qbyte start;                        /*  Starting offset; 0 = start       */
    qbyte end;                          /*  Ending offset; 0 = end           */
    char *pipe;                         /*  Transfer pipe, if any            */
} struct_smttran_putf;

int
put_smttran_putf (
          byte **_buffer,
    const qbyte socket,                 /*  Socket for output                */
    const char *filename,               /*  Name of file to send             */
    const dbyte filetype,               /*  0=binary, 1=ASCII                */
    const qbyte start,                  /*  Starting offset; 0 = start       */
    const qbyte end,                    /*  Ending offset; 0 = end           */
    const char *pipe);                  /*  Transfer pipe, if any            */

int
get_smttran_putf (
    byte *_buffer,
    struct_smttran_putf **params);

void
free_smttran_putf (
    struct_smttran_putf **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for put file - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_PUT_FILE;

#define declare_smttran_put_file(_event, _priority)                           \
    method_declare (agent, SMTTRAN_PUT_FILE, _event, _priority)

/*  Send event - put file                                                    */

int 
lsend_smttran_put_file (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket for output                */
    const char *filename,           /*  Name of file to send             */
    const dbyte filetype,           /*  0=binary, 1=ASCII                */
    const qbyte start,              /*  Starting offset; 0 = start       */
    const qbyte end,                /*  Ending offset; 0 = end           */
    const char *pipe);              /*  Transfer pipe, if any            */

#define send_smttran_put_file(_to,                                            \
            socket,                                                           \
            filename,                                                         \
            filetype,                                                         \
            start,                                                            \
            end,                                                              \
            pipe)                                                             \
       lsend_smttran_put_file(_to,                                            \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            filename,                                                         \
            filetype,                                                         \
            start,                                                            \
            end,                                                              \
            pipe)


typedef struct {
    qbyte socket;                       /*  Socket for input                 */
    char *filename;                     /*  Name of file to receive          */
    dbyte filetype;                     /*  0=binary, 1=ASCII                */
    qbyte start;                        /*  Starting offset; 0 = start       */
    qbyte end;                          /*  Ending offset; 0 = end           */
    Bool  append;                       /*  1 = append existing              */
    qbyte maxsize;                      /*  Max. size, -1 = no limit         */
    char *pipe;                         /*  Transfer pipe, if any            */
} struct_smttran_getf;

int
put_smttran_getf (
          byte **_buffer,
    const qbyte socket,                 /*  Socket for input                 */
    const char *filename,               /*  Name of file to receive          */
    const dbyte filetype,               /*  0=binary, 1=ASCII                */
    const qbyte start,                  /*  Starting offset; 0 = start       */
    const qbyte end,                    /*  Ending offset; 0 = end           */
    const Bool  append,                 /*  1 = append existing              */
    const qbyte maxsize,                /*  Max. size, -1 = no limit         */
    const char *pipe);                  /*  Transfer pipe, if any            */

int
get_smttran_getf (
    byte *_buffer,
    struct_smttran_getf **params);

void
free_smttran_getf (
    struct_smttran_getf **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get file - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_GET_FILE;

#define declare_smttran_get_file(_event, _priority)                           \
    method_declare (agent, SMTTRAN_GET_FILE, _event, _priority)

/*  Send event - get file                                                    */

int 
lsend_smttran_get_file (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket for input                 */
    const char *filename,           /*  Name of file to receive          */
    const dbyte filetype,           /*  0=binary, 1=ASCII                */
    const qbyte start,              /*  Starting offset; 0 = start       */
    const qbyte end,                /*  Ending offset; 0 = end           */
    const Bool  append,             /*  1 = append existing              */
    const qbyte maxsize,            /*  Max. size, -1 = no limit         */
    const char *pipe);              /*  Transfer pipe, if any            */

#define send_smttran_get_file(_to,                                            \
            socket,                                                           \
            filename,                                                         \
            filetype,                                                         \
            start,                                                            \
            end,                                                              \
            append,                                                           \
            maxsize,                                                          \
            pipe)                                                             \
       lsend_smttran_get_file(_to,                                            \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            filename,                                                         \
            filetype,                                                         \
            start,                                                            \
            end,                                                              \
            append,                                                           \
            maxsize,                                                          \
            pipe)


typedef struct {
    dbyte size;                         /*  Amount of transmitted data       */
} struct_smttran_putb_ok;

int
put_smttran_putb_ok (
          byte **_buffer,
    const dbyte size);                  /*  Amount of transmitted data       */

int
get_smttran_putb_ok (
    byte *_buffer,
    struct_smttran_putb_ok **params);

void
free_smttran_putb_ok (
    struct_smttran_putb_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for putb ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_PUTB_OK;

#define declare_smttran_putb_ok(_event, _priority)                            \
    method_declare (agent, SMTTRAN_PUTB_OK, _event, _priority)

/*  Send event - putb ok                                                     */

int 
lsend_smttran_putb_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte size);              /*  Amount of transmitted data       */

#define send_smttran_putb_ok(_to,                                             \
            size)                                                             \
       lsend_smttran_putb_ok(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size)


typedef struct {
    word  size;                         /*  Amount of data received          */
    void *data;                         /*  Block of data received           */
} struct_smttran_getb_ok;

int
put_smttran_getb_ok (
          byte **_buffer,
    const word  size,                   /*  Amount of data received          */
    const void *data);                  /*  Block of data received           */

int
get_smttran_getb_ok (
    byte *_buffer,
    struct_smttran_getb_ok **params);

void
free_smttran_getb_ok (
    struct_smttran_getb_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for getb ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_GETB_OK;

#define declare_smttran_getb_ok(_event, _priority)                            \
    method_declare (agent, SMTTRAN_GETB_OK, _event, _priority)

/*  Send event - getb ok                                                     */

int 
lsend_smttran_getb_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const word  size,               /*  Amount of data received          */
    const void *data);              /*  Block of data received           */

#define send_smttran_getb_ok(_to,                                             \
            size,                                                             \
            data)                                                             \
       lsend_smttran_getb_ok(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data)


typedef struct {
    qbyte size;                         /*  Amount of transmitted data       */
} struct_smttran_puth_ok;

int
put_smttran_puth_ok (
          byte **_buffer,
    const qbyte size);                  /*  Amount of transmitted data       */

int
get_smttran_puth_ok (
    byte *_buffer,
    struct_smttran_puth_ok **params);

void
free_smttran_puth_ok (
    struct_smttran_puth_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for puth ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_PUTH_OK;

#define declare_smttran_puth_ok(_event, _priority)                            \
    method_declare (agent, SMTTRAN_PUTH_OK, _event, _priority)

/*  Send event - puth ok                                                     */

int 
lsend_smttran_puth_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size);              /*  Amount of transmitted data       */

#define send_smttran_puth_ok(_to,                                             \
            size)                                                             \
       lsend_smttran_puth_ok(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size)


typedef struct {
    qbyte size;                         /*  Amount of data received          */
    byte *data;                         /*  Block of data received           */
} struct_smttran_geth_ok;

int
put_smttran_geth_ok (
          byte **_buffer,
    const qbyte size,                   /*  Amount of data received          */
    const byte *data);                  /*  Block of data received           */

int
get_smttran_geth_ok (
    byte *_buffer,
    struct_smttran_geth_ok **params);

void
free_smttran_geth_ok (
    struct_smttran_geth_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for geth ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_GETH_OK;

#define declare_smttran_geth_ok(_event, _priority)                            \
    method_declare (agent, SMTTRAN_GETH_OK, _event, _priority)

/*  Send event - geth ok                                                     */

int 
lsend_smttran_geth_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size,               /*  Amount of data received          */
    const byte *data);              /*  Block of data received           */

#define send_smttran_geth_ok(_to,                                             \
            size,                                                             \
            data)                                                             \
       lsend_smttran_geth_ok(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data)


typedef struct {
    qbyte size;                         /*  Amount of transmitted data       */
} struct_smttran_putf_ok;

int
put_smttran_putf_ok (
          byte **_buffer,
    const qbyte size);                  /*  Amount of transmitted data       */

int
get_smttran_putf_ok (
    byte *_buffer,
    struct_smttran_putf_ok **params);

void
free_smttran_putf_ok (
    struct_smttran_putf_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for putf ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_PUTF_OK;

#define declare_smttran_putf_ok(_event, _priority)                            \
    method_declare (agent, SMTTRAN_PUTF_OK, _event, _priority)

/*  Send event - putf ok                                                     */

int 
lsend_smttran_putf_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size);              /*  Amount of transmitted data       */

#define send_smttran_putf_ok(_to,                                             \
            size)                                                             \
       lsend_smttran_putf_ok(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size)


typedef struct {
    qbyte size;                         /*  Amount of transmitted data       */
} struct_smttran_getf_ok;

int
put_smttran_getf_ok (
          byte **_buffer,
    const qbyte size);                  /*  Amount of transmitted data       */

int
get_smttran_getf_ok (
    byte *_buffer,
    struct_smttran_getf_ok **params);

void
free_smttran_getf_ok (
    struct_smttran_getf_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for getf ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_GETF_OK;

#define declare_smttran_getf_ok(_event, _priority)                            \
    method_declare (agent, SMTTRAN_GETF_OK, _event, _priority)

/*  Send event - getf ok                                                     */

int 
lsend_smttran_getf_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size);              /*  Amount of transmitted data       */

#define send_smttran_getf_ok(_to,                                             \
            size)                                                             \
       lsend_smttran_getf_ok(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size)


typedef struct {
    char *name;                         /*  Name of pipe                     */
    qbyte input_rate;                   /*  Input rate, bytes/s              */
    qbyte output_rate;                  /*  Output rate, bytes/s             */
} struct_smttran_pipe_create;

int
put_smttran_pipe_create (
          byte **_buffer,
    const char *name,                   /*  Name of pipe                     */
    const qbyte input_rate,             /*  Input rate, bytes/s              */
    const qbyte output_rate);           /*  Output rate, bytes/s             */

int
get_smttran_pipe_create (
    byte *_buffer,
    struct_smttran_pipe_create **params);

void
free_smttran_pipe_create (
    struct_smttran_pipe_create **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for pipe create - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_PIPE_CREATE;

#define declare_smttran_pipe_create(_event, _priority)                        \
    method_declare (agent, SMTTRAN_PIPE_CREATE, _event, _priority)

/*  Send event - pipe create                                                 */

int 
lsend_smttran_pipe_create (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *name,               /*  Name of pipe                     */
    const qbyte input_rate,         /*  Input rate, bytes/s              */
    const qbyte output_rate);       /*  Output rate, bytes/s             */

#define send_smttran_pipe_create(_to,                                         \
            name,                                                             \
            input_rate,                                                       \
            output_rate)                                                      \
       lsend_smttran_pipe_create(_to,                                         \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            name,                                                             \
            input_rate,                                                       \
            output_rate)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for clear pipes - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_CLEAR_PIPES;

#define declare_smttran_clear_pipes(_event, _priority)                        \
    method_declare (agent, SMTTRAN_CLEAR_PIPES, _event, _priority)

/*  Send event - clear pipes                                                 */

#define lsend_smttran_clear_pipes(_to, _from,                                 \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTTRAN_CLEAR_PIPES,                                      \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smttran_clear_pipes(_to)                                         \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTTRAN_CLEAR_PIPES,                                      \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for commit - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_COMMIT;

#define declare_smttran_commit(_event, _priority)                             \
    method_declare (agent, SMTTRAN_COMMIT, _event, _priority)

/*  Send event - commit                                                      */

#define lsend_smttran_commit(_to, _from,                                      \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTTRAN_COMMIT,                                           \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smttran_commit(_to)                                              \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTTRAN_COMMIT,                                           \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for closed - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_CLOSED;

#define declare_smttran_closed(_event, _priority)                             \
    method_declare (agent, SMTTRAN_CLOSED, _event, _priority)

/*  Send event - closed                                                      */

#define lsend_smttran_closed(_to, _from,                                      \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTTRAN_CLOSED,                                           \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smttran_closed(_to)                                              \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTTRAN_CLOSED,                                           \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


typedef struct {
    char *reason;                       /*  Error message                    */
} struct_smttran_error;

int
put_smttran_error (
          byte **_buffer,
    const char *reason);                /*  Error message                    */

int
get_smttran_error (
    byte *_buffer,
    struct_smttran_error **params);

void
free_smttran_error (
    struct_smttran_error **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - .
 *---------------------------------------------------------------------------*/

extern char *SMTTRAN_ERROR;

#define declare_smttran_error(_event, _priority)                              \
    method_declare (agent, SMTTRAN_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_smttran_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *reason);            /*  Error message                    */

#define send_smttran_error(_to,                                               \
            reason)                                                           \
       lsend_smttran_error(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            reason)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtupm - Unattended Process Monitor agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    dbyte ident;                        /*                                   */
    char *string;                       /*                                   */
} struct_smtupm_message;

int
put_smtupm_message (
          byte **_buffer,
    const dbyte ident,                  /*                                   */
    const char *string);                /*                                   */

int
get_smtupm_message (
    byte *_buffer,
    struct_smtupm_message **params);

void
free_smtupm_message (
    struct_smtupm_message **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for put block - .
 *---------------------------------------------------------------------------*/

extern char *SMTUPM_PUT_BLOCK;

#define declare_smtupm_put_block(_event, _priority)                          \
    method_declare (agent, SMTUPM_PUT_BLOCK, _event, _priority)

/*  Send event - put block                                                   */

int 
lsend_smtupm_put_block (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte ident,              /*                                   */
    const char *string);            /*                                   */

#define send_smtupm_put_block(_to,                                            \
            ident,                                                            \
            string)                                                           \
       lsend_smtupm_put_block(_to,                                            \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            ident,                                                            \
            string)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtpop - POP3 agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    char *server;                       /*  pop3 server name                 */
    char *user;                         /*  user name                        */
    char *password;                     /*  user password                    */
} struct_smtpop_connection;

int
put_smtpop_connection (
          byte **_buffer,
    const char *server,                 /*  pop3 server name                 */
    const char *user,                   /*  user name                        */
    const char *password);              /*  user password                    */

int
get_smtpop_connection (
    byte *_buffer,
    struct_smtpop_connection **params);

void
free_smtpop_connection (
    struct_smtpop_connection **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for connect - .
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_CONNECT;

#define declare_smtpop_connect(_event, _priority)                             \
    method_declare (agent, SMTPOP_CONNECT, _event, _priority)

/*  Send event - connect                                                     */

int 
lsend_smtpop_connect (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *server,             /*  pop3 server name                 */
    const char *user,               /*  user name                        */
    const char *password);          /*  user password                    */

#define send_smtpop_connect(_to,                                              \
            server,                                                           \
            user,                                                             \
            password)                                                         \
       lsend_smtpop_connect(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            server,                                                           \
            user,                                                             \
            password)


typedef struct {
    qbyte msg_cnt;                      /*  count of new messages on server  */
    qbyte msg_size;                     /*  messages total size (bytes)      */
} struct_smtpop_connect_ok;

int
put_smtpop_connect_ok (
          byte **_buffer,
    const qbyte msg_cnt,                /*  count of new messages on server  */
    const qbyte msg_size);              /*  messages total size (bytes)      */

int
get_smtpop_connect_ok (
    byte *_buffer,
    struct_smtpop_connect_ok **params);

void
free_smtpop_connect_ok (
    struct_smtpop_connect_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for connect_ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_CONNECT_OK;

#define declare_smtpop_connect_ok(_event, _priority)                          \
    method_declare (agent, SMTPOP_CONNECT_OK, _event, _priority)

/*  Send event - connect_ok                                                  */

int 
lsend_smtpop_connect_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_cnt,            /*  count of new messages on server  */
    const qbyte msg_size);          /*  messages total size (bytes)      */

#define send_smtpop_connect_ok(_to,                                           \
            msg_cnt,                                                          \
            msg_size)                                                         \
       lsend_smtpop_connect_ok(_to,                                           \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_cnt,                                                          \
            msg_size)


typedef struct {
    char *reason;                       /*  why connection failed            */
    dbyte code;                         /*                                   */
} struct_smtpop_error;

int
put_smtpop_error (
          byte **_buffer,
    const char *reason,                 /*  why connection failed            */
    const dbyte code);                  /*                                   */

int
get_smtpop_error (
    byte *_buffer,
    struct_smtpop_error **params);

void
free_smtpop_error (
    struct_smtpop_error **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - .
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_ERROR;

#define declare_smtpop_error(_event, _priority)                               \
    method_declare (agent, SMTPOP_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_smtpop_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *reason,             /*  why connection failed            */
    const dbyte code);              /*                                   */

#define send_smtpop_error(_to,                                                \
            reason,                                                           \
            code)                                                             \
       lsend_smtpop_error(_to,                                                \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            reason,                                                           \
            code)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get_session_info - ask for message count on server.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_GET_SESSION_INFO;

#define declare_smtpop_get_session_info(_event, _priority)                    \
    method_declare (agent, SMTPOP_GET_SESSION_INFO, _event, _priority)

/*  Send event - get_session_info                                            */

#define lsend_smtpop_get_session_info(_to, _from,                             \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTPOP_GET_SESSION_INFO,                                  \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtpop_get_session_info(_to)                                     \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTPOP_GET_SESSION_INFO,                                  \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for quit - quit command.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_QUIT;

#define declare_smtpop_quit(_event, _priority)                                \
    method_declare (agent, SMTPOP_QUIT, _event, _priority)

/*  Send event - quit                                                        */

#define lsend_smtpop_quit(_to, _from,                                         \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTPOP_QUIT,                                              \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtpop_quit(_to)                                                 \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTPOP_QUIT,                                              \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for quit_ok - quit response.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_QUIT_OK;

#define declare_smtpop_quit_ok(_event, _priority)                             \
    method_declare (agent, SMTPOP_QUIT_OK, _event, _priority)

/*  Send event - quit_ok                                                     */

#define lsend_smtpop_quit_ok(_to, _from,                                      \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTPOP_QUIT_OK,                                           \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtpop_quit_ok(_to)                                              \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTPOP_QUIT_OK,                                           \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


typedef struct {
    qbyte count;                        /*  message count                    */
    qbyte size;                         /*  messages total size in bytes     */
} struct_smtpop_session_info;

int
put_smtpop_session_info (
          byte **_buffer,
    const qbyte count,                  /*  message count                    */
    const qbyte size);                  /*  messages total size in bytes     */

int
get_smtpop_session_info (
    byte *_buffer,
    struct_smtpop_session_info **params);

void
free_smtpop_session_info (
    struct_smtpop_session_info **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for session_info - .
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_SESSION_INFO;

#define declare_smtpop_session_info(_event, _priority)                        \
    method_declare (agent, SMTPOP_SESSION_INFO, _event, _priority)

/*  Send event - session_info                                                */

int 
lsend_smtpop_session_info (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte count,              /*  message count                    */
    const qbyte size);              /*  messages total size in bytes     */

#define send_smtpop_session_info(_to,                                         \
            count,                                                            \
            size)                                                             \
       lsend_smtpop_session_info(_to,                                         \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            count,                                                            \
            size)


typedef struct {
    qbyte msg_id;                       /*  requested message id             */
    qbyte size;                         /*  messages total size in bytes     */
} struct_smtpop_msg_session_info;

int
put_smtpop_msg_session_info (
          byte **_buffer,
    const qbyte msg_id,                 /*  requested message id             */
    const qbyte size);                  /*  messages total size in bytes     */

int
get_smtpop_msg_session_info (
    byte *_buffer,
    struct_smtpop_msg_session_info **params);

void
free_smtpop_msg_session_info (
    struct_smtpop_msg_session_info **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for msg_session_info - .
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_MSG_SESSION_INFO;

#define declare_smtpop_msg_session_info(_event, _priority)                    \
    method_declare (agent, SMTPOP_MSG_SESSION_INFO, _event, _priority)

/*  Send event - msg_session_info                                            */

int 
lsend_smtpop_msg_session_info (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_id,             /*  requested message id             */
    const qbyte size);              /*  messages total size in bytes     */

#define send_smtpop_msg_session_info(_to,                                     \
            msg_id,                                                           \
            size)                                                             \
       lsend_smtpop_msg_session_info(_to,                                     \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_id,                                                           \
            size)


typedef struct {
    qbyte msg_id;                       /*  message id, zero=all             */
    char *attach_dir;                   /*  directory where attchment will be stored  */
} struct_smtpop_msg_id;

int
put_smtpop_msg_id (
          byte **_buffer,
    const qbyte msg_id,                 /*  message id, zero=all             */
    const char *attach_dir);            /*  directory where attchment will be stored  */

int
get_smtpop_msg_id (
    byte *_buffer,
    struct_smtpop_msg_id **params);

void
free_smtpop_msg_id (
    struct_smtpop_msg_id **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get_msg_header - ask for message header.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_GET_MSG_HEADER;

#define declare_smtpop_get_msg_header(_event, _priority)                      \
    method_declare (agent, SMTPOP_GET_MSG_HEADER, _event, _priority)

/*  Send event - get_msg_header                                              */

int 
lsend_smtpop_get_msg_header (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_id,        /*  message id, zero=all                      */
    const char *attach_dir);   /*  directory where attchment will be stored  */

#define send_smtpop_get_msg_header(_to,                                       \
            msg_id,                                                           \
            attach_dir)                                                       \
       lsend_smtpop_get_msg_header(_to,                                       \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_id,                                                           \
            attach_dir)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get_msg - ask for entire message.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_GET_MSG;

#define declare_smtpop_get_msg(_event, _priority)                             \
    method_declare (agent, SMTPOP_GET_MSG, _event, _priority)

/*  Send event - get_msg                                                     */

int 
lsend_smtpop_get_msg (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_id,        /*  message id, zero=all             */
    const char *attach_dir);   /*  directory where attchment will be stored  */

#define send_smtpop_get_msg(_to,                                              \
            msg_id,                                                           \
            attach_dir)                                                       \
       lsend_smtpop_get_msg(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_id,                                                           \
            attach_dir)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for delete_msg - delete message from server.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_DELETE_MSG;

#define declare_smtpop_delete_msg(_event, _priority)                          \
    method_declare (agent, SMTPOP_DELETE_MSG, _event, _priority)

/*  Send event - delete_msg                                                  */

int 
lsend_smtpop_delete_msg (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_id,             /*  message id, zero=all             */
    const char *attach_dir);        /*  directory where attchment will be stored  */

#define send_smtpop_delete_msg(_to,                                           \
            msg_id,                                                           \
            attach_dir)                                                       \
       lsend_smtpop_delete_msg(_to,                                           \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_id,                                                           \
            attach_dir)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for delete_ok - delete ok response.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_DELETE_OK;

#define declare_smtpop_delete_ok(_event, _priority)                           \
    method_declare (agent, SMTPOP_DELETE_OK, _event, _priority)

/*  Send event - delete_ok                                                   */

int 
lsend_smtpop_delete_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_id,             /*  message id, zero=all             */
    const char *attach_dir);        /*  directory where attchment will be stored  */

#define send_smtpop_delete_ok(_to,                                            \
            msg_id,                                                           \
            attach_dir)                                                       \
       lsend_smtpop_delete_ok(_to,                                            \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_id,                                                           \
            attach_dir)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for get_msg_info - ask for message info.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_GET_MSG_INFO;

#define declare_smtpop_get_msg_info(_event, _priority)                        \
    method_declare (agent, SMTPOP_GET_MSG_INFO, _event, _priority)

/*  Send event - get_msg_info                                                */

int 
lsend_smtpop_get_msg_info (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_id,             /*  message id, zero=all             */
    const char *attach_dir);        /*  directory where attchment will be stored  */

#define send_smtpop_get_msg_info(_to,                                         \
            msg_id,                                                           \
            attach_dir)                                                       \
       lsend_smtpop_get_msg_info(_to,                                         \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_id,                                                           \
            attach_dir)


typedef struct {
    qbyte msg_id;                       /*  message id requested             */
    char *from;                         /*  message sender                   */
    char *to;                           /*  people the message was addressed to  */
    char *cc;                           /*  people the message is carbon copied to  */
    char *date;                         /*  date the message was received    */
    char *subject;                      /*  guess what                       */
} struct_smtpop_msg_header;

int
put_smtpop_msg_header (
          byte **_buffer,
    const qbyte msg_id,                 /*  message id requested             */
    const char *from,                   /*  message sender                   */
    const char *to,                     /*  people the message was addressed to  */
    const char *cc,                     /*  people the message is carbon copied to  */
    const char *date,                   /*  date the message was received    */
    const char *subject);               /*  guess what                       */

int
get_smtpop_msg_header (
    byte *_buffer,
    struct_smtpop_msg_header **params);

void
free_smtpop_msg_header (
    struct_smtpop_msg_header **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for msg_header - mail info.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_MSG_HEADER;

#define declare_smtpop_msg_header(_event, _priority)                          \
    method_declare (agent, SMTPOP_MSG_HEADER, _event, _priority)

/*  Send event - msg_header                                                  */

int 
lsend_smtpop_msg_header (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_id,             /*  message id requested             */
    const char *from,               /*  message sender                   */
    const char *to,                 /*  people the message was addressed to  */
    const char *cc,                 /*  people the message is carbon copied to  */
    const char *date,               /*  date the message was received    */
    const char *subject);           /*  guess what                       */

#define send_smtpop_msg_header(_to,                                           \
            msg_id,                                                           \
            from,                                                             \
            to,                                                               \
            cc,                                                               \
            date,                                                             \
            subject)                                                          \
       lsend_smtpop_msg_header(_to,                                           \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_id,                                                           \
            from,                                                             \
            to,                                                               \
            cc,                                                               \
            date,                                                             \
            subject)


typedef struct {
    qbyte msg_id;                       /*  message id requested             */
    char *from;                         /*  message sender                   */
    char *to;                           /*  people the message was addressed to  */
    char *cc;                           /*  people the message is carbon copied to  */
    char *date;                         /*  date the message was received    */
    char *subject;                      /*  guess what                       */
    char *body;                         /*  the text body                    */
    char *attachments;                  /*  attachment names, separated by semi-colon  */
    char *attach_dir;                   /*  directory where attach have been stored  */
} struct_smtpop_msg;

int
put_smtpop_msg (
          byte **_buffer,
    const qbyte msg_id,                 /*  message id requested             */
    const char *from,                   /*  message sender                   */
    const char *to,                     /*  people the message was addressed to  */
    const char *cc,                     /*  people the message is carbon copied to  */
    const char *date,                   /*  date the message was received    */
    const char *subject,                /*  guess what                       */
    const char *body,                   /*  the text body                    */
    const char *attachments,            /*  attachment names, separated by semi-colon  */
    const char *attach_dir);            /*  directory where attach have been stored  */

int
get_smtpop_msg (
    byte *_buffer,
    struct_smtpop_msg **params);

void
free_smtpop_msg (
    struct_smtpop_msg **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for msg - complete message.
 *---------------------------------------------------------------------------*/

extern char *SMTPOP_MSG;

#define declare_smtpop_msg(_event, _priority)                                 \
    method_declare (agent, SMTPOP_MSG, _event, _priority)

/*  Send event - msg                                                         */

int 
lsend_smtpop_msg (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte msg_id,             /*  message id requested             */
    const char *from,               /*  message sender                   */
    const char *to,                 /*  people the message was addressed to  */
    const char *cc,                 /*  people the message is carbon copied to  */
    const char *date,               /*  date the message was received    */
    const char *subject,            /*  guess what                       */
    const char *body,               /*  the text body                    */
    const char *attachments,        /*  attachment names, separated by semi-colon  */
    const char *attach_dir);        /*  directory where attach have been stored  */

#define send_smtpop_msg(_to,                                                  \
            msg_id,                                                           \
            from,                                                             \
            to,                                                               \
            cc,                                                               \
            date,                                                             \
            subject,                                                          \
            body,                                                             \
            attachments,                                                      \
            attach_dir)                                                       \
       lsend_smtpop_msg(_to,                                                  \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            msg_id,                                                           \
            from,                                                             \
            to,                                                               \
            cc,                                                               \
            date,                                                             \
            subject,                                                          \
            body,                                                             \
            attachments,                                                      \
            attach_dir)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtsmtp - SMTP agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    char *smtp_server;                  /*                                   */
    char *msg_body;                     /*                                   */
    char *sender_uid;                   /*                                   */
    char *dest_uids;                    /*                                   */
    char *subject;                      /*                                   */
} struct_smtsmtp_message;

int
put_smtsmtp_message (
          byte **_buffer,
    const char *smtp_server,            /*                                   */
    const char *msg_body,               /*                                   */
    const char *sender_uid,             /*                                   */
    const char *dest_uids,              /*                                   */
    const char *subject);               /*                                   */

int
get_smtsmtp_message (
    byte *_buffer,
    struct_smtsmtp_message **params);

void
free_smtsmtp_message (
    struct_smtsmtp_message **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for send_message - .
 *---------------------------------------------------------------------------*/

extern char *SMTSMTP_SEND_MESSAGE;

#define declare_smtsmtp_send_message(_event, _priority)                       \
    method_declare (agent, SMTSMTP_SEND_MESSAGE, _event, _priority)

/*  Send event - send_message                                                */

int 
lsend_smtsmtp_send_message (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *smtp_server,        /*                                   */
    const char *msg_body,           /*                                   */
    const char *sender_uid,         /*                                   */
    const char *dest_uids,          /*                                   */
    const char *subject);           /*                                   */

#define send_smtsmtp_send_message(_to,                                        \
            smtp_server,                                                      \
            msg_body,                                                         \
            sender_uid,                                                       \
            dest_uids,                                                        \
            subject)                                                          \
       lsend_smtsmtp_send_message(_to,                                        \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            smtp_server,                                                      \
            msg_body,                                                         \
            sender_uid,                                                       \
            dest_uids,                                                        \
            subject)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for open_message - .
 *---------------------------------------------------------------------------*/

extern char *SMTSMTP_OPEN_MESSAGE;

#define declare_smtsmtp_open_message(_event, _priority)                       \
    method_declare (agent, SMTSMTP_OPEN_MESSAGE, _event, _priority)

/*  Send event - open_message                                                */

int 
lsend_smtsmtp_open_message (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *smtp_server,        /*                                   */
    const char *msg_body,           /*                                   */
    const char *sender_uid,         /*                                   */
    const char *dest_uids,          /*                                   */
    const char *subject);           /*                                   */

#define send_smtsmtp_open_message(_to,                                        \
            smtp_server,                                                      \
            msg_body,                                                         \
            sender_uid,                                                       \
            dest_uids,                                                        \
            subject)                                                          \
       lsend_smtsmtp_open_message(_to,                                        \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            smtp_server,                                                      \
            msg_body,                                                         \
            sender_uid,                                                       \
            dest_uids,                                                        \
            subject)


typedef struct {
    char *chunk;                        /*                                   */
} struct_smtsmtp_chunk;

int
put_smtsmtp_chunk (
          byte **_buffer,
    const char *chunk);                 /*                                   */

int
get_smtsmtp_chunk (
    byte *_buffer,
    struct_smtsmtp_chunk **params);

void
free_smtsmtp_chunk (
    struct_smtsmtp_chunk **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for message chunk - .
 *---------------------------------------------------------------------------*/

extern char *SMTSMTP_MESSAGE_CHUNK;

#define declare_smtsmtp_message_chunk(_event, _priority)                      \
    method_declare (agent, SMTSMTP_MESSAGE_CHUNK, _event, _priority)

/*  Send event - message chunk                                               */

int 
lsend_smtsmtp_message_chunk (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *chunk);             /*                                   */

#define send_smtsmtp_message_chunk(_to,                                       \
            chunk)                                                            \
       lsend_smtsmtp_message_chunk(_to,                                       \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            chunk)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for close_message - .
 *---------------------------------------------------------------------------*/

extern char *SMTSMTP_CLOSE_MESSAGE;

#define declare_smtsmtp_close_message(_event, _priority)                      \
    method_declare (agent, SMTSMTP_CLOSE_MESSAGE, _event, _priority)

/*  Send event - close_message                                               */

#define lsend_smtsmtp_close_message(_to, _from,                               \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSMTP_CLOSE_MESSAGE,                                    \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtsmtp_close_message(_to)                                       \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSMTP_CLOSE_MESSAGE,                                    \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


typedef struct {
    qbyte code;                         /*  error code                       */
    char *msg;                          /*  error description                */
} struct_smtsmtp_reply;

int
put_smtsmtp_reply (
          byte **_buffer,
    const qbyte code,                   /*  error code                       */
    const char *msg);                   /*  error description                */

int
get_smtsmtp_reply (
    byte *_buffer,
    struct_smtsmtp_reply **params);

void
free_smtsmtp_reply (
    struct_smtsmtp_reply **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTSMTP_OK;

#define declare_smtsmtp_ok(_event, _priority)                                 \
    method_declare (agent, SMTSMTP_OK, _event, _priority)

/*  Send event - ok                                                          */

int 
lsend_smtsmtp_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte code,               /*  error code                       */
    const char *msg);               /*  error description                */

#define send_smtsmtp_ok(_to,                                                  \
            code,                                                             \
            msg)                                                              \
       lsend_smtsmtp_ok(_to,                                                  \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            code,                                                             \
            msg)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - .
 *---------------------------------------------------------------------------*/

extern char *SMTSMTP_ERROR;

#define declare_smtsmtp_error(_event, _priority)                              \
    method_declare (agent, SMTSMTP_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_smtsmtp_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte code,               /*  error code                       */
    const char *msg);               /*  error description                */

#define send_smtsmtp_error(_to,                                               \
            code,                                                             \
            msg)                                                              \
       lsend_smtsmtp_error(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            code,                                                             \
            msg)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smttmtp - TMTP agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    char *host;                         /*  Remote host                      */
    char *port;                         /*                                   */
    word  size;                         /*  Amount of data to write          */
    void *data;                         /*  Block of data to write           */
} struct_smttmtp_write;

int
put_smttmtp_write (
          byte **_buffer,
    const char *host,                   /*  Remote host                      */
    const char *port,                   /*                                   */
    const word  size,                   /*  Amount of data to write          */
    const void *data);                  /*  Block of data to write           */

int
get_smttmtp_write (
    byte *_buffer,
    struct_smttmtp_write **params);

void
free_smttmtp_write (
    struct_smttmtp_write **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for write - .
 *---------------------------------------------------------------------------*/

extern char *SMTTMTP_WRITE;

#define declare_smttmtp_write(_event, _priority)                              \
    method_declare (agent, SMTTMTP_WRITE, _event, _priority)

/*  Send event - write                                                       */

int 
lsend_smttmtp_write (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *host,               /*  Remote host                      */
    const char *port,               /*                                   */
    const word  size,               /*  Amount of data to write          */
    const void *data);              /*  Block of data to write           */

#define send_smttmtp_write(_to,                                               \
            host,                                                             \
            port,                                                             \
            size,                                                             \
            data)                                                             \
       lsend_smttmtp_write(_to,                                               \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            host,                                                             \
            port,                                                             \
            size,                                                             \
            data)


typedef struct {
    char *port;                         /*                                   */
} struct_smttmtp_listen;

int
put_smttmtp_listen (
          byte **_buffer,
    const char *port);                  /*                                   */

int
get_smttmtp_listen (
    byte *_buffer,
    struct_smttmtp_listen **params);

void
free_smttmtp_listen (
    struct_smttmtp_listen **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for listen - .
 *---------------------------------------------------------------------------*/

extern char *SMTTMTP_LISTEN;

#define declare_smttmtp_listen(_event, _priority)                             \
    method_declare (agent, SMTTMTP_LISTEN, _event, _priority)

/*  Send event - listen                                                      */

int 
lsend_smttmtp_listen (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *port);              /*                                   */

#define send_smttmtp_listen(_to,                                              \
            port)                                                             \
       lsend_smttmtp_listen(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            port)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for write ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTTMTP_WRITE_OK;

#define declare_smttmtp_write_ok(_event, _priority)                           \
    method_declare (agent, SMTTMTP_WRITE_OK, _event, _priority)

/*  Send event - write ok                                                    */

#define lsend_smttmtp_write_ok(_to, _from,                                    \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTTMTP_WRITE_OK,                                         \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smttmtp_write_ok(_to)                                            \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTTMTP_WRITE_OK,                                         \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for listen ok - .
 *---------------------------------------------------------------------------*/

extern char *SMTTMTP_LISTEN_OK;

#define declare_smttmtp_listen_ok(_event, _priority)                          \
    method_declare (agent, SMTTMTP_LISTEN_OK, _event, _priority)

/*  Send event - listen ok                                                   */

#define lsend_smttmtp_listen_ok(_to, _from,                                   \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTTMTP_LISTEN_OK,                                        \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smttmtp_listen_ok(_to)                                           \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTTMTP_LISTEN_OK,                                        \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


typedef struct {
    char *message;                      /*                                   */
} struct_smttmtp_error;

int
put_smttmtp_error (
          byte **_buffer,
    const char *message);               /*                                   */

int
get_smttmtp_error (
    byte *_buffer,
    struct_smttmtp_error **params);

void
free_smttmtp_error (
    struct_smttmtp_error **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for write error - .
 *---------------------------------------------------------------------------*/

extern char *SMTTMTP_WRITE_ERROR;

#define declare_smttmtp_write_error(_event, _priority)                        \
    method_declare (agent, SMTTMTP_WRITE_ERROR, _event, _priority)

/*  Send event - write error                                                 */

int 
lsend_smttmtp_write_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *message);           /*                                   */

#define send_smttmtp_write_error(_to,                                         \
            message)                                                          \
       lsend_smttmtp_write_error(_to,                                         \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            message)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for listen error - .
 *---------------------------------------------------------------------------*/

extern char *SMTTMTP_LISTEN_ERROR;

#define declare_smttmtp_listen_error(_event, _priority)                       \
    method_declare (agent, SMTTMTP_LISTEN_ERROR, _event, _priority)

/*  Send event - listen error                                                */

int 
lsend_smttmtp_listen_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *message);           /*                                   */

#define send_smttmtp_listen_error(_to,                                        \
            message)                                                          \
       lsend_smttmtp_listen_error(_to,                                        \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            message)


typedef struct {
    word  size;                         /*  Amount of data to write          */
    void *data;                         /*  Block of data read               */
} struct_smttmtp_incoming_message;

int
put_smttmtp_incoming_message (
          byte **_buffer,
    const word  size,                   /*  Amount of data to write          */
    const void *data);                  /*  Block of data read               */

int
get_smttmtp_incoming_message (
    byte *_buffer,
    struct_smttmtp_incoming_message **params);

void
free_smttmtp_incoming_message (
    struct_smttmtp_incoming_message **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for incoming data - .
 *---------------------------------------------------------------------------*/

extern char *SMTTMTP_INCOMING_DATA;

#define declare_smttmtp_incoming_data(_event, _priority)                      \
    method_declare (agent, SMTTMTP_INCOMING_DATA, _event, _priority)

/*  Send event - incoming data                                               */

int 
lsend_smttmtp_incoming_data (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const word  size,               /*  Amount of data to write          */
    const void *data);              /*  Block of data read               */

#define send_smttmtp_incoming_data(_to,                                       \
            size,                                                             \
            data)                                                             \
       lsend_smttmtp_incoming_data(_to,                                       \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data)



#endif                                  /*  Included                         */
/*---------------------------------------------------------------------------
 *  smtsslm.h - prototypes for Smtssl messages.
 *
 *  Generated from smtsslm.xml by smtmesg.gsl using GSL.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/
#ifndef INCLUDE_SMTSSLM
#define INCLUDE_SMTSSLM

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for smtssl - SMT SSL agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    char *config;                       /*  Configuration file to use        */
} struct_smtssl_open;

int
put_smtssl_open (
          byte **_buffer,
    const char *config);                /*  Configuration file to use        */

int
get_smtssl_open (
    byte *_buffer,
    struct_smtssl_open **params);

void
free_smtssl_open (
    struct_smtssl_open **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for open - Open SSL port.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_OPEN;

#define declare_smtssl_open(_event, _priority)                                \
    method_declare (agent, SMTSSL_OPEN, _event, _priority)

/*  Send event - open                                                        */

int 
lsend_smtssl_open (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *config);            /*  Configuration file to use        */

#define send_smtssl_open(_to,                                                 \
            config)                                                           \
       lsend_smtssl_open(_to,                                                 \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            config)


typedef struct {
    dbyte port;                         /*  SSL port opened                  */
} struct_smtssl_open_ok;

int
put_smtssl_open_ok (
          byte **_buffer,
    const dbyte port);                  /*  SSL port opened                  */

int
get_smtssl_open_ok (
    byte *_buffer,
    struct_smtssl_open_ok **params);

void
free_smtssl_open_ok (
    struct_smtssl_open_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for open ok - SSL port opened OK.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_OPEN_OK;

#define declare_smtssl_open_ok(_event, _priority)                             \
    method_declare (agent, SMTSSL_OPEN_OK, _event, _priority)

/*  Send event - open ok                                                     */

int 
lsend_smtssl_open_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte port);              /*  SSL port opened                  */

#define send_smtssl_open_ok(_to,                                              \
            port)                                                             \
       lsend_smtssl_open_ok(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            port)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for close - Close SSL port.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_CLOSE;

#define declare_smtssl_close(_event, _priority)                               \
    method_declare (agent, SMTSSL_CLOSE, _event, _priority)

/*  Send event - close                                                       */

#define lsend_smtssl_close(_to, _from,                                        \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSSL_CLOSE,                                             \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtssl_close(_to)                                                \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSSL_CLOSE,                                             \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for restart - Restart SSL connection.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_RESTART;

#define declare_smtssl_restart(_event, _priority)                             \
    method_declare (agent, SMTSSL_RESTART, _event, _priority)

/*  Send event - restart                                                     */

#define lsend_smtssl_restart(_to, _from,                                      \
    _accept, _reject, _expire, _timeout)                                      \
        event_send (_to,                                                      \
                    _from,                                                    \
                    SMTSSL_RESTART,                                           \
                    NULL, 0,                                                  \
                    _accept, _reject, _expire, _timeout)
#define send_smtssl_restart(_to)                                              \
        event_send (_to,                                                      \
                    &thread-> queue-> qid,                                    \
                    SMTSSL_RESTART,                                           \
                    NULL, 0,                                                  \
                    NULL, NULL, NULL, 0)


typedef struct {
    qbyte socket;                      /*  Socket handle for SSL connection  */
    char *user;                        /*  User name                         */
    char *cipher;                      /*  Cipher used                       */
    dbyte verify;                      /*  Level of user verification        */
} struct_smtssl_accepted;

int
put_smtssl_accepted (
          byte **_buffer,
    const qbyte socket,                /*  Socket handle for SSL connection  */
    const char *user,                  /*  User name                         */
    const char *cipher,                /*  Cipher used                       */
    const dbyte verify);               /*  Level of user verification        */

int
get_smtssl_accepted (
    byte *_buffer,
    struct_smtssl_accepted **params);

void
free_smtssl_accepted (
    struct_smtssl_accepted **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for accepted - Accept SSL connection.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_ACCEPTED;

#define declare_smtssl_accepted(_event, _priority)                            \
    method_declare (agent, SMTSSL_ACCEPTED, _event, _priority)

/*  Send event - accepted                                                    */

int 
lsend_smtssl_accepted (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket handle for SSL connection  */
    const char *user,               /*  User name                         */
    const char *cipher,             /*  Cipher used                       */
    const dbyte verify);            /*  Level of user verification        */

#define send_smtssl_accepted(_to,                                             \
            socket,                                                           \
            user,                                                             \
            cipher,                                                           \
            verify)                                                           \
       lsend_smtssl_accepted(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            user,                                                             \
            cipher,                                                           \
            verify)


typedef struct {
    qbyte size;                         /*  Maximum size to read             */
} struct_smtssl_read_request;

int
put_smtssl_read_request (
          byte **_buffer,
    const qbyte size);                  /*  Maximum size to read             */

int
get_smtssl_read_request (
    byte *_buffer,
    struct_smtssl_read_request **params);

void
free_smtssl_read_request (
    struct_smtssl_read_request **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for read request - Request read.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_READ_REQUEST;

#define declare_smtssl_read_request(_event, _priority)                        \
    method_declare (agent, SMTSSL_READ_REQUEST, _event, _priority)

/*  Send event - read request                                                */

int 
lsend_smtssl_read_request (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size);              /*  Maximum size to read             */

#define send_smtssl_read_request(_to,                                         \
            size)                                                             \
       lsend_smtssl_read_request(_to,                                         \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size)


typedef struct {
    dbyte timeout;                      /*  Timeout in seconds, zero = none  */
    qbyte socket;                       /*  Socket to write to               */
    word  size;                         /*  Amount of data to write          */
    void *data;                         /*  Block of data to write           */
    Bool  reply;                        /*  Whether OK reply is required     */
    qbyte tag;                          /*  User-defined request tag         */
} struct_smtssl_write_request;

int
put_smtssl_write_request (
          byte **_buffer,
    const dbyte timeout,                /*  Timeout in seconds, zero = none  */
    const qbyte socket,                 /*  Socket to write to               */
    const word  size,                   /*  Amount of data to write          */
    const void *data,                   /*  Block of data to write           */
    const Bool  reply,                  /*  Whether OK reply is required     */
    const qbyte tag);                   /*  User-defined request tag         */

int
get_smtssl_write_request (
    byte *_buffer,
    struct_smtssl_write_request **params);

void
free_smtssl_write_request (
    struct_smtssl_write_request **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for write request - Write SSL data.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_WRITE_REQUEST;

#define declare_smtssl_write_request(_event, _priority)                       \
    method_declare (agent, SMTSSL_WRITE_REQUEST, _event, _priority)

/*  Send event - write request                                               */

int 
lsend_smtssl_write_request (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const dbyte timeout,            /*  Timeout in seconds, zero = none  */
    const qbyte socket,             /*  Socket to write to               */
    const word  size,               /*  Amount of data to write          */
    const void *data,               /*  Block of data to write           */
    const Bool  reply,              /*  Whether OK reply is required     */
    const qbyte tag);               /*  User-defined request tag         */

#define send_smtssl_write_request(_to,                                        \
            timeout,                                                          \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            reply,                                                            \
            tag)                                                              \
       lsend_smtssl_write_request(_to,                                        \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            timeout,                                                          \
            socket,                                                           \
            size,                                                             \
            data,                                                             \
            reply,                                                            \
            tag)


typedef struct {
    qbyte socket;                       /*  Socket for output                */
    char *filename;                     /*  Name of file to send             */
    qbyte start;                        /*  Starting offset; 0 = start       */
    qbyte end;                          /*  Ending offset; 0 = end           */
} struct_smtssl_put_slice;

int
put_smtssl_put_slice (
          byte **_buffer,
    const qbyte socket,                 /*  Socket for output                */
    const char *filename,               /*  Name of file to send             */
    const qbyte start,                  /*  Starting offset; 0 = start       */
    const qbyte end);                   /*  Ending offset; 0 = end           */

int
get_smtssl_put_slice (
    byte *_buffer,
    struct_smtssl_put_slice **params);

void
free_smtssl_put_slice (
    struct_smtssl_put_slice **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for put slice - Write file slice to SSL socket.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_PUT_SLICE;

#define declare_smtssl_put_slice(_event, _priority)                           \
    method_declare (agent, SMTSSL_PUT_SLICE, _event, _priority)

/*  Send event - put slice                                                   */

int 
lsend_smtssl_put_slice (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket for output                */
    const char *filename,           /*  Name of file to send             */
    const qbyte start,              /*  Starting offset; 0 = start       */
    const qbyte end);               /*  Ending offset; 0 = end           */

#define send_smtssl_put_slice(_to,                                            \
            socket,                                                           \
            filename,                                                         \
            start,                                                            \
            end)                                                              \
       lsend_smtssl_put_slice(_to,                                            \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            filename,                                                         \
            start,                                                            \
            end)


typedef struct {
    qbyte code;                         /*  Error code                       */
} struct_smtssl_error;

int
put_smtssl_error (
          byte **_buffer,
    const qbyte code);                  /*  Error code                       */

int
get_smtssl_error (
    byte *_buffer,
    struct_smtssl_error **params);

void
free_smtssl_error (
    struct_smtssl_error **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - Signal SSL error.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_ERROR;

#define declare_smtssl_error(_event, _priority)                               \
    method_declare (agent, SMTSSL_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_smtssl_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte code);              /*  Error code                       */

#define send_smtssl_error(_to,                                                \
            code)                                                             \
       lsend_smtssl_error(_to,                                                \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            code)


typedef struct {
    qbyte socket;                       /*  Socket used for i/o, or new socket  */
    qbyte tag;                          /*  User-defined request tag         */
} struct_smtssl_write_ok;

int
put_smtssl_write_ok (
          byte **_buffer,
    const qbyte socket,                 /*  Socket used for i/o, or new socket  */
    const qbyte tag);                   /*  User-defined request tag         */

int
get_smtssl_write_ok (
    byte *_buffer,
    struct_smtssl_write_ok **params);

void
free_smtssl_write_ok (
    struct_smtssl_write_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for write ok - Write OK reply.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_WRITE_OK;

#define declare_smtssl_write_ok(_event, _priority)                            \
    method_declare (agent, SMTSSL_WRITE_OK, _event, _priority)

/*  Send event - write ok                                                    */

int 
lsend_smtssl_write_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte socket,             /*  Socket used for i/o, or new socket  */
    const qbyte tag);               /*  User-defined request tag         */

#define send_smtssl_write_ok(_to,                                             \
            socket,                                                           \
            tag)                                                              \
       lsend_smtssl_write_ok(_to,                                             \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            socket,                                                           \
            tag)


typedef struct {
    word  size;                         /*  Size of result                   */
    void *data;                         /*  Read data                        */
} struct_smtssl_read_ok;

int
put_smtssl_read_ok (
          byte **_buffer,
    const word  size,                   /*  Size of result                   */
    const void *data);                  /*  Read data                        */

int
get_smtssl_read_ok (
    byte *_buffer,
    struct_smtssl_read_ok **params);

void
free_smtssl_read_ok (
    struct_smtssl_read_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for read ok - Read result data.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_READ_OK;

#define declare_smtssl_read_ok(_event, _priority)                             \
    method_declare (agent, SMTSSL_READ_OK, _event, _priority)

/*  Send event - read ok                                                     */

int 
lsend_smtssl_read_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const word  size,               /*  Size of result                   */
    const void *data);              /*  Read data                        */

#define send_smtssl_read_ok(_to,                                              \
            size,                                                             \
            data)                                                             \
       lsend_smtssl_read_ok(_to,                                              \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size,                                                             \
            data)


typedef struct {
    qbyte size;                         /*  Amount of transmitted data       */
} struct_smtssl_put_slice_ok;

int
put_smtssl_put_slice_ok (
          byte **_buffer,
    const qbyte size);                  /*  Amount of transmitted data       */

int
get_smtssl_put_slice_ok (
    byte *_buffer,
    struct_smtssl_put_slice_ok **params);

void
free_smtssl_put_slice_ok (
    struct_smtssl_put_slice_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for put slice ok - File written okay.
 *---------------------------------------------------------------------------*/

extern char *SMTSSL_PUT_SLICE_OK;

#define declare_smtssl_put_slice_ok(_event, _priority)                        \
    method_declare (agent, SMTSSL_PUT_SLICE_OK, _event, _priority)

/*  Send event - put slice ok                                                */

int 
lsend_smtssl_put_slice_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const qbyte size);              /*  Amount of transmitted data       */

#define send_smtssl_put_slice_ok(_to,                                         \
            size)                                                             \
       lsend_smtssl_put_slice_ok(_to,                                         \
            &thread-> queue-> qid,                                            \
            NULL, NULL, NULL, 0,                                              \
            size)



#endif                                  /*  Included                         */
/*===========================================================================*
 *                                                                           *
 *  smtrdnsl.h - Reverse-DNS functions                                       *
 *                                                                           *
 *  Copyright (c) 1991-2010 iMatix Corporation                               *
 *                                                                           *
 *  ------------------ GPL Licensed Source Code ------------------           *
 *  iMatix makes this software available under the GNU General               *
 *  Public License (GPL) license for open source projects.  For              *
 *  details of the GPL license please see www.gnu.org or read the            *
 *  file license.gpl provided in this package.                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License as           *
 *  published by the Free Software Foundation; either version 3 of           *
 *  the License, or (at your option) any later version.                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public                *
 *  License along with this program in the file 'license.gpl'; if            *
 *  not, see <http://www.gnu.org/licenses/>.                                 *
 *                                                                           *
 *  You can also license this software under iMatix's General Terms          *
 *  of Business (GTB) for commercial projects.  If you have not              *
 *  explicitly licensed this software under the iMatix GTB you may           *
 *  only use it under the terms of the GNU General Public License.           *
 *                                                                           *
 *  For more information, send an email to info@imatix.com.                  *
 *  --------------------------------------------------------------           *
 *===========================================================================*/

#ifndef _SMTRDNSL_INCLUDED
#define _SMTRDNSL_INCLUDED


/*******************************************************/
/* byte order definition must be included in prelude.h */
/*******************************************************/

#ifndef BYTE_ORDER
#define LITTLE_ENDIAN   1234            /* least-significant first (vax, pc) */
#define BIG_ENDIAN      4321            /* most-significant first (IBM, net) */
#define PDP_ENDIAN      3412            /* LSB first in word, MSW first in
                                           long (pdp)                        */
#if defined (__MSDOS__) || defined (__OS2__) || defined (vax) || \
    defined (ns32000) || defined (sun386)  || defined (__QNX__) || \
    defined (MIPSEL)  || defined (_MIPSEL) || \
    defined (BIT_ZERO_ON_RIGHT) || defined (__alpha__) || defined(__alpha) || \
    defined (i386)    || defined (__i386)
#   define BYTE_ORDER      LITTLE_ENDIAN
#elif defined(sel) || defined(pyr) || defined(mc68000) || defined(sparc) || \
    defined(is68k) || defined(tahoe) || defined(ibm032) || defined(ibm370) || \
    defined(MIPSEB) || defined(_MIPSEB) || defined(_IBMR2) || defined(DGUX) ||\
    defined(apollo) || defined(__convex__) || defined(_CRAY) || \
    defined(__hppa) || defined(__hp9000) || \
    defined(__hp9000s300) || defined(__hp9000s700) || \
    defined (BIT_ZERO_ON_LEFT) || defined(m68k)
#   define BYTE_ORDER      BIG_ENDIAN
#endif

#endif /* BYTE_ORDER */
#if !defined(BYTE_ORDER) || \
    (BYTE_ORDER != BIG_ENDIAN && BYTE_ORDER != LITTLE_ENDIAN && \
    BYTE_ORDER != PDP_ENDIAN)
        /* you must determine what the correct bit order is for
         * your compiler - the next line is an intentional error
         * which will force your compiles to bomb until you fix
         * the above macros.
         */
#  error "Undefined or invalid BYTE_ORDER";
#endif

/*- Defines -----------------------------------------------------------------*/

#define MAX_NS             3            /* Max name servers                  */
#define REQUEST_TIMEOUT    10           /* Min. seconds between request      */
#define RECURSIVE_TIMEOUT  40           /* sec. between recursive request    */
#define QUERY_TIMEOUT      60           /* Query time out (1 min.)           */
#define CONNECT_TIMEOUT    5            /* Max time to connect DN server     */
#define REFRESH_CACHE_TIME 600          /* Refresh cache time (10 min.)      */
#define BAD_RESULT_TTL     120          /* Time To live in cache for bad     *
                                         * result of request                 */

#define REQ_TYPE_HOST      1            /* Request type host name            */
#define REQ_TYPE_IP        2            /* Request type ip address           */

/* Define constants based on RFC 883, RFC 1034, RFC 1035                     */

#define NS_PACKET_SIZE     512          /* Maximum packet size               */
#define NS_MAX_DNAME       1025         /* Maximum domain name               */
#define NS_MAX_CDNAME      255          /* Maximum compressed domain name    */
#define NS_MAX_LABEL       63           /* Maximum length of domain label    */
#define NS_HEAD_FIXED_SIZE 12           /* Size of fixed data in header      */
#define NS_QRY_FIXED_SIZE  4            /* Size of fixed data in query       */
#define NS_RR_FIXED_SIZE   10           /* Size of fixed data in r record    */
#define NS_INT32_SIZE      4            /* Size of data in a 32 bits integer */
#define NS_INT16_SIZE      2            /* Size of data in a 16 bits integer */
#define NS_INT8_SIZE       1            /* Size of data in a 8  bits integer */
#define NS_INADDR_SIZE     4            /* IPv4 T_A                          */
#define NS_IN6ADDR_SIZE    16           /* IPv6 T_AAAA                       */
#define NS_COMPRES_FLAGS   0xc0         /* Flag bits indicating compression. */
#define NS_DEFAULT_PORT    53           /* For both TCP and UDP.             */

#define NS_TIME_OUT        -1
#define NS_NO_INFO         -2
#define NS_ERROR           -3
#define NS_NONAUTH         -4
#define NS_NO_RESPONSE     -5

#define QUERY_BUFFER_SIZE  NS_PACKET_SIZE * 3

/* Currently defined type values for resources and queries.                  */

typedef enum __ns_type {
    ns_t_a        = 1,                  /* Host address.                     */
    ns_t_ns       = 2,                  /* Authoritative server.             */
    ns_t_md       = 3,                  /* Mail destination.                 */
    ns_t_mf       = 4,                  /* Mail forwarder.                   */
    ns_t_cname    = 5,                  /* Canonical name.                   */
    ns_t_soa      = 6,                  /* Start of authority zone.          */
    ns_t_mb       = 7,                  /* Mailbox domain name.              */
    ns_t_mg       = 8,                  /* Mail group member.                */
    ns_t_mr       = 9,                  /* Mail rename name.                 */
    ns_t_null     = 10,                 /* Null resource record.             */
    ns_t_wks      = 11,                 /* Well known service.               */
    ns_t_ptr      = 12,                 /* Domain name pointer.              */
    ns_t_hinfo    = 13,                 /* Host information.                 */
    ns_t_minfo    = 14,                 /* Mailbox information.              */
    ns_t_mx       = 15,                 /* Mail routing information.         */
    ns_t_txt      = 16,                 /* Text strings.                     */
    ns_t_rp       = 17,                 /* Responsible person.               */
    ns_t_afsdb    = 18,                 /* AFS cell database.                */
    ns_t_x25      = 19,                 /* X_25 calling address.             */
    ns_t_isdn     = 20,                 /* ISDN calling address.             */
    ns_t_rt       = 21,                 /* Router.                           */
    ns_t_nsap     = 22,                 /* NSAP address.                     */
    ns_t_nsap_ptr = 23,                 /* Reverse NSAP lookup (deprecated). */
    ns_t_sig      = 24,                 /* Security signature.               */
    ns_t_key      = 25,                 /* Security key.                     */
    ns_t_px       = 26,                 /* X.400 mail mapping.               */
    ns_t_gpos     = 27,                 /* Geographical position (withdrawn) */
    ns_t_aaaa     = 28,                 /* Ip6 Address.                      */
    ns_t_loc      = 29,                 /* Location Information.             */
    ns_t_nxt      = 30,                 /* Next domain (security).           */
    ns_t_eid      = 31,                 /* Endpoint identifier.              */
    ns_t_nimloc   = 32,                 /* Nimrod Locator.                   */
    ns_t_srv      = 33,                 /* Server Selection.                 */
    ns_t_atma     = 34,                 /* ATM Address                       */
    ns_t_naptr    = 35,                 /* Naming Authority PoinTeR          */

   /* Query type values which do not appear in resource records.             */
    ns_t_ixfr     = 251,                /* Incremental zone transfer.        */
    ns_t_axfr     = 252,                /* Transfer zone of authority.       */
    ns_t_mailb    = 253,                /* Transfer mailbox records.         */
    ns_t_maila    = 254,                /* Transfer mail agent records.      */
    ns_t_any      = 255,                /* Wildcard match.                   */
    ns_t_max      = 32767
} ns_type;


/* Values for class field                                                    */

typedef enum __ns_class {
    ns_c_in    = 1,                     /* Internet.                         */
                                        /* Class 2 unallocated/unsupported.  */
    ns_c_chaos = 3,                     /* MIT Chaos-net.                    */
    ns_c_hs    = 4,                     /* MIT Hesiod.                       */

    /* Query class values which do not appear in resource records            */
    ns_c_none  = 254,                   /* for prereq. sect. in update req.  */
    ns_c_any   = 255,                   /* Wildcard match.                   */
    ns_c_max   = 32767
} ns_class;


/*  Currently defined response codes.                                        */

typedef enum __ns_rcode {
    ns_r_noerror  = 0,                  /* No error occurred.                */
    ns_r_formerr  = 1,                  /* Format error.                     */
    ns_r_servfail = 2,                  /* Server failure.                   */
    ns_r_nxdomain = 3,                  /* Name error.                       */
    ns_r_notimpl  = 4,                  /* Unimplemented.                    */
    ns_r_refused  = 5,                  /* Operation refused.                */
    /* these are for UPDATE                                                  */
    ns_r_yxdomain = 6,                  /* Name exists                       */
    ns_r_yxrrset  = 7,                  /* RRset exists                      */
    ns_r_nxrrset  = 8,                  /* RRset does not exist              */
    ns_r_notauth  = 9,                  /* Not authoritative for zone        */
    ns_r_notzone  = 10,                 /* Zone of record different          */
    ns_r_max      = 11
} ns_rcode;

/*- Structure definitions ---------------------------------------------------*/


/* Structure for query header.  The order of the fields is machine- and      *
 * compiler-dependent, depending on the byte/bit order and the layout        *
 * of bit fields.  We use bit fields only in int variables, as this          *
 * is all ANSI requires.  This requires a somewhat confusing rearrangement.  */

typedef struct {
    unsigned id: 16;                    /* query identification number       */
#if BYTE_ORDER == BIG_ENDIAN
    /* fields in third byte                                                  */
    unsigned qr: 1;                     /* response flag                     */
    unsigned opcode: 4;                 /* purpose of message                */
    unsigned aa: 1;                     /* authoritive answer                */
    unsigned tc: 1;                     /* truncated message                 */
    unsigned rd: 1;                     /* recursion desired                 */
    /* fields in fourth byte                                                 */
    unsigned ra: 1;                     /* recursion available               */
    unsigned unused :1;                 /* unused bits                       */
    unsigned ad: 1;                     /* authentic data from named         */
    unsigned cd: 1;                     /* checking disabled by resolver     */
    unsigned rcode :4;                  /* response code                     */
#elif BYTE_ORDER == LITTLE_ENDIAN || BYTE_ORDER == PDP_ENDIAN
    /* fields in third byte                                                  */
    unsigned rd :1;                     /* recursion desired                 */
    unsigned tc :1;                     /* truncated message                 */
    unsigned aa :1;                     /* authoritive answer                */
    unsigned opcode :4;                 /* purpose of message                */
    unsigned qr :1;                     /* response flag                     */
    /* fields in fourth byte                                                 */
    unsigned rcode :4;                  /* response code                     */
    unsigned cd: 1;                     /* checking disabled by resolver     */
    unsigned ad: 1;                     /* authentic data from named         */
    unsigned unused: 1;                 /* unused bits                       */
    unsigned ra: 1;                     /* recursion available               */
#endif
    /* remaining bytes                                                       */
    unsigned qdcount: 16;               /* number of question entries        */
    unsigned ancount: 16;               /* number of answer entries          */
    unsigned nscount: 16;               /* number of authority entries       */
    unsigned arcount: 16;               /* number of resource entries        */
} NS_HEADER;

typedef union {
    NS_HEADER query_header;
    byte      query_buffer [QUERY_BUFFER_SIZE];
} QUERY_BUF;


/* Request structure used in stack                                           */

typedef struct _NS_REQUEST              /*  Name Server Request              */
{
    struct _NS_REQUEST
          *next, *prev;                 /*    Doubly-linked list             */
    char  *host_name;                   /*    Host name                      */
    char  *host_address;                /*    Host ip address (a.b.c.d)      */
    qbyte  host_ip;                     /*    Host ip (network order)        */
    char  *ns_name;                     /*    Name server name               */
    char  *ns_address;                  /*    Name server address (a.b.c.d)  */
    qbyte  ns_ip;                       /*    Name server ip (network order) */
    dbyte  ns_port;                     /*    Name server port               */
    byte   type;                        /*    Type o request (ip address, ...*/
    long   ttl;                         /*    Time To Live                   */
    Bool   recursive;                   /*    Try recursive request          */
    Bool   main_request;                /*    Request created from serverlist*/
    byte   main_index;                  /*    Index in server list           */
} NS_REQUEST;


/* NS_RR_RESULT structure used to store answer result                        */

typedef struct {
  char
      ns_name [NS_MAX_CDNAME + 1];       /*    Domain name server name       */
  struct in_addr
      ns_addr;                           /*    Domain name server address    */
  long
      ttl;                               /*    Time To Live                  */
} NS_RR_RESULT;


/*  DNS configuration for the computer                                       */

typedef struct {
   struct sockaddr_in
       ns_addr [MAX_NS];                /*  Address of name server           */
   short
       ns_count;                        /*  number of name servers           */
   Bool
       recursive_accept [MAX_NS];       /*  Accept recursive query           */
} NS_CTX;

/*- Global variables --------------------------------------------------------*/

extern Bool   dns_debug_mode;           /* Debuf mode flag                   */
extern Bool   dns_recursive;            /* Use Recursive mode if possible    */
extern NS_CTX server_list;              /* Name server list (computer config)*/

/*- Function prototypes -----------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

int        rdns_init              (NS_CTX *p_ns);
QUERY_BUF *rdns_make_query        (char *host_ip, long id, word *size,
                                   Bool recursive);
QUERY_BUF *rdns_make_ip_query     (char *host_name, long id, word *size,
                                   Bool recursive);
Bool       rdns_read_answer       (QUERY_BUF *answer, word size,
                                   NS_REQUEST *current, SYMTAB *invalid_ns,
                                   NS_RR_RESULT *rr_tab, dbyte rr_nbr);
NS_REQUEST *rdns_request_alloc    (qbyte ip_address, char *ip_value,
                                   char *host_name, byte request_type);
void       rdns_request_free      (NS_REQUEST *request);
Bool       is_request_host_exist  (NS_REQUEST *head, char *hos_name, byte type);
Bool       is_request_ns_exist    (NS_REQUEST *head, qbyte ip_addr,  byte type);
dbyte      rdns_get_nbr_rr_result (QUERY_BUF *answer);
Bool       rdns_is_recursive      (QUERY_BUF *answer);
Bool       rdns_check_answer_size (QUERY_BUF *answer, dbyte read_size);
#ifdef __cplusplus
}
#endif

#endif
/*===========================================================================*
 *                                                                           *
 *  smtxlog.h - SMT extended logging agent                                   *
 *                                                                           *
 *  Copyright (c) 1991-2010 iMatix Corporation                               *
 *                                                                           *
 *  ------------------ GPL Licensed Source Code ------------------           *
 *  iMatix makes this software available under the GNU General               *
 *  Public License (GPL) license for open source projects.  For              *
 *  details of the GPL license please see www.gnu.org or read the            *
 *  file license.gpl provided in this package.                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License as           *
 *  published by the Free Software Foundation; either version 3 of           *
 *  the License, or (at your option) any later version.                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public                *
 *  License along with this program in the file 'license.gpl'; if            *
 *  not, see <http://www.gnu.org/licenses/>.                                 *
 *                                                                           *
 *  You can also license this software under iMatix's General Terms          *
 *  of Business (GTB) for commercial projects.  If you have not              *
 *  explicitly licensed this software under the iMatix GTB you may           *
 *  only use it under the terms of the GNU General Public License.           *
 *                                                                           *
 *  For more information, send an email to info@imatix.com.                  *
 *  --------------------------------------------------------------           *
 *===========================================================================*/

#ifndef _SMTXLOG_INCLUDED                /*  Allow multiple inclusions        */
#define _SMTXLOG_INCLUDED


/*- Constants ---------------------------------------------------------------*/

#define SMTXLOG_AGENT     "smtxlog"     /*  Xixlog agent name                */


/*  When to cycle the log file                                               */

#define XLOG_CYCLE_STARTUP  "startup"   /*  Cycle when starting the server   */
#define XLOG_CYCLE_HOURLY   "hourly"    /*  Cycle every hour at X minutes    */
#define XLOG_CYCLE_DAILY    "daily"     /*  Cycle every day at hh:mm         */
#define XLOG_CYCLE_WEEKLY   "weekly"    /*  Cycle every week at dd:hh:mm     */
#define XLOG_CYCLE_MONTHLY  "monthly"   /*  Cycle every month at dd:hh:mm    */
#define XLOG_CYCLE_SIZE     "size"      /*  Cycle when exceeds X Kb          */
#define XLOG_CYCLE_LINES    "lines"     /*  Cycle when exceeds X lines       */
#define XLOG_CYCLE_MANUAL   "manual"    /*  Do not cycle the log file        */

/*  How to cycle the log file                                                */

#define XLOG_CYCLE_RENAME   "rename"    /*  Rename old file                  */
#define XLOG_CYCLE_DELETE   "delete"    /*  Delete old file                  */
#define XLOG_CYCLE_MOVE     "move"      /*  Move old file to another path    */
#define XLOG_CYCLE_CONCAT   "concat"    /*  Concat old data to file          */
#define XLOG_CYCLE_PROCESS  "process"   /*  Execute some command on file     */

/*  Log file statistics, updated in each thread's TCB                        */

typedef struct {
    qbyte file_size;                    /*    Log file size, in bytes        */
    qbyte file_lines;                   /*    Log file size, in lines        */
} XLOG_STATS;


/*- Function prototypes -----------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

int  smtxlog_init (void);
void smtxlog_log  (QID *to, char *log_file, SYMTAB *table);

#ifdef __cplusplus
}

#endif

#endif
