// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"testing"

	"code.forgejo.org/f3/gof3/v3/id"
	"code.forgejo.org/f3/gof3/v3/tree/generic"
	"code.forgejo.org/f3/gof3/v3/util"

	"github.com/stretchr/testify/assert"
)

func TestF3Path(t *testing.T) {
	p := NewPathFromString("/")
	p = p.SetForge()
	{
		p.Root().Forge()
	}
	nodeIDs := make([]id.NodeID, 0, 10)
	{
		p := p.SetOwners(KindUsers)
		i := "1"
		ownerID := util.ParseInt(i)
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Users().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())

		{
			p := p.SetProjects()
			i := "2"
			projectID := util.ParseInt(i)
			nodeIDs := append(nodeIDs, id.NewNodeID(i))
			p = p.AppendID(i)
			assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Users().Ignore().Projects().First().(generic.NodeInterface).GetID())
			assert.EqualValues(t, nodeIDs, p.NodeIDs())
			owner, project := p.OwnerAndProjectID()
			assert.EqualValues(t, ownerID, owner)
			assert.EqualValues(t, projectID, project)
		}
	}

	{
		p := p.SetAttachments()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Attachments().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetComments()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Comments().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetIssues()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Issues().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetLabels()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Labels().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetMilestones()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Milestones().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetOrganizations()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Organizations().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetProjects()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Projects().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetPullRequests()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().PullRequests().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetReactions()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Reactions().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetReleases()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Releases().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetRepositories()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Repositories().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetReviews()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Reviews().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetReviewComments()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().ReviewComments().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetTopics()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Topics().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}

	{
		p := p.SetUsers()
		i := "something"
		nodeIDs := append(nodeIDs, id.NewNodeID(i))
		p = p.AppendID(i)
		assert.EqualValues(t, id.NewNodeID(i), p.Root().Forge().Users().First().(generic.NodeInterface).GetID())
		assert.EqualValues(t, nodeIDs, p.NodeIDs())
	}
}
