// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents the data for an attribute. Each attribute value is described as a
// name-value pair. The name is the data type, and the value is the data itself.
// For more information, see Data Types
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
// in the Amazon DynamoDB Developer Guide.
//
// The following types satisfy this interface:
//
//	AttributeValueMemberB
//	AttributeValueMemberBOOL
//	AttributeValueMemberBS
//	AttributeValueMemberL
//	AttributeValueMemberM
//	AttributeValueMemberN
//	AttributeValueMemberNS
//	AttributeValueMemberNULL
//	AttributeValueMemberS
//	AttributeValueMemberSS
type AttributeValue interface {
	isAttributeValue()
}

// An attribute of type Binary. For example: "B":
// "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
type AttributeValueMemberB struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*AttributeValueMemberB) isAttributeValue() {}

// An attribute of type Boolean. For example: "BOOL": true
type AttributeValueMemberBOOL struct {
	Value bool

	noSmithyDocumentSerde
}

func (*AttributeValueMemberBOOL) isAttributeValue() {}

// An attribute of type Binary Set. For example: "BS": ["U3Vubnk=", "UmFpbnk=",
// "U25vd3k="]
type AttributeValueMemberBS struct {
	Value [][]byte

	noSmithyDocumentSerde
}

func (*AttributeValueMemberBS) isAttributeValue() {}

// An attribute of type List. For example: "L": [ {"S": "Cookies"} , {"S":
// "Coffee"}, {"N": "3.14159"}]
type AttributeValueMemberL struct {
	Value []AttributeValue

	noSmithyDocumentSerde
}

func (*AttributeValueMemberL) isAttributeValue() {}

// An attribute of type Map. For example: "M": {"Name": {"S": "Joe"}, "Age": {"N":
// "35"}}
type AttributeValueMemberM struct {
	Value map[string]AttributeValue

	noSmithyDocumentSerde
}

func (*AttributeValueMemberM) isAttributeValue() {}

// An attribute of type Number. For example: "N": "123.45" Numbers are sent across
// the network to DynamoDB as strings, to maximize compatibility across languages
// and libraries. However, DynamoDB treats them as number type attributes for
// mathematical operations.
type AttributeValueMemberN struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberN) isAttributeValue() {}

// An attribute of type Number Set. For example: "NS": ["42.2", "-19", "7.5",
// "3.14"] Numbers are sent across the network to DynamoDB as strings, to maximize
// compatibility across languages and libraries. However, DynamoDB treats them as
// number type attributes for mathematical operations.
type AttributeValueMemberNS struct {
	Value []string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberNS) isAttributeValue() {}

// An attribute of type Null. For example: "NULL": true
type AttributeValueMemberNULL struct {
	Value bool

	noSmithyDocumentSerde
}

func (*AttributeValueMemberNULL) isAttributeValue() {}

// An attribute of type String. For example: "S": "Hello"
type AttributeValueMemberS struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberS) isAttributeValue() {}

// An attribute of type String Set. For example: "SS": ["Giraffe", "Hippo"
// ,"Zebra"]
type AttributeValueMemberSS struct {
	Value []string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberSS) isAttributeValue() {}

// Contains details about the type of identity that made the request.
type Identity struct {

	// A unique identifier for the entity that made the call. For Time To Live, the
	// principalId is "dynamodb.amazonaws.com".
	PrincipalId *string

	// The type of the identity. For Time To Live, the type is "Service".
	Type *string

	noSmithyDocumentSerde
}

// Represents a single element of a key schema. A key schema specifies the
// attributes that make up the primary key of a table, or the key attributes of an
// index. A KeySchemaElement represents exactly one attribute of the primary key.
// For example, a simple primary key would be represented by one KeySchemaElement
// (for the partition key). A composite primary key would require one
// KeySchemaElement for the partition key, and another KeySchemaElement for the
// sort key. A KeySchemaElement must be a scalar, top-level attribute (not a nested
// attribute). The data type must be one of String, Number, or Binary. The
// attribute cannot be nested within a List or a Map.
type KeySchemaElement struct {

	// The name of a key attribute.
	//
	// This member is required.
	AttributeName *string

	// The role that this key attribute will assume:
	//
	// * HASH - partition key
	//
	// * RANGE -
	// sort key
	//
	// The partition key of an item is also known as its hash attribute. The
	// term "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition key
	// values. The sort key of an item is also known as its range attribute. The term
	// "range attribute" derives from the way DynamoDB stores items with the same
	// partition key physically close together, in sorted order by the sort key value.
	//
	// This member is required.
	KeyType KeyType

	noSmithyDocumentSerde
}

// A description of a unique event within a stream.
type Record struct {

	// The region in which the GetRecords request was received.
	AwsRegion *string

	// The main body of the stream record, containing all of the DynamoDB-specific
	// fields.
	Dynamodb *StreamRecord

	// A globally unique identifier for the event that was recorded in this stream
	// record.
	EventID *string

	// The type of data modification that was performed on the DynamoDB table:
	//
	// *
	// INSERT - a new item was added to the table.
	//
	// * MODIFY - one or more of an
	// existing item's attributes were modified.
	//
	// * REMOVE - the item was deleted from
	// the table
	EventName OperationType

	// The AWS service from which the stream record originated. For DynamoDB Streams,
	// this is aws:dynamodb.
	EventSource *string

	// The version number of the stream record format. This number is updated whenever
	// the structure of Record is modified. Client applications must not assume that
	// eventVersion will remain at a particular value, as this number is subject to
	// change at any time. In general, eventVersion will only increase as the low-level
	// DynamoDB Streams API evolves.
	EventVersion *string

	// Items that are deleted by the Time to Live process after expiration have the
	// following fields:
	//
	// * Records[].userIdentity.type "Service"
	//
	// *
	// Records[].userIdentity.principalId "dynamodb.amazonaws.com"
	UserIdentity *Identity

	noSmithyDocumentSerde
}

// The beginning and ending sequence numbers for the stream records contained
// within a shard.
type SequenceNumberRange struct {

	// The last sequence number for the stream records contained within a shard. String
	// contains numeric characters only.
	EndingSequenceNumber *string

	// The first sequence number for the stream records contained within a shard.
	// String contains numeric characters only.
	StartingSequenceNumber *string

	noSmithyDocumentSerde
}

// A uniquely identified group of stream records within a stream.
type Shard struct {

	// The shard ID of the current shard's parent.
	ParentShardId *string

	// The range of possible sequence numbers for the shard.
	SequenceNumberRange *SequenceNumberRange

	// The system-generated identifier for this shard.
	ShardId *string

	noSmithyDocumentSerde
}

// Represents all of the data describing a particular stream.
type Stream struct {

	// The Amazon Resource Name (ARN) for the stream.
	StreamArn *string

	// A timestamp, in ISO 8601 format, for this stream. Note that LatestStreamLabel is
	// not a unique identifier for the stream, because it is possible that a stream
	// from another table might have the same timestamp. However, the combination of
	// the following three elements is guaranteed to be unique:
	//
	// * the AWS customer
	// ID.
	//
	// * the table name
	//
	// * the StreamLabel
	StreamLabel *string

	// The DynamoDB table with which the stream is associated.
	TableName *string

	noSmithyDocumentSerde
}

// Represents all of the data describing a particular stream.
type StreamDescription struct {

	// The date and time when the request to create this stream was issued.
	CreationRequestDateTime *time.Time

	// The key attribute(s) of the stream's DynamoDB table.
	KeySchema []KeySchemaElement

	// The shard ID of the item where the operation stopped, inclusive of the previous
	// result set. Use this value to start a new operation, excluding this value in the
	// new request. If LastEvaluatedShardId is empty, then the "last page" of results
	// has been processed and there is currently no more data to be retrieved. If
	// LastEvaluatedShardId is not empty, it does not necessarily mean that there is
	// more data in the result set. The only way to know when you have reached the end
	// of the result set is when LastEvaluatedShardId is empty.
	LastEvaluatedShardId *string

	// The shards that comprise the stream.
	Shards []Shard

	// The Amazon Resource Name (ARN) for the stream.
	StreamArn *string

	// A timestamp, in ISO 8601 format, for this stream. Note that LatestStreamLabel is
	// not a unique identifier for the stream, because it is possible that a stream
	// from another table might have the same timestamp. However, the combination of
	// the following three elements is guaranteed to be unique:
	//
	// * the AWS customer
	// ID.
	//
	// * the table name
	//
	// * the StreamLabel
	StreamLabel *string

	// Indicates the current status of the stream:
	//
	// * ENABLING - Streams is currently
	// being enabled on the DynamoDB table.
	//
	// * ENABLED - the stream is enabled.
	//
	// *
	// DISABLING - Streams is currently being disabled on the DynamoDB table.
	//
	// *
	// DISABLED - the stream is disabled.
	StreamStatus StreamStatus

	// Indicates the format of the records within this stream:
	//
	// * KEYS_ONLY - only the
	// key attributes of items that were modified in the DynamoDB table.
	//
	// * NEW_IMAGE -
	// entire items from the table, as they appeared after they were modified.
	//
	// *
	// OLD_IMAGE - entire items from the table, as they appeared before they were
	// modified.
	//
	// * NEW_AND_OLD_IMAGES - both the new and the old images of the items
	// from the table.
	StreamViewType StreamViewType

	// The DynamoDB table with which the stream is associated.
	TableName *string

	noSmithyDocumentSerde
}

// A description of a single data modification that was performed on an item in a
// DynamoDB table.
type StreamRecord struct {

	// The approximate date and time when the stream record was created, in UNIX epoch
	// time (http://www.epochconverter.com/) format.
	ApproximateCreationDateTime *time.Time

	// The primary key attribute(s) for the DynamoDB item that was modified.
	Keys map[string]AttributeValue

	// The item in the DynamoDB table as it appeared after it was modified.
	NewImage map[string]AttributeValue

	// The item in the DynamoDB table as it appeared before it was modified.
	OldImage map[string]AttributeValue

	// The sequence number of the stream record.
	SequenceNumber *string

	// The size of the stream record, in bytes.
	SizeBytes *int64

	// The type of data from the modified DynamoDB item that was captured in this
	// stream record:
	//
	// * KEYS_ONLY - only the key attributes of the modified item.
	//
	// *
	// NEW_IMAGE - the entire item, as it appeared after it was modified.
	//
	// * OLD_IMAGE
	// - the entire item, as it appeared before it was modified.
	//
	// * NEW_AND_OLD_IMAGES
	// - both the new and the old item images of the item.
	StreamViewType StreamViewType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAttributeValue() {}
