// Code generated by smithy-go-codegen DO NOT EDIT.

package licensemanager

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/licensemanager/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcceptGrant struct {
}

func (*validateOpAcceptGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCheckInLicense struct {
}

func (*validateOpCheckInLicense) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCheckInLicense) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CheckInLicenseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCheckInLicenseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCheckoutBorrowLicense struct {
}

func (*validateOpCheckoutBorrowLicense) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCheckoutBorrowLicense) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CheckoutBorrowLicenseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCheckoutBorrowLicenseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCheckoutLicense struct {
}

func (*validateOpCheckoutLicense) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCheckoutLicense) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CheckoutLicenseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCheckoutLicenseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateGrant struct {
}

func (*validateOpCreateGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateGrantVersion struct {
}

func (*validateOpCreateGrantVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateGrantVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateGrantVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateGrantVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLicenseConfiguration struct {
}

func (*validateOpCreateLicenseConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLicenseConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLicenseConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLicenseConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLicenseConversionTaskForResource struct {
}

func (*validateOpCreateLicenseConversionTaskForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLicenseConversionTaskForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLicenseConversionTaskForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLicenseConversionTaskForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLicense struct {
}

func (*validateOpCreateLicense) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLicense) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLicenseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLicenseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLicenseManagerReportGenerator struct {
}

func (*validateOpCreateLicenseManagerReportGenerator) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLicenseManagerReportGenerator) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLicenseManagerReportGeneratorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLicenseManagerReportGeneratorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLicenseVersion struct {
}

func (*validateOpCreateLicenseVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLicenseVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLicenseVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLicenseVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateToken struct {
}

func (*validateOpCreateToken) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateToken) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateTokenInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateTokenInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteGrant struct {
}

func (*validateOpDeleteGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteLicenseConfiguration struct {
}

func (*validateOpDeleteLicenseConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteLicenseConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteLicenseConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteLicenseConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteLicense struct {
}

func (*validateOpDeleteLicense) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteLicense) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteLicenseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteLicenseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteLicenseManagerReportGenerator struct {
}

func (*validateOpDeleteLicenseManagerReportGenerator) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteLicenseManagerReportGenerator) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteLicenseManagerReportGeneratorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteLicenseManagerReportGeneratorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteToken struct {
}

func (*validateOpDeleteToken) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteToken) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTokenInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTokenInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpExtendLicenseConsumption struct {
}

func (*validateOpExtendLicenseConsumption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpExtendLicenseConsumption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ExtendLicenseConsumptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpExtendLicenseConsumptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAccessToken struct {
}

func (*validateOpGetAccessToken) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAccessToken) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAccessTokenInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAccessTokenInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetGrant struct {
}

func (*validateOpGetGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLicenseConfiguration struct {
}

func (*validateOpGetLicenseConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLicenseConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLicenseConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLicenseConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLicenseConversionTask struct {
}

func (*validateOpGetLicenseConversionTask) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLicenseConversionTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLicenseConversionTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLicenseConversionTaskInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLicense struct {
}

func (*validateOpGetLicense) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLicense) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLicenseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLicenseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLicenseManagerReportGenerator struct {
}

func (*validateOpGetLicenseManagerReportGenerator) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLicenseManagerReportGenerator) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLicenseManagerReportGeneratorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLicenseManagerReportGeneratorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLicenseUsage struct {
}

func (*validateOpGetLicenseUsage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLicenseUsage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLicenseUsageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLicenseUsageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAssociationsForLicenseConfiguration struct {
}

func (*validateOpListAssociationsForLicenseConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAssociationsForLicenseConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAssociationsForLicenseConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAssociationsForLicenseConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFailuresForLicenseConfigurationOperations struct {
}

func (*validateOpListFailuresForLicenseConfigurationOperations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFailuresForLicenseConfigurationOperations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFailuresForLicenseConfigurationOperationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFailuresForLicenseConfigurationOperationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListLicenseSpecificationsForResource struct {
}

func (*validateOpListLicenseSpecificationsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListLicenseSpecificationsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListLicenseSpecificationsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListLicenseSpecificationsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListLicenseVersions struct {
}

func (*validateOpListLicenseVersions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListLicenseVersions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListLicenseVersionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListLicenseVersionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListResourceInventory struct {
}

func (*validateOpListResourceInventory) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListResourceInventory) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListResourceInventoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListResourceInventoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListUsageForLicenseConfiguration struct {
}

func (*validateOpListUsageForLicenseConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListUsageForLicenseConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListUsageForLicenseConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListUsageForLicenseConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRejectGrant struct {
}

func (*validateOpRejectGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRejectGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RejectGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRejectGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateLicenseConfiguration struct {
}

func (*validateOpUpdateLicenseConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateLicenseConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateLicenseConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateLicenseConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateLicenseManagerReportGenerator struct {
}

func (*validateOpUpdateLicenseManagerReportGenerator) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateLicenseManagerReportGenerator) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateLicenseManagerReportGeneratorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateLicenseManagerReportGeneratorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateLicenseSpecificationsForResource struct {
}

func (*validateOpUpdateLicenseSpecificationsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateLicenseSpecificationsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateLicenseSpecificationsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateLicenseSpecificationsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateServiceSettings struct {
}

func (*validateOpUpdateServiceSettings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateServiceSettings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateServiceSettingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateServiceSettingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcceptGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptGrant{}, middleware.After)
}

func addOpCheckInLicenseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCheckInLicense{}, middleware.After)
}

func addOpCheckoutBorrowLicenseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCheckoutBorrowLicense{}, middleware.After)
}

func addOpCheckoutLicenseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCheckoutLicense{}, middleware.After)
}

func addOpCreateGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateGrant{}, middleware.After)
}

func addOpCreateGrantVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateGrantVersion{}, middleware.After)
}

func addOpCreateLicenseConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLicenseConfiguration{}, middleware.After)
}

func addOpCreateLicenseConversionTaskForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLicenseConversionTaskForResource{}, middleware.After)
}

func addOpCreateLicenseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLicense{}, middleware.After)
}

func addOpCreateLicenseManagerReportGeneratorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLicenseManagerReportGenerator{}, middleware.After)
}

func addOpCreateLicenseVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLicenseVersion{}, middleware.After)
}

func addOpCreateTokenValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateToken{}, middleware.After)
}

func addOpDeleteGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteGrant{}, middleware.After)
}

func addOpDeleteLicenseConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteLicenseConfiguration{}, middleware.After)
}

func addOpDeleteLicenseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteLicense{}, middleware.After)
}

func addOpDeleteLicenseManagerReportGeneratorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteLicenseManagerReportGenerator{}, middleware.After)
}

func addOpDeleteTokenValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteToken{}, middleware.After)
}

func addOpExtendLicenseConsumptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpExtendLicenseConsumption{}, middleware.After)
}

func addOpGetAccessTokenValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAccessToken{}, middleware.After)
}

func addOpGetGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetGrant{}, middleware.After)
}

func addOpGetLicenseConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLicenseConfiguration{}, middleware.After)
}

func addOpGetLicenseConversionTaskValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLicenseConversionTask{}, middleware.After)
}

func addOpGetLicenseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLicense{}, middleware.After)
}

func addOpGetLicenseManagerReportGeneratorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLicenseManagerReportGenerator{}, middleware.After)
}

func addOpGetLicenseUsageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLicenseUsage{}, middleware.After)
}

func addOpListAssociationsForLicenseConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAssociationsForLicenseConfiguration{}, middleware.After)
}

func addOpListFailuresForLicenseConfigurationOperationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFailuresForLicenseConfigurationOperations{}, middleware.After)
}

func addOpListLicenseSpecificationsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListLicenseSpecificationsForResource{}, middleware.After)
}

func addOpListLicenseVersionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListLicenseVersions{}, middleware.After)
}

func addOpListResourceInventoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListResourceInventory{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpListUsageForLicenseConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListUsageForLicenseConfiguration{}, middleware.After)
}

func addOpRejectGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRejectGrant{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateLicenseConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateLicenseConfiguration{}, middleware.After)
}

func addOpUpdateLicenseManagerReportGeneratorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateLicenseManagerReportGenerator{}, middleware.After)
}

func addOpUpdateLicenseSpecificationsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateLicenseSpecificationsForResource{}, middleware.After)
}

func addOpUpdateServiceSettingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateServiceSettings{}, middleware.After)
}

func validateBorrowConfiguration(v *types.BorrowConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BorrowConfiguration"}
	if v.AllowEarlyCheckIn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AllowEarlyCheckIn"))
	}
	if v.MaxTimeToLiveInMinutes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxTimeToLiveInMinutes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConsumptionConfiguration(v *types.ConsumptionConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConsumptionConfiguration"}
	if v.ProvisionalConfiguration != nil {
		if err := validateProvisionalConfiguration(v.ProvisionalConfiguration); err != nil {
			invalidParams.AddNested("ProvisionalConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.BorrowConfiguration != nil {
		if err := validateBorrowConfiguration(v.BorrowConfiguration); err != nil {
			invalidParams.AddNested("BorrowConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDatetimeRange(v *types.DatetimeRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DatetimeRange"}
	if v.Begin == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Begin"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEntitlement(v *types.Entitlement) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Entitlement"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Unit) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Unit"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEntitlementData(v *types.EntitlementData) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EntitlementData"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Unit) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Unit"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEntitlementDataList(v []types.EntitlementData) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EntitlementDataList"}
	for i := range v {
		if err := validateEntitlementData(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEntitlementList(v []types.Entitlement) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EntitlementList"}
	for i := range v {
		if err := validateEntitlement(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInventoryFilter(v *types.InventoryFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InventoryFilter"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Condition) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Condition"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInventoryFilterList(v []types.InventoryFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InventoryFilterList"}
	for i := range v {
		if err := validateInventoryFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIssuer(v *types.Issuer) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Issuer"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLicenseSpecification(v *types.LicenseSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LicenseSpecification"}
	if v.LicenseConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLicenseSpecifications(v []types.LicenseSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LicenseSpecifications"}
	for i := range v {
		if err := validateLicenseSpecification(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOrganizationConfiguration(v *types.OrganizationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OrganizationConfiguration"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProductInformation(v *types.ProductInformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProductInformation"}
	if v.ResourceType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceType"))
	}
	if v.ProductInformationFilterList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductInformationFilterList"))
	} else if v.ProductInformationFilterList != nil {
		if err := validateProductInformationFilterList(v.ProductInformationFilterList); err != nil {
			invalidParams.AddNested("ProductInformationFilterList", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProductInformationFilter(v *types.ProductInformationFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProductInformationFilter"}
	if v.ProductInformationFilterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductInformationFilterName"))
	}
	if v.ProductInformationFilterComparator == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductInformationFilterComparator"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProductInformationFilterList(v []types.ProductInformationFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProductInformationFilterList"}
	for i := range v {
		if err := validateProductInformationFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProductInformationList(v []types.ProductInformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProductInformationList"}
	for i := range v {
		if err := validateProductInformation(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProvisionalConfiguration(v *types.ProvisionalConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProvisionalConfiguration"}
	if v.MaxTimeToLiveInMinutes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxTimeToLiveInMinutes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReportContext(v *types.ReportContext) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReportContext"}
	if v.LicenseConfigurationArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConfigurationArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptGrantInput(v *AcceptGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptGrantInput"}
	if v.GrantArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GrantArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCheckInLicenseInput(v *CheckInLicenseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CheckInLicenseInput"}
	if v.LicenseConsumptionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConsumptionToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCheckoutBorrowLicenseInput(v *CheckoutBorrowLicenseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CheckoutBorrowLicenseInput"}
	if v.LicenseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseArn"))
	}
	if v.Entitlements == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Entitlements"))
	} else if v.Entitlements != nil {
		if err := validateEntitlementDataList(v.Entitlements); err != nil {
			invalidParams.AddNested("Entitlements", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.DigitalSignatureMethod) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DigitalSignatureMethod"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCheckoutLicenseInput(v *CheckoutLicenseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CheckoutLicenseInput"}
	if v.ProductSKU == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductSKU"))
	}
	if len(v.CheckoutType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("CheckoutType"))
	}
	if v.KeyFingerprint == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyFingerprint"))
	}
	if v.Entitlements == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Entitlements"))
	} else if v.Entitlements != nil {
		if err := validateEntitlementDataList(v.Entitlements); err != nil {
			invalidParams.AddNested("Entitlements", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateGrantInput(v *CreateGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateGrantInput"}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.GrantName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GrantName"))
	}
	if v.LicenseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseArn"))
	}
	if v.Principals == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Principals"))
	}
	if v.HomeRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HomeRegion"))
	}
	if v.AllowedOperations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AllowedOperations"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateGrantVersionInput(v *CreateGrantVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateGrantVersionInput"}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.GrantArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GrantArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLicenseConfigurationInput(v *CreateLicenseConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLicenseConfigurationInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.LicenseCountingType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseCountingType"))
	}
	if v.ProductInformationList != nil {
		if err := validateProductInformationList(v.ProductInformationList); err != nil {
			invalidParams.AddNested("ProductInformationList", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLicenseConversionTaskForResourceInput(v *CreateLicenseConversionTaskForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLicenseConversionTaskForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.SourceLicenseContext == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceLicenseContext"))
	}
	if v.DestinationLicenseContext == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationLicenseContext"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLicenseInput(v *CreateLicenseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLicenseInput"}
	if v.LicenseName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseName"))
	}
	if v.ProductName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductName"))
	}
	if v.ProductSKU == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductSKU"))
	}
	if v.Issuer == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Issuer"))
	} else if v.Issuer != nil {
		if err := validateIssuer(v.Issuer); err != nil {
			invalidParams.AddNested("Issuer", err.(smithy.InvalidParamsError))
		}
	}
	if v.HomeRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HomeRegion"))
	}
	if v.Validity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Validity"))
	} else if v.Validity != nil {
		if err := validateDatetimeRange(v.Validity); err != nil {
			invalidParams.AddNested("Validity", err.(smithy.InvalidParamsError))
		}
	}
	if v.Entitlements == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Entitlements"))
	} else if v.Entitlements != nil {
		if err := validateEntitlementList(v.Entitlements); err != nil {
			invalidParams.AddNested("Entitlements", err.(smithy.InvalidParamsError))
		}
	}
	if v.Beneficiary == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Beneficiary"))
	}
	if v.ConsumptionConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConsumptionConfiguration"))
	} else if v.ConsumptionConfiguration != nil {
		if err := validateConsumptionConfiguration(v.ConsumptionConfiguration); err != nil {
			invalidParams.AddNested("ConsumptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLicenseManagerReportGeneratorInput(v *CreateLicenseManagerReportGeneratorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLicenseManagerReportGeneratorInput"}
	if v.ReportGeneratorName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportGeneratorName"))
	}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.ReportContext == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportContext"))
	} else if v.ReportContext != nil {
		if err := validateReportContext(v.ReportContext); err != nil {
			invalidParams.AddNested("ReportContext", err.(smithy.InvalidParamsError))
		}
	}
	if v.ReportFrequency == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportFrequency"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLicenseVersionInput(v *CreateLicenseVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLicenseVersionInput"}
	if v.LicenseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseArn"))
	}
	if v.LicenseName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseName"))
	}
	if v.ProductName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductName"))
	}
	if v.Issuer == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Issuer"))
	} else if v.Issuer != nil {
		if err := validateIssuer(v.Issuer); err != nil {
			invalidParams.AddNested("Issuer", err.(smithy.InvalidParamsError))
		}
	}
	if v.HomeRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HomeRegion"))
	}
	if v.Validity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Validity"))
	} else if v.Validity != nil {
		if err := validateDatetimeRange(v.Validity); err != nil {
			invalidParams.AddNested("Validity", err.(smithy.InvalidParamsError))
		}
	}
	if v.Entitlements == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Entitlements"))
	} else if v.Entitlements != nil {
		if err := validateEntitlementList(v.Entitlements); err != nil {
			invalidParams.AddNested("Entitlements", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConsumptionConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConsumptionConfiguration"))
	} else if v.ConsumptionConfiguration != nil {
		if err := validateConsumptionConfiguration(v.ConsumptionConfiguration); err != nil {
			invalidParams.AddNested("ConsumptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateTokenInput(v *CreateTokenInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTokenInput"}
	if v.LicenseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseArn"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteGrantInput(v *DeleteGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteGrantInput"}
	if v.GrantArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GrantArn"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteLicenseConfigurationInput(v *DeleteLicenseConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteLicenseConfigurationInput"}
	if v.LicenseConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteLicenseInput(v *DeleteLicenseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteLicenseInput"}
	if v.LicenseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseArn"))
	}
	if v.SourceVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteLicenseManagerReportGeneratorInput(v *DeleteLicenseManagerReportGeneratorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteLicenseManagerReportGeneratorInput"}
	if v.LicenseManagerReportGeneratorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseManagerReportGeneratorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTokenInput(v *DeleteTokenInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTokenInput"}
	if v.TokenId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TokenId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpExtendLicenseConsumptionInput(v *ExtendLicenseConsumptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExtendLicenseConsumptionInput"}
	if v.LicenseConsumptionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConsumptionToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAccessTokenInput(v *GetAccessTokenInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAccessTokenInput"}
	if v.Token == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Token"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetGrantInput(v *GetGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetGrantInput"}
	if v.GrantArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GrantArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLicenseConfigurationInput(v *GetLicenseConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLicenseConfigurationInput"}
	if v.LicenseConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLicenseConversionTaskInput(v *GetLicenseConversionTaskInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLicenseConversionTaskInput"}
	if v.LicenseConversionTaskId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConversionTaskId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLicenseInput(v *GetLicenseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLicenseInput"}
	if v.LicenseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLicenseManagerReportGeneratorInput(v *GetLicenseManagerReportGeneratorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLicenseManagerReportGeneratorInput"}
	if v.LicenseManagerReportGeneratorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseManagerReportGeneratorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLicenseUsageInput(v *GetLicenseUsageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLicenseUsageInput"}
	if v.LicenseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAssociationsForLicenseConfigurationInput(v *ListAssociationsForLicenseConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAssociationsForLicenseConfigurationInput"}
	if v.LicenseConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFailuresForLicenseConfigurationOperationsInput(v *ListFailuresForLicenseConfigurationOperationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFailuresForLicenseConfigurationOperationsInput"}
	if v.LicenseConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListLicenseSpecificationsForResourceInput(v *ListLicenseSpecificationsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListLicenseSpecificationsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListLicenseVersionsInput(v *ListLicenseVersionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListLicenseVersionsInput"}
	if v.LicenseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListResourceInventoryInput(v *ListResourceInventoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListResourceInventoryInput"}
	if v.Filters != nil {
		if err := validateInventoryFilterList(v.Filters); err != nil {
			invalidParams.AddNested("Filters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListUsageForLicenseConfigurationInput(v *ListUsageForLicenseConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListUsageForLicenseConfigurationInput"}
	if v.LicenseConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRejectGrantInput(v *RejectGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RejectGrantInput"}
	if v.GrantArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GrantArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateLicenseConfigurationInput(v *UpdateLicenseConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateLicenseConfigurationInput"}
	if v.LicenseConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseConfigurationArn"))
	}
	if v.ProductInformationList != nil {
		if err := validateProductInformationList(v.ProductInformationList); err != nil {
			invalidParams.AddNested("ProductInformationList", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateLicenseManagerReportGeneratorInput(v *UpdateLicenseManagerReportGeneratorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateLicenseManagerReportGeneratorInput"}
	if v.LicenseManagerReportGeneratorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseManagerReportGeneratorArn"))
	}
	if v.ReportGeneratorName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportGeneratorName"))
	}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.ReportContext == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportContext"))
	} else if v.ReportContext != nil {
		if err := validateReportContext(v.ReportContext); err != nil {
			invalidParams.AddNested("ReportContext", err.(smithy.InvalidParamsError))
		}
	}
	if v.ReportFrequency == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportFrequency"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateLicenseSpecificationsForResourceInput(v *UpdateLicenseSpecificationsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateLicenseSpecificationsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.AddLicenseSpecifications != nil {
		if err := validateLicenseSpecifications(v.AddLicenseSpecifications); err != nil {
			invalidParams.AddNested("AddLicenseSpecifications", err.(smithy.InvalidParamsError))
		}
	}
	if v.RemoveLicenseSpecifications != nil {
		if err := validateLicenseSpecifications(v.RemoveLicenseSpecifications); err != nil {
			invalidParams.AddNested("RemoveLicenseSpecifications", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateServiceSettingsInput(v *UpdateServiceSettingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateServiceSettingsInput"}
	if v.OrganizationConfiguration != nil {
		if err := validateOrganizationConfiguration(v.OrganizationConfiguration); err != nil {
			invalidParams.AddNested("OrganizationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
