// Code generated by smithy-go-codegen DO NOT EDIT.

package managedblockchain

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The token based access feature is in preview release for Ethereum on Amazon
// Managed Blockchain and is subject to change. We recommend that you use this
// feature only with test scenarios, and not in production environments. Deletes an
// accessor that your Amazon Web Services account owns. An accessor object is a
// container that has the information required for token based access to your
// Ethereum nodes including, the BILLING_TOKEN. After an accessor is deleted, the
// status of the accessor changes from AVAILABLE to PENDING_DELETION. An accessor
// in the PENDING_DELETION state can’t be used for new WebSocket requests or HTTP
// requests. However, WebSocket connections that are initiated while the accessor
// was in the AVAILABLE state remain open until they expire (up to 2 hours).
func (c *Client) DeleteAccessor(ctx context.Context, params *DeleteAccessorInput, optFns ...func(*Options)) (*DeleteAccessorOutput, error) {
	if params == nil {
		params = &DeleteAccessorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteAccessor", params, optFns, c.addOperationDeleteAccessorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteAccessorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteAccessorInput struct {

	// The unique identifier of the accessor.
	//
	// This member is required.
	AccessorId *string

	noSmithyDocumentSerde
}

type DeleteAccessorOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteAccessorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteAccessor{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteAccessor{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDeleteAccessorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteAccessor(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteAccessor(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "managedblockchain",
		OperationName: "DeleteAccessor",
	}
}
