//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package publisher

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
)

// MarshalJSON implements the json.Marshaller interface for type Event.
func (e Event) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "data", e.Data)
	populate(objectMap, "dataVersion", e.DataVersion)
	populateTimeRFC3339(objectMap, "eventTime", e.EventTime)
	populate(objectMap, "eventType", e.EventType)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "metadataVersion", e.MetadataVersion)
	populate(objectMap, "subject", e.Subject)
	populate(objectMap, "topic", e.Topic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Event.
func (e *Event) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &e.Data)
			delete(rawMsg, key)
		case "dataVersion":
			err = unpopulate(val, "DataVersion", &e.DataVersion)
			delete(rawMsg, key)
		case "eventTime":
			err = unpopulateTimeRFC3339(val, "EventTime", &e.EventTime)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "metadataVersion":
			err = unpopulate(val, "MetadataVersion", &e.MetadataVersion)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &e.Subject)
			delete(rawMsg, key)
		case "topic":
			err = unpopulate(val, "Topic", &e.Topic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
