//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// StaticSitesClient contains the methods for the StaticSites group.
// Don't use this type directly, use NewStaticSitesClient() instead.
type StaticSitesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewStaticSitesClient creates a new instance of StaticSitesClient with the specified values.
//   - subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewStaticSitesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*StaticSitesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &StaticSitesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginApproveOrRejectPrivateEndpointConnection - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - privateEndpointConnectionName - Name of the private endpoint connection.
//   - privateEndpointWrapper - Request body.
//   - options - StaticSitesClientBeginApproveOrRejectPrivateEndpointConnectionOptions contains the optional parameters for the
//     StaticSitesClient.BeginApproveOrRejectPrivateEndpointConnection method.
func (client *StaticSitesClient) BeginApproveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *StaticSitesClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*runtime.Poller[StaticSitesClientApproveOrRejectPrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.approveOrRejectPrivateEndpointConnection(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientApproveOrRejectPrivateEndpointConnectionResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientApproveOrRejectPrivateEndpointConnectionResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ApproveOrRejectPrivateEndpointConnection - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) approveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *StaticSitesClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginApproveOrRejectPrivateEndpointConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.approveOrRejectPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// approveOrRejectPrivateEndpointConnectionCreateRequest creates the ApproveOrRejectPrivateEndpointConnection request.
func (client *StaticSitesClient) approveOrRejectPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *StaticSitesClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, privateEndpointWrapper); err != nil {
		return nil, err
	}
	return req, nil
}

// CreateOrUpdateBasicAuth - Description for Adds or updates basic auth for a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - basicAuthName - name of the basic auth entry.
//   - basicAuthEnvelope - A JSON representation of the basic auth properties.
//   - options - StaticSitesClientCreateOrUpdateBasicAuthOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateBasicAuth
//     method.
func (client *StaticSitesClient) CreateOrUpdateBasicAuth(ctx context.Context, resourceGroupName string, name string, basicAuthName BasicAuthName, basicAuthEnvelope StaticSiteBasicAuthPropertiesARMResource, options *StaticSitesClientCreateOrUpdateBasicAuthOptions) (StaticSitesClientCreateOrUpdateBasicAuthResponse, error) {
	var err error
	const operationName = "StaticSitesClient.CreateOrUpdateBasicAuth"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateBasicAuthCreateRequest(ctx, resourceGroupName, name, basicAuthName, basicAuthEnvelope, options)
	if err != nil {
		return StaticSitesClientCreateOrUpdateBasicAuthResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientCreateOrUpdateBasicAuthResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientCreateOrUpdateBasicAuthResponse{}, err
	}
	resp, err := client.createOrUpdateBasicAuthHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateBasicAuthCreateRequest creates the CreateOrUpdateBasicAuth request.
func (client *StaticSitesClient) createOrUpdateBasicAuthCreateRequest(ctx context.Context, resourceGroupName string, name string, basicAuthName BasicAuthName, basicAuthEnvelope StaticSiteBasicAuthPropertiesARMResource, options *StaticSitesClientCreateOrUpdateBasicAuthOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/basicAuth/{basicAuthName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if basicAuthName == "" {
		return nil, errors.New("parameter basicAuthName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{basicAuthName}", url.PathEscape(string(basicAuthName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, basicAuthEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateBasicAuthHandleResponse handles the CreateOrUpdateBasicAuth response.
func (client *StaticSitesClient) createOrUpdateBasicAuthHandleResponse(resp *http.Response) (StaticSitesClientCreateOrUpdateBasicAuthResponse, error) {
	result := StaticSitesClientCreateOrUpdateBasicAuthResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteBasicAuthPropertiesARMResource); err != nil {
		return StaticSitesClientCreateOrUpdateBasicAuthResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateBuildDatabaseConnection - Description for Create or update a database connection for a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier.
//   - databaseConnectionName - Name of the database connection.
//   - databaseConnectionRequestEnvelope - A JSON representation of the database connection request properties
//   - options - StaticSitesClientCreateOrUpdateBuildDatabaseConnectionOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateBuildDatabaseConnection
//     method.
func (client *StaticSitesClient) CreateOrUpdateBuildDatabaseConnection(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, databaseConnectionRequestEnvelope DatabaseConnection, options *StaticSitesClientCreateOrUpdateBuildDatabaseConnectionOptions) (StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.CreateOrUpdateBuildDatabaseConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateBuildDatabaseConnectionCreateRequest(ctx, resourceGroupName, name, environmentName, databaseConnectionName, databaseConnectionRequestEnvelope, options)
	if err != nil {
		return StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse{}, err
	}
	resp, err := client.createOrUpdateBuildDatabaseConnectionHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateBuildDatabaseConnectionCreateRequest creates the CreateOrUpdateBuildDatabaseConnection request.
func (client *StaticSitesClient) createOrUpdateBuildDatabaseConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, databaseConnectionRequestEnvelope DatabaseConnection, options *StaticSitesClientCreateOrUpdateBuildDatabaseConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, databaseConnectionRequestEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateBuildDatabaseConnectionHandleResponse handles the CreateOrUpdateBuildDatabaseConnection response.
func (client *StaticSitesClient) createOrUpdateBuildDatabaseConnectionHandleResponse(resp *http.Response) (StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse, error) {
	result := StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnection); err != nil {
		return StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateDatabaseConnection - Description for Create or update a database connection for a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - databaseConnectionName - Name of the database connection.
//   - databaseConnectionRequestEnvelope - A JSON representation of the database connection request properties
//   - options - StaticSitesClientCreateOrUpdateDatabaseConnectionOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateDatabaseConnection
//     method.
func (client *StaticSitesClient) CreateOrUpdateDatabaseConnection(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, databaseConnectionRequestEnvelope DatabaseConnection, options *StaticSitesClientCreateOrUpdateDatabaseConnectionOptions) (StaticSitesClientCreateOrUpdateDatabaseConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.CreateOrUpdateDatabaseConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateDatabaseConnectionCreateRequest(ctx, resourceGroupName, name, databaseConnectionName, databaseConnectionRequestEnvelope, options)
	if err != nil {
		return StaticSitesClientCreateOrUpdateDatabaseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientCreateOrUpdateDatabaseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientCreateOrUpdateDatabaseConnectionResponse{}, err
	}
	resp, err := client.createOrUpdateDatabaseConnectionHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateDatabaseConnectionCreateRequest creates the CreateOrUpdateDatabaseConnection request.
func (client *StaticSitesClient) createOrUpdateDatabaseConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, databaseConnectionRequestEnvelope DatabaseConnection, options *StaticSitesClientCreateOrUpdateDatabaseConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, databaseConnectionRequestEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateDatabaseConnectionHandleResponse handles the CreateOrUpdateDatabaseConnection response.
func (client *StaticSitesClient) createOrUpdateDatabaseConnectionHandleResponse(resp *http.Response) (StaticSitesClientCreateOrUpdateDatabaseConnectionResponse, error) {
	result := StaticSitesClientCreateOrUpdateDatabaseConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnection); err != nil {
		return StaticSitesClientCreateOrUpdateDatabaseConnectionResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdateStaticSite - Description for Creates a new static site in an existing resource group, or updates an
// existing static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site to create or update.
//   - staticSiteEnvelope - A JSON representation of the staticsite properties. See example.
//   - options - StaticSitesClientBeginCreateOrUpdateStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginCreateOrUpdateStaticSite
//     method.
func (client *StaticSitesClient) BeginCreateOrUpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSiteARMResource, options *StaticSitesClientBeginCreateOrUpdateStaticSiteOptions) (*runtime.Poller[StaticSitesClientCreateOrUpdateStaticSiteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateStaticSite(ctx, resourceGroupName, name, staticSiteEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientCreateOrUpdateStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientCreateOrUpdateStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateStaticSite - Description for Creates a new static site in an existing resource group, or updates an existing
// static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) createOrUpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSiteARMResource, options *StaticSitesClientBeginCreateOrUpdateStaticSiteOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginCreateOrUpdateStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateStaticSiteCreateRequest(ctx, resourceGroupName, name, staticSiteEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateStaticSiteCreateRequest creates the CreateOrUpdateStaticSite request.
func (client *StaticSitesClient) createOrUpdateStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSiteARMResource, options *StaticSitesClientBeginCreateOrUpdateStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// CreateOrUpdateStaticSiteAppSettings - Description for Creates or updates the app settings of a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - appSettings - The dictionary containing the static site app settings to update.
//   - options - StaticSitesClientCreateOrUpdateStaticSiteAppSettingsOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateStaticSiteAppSettings
//     method.
func (client *StaticSitesClient) CreateOrUpdateStaticSiteAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary, options *StaticSitesClientCreateOrUpdateStaticSiteAppSettingsOptions) (StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.CreateOrUpdateStaticSiteAppSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateStaticSiteAppSettingsCreateRequest(ctx, resourceGroupName, name, appSettings, options)
	if err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse{}, err
	}
	resp, err := client.createOrUpdateStaticSiteAppSettingsHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateStaticSiteAppSettingsCreateRequest creates the CreateOrUpdateStaticSiteAppSettings request.
func (client *StaticSitesClient) createOrUpdateStaticSiteAppSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary, options *StaticSitesClientCreateOrUpdateStaticSiteAppSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/appsettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, appSettings); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateStaticSiteAppSettingsHandleResponse handles the CreateOrUpdateStaticSiteAppSettings response.
func (client *StaticSitesClient) createOrUpdateStaticSiteAppSettingsHandleResponse(resp *http.Response) (StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse, error) {
	result := StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateStaticSiteBuildAppSettings - Description for Creates or updates the app settings of a static site build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - appSettings - The dictionary containing the static site app settings to update.
//   - options - StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateStaticSiteBuildAppSettings
//     method.
func (client *StaticSitesClient) CreateOrUpdateStaticSiteBuildAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings StringDictionary, options *StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsOptions) (StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.CreateOrUpdateStaticSiteBuildAppSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateStaticSiteBuildAppSettingsCreateRequest(ctx, resourceGroupName, name, environmentName, appSettings, options)
	if err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse{}, err
	}
	resp, err := client.createOrUpdateStaticSiteBuildAppSettingsHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateStaticSiteBuildAppSettingsCreateRequest creates the CreateOrUpdateStaticSiteBuildAppSettings request.
func (client *StaticSitesClient) createOrUpdateStaticSiteBuildAppSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings StringDictionary, options *StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/config/appsettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, appSettings); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateStaticSiteBuildAppSettingsHandleResponse handles the CreateOrUpdateStaticSiteBuildAppSettings response.
func (client *StaticSitesClient) createOrUpdateStaticSiteBuildAppSettingsHandleResponse(resp *http.Response) (StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse, error) {
	result := StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettings - Description for Creates or updates the function app settings of a static
// site build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - appSettings - The dictionary containing the static site function app settings to update.
//   - options - StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsOptions contains the optional parameters for
//     the StaticSitesClient.CreateOrUpdateStaticSiteBuildFunctionAppSettings method.
func (client *StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings StringDictionary, options *StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsOptions) (StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.CreateOrUpdateStaticSiteBuildFunctionAppSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateStaticSiteBuildFunctionAppSettingsCreateRequest(ctx, resourceGroupName, name, environmentName, appSettings, options)
	if err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse{}, err
	}
	resp, err := client.createOrUpdateStaticSiteBuildFunctionAppSettingsHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateStaticSiteBuildFunctionAppSettingsCreateRequest creates the CreateOrUpdateStaticSiteBuildFunctionAppSettings request.
func (client *StaticSitesClient) createOrUpdateStaticSiteBuildFunctionAppSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings StringDictionary, options *StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/config/functionappsettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, appSettings); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateStaticSiteBuildFunctionAppSettingsHandleResponse handles the CreateOrUpdateStaticSiteBuildFunctionAppSettings response.
func (client *StaticSitesClient) createOrUpdateStaticSiteBuildFunctionAppSettingsHandleResponse(resp *http.Response) (StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse, error) {
	result := StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdateStaticSiteCustomDomain - Description for Creates a new static site custom domain in an existing resource
// group and static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - domainName - The custom domain to create.
//   - staticSiteCustomDomainRequestPropertiesEnvelope - A JSON representation of the static site custom domain request properties.
//     See example.
//   - options - StaticSitesClientBeginCreateOrUpdateStaticSiteCustomDomainOptions contains the optional parameters for the StaticSitesClient.BeginCreateOrUpdateStaticSiteCustomDomain
//     method.
func (client *StaticSitesClient) BeginCreateOrUpdateStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource, options *StaticSitesClientBeginCreateOrUpdateStaticSiteCustomDomainOptions) (*runtime.Poller[StaticSitesClientCreateOrUpdateStaticSiteCustomDomainResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateStaticSiteCustomDomain(ctx, resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientCreateOrUpdateStaticSiteCustomDomainResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientCreateOrUpdateStaticSiteCustomDomainResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateStaticSiteCustomDomain - Description for Creates a new static site custom domain in an existing resource
// group and static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) createOrUpdateStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource, options *StaticSitesClientBeginCreateOrUpdateStaticSiteCustomDomainOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginCreateOrUpdateStaticSiteCustomDomain"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateStaticSiteCustomDomainCreateRequest(ctx, resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateStaticSiteCustomDomainCreateRequest creates the CreateOrUpdateStaticSiteCustomDomain request.
func (client *StaticSitesClient) createOrUpdateStaticSiteCustomDomainCreateRequest(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource, options *StaticSitesClientBeginCreateOrUpdateStaticSiteCustomDomainOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteCustomDomainRequestPropertiesEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// CreateOrUpdateStaticSiteFunctionAppSettings - Description for Creates or updates the function app settings of a static
// site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - appSettings - The dictionary containing the static site function app settings to update.
//   - options - StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsOptions contains the optional parameters for the
//     StaticSitesClient.CreateOrUpdateStaticSiteFunctionAppSettings method.
func (client *StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary, options *StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsOptions) (StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.CreateOrUpdateStaticSiteFunctionAppSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateStaticSiteFunctionAppSettingsCreateRequest(ctx, resourceGroupName, name, appSettings, options)
	if err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse{}, err
	}
	resp, err := client.createOrUpdateStaticSiteFunctionAppSettingsHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateStaticSiteFunctionAppSettingsCreateRequest creates the CreateOrUpdateStaticSiteFunctionAppSettings request.
func (client *StaticSitesClient) createOrUpdateStaticSiteFunctionAppSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary, options *StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/functionappsettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, appSettings); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateStaticSiteFunctionAppSettingsHandleResponse handles the CreateOrUpdateStaticSiteFunctionAppSettings response.
func (client *StaticSitesClient) createOrUpdateStaticSiteFunctionAppSettingsHandleResponse(resp *http.Response) (StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse, error) {
	result := StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse{}, err
	}
	return result, nil
}

// CreateUserRolesInvitationLink - Description for Creates an invitation link for a user with the role
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientCreateUserRolesInvitationLinkOptions contains the optional parameters for the StaticSitesClient.CreateUserRolesInvitationLink
//     method.
func (client *StaticSitesClient) CreateUserRolesInvitationLink(ctx context.Context, resourceGroupName string, name string, staticSiteUserRolesInvitationEnvelope StaticSiteUserInvitationRequestResource, options *StaticSitesClientCreateUserRolesInvitationLinkOptions) (StaticSitesClientCreateUserRolesInvitationLinkResponse, error) {
	var err error
	const operationName = "StaticSitesClient.CreateUserRolesInvitationLink"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createUserRolesInvitationLinkCreateRequest(ctx, resourceGroupName, name, staticSiteUserRolesInvitationEnvelope, options)
	if err != nil {
		return StaticSitesClientCreateUserRolesInvitationLinkResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientCreateUserRolesInvitationLinkResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientCreateUserRolesInvitationLinkResponse{}, err
	}
	resp, err := client.createUserRolesInvitationLinkHandleResponse(httpResp)
	return resp, err
}

// createUserRolesInvitationLinkCreateRequest creates the CreateUserRolesInvitationLink request.
func (client *StaticSitesClient) createUserRolesInvitationLinkCreateRequest(ctx context.Context, resourceGroupName string, name string, staticSiteUserRolesInvitationEnvelope StaticSiteUserInvitationRequestResource, options *StaticSitesClientCreateUserRolesInvitationLinkOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/createUserInvitation"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteUserRolesInvitationEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// createUserRolesInvitationLinkHandleResponse handles the CreateUserRolesInvitationLink response.
func (client *StaticSitesClient) createUserRolesInvitationLinkHandleResponse(resp *http.Response) (StaticSitesClientCreateUserRolesInvitationLinkResponse, error) {
	result := StaticSitesClientCreateUserRolesInvitationLinkResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteUserInvitationResponseResource); err != nil {
		return StaticSitesClientCreateUserRolesInvitationLinkResponse{}, err
	}
	return result, nil
}

// BeginCreateZipDeploymentForStaticSite - Description for Deploys zipped content to a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - staticSiteZipDeploymentEnvelope - A JSON representation of the StaticSiteZipDeployment properties. See example.
//   - options - StaticSitesClientBeginCreateZipDeploymentForStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginCreateZipDeploymentForStaticSite
//     method.
func (client *StaticSitesClient) BeginCreateZipDeploymentForStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource, options *StaticSitesClientBeginCreateZipDeploymentForStaticSiteOptions) (*runtime.Poller[StaticSitesClientCreateZipDeploymentForStaticSiteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createZipDeploymentForStaticSite(ctx, resourceGroupName, name, staticSiteZipDeploymentEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientCreateZipDeploymentForStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientCreateZipDeploymentForStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateZipDeploymentForStaticSite - Description for Deploys zipped content to a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) createZipDeploymentForStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource, options *StaticSitesClientBeginCreateZipDeploymentForStaticSiteOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginCreateZipDeploymentForStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createZipDeploymentForStaticSiteCreateRequest(ctx, resourceGroupName, name, staticSiteZipDeploymentEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createZipDeploymentForStaticSiteCreateRequest creates the CreateZipDeploymentForStaticSite request.
func (client *StaticSitesClient) createZipDeploymentForStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource, options *StaticSitesClientBeginCreateZipDeploymentForStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/zipdeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteZipDeploymentEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateZipDeploymentForStaticSiteBuild - Description for Deploys zipped content to a specific environment of a static
// site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - Name of the environment.
//   - staticSiteZipDeploymentEnvelope - A JSON representation of the StaticSiteZipDeployment properties. See example.
//   - options - StaticSitesClientBeginCreateZipDeploymentForStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.BeginCreateZipDeploymentForStaticSiteBuild
//     method.
func (client *StaticSitesClient) BeginCreateZipDeploymentForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource, options *StaticSitesClientBeginCreateZipDeploymentForStaticSiteBuildOptions) (*runtime.Poller[StaticSitesClientCreateZipDeploymentForStaticSiteBuildResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createZipDeploymentForStaticSiteBuild(ctx, resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientCreateZipDeploymentForStaticSiteBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientCreateZipDeploymentForStaticSiteBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateZipDeploymentForStaticSiteBuild - Description for Deploys zipped content to a specific environment of a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) createZipDeploymentForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource, options *StaticSitesClientBeginCreateZipDeploymentForStaticSiteBuildOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginCreateZipDeploymentForStaticSiteBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createZipDeploymentForStaticSiteBuildCreateRequest(ctx, resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createZipDeploymentForStaticSiteBuildCreateRequest creates the CreateZipDeploymentForStaticSiteBuild request.
func (client *StaticSitesClient) createZipDeploymentForStaticSiteBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource, options *StaticSitesClientBeginCreateZipDeploymentForStaticSiteBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/zipdeploy"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteZipDeploymentEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// DeleteBuildDatabaseConnection - Delete a database connection for a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier.
//   - databaseConnectionName - Name of the database connection.
//   - options - StaticSitesClientDeleteBuildDatabaseConnectionOptions contains the optional parameters for the StaticSitesClient.DeleteBuildDatabaseConnection
//     method.
func (client *StaticSitesClient) DeleteBuildDatabaseConnection(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *StaticSitesClientDeleteBuildDatabaseConnectionOptions) (StaticSitesClientDeleteBuildDatabaseConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.DeleteBuildDatabaseConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteBuildDatabaseConnectionCreateRequest(ctx, resourceGroupName, name, environmentName, databaseConnectionName, options)
	if err != nil {
		return StaticSitesClientDeleteBuildDatabaseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientDeleteBuildDatabaseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientDeleteBuildDatabaseConnectionResponse{}, err
	}
	return StaticSitesClientDeleteBuildDatabaseConnectionResponse{}, nil
}

// deleteBuildDatabaseConnectionCreateRequest creates the DeleteBuildDatabaseConnection request.
func (client *StaticSitesClient) deleteBuildDatabaseConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *StaticSitesClientDeleteBuildDatabaseConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteDatabaseConnection - Delete a database connection for a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - databaseConnectionName - Name of the database connection.
//   - options - StaticSitesClientDeleteDatabaseConnectionOptions contains the optional parameters for the StaticSitesClient.DeleteDatabaseConnection
//     method.
func (client *StaticSitesClient) DeleteDatabaseConnection(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *StaticSitesClientDeleteDatabaseConnectionOptions) (StaticSitesClientDeleteDatabaseConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.DeleteDatabaseConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteDatabaseConnectionCreateRequest(ctx, resourceGroupName, name, databaseConnectionName, options)
	if err != nil {
		return StaticSitesClientDeleteDatabaseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientDeleteDatabaseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientDeleteDatabaseConnectionResponse{}, err
	}
	return StaticSitesClientDeleteDatabaseConnectionResponse{}, nil
}

// deleteDatabaseConnectionCreateRequest creates the DeleteDatabaseConnection request.
func (client *StaticSitesClient) deleteDatabaseConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *StaticSitesClientDeleteDatabaseConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeletePrivateEndpointConnection - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - privateEndpointConnectionName - Name of the private endpoint connection.
//   - options - StaticSitesClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the StaticSitesClient.BeginDeletePrivateEndpointConnection
//     method.
func (client *StaticSitesClient) BeginDeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *StaticSitesClientBeginDeletePrivateEndpointConnectionOptions) (*runtime.Poller[StaticSitesClientDeletePrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deletePrivateEndpointConnection(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientDeletePrivateEndpointConnectionResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientDeletePrivateEndpointConnectionResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeletePrivateEndpointConnection - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) deletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *StaticSitesClientBeginDeletePrivateEndpointConnectionOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginDeletePrivateEndpointConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deletePrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deletePrivateEndpointConnectionCreateRequest creates the DeletePrivateEndpointConnection request.
func (client *StaticSitesClient) deletePrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *StaticSitesClientBeginDeletePrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteStaticSite - Description for Deletes a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site to delete.
//   - options - StaticSitesClientBeginDeleteStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginDeleteStaticSite
//     method.
func (client *StaticSitesClient) BeginDeleteStaticSite(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientBeginDeleteStaticSiteOptions) (*runtime.Poller[StaticSitesClientDeleteStaticSiteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteStaticSite(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientDeleteStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientDeleteStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteStaticSite - Description for Deletes a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) deleteStaticSite(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientBeginDeleteStaticSiteOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginDeleteStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteStaticSiteCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteStaticSiteCreateRequest creates the DeleteStaticSite request.
func (client *StaticSitesClient) deleteStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientBeginDeleteStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteStaticSiteBuild - Description for Deletes a static site build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - options - StaticSitesClientBeginDeleteStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.BeginDeleteStaticSiteBuild
//     method.
func (client *StaticSitesClient) BeginDeleteStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientBeginDeleteStaticSiteBuildOptions) (*runtime.Poller[StaticSitesClientDeleteStaticSiteBuildResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteStaticSiteBuild(ctx, resourceGroupName, name, environmentName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientDeleteStaticSiteBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientDeleteStaticSiteBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteStaticSiteBuild - Description for Deletes a static site build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) deleteStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientBeginDeleteStaticSiteBuildOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginDeleteStaticSiteBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteStaticSiteBuildCreateRequest(ctx, resourceGroupName, name, environmentName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteStaticSiteBuildCreateRequest creates the DeleteStaticSiteBuild request.
func (client *StaticSitesClient) deleteStaticSiteBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientBeginDeleteStaticSiteBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteStaticSiteCustomDomain - Description for Deletes a custom domain.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - domainName - The custom domain to delete.
//   - options - StaticSitesClientBeginDeleteStaticSiteCustomDomainOptions contains the optional parameters for the StaticSitesClient.BeginDeleteStaticSiteCustomDomain
//     method.
func (client *StaticSitesClient) BeginDeleteStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string, options *StaticSitesClientBeginDeleteStaticSiteCustomDomainOptions) (*runtime.Poller[StaticSitesClientDeleteStaticSiteCustomDomainResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteStaticSiteCustomDomain(ctx, resourceGroupName, name, domainName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientDeleteStaticSiteCustomDomainResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientDeleteStaticSiteCustomDomainResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteStaticSiteCustomDomain - Description for Deletes a custom domain.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) deleteStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string, options *StaticSitesClientBeginDeleteStaticSiteCustomDomainOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginDeleteStaticSiteCustomDomain"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteStaticSiteCustomDomainCreateRequest(ctx, resourceGroupName, name, domainName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteStaticSiteCustomDomainCreateRequest creates the DeleteStaticSiteCustomDomain request.
func (client *StaticSitesClient) deleteStaticSiteCustomDomainCreateRequest(ctx context.Context, resourceGroupName string, name string, domainName string, options *StaticSitesClientBeginDeleteStaticSiteCustomDomainOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteStaticSiteUser - Description for Deletes the user entry from the static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the staticsite.
//   - authprovider - The auth provider for this user.
//   - userid - The user id of the user.
//   - options - StaticSitesClientDeleteStaticSiteUserOptions contains the optional parameters for the StaticSitesClient.DeleteStaticSiteUser
//     method.
func (client *StaticSitesClient) DeleteStaticSiteUser(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, options *StaticSitesClientDeleteStaticSiteUserOptions) (StaticSitesClientDeleteStaticSiteUserResponse, error) {
	var err error
	const operationName = "StaticSitesClient.DeleteStaticSiteUser"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteStaticSiteUserCreateRequest(ctx, resourceGroupName, name, authprovider, userid, options)
	if err != nil {
		return StaticSitesClientDeleteStaticSiteUserResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientDeleteStaticSiteUserResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientDeleteStaticSiteUserResponse{}, err
	}
	return StaticSitesClientDeleteStaticSiteUserResponse{}, nil
}

// deleteStaticSiteUserCreateRequest creates the DeleteStaticSiteUser request.
func (client *StaticSitesClient) deleteStaticSiteUserCreateRequest(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, options *StaticSitesClientDeleteStaticSiteUserOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if authprovider == "" {
		return nil, errors.New("parameter authprovider cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{authprovider}", url.PathEscape(authprovider))
	if userid == "" {
		return nil, errors.New("parameter userid cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{userid}", url.PathEscape(userid))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDetachStaticSite - Description for Detaches a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site to detach.
//   - options - StaticSitesClientBeginDetachStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginDetachStaticSite
//     method.
func (client *StaticSitesClient) BeginDetachStaticSite(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientBeginDetachStaticSiteOptions) (*runtime.Poller[StaticSitesClientDetachStaticSiteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.detachStaticSite(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientDetachStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientDetachStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DetachStaticSite - Description for Detaches a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) detachStaticSite(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientBeginDetachStaticSiteOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginDetachStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.detachStaticSiteCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// detachStaticSiteCreateRequest creates the DetachStaticSite request.
func (client *StaticSitesClient) detachStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientBeginDetachStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/detach"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DetachUserProvidedFunctionAppFromStaticSite - Description for Detach the user provided function app from the static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - functionAppName - Name of the function app registered with the static site.
//   - options - StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteOptions contains the optional parameters for the
//     StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSite method.
func (client *StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string, options *StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteOptions) (StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteResponse, error) {
	var err error
	const operationName = "StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.detachUserProvidedFunctionAppFromStaticSiteCreateRequest(ctx, resourceGroupName, name, functionAppName, options)
	if err != nil {
		return StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteResponse{}, err
	}
	return StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteResponse{}, nil
}

// detachUserProvidedFunctionAppFromStaticSiteCreateRequest creates the DetachUserProvidedFunctionAppFromStaticSite request.
func (client *StaticSitesClient) detachUserProvidedFunctionAppFromStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, functionAppName string, options *StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionAppName == "" {
		return nil, errors.New("parameter functionAppName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionAppName}", url.PathEscape(functionAppName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DetachUserProvidedFunctionAppFromStaticSiteBuild - Description for Detach the user provided function app from the static
// site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - functionAppName - Name of the function app registered with the static site build.
//   - options - StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildOptions contains the optional parameters for
//     the StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSiteBuild method.
func (client *StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, options *StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildOptions) (StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildResponse, error) {
	var err error
	const operationName = "StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSiteBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.detachUserProvidedFunctionAppFromStaticSiteBuildCreateRequest(ctx, resourceGroupName, name, environmentName, functionAppName, options)
	if err != nil {
		return StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildResponse{}, err
	}
	return StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildResponse{}, nil
}

// detachUserProvidedFunctionAppFromStaticSiteBuildCreateRequest creates the DetachUserProvidedFunctionAppFromStaticSiteBuild request.
func (client *StaticSitesClient) detachUserProvidedFunctionAppFromStaticSiteBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, options *StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if functionAppName == "" {
		return nil, errors.New("parameter functionAppName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionAppName}", url.PathEscape(functionAppName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetBasicAuth - Description for Gets the basic auth properties for a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - basicAuthName - name of the basic auth entry.
//   - options - StaticSitesClientGetBasicAuthOptions contains the optional parameters for the StaticSitesClient.GetBasicAuth
//     method.
func (client *StaticSitesClient) GetBasicAuth(ctx context.Context, resourceGroupName string, name string, basicAuthName BasicAuthName, options *StaticSitesClientGetBasicAuthOptions) (StaticSitesClientGetBasicAuthResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetBasicAuth"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getBasicAuthCreateRequest(ctx, resourceGroupName, name, basicAuthName, options)
	if err != nil {
		return StaticSitesClientGetBasicAuthResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetBasicAuthResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetBasicAuthResponse{}, err
	}
	resp, err := client.getBasicAuthHandleResponse(httpResp)
	return resp, err
}

// getBasicAuthCreateRequest creates the GetBasicAuth request.
func (client *StaticSitesClient) getBasicAuthCreateRequest(ctx context.Context, resourceGroupName string, name string, basicAuthName BasicAuthName, options *StaticSitesClientGetBasicAuthOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/basicAuth/{basicAuthName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if basicAuthName == "" {
		return nil, errors.New("parameter basicAuthName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{basicAuthName}", url.PathEscape(string(basicAuthName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBasicAuthHandleResponse handles the GetBasicAuth response.
func (client *StaticSitesClient) getBasicAuthHandleResponse(resp *http.Response) (StaticSitesClientGetBasicAuthResponse, error) {
	result := StaticSitesClientGetBasicAuthResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteBasicAuthPropertiesARMResource); err != nil {
		return StaticSitesClientGetBasicAuthResponse{}, err
	}
	return result, nil
}

// GetBuildDatabaseConnection - Returns overview of a database connection for a static site build by name
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier.
//   - databaseConnectionName - Name of the database connection.
//   - options - StaticSitesClientGetBuildDatabaseConnectionOptions contains the optional parameters for the StaticSitesClient.GetBuildDatabaseConnection
//     method.
func (client *StaticSitesClient) GetBuildDatabaseConnection(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *StaticSitesClientGetBuildDatabaseConnectionOptions) (StaticSitesClientGetBuildDatabaseConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetBuildDatabaseConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getBuildDatabaseConnectionCreateRequest(ctx, resourceGroupName, name, environmentName, databaseConnectionName, options)
	if err != nil {
		return StaticSitesClientGetBuildDatabaseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetBuildDatabaseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetBuildDatabaseConnectionResponse{}, err
	}
	resp, err := client.getBuildDatabaseConnectionHandleResponse(httpResp)
	return resp, err
}

// getBuildDatabaseConnectionCreateRequest creates the GetBuildDatabaseConnection request.
func (client *StaticSitesClient) getBuildDatabaseConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *StaticSitesClientGetBuildDatabaseConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildDatabaseConnectionHandleResponse handles the GetBuildDatabaseConnection response.
func (client *StaticSitesClient) getBuildDatabaseConnectionHandleResponse(resp *http.Response) (StaticSitesClientGetBuildDatabaseConnectionResponse, error) {
	result := StaticSitesClientGetBuildDatabaseConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnection); err != nil {
		return StaticSitesClientGetBuildDatabaseConnectionResponse{}, err
	}
	return result, nil
}

// GetBuildDatabaseConnectionWithDetails - Returns details of a database connection for a static site build by name
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier.
//   - databaseConnectionName - Name of the database connection.
//   - options - StaticSitesClientGetBuildDatabaseConnectionWithDetailsOptions contains the optional parameters for the StaticSitesClient.GetBuildDatabaseConnectionWithDetails
//     method.
func (client *StaticSitesClient) GetBuildDatabaseConnectionWithDetails(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *StaticSitesClientGetBuildDatabaseConnectionWithDetailsOptions) (StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetBuildDatabaseConnectionWithDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getBuildDatabaseConnectionWithDetailsCreateRequest(ctx, resourceGroupName, name, environmentName, databaseConnectionName, options)
	if err != nil {
		return StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse{}, err
	}
	resp, err := client.getBuildDatabaseConnectionWithDetailsHandleResponse(httpResp)
	return resp, err
}

// getBuildDatabaseConnectionWithDetailsCreateRequest creates the GetBuildDatabaseConnectionWithDetails request.
func (client *StaticSitesClient) getBuildDatabaseConnectionWithDetailsCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, options *StaticSitesClientGetBuildDatabaseConnectionWithDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}/show"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildDatabaseConnectionWithDetailsHandleResponse handles the GetBuildDatabaseConnectionWithDetails response.
func (client *StaticSitesClient) getBuildDatabaseConnectionWithDetailsHandleResponse(resp *http.Response) (StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse, error) {
	result := StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnection); err != nil {
		return StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse{}, err
	}
	return result, nil
}

// NewGetBuildDatabaseConnectionsPager - Returns overviews of database connections for a static site build
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier.
//   - options - StaticSitesClientGetBuildDatabaseConnectionsOptions contains the optional parameters for the StaticSitesClient.NewGetBuildDatabaseConnectionsPager
//     method.
func (client *StaticSitesClient) NewGetBuildDatabaseConnectionsPager(resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetBuildDatabaseConnectionsOptions) *runtime.Pager[StaticSitesClientGetBuildDatabaseConnectionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetBuildDatabaseConnectionsResponse]{
		More: func(page StaticSitesClientGetBuildDatabaseConnectionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetBuildDatabaseConnectionsResponse) (StaticSitesClientGetBuildDatabaseConnectionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetBuildDatabaseConnectionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getBuildDatabaseConnectionsCreateRequest(ctx, resourceGroupName, name, environmentName, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetBuildDatabaseConnectionsResponse{}, err
			}
			return client.getBuildDatabaseConnectionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getBuildDatabaseConnectionsCreateRequest creates the GetBuildDatabaseConnections request.
func (client *StaticSitesClient) getBuildDatabaseConnectionsCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetBuildDatabaseConnectionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildDatabaseConnectionsHandleResponse handles the GetBuildDatabaseConnections response.
func (client *StaticSitesClient) getBuildDatabaseConnectionsHandleResponse(resp *http.Response) (StaticSitesClientGetBuildDatabaseConnectionsResponse, error) {
	result := StaticSitesClientGetBuildDatabaseConnectionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnectionCollection); err != nil {
		return StaticSitesClientGetBuildDatabaseConnectionsResponse{}, err
	}
	return result, nil
}

// NewGetBuildDatabaseConnectionsWithDetailsPager - Returns details of database connections for a static site build
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier.
//   - options - StaticSitesClientGetBuildDatabaseConnectionsWithDetailsOptions contains the optional parameters for the StaticSitesClient.NewGetBuildDatabaseConnectionsWithDetailsPager
//     method.
func (client *StaticSitesClient) NewGetBuildDatabaseConnectionsWithDetailsPager(resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetBuildDatabaseConnectionsWithDetailsOptions) *runtime.Pager[StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse]{
		More: func(page StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse) (StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetBuildDatabaseConnectionsWithDetailsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getBuildDatabaseConnectionsWithDetailsCreateRequest(ctx, resourceGroupName, name, environmentName, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse{}, err
			}
			return client.getBuildDatabaseConnectionsWithDetailsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getBuildDatabaseConnectionsWithDetailsCreateRequest creates the GetBuildDatabaseConnectionsWithDetails request.
func (client *StaticSitesClient) getBuildDatabaseConnectionsWithDetailsCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetBuildDatabaseConnectionsWithDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/showDatabaseConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildDatabaseConnectionsWithDetailsHandleResponse handles the GetBuildDatabaseConnectionsWithDetails response.
func (client *StaticSitesClient) getBuildDatabaseConnectionsWithDetailsHandleResponse(resp *http.Response) (StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse, error) {
	result := StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnectionCollection); err != nil {
		return StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse{}, err
	}
	return result, nil
}

// GetDatabaseConnection - Returns overview of a database connection for a static site by name
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - databaseConnectionName - Name of the database connection.
//   - options - StaticSitesClientGetDatabaseConnectionOptions contains the optional parameters for the StaticSitesClient.GetDatabaseConnection
//     method.
func (client *StaticSitesClient) GetDatabaseConnection(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *StaticSitesClientGetDatabaseConnectionOptions) (StaticSitesClientGetDatabaseConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetDatabaseConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDatabaseConnectionCreateRequest(ctx, resourceGroupName, name, databaseConnectionName, options)
	if err != nil {
		return StaticSitesClientGetDatabaseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetDatabaseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetDatabaseConnectionResponse{}, err
	}
	resp, err := client.getDatabaseConnectionHandleResponse(httpResp)
	return resp, err
}

// getDatabaseConnectionCreateRequest creates the GetDatabaseConnection request.
func (client *StaticSitesClient) getDatabaseConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *StaticSitesClientGetDatabaseConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDatabaseConnectionHandleResponse handles the GetDatabaseConnection response.
func (client *StaticSitesClient) getDatabaseConnectionHandleResponse(resp *http.Response) (StaticSitesClientGetDatabaseConnectionResponse, error) {
	result := StaticSitesClientGetDatabaseConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnection); err != nil {
		return StaticSitesClientGetDatabaseConnectionResponse{}, err
	}
	return result, nil
}

// GetDatabaseConnectionWithDetails - Returns details of a database connection for a static site by name
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - databaseConnectionName - Name of the database connection.
//   - options - StaticSitesClientGetDatabaseConnectionWithDetailsOptions contains the optional parameters for the StaticSitesClient.GetDatabaseConnectionWithDetails
//     method.
func (client *StaticSitesClient) GetDatabaseConnectionWithDetails(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *StaticSitesClientGetDatabaseConnectionWithDetailsOptions) (StaticSitesClientGetDatabaseConnectionWithDetailsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetDatabaseConnectionWithDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDatabaseConnectionWithDetailsCreateRequest(ctx, resourceGroupName, name, databaseConnectionName, options)
	if err != nil {
		return StaticSitesClientGetDatabaseConnectionWithDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetDatabaseConnectionWithDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetDatabaseConnectionWithDetailsResponse{}, err
	}
	resp, err := client.getDatabaseConnectionWithDetailsHandleResponse(httpResp)
	return resp, err
}

// getDatabaseConnectionWithDetailsCreateRequest creates the GetDatabaseConnectionWithDetails request.
func (client *StaticSitesClient) getDatabaseConnectionWithDetailsCreateRequest(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, options *StaticSitesClientGetDatabaseConnectionWithDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}/show"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDatabaseConnectionWithDetailsHandleResponse handles the GetDatabaseConnectionWithDetails response.
func (client *StaticSitesClient) getDatabaseConnectionWithDetailsHandleResponse(resp *http.Response) (StaticSitesClientGetDatabaseConnectionWithDetailsResponse, error) {
	result := StaticSitesClientGetDatabaseConnectionWithDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnection); err != nil {
		return StaticSitesClientGetDatabaseConnectionWithDetailsResponse{}, err
	}
	return result, nil
}

// NewGetDatabaseConnectionsPager - Returns overviews of database connections for a static site
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - options - StaticSitesClientGetDatabaseConnectionsOptions contains the optional parameters for the StaticSitesClient.NewGetDatabaseConnectionsPager
//     method.
func (client *StaticSitesClient) NewGetDatabaseConnectionsPager(resourceGroupName string, name string, options *StaticSitesClientGetDatabaseConnectionsOptions) *runtime.Pager[StaticSitesClientGetDatabaseConnectionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetDatabaseConnectionsResponse]{
		More: func(page StaticSitesClientGetDatabaseConnectionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetDatabaseConnectionsResponse) (StaticSitesClientGetDatabaseConnectionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetDatabaseConnectionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getDatabaseConnectionsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetDatabaseConnectionsResponse{}, err
			}
			return client.getDatabaseConnectionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getDatabaseConnectionsCreateRequest creates the GetDatabaseConnections request.
func (client *StaticSitesClient) getDatabaseConnectionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetDatabaseConnectionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDatabaseConnectionsHandleResponse handles the GetDatabaseConnections response.
func (client *StaticSitesClient) getDatabaseConnectionsHandleResponse(resp *http.Response) (StaticSitesClientGetDatabaseConnectionsResponse, error) {
	result := StaticSitesClientGetDatabaseConnectionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnectionCollection); err != nil {
		return StaticSitesClientGetDatabaseConnectionsResponse{}, err
	}
	return result, nil
}

// NewGetDatabaseConnectionsWithDetailsPager - Returns details of database connections for a static site
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - options - StaticSitesClientGetDatabaseConnectionsWithDetailsOptions contains the optional parameters for the StaticSitesClient.NewGetDatabaseConnectionsWithDetailsPager
//     method.
func (client *StaticSitesClient) NewGetDatabaseConnectionsWithDetailsPager(resourceGroupName string, name string, options *StaticSitesClientGetDatabaseConnectionsWithDetailsOptions) *runtime.Pager[StaticSitesClientGetDatabaseConnectionsWithDetailsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetDatabaseConnectionsWithDetailsResponse]{
		More: func(page StaticSitesClientGetDatabaseConnectionsWithDetailsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetDatabaseConnectionsWithDetailsResponse) (StaticSitesClientGetDatabaseConnectionsWithDetailsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetDatabaseConnectionsWithDetailsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getDatabaseConnectionsWithDetailsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetDatabaseConnectionsWithDetailsResponse{}, err
			}
			return client.getDatabaseConnectionsWithDetailsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getDatabaseConnectionsWithDetailsCreateRequest creates the GetDatabaseConnectionsWithDetails request.
func (client *StaticSitesClient) getDatabaseConnectionsWithDetailsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetDatabaseConnectionsWithDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/showDatabaseConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDatabaseConnectionsWithDetailsHandleResponse handles the GetDatabaseConnectionsWithDetails response.
func (client *StaticSitesClient) getDatabaseConnectionsWithDetailsHandleResponse(resp *http.Response) (StaticSitesClientGetDatabaseConnectionsWithDetailsResponse, error) {
	result := StaticSitesClientGetDatabaseConnectionsWithDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnectionCollection); err != nil {
		return StaticSitesClientGetDatabaseConnectionsWithDetailsResponse{}, err
	}
	return result, nil
}

// GetLinkedBackend - Returns the details of a linked backend linked to a static site by name
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - linkedBackendName - Name of the linked backend that should be retrieved
//   - options - StaticSitesClientGetLinkedBackendOptions contains the optional parameters for the StaticSitesClient.GetLinkedBackend
//     method.
func (client *StaticSitesClient) GetLinkedBackend(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, options *StaticSitesClientGetLinkedBackendOptions) (StaticSitesClientGetLinkedBackendResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetLinkedBackend"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getLinkedBackendCreateRequest(ctx, resourceGroupName, name, linkedBackendName, options)
	if err != nil {
		return StaticSitesClientGetLinkedBackendResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetLinkedBackendResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetLinkedBackendResponse{}, err
	}
	resp, err := client.getLinkedBackendHandleResponse(httpResp)
	return resp, err
}

// getLinkedBackendCreateRequest creates the GetLinkedBackend request.
func (client *StaticSitesClient) getLinkedBackendCreateRequest(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, options *StaticSitesClientGetLinkedBackendOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if linkedBackendName == "" {
		return nil, errors.New("parameter linkedBackendName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkedBackendName}", url.PathEscape(linkedBackendName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getLinkedBackendHandleResponse handles the GetLinkedBackend response.
func (client *StaticSitesClient) getLinkedBackendHandleResponse(resp *http.Response) (StaticSitesClientGetLinkedBackendResponse, error) {
	result := StaticSitesClientGetLinkedBackendResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteLinkedBackendARMResource); err != nil {
		return StaticSitesClientGetLinkedBackendResponse{}, err
	}
	return result, nil
}

// GetLinkedBackendForBuild - Returns the details of a linked backend linked to a static site build by name
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier
//   - linkedBackendName - Name of the linked backend that should be retrieved
//   - options - StaticSitesClientGetLinkedBackendForBuildOptions contains the optional parameters for the StaticSitesClient.GetLinkedBackendForBuild
//     method.
func (client *StaticSitesClient) GetLinkedBackendForBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, options *StaticSitesClientGetLinkedBackendForBuildOptions) (StaticSitesClientGetLinkedBackendForBuildResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetLinkedBackendForBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getLinkedBackendForBuildCreateRequest(ctx, resourceGroupName, name, environmentName, linkedBackendName, options)
	if err != nil {
		return StaticSitesClientGetLinkedBackendForBuildResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetLinkedBackendForBuildResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetLinkedBackendForBuildResponse{}, err
	}
	resp, err := client.getLinkedBackendForBuildHandleResponse(httpResp)
	return resp, err
}

// getLinkedBackendForBuildCreateRequest creates the GetLinkedBackendForBuild request.
func (client *StaticSitesClient) getLinkedBackendForBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, options *StaticSitesClientGetLinkedBackendForBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if linkedBackendName == "" {
		return nil, errors.New("parameter linkedBackendName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkedBackendName}", url.PathEscape(linkedBackendName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getLinkedBackendForBuildHandleResponse handles the GetLinkedBackendForBuild response.
func (client *StaticSitesClient) getLinkedBackendForBuildHandleResponse(resp *http.Response) (StaticSitesClientGetLinkedBackendForBuildResponse, error) {
	result := StaticSitesClientGetLinkedBackendForBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteLinkedBackendARMResource); err != nil {
		return StaticSitesClientGetLinkedBackendForBuildResponse{}, err
	}
	return result, nil
}

// NewGetLinkedBackendsPager - Returns details of all backends linked to a static site
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - options - StaticSitesClientGetLinkedBackendsOptions contains the optional parameters for the StaticSitesClient.NewGetLinkedBackendsPager
//     method.
func (client *StaticSitesClient) NewGetLinkedBackendsPager(resourceGroupName string, name string, options *StaticSitesClientGetLinkedBackendsOptions) *runtime.Pager[StaticSitesClientGetLinkedBackendsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetLinkedBackendsResponse]{
		More: func(page StaticSitesClientGetLinkedBackendsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetLinkedBackendsResponse) (StaticSitesClientGetLinkedBackendsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetLinkedBackendsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getLinkedBackendsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetLinkedBackendsResponse{}, err
			}
			return client.getLinkedBackendsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getLinkedBackendsCreateRequest creates the GetLinkedBackends request.
func (client *StaticSitesClient) getLinkedBackendsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetLinkedBackendsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getLinkedBackendsHandleResponse handles the GetLinkedBackends response.
func (client *StaticSitesClient) getLinkedBackendsHandleResponse(resp *http.Response) (StaticSitesClientGetLinkedBackendsResponse, error) {
	result := StaticSitesClientGetLinkedBackendsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteLinkedBackendsCollection); err != nil {
		return StaticSitesClientGetLinkedBackendsResponse{}, err
	}
	return result, nil
}

// NewGetLinkedBackendsForBuildPager - Returns details of all backends linked to a static site build
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier
//   - options - StaticSitesClientGetLinkedBackendsForBuildOptions contains the optional parameters for the StaticSitesClient.NewGetLinkedBackendsForBuildPager
//     method.
func (client *StaticSitesClient) NewGetLinkedBackendsForBuildPager(resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetLinkedBackendsForBuildOptions) *runtime.Pager[StaticSitesClientGetLinkedBackendsForBuildResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetLinkedBackendsForBuildResponse]{
		More: func(page StaticSitesClientGetLinkedBackendsForBuildResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetLinkedBackendsForBuildResponse) (StaticSitesClientGetLinkedBackendsForBuildResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetLinkedBackendsForBuildPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getLinkedBackendsForBuildCreateRequest(ctx, resourceGroupName, name, environmentName, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetLinkedBackendsForBuildResponse{}, err
			}
			return client.getLinkedBackendsForBuildHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getLinkedBackendsForBuildCreateRequest creates the GetLinkedBackendsForBuild request.
func (client *StaticSitesClient) getLinkedBackendsForBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetLinkedBackendsForBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getLinkedBackendsForBuildHandleResponse handles the GetLinkedBackendsForBuild response.
func (client *StaticSitesClient) getLinkedBackendsForBuildHandleResponse(resp *http.Response) (StaticSitesClientGetLinkedBackendsForBuildResponse, error) {
	result := StaticSitesClientGetLinkedBackendsForBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteLinkedBackendsCollection); err != nil {
		return StaticSitesClientGetLinkedBackendsForBuildResponse{}, err
	}
	return result, nil
}

// GetPrivateEndpointConnection - Description for Gets a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - privateEndpointConnectionName - Name of the private endpoint connection.
//   - options - StaticSitesClientGetPrivateEndpointConnectionOptions contains the optional parameters for the StaticSitesClient.GetPrivateEndpointConnection
//     method.
func (client *StaticSitesClient) GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *StaticSitesClientGetPrivateEndpointConnectionOptions) (StaticSitesClientGetPrivateEndpointConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetPrivateEndpointConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
	if err != nil {
		return StaticSitesClientGetPrivateEndpointConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetPrivateEndpointConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetPrivateEndpointConnectionResponse{}, err
	}
	resp, err := client.getPrivateEndpointConnectionHandleResponse(httpResp)
	return resp, err
}

// getPrivateEndpointConnectionCreateRequest creates the GetPrivateEndpointConnection request.
func (client *StaticSitesClient) getPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *StaticSitesClientGetPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionHandleResponse handles the GetPrivateEndpointConnection response.
func (client *StaticSitesClient) getPrivateEndpointConnectionHandleResponse(resp *http.Response) (StaticSitesClientGetPrivateEndpointConnectionResponse, error) {
	result := StaticSitesClientGetPrivateEndpointConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemotePrivateEndpointConnectionARMResource); err != nil {
		return StaticSitesClientGetPrivateEndpointConnectionResponse{}, err
	}
	return result, nil
}

// NewGetPrivateEndpointConnectionListPager - Description for Gets the list of private endpoint connections associated with
// a static site
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientGetPrivateEndpointConnectionListOptions contains the optional parameters for the StaticSitesClient.NewGetPrivateEndpointConnectionListPager
//     method.
func (client *StaticSitesClient) NewGetPrivateEndpointConnectionListPager(resourceGroupName string, name string, options *StaticSitesClientGetPrivateEndpointConnectionListOptions) *runtime.Pager[StaticSitesClientGetPrivateEndpointConnectionListResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetPrivateEndpointConnectionListResponse]{
		More: func(page StaticSitesClientGetPrivateEndpointConnectionListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetPrivateEndpointConnectionListResponse) (StaticSitesClientGetPrivateEndpointConnectionListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetPrivateEndpointConnectionListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getPrivateEndpointConnectionListCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetPrivateEndpointConnectionListResponse{}, err
			}
			return client.getPrivateEndpointConnectionListHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getPrivateEndpointConnectionListCreateRequest creates the GetPrivateEndpointConnectionList request.
func (client *StaticSitesClient) getPrivateEndpointConnectionListCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetPrivateEndpointConnectionListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionListHandleResponse handles the GetPrivateEndpointConnectionList response.
func (client *StaticSitesClient) getPrivateEndpointConnectionListHandleResponse(resp *http.Response) (StaticSitesClientGetPrivateEndpointConnectionListResponse, error) {
	result := StaticSitesClientGetPrivateEndpointConnectionListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateEndpointConnectionCollection); err != nil {
		return StaticSitesClientGetPrivateEndpointConnectionListResponse{}, err
	}
	return result, nil
}

// GetPrivateLinkResources - Description for Gets the private link resources
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the site.
//   - options - StaticSitesClientGetPrivateLinkResourcesOptions contains the optional parameters for the StaticSitesClient.GetPrivateLinkResources
//     method.
func (client *StaticSitesClient) GetPrivateLinkResources(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetPrivateLinkResourcesOptions) (StaticSitesClientGetPrivateLinkResourcesResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetPrivateLinkResources"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getPrivateLinkResourcesCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return StaticSitesClientGetPrivateLinkResourcesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetPrivateLinkResourcesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetPrivateLinkResourcesResponse{}, err
	}
	resp, err := client.getPrivateLinkResourcesHandleResponse(httpResp)
	return resp, err
}

// getPrivateLinkResourcesCreateRequest creates the GetPrivateLinkResources request.
func (client *StaticSitesClient) getPrivateLinkResourcesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetPrivateLinkResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateLinkResources"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateLinkResourcesHandleResponse handles the GetPrivateLinkResources response.
func (client *StaticSitesClient) getPrivateLinkResourcesHandleResponse(resp *http.Response) (StaticSitesClientGetPrivateLinkResourcesResponse, error) {
	result := StaticSitesClientGetPrivateLinkResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResourcesWrapper); err != nil {
		return StaticSitesClientGetPrivateLinkResourcesResponse{}, err
	}
	return result, nil
}

// GetStaticSite - Description for Gets the details of a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientGetStaticSiteOptions contains the optional parameters for the StaticSitesClient.GetStaticSite
//     method.
func (client *StaticSitesClient) GetStaticSite(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetStaticSiteOptions) (StaticSitesClientGetStaticSiteResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getStaticSiteCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return StaticSitesClientGetStaticSiteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetStaticSiteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetStaticSiteResponse{}, err
	}
	resp, err := client.getStaticSiteHandleResponse(httpResp)
	return resp, err
}

// getStaticSiteCreateRequest creates the GetStaticSite request.
func (client *StaticSitesClient) getStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getStaticSiteHandleResponse handles the GetStaticSite response.
func (client *StaticSitesClient) getStaticSiteHandleResponse(resp *http.Response) (StaticSitesClientGetStaticSiteResponse, error) {
	result := StaticSitesClientGetStaticSiteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteARMResource); err != nil {
		return StaticSitesClientGetStaticSiteResponse{}, err
	}
	return result, nil
}

// GetStaticSiteBuild - Description for Gets the details of a static site build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - options - StaticSitesClientGetStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.GetStaticSiteBuild
//     method.
func (client *StaticSitesClient) GetStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetStaticSiteBuildOptions) (StaticSitesClientGetStaticSiteBuildResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetStaticSiteBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getStaticSiteBuildCreateRequest(ctx, resourceGroupName, name, environmentName, options)
	if err != nil {
		return StaticSitesClientGetStaticSiteBuildResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetStaticSiteBuildResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetStaticSiteBuildResponse{}, err
	}
	resp, err := client.getStaticSiteBuildHandleResponse(httpResp)
	return resp, err
}

// getStaticSiteBuildCreateRequest creates the GetStaticSiteBuild request.
func (client *StaticSitesClient) getStaticSiteBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetStaticSiteBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getStaticSiteBuildHandleResponse handles the GetStaticSiteBuild response.
func (client *StaticSitesClient) getStaticSiteBuildHandleResponse(resp *http.Response) (StaticSitesClientGetStaticSiteBuildResponse, error) {
	result := StaticSitesClientGetStaticSiteBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteBuildARMResource); err != nil {
		return StaticSitesClientGetStaticSiteBuildResponse{}, err
	}
	return result, nil
}

// NewGetStaticSiteBuildsPager - Description for Gets all static site builds for a particular static site.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientGetStaticSiteBuildsOptions contains the optional parameters for the StaticSitesClient.NewGetStaticSiteBuildsPager
//     method.
func (client *StaticSitesClient) NewGetStaticSiteBuildsPager(resourceGroupName string, name string, options *StaticSitesClientGetStaticSiteBuildsOptions) *runtime.Pager[StaticSitesClientGetStaticSiteBuildsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetStaticSiteBuildsResponse]{
		More: func(page StaticSitesClientGetStaticSiteBuildsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetStaticSiteBuildsResponse) (StaticSitesClientGetStaticSiteBuildsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetStaticSiteBuildsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getStaticSiteBuildsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetStaticSiteBuildsResponse{}, err
			}
			return client.getStaticSiteBuildsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getStaticSiteBuildsCreateRequest creates the GetStaticSiteBuilds request.
func (client *StaticSitesClient) getStaticSiteBuildsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetStaticSiteBuildsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getStaticSiteBuildsHandleResponse handles the GetStaticSiteBuilds response.
func (client *StaticSitesClient) getStaticSiteBuildsHandleResponse(resp *http.Response) (StaticSitesClientGetStaticSiteBuildsResponse, error) {
	result := StaticSitesClientGetStaticSiteBuildsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteBuildCollection); err != nil {
		return StaticSitesClientGetStaticSiteBuildsResponse{}, err
	}
	return result, nil
}

// GetStaticSiteCustomDomain - Description for Gets an existing custom domain for a particular static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site resource to search in.
//   - domainName - The custom domain name.
//   - options - StaticSitesClientGetStaticSiteCustomDomainOptions contains the optional parameters for the StaticSitesClient.GetStaticSiteCustomDomain
//     method.
func (client *StaticSitesClient) GetStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string, options *StaticSitesClientGetStaticSiteCustomDomainOptions) (StaticSitesClientGetStaticSiteCustomDomainResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetStaticSiteCustomDomain"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getStaticSiteCustomDomainCreateRequest(ctx, resourceGroupName, name, domainName, options)
	if err != nil {
		return StaticSitesClientGetStaticSiteCustomDomainResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetStaticSiteCustomDomainResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetStaticSiteCustomDomainResponse{}, err
	}
	resp, err := client.getStaticSiteCustomDomainHandleResponse(httpResp)
	return resp, err
}

// getStaticSiteCustomDomainCreateRequest creates the GetStaticSiteCustomDomain request.
func (client *StaticSitesClient) getStaticSiteCustomDomainCreateRequest(ctx context.Context, resourceGroupName string, name string, domainName string, options *StaticSitesClientGetStaticSiteCustomDomainOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getStaticSiteCustomDomainHandleResponse handles the GetStaticSiteCustomDomain response.
func (client *StaticSitesClient) getStaticSiteCustomDomainHandleResponse(resp *http.Response) (StaticSitesClientGetStaticSiteCustomDomainResponse, error) {
	result := StaticSitesClientGetStaticSiteCustomDomainResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteCustomDomainOverviewARMResource); err != nil {
		return StaticSitesClientGetStaticSiteCustomDomainResponse{}, err
	}
	return result, nil
}

// NewGetStaticSitesByResourceGroupPager - Description for Gets all static sites in the specified resource group.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - options - StaticSitesClientGetStaticSitesByResourceGroupOptions contains the optional parameters for the StaticSitesClient.NewGetStaticSitesByResourceGroupPager
//     method.
func (client *StaticSitesClient) NewGetStaticSitesByResourceGroupPager(resourceGroupName string, options *StaticSitesClientGetStaticSitesByResourceGroupOptions) *runtime.Pager[StaticSitesClientGetStaticSitesByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetStaticSitesByResourceGroupResponse]{
		More: func(page StaticSitesClientGetStaticSitesByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetStaticSitesByResourceGroupResponse) (StaticSitesClientGetStaticSitesByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetStaticSitesByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getStaticSitesByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetStaticSitesByResourceGroupResponse{}, err
			}
			return client.getStaticSitesByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getStaticSitesByResourceGroupCreateRequest creates the GetStaticSitesByResourceGroup request.
func (client *StaticSitesClient) getStaticSitesByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *StaticSitesClientGetStaticSitesByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getStaticSitesByResourceGroupHandleResponse handles the GetStaticSitesByResourceGroup response.
func (client *StaticSitesClient) getStaticSitesByResourceGroupHandleResponse(resp *http.Response) (StaticSitesClientGetStaticSitesByResourceGroupResponse, error) {
	result := StaticSitesClientGetStaticSitesByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteCollection); err != nil {
		return StaticSitesClientGetStaticSitesByResourceGroupResponse{}, err
	}
	return result, nil
}

// GetUserProvidedFunctionAppForStaticSite - Description for Gets the details of the user provided function app registered
// with a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - functionAppName - Name of the function app registered with the static site.
//   - options - StaticSitesClientGetUserProvidedFunctionAppForStaticSiteOptions contains the optional parameters for the StaticSitesClient.GetUserProvidedFunctionAppForStaticSite
//     method.
func (client *StaticSitesClient) GetUserProvidedFunctionAppForStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string, options *StaticSitesClientGetUserProvidedFunctionAppForStaticSiteOptions) (StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetUserProvidedFunctionAppForStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getUserProvidedFunctionAppForStaticSiteCreateRequest(ctx, resourceGroupName, name, functionAppName, options)
	if err != nil {
		return StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse{}, err
	}
	resp, err := client.getUserProvidedFunctionAppForStaticSiteHandleResponse(httpResp)
	return resp, err
}

// getUserProvidedFunctionAppForStaticSiteCreateRequest creates the GetUserProvidedFunctionAppForStaticSite request.
func (client *StaticSitesClient) getUserProvidedFunctionAppForStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, functionAppName string, options *StaticSitesClientGetUserProvidedFunctionAppForStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionAppName == "" {
		return nil, errors.New("parameter functionAppName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionAppName}", url.PathEscape(functionAppName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getUserProvidedFunctionAppForStaticSiteHandleResponse handles the GetUserProvidedFunctionAppForStaticSite response.
func (client *StaticSitesClient) getUserProvidedFunctionAppForStaticSiteHandleResponse(resp *http.Response) (StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse, error) {
	result := StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteUserProvidedFunctionAppARMResource); err != nil {
		return StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse{}, err
	}
	return result, nil
}

// GetUserProvidedFunctionAppForStaticSiteBuild - Description for Gets the details of the user provided function app registered
// with a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - functionAppName - Name of the function app registered with the static site build.
//   - options - StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildOptions contains the optional parameters for the
//     StaticSitesClient.GetUserProvidedFunctionAppForStaticSiteBuild method.
func (client *StaticSitesClient) GetUserProvidedFunctionAppForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, options *StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildOptions) (StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse, error) {
	var err error
	const operationName = "StaticSitesClient.GetUserProvidedFunctionAppForStaticSiteBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getUserProvidedFunctionAppForStaticSiteBuildCreateRequest(ctx, resourceGroupName, name, environmentName, functionAppName, options)
	if err != nil {
		return StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse{}, err
	}
	resp, err := client.getUserProvidedFunctionAppForStaticSiteBuildHandleResponse(httpResp)
	return resp, err
}

// getUserProvidedFunctionAppForStaticSiteBuildCreateRequest creates the GetUserProvidedFunctionAppForStaticSiteBuild request.
func (client *StaticSitesClient) getUserProvidedFunctionAppForStaticSiteBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, options *StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if functionAppName == "" {
		return nil, errors.New("parameter functionAppName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionAppName}", url.PathEscape(functionAppName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getUserProvidedFunctionAppForStaticSiteBuildHandleResponse handles the GetUserProvidedFunctionAppForStaticSiteBuild response.
func (client *StaticSitesClient) getUserProvidedFunctionAppForStaticSiteBuildHandleResponse(resp *http.Response) (StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse, error) {
	result := StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteUserProvidedFunctionAppARMResource); err != nil {
		return StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse{}, err
	}
	return result, nil
}

// NewGetUserProvidedFunctionAppsForStaticSitePager - Description for Gets the details of the user provided function apps
// registered with a static site
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteOptions contains the optional parameters for the StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSitePager
//     method.
func (client *StaticSitesClient) NewGetUserProvidedFunctionAppsForStaticSitePager(resourceGroupName string, name string, options *StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteOptions) *runtime.Pager[StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse]{
		More: func(page StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse) (StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSitePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getUserProvidedFunctionAppsForStaticSiteCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse{}, err
			}
			return client.getUserProvidedFunctionAppsForStaticSiteHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getUserProvidedFunctionAppsForStaticSiteCreateRequest creates the GetUserProvidedFunctionAppsForStaticSite request.
func (client *StaticSitesClient) getUserProvidedFunctionAppsForStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getUserProvidedFunctionAppsForStaticSiteHandleResponse handles the GetUserProvidedFunctionAppsForStaticSite response.
func (client *StaticSitesClient) getUserProvidedFunctionAppsForStaticSiteHandleResponse(resp *http.Response) (StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse, error) {
	result := StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteUserProvidedFunctionAppsCollection); err != nil {
		return StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse{}, err
	}
	return result, nil
}

// NewGetUserProvidedFunctionAppsForStaticSiteBuildPager - Description for Gets the details of the user provided function
// apps registered with a static site build
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - options - StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildOptions contains the optional parameters for the
//     StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSiteBuildPager method.
func (client *StaticSitesClient) NewGetUserProvidedFunctionAppsForStaticSiteBuildPager(resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildOptions) *runtime.Pager[StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse]{
		More: func(page StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse) (StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSiteBuildPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getUserProvidedFunctionAppsForStaticSiteBuildCreateRequest(ctx, resourceGroupName, name, environmentName, options)
			}, nil)
			if err != nil {
				return StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse{}, err
			}
			return client.getUserProvidedFunctionAppsForStaticSiteBuildHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getUserProvidedFunctionAppsForStaticSiteBuildCreateRequest creates the GetUserProvidedFunctionAppsForStaticSiteBuild request.
func (client *StaticSitesClient) getUserProvidedFunctionAppsForStaticSiteBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getUserProvidedFunctionAppsForStaticSiteBuildHandleResponse handles the GetUserProvidedFunctionAppsForStaticSiteBuild response.
func (client *StaticSitesClient) getUserProvidedFunctionAppsForStaticSiteBuildHandleResponse(resp *http.Response) (StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse, error) {
	result := StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteUserProvidedFunctionAppsCollection); err != nil {
		return StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse{}, err
	}
	return result, nil
}

// BeginLinkBackend - Link backend to a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - linkedBackendName - Name of the backend to link to the static site
//   - staticSiteLinkedBackendEnvelope - A JSON representation of the linked backend request properties
//   - options - StaticSitesClientBeginLinkBackendOptions contains the optional parameters for the StaticSitesClient.BeginLinkBackend
//     method.
func (client *StaticSitesClient) BeginLinkBackend(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginLinkBackendOptions) (*runtime.Poller[StaticSitesClientLinkBackendResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.linkBackend(ctx, resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientLinkBackendResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientLinkBackendResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// LinkBackend - Link backend to a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) linkBackend(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginLinkBackendOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginLinkBackend"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.linkBackendCreateRequest(ctx, resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// linkBackendCreateRequest creates the LinkBackend request.
func (client *StaticSitesClient) linkBackendCreateRequest(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginLinkBackendOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if linkedBackendName == "" {
		return nil, errors.New("parameter linkedBackendName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkedBackendName}", url.PathEscape(linkedBackendName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteLinkedBackendEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginLinkBackendToBuild - Link backend to a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier
//   - linkedBackendName - Name of the backend to link to the static site
//   - staticSiteLinkedBackendEnvelope - A JSON representation of the linked backend request properties
//   - options - StaticSitesClientBeginLinkBackendToBuildOptions contains the optional parameters for the StaticSitesClient.BeginLinkBackendToBuild
//     method.
func (client *StaticSitesClient) BeginLinkBackendToBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginLinkBackendToBuildOptions) (*runtime.Poller[StaticSitesClientLinkBackendToBuildResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.linkBackendToBuild(ctx, resourceGroupName, name, environmentName, linkedBackendName, staticSiteLinkedBackendEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientLinkBackendToBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientLinkBackendToBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// LinkBackendToBuild - Link backend to a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) linkBackendToBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginLinkBackendToBuildOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginLinkBackendToBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.linkBackendToBuildCreateRequest(ctx, resourceGroupName, name, environmentName, linkedBackendName, staticSiteLinkedBackendEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// linkBackendToBuildCreateRequest creates the LinkBackendToBuild request.
func (client *StaticSitesClient) linkBackendToBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginLinkBackendToBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if linkedBackendName == "" {
		return nil, errors.New("parameter linkedBackendName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkedBackendName}", url.PathEscape(linkedBackendName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteLinkedBackendEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// NewListPager - Description for Get all Static Sites for a subscription.
//
// Generated from API version 2023-01-01
//   - options - StaticSitesClientListOptions contains the optional parameters for the StaticSitesClient.NewListPager method.
func (client *StaticSitesClient) NewListPager(options *StaticSitesClientListOptions) *runtime.Pager[StaticSitesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientListResponse]{
		More: func(page StaticSitesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientListResponse) (StaticSitesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return StaticSitesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *StaticSitesClient) listCreateRequest(ctx context.Context, options *StaticSitesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/staticSites"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *StaticSitesClient) listHandleResponse(resp *http.Response) (StaticSitesClientListResponse, error) {
	result := StaticSitesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteCollection); err != nil {
		return StaticSitesClientListResponse{}, err
	}
	return result, nil
}

// NewListBasicAuthPager - Description for Gets the basic auth properties for a static site as a collection.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientListBasicAuthOptions contains the optional parameters for the StaticSitesClient.NewListBasicAuthPager
//     method.
func (client *StaticSitesClient) NewListBasicAuthPager(resourceGroupName string, name string, options *StaticSitesClientListBasicAuthOptions) *runtime.Pager[StaticSitesClientListBasicAuthResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientListBasicAuthResponse]{
		More: func(page StaticSitesClientListBasicAuthResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientListBasicAuthResponse) (StaticSitesClientListBasicAuthResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewListBasicAuthPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBasicAuthCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientListBasicAuthResponse{}, err
			}
			return client.listBasicAuthHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBasicAuthCreateRequest creates the ListBasicAuth request.
func (client *StaticSitesClient) listBasicAuthCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListBasicAuthOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/basicAuth"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBasicAuthHandleResponse handles the ListBasicAuth response.
func (client *StaticSitesClient) listBasicAuthHandleResponse(resp *http.Response) (StaticSitesClientListBasicAuthResponse, error) {
	result := StaticSitesClientListBasicAuthResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteBasicAuthPropertiesCollection); err != nil {
		return StaticSitesClientListBasicAuthResponse{}, err
	}
	return result, nil
}

// ListStaticSiteAppSettings - Description for Gets the application settings of a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientListStaticSiteAppSettingsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteAppSettings
//     method.
func (client *StaticSitesClient) ListStaticSiteAppSettings(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteAppSettingsOptions) (StaticSitesClientListStaticSiteAppSettingsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.ListStaticSiteAppSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listStaticSiteAppSettingsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return StaticSitesClientListStaticSiteAppSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientListStaticSiteAppSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientListStaticSiteAppSettingsResponse{}, err
	}
	resp, err := client.listStaticSiteAppSettingsHandleResponse(httpResp)
	return resp, err
}

// listStaticSiteAppSettingsCreateRequest creates the ListStaticSiteAppSettings request.
func (client *StaticSitesClient) listStaticSiteAppSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteAppSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listAppSettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteAppSettingsHandleResponse handles the ListStaticSiteAppSettings response.
func (client *StaticSitesClient) listStaticSiteAppSettingsHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteAppSettingsResponse, error) {
	result := StaticSitesClientListStaticSiteAppSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientListStaticSiteAppSettingsResponse{}, err
	}
	return result, nil
}

// ListStaticSiteBuildAppSettings - Description for Gets the application settings of a static site build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - options - StaticSitesClientListStaticSiteBuildAppSettingsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteBuildAppSettings
//     method.
func (client *StaticSitesClient) ListStaticSiteBuildAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientListStaticSiteBuildAppSettingsOptions) (StaticSitesClientListStaticSiteBuildAppSettingsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.ListStaticSiteBuildAppSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listStaticSiteBuildAppSettingsCreateRequest(ctx, resourceGroupName, name, environmentName, options)
	if err != nil {
		return StaticSitesClientListStaticSiteBuildAppSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientListStaticSiteBuildAppSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientListStaticSiteBuildAppSettingsResponse{}, err
	}
	resp, err := client.listStaticSiteBuildAppSettingsHandleResponse(httpResp)
	return resp, err
}

// listStaticSiteBuildAppSettingsCreateRequest creates the ListStaticSiteBuildAppSettings request.
func (client *StaticSitesClient) listStaticSiteBuildAppSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientListStaticSiteBuildAppSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/listAppSettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteBuildAppSettingsHandleResponse handles the ListStaticSiteBuildAppSettings response.
func (client *StaticSitesClient) listStaticSiteBuildAppSettingsHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteBuildAppSettingsResponse, error) {
	result := StaticSitesClientListStaticSiteBuildAppSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientListStaticSiteBuildAppSettingsResponse{}, err
	}
	return result, nil
}

// ListStaticSiteBuildFunctionAppSettings - Description for Gets the application settings of a static site build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - options - StaticSitesClientListStaticSiteBuildFunctionAppSettingsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteBuildFunctionAppSettings
//     method.
func (client *StaticSitesClient) ListStaticSiteBuildFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientListStaticSiteBuildFunctionAppSettingsOptions) (StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.ListStaticSiteBuildFunctionAppSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listStaticSiteBuildFunctionAppSettingsCreateRequest(ctx, resourceGroupName, name, environmentName, options)
	if err != nil {
		return StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse{}, err
	}
	resp, err := client.listStaticSiteBuildFunctionAppSettingsHandleResponse(httpResp)
	return resp, err
}

// listStaticSiteBuildFunctionAppSettingsCreateRequest creates the ListStaticSiteBuildFunctionAppSettings request.
func (client *StaticSitesClient) listStaticSiteBuildFunctionAppSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientListStaticSiteBuildFunctionAppSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/listFunctionAppSettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteBuildFunctionAppSettingsHandleResponse handles the ListStaticSiteBuildFunctionAppSettings response.
func (client *StaticSitesClient) listStaticSiteBuildFunctionAppSettingsHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse, error) {
	result := StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse{}, err
	}
	return result, nil
}

// NewListStaticSiteBuildFunctionsPager - Description for Gets the functions of a particular static site build.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - options - StaticSitesClientListStaticSiteBuildFunctionsOptions contains the optional parameters for the StaticSitesClient.NewListStaticSiteBuildFunctionsPager
//     method.
func (client *StaticSitesClient) NewListStaticSiteBuildFunctionsPager(resourceGroupName string, name string, environmentName string, options *StaticSitesClientListStaticSiteBuildFunctionsOptions) *runtime.Pager[StaticSitesClientListStaticSiteBuildFunctionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientListStaticSiteBuildFunctionsResponse]{
		More: func(page StaticSitesClientListStaticSiteBuildFunctionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientListStaticSiteBuildFunctionsResponse) (StaticSitesClientListStaticSiteBuildFunctionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewListStaticSiteBuildFunctionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listStaticSiteBuildFunctionsCreateRequest(ctx, resourceGroupName, name, environmentName, options)
			}, nil)
			if err != nil {
				return StaticSitesClientListStaticSiteBuildFunctionsResponse{}, err
			}
			return client.listStaticSiteBuildFunctionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listStaticSiteBuildFunctionsCreateRequest creates the ListStaticSiteBuildFunctions request.
func (client *StaticSitesClient) listStaticSiteBuildFunctionsCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, options *StaticSitesClientListStaticSiteBuildFunctionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/functions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteBuildFunctionsHandleResponse handles the ListStaticSiteBuildFunctions response.
func (client *StaticSitesClient) listStaticSiteBuildFunctionsHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteBuildFunctionsResponse, error) {
	result := StaticSitesClientListStaticSiteBuildFunctionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteFunctionOverviewCollection); err != nil {
		return StaticSitesClientListStaticSiteBuildFunctionsResponse{}, err
	}
	return result, nil
}

// ListStaticSiteConfiguredRoles - Description for Lists the roles configured for the static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientListStaticSiteConfiguredRolesOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteConfiguredRoles
//     method.
func (client *StaticSitesClient) ListStaticSiteConfiguredRoles(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteConfiguredRolesOptions) (StaticSitesClientListStaticSiteConfiguredRolesResponse, error) {
	var err error
	const operationName = "StaticSitesClient.ListStaticSiteConfiguredRoles"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listStaticSiteConfiguredRolesCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return StaticSitesClientListStaticSiteConfiguredRolesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientListStaticSiteConfiguredRolesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientListStaticSiteConfiguredRolesResponse{}, err
	}
	resp, err := client.listStaticSiteConfiguredRolesHandleResponse(httpResp)
	return resp, err
}

// listStaticSiteConfiguredRolesCreateRequest creates the ListStaticSiteConfiguredRoles request.
func (client *StaticSitesClient) listStaticSiteConfiguredRolesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteConfiguredRolesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listConfiguredRoles"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteConfiguredRolesHandleResponse handles the ListStaticSiteConfiguredRoles response.
func (client *StaticSitesClient) listStaticSiteConfiguredRolesHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteConfiguredRolesResponse, error) {
	result := StaticSitesClientListStaticSiteConfiguredRolesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringList); err != nil {
		return StaticSitesClientListStaticSiteConfiguredRolesResponse{}, err
	}
	return result, nil
}

// NewListStaticSiteCustomDomainsPager - Description for Gets all static site custom domains for a particular static site.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site resource to search in.
//   - options - StaticSitesClientListStaticSiteCustomDomainsOptions contains the optional parameters for the StaticSitesClient.NewListStaticSiteCustomDomainsPager
//     method.
func (client *StaticSitesClient) NewListStaticSiteCustomDomainsPager(resourceGroupName string, name string, options *StaticSitesClientListStaticSiteCustomDomainsOptions) *runtime.Pager[StaticSitesClientListStaticSiteCustomDomainsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientListStaticSiteCustomDomainsResponse]{
		More: func(page StaticSitesClientListStaticSiteCustomDomainsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientListStaticSiteCustomDomainsResponse) (StaticSitesClientListStaticSiteCustomDomainsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewListStaticSiteCustomDomainsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listStaticSiteCustomDomainsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientListStaticSiteCustomDomainsResponse{}, err
			}
			return client.listStaticSiteCustomDomainsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listStaticSiteCustomDomainsCreateRequest creates the ListStaticSiteCustomDomains request.
func (client *StaticSitesClient) listStaticSiteCustomDomainsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteCustomDomainsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteCustomDomainsHandleResponse handles the ListStaticSiteCustomDomains response.
func (client *StaticSitesClient) listStaticSiteCustomDomainsHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteCustomDomainsResponse, error) {
	result := StaticSitesClientListStaticSiteCustomDomainsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteCustomDomainOverviewCollection); err != nil {
		return StaticSitesClientListStaticSiteCustomDomainsResponse{}, err
	}
	return result, nil
}

// ListStaticSiteFunctionAppSettings - Description for Gets the application settings of a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientListStaticSiteFunctionAppSettingsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteFunctionAppSettings
//     method.
func (client *StaticSitesClient) ListStaticSiteFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteFunctionAppSettingsOptions) (StaticSitesClientListStaticSiteFunctionAppSettingsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.ListStaticSiteFunctionAppSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listStaticSiteFunctionAppSettingsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return StaticSitesClientListStaticSiteFunctionAppSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientListStaticSiteFunctionAppSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientListStaticSiteFunctionAppSettingsResponse{}, err
	}
	resp, err := client.listStaticSiteFunctionAppSettingsHandleResponse(httpResp)
	return resp, err
}

// listStaticSiteFunctionAppSettingsCreateRequest creates the ListStaticSiteFunctionAppSettings request.
func (client *StaticSitesClient) listStaticSiteFunctionAppSettingsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteFunctionAppSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listFunctionAppSettings"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteFunctionAppSettingsHandleResponse handles the ListStaticSiteFunctionAppSettings response.
func (client *StaticSitesClient) listStaticSiteFunctionAppSettingsHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteFunctionAppSettingsResponse, error) {
	result := StaticSitesClientListStaticSiteFunctionAppSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientListStaticSiteFunctionAppSettingsResponse{}, err
	}
	return result, nil
}

// NewListStaticSiteFunctionsPager - Description for Gets the functions of a static site.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientListStaticSiteFunctionsOptions contains the optional parameters for the StaticSitesClient.NewListStaticSiteFunctionsPager
//     method.
func (client *StaticSitesClient) NewListStaticSiteFunctionsPager(resourceGroupName string, name string, options *StaticSitesClientListStaticSiteFunctionsOptions) *runtime.Pager[StaticSitesClientListStaticSiteFunctionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientListStaticSiteFunctionsResponse]{
		More: func(page StaticSitesClientListStaticSiteFunctionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientListStaticSiteFunctionsResponse) (StaticSitesClientListStaticSiteFunctionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewListStaticSiteFunctionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listStaticSiteFunctionsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return StaticSitesClientListStaticSiteFunctionsResponse{}, err
			}
			return client.listStaticSiteFunctionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listStaticSiteFunctionsCreateRequest creates the ListStaticSiteFunctions request.
func (client *StaticSitesClient) listStaticSiteFunctionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteFunctionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/functions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteFunctionsHandleResponse handles the ListStaticSiteFunctions response.
func (client *StaticSitesClient) listStaticSiteFunctionsHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteFunctionsResponse, error) {
	result := StaticSitesClientListStaticSiteFunctionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteFunctionOverviewCollection); err != nil {
		return StaticSitesClientListStaticSiteFunctionsResponse{}, err
	}
	return result, nil
}

// ListStaticSiteSecrets - Description for Lists the secrets for an existing static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientListStaticSiteSecretsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteSecrets
//     method.
func (client *StaticSitesClient) ListStaticSiteSecrets(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteSecretsOptions) (StaticSitesClientListStaticSiteSecretsResponse, error) {
	var err error
	const operationName = "StaticSitesClient.ListStaticSiteSecrets"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listStaticSiteSecretsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return StaticSitesClientListStaticSiteSecretsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientListStaticSiteSecretsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientListStaticSiteSecretsResponse{}, err
	}
	resp, err := client.listStaticSiteSecretsHandleResponse(httpResp)
	return resp, err
}

// listStaticSiteSecretsCreateRequest creates the ListStaticSiteSecrets request.
func (client *StaticSitesClient) listStaticSiteSecretsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *StaticSitesClientListStaticSiteSecretsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listSecrets"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteSecretsHandleResponse handles the ListStaticSiteSecrets response.
func (client *StaticSitesClient) listStaticSiteSecretsHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteSecretsResponse, error) {
	result := StaticSitesClientListStaticSiteSecretsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StringDictionary); err != nil {
		return StaticSitesClientListStaticSiteSecretsResponse{}, err
	}
	return result, nil
}

// NewListStaticSiteUsersPager - Description for Gets the list of users of a static site.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - authprovider - The auth provider for the users.
//   - options - StaticSitesClientListStaticSiteUsersOptions contains the optional parameters for the StaticSitesClient.NewListStaticSiteUsersPager
//     method.
func (client *StaticSitesClient) NewListStaticSiteUsersPager(resourceGroupName string, name string, authprovider string, options *StaticSitesClientListStaticSiteUsersOptions) *runtime.Pager[StaticSitesClientListStaticSiteUsersResponse] {
	return runtime.NewPager(runtime.PagingHandler[StaticSitesClientListStaticSiteUsersResponse]{
		More: func(page StaticSitesClientListStaticSiteUsersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StaticSitesClientListStaticSiteUsersResponse) (StaticSitesClientListStaticSiteUsersResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StaticSitesClient.NewListStaticSiteUsersPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listStaticSiteUsersCreateRequest(ctx, resourceGroupName, name, authprovider, options)
			}, nil)
			if err != nil {
				return StaticSitesClientListStaticSiteUsersResponse{}, err
			}
			return client.listStaticSiteUsersHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listStaticSiteUsersCreateRequest creates the ListStaticSiteUsers request.
func (client *StaticSitesClient) listStaticSiteUsersCreateRequest(ctx context.Context, resourceGroupName string, name string, authprovider string, options *StaticSitesClientListStaticSiteUsersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/listUsers"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if authprovider == "" {
		return nil, errors.New("parameter authprovider cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{authprovider}", url.PathEscape(authprovider))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listStaticSiteUsersHandleResponse handles the ListStaticSiteUsers response.
func (client *StaticSitesClient) listStaticSiteUsersHandleResponse(resp *http.Response) (StaticSitesClientListStaticSiteUsersResponse, error) {
	result := StaticSitesClientListStaticSiteUsersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteUserCollection); err != nil {
		return StaticSitesClientListStaticSiteUsersResponse{}, err
	}
	return result, nil
}

// PreviewWorkflow - Description for Generates a preview workflow file for the static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - location - Location where you plan to create the static site.
//   - staticSitesWorkflowPreviewRequest - A JSON representation of the StaticSitesWorkflowPreviewRequest properties. See example.
//   - options - StaticSitesClientPreviewWorkflowOptions contains the optional parameters for the StaticSitesClient.PreviewWorkflow
//     method.
func (client *StaticSitesClient) PreviewWorkflow(ctx context.Context, location string, staticSitesWorkflowPreviewRequest StaticSitesWorkflowPreviewRequest, options *StaticSitesClientPreviewWorkflowOptions) (StaticSitesClientPreviewWorkflowResponse, error) {
	var err error
	const operationName = "StaticSitesClient.PreviewWorkflow"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.previewWorkflowCreateRequest(ctx, location, staticSitesWorkflowPreviewRequest, options)
	if err != nil {
		return StaticSitesClientPreviewWorkflowResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientPreviewWorkflowResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientPreviewWorkflowResponse{}, err
	}
	resp, err := client.previewWorkflowHandleResponse(httpResp)
	return resp, err
}

// previewWorkflowCreateRequest creates the PreviewWorkflow request.
func (client *StaticSitesClient) previewWorkflowCreateRequest(ctx context.Context, location string, staticSitesWorkflowPreviewRequest StaticSitesWorkflowPreviewRequest, options *StaticSitesClientPreviewWorkflowOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/previewStaticSiteWorkflowFile"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSitesWorkflowPreviewRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// previewWorkflowHandleResponse handles the PreviewWorkflow response.
func (client *StaticSitesClient) previewWorkflowHandleResponse(resp *http.Response) (StaticSitesClientPreviewWorkflowResponse, error) {
	result := StaticSitesClientPreviewWorkflowResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSitesWorkflowPreview); err != nil {
		return StaticSitesClientPreviewWorkflowResponse{}, err
	}
	return result, nil
}

// BeginRegisterUserProvidedFunctionAppWithStaticSite - Description for Register a user provided function app with a static
// site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - functionAppName - Name of the function app to register with the static site.
//   - staticSiteUserProvidedFunctionEnvelope - A JSON representation of the user provided function app properties. See example.
//   - options - StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions contains the optional parameters for
//     the StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSite method.
func (client *StaticSitesClient) BeginRegisterUserProvidedFunctionAppWithStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, options *StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions) (*runtime.Poller[StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.registerUserProvidedFunctionAppWithStaticSite(ctx, resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// RegisterUserProvidedFunctionAppWithStaticSite - Description for Register a user provided function app with a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) registerUserProvidedFunctionAppWithStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, options *StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.registerUserProvidedFunctionAppWithStaticSiteCreateRequest(ctx, resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// registerUserProvidedFunctionAppWithStaticSiteCreateRequest creates the RegisterUserProvidedFunctionAppWithStaticSite request.
func (client *StaticSitesClient) registerUserProvidedFunctionAppWithStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, options *StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if functionAppName == "" {
		return nil, errors.New("parameter functionAppName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionAppName}", url.PathEscape(functionAppName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IsForced != nil {
		reqQP.Set("isForced", strconv.FormatBool(*options.IsForced))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteUserProvidedFunctionEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild - Description for Register a user provided function app with a
// static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - environmentName - The stage site identifier.
//   - functionAppName - Name of the function app to register with the static site build.
//   - staticSiteUserProvidedFunctionEnvelope - A JSON representation of the user provided function app properties. See example.
//   - options - StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions contains the optional parameters
//     for the StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild method.
func (client *StaticSitesClient) BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, options *StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions) (*runtime.Poller[StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteBuildResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.registerUserProvidedFunctionAppWithStaticSiteBuild(ctx, resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// RegisterUserProvidedFunctionAppWithStaticSiteBuild - Description for Register a user provided function app with a static
// site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) registerUserProvidedFunctionAppWithStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, options *StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.registerUserProvidedFunctionAppWithStaticSiteBuildCreateRequest(ctx, resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// registerUserProvidedFunctionAppWithStaticSiteBuildCreateRequest creates the RegisterUserProvidedFunctionAppWithStaticSiteBuild request.
func (client *StaticSitesClient) registerUserProvidedFunctionAppWithStaticSiteBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, options *StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if functionAppName == "" {
		return nil, errors.New("parameter functionAppName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{functionAppName}", url.PathEscape(functionAppName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IsForced != nil {
		reqQP.Set("isForced", strconv.FormatBool(*options.IsForced))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteUserProvidedFunctionEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// ResetStaticSiteAPIKey - Description for Resets the api key for an existing static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - options - StaticSitesClientResetStaticSiteAPIKeyOptions contains the optional parameters for the StaticSitesClient.ResetStaticSiteAPIKey
//     method.
func (client *StaticSitesClient) ResetStaticSiteAPIKey(ctx context.Context, resourceGroupName string, name string, resetPropertiesEnvelope StaticSiteResetPropertiesARMResource, options *StaticSitesClientResetStaticSiteAPIKeyOptions) (StaticSitesClientResetStaticSiteAPIKeyResponse, error) {
	var err error
	const operationName = "StaticSitesClient.ResetStaticSiteAPIKey"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.resetStaticSiteAPIKeyCreateRequest(ctx, resourceGroupName, name, resetPropertiesEnvelope, options)
	if err != nil {
		return StaticSitesClientResetStaticSiteAPIKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientResetStaticSiteAPIKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientResetStaticSiteAPIKeyResponse{}, err
	}
	return StaticSitesClientResetStaticSiteAPIKeyResponse{}, nil
}

// resetStaticSiteAPIKeyCreateRequest creates the ResetStaticSiteAPIKey request.
func (client *StaticSitesClient) resetStaticSiteAPIKeyCreateRequest(ctx context.Context, resourceGroupName string, name string, resetPropertiesEnvelope StaticSiteResetPropertiesARMResource, options *StaticSitesClientResetStaticSiteAPIKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/resetapikey"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resetPropertiesEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// UnlinkBackend - Unlink a backend from a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - linkedBackendName - Name of the backend linked to the static site
//   - options - StaticSitesClientUnlinkBackendOptions contains the optional parameters for the StaticSitesClient.UnlinkBackend
//     method.
func (client *StaticSitesClient) UnlinkBackend(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, options *StaticSitesClientUnlinkBackendOptions) (StaticSitesClientUnlinkBackendResponse, error) {
	var err error
	const operationName = "StaticSitesClient.UnlinkBackend"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.unlinkBackendCreateRequest(ctx, resourceGroupName, name, linkedBackendName, options)
	if err != nil {
		return StaticSitesClientUnlinkBackendResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientUnlinkBackendResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientUnlinkBackendResponse{}, err
	}
	return StaticSitesClientUnlinkBackendResponse{}, nil
}

// unlinkBackendCreateRequest creates the UnlinkBackend request.
func (client *StaticSitesClient) unlinkBackendCreateRequest(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, options *StaticSitesClientUnlinkBackendOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if linkedBackendName == "" {
		return nil, errors.New("parameter linkedBackendName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkedBackendName}", url.PathEscape(linkedBackendName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IsCleaningAuthConfig != nil {
		reqQP.Set("isCleaningAuthConfig", strconv.FormatBool(*options.IsCleaningAuthConfig))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UnlinkBackendFromBuild - Unlink a backend from a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier
//   - linkedBackendName - Name of the backend linked to the static site
//   - options - StaticSitesClientUnlinkBackendFromBuildOptions contains the optional parameters for the StaticSitesClient.UnlinkBackendFromBuild
//     method.
func (client *StaticSitesClient) UnlinkBackendFromBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, options *StaticSitesClientUnlinkBackendFromBuildOptions) (StaticSitesClientUnlinkBackendFromBuildResponse, error) {
	var err error
	const operationName = "StaticSitesClient.UnlinkBackendFromBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.unlinkBackendFromBuildCreateRequest(ctx, resourceGroupName, name, environmentName, linkedBackendName, options)
	if err != nil {
		return StaticSitesClientUnlinkBackendFromBuildResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientUnlinkBackendFromBuildResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientUnlinkBackendFromBuildResponse{}, err
	}
	return StaticSitesClientUnlinkBackendFromBuildResponse{}, nil
}

// unlinkBackendFromBuildCreateRequest creates the UnlinkBackendFromBuild request.
func (client *StaticSitesClient) unlinkBackendFromBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, options *StaticSitesClientUnlinkBackendFromBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if linkedBackendName == "" {
		return nil, errors.New("parameter linkedBackendName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkedBackendName}", url.PathEscape(linkedBackendName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IsCleaningAuthConfig != nil {
		reqQP.Set("isCleaningAuthConfig", strconv.FormatBool(*options.IsCleaningAuthConfig))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// UpdateBuildDatabaseConnection - Description for Create or update a database connection for a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier.
//   - databaseConnectionName - Name of the database connection.
//   - databaseConnectionRequestEnvelope - A JSON representation of the database connection request properties
//   - options - StaticSitesClientUpdateBuildDatabaseConnectionOptions contains the optional parameters for the StaticSitesClient.UpdateBuildDatabaseConnection
//     method.
func (client *StaticSitesClient) UpdateBuildDatabaseConnection(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, databaseConnectionRequestEnvelope DatabaseConnectionPatchRequest, options *StaticSitesClientUpdateBuildDatabaseConnectionOptions) (StaticSitesClientUpdateBuildDatabaseConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.UpdateBuildDatabaseConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateBuildDatabaseConnectionCreateRequest(ctx, resourceGroupName, name, environmentName, databaseConnectionName, databaseConnectionRequestEnvelope, options)
	if err != nil {
		return StaticSitesClientUpdateBuildDatabaseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientUpdateBuildDatabaseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientUpdateBuildDatabaseConnectionResponse{}, err
	}
	resp, err := client.updateBuildDatabaseConnectionHandleResponse(httpResp)
	return resp, err
}

// updateBuildDatabaseConnectionCreateRequest creates the UpdateBuildDatabaseConnection request.
func (client *StaticSitesClient) updateBuildDatabaseConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, databaseConnectionName string, databaseConnectionRequestEnvelope DatabaseConnectionPatchRequest, options *StaticSitesClientUpdateBuildDatabaseConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, databaseConnectionRequestEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// updateBuildDatabaseConnectionHandleResponse handles the UpdateBuildDatabaseConnection response.
func (client *StaticSitesClient) updateBuildDatabaseConnectionHandleResponse(resp *http.Response) (StaticSitesClientUpdateBuildDatabaseConnectionResponse, error) {
	result := StaticSitesClientUpdateBuildDatabaseConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnection); err != nil {
		return StaticSitesClientUpdateBuildDatabaseConnectionResponse{}, err
	}
	return result, nil
}

// UpdateDatabaseConnection - Description for Create or update a database connection for a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - databaseConnectionName - Name of the database connection.
//   - databaseConnectionRequestEnvelope - A JSON representation of the database connection request properties
//   - options - StaticSitesClientUpdateDatabaseConnectionOptions contains the optional parameters for the StaticSitesClient.UpdateDatabaseConnection
//     method.
func (client *StaticSitesClient) UpdateDatabaseConnection(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, databaseConnectionRequestEnvelope DatabaseConnectionPatchRequest, options *StaticSitesClientUpdateDatabaseConnectionOptions) (StaticSitesClientUpdateDatabaseConnectionResponse, error) {
	var err error
	const operationName = "StaticSitesClient.UpdateDatabaseConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateDatabaseConnectionCreateRequest(ctx, resourceGroupName, name, databaseConnectionName, databaseConnectionRequestEnvelope, options)
	if err != nil {
		return StaticSitesClientUpdateDatabaseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientUpdateDatabaseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientUpdateDatabaseConnectionResponse{}, err
	}
	resp, err := client.updateDatabaseConnectionHandleResponse(httpResp)
	return resp, err
}

// updateDatabaseConnectionCreateRequest creates the UpdateDatabaseConnection request.
func (client *StaticSitesClient) updateDatabaseConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, databaseConnectionName string, databaseConnectionRequestEnvelope DatabaseConnectionPatchRequest, options *StaticSitesClientUpdateDatabaseConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if databaseConnectionName == "" {
		return nil, errors.New("parameter databaseConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseConnectionName}", url.PathEscape(databaseConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, databaseConnectionRequestEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// updateDatabaseConnectionHandleResponse handles the UpdateDatabaseConnection response.
func (client *StaticSitesClient) updateDatabaseConnectionHandleResponse(resp *http.Response) (StaticSitesClientUpdateDatabaseConnectionResponse, error) {
	result := StaticSitesClientUpdateDatabaseConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseConnection); err != nil {
		return StaticSitesClientUpdateDatabaseConnectionResponse{}, err
	}
	return result, nil
}

// UpdateStaticSite - Description for Creates a new static site in an existing resource group, or updates an existing static
// site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site to create or update.
//   - staticSiteEnvelope - A JSON representation of the staticsite properties. See example.
//   - options - StaticSitesClientUpdateStaticSiteOptions contains the optional parameters for the StaticSitesClient.UpdateStaticSite
//     method.
func (client *StaticSitesClient) UpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSitePatchResource, options *StaticSitesClientUpdateStaticSiteOptions) (StaticSitesClientUpdateStaticSiteResponse, error) {
	var err error
	const operationName = "StaticSitesClient.UpdateStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateStaticSiteCreateRequest(ctx, resourceGroupName, name, staticSiteEnvelope, options)
	if err != nil {
		return StaticSitesClientUpdateStaticSiteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientUpdateStaticSiteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientUpdateStaticSiteResponse{}, err
	}
	resp, err := client.updateStaticSiteHandleResponse(httpResp)
	return resp, err
}

// updateStaticSiteCreateRequest creates the UpdateStaticSite request.
func (client *StaticSitesClient) updateStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSitePatchResource, options *StaticSitesClientUpdateStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// updateStaticSiteHandleResponse handles the UpdateStaticSite response.
func (client *StaticSitesClient) updateStaticSiteHandleResponse(resp *http.Response) (StaticSitesClientUpdateStaticSiteResponse, error) {
	result := StaticSitesClientUpdateStaticSiteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteARMResource); err != nil {
		return StaticSitesClientUpdateStaticSiteResponse{}, err
	}
	return result, nil
}

// UpdateStaticSiteUser - Description for Updates a user entry with the listed roles
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - authprovider - The auth provider for this user.
//   - userid - The user id of the user.
//   - staticSiteUserEnvelope - A JSON representation of the StaticSiteUser properties. See example.
//   - options - StaticSitesClientUpdateStaticSiteUserOptions contains the optional parameters for the StaticSitesClient.UpdateStaticSiteUser
//     method.
func (client *StaticSitesClient) UpdateStaticSiteUser(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, staticSiteUserEnvelope StaticSiteUserARMResource, options *StaticSitesClientUpdateStaticSiteUserOptions) (StaticSitesClientUpdateStaticSiteUserResponse, error) {
	var err error
	const operationName = "StaticSitesClient.UpdateStaticSiteUser"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateStaticSiteUserCreateRequest(ctx, resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope, options)
	if err != nil {
		return StaticSitesClientUpdateStaticSiteUserResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StaticSitesClientUpdateStaticSiteUserResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StaticSitesClientUpdateStaticSiteUserResponse{}, err
	}
	resp, err := client.updateStaticSiteUserHandleResponse(httpResp)
	return resp, err
}

// updateStaticSiteUserCreateRequest creates the UpdateStaticSiteUser request.
func (client *StaticSitesClient) updateStaticSiteUserCreateRequest(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, staticSiteUserEnvelope StaticSiteUserARMResource, options *StaticSitesClientUpdateStaticSiteUserOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if authprovider == "" {
		return nil, errors.New("parameter authprovider cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{authprovider}", url.PathEscape(authprovider))
	if userid == "" {
		return nil, errors.New("parameter userid cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{userid}", url.PathEscape(userid))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteUserEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// updateStaticSiteUserHandleResponse handles the UpdateStaticSiteUser response.
func (client *StaticSitesClient) updateStaticSiteUserHandleResponse(resp *http.Response) (StaticSitesClientUpdateStaticSiteUserResponse, error) {
	result := StaticSitesClientUpdateStaticSiteUserResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StaticSiteUserARMResource); err != nil {
		return StaticSitesClientUpdateStaticSiteUserResponse{}, err
	}
	return result, nil
}

// BeginValidateBackend - Validates that a backend can be linked to a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - linkedBackendName - Name of the linked backend that should be retrieved
//   - staticSiteLinkedBackendEnvelope - A JSON representation of the linked backend request properties
//   - options - StaticSitesClientBeginValidateBackendOptions contains the optional parameters for the StaticSitesClient.BeginValidateBackend
//     method.
func (client *StaticSitesClient) BeginValidateBackend(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginValidateBackendOptions) (*runtime.Poller[StaticSitesClientValidateBackendResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.validateBackend(ctx, resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientValidateBackendResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientValidateBackendResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ValidateBackend - Validates that a backend can be linked to a static site
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) validateBackend(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginValidateBackendOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginValidateBackend"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateBackendCreateRequest(ctx, resourceGroupName, name, linkedBackendName, staticSiteLinkedBackendEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// validateBackendCreateRequest creates the ValidateBackend request.
func (client *StaticSitesClient) validateBackendCreateRequest(ctx context.Context, resourceGroupName string, name string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginValidateBackendOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}/validate"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if linkedBackendName == "" {
		return nil, errors.New("parameter linkedBackendName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkedBackendName}", url.PathEscape(linkedBackendName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteLinkedBackendEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginValidateBackendForBuild - Validates that a backend can be linked to a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site
//   - environmentName - The stage site identifier
//   - linkedBackendName - Name of the linked backend that should be retrieved
//   - staticSiteLinkedBackendEnvelope - A JSON representation of the linked backend request properties
//   - options - StaticSitesClientBeginValidateBackendForBuildOptions contains the optional parameters for the StaticSitesClient.BeginValidateBackendForBuild
//     method.
func (client *StaticSitesClient) BeginValidateBackendForBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginValidateBackendForBuildOptions) (*runtime.Poller[StaticSitesClientValidateBackendForBuildResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.validateBackendForBuild(ctx, resourceGroupName, name, environmentName, linkedBackendName, staticSiteLinkedBackendEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientValidateBackendForBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientValidateBackendForBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ValidateBackendForBuild - Validates that a backend can be linked to a static site build
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) validateBackendForBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginValidateBackendForBuildOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginValidateBackendForBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateBackendForBuildCreateRequest(ctx, resourceGroupName, name, environmentName, linkedBackendName, staticSiteLinkedBackendEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// validateBackendForBuildCreateRequest creates the ValidateBackendForBuild request.
func (client *StaticSitesClient) validateBackendForBuildCreateRequest(ctx context.Context, resourceGroupName string, name string, environmentName string, linkedBackendName string, staticSiteLinkedBackendEnvelope StaticSiteLinkedBackendARMResource, options *StaticSitesClientBeginValidateBackendForBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}/validate"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if environmentName == "" {
		return nil, errors.New("parameter environmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentName}", url.PathEscape(environmentName))
	if linkedBackendName == "" {
		return nil, errors.New("parameter linkedBackendName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkedBackendName}", url.PathEscape(linkedBackendName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteLinkedBackendEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginValidateCustomDomainCanBeAddedToStaticSite - Description for Validates a particular custom domain can be added to
// a static site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the static site.
//   - domainName - The custom domain to validate.
//   - staticSiteCustomDomainRequestPropertiesEnvelope - A JSON representation of the static site custom domain request properties.
//     See example.
//   - options - StaticSitesClientBeginValidateCustomDomainCanBeAddedToStaticSiteOptions contains the optional parameters for
//     the StaticSitesClient.BeginValidateCustomDomainCanBeAddedToStaticSite method.
func (client *StaticSitesClient) BeginValidateCustomDomainCanBeAddedToStaticSite(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource, options *StaticSitesClientBeginValidateCustomDomainCanBeAddedToStaticSiteOptions) (*runtime.Poller[StaticSitesClientValidateCustomDomainCanBeAddedToStaticSiteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.validateCustomDomainCanBeAddedToStaticSite(ctx, resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StaticSitesClientValidateCustomDomainCanBeAddedToStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StaticSitesClientValidateCustomDomainCanBeAddedToStaticSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ValidateCustomDomainCanBeAddedToStaticSite - Description for Validates a particular custom domain can be added to a static
// site.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StaticSitesClient) validateCustomDomainCanBeAddedToStaticSite(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource, options *StaticSitesClientBeginValidateCustomDomainCanBeAddedToStaticSiteOptions) (*http.Response, error) {
	var err error
	const operationName = "StaticSitesClient.BeginValidateCustomDomainCanBeAddedToStaticSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateCustomDomainCanBeAddedToStaticSiteCreateRequest(ctx, resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// validateCustomDomainCanBeAddedToStaticSiteCreateRequest creates the ValidateCustomDomainCanBeAddedToStaticSite request.
func (client *StaticSitesClient) validateCustomDomainCanBeAddedToStaticSiteCreateRequest(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource, options *StaticSitesClientBeginValidateCustomDomainCanBeAddedToStaticSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}/validate"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, staticSiteCustomDomainRequestPropertiesEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}
