//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// PriceSheetServer is a fake server for instances of the armcostmanagement.PriceSheetClient type.
type PriceSheetServer struct {
	// BeginDownload is the fake for method PriceSheetClient.BeginDownload
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDownload func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceName string, options *armcostmanagement.PriceSheetClientBeginDownloadOptions) (resp azfake.PollerResponder[armcostmanagement.PriceSheetClientDownloadResponse], errResp azfake.ErrorResponder)

	// BeginDownloadByBillingProfile is the fake for method PriceSheetClient.BeginDownloadByBillingProfile
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDownloadByBillingProfile func(ctx context.Context, billingAccountName string, billingProfileName string, options *armcostmanagement.PriceSheetClientBeginDownloadByBillingProfileOptions) (resp azfake.PollerResponder[armcostmanagement.PriceSheetClientDownloadByBillingProfileResponse], errResp azfake.ErrorResponder)
}

// NewPriceSheetServerTransport creates a new instance of PriceSheetServerTransport with the provided implementation.
// The returned PriceSheetServerTransport instance is connected to an instance of armcostmanagement.PriceSheetClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPriceSheetServerTransport(srv *PriceSheetServer) *PriceSheetServerTransport {
	return &PriceSheetServerTransport{
		srv:                           srv,
		beginDownload:                 newTracker[azfake.PollerResponder[armcostmanagement.PriceSheetClientDownloadResponse]](),
		beginDownloadByBillingProfile: newTracker[azfake.PollerResponder[armcostmanagement.PriceSheetClientDownloadByBillingProfileResponse]](),
	}
}

// PriceSheetServerTransport connects instances of armcostmanagement.PriceSheetClient to instances of PriceSheetServer.
// Don't use this type directly, use NewPriceSheetServerTransport instead.
type PriceSheetServerTransport struct {
	srv                           *PriceSheetServer
	beginDownload                 *tracker[azfake.PollerResponder[armcostmanagement.PriceSheetClientDownloadResponse]]
	beginDownloadByBillingProfile *tracker[azfake.PollerResponder[armcostmanagement.PriceSheetClientDownloadByBillingProfileResponse]]
}

// Do implements the policy.Transporter interface for PriceSheetServerTransport.
func (p *PriceSheetServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PriceSheetClient.BeginDownload":
		resp, err = p.dispatchBeginDownload(req)
	case "PriceSheetClient.BeginDownloadByBillingProfile":
		resp, err = p.dispatchBeginDownloadByBillingProfile(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PriceSheetServerTransport) dispatchBeginDownload(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDownload == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDownload not implemented")}
	}
	beginDownload := p.beginDownload.get(req)
	if beginDownload == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoices/(?P<invoiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/pricesheets/default/download`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		invoiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDownload(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDownload = &respr
		p.beginDownload.add(req, beginDownload)
	}

	resp, err := server.PollerResponderNext(beginDownload, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginDownload.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDownload) {
		p.beginDownload.remove(req)
	}

	return resp, nil
}

func (p *PriceSheetServerTransport) dispatchBeginDownloadByBillingProfile(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDownloadByBillingProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDownloadByBillingProfile not implemented")}
	}
	beginDownloadByBillingProfile := p.beginDownloadByBillingProfile.get(req)
	if beginDownloadByBillingProfile == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/pricesheets/default/download`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDownloadByBillingProfile(req.Context(), billingAccountNameParam, billingProfileNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDownloadByBillingProfile = &respr
		p.beginDownloadByBillingProfile.add(req, beginDownloadByBillingProfile)
	}

	resp, err := server.PollerResponderNext(beginDownloadByBillingProfile, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginDownloadByBillingProfile.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDownloadByBillingProfile) {
		p.beginDownloadByBillingProfile.remove(req)
	}

	return resp, nil
}
