//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatacatalog

// ADCCatalog - Azure Data Catalog.
type ADCCatalog struct {
	// Resource etag
	Etag *string

	// Resource location
	Location *string

	// Azure Data Catalog properties.
	Properties *ADCCatalogProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ADCCatalogProperties - Properties of the data catalog.
type ADCCatalogProperties struct {
	// Azure data catalog admin list.
	Admins []*Principals

	// Automatic unit adjustment enabled or not.
	EnableAutomaticUnitAdjustment *bool

	// Azure data catalog SKU.
	SKU *SKUType

	// Azure data catalog provision status.
	SuccessfullyProvisioned *bool

	// Azure data catalog units.
	Units *int32

	// Azure data catalog user list.
	Users []*Principals
}

// ADCCatalogsListResult - The response from the List Azure Data Catalog operation.
type ADCCatalogsListResult struct {
	// the list of Azure Data Catalogs.
	Value []*ADCCatalog
}

// OperationDisplayInfo - The operation supported by Azure Data Catalog Service.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string

	// The action that users can perform, based on their permission level.
	Operation *string

	// Service provider: Azure Data Catalog Service.
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// OperationEntity - The operation supported by Azure Data Catalog Service.
type OperationEntity struct {
	// The operation supported by Azure Data Catalog Service.
	Display *OperationDisplayInfo

	// Operation name: {provider}/{resource}/{operation}.
	Name *string
}

// OperationEntityListResult - The list of Azure data catalog service operation response.
type OperationEntityListResult struct {
	// The list of operations.
	Value []*OperationEntity
}

// Principals - User principals.
type Principals struct {
	// Object Id for the user
	ObjectID *string

	// UPN of the user.
	Upn *string
}

// Resource - The Resource model definition.
type Resource struct {
	// Resource etag
	Etag *string

	// Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}
