//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmarketplace_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/marketplace/armmarketplace"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetPrivateStoreCollectionsList.json
func ExamplePrivateStoreCollectionClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreCollectionClient().List(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CollectionsList = armmarketplace.CollectionsList{
	// 	Value: []*armmarketplace.Collection{
	// 		{
	// 			Name: to.Ptr("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d"),
	// 			Type: to.Ptr("Microsoft.Marketplace/privateStores/collections"),
	// 			ID: to.Ptr("providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/collections"),
	// 			SystemData: &armmarketplace.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 				CreatedBy: to.Ptr("user@somedoamin.com"),
	// 				CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 				LastModifiedBy: to.Ptr("user@somedoamin.com"),
	// 				LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 			},
	// 			Properties: &armmarketplace.CollectionProperties{
	// 				AllSubscriptions: to.Ptr(true),
	// 				Claim: to.Ptr(""),
	// 				CollectionID: to.Ptr("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d"),
	// 				CollectionName: to.Ptr("Default Collection"),
	// 				SubscriptionsList: []*string{
	// 				},
	// 			},
	// 		},
	// 		{
	// 			Name: to.Ptr("fba3f52c-874a-4010-87cf-c1cfa6ed3490"),
	// 			Type: to.Ptr("Microsoft.Marketplace/privateStores/collections"),
	// 			ID: to.Ptr("providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/collections"),
	// 			SystemData: &armmarketplace.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 				CreatedBy: to.Ptr("user@somedoamin.com"),
	// 				CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 				LastModifiedBy: to.Ptr("user@somedoamin.com"),
	// 				LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 			},
	// 			Properties: &armmarketplace.CollectionProperties{
	// 				AllSubscriptions: to.Ptr(false),
	// 				Claim: to.Ptr(""),
	// 				CollectionID: to.Ptr("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d"),
	// 				CollectionName: to.Ptr("Dev collection"),
	// 				SubscriptionsList: []*string{
	// 					to.Ptr("7c927b63-59cf-4a0f-9d13-41e11f1ddf76")},
	// 				},
	// 		}},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetPrivateStoreCollection.json
func ExamplePrivateStoreCollectionClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreCollectionClient().Get(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Collection = armmarketplace.Collection{
	// 	Name: to.Ptr("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d"),
	// 	Type: to.Ptr("Microsoft.Marketplace/privateStores/collections"),
	// 	ID: to.Ptr("providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/collections/56a1a02d-8cf8-45df-bf37-d5f7120fcb3d"),
	// 	SystemData: &armmarketplace.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@somedoamin.com"),
	// 		CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@somedoamin.com"),
	// 		LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 	},
	// 	Properties: &armmarketplace.CollectionProperties{
	// 		AllSubscriptions: to.Ptr(true),
	// 		Claim: to.Ptr(""),
	// 		CollectionID: to.Ptr("56a1a02d-8cf8-45df-bf37-d5f7120fcb3d"),
	// 		CollectionName: to.Ptr("Default Collection"),
	// 		SubscriptionsList: []*string{
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/CreatePrivateStoreCollection.json
func ExamplePrivateStoreCollectionClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreCollectionClient().CreateOrUpdate(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1", &armmarketplace.PrivateStoreCollectionClientCreateOrUpdateOptions{Payload: &armmarketplace.Collection{
		Properties: &armmarketplace.CollectionProperties{
			AllSubscriptions: to.Ptr(false),
			Claim:            to.Ptr(""),
			CollectionName:   to.Ptr("Test Collection"),
			SubscriptionsList: []*string{
				to.Ptr("b340914e-353d-453a-85fb-8f9b65b51f91"),
				to.Ptr("f2baa04d-5bfc-461b-b6d8-61b403c9ec48")},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Collection = armmarketplace.Collection{
	// 	Name: to.Ptr("d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1"),
	// 	Type: to.Ptr("Microsoft.Marketplace/privateStores/collections"),
	// 	ID: to.Ptr("providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/collections/d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1"),
	// 	SystemData: &armmarketplace.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-01T08:23:17.657Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@somedoamin.com"),
	// 		CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-01T08:23:17.657Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@somedoamin.com"),
	// 		LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 	},
	// 	Properties: &armmarketplace.CollectionProperties{
	// 		AllSubscriptions: to.Ptr(false),
	// 		Claim: to.Ptr(""),
	// 		CollectionName: to.Ptr("Test Collection"),
	// 		SubscriptionsList: []*string{
	// 			to.Ptr("b340914e-353d-453a-85fb-8f9b65b51f91"),
	// 			to.Ptr("f2baa04d-5bfc-461b-b6d8-61b403c9ec48")},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/DeletePrivateStoreCollection.json
func ExamplePrivateStoreCollectionClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPrivateStoreCollectionClient().Delete(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/PostPrivateStoreCollection.json
func ExamplePrivateStoreCollectionClient_Post() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPrivateStoreCollectionClient().Post(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d", &armmarketplace.PrivateStoreCollectionClientPostOptions{Payload: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/TransferOffers.json
func ExamplePrivateStoreCollectionClient_TransferOffers() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreCollectionClient().TransferOffers(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d", &armmarketplace.PrivateStoreCollectionClientTransferOffersOptions{Payload: &armmarketplace.TransferOffersProperties{
		Properties: &armmarketplace.TransferOffersDetails{
			OfferIDsList: []*string{
				to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
				to.Ptr("marketplacetestthirdparty.md-test-third-party-3")},
			Operation: to.Ptr("copy"),
			TargetCollections: []*string{
				to.Ptr("c752f021-1c37-4af5-b82f-74c51c27b44a"),
				to.Ptr("f47ef1c7-e908-4f39-ae29-db181634ad8d")},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TransferOffersResponse = armmarketplace.TransferOffersResponse{
	// 	Failed: []*armmarketplace.CollectionsDetails{
	// 		{
	// 			CollectionID: to.Ptr("f47ef1c7-e908-4f39-ae29-db181634ad8d"),
	// 			CollectionName: to.Ptr("Test collection 2"),
	// 	}},
	// 	Succeeded: []*armmarketplace.CollectionsDetails{
	// 		{
	// 			CollectionID: to.Ptr("c752f021-1c37-4af5-b82f-74c51c27b44a"),
	// 			CollectionName: to.Ptr("Test collection"),
	// 	}},
	// }
}
