//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armscvmm_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/scvmm/armscvmm"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/GetVirtualMachine.json
func ExampleVirtualMachinesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualMachinesClient().Get(ctx, "testrg", "DemoVM", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachine = armscvmm.VirtualMachine{
	// 	Name: to.Ptr("DemoVM"),
	// 	Type: to.Ptr("Microsoft.SCVMM/VirtualMachines"),
	// 	ExtendedLocation: &armscvmm.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
	// 		Type: to.Ptr("customLocation"),
	// 	},
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachines/DemoVM"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armscvmm.VirtualMachineProperties{
	// 		CloudID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
	// 		HardwareProfile: &armscvmm.HardwareProfile{
	// 			CPUCount: to.Ptr[int32](4),
	// 			MemoryMB: to.Ptr[int32](4096),
	// 		},
	// 		OSProfile: &armscvmm.OsProfile{
	// 			ComputerName: to.Ptr("DemoVM"),
	// 			OSType: to.Ptr(armscvmm.OsTypeWindows),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		TemplateID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
	// 		VmmServerID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/CreateVirtualMachine.json
func ExampleVirtualMachinesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginCreateOrUpdate(ctx, "testrg", "DemoVM", armscvmm.VirtualMachine{
		ExtendedLocation: &armscvmm.ExtendedLocation{
			Name: to.Ptr("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
			Type: to.Ptr("customLocation"),
		},
		Location: to.Ptr("East US"),
		Properties: &armscvmm.VirtualMachineProperties{
			CloudID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
			HardwareProfile: &armscvmm.HardwareProfile{
				CPUCount: to.Ptr[int32](4),
				MemoryMB: to.Ptr[int32](4096),
			},
			TemplateID:  to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
			VmmServerID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachine = armscvmm.VirtualMachine{
	// 	Name: to.Ptr("DemoVM"),
	// 	Type: to.Ptr("Microsoft.SCVMM/VirtualMachines"),
	// 	ExtendedLocation: &armscvmm.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
	// 		Type: to.Ptr("customLocation"),
	// 	},
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachines/DemoVM"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armscvmm.VirtualMachineProperties{
	// 		CloudID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
	// 		HardwareProfile: &armscvmm.HardwareProfile{
	// 			CPUCount: to.Ptr[int32](4),
	// 			MemoryMB: to.Ptr[int32](4096),
	// 		},
	// 		OSProfile: &armscvmm.OsProfile{
	// 			ComputerName: to.Ptr("DemoVM"),
	// 			OSType: to.Ptr(armscvmm.OsTypeWindows),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		TemplateID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
	// 		VmmServerID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/DeleteVirtualMachine.json
func ExampleVirtualMachinesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginDelete(ctx, "testrg", "DemoVM", &armscvmm.VirtualMachinesClientBeginDeleteOptions{Retain: nil,
		Force: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/UpdateVirtualMachine.json
func ExampleVirtualMachinesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginUpdate(ctx, "testrg", "DemoVM", armscvmm.VirtualMachineUpdate{
		Properties: &armscvmm.VirtualMachineUpdateProperties{
			HardwareProfile: &armscvmm.HardwareProfileUpdate{
				CPUCount: to.Ptr[int32](4),
				MemoryMB: to.Ptr[int32](4096),
			},
			NetworkProfile: &armscvmm.NetworkProfileUpdate{
				NetworkInterfaces: []*armscvmm.NetworkInterfacesUpdate{
					{
						Name:            to.Ptr("test"),
						IPv4AddressType: to.Ptr(armscvmm.AllocationMethodDynamic),
						IPv6AddressType: to.Ptr(armscvmm.AllocationMethodDynamic),
						MacAddressType:  to.Ptr(armscvmm.AllocationMethodStatic),
					}},
			},
			StorageProfile: &armscvmm.StorageProfileUpdate{
				Disks: []*armscvmm.VirtualDiskUpdate{
					{
						Name:       to.Ptr("test"),
						DiskSizeGB: to.Ptr[int32](10),
					}},
			},
		},
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachine = armscvmm.VirtualMachine{
	// 	Name: to.Ptr("DemoVM"),
	// 	Type: to.Ptr("Microsoft.SCVMM/VirtualMachines"),
	// 	ExtendedLocation: &armscvmm.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
	// 		Type: to.Ptr("customLocation"),
	// 	},
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachines/DemoVM"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armscvmm.VirtualMachineProperties{
	// 		CloudID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
	// 		Generation: to.Ptr[int32](0),
	// 		HardwareProfile: &armscvmm.HardwareProfile{
	// 			CPUCount: to.Ptr[int32](4),
	// 			DynamicMemoryEnabled: to.Ptr(armscvmm.DynamicMemoryEnabledFalse),
	// 			DynamicMemoryMaxMB: to.Ptr[int32](0),
	// 			DynamicMemoryMinMB: to.Ptr[int32](0),
	// 			IsHighlyAvailable: to.Ptr("string"),
	// 			MemoryMB: to.Ptr[int32](4096),
	// 		},
	// 		NetworkProfile: &armscvmm.NetworkProfile{
	// 			NetworkInterfaces: []*armscvmm.NetworkInterfaces{
	// 				{
	// 					Name: to.Ptr("test"),
	// 					DisplayName: to.Ptr("string"),
	// 					IPv4AddressType: to.Ptr(armscvmm.AllocationMethodDynamic),
	// 					IPv4Addresses: []*string{
	// 						to.Ptr("string")},
	// 						IPv6AddressType: to.Ptr(armscvmm.AllocationMethodDynamic),
	// 						IPv6Addresses: []*string{
	// 							to.Ptr("string")},
	// 							MacAddress: to.Ptr("string"),
	// 							MacAddressType: to.Ptr(armscvmm.AllocationMethodStatic),
	// 							NetworkName: to.Ptr("string"),
	// 							NicID: to.Ptr("string"),
	// 							VirtualNetworkID: to.Ptr("string"),
	// 					}},
	// 				},
	// 				OSProfile: &armscvmm.OsProfile{
	// 					ComputerName: to.Ptr("DemoVM"),
	// 					OSName: to.Ptr("string"),
	// 					OSType: to.Ptr(armscvmm.OsTypeWindows),
	// 				},
	// 				PowerState: to.Ptr("string"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				StorageProfile: &armscvmm.StorageProfile{
	// 					Disks: []*armscvmm.VirtualDisk{
	// 						{
	// 							Name: to.Ptr("test"),
	// 							Bus: to.Ptr[int32](0),
	// 							BusType: to.Ptr("string"),
	// 							CreateDiffDisk: to.Ptr(armscvmm.CreateDiffDiskFalse),
	// 							DiskID: to.Ptr("string"),
	// 							DiskSizeGB: to.Ptr[int32](10),
	// 							DisplayName: to.Ptr("string"),
	// 							Lun: to.Ptr[int32](0),
	// 							MaxDiskSizeGB: to.Ptr[int32](10),
	// 							StorageQoSPolicy: &armscvmm.StorageQoSPolicyDetails{
	// 								Name: to.Ptr("string"),
	// 								ID: to.Ptr("string"),
	// 							},
	// 							TemplateDiskID: to.Ptr("string"),
	// 							VhdFormatType: to.Ptr("string"),
	// 							VhdType: to.Ptr("string"),
	// 							VolumeType: to.Ptr("string"),
	// 					}},
	// 				},
	// 				TemplateID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
	// 				UUID: to.Ptr("string"),
	// 				VMName: to.Ptr("string"),
	// 				VmmServerID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
	// 			},
	// 			Tags: map[string]*string{
	// 				"tag1": to.Ptr("value1"),
	// 				"tag2": to.Ptr("value2"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/StopVirtualMachine.json
func ExampleVirtualMachinesClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginStop(ctx, "testrg", "DemoVM", &armscvmm.VirtualMachinesClientBeginStopOptions{Body: &armscvmm.StopVirtualMachineOptions{
		SkipShutdown: to.Ptr(true),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/StartVirtualMachine.json
func ExampleVirtualMachinesClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginStart(ctx, "testrg", "DemoVM", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/RestartVirtualMachine.json
func ExampleVirtualMachinesClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginRestart(ctx, "testrg", "DemoVM", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/CreateCheckpointVirtualMachine.json
func ExampleVirtualMachinesClient_BeginCreateCheckpoint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginCreateCheckpoint(ctx, "testrg", "DemoVM", &armscvmm.VirtualMachinesClientBeginCreateCheckpointOptions{Body: &armscvmm.VirtualMachineCreateCheckpoint{
		Name:        to.Ptr("Demo Checkpoint name"),
		Description: to.Ptr("Demo Checkpoint description"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/DeleteCheckpointVirtualMachine.json
func ExampleVirtualMachinesClient_BeginDeleteCheckpoint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginDeleteCheckpoint(ctx, "testrg", "DemoVM", &armscvmm.VirtualMachinesClientBeginDeleteCheckpointOptions{Body: &armscvmm.VirtualMachineDeleteCheckpoint{
		ID: to.Ptr("Demo CheckpointID"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/RestoreCheckpointVirtualMachine.json
func ExampleVirtualMachinesClient_BeginRestoreCheckpoint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachinesClient().BeginRestoreCheckpoint(ctx, "testrg", "DemoVM", &armscvmm.VirtualMachinesClientBeginRestoreCheckpointOptions{Body: &armscvmm.VirtualMachineRestoreCheckpoint{
		ID: to.Ptr("Demo CheckpointID"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/ListVirtualMachinesByResourceGroup.json
func ExampleVirtualMachinesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualMachinesClient().NewListByResourceGroupPager("testrg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VirtualMachineListResult = armscvmm.VirtualMachineListResult{
		// 	Value: []*armscvmm.VirtualMachine{
		// 		{
		// 			Name: to.Ptr("DemoVM"),
		// 			Type: to.Ptr("Microsoft.SCVMM/VirtualMachines"),
		// 			ExtendedLocation: &armscvmm.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
		// 				Type: to.Ptr("customLocation"),
		// 			},
		// 			ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachines/DemoVM"),
		// 			Location: to.Ptr("East US"),
		// 			Properties: &armscvmm.VirtualMachineProperties{
		// 				CloudID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
		// 				HardwareProfile: &armscvmm.HardwareProfile{
		// 					CPUCount: to.Ptr[int32](4),
		// 					MemoryMB: to.Ptr[int32](4096),
		// 				},
		// 				OSProfile: &armscvmm.OsProfile{
		// 					ComputerName: to.Ptr("DemoVM"),
		// 					OSType: to.Ptr(armscvmm.OsTypeWindows),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				TemplateID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
		// 				VmmServerID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/scvmm/resource-manager/Microsoft.ScVmm/preview/2020-06-05-preview/examples/ListVirtualMachinesBySubscription.json
func ExampleVirtualMachinesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armscvmm.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualMachinesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VirtualMachineListResult = armscvmm.VirtualMachineListResult{
		// 	Value: []*armscvmm.VirtualMachine{
		// 		{
		// 			Name: to.Ptr("DemoVM"),
		// 			Type: to.Ptr("Microsoft.SCVMM/VirtualMachines"),
		// 			ExtendedLocation: &armscvmm.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
		// 				Type: to.Ptr("customLocation"),
		// 			},
		// 			ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachines/DemoVM"),
		// 			Location: to.Ptr("East US"),
		// 			Properties: &armscvmm.VirtualMachineProperties{
		// 				CloudID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
		// 				HardwareProfile: &armscvmm.HardwareProfile{
		// 					CPUCount: to.Ptr[int32](4),
		// 					MemoryMB: to.Ptr[int32](4096),
		// 				},
		// 				OSProfile: &armscvmm.OsProfile{
		// 					ComputerName: to.Ptr("DemoVM"),
		// 					OSType: to.Ptr(armscvmm.OsTypeWindows),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				TemplateID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
		// 				VmmServerID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
		// 			},
		// 	}},
		// }
	}
}
