//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SQLPoolTableColumnsServer is a fake server for instances of the armsynapse.SQLPoolTableColumnsClient type.
type SQLPoolTableColumnsServer struct {
	// NewListByTableNamePager is the fake for method SQLPoolTableColumnsClient.NewListByTableNamePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTableNamePager func(resourceGroupName string, workspaceName string, sqlPoolName string, schemaName string, tableName string, options *armsynapse.SQLPoolTableColumnsClientListByTableNameOptions) (resp azfake.PagerResponder[armsynapse.SQLPoolTableColumnsClientListByTableNameResponse])
}

// NewSQLPoolTableColumnsServerTransport creates a new instance of SQLPoolTableColumnsServerTransport with the provided implementation.
// The returned SQLPoolTableColumnsServerTransport instance is connected to an instance of armsynapse.SQLPoolTableColumnsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLPoolTableColumnsServerTransport(srv *SQLPoolTableColumnsServer) *SQLPoolTableColumnsServerTransport {
	return &SQLPoolTableColumnsServerTransport{
		srv:                     srv,
		newListByTableNamePager: newTracker[azfake.PagerResponder[armsynapse.SQLPoolTableColumnsClientListByTableNameResponse]](),
	}
}

// SQLPoolTableColumnsServerTransport connects instances of armsynapse.SQLPoolTableColumnsClient to instances of SQLPoolTableColumnsServer.
// Don't use this type directly, use NewSQLPoolTableColumnsServerTransport instead.
type SQLPoolTableColumnsServerTransport struct {
	srv                     *SQLPoolTableColumnsServer
	newListByTableNamePager *tracker[azfake.PagerResponder[armsynapse.SQLPoolTableColumnsClientListByTableNameResponse]]
}

// Do implements the policy.Transporter interface for SQLPoolTableColumnsServerTransport.
func (s *SQLPoolTableColumnsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLPoolTableColumnsClient.NewListByTableNamePager":
		resp, err = s.dispatchNewListByTableNamePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLPoolTableColumnsServerTransport) dispatchNewListByTableNamePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByTableNamePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTableNamePager not implemented")}
	}
	newListByTableNamePager := s.newListByTableNamePager.get(req)
	if newListByTableNamePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/schemas/(?P<schemaName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/columns`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
		if err != nil {
			return nil, err
		}
		schemaNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("schemaName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armsynapse.SQLPoolTableColumnsClientListByTableNameOptions
		if filterParam != nil {
			options = &armsynapse.SQLPoolTableColumnsClientListByTableNameOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListByTableNamePager(resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, schemaNameParam, tableNameParam, options)
		newListByTableNamePager = &resp
		s.newListByTableNamePager.add(req, newListByTableNamePager)
		server.PagerResponderInjectNextLinks(newListByTableNamePager, req, func(page *armsynapse.SQLPoolTableColumnsClientListByTableNameResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTableNamePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByTableNamePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTableNamePager) {
		s.newListByTableNamePager.remove(req)
	}
	return resp, nil
}
