// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package privateca aliases all exported identifiers in package
// "cloud.google.com/go/security/privateca/apiv1/privatecapb".
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package privateca

import (
	src "cloud.google.com/go/security/privateca/apiv1/privatecapb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/security/privateca/apiv1/privatecapb
const (
	CaPool_DEVOPS                                                                     = src.CaPool_DEVOPS
	CaPool_ENTERPRISE                                                                 = src.CaPool_ENTERPRISE
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_ECDSA_P256                         = src.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_ECDSA_P256
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_ECDSA_P384                         = src.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_ECDSA_P384
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EC_SIGNATURE_ALGORITHM_UNSPECIFIED = src.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EC_SIGNATURE_ALGORITHM_UNSPECIFIED
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EDDSA_25519                        = src.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EDDSA_25519
	CaPool_TIER_UNSPECIFIED                                                           = src.CaPool_TIER_UNSPECIFIED
	CertificateAuthority_AWAITING_USER_ACTIVATION                                     = src.CertificateAuthority_AWAITING_USER_ACTIVATION
	CertificateAuthority_DELETED                                                      = src.CertificateAuthority_DELETED
	CertificateAuthority_DISABLED                                                     = src.CertificateAuthority_DISABLED
	CertificateAuthority_EC_P256_SHA256                                               = src.CertificateAuthority_EC_P256_SHA256
	CertificateAuthority_EC_P384_SHA384                                               = src.CertificateAuthority_EC_P384_SHA384
	CertificateAuthority_ENABLED                                                      = src.CertificateAuthority_ENABLED
	CertificateAuthority_RSA_PKCS1_2048_SHA256                                        = src.CertificateAuthority_RSA_PKCS1_2048_SHA256
	CertificateAuthority_RSA_PKCS1_3072_SHA256                                        = src.CertificateAuthority_RSA_PKCS1_3072_SHA256
	CertificateAuthority_RSA_PKCS1_4096_SHA256                                        = src.CertificateAuthority_RSA_PKCS1_4096_SHA256
	CertificateAuthority_RSA_PSS_2048_SHA256                                          = src.CertificateAuthority_RSA_PSS_2048_SHA256
	CertificateAuthority_RSA_PSS_3072_SHA256                                          = src.CertificateAuthority_RSA_PSS_3072_SHA256
	CertificateAuthority_RSA_PSS_4096_SHA256                                          = src.CertificateAuthority_RSA_PSS_4096_SHA256
	CertificateAuthority_SELF_SIGNED                                                  = src.CertificateAuthority_SELF_SIGNED
	CertificateAuthority_SIGN_HASH_ALGORITHM_UNSPECIFIED                              = src.CertificateAuthority_SIGN_HASH_ALGORITHM_UNSPECIFIED
	CertificateAuthority_STAGED                                                       = src.CertificateAuthority_STAGED
	CertificateAuthority_STATE_UNSPECIFIED                                            = src.CertificateAuthority_STATE_UNSPECIFIED
	CertificateAuthority_SUBORDINATE                                                  = src.CertificateAuthority_SUBORDINATE
	CertificateAuthority_TYPE_UNSPECIFIED                                             = src.CertificateAuthority_TYPE_UNSPECIFIED
	CertificateExtensionConstraints_AIA_OCSP_SERVERS                                  = src.CertificateExtensionConstraints_AIA_OCSP_SERVERS
	CertificateExtensionConstraints_BASE_KEY_USAGE                                    = src.CertificateExtensionConstraints_BASE_KEY_USAGE
	CertificateExtensionConstraints_CA_OPTIONS                                        = src.CertificateExtensionConstraints_CA_OPTIONS
	CertificateExtensionConstraints_EXTENDED_KEY_USAGE                                = src.CertificateExtensionConstraints_EXTENDED_KEY_USAGE
	CertificateExtensionConstraints_KNOWN_CERTIFICATE_EXTENSION_UNSPECIFIED           = src.CertificateExtensionConstraints_KNOWN_CERTIFICATE_EXTENSION_UNSPECIFIED
	CertificateExtensionConstraints_POLICY_IDS                                        = src.CertificateExtensionConstraints_POLICY_IDS
	CertificateRevocationList_ACTIVE                                                  = src.CertificateRevocationList_ACTIVE
	CertificateRevocationList_STATE_UNSPECIFIED                                       = src.CertificateRevocationList_STATE_UNSPECIFIED
	CertificateRevocationList_SUPERSEDED                                              = src.CertificateRevocationList_SUPERSEDED
	PublicKey_KEY_FORMAT_UNSPECIFIED                                                  = src.PublicKey_KEY_FORMAT_UNSPECIFIED
	PublicKey_PEM                                                                     = src.PublicKey_PEM
	RevocationReason_AFFILIATION_CHANGED                                              = src.RevocationReason_AFFILIATION_CHANGED
	RevocationReason_ATTRIBUTE_AUTHORITY_COMPROMISE                                   = src.RevocationReason_ATTRIBUTE_AUTHORITY_COMPROMISE
	RevocationReason_CERTIFICATE_AUTHORITY_COMPROMISE                                 = src.RevocationReason_CERTIFICATE_AUTHORITY_COMPROMISE
	RevocationReason_CERTIFICATE_HOLD                                                 = src.RevocationReason_CERTIFICATE_HOLD
	RevocationReason_CESSATION_OF_OPERATION                                           = src.RevocationReason_CESSATION_OF_OPERATION
	RevocationReason_KEY_COMPROMISE                                                   = src.RevocationReason_KEY_COMPROMISE
	RevocationReason_PRIVILEGE_WITHDRAWN                                              = src.RevocationReason_PRIVILEGE_WITHDRAWN
	RevocationReason_REVOCATION_REASON_UNSPECIFIED                                    = src.RevocationReason_REVOCATION_REASON_UNSPECIFIED
	RevocationReason_SUPERSEDED                                                       = src.RevocationReason_SUPERSEDED
	SubjectRequestMode_DEFAULT                                                        = src.SubjectRequestMode_DEFAULT
	SubjectRequestMode_REFLECTED_SPIFFE                                               = src.SubjectRequestMode_REFLECTED_SPIFFE
	SubjectRequestMode_SUBJECT_REQUEST_MODE_UNSPECIFIED                               = src.SubjectRequestMode_SUBJECT_REQUEST_MODE_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/security/privateca/apiv1/privatecapb
var (
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm_name  = src.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm_name
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm_value = src.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm_value
	CaPool_Tier_name                                                          = src.CaPool_Tier_name
	CaPool_Tier_value                                                         = src.CaPool_Tier_value
	CertificateAuthority_SignHashAlgorithm_name                               = src.CertificateAuthority_SignHashAlgorithm_name
	CertificateAuthority_SignHashAlgorithm_value                              = src.CertificateAuthority_SignHashAlgorithm_value
	CertificateAuthority_State_name                                           = src.CertificateAuthority_State_name
	CertificateAuthority_State_value                                          = src.CertificateAuthority_State_value
	CertificateAuthority_Type_name                                            = src.CertificateAuthority_Type_name
	CertificateAuthority_Type_value                                           = src.CertificateAuthority_Type_value
	CertificateExtensionConstraints_KnownCertificateExtension_name            = src.CertificateExtensionConstraints_KnownCertificateExtension_name
	CertificateExtensionConstraints_KnownCertificateExtension_value           = src.CertificateExtensionConstraints_KnownCertificateExtension_value
	CertificateRevocationList_State_name                                      = src.CertificateRevocationList_State_name
	CertificateRevocationList_State_value                                     = src.CertificateRevocationList_State_value
	File_google_cloud_security_privateca_v1_resources_proto                   = src.File_google_cloud_security_privateca_v1_resources_proto
	File_google_cloud_security_privateca_v1_service_proto                     = src.File_google_cloud_security_privateca_v1_service_proto
	PublicKey_KeyFormat_name                                                  = src.PublicKey_KeyFormat_name
	PublicKey_KeyFormat_value                                                 = src.PublicKey_KeyFormat_value
	RevocationReason_name                                                     = src.RevocationReason_name
	RevocationReason_value                                                    = src.RevocationReason_value
	SubjectRequestMode_name                                                   = src.SubjectRequestMode_name
	SubjectRequestMode_value                                                  = src.SubjectRequestMode_value
)

// Request message for
// [CertificateAuthorityService.ActivateCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.ActivateCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ActivateCertificateAuthorityRequest = src.ActivateCertificateAuthorityRequest

// A [CaPool][google.cloud.security.privateca.v1.CaPool] represents a group of
// [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority]
// that form a trust anchor. A
// [CaPool][google.cloud.security.privateca.v1.CaPool] can be used to manage
// issuance policies for one or more
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// resources and to rotate CA certificates in and out of the trust anchor.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool = src.CaPool

// Defines controls over all certificate issuance within a
// [CaPool][google.cloud.security.privateca.v1.CaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool_IssuancePolicy = src.CaPool_IssuancePolicy

// Describes a "type" of key that may be used in a
// [Certificate][google.cloud.security.privateca.v1.Certificate] issued from a
// [CaPool][google.cloud.security.privateca.v1.CaPool]. Note that a single
// [AllowedKeyType][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType]
// may refer to either a fully-qualified key algorithm, such as RSA 4096, or a
// family of key algorithms, such as any RSA key.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool_IssuancePolicy_AllowedKeyType = src.CaPool_IssuancePolicy_AllowedKeyType

// Describes an Elliptic Curve key that may be used in a
// [Certificate][google.cloud.security.privateca.v1.Certificate] issued from a
// [CaPool][google.cloud.security.privateca.v1.CaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool_IssuancePolicy_AllowedKeyType_EcKeyType = src.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType

// Describes an elliptic curve-based signature algorithm that may be used in a
// [Certificate][google.cloud.security.privateca.v1.Certificate] issued from a
// [CaPool][google.cloud.security.privateca.v1.CaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm = src.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm
type CaPool_IssuancePolicy_AllowedKeyType_EllipticCurve = src.CaPool_IssuancePolicy_AllowedKeyType_EllipticCurve
type CaPool_IssuancePolicy_AllowedKeyType_Rsa = src.CaPool_IssuancePolicy_AllowedKeyType_Rsa

// Describes an RSA key that may be used in a
// [Certificate][google.cloud.security.privateca.v1.Certificate] issued from a
// [CaPool][google.cloud.security.privateca.v1.CaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType = src.CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType

// [IssuanceModes][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.IssuanceModes]
// specifies the allowed ways in which
// [Certificates][google.cloud.security.privateca.v1.Certificate] may be
// requested from this [CaPool][google.cloud.security.privateca.v1.CaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool_IssuancePolicy_IssuanceModes = src.CaPool_IssuancePolicy_IssuanceModes

// Options relating to the publication of each
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
// CA certificate and CRLs and their inclusion as extensions in issued
// [Certificates][google.cloud.security.privateca.v1.Certificate]. The options
// set here apply to certificates issued by any
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// in the [CaPool][google.cloud.security.privateca.v1.CaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool_PublishingOptions = src.CaPool_PublishingOptions

// The tier of a [CaPool][google.cloud.security.privateca.v1.CaPool],
// indicating its supported functionality and/or billing SKU.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CaPool_Tier = src.CaPool_Tier

// A [Certificate][google.cloud.security.privateca.v1.Certificate] corresponds
// to a signed X.509 certificate issued by a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type Certificate = src.Certificate

// A
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// represents an individual Certificate Authority. A
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// can be used to create
// [Certificates][google.cloud.security.privateca.v1.Certificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateAuthority = src.CertificateAuthority

// CertificateAuthorityServiceClient is the client API for
// CertificateAuthorityService service. For semantics around ctx use and
// closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateAuthorityServiceClient = src.CertificateAuthorityServiceClient

// CertificateAuthorityServiceServer is the server API for
// CertificateAuthorityService service.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateAuthorityServiceServer = src.CertificateAuthorityServiceServer

// URLs where a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// will publish content.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateAuthority_AccessUrls = src.CertificateAuthority_AccessUrls

// A Cloud KMS key configuration that a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// will use.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateAuthority_KeyVersionSpec = src.CertificateAuthority_KeyVersionSpec
type CertificateAuthority_KeyVersionSpec_Algorithm = src.CertificateAuthority_KeyVersionSpec_Algorithm
type CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion = src.CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion

// The algorithm of a Cloud KMS CryptoKeyVersion of a
// [CryptoKey][google.cloud.kms.v1.CryptoKey] with the
// [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose] value
// `ASYMMETRIC_SIGN`. These values correspond to the
// [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
// values. For RSA signing algorithms, the PSS algorithms should be preferred,
// use PKCS1 algorithms if required for compatibility. For further
// recommendations, see
// https://cloud.google.com/kms/docs/algorithms#algorithm_recommendations.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateAuthority_SignHashAlgorithm = src.CertificateAuthority_SignHashAlgorithm

// The state of a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority],
// indicating if it can be used.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateAuthority_State = src.CertificateAuthority_State

// The type of a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority],
// indicating its issuing chain.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateAuthority_Type = src.CertificateAuthority_Type

// A [CertificateConfig][google.cloud.security.privateca.v1.CertificateConfig]
// describes an X.509 certificate or CSR that is to be created, as an
// alternative to using ASN.1.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateConfig = src.CertificateConfig

// These values are used to create the distinguished name and subject
// alternative name fields in an X.509 certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateConfig_SubjectConfig = src.CertificateConfig_SubjectConfig

// A
// [CertificateDescription][google.cloud.security.privateca.v1.CertificateDescription]
// describes an X.509 certificate or CSR that has been issued, as an
// alternative to using ASN.1 / X.509.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateDescription = src.CertificateDescription

// A group of fingerprints for the x509 certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateDescription_CertificateFingerprint = src.CertificateDescription_CertificateFingerprint

// A KeyId identifies a specific public key, usually by hashing the public
// key.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateDescription_KeyId = src.CertificateDescription_KeyId

// These values describe fields in an issued X.509 certificate such as the
// distinguished name, subject alternative names, serial number, and lifetime.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateDescription_SubjectDescription = src.CertificateDescription_SubjectDescription

// Describes a set of X.509 extensions that may be part of some certificate
// issuance controls.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateExtensionConstraints = src.CertificateExtensionConstraints

// Describes well-known X.509 extensions that can appear in a
// [Certificate][google.cloud.security.privateca.v1.Certificate], not including
// the [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames]
// extension.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateExtensionConstraints_KnownCertificateExtension = src.CertificateExtensionConstraints_KnownCertificateExtension

// Describes constraints on a
// [Certificate][google.cloud.security.privateca.v1.Certificate]'s
// [Subject][google.cloud.security.privateca.v1.Subject] and
// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateIdentityConstraints = src.CertificateIdentityConstraints

// A
// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
// corresponds to a signed X.509 certificate Revocation List (CRL). A CRL
// contains the serial numbers of certificates that should no longer be
// trusted.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateRevocationList = src.CertificateRevocationList

// Describes a revoked
// [Certificate][google.cloud.security.privateca.v1.Certificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateRevocationList_RevokedCertificate = src.CertificateRevocationList_RevokedCertificate

// The state of a
// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList],
// indicating if it is current.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateRevocationList_State = src.CertificateRevocationList_State

// A
// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
// refers to a managed template for certificate issuance.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CertificateTemplate = src.CertificateTemplate
type Certificate_Config = src.Certificate_Config
type Certificate_PemCsr = src.Certificate_PemCsr

// Describes fields that are relavent to the revocation of a
// [Certificate][google.cloud.security.privateca.v1.Certificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type Certificate_RevocationDetails = src.Certificate_RevocationDetails

// Request message for
// [CertificateAuthorityService.CreateCaPool][google.cloud.security.privateca.v1.CertificateAuthorityService.CreateCaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CreateCaPoolRequest = src.CreateCaPoolRequest

// Request message for
// [CertificateAuthorityService.CreateCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.CreateCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CreateCertificateAuthorityRequest = src.CreateCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.CreateCertificate][google.cloud.security.privateca.v1.CertificateAuthorityService.CreateCertificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CreateCertificateRequest = src.CreateCertificateRequest

// Request message for
// [CertificateAuthorityService.CreateCertificateTemplate][google.cloud.security.privateca.v1.CertificateAuthorityService.CreateCertificateTemplate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type CreateCertificateTemplateRequest = src.CreateCertificateTemplateRequest

// Request message for
// [CertificateAuthorityService.DeleteCaPool][google.cloud.security.privateca.v1.CertificateAuthorityService.DeleteCaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type DeleteCaPoolRequest = src.DeleteCaPoolRequest

// Request message for
// [CertificateAuthorityService.DeleteCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.DeleteCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type DeleteCertificateAuthorityRequest = src.DeleteCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.DeleteCertificateTemplate][google.cloud.security.privateca.v1.CertificateAuthorityService.DeleteCertificateTemplate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type DeleteCertificateTemplateRequest = src.DeleteCertificateTemplateRequest

// Request message for
// [CertificateAuthorityService.DisableCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.DisableCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type DisableCertificateAuthorityRequest = src.DisableCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.EnableCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.EnableCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type EnableCertificateAuthorityRequest = src.EnableCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.FetchCaCerts][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCaCerts].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type FetchCaCertsRequest = src.FetchCaCertsRequest

// Response message for
// [CertificateAuthorityService.FetchCaCerts][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCaCerts].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type FetchCaCertsResponse = src.FetchCaCertsResponse
type FetchCaCertsResponse_CertChain = src.FetchCaCertsResponse_CertChain

// Request message for
// [CertificateAuthorityService.FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCertificateAuthorityCsr].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type FetchCertificateAuthorityCsrRequest = src.FetchCertificateAuthorityCsrRequest

// Response message for
// [CertificateAuthorityService.FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCertificateAuthorityCsr].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type FetchCertificateAuthorityCsrResponse = src.FetchCertificateAuthorityCsrResponse

// Request message for
// [CertificateAuthorityService.GetCaPool][google.cloud.security.privateca.v1.CertificateAuthorityService.GetCaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type GetCaPoolRequest = src.GetCaPoolRequest

// Request message for
// [CertificateAuthorityService.GetCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.GetCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type GetCertificateAuthorityRequest = src.GetCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.GetCertificate][google.cloud.security.privateca.v1.CertificateAuthorityService.GetCertificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type GetCertificateRequest = src.GetCertificateRequest

// Request message for
// [CertificateAuthorityService.GetCertificateRevocationList][google.cloud.security.privateca.v1.CertificateAuthorityService.GetCertificateRevocationList].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type GetCertificateRevocationListRequest = src.GetCertificateRevocationListRequest

// Request message for
// [CertificateAuthorityService.GetCertificateTemplate][google.cloud.security.privateca.v1.CertificateAuthorityService.GetCertificateTemplate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type GetCertificateTemplateRequest = src.GetCertificateTemplateRequest

// A [KeyUsage][google.cloud.security.privateca.v1.KeyUsage] describes key
// usage values that may appear in an X.509 certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type KeyUsage = src.KeyUsage

// [KeyUsage.ExtendedKeyUsageOptions][google.cloud.security.privateca.v1.KeyUsage.ExtendedKeyUsageOptions]
// has fields that correspond to certain common OIDs that could be specified
// as an extended key usage value.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type KeyUsage_ExtendedKeyUsageOptions = src.KeyUsage_ExtendedKeyUsageOptions

// [KeyUsage.KeyUsageOptions][google.cloud.security.privateca.v1.KeyUsage.KeyUsageOptions]
// corresponds to the key usage values described in
// https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type KeyUsage_KeyUsageOptions = src.KeyUsage_KeyUsageOptions

// Request message for
// [CertificateAuthorityService.ListCaPools][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCaPools].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCaPoolsRequest = src.ListCaPoolsRequest

// Response message for
// [CertificateAuthorityService.ListCaPools][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCaPools].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCaPoolsResponse = src.ListCaPoolsResponse

// Request message for
// [CertificateAuthorityService.ListCertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCertificateAuthorities].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCertificateAuthoritiesRequest = src.ListCertificateAuthoritiesRequest

// Response message for
// [CertificateAuthorityService.ListCertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCertificateAuthorities].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCertificateAuthoritiesResponse = src.ListCertificateAuthoritiesResponse

// Request message for
// [CertificateAuthorityService.ListCertificateRevocationLists][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCertificateRevocationLists].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCertificateRevocationListsRequest = src.ListCertificateRevocationListsRequest

// Response message for
// [CertificateAuthorityService.ListCertificateRevocationLists][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCertificateRevocationLists].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCertificateRevocationListsResponse = src.ListCertificateRevocationListsResponse

// Request message for
// [CertificateAuthorityService.ListCertificateTemplates][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCertificateTemplates].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCertificateTemplatesRequest = src.ListCertificateTemplatesRequest

// Response message for
// [CertificateAuthorityService.ListCertificateTemplates][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCertificateTemplates].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCertificateTemplatesResponse = src.ListCertificateTemplatesResponse

// Request message for
// [CertificateAuthorityService.ListCertificates][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCertificates].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCertificatesRequest = src.ListCertificatesRequest

// Response message for
// [CertificateAuthorityService.ListCertificates][google.cloud.security.privateca.v1.CertificateAuthorityService.ListCertificates].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ListCertificatesResponse = src.ListCertificatesResponse

// An [ObjectId][google.cloud.security.privateca.v1.ObjectId] specifies an
// object identifier (OID). These provide context and describe types in ASN.1
// messages.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type ObjectId = src.ObjectId

// Represents the metadata of the long-running operation.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type OperationMetadata = src.OperationMetadata

// A [PublicKey][google.cloud.security.privateca.v1.PublicKey] describes a
// public key.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type PublicKey = src.PublicKey

// Types of public keys formats that are supported. Currently, only `PEM`
// format is supported.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type PublicKey_KeyFormat = src.PublicKey_KeyFormat

// A [RevocationReason][google.cloud.security.privateca.v1.RevocationReason]
// indicates whether a
// [Certificate][google.cloud.security.privateca.v1.Certificate] has been
// revoked, and the reason for revocation. These correspond to standard
// revocation reasons from RFC 5280. Note that the enum labels and values in
// this definition are not the same ASN.1 values defined in RFC 5280. These
// values will be translated to the correct ASN.1 values when a CRL is created.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type RevocationReason = src.RevocationReason

// Request message for
// [CertificateAuthorityService.RevokeCertificate][google.cloud.security.privateca.v1.CertificateAuthorityService.RevokeCertificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type RevokeCertificateRequest = src.RevokeCertificateRequest

// [Subject][google.cloud.security.privateca.v1.Subject] describes parts of a
// distinguished name that, in turn, describes the subject of the certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type Subject = src.Subject

// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames]
// corresponds to a more modern way of listing what the asserted identity is in
// a certificate (i.e., compared to the "common name" in the distinguished
// name).
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type SubjectAltNames = src.SubjectAltNames

// Describes the way in which a
// [Certificate][google.cloud.security.privateca.v1.Certificate]'s
// [Subject][google.cloud.security.privateca.v1.Subject] and/or
// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames] will
// be resolved.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type SubjectRequestMode = src.SubjectRequestMode

// Describes a subordinate CA's issuers. This is either a resource name to a
// known issuing
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority],
// or a PEM issuer certificate chain.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type SubordinateConfig = src.SubordinateConfig
type SubordinateConfig_CertificateAuthority = src.SubordinateConfig_CertificateAuthority
type SubordinateConfig_PemIssuerChain = src.SubordinateConfig_PemIssuerChain

// This message describes a subordinate CA's issuer certificate chain. This
// wrapper exists for compatibility reasons.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type SubordinateConfig_SubordinateConfigChain = src.SubordinateConfig_SubordinateConfigChain

// Request message for
// [CertificateAuthorityService.UndeleteCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.UndeleteCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type UndeleteCertificateAuthorityRequest = src.UndeleteCertificateAuthorityRequest

// UnimplementedCertificateAuthorityServiceServer can be embedded to have
// forward compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type UnimplementedCertificateAuthorityServiceServer = src.UnimplementedCertificateAuthorityServiceServer

// Request message for
// [CertificateAuthorityService.UpdateCaPool][google.cloud.security.privateca.v1.CertificateAuthorityService.UpdateCaPool].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type UpdateCaPoolRequest = src.UpdateCaPoolRequest

// Request message for
// [CertificateAuthorityService.UpdateCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.UpdateCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type UpdateCertificateAuthorityRequest = src.UpdateCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.UpdateCertificate][google.cloud.security.privateca.v1.CertificateAuthorityService.UpdateCertificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type UpdateCertificateRequest = src.UpdateCertificateRequest

// Request message for
// [CertificateAuthorityService.UpdateCertificateRevocationList][google.cloud.security.privateca.v1.CertificateAuthorityService.UpdateCertificateRevocationList].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type UpdateCertificateRevocationListRequest = src.UpdateCertificateRevocationListRequest

// Request message for
// [CertificateAuthorityService.UpdateCertificateTemplate][google.cloud.security.privateca.v1.CertificateAuthorityService.UpdateCertificateTemplate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type UpdateCertificateTemplateRequest = src.UpdateCertificateTemplateRequest

// An [X509Extension][google.cloud.security.privateca.v1.X509Extension]
// specifies an X.509 extension, which may be used in different parts of X.509
// objects like certificates, CSRs, and CRLs.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type X509Extension = src.X509Extension

// An [X509Parameters][google.cloud.security.privateca.v1.X509Parameters] is
// used to describe certain fields of an X.509 certificate, such as the key
// usage fields, fields specific to CA certificates, certificate policy
// extensions and custom extensions.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type X509Parameters = src.X509Parameters

// Describes values that are relevant in a CA certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1/privatecapb
type X509Parameters_CaOptions = src.X509Parameters_CaOptions

// Deprecated: Please use funcs in: cloud.google.com/go/security/privateca/apiv1/privatecapb
func NewCertificateAuthorityServiceClient(cc grpc.ClientConnInterface) CertificateAuthorityServiceClient {
	return src.NewCertificateAuthorityServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/security/privateca/apiv1/privatecapb
func RegisterCertificateAuthorityServiceServer(s *grpc.Server, srv CertificateAuthorityServiceServer) {
	src.RegisterCertificateAuthorityServiceServer(s, srv)
}
