#pragma once
/*
 *  $Id: serializable.h 28435 2025-08-22 11:38:30Z yeti-dn $
 *  Copyright (C) 2009-2025 David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
/*< private_header >*/

#ifndef __GWY_SERIALIZABLE_INTERNAL_H__
#define __GWY_SERIALIZABLE_INTERNAL_H__

#include <libgwyddion/serializable.h>

G_BEGIN_DECLS

#define GWY_SERIALIZE_SIZE_DEFAULT GWY_SERIALIZE_SIZE_64BIT

struct _GwySerializableGroup {
    const gchar *name;
    /* NB: This is the total size, including the name and size field itself. In GWY files, where the two are excluded
     * from the size field. */
    gsize size_bytes;

    gsize len;
    gsize n;
    GwySerializableItem *items;

    /* Direct member objects we need to call done() on when done. */
    gsize lenobjects;
    gsize nobjects;
    GwySerializable **objects;
};

G_GNUC_UNUSED
static void
ensure_group_size(GwySerializableGroup *group, gsize len)
{
    if (group->len >= len)
        return;

    gsize old_len = group->len;
    group->len = MAX(2*group->len, len);
    group->items = g_renew(GwySerializableItem, group->items, group->len);
    gwy_clear(group->items + old_len, group->len - old_len);
}

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */

