clean_entry= function(text, element) {
  var _out = []
  var _data = $.trim(text).split(',');
  var y=0;
  for (var j=0; j<_data.length; j++){
    if ($.trim(_data[j]) == element) {
      continue;
    }
    _out[y] = $.trim(_data[j]);
    y+=1;
  }
  return _out;
}

add_tags = function(data, _issues_url) {
  console.log('adding ' + data.added_tags);

  var $select = $('#tag').selectize();
  if ($select.length) {
    var selectize = $select[0].selectize;
  }

  var field = $('#taglist');
  for (i=0; i<data.added_tags.length; i++ ){
    tag = data.added_tags[i];
    var obj = document.createElement('a');
    $(obj).attr('id', 'tag-' + tag);
    $(obj).attr('title', '');
    $(obj).addClass('badge badge-secondary badge-tag text-left my-1 p-2 ');
    $(obj).attr('href', _issues_url + '?tags=' + tag);
    $(obj).attr('data-bg-color', data.added_tags_color[i]);
    $(obj).text(tag);

    field.append(obj);
    $(obj).css('background-color', $(obj).attr('data-bg-color'));
    if ($select.length) {
      selectize.createItem(tag);
    }
  }
}

remove_tags = function(data, _issues_url) {
  console.log('removing ' + data.removed_tags);

  var $select = $('#tag').selectize();
  if ($select.length) {
    var selectize = $select[0].selectize;
  }

  for (var i=0; i<data.removed_tags.length; i++ ){
    tag = data.removed_tags[i]
    if ($select.length) {
      selectize.removeItem(tag);
    }
    $('#tag-' + tag).remove();
  }
}

assigne_issue = function(data, _issues_url) {
  console.log('assigning ' + data.assigned.name);
  var field = $('#assignee_plain');
  var _url = '\n<a href="'
        + _issues_url + '?assignee=' + data.assigned.name + '">'
        + data.assigned.name + '</a>';
  field.html(_url);

  var $select = $('#assignee').selectize();
  var selectize = $select[0].selectize;
  selectize.settings.create = true;
  selectize.createItem(data.assigned.name);
  selectize.settings.create = false;
  $('#assignee').val(data.assigned.name);
}

unassigne_issue = function(data) {
  console.log('un-assigning ');

  var field = $('#assignee_plain');
  var _html = '<div class="text-muted">None';
  if ( data.comment_user == username) {
  _html = _html + ' — <a id="take-btn" title="assign this issue to you">Take</a>'
  }
  _html = _html + '</div>';
  field.html(_html);

  var $select = $('#assignee').selectize();
  var selectize = $select[0].selectize;
  selectize.setValue(null);
}

add_deps = function(data, issue_uid, _issue_url) {
  console.log('adding ' + data.added_dependency);

  var dep = data.added_dependency;
  if (data.issue_uid == issue_uid){
    if (data.type == "children"){
      var $select = $('#blocks').selectize();
      var field = $('#blocklist');
      var _id = 'block';
    } else {
      var $select = $('#depends').selectize();
      var field = $('#dependlist');
      var _id = 'depend';
    }
  }

  var html = '\n<a id="' + _id + '-' + dep + '" class="label label-default" href="'
               + _issue_url.replace('/-123456789', '/' + dep) + '">#' + dep + '</a>';

  field.append(html);

  var selectize = $select[0].selectize;
  selectize.settings.create = true;
  selectize.items.push(String(dep));
  selectize.createItem(String(dep));
  selectize.settings.create = false;

  var input_field = $('#' + _id + 's');
  input_field.val(selectize.items.join(','));
}

remove_deps = function(data, issue_uid, _issue_url) {
  console.log('Removing ' + data.removed_dependency);
  if (data.issue_uid == issue_uid){
    if (data.type == "children"){
      var $select = $('#depends').selectize();
      var _id = 'depend';
    } else {
      var $select = $('#blocks').selectize();
      var _id = 'block';
    }
  }

  var selectize = $select[0].selectize;

  var dep = data.removed_dependency;
  $('#' + _id + '-' + dep).remove();
  selectize.removeItem(dep);
}

add_comment = function(data, username) {
  console.log('Adding comment ' + data.comment_added);
  var field = $('#comments');
  if (data.notification){
    var _data = '<div class="d-flex align-items-center px-3 py-2 mb-3">'
                  +'<div class="">'
                  + '<img src="'+data.avatar_url+'"/>'
                  +'</div>'
                  +'<span class="font-size-09 autogenerated-comment pl-4">'
                  + data.comment_added
                  +'</span>'
                  +'<div class="text-muted ml-auto">'
                   + '<span title="'+data.comment_date+'">'
                   + 'seconds ago</span>'
                  +'</div>'
                +'</div>'
  } else {
    var _data = '<div class="card mb-4 clearfix">'
    + '  <div id="comment-' + data.comment_id + '" class="card-header bg-light d-flex align-items-center px-3 py-2">'
    + '    <div>'
    + '        <img class="avatar circle" src="' + data.avatar_url + '"/>'
    + '        <a href="/user/' + data.comment_user + '"'
    + '            class="notblue font-weight-bold">'+data.comment_user+'</a>'
    + '        <a class="notblue" title="Permalink to this headline"'
    + '           href="#comment-' + data.comment_id + '">'
    + '          <span>commented seconds ago</span>'
    + '        </a>'
    + '    </div>'
    + '    <div class="issue_actions ml-auto">'
    + '        <div class="issue_action icon">'
    + '          <div class="btn-group" role="group" aria-label="Basic example">'
    + '              <button class="reply btn btn-outline-primary border-0" type="button"'
    + '                  data-comment="' + data.comment_id + '"'
    + '                  title="Reply to this comment">'
    + '                <span class="fa fa-reply" title="Reply to this comment"></span>'
    + '              </a>';
    if ( data.comment_user == username) {

      _data = _data+ '<a class="btn btn-outline-primary border-0 edit_btn"'
      + '                href="/' + data.project + '/issue/' + data.issue_id + '/comment/' + data.comment_id + '/edit"'
      + '                data-comment="'+data.comment_id+'" data-objid="'+data.issue_id+'">'
      + '              <i class="fa fa-pencil"  title="Edit comment"></i>'
      + '            </a>'
      + '            <button class="btn btn-outline-primary border-0 delete_comment_btn" type="submit"'
      + '                name="drop_comment" value="'+data.comment_id+'"'
      + '                title="Remove comment">'
      + '              <i class="fa fa-trash"></i>'
      + '            </button>'
    }

    _data = _data + '          </div>'
    + '        </div>'
    + '      </div>'
    + '  </div>'
    + '  <div class="card-body pb-1">'
    + '    <section class="issue_comment">'
    + '      <div>'
    + '        <span class="edit_date" title="">'
    + '        </span>'
    + '        <span class="comment_text comment_body">'
    + emojione.toImage(data.comment_added)
    + '        </span>'
    + '      </div>'
    + '    </section>'
    + '  </div>'
    + '  <div class="card-footer bg-transparent d-flex align-items-center border-0 p-0">'
    + '  </div>'
    + '</div>'
  }

  field.html(field.html() + _data);
}

update_comment = function(data) {
  console.log('Updating comment ' + data.comment_id);
  var field = $('#comment-' + data.comment_id).parent();
  var edited = field.find('.text-muted');
  if (edited.length == 0) {
    $(field.find('aside')).before(
        '<small class="text-muted">Edited a just now by '
        + data.comment_editor + '</small>');
  } else {
    edited.html('Edited a just now by ' + data.comment_editor)
  }
  field.find('.comment_body').html(data.comment_updated);
  field.find('.issue_actions').show();
  field.find('.issue_comment').show();
}

update_issue = function(data, _roadmap_url) {
  console.log('Adjusting issue ' + data.fields);
  for (i=0; i<data.fields.length; i++){
    var _f = data.fields[i];
    if (_f == 'status' || _f == 'close_status') {
      var field = $('#status');
      var html = '';
      if (data.issue.close_status == 'Invalid'){
          html = '<span class="label label-danger">Closed</span> <small>as: Invalid</small>';
      } else if (data.issue.close_status == 'Fixed'){
          html = '<span class="label label-success">Closed</span> <small>as: Fixed</small>';
      } else if (data.issue.close_status == 'Insufficient Data'){
          html = '<span class="label label-warning">Closed</span> <small>as: Insufficient Data</small>';
      } else if (data.issue.close_status == 'Duplicate'){
          html = '<span class="label label-default">Closed</span> <small>as: Duplicate</small>';
      } else if (data.issue.status == 'Open'){
          html = '<span class="label label-primary">Open</span>';
      } else {
          html = '<span class="label label-info">' + data.issue.status
            + '</span>';
        if (data.issue.close_status) {
          html += '<small>as: ' + data.issue.close_status + '</small>';
        }
      }
      field.html(html);
    } else if (_f == 'title'){
      var field = $('#issuetitle');
      field.html(data.issue.title);
    } else if (_f == 'priority'){
      var field = $('#priority_plain');
      if (data.issue.priority != null){
        field.html(data.priorities[data.issue.priority]);
      } else {
          field.html('');
      }
    } else if (_f == 'content'){
      var field = $('#comment-0').parent().find('.comment_body');
      field.html('<p>' + data.content_updated + '</p>');
    } else if (_f == 'milestone'){
      var field = $('#milestone_plain');
      var _url = _roadmap_url.replace('-123456789', data.issue.milestone);
      field.html(
        '<a href="' + _url + '">' + data.issue.milestone + '</a>')
    }
  }
}

update_custom_fields = function(data) {
  console.log('Adjusting custom fields ' + data.custom_fields);
  for (i=0; i<data.custom_fields.length; i++){
    var _f = data.custom_fields[i];
    var _f2 = _f.replace(/ /g, '_');
    var field = $('#' +  _f2);
    var _val = null;
    for (j=0; j<data.issue.custom_fields.length; j++) {
      if (data.issue.custom_fields[j].name == _f){
        if (data.issue.custom_fields[j].key_type == 'boolean'){
          _val = data.issue.custom_fields[j].value == 'on';
        } else {
          _val = data.issue.custom_fields[j].value;
        }
        break;
      }
    }
    if (_val == null) {
      console.log('No corresponding custom field/value found');
      return
    }
    if (field.length){
      if (_val == true || _val == false) {
        field[0].checked = _val;
      } else {
        field.val(_val);
      }
    }

    var field = $('#' +  _f2 + '_plain');
    field.html(_val);
  }
}

private_issue = function(data, _api_issue_url, issue_uid) {
  if (data.comment_id){
    var _url = _api_issue_url.replace('-123456789', issue_uid)
      + '/comment/' + data.comment_id;
    $.get( _url )
      .done(function(data) {
        add_comment({
          comment_added: data.comment,
          comment_id: data.id,
          comment_user: data.user.name,
          comment_date: data.comment_date,
          avatar_url: data.avatar_url,
        });
      })
  } else if (data.fields) {
    var _url = _api_issue_url.replace('-1', issue_uid) + '?comments=0';
    $.get( _url )
      .done(function(ndata) {
        update_issue({
          fields: data.fields,
          issue: {
            status: ndata.status,
            title: ndata.title,
            content: ndata.content,
          }
        });
      })
  }
}

private_issue_update = function(data, _api_issue_url, issue_uid) {
  var _url = _api_issue_url.replace('-1', issue_uid)
    + '/comment/' + data.comment_id;
  $.get( _url )
    .done(function(data) {
      update_comment({
        comment_updated: data.comment,
        comment_id: data.id,
        comment_user: data.user.name,
        comment_editor: data.comment_date,
      });
    })
}

process_event = function(
      data, issue_uid, _issue_url, _issues_url, _api_issue_url,
      _roadmap_url, username)
{
  console.log(data);
  var category = null;
  var originalTitle = document.title;
  if (data.issue == 'private'){
    console.log('private issue');
    private_issue(data, _api_issue_url, issue_uid)
  }
  else if (data.comment_updated == 'private'){
    console.log('private issue updated');
    private_issue_update(data, _api_issue_url, issue_uid)
  }
  else if (data.added_tags){
    add_tags(data, _issues_url);
    category = 'Tag added';
  }
  else if (data.removed_tags){
    remove_tags(data, _issues_url);
    category = 'Tag removed';
  }
  else if (data.assigned){
    assigne_issue(data, _issues_url);
    category = 'Issue assigned';
  }
  else if (data.unassigned){
    unassigne_issue(data);
    category = 'Issue un-assigned';
  }
  else if (data.added_dependency){
    add_deps(data, issue_uid, _issue_url);
    category = 'Dependency added';
  }
  else if (data.removed_dependency){
    remove_deps(data, issue_uid, _issue_url);
    category = 'Dependency removed';
  }
  else if (data.comment_added){
    add_comment(data, username);
    category = 'Comment added';
  }
  else if (data.comment_updated){
    update_comment(data);
    category = 'Comment updated';
  }
  else if (data.custom_fields){
    update_custom_fields(data);
    category = 'Custom fields edited';
  }
  else if (data.fields){
    update_issue(data, _roadmap_url);
    category = 'Issue edited';
  } else {
    console.log('Unknown data');
  }

  if (category && !document.hasFocus()) {
    var int = setInterval(function(){
      var title = document.title;
      document.title = (title === originalTitle) ? category : originalTitle;
    }, 750);

    $(window).focus(function () {
      clearInterval(int);
      document.title = originalTitle;
    });
  }
}
