/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.AParentFolderRegular;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLineNumbered;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.Preprocessor;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.utils.StartUtils;

public final class BlockUmlBuilder
implements DefinitionsContainer {
    private final List<BlockUml> blocks = new ArrayList<BlockUml>();
    private Set<FileWithSuffix> usedFiles = new HashSet<FileWithSuffix>();
    private final UncommentReadLine reader;
    private final Defines defines;
    private final ImportedFiles importedFiles;
    private final String charset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader readerInit, SFile newCurrentDir, String desc) throws IOException {
        Closeable includer = null;
        this.defines = defines;
        this.charset = charset;
        try {
            this.reader = new UncommentReadLine(ReadLineReader.create(readerInit, desc));
            this.importedFiles = ImportedFiles.createImportedFiles(new AParentFolderRegular(newCurrentDir));
            includer = new Preprocessor(config, this.reader);
            this.init((ReadLineNumbered)includer);
        }
        finally {
            if (includer != null) {
                includer.close();
            }
            readerInit.close();
        }
    }

    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader reader) throws IOException {
        this(config, charset, defines, reader, null, null);
    }

    private void init(ReadLineNumbered includer) throws IOException {
        StringLocated s = null;
        ArrayList<StringLocated> current = null;
        boolean paused = false;
        while ((s = includer.readLine()) != null) {
            StringLocated append;
            if (StartUtils.isArobaseStartDiagram(s.getString())) {
                current = new ArrayList<StringLocated>();
                paused = false;
            }
            if (StartUtils.isArobasePauseDiagram(s.getString())) {
                paused = true;
                this.reader.setPaused(true);
            }
            if (StartUtils.isExit(s.getString())) {
                paused = true;
                this.reader.setPaused(true);
            }
            if (current != null && !paused) {
                current.add(s);
            } else if (paused && (append = StartUtils.getPossibleAppend(s)) != null) {
                current.add(append);
            }
            if (StartUtils.isArobaseUnpauseDiagram(s.getString())) {
                paused = false;
                this.reader.setPaused(false);
            }
            if (!StartUtils.isArobaseEndDiagram(s.getString()) || current == null) continue;
            if (paused) {
                current.add(s);
            }
            BlockUml uml = new BlockUml(current, this.defines.cloneMe(), null, this);
            this.usedFiles.addAll(uml.getIncluded());
            this.blocks.add(uml);
            current = null;
            this.reader.setPaused(false);
        }
    }

    public List<BlockUml> getBlockUmls() {
        return Collections.unmodifiableList(this.blocks);
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return Collections.unmodifiableSet(this.usedFiles);
    }

    @Override
    public List<String> getDefinition(String name) {
        for (BlockUml block : this.blocks) {
            if (!block.isStartDef(name)) continue;
            return block.getDefinition(false);
        }
        return Collections.emptyList();
    }

    @Override
    public final ImportedFiles getImportedFiles() {
        return this.importedFiles;
    }

    @Override
    public final String getCharset() {
        return this.charset;
    }
}

