/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.api.NumberAnalyzed;

public class NumberAnalyzedDated
extends NumberAnalyzed {
    private final AtomicLong created = new AtomicLong();
    private final AtomicLong modified = new AtomicLong();
    private String comment;

    private NumberAnalyzedDated(String name, long nb, long sum, long min, long max, long sumOfSquare, long sliddingSum, long created, long modified, String comment) {
        super(name, nb, sum, min, max, sumOfSquare, sliddingSum);
        this.created.set(created);
        this.modified.set(modified);
        this.comment = comment;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.resetCreatedModifiedComment();
    }

    public NumberAnalyzedDated() {
        this.resetCreatedModifiedComment();
    }

    public NumberAnalyzedDated(String name) {
        super(name);
        this.resetCreatedModifiedComment();
    }

    private void resetCreatedModifiedComment() {
        long now = System.currentTimeMillis();
        this.created.set(now);
        this.modified.set(now);
        this.comment = " ";
    }

    @Override
    public void addValue(long v) {
        super.addValue(v);
        this.modified.set(System.currentTimeMillis());
    }

    @Override
    public void add(NumberAnalyzed other) {
        super.add(other);
        this.modified.set(System.currentTimeMillis());
    }

    @Override
    protected String getSavedSupplementatyData() {
        return this.longToString(this.created.get()) + ";" + this.longToString(this.modified.get()) + ";" + this.comment;
    }

    public static NumberAnalyzedDated load(String name, Preferences prefs) {
        String value = prefs.get(name + ".saved", "");
        if (value.length() == 0) {
            Log.info("Cannot load " + name);
            return null;
        }
        try {
            StringTokenizer st = new StringTokenizer(value, ";");
            return new NumberAnalyzedDated(name, Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), st.nextToken());
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.info("Error reading " + value);
            return null;
        }
    }

    public final long getCreationTime() {
        return this.created.get();
    }

    public final long getModificationTime() {
        return this.modified.get();
    }

    public final synchronized String getComment() {
        return this.comment;
    }

    public final synchronized void setComment(String comment) {
        this.comment = comment;
    }
}

