/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.core;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.ComponentStyle;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class NServer {
    private final Map<Network, String> connections = new LinkedHashMap<Network, String>();
    private USymbol shape = USymbol.RECTANGLE;
    private final String name;
    private String description;
    private final NBar bar = new NBar();

    public void connect(Network network, Map<String, String> props) {
        String address = props.get("address");
        if (address == null) {
            address = "";
        }
        if (address.length() == 0 && this.connections.containsKey(network)) {
            return;
        }
        this.connections.put(network, address);
        this.bar.addStage(network.getNstage());
    }

    public final String toString() {
        return this.name;
    }

    public NServer(String name) {
        this.description = name;
        this.name = name;
    }

    protected final FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getName() {
        return this.name;
    }

    public final void setShape(String shapeName) {
        USymbol shapeFromString = USymbol.fromString(shapeName, ActorStyle.STICKMAN, ComponentStyle.RECTANGLE, PackageStyle.RECTANGLE);
        if (shapeFromString != null) {
            this.shape = shapeFromString;
        }
    }

    public final USymbol getShape() {
        return this.shape;
    }

    public final NBar getBar() {
        return this.bar;
    }
}

