/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.legacy;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.nwdiag.VerticalLine;
import net.sourceforge.plantuml.nwdiag.legacy.NServerLegacy;
import net.sourceforge.plantuml.nwdiag.legacy.NetworkLegacy;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.MathUtils;

public class LinkedElement {
    private final TextBlock box;
    private final NetworkLegacy network;
    private final NServerLegacy square;
    private final Map<NetworkLegacy, TextBlock> conns;
    private final List<NetworkLegacy> networks;
    private final double marginAd = 10.0;
    private final double marginBox = 15.0;

    public LinkedElement(NServerLegacy square, TextBlock box, Map<NetworkLegacy, TextBlock> conns, List<NetworkLegacy> networks) {
        this.networks = networks;
        this.box = box;
        this.network = square.getMainNetwork();
        this.square = square;
        this.conns = conns;
    }

    public boolean isLinkedTo(NetworkLegacy some) {
        return this.conns.containsKey(some);
    }

    public MinMax getMinMax(StringBounder stringBounder, double width, double height) {
        double xMiddle = width / 2.0;
        double yMiddle = height / 2.0;
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        double x1 = xMiddle - dimBox.getWidth() / 2.0;
        double y1 = yMiddle - dimBox.getHeight() / 2.0;
        double x2 = xMiddle + dimBox.getWidth() / 2.0;
        double y2 = yMiddle + dimBox.getHeight() / 2.0;
        return MinMax.getEmpty(false).addPoint(x1 - 5.0, y1 - 5.0).addPoint(x2 + 5.0, y2 + 5.0);
    }

    public void drawMe(UGraphic ug, double width, double height) {
        double xMiddle = width / 2.0;
        double yMiddle = height / 2.0;
        this.drawCenter(ug, this.box, xMiddle, yMiddle);
    }

    public void drawLinks(UGraphic ug, double xstart, double width, double height) {
        ug = ug.apply(UTranslate.dx(xstart));
        double ynet1 = this.network.getY();
        double yMiddle = height / 2.0;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        double alpha = yMiddle - dimBox.getHeight() / 2.0;
        HColor color = ColorParam.activityBorder.getDefaultValue();
        ug = ug.apply(color);
        double xMiddle = width / 2.0;
        TreeSet<Double> skip = new TreeSet<Double>();
        for (NetworkLegacy n : this.networks) {
            if (!(xstart + xMiddle > n.getXmin()) || !(xstart + xMiddle < n.getXmax())) continue;
            skip.add(n.getY());
        }
        if (this.square.hasItsOwnColumn()) {
            if (this.square.getMainNetwork().isVisible()) {
                new VerticalLine(ynet1 + 5.0, ynet1 + alpha, skip).drawU(ug.apply(UTranslate.dx(xMiddle)));
            } else {
                new VerticalLine(ynet1, ynet1 + alpha, Collections.emptySet()).drawU(ug.apply(UTranslate.dx(xMiddle)));
            }
        }
        this.drawCenter(ug, this.link1(), xMiddle, ynet1 + alpha / 2.0);
        double seven = 7.0;
        double x = xMiddle - (double)(this.conns.size() - 2) * 7.0 / 2.0;
        boolean first = true;
        for (Map.Entry<NetworkLegacy, TextBlock> ent : this.conns.entrySet()) {
            if (ent.getKey() == this.network) continue;
            double ynet2 = ent.getKey().getY();
            new VerticalLine(ynet1 + yMiddle + dimBox.getHeight() / 2.0, ynet2, skip).drawU(ug.apply(UTranslate.dx(x)));
            double xtext = first && this.conns.size() > 2 ? x - ent.getValue().calculateDimension(stringBounder).getWidth() / 2.0 : x;
            this.drawCenter(ug, ent.getValue(), xtext, ynet2 - alpha / 2.0);
            x += 7.0;
            first = false;
        }
    }

    private TextBlock link1() {
        return this.conns.get(this.network);
    }

    private TextBlock link2() {
        int i = this.networks.indexOf(this.network);
        if (i == this.networks.size() - 1) {
            return null;
        }
        return this.conns.get(this.networks.get(i + 1));
    }

    private void drawCenter(UGraphic ug, TextBlock block, double x, double y) {
        if (block == null) {
            return;
        }
        Dimension2D dim = block.calculateDimension(ug.getStringBounder());
        block.drawU(ug.apply(new UTranslate(x - dim.getWidth() / 2.0, y - dim.getHeight() / 2.0)));
    }

    public Dimension2D naturalDimension(StringBounder stringBounder) {
        Dimension2D dim1 = this.link1() == null ? new Dimension2DDouble(0.0, 0.0) : this.link1().calculateDimension(stringBounder);
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        Dimension2D dim2 = this.link2() == null ? new Dimension2DDouble(0.0, 0.0) : this.link2().calculateDimension(stringBounder);
        double width = MathUtils.max(dim1.getWidth() + 20.0, dimBox.getWidth() + 30.0, dim2.getWidth() + 20.0);
        double height = dim1.getHeight() + 20.0 + dimBox.getHeight() + 30.0 + dim2.getHeight() + 20.0;
        return new Dimension2DDouble(width, height);
    }

    public final NetworkLegacy getNetwork() {
        return this.network;
    }

    public final NServerLegacy getElement() {
        return this.square;
    }
}

