/* 
 * Copyright (c) 2010 Wind River Systems; see
 * guts/COPYRIGHT for information.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 *
 * static int
 * wrap_mkstemp64(char *template, int oflags) {
 *	int rc = -1;
 */
	struct stat64 buf;
 	int save_errno;
	size_t len;
	char *tmp_template;

	if (!template) {
		errno = EFAULT;
		return 0;
	}

	len = strlen(template);
	tmp_template = PSEUDO_ROOT_PATH(AT_FDCWD, template, AT_SYMLINK_NOFOLLOW);

	if (!tmp_template) {
		errno = ENOENT;
		return -1;
	}

	/* mkstemp64 wrapper uses this code and mkostemp64 not present in some glibc versions */
	if (oflags == 0)
		rc = real_mkstemp64(tmp_template);
	else
		rc = real_mkostemp64(tmp_template, oflags);

	if (rc != -1) {
		save_errno = errno;

		if (real___fxstat64(_STAT_VER, rc, &buf) != -1) {
			real_fchmod(rc, PSEUDO_FS_MODE(0600, 0));
			pseudo_client_op(OP_CREAT, 0, -1, -1, tmp_template, &buf);
			pseudo_client_op(OP_OPEN, PSA_READ | PSA_WRITE, rc, -1, tmp_template, &buf);
		} else {
			pseudo_debug(PDBGF_CONSISTENCY, "mkstemp (fd %d) succeeded, but fstat failed (%s).\n",
				rc, strerror(errno));
			pseudo_client_op(OP_OPEN, PSA_READ | PSA_WRITE, rc, -1, tmp_template, 0);
		}
		errno = save_errno;
	}
	/* mkstemp only changes the XXXXXX at the end. */
	memcpy(template + len - 6, tmp_template + strlen(tmp_template) - 6, 6);
/*	return rc;
 * }
 */
