
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2455197.5,
          {-0.2506,0.00063,9.3396,0.03893,9.9e-05,0.0492}, /*cmx*/
          {-3.81001,-2.2156,-1.0325,-2.6168}, /*cfx*/
          {0.0267,-0.00069,3.1658,0.02811,0.00026,0.0184}, /*cmy*/
          {-2.092824,-4.8325,-2.9905,-1.7378}, /*cfy*/
          {-0.0426,0.0035,8.8338,0.04465,0.000224,0.0631}, /*cmz*/
          {-2.257369,-0.8899,-5.8418,-1.3633} /*cfz*/
     },
     {
          2455247.5,
          {-0.186,0.00128,9.304,0.01788,0.000788,0.0648}, /*cmx*/
          {-4.921926,-3.2443,-0.1541,-5.8041}, /*cfx*/
          {-0.0121,0.00079,2.5147,0.01587,0.000392,0.0196}, /*cmy*/
          {-3.836929,-5.1989,-2.3247,-5.0025}, /*cfy*/
          {0.1133,0.00114,9.0893,0.02063,0.000849,0.0721}, /*cmz*/
          {-3.320532,-1.9627,-5.0671,-4.1644} /*cfz*/
     },
     {
          2455297.5,
          {-0.1389,0.00019,9.3529,0.0579,0.000378,0.0718}, /*cmx*/
          {-0.080321,-1.5925,-2.6799,-2.9787}, /*cfx*/
          {0.0304,0.0009,2.7577,0.02362,0.000235,0.0258}, /*cmy*/
          {-5.101322,-3.8754,-5.359,-1.2617}, /*cfy*/
          {0.1798,-0.00073,9.0016,0.06533,0.000474,0.062}, /*cmz*/
          {-4.76028,-0.0973,-1.1419,-1.4746} /*cfz*/
     },
     {
          2455347.5,
          {-0.1313,5e-05,9.2626,0.07673,0.00054,0.0717}, /*cmx*/
          {-1.775355,-3.3872,-4.8945,-0.2032}, /*cfx*/
          {0.0841,0.00101,3.8325,0.03459,0.000417,0.0372}, /*cmy*/
          {-6.184452,-6.0251,-1.6349,-4.3261}, /*cfy*/
          {0.1229,0.0004,8.644,0.09925,0.000562,0.061}, /*cmz*/
          {-0.255221,-1.8844,-3.5037,-5.1042} /*cfz*/
     },
     {
          2455397.5,
          {-0.1224,0.00019,8.6295,0.09361,0.000625,0.0647}, /*cmx*/
          {-3.554141,-5.2669,-0.6181,-3.7469}, /*cfx*/
          {0.1257,2e-05,5.3776,0.0455,0.00049,0.0446}, /*cmy*/
          {-1.363151,-2.1747,-4.0463,-1.3891}, /*cfy*/
          {0.1454,-0.00141,8.4588,0.1152,0.000624,0.0614}, /*cmz*/
          {-2.179123,-3.7547,-5.6049,-2.5005} /*cfz*/
     },
     {
          2455447.5,
          {-0.1111,-0.00115,7.779,0.11266,0.000652,0.0528}, /*cmx*/
          {-5.463704,-0.8848,-2.4759,-1.2887}, /*cfx*/
          {0.1436,7e-05,6.2375,0.05912,0.000545,0.0447}, /*cmy*/
          {-3.040741,-4.5381,-0.3542,-4.8303}, /*cfy*/
          {0.0901,-0.00034,8.7858,0.11907,0.000674,0.0636}, /*cmz*/
          {-4.159445,-5.6768,-1.2685,-6.2128} /*cfz*/
     },
     {
          2455497.5,
          {-0.1908,-1e-05,7.5937,0.13496,0.000896,0.0601}, /*cmx*/
          {-1.279063,-2.7496,-4.629,-5.3739}, /*cfx*/
          {0.1272,-0.00095,5.7463,0.05857,0.000701,0.0344}, /*cmy*/
          {-4.782109,-0.711,-2.9222,-2.0585}, /*cfy*/
          {0.0508,-0.00046,9.2708,0.11749,0.000788,0.0688}, /*cmz*/
          {-6.126701,-1.3684,-3.1584,-3.6387} /*cfz*/
     },
     {
          2455547.5,
          {-0.1701,-0.00087,8.6817,0.13754,0.001107,0.0732}, /*cmx*/
          {-3.395098,-4.7756,-0.6732,-2.7788}, /*cfx*/
          {0.0916,-0.00186,3.6199,0.06033,0.000661,0.021}, /*cmy*/
          {-0.014157,-3.5603,-5.7352,-4.8431}, /*cfy*/
          {0.0347,-0.00194,9.3233,0.12261,0.000926,0.0682}, /*cmz*/
          {-1.794966,-3.3964,-5.1603,-1.0061} /*cfz*/
     },
     {
          2455597.5,
          {-0.2247,0.00072,9.4012,0.11861,0.000831,0.0742}, /*cmx*/
          {-5.358061,-0.7089,-2.7715,-0.0581}, /*cfx*/
          {0.0011,-0.00054,2.9929,0.0572,0.000669,0.0306}, /*cmy*/
          {-0.608046,-6.2805,-2.2394,-1.2214}, /*cfy*/
          {-0.0491,-0.00029,8.8724,0.13611,0.000914,0.0622}, /*cmz*/
          {-3.796403,-5.4598,-1.0428,-4.7052} /*cfz*/
     },
     {
          2455647.5,
          {-0.1941,0.00117,8.7879,0.11278,0.000616,0.06}, /*cmx*/
          {-0.988712,-2.7951,-4.5239,-3.7059}, /*cfx*/
          {-0.0437,6e-05,5.2179,0.05521,0.000585,0.0411}, /*cmy*/
          {-1.931367,-2.7706,-4.7796,-4.6689}, /*cfy*/
          {-0.0883,-0.00173,8.5194,0.13715,0.000801,0.0599}, /*cmz*/
          {-5.886495,-1.2048,-3.1676,-2.358} /*cfz*/
     },
     {
          2455697.5,
          {-0.1167,0.00022,7.7729,0.12265,0.000634,0.0527}, /*cmx*/
          {-2.997473,-4.7026,-0.1655,-1.2837}, /*cfx*/
          {-0.0161,-0.0003,6.1821,0.06081,0.000618,0.0431}, /*cmy*/
          {-3.662781,-5.2498,-1.225,-1.9181}, /*cfy*/
          {-0.1654,-0.00052,8.8026,0.12354,0.000802,0.0711}, /*cmz*/
          {-1.675313,-3.1521,-5.1355,-6.1867} /*cfz*/
     },
     {
          2455747.5,
          {-0.1118,0.00179,7.7765,0.12688,0.000691,0.0588}, /*cmx*/
          {-5.117206,-0.3033,-2.4396,-5.0328}, /*cfx*/
          {-0.0469,-0.0001,5.3968,0.05089,0.000621,0.0338}, /*cmy*/
          {-5.3728,-1.5468,-3.783,-5.2104}, /*cfy*/
          {-0.1856,-0.00011,9.2686,0.11292,0.000782,0.0758}, /*cmz*/
          {-3.626735,-5.1287,-0.9153,-3.4689} /*cfz*/
     },
     {
          2455797.5,
          {-0.0317,-0.00041,8.8519,0.10262,0.000595,0.0669}, /*cmx*/
          {-0.835074,-2.257,-4.5519,-2.3554}, /*cfx*/
          {-0.0401,-0.00047,3.4265,0.0489,0.000405,0.0212}, /*cmy*/
          {-0.443731,-4.2673,-0.1343,-1.6469}, /*cfy*/
          {-0.202,-0.0002,9.3043,0.10393,0.00055,0.0732}, /*cmz*/
          {-5.494141,-0.8815,-3.0132,-0.6869} /*cfz*/
     },
     {
          2455847.5,
          {-0.0378,0.00026,9.393,0.07354,0.00037,0.0674}, /*cmx*/
          {-2.634027,-4.2425,-0.2591,-5.7727}, /*cfx*/
          {-0.0744,-0.00018,3.0825,0.04014,0.000263,0.0272}, /*cmy*/
          {-1.134305,-0.2675,-2.6759,-4.0245}, /*cfy*/
          {-0.2069,0.0005,8.8979,0.09158,0.000344,0.0646}, /*cmz*/
          {-1.049311,-2.7915,-5.1953,-4.2429} /*cfz*/
     },
     {
          2455897.5,
          {-0.0298,-0.00065,9.1056,0.05397,0.000436,0.0711}, /*cmx*/
          {-4.294556,-6.0801,-2.7611,-2.847}, /*cfx*/
          {-0.0837,0.00026,4.4607,0.02501,0.000237,0.0402}, /*cmy*/
          {-2.262607,-2.3105,-5.4314,-0.6247}, /*cfy*/
          {-0.1721,-0.00048,8.561,0.07195,0.000607,0.0613}, /*cmz*/
          {-2.834135,-4.5117,-1.3402,-1.4249} /*cfz*/
     },
     {
          2455947.5,
          {-0.0543,-0.0021,8.7188,0.00455,0.00056,0.0596}, /*cmx*/
          {-5.798,-5.1069,-4.2613,-5.7418}, /*cfx*/
          {-0.0764,0.00139,5.1149,0.0104,0.000264,0.0322}, /*cmy*/
          {-3.597191,-1.8391,-0.1769,-3.6686}, /*cfy*/
          {-0.2095,0.00085,8.5258,0.00502,0.000741,0.0576}, /*cmz*/
          {-4.405233,-3.6212,-2.6709,-4.6321} /*cfz*/
     },
     {
          2455997.5,
          {-0.1618,-0.00117,9.0594,0.04773,0.000844,0.0684}, /*cmx*/
          {-0.678721,-5.5055,-2.3245,-2.4444}, /*cfx*/
          {-0.0085,0.00069,4.4391,0.02288,0.000401,0.0314}, /*cmy*/
          {-4.849812,-1.4714,-4.9512,-0.4324}, /*cfy*/
          {-0.127,0.00155,8.6319,0.06049,0.001037,0.064}, /*cmz*/
          {-5.507136,-3.8963,-0.7848,-0.9745} /*cfz*/
     },
     {
          2456047.5,
          {-0.226,0.00045,9.1423,0.03593,0.000524,0.0737}, /*cmx*/
          {-1.974214,-3.5126,-4.3066,-5.8179}, /*cfx*/
          {0.033,0.00081,4.3138,0.01762,0.000268,0.0433}, /*cmy*/
          {-6.268203,-0.1625,-1.2458,-3.6196}, /*cfy*/
          {-0.0695,0.00089,8.5654,0.048,0.00052,0.0608}, /*cmz*/
          {-0.497023,-2.1043,-2.7096,-4.3088} /*cfz*/
     },
     {
          2456097.5,
          {-0.187,9e-05,8.6813,0.07852,0.000572,0.0659}, /*cmx*/
          {-3.61106,-5.2938,-0.4843,-2.9864}, /*cfx*/
          {0.0619,0.0005,5.3826,0.0394,0.000445,0.0487}, /*cmy*/
          {-1.458317,-2.1604,-3.9573,-0.6518}, /*cfy*/
          {-0.0222,-0.00149,8.375,0.09445,0.000541,0.061}, /*cmz*/
          {-2.240423,-3.7956,-5.2611,-1.5857} /*cfz*/
     },
     {
          2456147.5,
          {-0.1799,0.00044,7.8745,0.10676,0.000618,0.056}, /*cmx*/
          {-5.445352,-0.8974,-2.4689,-0.3623}, /*cfx*/
          {0.0977,0.00017,6.2891,0.05723,0.000524,0.0514}, /*cmy*/
          {-3.086424,-4.471,-0.2476,-4.0524}, /*cfy*/
          {-0.0851,0.0,8.6141,0.11412,0.000687,0.0623}, /*cmz*/
          {-4.164315,-5.6483,-1.1749,-5.2878} /*cfz*/
     },
     {
          2456197.5,
          {-0.1826,0.00101,7.4668,0.13322,0.000801,0.0515}, /*cmx*/
          {-1.226465,-2.7695,-4.5762,-4.3963}, /*cfx*/
          {0.0954,-0.00049,6.106,0.06092,0.000694,0.0399}, /*cmy*/
          {-4.815842,-0.5733,-2.8072,-1.2689}, /*cfy*/
          {-0.1042,-0.00107,9.166,0.11762,0.000801,0.0683}, /*cmz*/
          {-6.123335,-1.3396,-3.1357,-2.7909} /*cfz*/
     },
     {
          2456247.5,
          {-0.0991,-0.00044,8.4271,0.14119,0.001081,0.0651}, /*cmx*/
          {-3.381379,-4.76,-0.6258,-1.9958}, /*cfx*/
          {0.081,-0.00062,4.2048,0.05985,0.000685,0.0233}, /*cmy*/
          {-0.136953,-3.3818,-5.5219,-4.3129}, /*cfy*/
          {-0.1505,-0.00074,9.3381,0.1217,0.000975,0.0743}, /*cmz*/
          {-1.795031,-3.3664,-5.1048,-0.2318} /*cfz*/
     },
     {
          2456297.5,
          {-0.1376,0.00156,9.3854,0.12176,0.0009,0.07}, /*cmx*/
          {-5.382064,-0.6831,-2.7477,-5.6093}, /*cfx*/
          {0.0512,0.00058,2.7897,0.05885,0.0007,0.0267}, /*cmy*/
          {-0.863268,-6.126,-2.12,-0.5457}, /*cfy*/
          {-0.1765,0.0003,8.9164,0.13849,0.001032,0.0709}, /*cmz*/
          {-3.794067,-5.4322,-1.0319,-3.9182} /*cfz*/
     },
     {
          2456347.5,
          {-0.0654,0.00067,8.9459,0.1146,0.000642,0.0612}, /*cmx*/
          {-1.02187,-2.8208,-4.5959,-2.9377}, /*cfx*/
          {0.0631,0.00012,4.9183,0.0546,0.000607,0.0379}, /*cmy*/
          {-2.008259,-2.6965,-4.7012,-3.8472}, /*cfy*/
          {-0.1801,-0.00089,8.5234,0.14414,0.000898,0.0626}, /*cmz*/
          {-5.886616,-1.2165,-3.2448,-1.4828} /*cfz*/
     },
     {
          2456397.5,
          {-0.012,0.00101,7.8991,0.12087,0.000628,0.0553}, /*cmx*/
          {-3.023488,-4.7599,-0.141,-0.4823}, /*cfx*/
          {0.0994,-0.00043,6.1552,0.06302,0.000593,0.0387}, /*cmy*/
          {-3.729878,-5.2414,-1.1436,-1.1697}, /*cfy*/
          {-0.2181,0.00067,8.7504,0.12998,0.00082,0.0663}, /*cmz*/
          {-1.700735,-3.2085,-5.217,-5.4586} /*cfz*/
     },
     {
          2456447.5,
          {0.0302,0.0021,7.6722,0.12742,0.000732,0.0609}, /*cmx*/
          {-5.148446,-0.3505,-2.3203,-4.2809}, /*cfx*/
          {0.0567,-0.00051,5.6215,0.05541,0.000645,0.0321}, /*cmy*/
          {-5.485833,-1.453,-3.7361,-4.5515}, /*cfy*/
          {-0.1781,-0.00012,9.2208,0.11822,0.000822,0.0743}, /*cmz*/
          {-3.688212,-5.183,-0.9466,-2.8579} /*cfz*/
     },
     {
          2456497.5,
          {0.1277,-0.00018,8.6659,0.11322,0.000727,0.0665}, /*cmx*/
          {-0.912433,-2.3049,-4.5149,-1.6598}, /*cfx*/
          {0.0403,-0.00148,3.6833,0.05035,0.000487,0.0189}, /*cmy*/
          {-0.690714,-4.1968,-0.0653,-1.1614}, /*cfy*/
          {-0.1939,0.00069,9.3514,0.11102,0.000648,0.0746}, /*cmz*/
          {-5.585074,-0.9377,-3.0227,-0.1124} /*cfz*/
     },
     {
          2456547.5,
          {0.1323,0.0007,9.3665,0.08695,0.0005,0.0682}, /*cmx*/
          {-2.77127,-4.3324,-0.1611,-5.1706}, /*cfx*/
          {-0.0401,-0.00119,2.7992,0.04488,0.000367,0.026}, /*cmy*/
          {-1.418492,-0.3537,-2.5554,-3.4755}, /*cfy*/
          {-0.1584,0.00078,9.0177,0.10201,0.000419,0.0675}, /*cmz*/
          {-1.176142,-2.9074,-4.9173,-3.6655} /*cfz*/
     },
     {
          2456597.5,
          {0.1572,-0.00055,9.1165,0.07169,0.000331,0.0661}, /*cmx*/
          {-4.514741,-6.2592,-1.9392,-2.382}, /*cfx*/
          {-0.1015,-0.00063,4.3961,0.03491,0.00029,0.042}, /*cmy*/
          {-2.486407,-2.6221,-4.7989,-0.211}, /*cfy*/
          {-0.1091,0.0,8.5882,0.09244,0.000325,0.0616}, /*cmz*/
          {-3.050928,-4.7203,-0.6112,-0.9634} /*cfz*/
     },
     {
          2456647.5,
          {0.1209,-3e-05,8.4183,0.06801,0.000394,0.0649}, /*cmx*/
          {-6.211203,-1.7525,-4.5421,-5.7887}, /*cfx*/
          {-0.1259,-0.00017,5.6696,0.02843,0.000226,0.0489}, /*cmy*/
          {-3.941565,-4.8528,-1.2964,-3.3564}, /*cfy*/
          {-0.1125,0.00043,8.5235,0.07575,0.000415,0.0658}, /*cmz*/
          {-4.8713,-0.1405,-2.994,-4.3282} /*cfz*/
     },
     {
          2456697.5,
          {0.1285,-0.00146,7.8601,0.03385,0.00087,0.0601}, /*cmx*/
          {-1.551024,-3.3671,-0.1868,-2.6023}, /*cfx*/
          {-0.142,0.00038,6.1264,0.01068,0.000317,0.0489}, /*cmy*/
          {-5.403616,-0.4442,-3.6664,-0.1372}, /*cfy*/
          {-0.1053,-0.00132,8.7417,0.03478,0.0009,0.0672}, /*cmz*/
          {-0.233541,-1.6478,-4.8105,-1.2435} /*cfz*/
     },
     {
          2456747.5,
          {0.0234,-0.00163,7.8853,0.07142,0.000719,0.0652}, /*cmx*/
          {-2.827143,-1.3892,-4.549,-5.5303}, /*cfx*/
          {-0.1095,0.00075,6.1515,0.02551,0.000363,0.0486}, /*cmy*/
          {-0.411406,-4.7614,-1.6598,-3.1191}, /*cfy*/
          {-0.1547,-0.00022,8.7448,0.07193,0.000699,0.0801}, /*cmz*/
          {-1.512121,-5.9854,-2.8942,-3.9589} /*cfz*/
     },
     {
          2456797.5,
          {-0.0447,-0.00105,8.2597,0.01591,0.000692,0.0629}, /*cmx*/
          {-3.939763,-5.1779,-6.0941,-2.3743}, /*cfx*/
          {-0.0807,0.00075,5.9671,0.01439,0.000332,0.0519}, /*cmy*/
          {-1.683364,-2.4557,-3.5142,-0.0284}, /*cfy*/
          {-0.1799,-0.00061,8.4277,0.01658,0.000765,0.0664}, /*cmz*/
          {-2.631547,-4.1346,-4.3838,-0.9175} /*cfz*/
     },
     {
          2456847.5,
          {-0.1037,0.00125,7.8654,0.08195,0.000552,0.0553}, /*cmx*/
          {-5.538267,-0.964,-2.1827,-5.836}, /*cfx*/
          {-0.033,9e-05,6.3681,0.04692,0.000418,0.052}, /*cmy*/
          {-3.205141,-4.5276,-0.1303,-3.3652}, /*cfy*/
          {-0.1926,0.00031,8.495,0.08944,0.000621,0.0668}, /*cmz*/
          {-4.271603,-5.6838,-0.903,-4.4067} /*cfz*/
     },
     {
          2456897.5,
          {-0.0619,0.00117,7.4142,0.12281,0.000699,0.0487}, /*cmx*/
          {-1.20955,-2.7993,-4.4418,-3.3969}, /*cfx*/
          {-0.0309,0.00044,6.3443,0.0592,0.00063,0.0434}, /*cmy*/
          {-4.881183,-0.5163,-2.7412,-0.5023}, /*cfy*/
          {-0.1902,-0.00087,9.0248,0.1129,0.000775,0.0664}, /*cmz*/
          {-6.147123,-1.3254,-3.1339,-1.8999} /*cfz*/
     },
     {
          2456947.5,
          {0.0375,0.00046,8.1515,0.1404,0.000985,0.0586}, /*cmx*/
          {-3.359517,-4.7506,-0.5527,-1.0684}, /*cfx*/
          {-0.0088,0.00092,4.7607,0.0582,0.000697,0.0249}, /*cmy*/
          {-0.238624,-3.2348,-5.3456,-3.6721}, /*cfy*/
          {-0.2357,0.00081,9.3548,0.11975,0.000961,0.0722}, /*cmz*/
          {-1.794322,-3.3473,-5.0945,-5.7419} /*cfz*/
     },
     {
          2456997.5,
          {0.0382,0.00158,9.3016,0.12122,0.000944,0.0658}, /*cmx*/
          {-5.392903,-0.6267,-2.6561,-4.7313}, /*cfx*/
          {0.0418,0.00167,2.8159,0.06083,0.000716,0.0227}, /*cmy*/
          {-1.153581,-5.9756,-1.9764,-6.0565}, /*cfy*/
          {-0.1815,0.00068,8.986,0.13759,0.001074,0.0739}, /*cmz*/
          {-3.77776,-5.4116,-0.9961,-3.1963} /*cfz*/
     },
     {
          2457047.5,
          {0.1133,-0.00044,9.0774,0.11389,0.000718,0.0602}, /*cmx*/
          {-1.03239,-2.7967,-4.5837,-2.07}, /*cfx*/
          {0.1118,0.00019,4.6458,0.05341,0.000649,0.0367}, /*cmy*/
          {-2.099084,-2.5467,-4.5846,-2.9919}, /*cfy*/
          {-0.1619,0.00068,8.4966,0.14939,0.000969,0.0687}, /*cmz*/
          {-5.863753,-1.2092,-3.2816,-0.673} /*cfz*/
     },
     {
          2457097.5,
          {0.108,0.00101,7.998,0.12036,0.000646,0.0547}, /*cmx*/
          {-3.016368,-4.7816,-0.1526,-5.9374}, /*cfx*/
          {0.1511,-0.00011,6.1649,0.0631,0.000573,0.0372}, /*cmy*/
          {-3.777166,-5.1938,-1.0154,-0.2474}, /*cfy*/
          {-0.1267,0.00146,8.6769,0.1365,0.000829,0.0639}, /*cmz*/
          {-1.699722,-3.2376,-5.3091,-4.5757} /*cfz*/
     },
     {
          2457147.5,
          {0.1482,0.00107,7.5276,0.12755,0.000754,0.0621}, /*cmx*/
          {-5.143253,-0.3738,-2.2399,-3.5438}, /*cfx*/
          {0.1171,-0.00049,5.9121,0.05861,0.000633,0.0326}, /*cmy*/
          {-5.552235,-1.3592,-3.6369,-3.7452}, /*cfy*/
          {-0.0426,-0.0001,9.1907,0.12128,0.000804,0.0677}, /*cmz*/
          {-3.718756,-5.2263,-0.9648,-2.1219} /*cfz*/
     },
     {
          2457197.5,
          {0.1962,-0.00012,8.4158,0.12082,0.000842,0.0697}, /*cmx*/
          {-0.949654,-2.309,-4.476,-0.9248}, /*cfx*/
          {0.1044,-0.00157,4.103,0.05125,0.000525,0.0188}, /*cmy*/
          {-0.855293,-4.0655,-6.2342,-0.5034}, /*cfy*/
          {-0.0589,0.00133,9.3756,0.11403,0.000691,0.0697}, /*cmz*/
          {-5.639199,-0.9679,-3.0,-5.7302} /*cfz*/
     },
     {
          2457247.5,
          {0.2037,0.00059,9.3057,0.09805,0.000625,0.0709}, /*cmx*/
          {-2.853033,-4.3714,-0.2407,-4.4611}, /*cfx*/
          {0.023,-0.0011,2.6367,0.04698,0.000425,0.0235}, /*cmy*/
          {-1.724082,-0.3149,-2.5112,-2.9013}, /*cfy*/
          {0.0059,0.00036,9.1156,0.10757,0.0005,0.0663}, /*cmz*/
          {-1.249036,-2.96,-4.8975,-3.0095} /*cfz*/
     },
     {
          2457297.5,
          {0.2239,-0.00094,9.2098,0.08192,0.000414,0.0648}, /*cmx*/
          {-4.641413,-0.0805,-1.9355,-1.7497}, /*cfx*/
          {-0.0395,-0.00054,4.0508,0.03915,0.000382,0.0396}, /*cmy*/
          {-2.655857,-2.7025,-4.7711,-5.9734}, /*cfy*/
          {0.0356,0.00065,8.6778,0.10083,0.000403,0.0638}, /*cmz*/
          {-3.15623,-4.8321,-0.3717,-0.3366} /*cfz*/
     },
     {
          2457347.5,
          {0.1734,0.00011,8.471,0.08111,0.000349,0.0593}, /*cmx*/
          {-0.122741,-1.9063,-3.7003,-5.2836}, /*cfx*/
          {-0.0567,-0.00051,5.5581,0.0384,0.000334,0.048}, /*cmy*/
          {-4.140087,-5.0533,-0.8774,-2.9196}, /*cfy*/
          {0.0628,0.00101,8.5263,0.09342,0.000411,0.0664}, /*cmz*/
          {-5.056726,-0.3105,-2.2573,-3.876} /*cfz*/
     },
     {
          2457397.5,
          {0.1841,-0.00081,7.7517,0.08406,0.000286,0.0563}, /*cmx*/
          {-1.929922,-3.6737,-6.1282,-2.4654}, /*cfx*/
          {-0.0916,-3e-05,6.1424,0.03598,0.000272,0.0493}, /*cmy*/
          {-5.726985,-1.0329,-3.4984,-6.1391}, /*cfy*/
          {0.1071,-0.00024,8.8327,0.08425,0.000428,0.0703}, /*cmz*/
          {-0.602851,-2.0679,-4.4877,-0.9977} /*cfz*/
     },
     {
          2457447.5,
          {0.1574,0.0005,7.5805,0.06924,0.000669,0.0518}, /*cmx*/
          {-3.739119,-5.3271,-2.144,-5.7532}, /*cfx*/
          {-0.083,-0.00047,5.8753,0.02382,0.000224,0.046}, /*cmy*/
          {-0.990702,-3.3259,-0.2964,-3.0173}, /*cfy*/
          {0.1167,-0.00049,9.2205,0.06295,0.000616,0.074}, /*cmz*/
          {-2.31051,-3.8839,-0.7011,-4.2718} /*cfz*/
     },
     {
          2457497.5,
          {0.1775,-0.00095,7.6673,0.01869,0.000558,0.0517}, /*cmx*/
          {-5.305763,-3.7285,-3.3319,-2.4291}, /*cfx*/
          {-0.123,-0.00042,5.4751,0.00917,0.000147,0.052}, /*cmy*/
          {-2.410291,-2.4665,-1.5381,-6.1403}, /*cfy*/
          {0.0569,-0.00242,9.2956,0.01666,0.000349,0.0835}, /*cmz*/
          {-3.817061,-2.0589,-2.0037,-0.9287} /*cfz*/
     },
     {
          2457547.5,
          {0.1385,-0.00021,7.4402,0.04251,0.001125,0.0569}, /*cmx*/
          {-0.05734,-4.7392,-1.6188,-5.5044}, /*cfx*/
          {-0.1343,-9e-05,6.1298,0.01526,0.000441,0.0479}, /*cmy*/
          {-3.695867,-3.2185,-5.9295,-2.838}, /*cfy*/
          {-0.0487,-0.001,9.0695,0.03416,0.001011,0.069}, /*cmz*/
          {-4.969476,-3.2793,-0.1814,-4.0252} /*cfz*/
     },
     {
          2457597.5,
          {0.1195,6e-05,7.4308,0.0756,0.000642,0.0478}, /*cmx*/
          {-1.467386,-2.9382,-3.9374,-2.5007}, /*cfx*/
          {-0.1417,0.00102,6.177,0.03735,0.000404,0.0414}, /*cmy*/
          {-5.097042,-0.7469,-2.6341,-6.0606}, /*cfy*/
          {-0.1063,-0.00028,9.0418,0.07107,0.000578,0.069}, /*cmz*/
          {-0.094024,-1.476,-2.7755,-1.1122} /*cfz*/
     },
     {
          2457647.5,
          {0.1615,0.00087,8.0735,0.12531,0.0008,0.0575}, /*cmx*/
          {-3.422072,-4.813,-0.4608,-0.1326}, /*cfx*/
          {-0.101,0.0014,4.8919,0.05168,0.000616,0.0254}, /*cmy*/
          {-0.371138,-3.2803,-5.3116,-2.8667}, /*cfy*/
          {-0.1354,0.00134,9.3618,0.10673,0.000814,0.0659}, /*cmz*/
          {-1.871843,-3.41,-5.0845,-4.8924} /*cfz*/
     },
     {
          2457697.5,
          {0.1832,0.00074,9.1993,0.11579,0.000906,0.0685}, /*cmx*/
          {-5.425158,-0.6056,-2.5742,-3.8397}, /*cfx*/
          {-0.0193,0.00186,2.8922,0.05983,0.000682,0.0235}, /*cmy*/
          {-1.393082,-5.9363,-1.888,-5.2068}, /*cfy*/
          {-0.0461,0.00039,9.0938,0.12923,0.000982,0.0671}, /*cmz*/
          {-3.796827,-5.4432,-0.9586,-2.4256} /*cfz*/
     },
     {
          2457747.5,
          {0.2208,-0.00122,9.167,0.10977,0.000798,0.0645}, /*cmx*/
          {-1.048464,-2.7501,-4.5391,-1.1746}, /*cfx*/
          {0.0637,0.00024,4.3788,0.05305,0.000687,0.0376}, /*cmy*/
          {-2.215378,-2.3994,-4.493,-2.1305}, /*cfy*/
          {-0.0414,0.00187,8.4905,0.14702,0.000949,0.0679}, /*cmz*/
          {-5.848355,-1.2154,-3.2531,-6.2029} /*cfz*/
     },
     {
          2457797.5,
          {0.1698,0.00026,8.1358,0.11943,0.000693,0.0541}, /*cmx*/
          {-2.996027,-4.7757,-0.1976,-4.9775}, /*cfx*/
          {0.0982,0.00041,6.1357,0.06186,0.000576,0.0411}, /*cmy*/
          {-3.830919,-5.1113,-0.8728,-5.5814}, /*cfy*/
          {0.0498,0.00115,8.5553,0.13986,0.000816,0.0665}, /*cmz*/
          {-1.687715,-3.2483,-5.3589,-3.7086} /*cfz*/
     },
     {
          2457847.5,
          {0.1751,-0.00073,7.4089,0.12825,0.000743,0.0582}, /*cmx*/
          {-5.103914,-0.3933,-2.2143,-2.7568}, /*cfx*/
          {0.0876,-0.0002,6.2168,0.06067,0.000615,0.0365}, /*cmy*/
          {-5.602417,-1.2564,-3.5184,-2.8742}, /*cfy*/
          {0.1255,-1e-05,9.1293,0.12251,0.000755,0.0652}, /*cmz*/
          {-3.730891,-5.2503,-0.9695,-1.2409} /*cfz*/
     },
     {
          2457897.5,
          {0.1319,-0.00016,8.1038,0.12654,0.0009,0.0724}, /*cmx*/
          {-0.952918,-2.3006,-4.4413,-0.2197}, /*cfx*/
          {0.0955,-0.0007,4.65,0.05114,0.000542,0.0233}, /*cmy*/
          {-0.968144,-3.912,-6.0624,-6.0476}, /*cfy*/
          {0.1094,0.00129,9.3894,0.11293,0.000698,0.066}, /*cmz*/
          {-5.66887,-0.9773,-2.9081,-4.9035} /*cfz*/
     },
     {
          2457947.5,
          {0.1354,3e-05,9.1866,0.10688,0.000738,0.0756}, /*cmx*/
          {-2.899319,-4.3679,-0.2869,-3.7602}, /*cfx*/
          {0.0581,-9e-05,2.7673,0.0485,0.000452,0.0226}, /*cmy*/
          {-2.034311,-0.2118,-2.4186,-2.3522}, /*cfy*/
          {0.1724,-0.00053,9.1657,0.11003,0.000581,0.0637}, /*cmz*/
          {-1.286408,-2.9681,-4.848,-2.2313} /*cfz*/
     },
     {
          2457997.5,
          {0.1315,-0.00089,9.3124,0.08948,0.000461,0.0679}, /*cmx*/
          {-4.717981,-0.1461,-2.0768,-1.0174}, /*cfx*/
          {0.0414,3e-05,3.7124,0.04103,0.000425,0.0356}, /*cmy*/
          {-2.819333,-2.6706,-4.7624,-5.3529}, /*cfy*/
          {0.1576,0.00073,8.7314,0.10666,0.000488,0.0629}, /*cmz*/
          {-3.208503,-4.8813,-0.3879,-5.9127} /*cfz*/
     },
     {
          2458047.5,
          {0.084,-2e-05,8.6105,0.08647,0.000398,0.0591}, /*cmx*/
          {-0.230661,-2.0213,-3.6107,-4.5873}, /*cfx*/
          {0.058,-0.0004,5.3788,0.04184,0.000398,0.0455}, /*cmy*/
          {-4.268873,-5.1217,-0.8268,-2.3594}, /*cfy*/
          {0.1867,0.00032,8.5265,0.10168,0.000515,0.0677}, /*cmz*/
          {-5.145823,-0.4087,-2.1866,-3.2766} /*cfz*/
     },
     {
          2458097.5,
          {0.0846,-0.00167,7.7888,0.09564,0.000405,0.0544}, /*cmx*/
          {-2.091019,-3.7932,-5.4284,-1.9122}, /*cfx*/
          {0.027,0.00017,6.0978,0.04591,0.000404,0.0461}, /*cmy*/
          {-5.899152,-1.1518,-3.3664,-5.6339}, /*cfy*/
          {0.198,7e-05,8.788,0.10025,0.000586,0.0724}, /*cmz*/
          {-0.761454,-2.2078,-4.2139,-0.5082} /*cfz*/
     },
     {
          2458147.5,
          {0.0066,-0.00024,7.6792,0.10312,0.000426,0.0572}, /*cmx*/
          {-4.049873,-5.5576,-1.2887,-5.5331}, /*cfx*/
          {0.0382,-0.00075,5.657,0.04063,0.000397,0.0389}, /*cmy*/
          {-1.250469,-3.5443,-5.708,-2.5659}, /*cfy*/
          {0.2098,0.00036,9.2439,0.09442,0.0005,0.0739}, /*cmz*/
          {-2.594017,-4.1133,-6.238,-3.9661} /*cfz*/
     },
     {
          2458197.5,
          {-0.0226,-0.00066,8.4644,0.09069,0.000439,0.0637}, /*cmx*/
          {-5.972005,-1.0867,-3.4646,-2.7835}, /*cfx*/
          {-0.0001,-0.00068,4.1106,0.03819,0.000232,0.0255}, /*cmy*/
          {-2.720845,-6.0525,-1.8652,-5.4836}, /*cfy*/
          {0.2241,-0.00052,9.4019,0.0842,0.000341,0.0695}, /*cmz*/
          {-4.375296,-6.0289,-1.9871,-1.1649} /*cfz*/
     },
     {
          2458247.5,
          {-0.0497,0.00067,9.1719,0.06292,0.000548,0.0761}, /*cmx*/
          {-1.438294,-2.9149,-5.9085,-6.1824}, /*cfx*/
          {-0.045,-0.00035,2.7236,0.03246,0.00033,0.02}, /*cmy*/
          {-3.76098,-1.8223,-5.1757,-1.5646}, /*cfy*/
          {0.1824,0.00056,9.2033,0.07196,0.000625,0.065}, /*cmz*/
          {-6.105022,-1.5404,-4.6581,-4.6318} /*cfz*/
     },
     {
          2458297.5,
          {-0.0303,0.00274,9.3318,0.0156,0.000226,0.0624}, /*cmx*/
          {-2.960623,-1.5433,-0.8014,-2.8539}, /*cfx*/
          {-0.0568,0.00072,2.3935,0.02097,0.000264,0.0177}, /*cmy*/
          {-4.775039,-1.0505,-5.4852,-4.5174}, /*cfy*/
          {0.2349,-0.00027,9.0735,0.01329,0.000293,0.061}, /*cmz*/
          {-1.376032,-0.0206,-5.9859,-1.6438} /*cfz*/
     },
     {
          2458347.5,
          {0.1134,0.00104,9.2377,0.00763,0.000831,0.0637}, /*cmx*/
          {-4.160118,-2.6704,-5.7379,-5.9055}, /*cfx*/
          {-0.0446,-0.00033,2.2426,0.00904,0.000449,0.0184}, /*cmy*/
          {-0.261853,-0.7553,-4.8076,-1.8329}, /*cfy*/
          {0.1663,-0.00052,9.2282,0.01258,0.000931,0.0647}, /*cmz*/
          {-2.560219,-1.2501,-4.3415,-4.4243} /*cfz*/
     },
     {
          2458397.5,
          {0.1563,2e-05,9.3342,0.07094,0.000555,0.0758}, /*cmx*/
          {-5.667146,-0.867,-2.2078,-3.1491}, /*cfx*/
          {-0.0492,0.00044,2.6313,0.04047,0.000405,0.0287}, /*cmy*/
          {-1.258962,-0.131,-1.9749,-4.3972}, /*cfy*/
          {0.1746,-0.00075,9.0398,0.08319,0.000653,0.0617}, /*cmz*/
          {-4.065949,-5.7,-0.6677,-1.6834} /*cfz*/
     },
     {
          2458447.5,
          {0.149,-0.00081,9.14,0.09316,0.000723,0.0701}, /*cmx*/
          {-1.148054,-2.7952,-4.453,-0.4053}, /*cfx*/
          {-0.0369,-0.00013,4.3717,0.04831,0.000605,0.0416}, /*cmy*/
          {-2.324522,-2.4917,-4.5161,-1.3309}, /*cfy*/
          {0.1178,0.00151,8.4923,0.12405,0.000738,0.0614}, /*cmz*/
          {-5.950437,-1.3172,-3.137,-5.421} /*cfz*/
     },
     {
          2458497.5,
          {0.1151,-0.00045,8.2526,0.11239,0.000704,0.06}, /*cmx*/
          {-3.019164,-4.7825,-0.2307,-4.0712}, /*cfx*/
          {-0.0289,0.00057,6.069,0.05883,0.000566,0.0472}, /*cmy*/
          {-3.913303,-5.0721,-0.7967,-4.7554}, /*cfy*/
          {0.1908,-0.00012,8.4329,0.13188,0.000736,0.0628}, /*cmz*/
          {-1.715143,-3.2762,-5.3113,-2.896} /*cfz*/
     },
     {
          2458547.5,
          {0.0912,-0.00186,7.4151,0.12604,0.000692,0.0529}, /*cmx*/
          {-5.066046,-0.4247,-2.2272,-1.8421}, /*cfx*/
          {-0.0255,9e-05,6.4174,0.06155,0.000586,0.0422}, /*cmy*/
          {-5.661488,-1.1761,-3.4319,-2.0276}, /*cfy*/
          {0.2065,0.00021,9.0055,0.12032,0.000697,0.0663}, /*cmz*/
          {-3.745914,-5.2602,-0.9517,-0.3737} /*cfz*/
     },
     {
          2458597.5,
          {-0.0167,-0.00024,7.8158,0.12903,0.000856,0.0673}, /*cmx*/
          {-0.929057,-2.3118,-4.4111,-5.7874}, /*cfx*/
          {-0.0004,0.00061,5.1869,0.05015,0.000554,0.0299}, /*cmy*/
          {-1.062668,-3.7438,-5.8899,-5.3835}, /*cfy*/
          {0.1981,0.00058,9.379,0.10917,0.000687,0.0689}, /*cmz*/
          {-5.687117,-0.9697,-2.7966,-4.0428} /*cfz*/
     },
     {
          2458647.5,
          {-0.0169,-0.00072,8.9915,0.11277,0.000799,0.0749}, /*cmx*/
          {-2.920902,-4.3407,-0.2787,-3.0759}, /*cfx*/
          {0.0266,0.00121,3.1495,0.04869,0.000458,0.0224}, /*cmy*/
          {-2.316015,-0.0935,-2.2556,-1.8706}, /*cfy*/
          {0.2277,-0.0012,9.1999,0.10905,0.000671,0.066}, /*cmz*/
          {-1.300505,-2.9424,-4.7528,-1.3724} /*cfz*/
     },
     {
          2458697.5,
          {-0.0554,-0.00017,9.3959,0.09415,0.000512,0.0721}, /*cmx*/
          {-4.763321,-0.1592,-2.1575,-0.2935}, /*cfx*/
          {0.0759,0.0007,3.4191,0.04272,0.000445,0.0319}, /*cmy*/
          {-3.024247,-2.5682,-4.7158,-4.6682}, /*cfy*/
          {0.1781,0.00033,8.7503,0.11166,0.000582,0.0615}, /*cmz*/
          {-3.221873,-4.8876,-0.439,-5.0702} /*cfz*/
     },
     {
          2458747.5,
          {-0.0685,6e-05,8.79,0.08878,0.000408,0.063}, /*cmx*/
          {-0.288787,-2.0995,-3.6304,-3.842}, /*cfx*/
          {0.129,-3e-05,5.1982,0.042,0.000419,0.0418}, /*cmy*/
          {-4.378899,-5.1022,-0.7537,-1.6864}, /*cfy*/
          {0.1864,-0.00089,8.4895,0.10855,0.00057,0.0643}, /*cmz*/
          {-5.181238,-0.4663,-2.2581,-2.5829} /*cfz*/
     },
     {
          2458797.5,
          {-0.0623,-0.00148,7.8459,0.09782,0.000501,0.0555}, /*cmx*/
          {-2.163644,-3.8781,-5.3302,-1.2001}, /*cfx*/
          {0.1128,0.00035,6.1268,0.04917,0.000438,0.0443}, /*cmy*/
          {-6.011212,-1.1826,-3.2816,-4.9954}, /*cfy*/
          {0.1366,-0.00011,8.7137,0.10832,0.000679,0.0717}, /*cmz*/
          {-0.841094,-2.2907,-4.2303,-6.2123} /*cfz*/
     },
     {
          2458847.5,
          {-0.1287,-0.00027,7.5827,0.11566,0.000625,0.0567}, /*cmx*/
          {-4.167883,-5.6556,-1.2288,-4.8624}, /*cfx*/
          {0.1324,-0.00129,5.7953,0.04861,0.000538,0.0374}, /*cmy*/
          {-1.402373,-3.5747,-5.7466,-1.9899}, /*cfy*/
          {0.138,-0.00059,9.2013,0.10781,0.000665,0.074}, /*cmz*/
          {-2.728233,-4.2297,-6.2509,-3.4384} /*cfz*/
     },
     {
          2458897.5,
          {-0.1616,-0.00124,8.4987,0.11352,0.00071,0.0638}, /*cmx*/
          {-6.186181,-1.2808,-3.3831,-2.2974}, /*cfx*/
          {0.0754,-0.00128,4.0377,0.04999,0.000492,0.0243}, /*cmy*/
          {-2.920975,-6.2247,-1.9453,-4.7343}, /*cfy*/
          {0.1124,-0.00105,9.4002,0.10489,0.000586,0.0686}, /*cmz*/
          {-4.587819,-6.2193,-1.765,-0.7064} /*cfz*/
     },
     {
          2458947.5,
          {-0.2137,0.00027,9.3194,0.09369,0.000644,0.071}, /*cmx*/
          {-1.789121,-3.3016,-5.2283,-5.9038}, /*cfx*/
          {-0.0065,-0.00127,2.6691,0.0515,0.000505,0.0308}, /*cmy*/
          {-3.699119,-2.3531,-4.5892,-0.8554}, /*cfy*/
          {0.0444,-0.00029,9.0677,0.10899,0.000562,0.0628}, /*cmz*/
          {-0.188848,-1.8777,-3.648,-4.3479} /*cfz*/
     },
     {
          2458997.5,
          {-0.1948,0.00029,9.0797,0.09052,0.000526,0.0713}, /*cmx*/
          {-3.587679,-5.3056,-1.0563,-3.1047}, /*cfx*/
          {-0.058,-0.00064,4.2693,0.04212,0.000421,0.0426}, /*cmy*/
          {-4.661227,-4.8423,-0.8316,-3.9189}, /*cfy*/
          {0.0396,-0.0017,8.6466,0.11179,0.000505,0.0619}, /*cmz*/
          {-2.12357,-3.7689,-5.9554,-1.6841} /*cfz*/
     },
     {
          2459047.5,
          {-0.2037,0.00048,8.3221,0.08768,0.000726,0.0694}, /*cmx*/
          {-5.374532,-0.9582,-4.0038,-0.2249}, /*cfx*/
          {-0.1045,-0.00054,5.6366,0.03448,0.000303,0.0497}, /*cmy*/
          {-6.164005,-1.0595,-4.0044,-0.8283}, /*cfy*/
          {-0.0387,0.00097,8.7212,0.09195,0.000726,0.0638}, /*cmz*/
          {-4.024833,-5.6003,-2.3118,-5.0718} /*cfz*/
     },
     {
          2459097.5,
          {-0.1486,0.00085,7.7852,0.0064,0.000545,0.0845}, /*cmx*/
          {-0.742017,-4.8745,-5.6981,-3.3488}, /*cfx*/
          {-0.1166,-7e-05,5.9801,0.00094,0.000114,0.0528}, /*cmy*/
          {-1.372844,-3.5555,-6.2446,-3.9217}, /*cfy*/
          {0.0059,0.00123,8.8841,0.00466,0.000564,0.0663}, /*cmz*/
          {-5.675376,-5.0744,-3.6953,-1.9847} /*cfz*/
     },
     {
          2459147.5,
          {-0.1382,0.00104,8.053,0.03572,0.001017,0.0668}, /*cmx*/
          {-1.88417,-0.5992,-3.6947,-0.037}, /*cfx*/
          {-0.1359,-0.00023,6.0001,0.00319,0.0004,0.0494}, /*cmy*/
          {-2.667405,-1.8682,-4.0886,-0.7906}, /*cfy*/
          {0.0806,0.00146,8.6347,0.0278,0.000993,0.063}, /*cmz*/
          {-0.562361,-5.0564,-2.0889,-5.0673} /*cfz*/
     },
     {
          2459197.5,
          {-0.0685,-0.00018,7.9479,0.06635,0.000561,0.0633}, /*cmx*/
          {-3.292336,-4.9267,-6.1027,-3.4284}, /*cfx*/
          {-0.1364,0.00031,6.269,0.03929,0.000376,0.0509}, /*cmy*/
          {-4.126901,-5.3268,-0.7083,-4.1044}, /*cfy*/
          {0.1533,-0.0008,8.4872,0.07393,0.000473,0.0602}, /*cmz*/
          {-2.013015,-3.4892,-4.6271,-2.0982} /*cfz*/
     },
     {
          2455197.5,
          {-0.0062,0.00057,23.362,0.03798,0.001055,0.0082}, /*cmx*/
          {4.139981,5.3888,6.1049,-1.378}, /*cfx*/
          {0.0058,-0.00025,7.949,0.05932,0.00073,0.0036}, /*cmy*/
          {5.905416,3.2247,4.2694,-5.6853}, /*cfy*/
          {0.0027,6e-05,22.1394,0.05497,0.001077,0.0082}, /*cmz*/
          {5.688867,0.7214,1.1416,-2.7077} /*cfz*/
     },
     {
          2455237.5,
          {0.0036,0.0001,23.4028,0.08528,0.002208,0.0018}, /*cmx*/
          {2.349473,4.0698,0.8821,-5.7362}, /*cfx*/
          {0.0006,1e-05,6.2099,0.0802,0.001262,0.0011}, /*cmy*/
          {3.636621,2.0023,4.9831,-5.0882}, /*cfy*/
          {0.0034,-4e-05,22.6961,0.10179,0.002446,0.0028}, /*cmz*/
          {3.94082,5.4375,2.3012,-4.3615} /*cfz*/
     },
     {
          2455277.5,
          {-0.0001,0.00026,23.2326,0.10055,0.001167,0.0026}, /*cmx*/
          {0.434172,5.2605,4.6636,-1.966}, /*cfx*/
          {0.0025,-7e-05,6.574,0.02549,0.000586,0.0015}, /*cmy*/
          {1.531334,2.802,2.3675,-5.4009}, /*cfy*/
          {0.004,-5e-05,22.7012,0.10016,0.001496,0.0044}, /*cmz*/
          {2.03763,0.4701,6.149,-2.7697} /*cfz*/
     },
     {
          2455317.5,
          {0.0061,-0.0001,23.4564,0.18333,0.001148,0.0016}, /*cmx*/
          {4.565164,3.0111,1.5665,-0.9585}, /*cfx*/
          {0.0012,0.0,7.6817,0.07191,0.000784,0.001}, /*cmy*/
          {6.115136,0.5379,5.1388,-2.958}, /*cfy*/
          {0.0025,7e-05,22.1403,0.20968,0.001316,0.003}, /*cmz*/
          {6.138701,4.5005,3.2165,-6.1723} /*cfz*/
     },
     {
          2455357.5,
          {0.004,-4e-05,23.0316,0.21409,0.001352,0.0007}, /*cmx*/
          {2.31913,0.6448,5.3452,-0.3977}, /*cfx*/
          {0.0013,1e-05,10.5691,0.09227,0.001083,0.002}, /*cmy*/
          {4.279892,4.1069,2.3435,-4.8921}, /*cfy*/
          {0.0078,-0.00011,21.395,0.26262,0.001511,0.005}, /*cmz*/
          {3.804359,2.1741,0.6141,-4.3227} /*cfz*/
     },
     {
          2455397.5,
          {0.0003,3e-05,21.6283,0.23984,0.001507,0.001}, /*cmx*/
          {0.016626,4.545,3.0177,-3.991}, /*cfx*/
          {0.0034,-5e-05,13.7277,0.11725,0.001234,0.0022}, /*cmy*/
          {2.205045,1.3275,5.8951,-3.0522}, /*cfy*/
          {0.0047,7e-05,21.0589,0.29153,0.001735,0.0028}, /*cmz*/
          {1.380545,6.0989,4.4105,-2.9626} /*cfz*/
     },
     {
          2455437.5,
          {0.0014,-0.00014,19.6938,0.27728,0.001761,0.0012}, /*cmx*/
          {3.910382,2.1739,0.6857,-3.3399}, /*cfx*/
          {0.0016,8e-05,15.7064,0.14765,0.001364,0.0036}, /*cmy*/
          {6.280818,4.9108,3.0154,-6.2284}, /*cfy*/
          {0.0083,-0.00014,21.5754,0.30787,0.002017,0.0029}, /*cmz*/
          {5.200805,3.7089,1.9203,-5.7122} /*cfz*/
     },
     {
          2455477.5,
          {-0.0064,0.0001,18.4511,0.32744,0.002136,0.0035}, /*cmx*/
          {1.383754,6.0794,4.4496,-1.4247}, /*cfx*/
          {0.0079,-0.0002,15.7244,0.15966,0.001732,0.005}, /*cmy*/
          {4.015815,2.1954,0.0131,-3.7884}, /*cfy*/
          {0.0079,-0.00017,22.6576,0.31712,0.002329,0.0033}, /*cmz*/
          {2.742946,1.2642,5.7029,-4.1093} /*cfz*/
     },
     {
          2455517.5,
          {-0.0019,-0.00019,19.5761,0.36278,0.002673,0.0053}, /*cmx*/
          {5.04617,3.6448,1.6991,-5.388}, /*cfx*/
          {-0.0008,0.00017,13.0746,0.1452,0.001984,0.0044}, /*cmy*/
          {1.789097,5.4833,3.307,-0.5229}, /*cfy*/
          {0.0022,0.0,23.4202,0.32591,0.002551,0.0013}, /*cmz*/
          {0.298749,5.0308,3.2082,-4.4199} /*cfz*/
     },
     {
          2455557.5,
          {-0.0086,0.00015,22.3219,0.34039,0.002891,0.0055}, /*cmx*/
          {2.493348,1.0857,5.3145,-2.5013}, /*cfx*/
          {0.0057,-0.00021,8.3935,0.14722,0.001855,0.0041}, /*cmy*/
          {6.166882,2.2691,0.0893,-3.5615}, /*cfy*/
          {0.005,-0.00029,23.116,0.34321,0.002603,0.0034}, /*cmz*/
          {4.123296,2.4728,0.6929,-3.9199} /*cfz*/
     },
     {
          2455597.5,
          {-0.006,7e-05,23.4654,0.30369,0.002454,0.0025}, /*cmx*/
          {0.048305,4.7204,2.8074,-0.3484}, /*cfx*/
          {-0.003,0.0002,8.3404,0.13782,0.001916,0.0038}, /*cmy*/
          {4.831133,5.4236,3.2582,-0.689}, /*cfy*/
          {-0.0064,0.00012,21.9417,0.36336,0.002547,0.0017}, /*cmz*/
          {1.609472,6.2188,4.4154,-0.5857} /*cfz*/
     },
     {
          2455637.5,
          {-0.0024,1e-05,22.1131,0.30006,0.002068,0.0012}, /*cmx*/
          {3.917865,2.1465,0.4065,-4.6781}, /*cfx*/
          {0.0032,-7e-05,12.8238,0.14066,0.001739,0.0018}, /*cmy*/
          {2.923322,2.2354,0.32,-3.2846}, /*cfy*/
          {-0.0006,-0.00022,21.162,0.36957,0.002504,0.0057}, /*cmz*/
          {5.316448,3.7224,1.8186,-4.8357} /*cfz*/
     },
     {
          2455677.5,
          {-0.0033,0.00022,19.7196,0.31905,0.001973,0.0014}, /*cmx*/
          {1.442972,5.9695,4.2905,-2.0881}, /*cfx*/
          {-0.0026,0.00026,15.5752,0.16419,0.001556,0.0032}, /*cmy*/
          {0.691185,5.581,3.5519,-0.5408}, /*cfy*/
          {-0.0041,-2e-05,21.6916,0.35429,0.002461,0.0047}, /*cmz*/
          {2.743431,1.2388,5.5324,-2.9219} /*cfz*/
     },
     {
          2455717.5,
          {0.0054,-7e-05,18.4583,0.34107,0.002072,0.0007}, /*cmx*/
          {5.136773,3.5602,1.7149,-5.6687}, /*cfx*/
          {0.0069,-0.00019,15.4875,0.15597,0.001658,0.0029}, /*cmy*/
          {4.685356,2.7795,0.536,-3.3872}, /*cfy*/
          {-0.0046,5e-05,22.8555,0.32647,0.002295,0.0028}, /*cmz*/
          {0.240843,5.0204,3.0328,-6.2489} /*cfz*/
     },
     {
          2455757.5,
          {0.0038,0.00011,19.8152,0.33298,0.002215,0.0037}, /*cmx*/
          {2.53159,1.133,5.3356,-1.8015}, /*cfx*/
          {-0.0007,0.00015,12.6406,0.12543,0.001485,0.0037}, /*cmy*/
          {2.481102,6.0748,3.9107,-0.7657}, /*cfy*/
          {0.0001,-7e-05,23.4697,0.30262,0.002014,0.0046}, /*cmz*/
          {4.088907,2.5082,0.5797,-4.3963} /*cfz*/
     },
     {
          2455797.5,
          {0.0055,4e-05,22.2559,0.28582,0.001986,0.0033}, /*cmx*/
          {0.055178,4.9272,2.7833,-5.5023}, /*cfx*/
          {0.0046,-0.00018,8.5164,0.11191,0.001142,0.0033}, /*cmy*/
          {0.581478,3.0298,0.8861,-4.067}, /*cfy*/
          {-0.0015,0.00012,23.1201,0.28699,0.001696,0.002}, /*cmz*/
          {1.685628,0.0293,4.4196,-3.5243} /*cfz*/
     },
     {
          2455837.5,
          {0.0065,-3e-05,23.4501,0.23799,0.001451,0.0038}, /*cmx*/
          {3.986501,2.4167,0.2795,-2.975}, /*cfx*/
          {-0.0013,8e-05,7.5807,0.09414,0.000927,0.002}, /*cmy*/
          {5.410488,0.1434,4.2225,-1.0954}, /*cfy*/
          {0.0059,-0.00014,22.2437,0.27212,0.001376,0.0012}, /*cmz*/
          {5.573668,3.8978,1.8793,-4.9631} /*cfz*/
     },
     {
          2455877.5,
          {0.003,7e-05,23.0901,0.20113,0.001007,0.004}, /*cmx*/
          {1.708635,6.2629,3.8008,-0.9197}, /*cfx*/
          {0.0028,-0.00011,10.2414,0.07397,0.000623,0.0029}, /*cmy*/
          {3.6796,3.5595,1.2632,-4.5667}, /*cfy*/
          {0.0046,0.0,21.5636,0.24343,0.00124,0.0014}, /*cmz*/
          {3.198088,1.5552,5.2956,-3.8384} /*cfz*/
     },
     {
          2455917.5,
          {0.0071,-0.00016,22.0728,0.14708,0.001616,0.0042}, /*cmx*/
          {5.780023,3.986,0.8555,-5.0899}, /*cfx*/
          {-0.0003,4e-05,12.4566,0.05203,0.000746,0.0018}, /*cmy*/
          {1.689555,0.8811,4.3058,-2.882}, /*cfy*/
          {0.0023,0.00013,21.4698,0.17412,0.002092,0.002}, /*cmz*/
          {0.906909,5.5812,2.4419,-4.7684} /*cfz*/
     },
     {
          2455957.5,
          {-0.003,0.00031,21.5716,0.01921,0.00129,0.0034}, /*cmx*/
          {3.715761,4.4198,5.2209,-0.7302}, /*cfx*/
          {0.0051,-0.00022,12.9304,0.02505,0.000535,0.0013}, /*cmy*/
          {5.988184,2.5157,3.1356,-3.8123}, /*cfy*/
          {-0.001,0.00027,21.5978,0.02504,0.001713,0.0063}, /*cmz*/
          {5.108987,0.0499,0.5688,-2.5145} /*cfz*/
     },
     {
          2455997.5,
          {0.0049,-5e-05,22.4308,0.09989,0.001982,0.0035}, /*cmx*/
          {1.912295,3.2527,0.1862,-5.2522}, /*cfx*/
          {0.002,-7e-05,11.2316,0.05956,0.000996,0.0004}, /*cmy*/
          {4.083475,1.2493,3.8779,-3.6623}, /*cfy*/
          {0.0028,8e-05,21.7372,0.13497,0.002533,0.0026}, /*cmz*/
          {3.356627,4.967,1.7881,-5.5649} /*cfz*/
     },
     {
          2456037.5,
          {0.003,6e-05,22.8407,0.07337,0.001331,0.0017}, /*cmx*/
          {0.035036,4.787,4.1899,-4.9893}, /*cfx*/
          {0.0021,-7e-05,10.5341,0.0383,0.000507,0.0006}, /*cmy*/
          {2.072522,1.379,1.3129,-3.9327}, /*cfy*/
          {0.0014,0.00015,21.5758,0.07948,0.001704,0.0046}, /*cmz*/
          {1.508124,6.2028,5.8237,-2.4894} /*cfz*/
     },
     {
          2456077.5,
          {0.0066,-0.00016,22.2988,0.17146,0.001175,0.002}, /*cmx*/
          {4.194755,2.4943,1.3376,-4.1623}, /*cfx*/
          {-0.002,0.00014,12.3505,0.08257,0.000815,0.0025}, /*cmy*/
          {0.034478,5.6504,4.2583,-1.1047}, /*cfy*/
          {0.0021,0.00014,21.1889,0.21058,0.001349,0.0042}, /*cmz*/
          {5.611334,4.0352,2.8228,-0.3597} /*cfz*/
     },
     {
          2456117.5,
          {0.0023,-4e-05,20.8996,0.22572,0.001472,0.0003}, /*cmx*/
          {1.927058,0.1804,5.1079,-4.7932}, /*cfx*/
          {0.0027,-4e-05,14.6443,0.11762,0.001107,0.0015}, /*cmy*/
          {4.187897,3.0891,1.4809,-5.1355}, /*cfy*/
          {0.0076,-8e-05,21.1646,0.27206,0.001626,0.0018}, /*cmz*/
          {3.254651,1.7255,0.1126,-4.6122} /*cfz*/
     },
     {
          2456157.5,
          {-0.0004,-3e-05,19.1653,0.27936,0.001845,0.0028}, /*cmx*/
          {5.813534,4.1225,2.6596,-5.4935}, /*cfx*/
          {-0.0004,0.00016,15.9431,0.1478,0.001378,0.0049}, /*cmy*/
          {1.965069,0.4717,4.8505,-2.0489}, /*cfy*/
          {0.0032,0.00015,21.8751,0.30089,0.001976,0.0029}, /*cmz*/
          {0.826031,5.626,3.8674,-1.7994} /*cfz*/
     },
     {
          2456197.5,
          {0.0033,-0.00033,18.4876,0.34052,0.002269,0.0055}, /*cmx*/
          {3.266458,1.7395,0.0091,-3.6315}, /*cfx*/
          {0.0038,-5e-05,15.26,0.15435,0.001872,0.0044}, /*cmy*/
          {5.983502,4.0268,1.8551,-5.8579}, /*cfy*/
          {0.0081,-0.00014,22.9417,0.31407,0.002343,0.0016}, /*cmz*/
          {4.667139,3.1732,1.3781,-0.4222} /*cfz*/
     },
     {
          2456237.5,
          {-0.0088,0.00017,20.287,0.36815,0.002799,0.0043}, /*cmx*/
          {0.654134,5.5513,3.5238,-0.8812}, /*cfx*/
          {-0.0018,0.00016,11.8262,0.14111,0.002003,0.0047}, /*cmy*/
          {3.794649,0.9387,5.1149,-2.2841}, /*cfy*/
          {0.0014,8e-05,23.4656,0.3275,0.002617,0.0018}, /*cmz*/
          {2.22332,0.6498,5.151,-1.5462} /*cfz*/
     },
     {
          2456277.5,
          {-0.0017,-0.00021,22.902,0.3328,0.002783,0.0052}, /*cmx*/
          {4.412163,2.9497,0.9158,-4.563}, /*cfx*/
          {0.0046,-0.00021,7.3965,0.14444,0.001909,0.0042}, /*cmy*/
          {2.074791,4.0261,1.8638,-5.3955}, /*cfy*/
          {-0.0003,0.0,22.8655,0.3506,0.002695,0.0032}, /*cmz*/
          {6.035016,4.3791,2.5896,-5.7477} /*cfz*/
     },
     {
          2456317.5,
          {-0.0081,0.00016,23.3295,0.30039,0.002301,0.0019}, /*cmx*/
          {1.978432,0.3062,4.7431,-3.8164}, /*cfx*/
          {-0.0027,0.00014,9.3914,0.13274,0.00193,0.0025}, /*cmy*/
          {0.681604,0.8656,5.0894,-2.6874}, /*cfy*/
          {0.0005,-0.00015,21.6637,0.37202,0.002603,0.0042}, /*cmz*/
          {3.501774,1.8454,6.264,-2.7498} /*cfz*/
     },
     {
          2456357.5,
          {-0.0019,-3e-05,21.5047,0.30287,0.002046,0.0007}, /*cmx*/
          {5.836534,4.0563,2.3547,-5.0814}, /*cfx*/
          {0.003,-0.00012,13.7709,0.14594,0.001713,0.0035}, /*cmy*/
          {4.914707,3.9988,2.1322,-4.9331}, /*cfy*/
          {-0.0072,0.00013,21.2075,0.37156,0.002492,0.0052}, /*cmz*/
          {0.91701,5.6274,3.6733,-0.8036} /*cfz*/
     },
     {
          2456397.5,
          {0.002,-7e-05,19.1996,0.32743,0.002023,0.0015}, /*cmx*/
          {3.33303,1.6174,6.1727,-3.8552}, /*cfx*/
          {0.0014,3e-05,15.7812,0.16639,0.001651,0.0031}, /*cmy*/
          {2.646324,1.1415,5.3386,-2.428}, /*cfy*/
          {-0.0021,-0.00012,22.0091,0.34757,0.002382,0.0032}, /*cmz*/
          {4.639294,3.1359,1.1588,-4.9453} /*cfz*/
     },
     {
          2456437.5,
          {-0.0006,0.0002,18.5946,0.34751,0.002132,0.0021}, /*cmx*/
          {0.724557,5.4838,3.5559,-5.7895}, /*cfx*/
          {0.004,-8e-05,14.9378,0.14968,0.001762,0.0045}, /*cmy*/
          {0.36089,4.6072,2.3651,-5.3898}, /*cfy*/
          {-0.0082,0.00021,23.1048,0.31885,0.002234,0.0027}, /*cmz*/
          {2.153177,0.6334,4.978,-2.5504} /*cfz*/
     },
     {
          2456477.5,
          {0.0088,-0.00016,20.5078,0.32832,0.002222,0.0054}, /*cmx*/
          {4.423371,3.0333,0.9451,-4.0536}, /*cfx*/
          {0.0016,0.0,11.4839,0.12306,0.001527,0.0037}, /*cmy*/
          {4.485147,1.5645,5.711,-2.8693}, /*cfy*/
          {-0.0033,5e-05,23.4594,0.30102,0.00204,0.0024}, /*cmz*/
          {6.008191,4.414,2.5291,-0.5002} /*cfz*/
     },
     {
          2456517.5,
          {0.0041,0.0001,22.7889,0.27919,0.001965,0.0019}, /*cmx*/
          {1.972739,0.5236,4.7448,-1.4769}, /*cfx*/
          {0.0006,-1e-05,7.63,0.11414,0.001266,0.0032}, /*cmy*/
          {2.725747,4.8191,2.6625,-6.0443}, /*cfy*/
          {0.0001,0.0,22.908,0.2943,0.001794,0.0005}, /*cmz*/
          {3.5994,1.94,0.0793,-0.6642} /*cfz*/
     },
     {
          2456557.5,
          {0.009,-0.00015,23.4613,0.24163,0.00153,0.004}, /*cmx*/
          {5.907342,4.2918,2.344,-5.2238}, /*cfx*/
          {0.0,0.0,8.2626,0.09953,0.001126,0.0022}, /*cmy*/
          {1.289887,1.8903,6.0623,-2.8846}, /*cfy*/
          {-0.0009,0.00017,21.9816,0.28895,0.001556,0.0009}, /*cmz*/
          {1.182628,5.8009,3.9032,-0.8197} /*cfz*/
     },
     {
          2456597.5,
          {0.0072,-9e-05,22.5545,0.22484,0.001144,0.0034}, /*cmx*/
          {3.602497,1.8522,6.1901,-3.5782}, /*cfx*/
          {-0.0025,0.0001,11.6303,0.09302,0.000888,0.0026}, /*cmy*/
          {5.701882,5.2453,3.2959,-0.6832}, /*cfy*/
          {0.0047,-1e-05,21.3948,0.27408,0.001347,0.0008}, /*cmz*/
          {5.043083,3.4312,1.3987,-2.6456} /*cfz*/
     },
     {
          2456637.5,
          {0.0024,6e-05,20.9702,0.21146,0.000905,0.0017}, /*cmx*/
          {1.306007,5.7874,3.4255,-0.8573}, /*cfx*/
          {0.0002,-1e-05,14.1493,0.09389,0.000608,0.0003}, /*cmy*/
          {3.608491,2.5059,0.3385,-4.1713}, /*cfy*/
          {0.0017,0.00016,21.5121,0.24277,0.001209,0.0028}, /*cmz*/
          {2.653561,1.1016,4.9706,-1.2359} /*cfz*/
     },
     {
          2456677.5,
          {0.0061,-0.0002,19.629,0.17013,0.001555,0.0042}, /*cmx*/
          {5.314111,3.535,0.4639,-5.1455}, /*cfx*/
          {-0.0017,0.00011,15.247,0.0766,0.000652,0.0019}, /*cmy*/
          {1.485492,0.0043,3.3352,-1.6175}, /*cfy*/
          {0.0031,9e-05,22.0452,0.18347,0.001748,0.0031}, /*cmz*/
          {0.358507,5.1035,2.0714,-6.1447} /*cfz*/
     },
     {
          2456717.5,
          {0.0,8e-05,19.0657,0.02232,0.001985,0.0039}, /*cmx*/
          {3.180263,1.654,4.6212,-0.5522}, /*cfx*/
          {-0.0003,6e-05,15.3768,0.01708,0.000637,0.002}, /*cmy*/
          {5.723468,4.1558,1.2019,-2.3784}, /*cfy*/
          {-0.001,0.0003,22.3405,0.02774,0.002111,0.0056}, /*cmz*/
          {4.523331,3.1616,0.005,-1.7757} /*cfz*/
     },
     {
          2456757.5,
          {0.0067,-0.0002,19.6104,0.13782,0.00195,0.0022}, /*cmx*/
          {1.376022,2.732,5.9205,-5.2401}, /*cfx*/
          {-0.0014,8e-05,15.1939,0.03298,0.000862,0.0002}, /*cmy*/
          {3.828867,5.9265,2.5491,-3.0914}, /*cfy*/
          {-0.0007,0.00026,22.067,0.14594,0.002226,0.0062}, /*cmz*/
          {2.704375,4.4777,1.2608,-6.0052} /*cfz*/
     },
     {
          2456797.5,
          {-0.0007,0.00016,20.3638,0.04497,0.001782,0.0032}, /*cmx*/
          {5.859349,4.4461,3.812,-6.2396}, /*cfx*/
          {0.0023,-9e-05,14.913,0.04414,0.000737,0.0027}, /*cmy*/
          {1.90409,0.6939,0.2109,-3.153}, /*cfy*/
          {-0.0005,0.00025,21.4645,0.0549,0.001939,0.0038}, /*cmz*/
          {0.895275,5.6232,5.4358,-2.2284} /*cfz*/
     },
     {
          2456837.5,
          {0.0039,-0.00012,19.7698,0.18213,0.001444,0.0008}, /*cmx*/
          {3.730966,2.0381,1.0596,-2.8321}, /*cfx*/
          {-0.0008,9e-05,15.5988,0.10627,0.000907,0.0022}, /*cmy*/
          {6.095586,4.772,3.3019,-0.5008}, /*cfy*/
          {0.005,1e-05,21.5357,0.20654,0.001445,0.0031}, /*cmz*/
          {5.02444,3.5485,2.3739,-0.5497} /*cfz*/
     },
     {
          2456877.5,
          {-0.0021,9e-05,18.706,0.26882,0.00182,0.0051}, /*cmx*/
          {1.364544,6.0225,4.6684,-1.6414}, /*cfx*/
          {0.0054,-0.00018,15.9317,0.14334,0.001328,0.0051}, /*cmy*/
          {3.894489,2.242,0.2682,-4.2486}, /*cfy*/
          {0.0073,-6e-05,22.2633,0.27529,0.001881,0.0012}, /*cmz*/
          {2.684385,1.2214,5.8478,-3.5142} /*cfz*/
     },
     {
          2456917.5,
          {-0.0008,-0.0001,18.875,0.33789,0.002373,0.0053}, /*cmx*/
          {5.106084,3.6498,1.8978,-5.9379}, /*cfx*/
          {-0.0025,0.0002,14.4193,0.14797,0.001848,0.0029}, /*cmy*/
          {1.653957,5.7404,3.573,-1.1062}, /*cfy*/
          {0.0017,0.00017,23.1788,0.30798,0.00231,0.0008}, /*cmz*/
          {0.281074,5.0553,3.2775,-0.0035} /*cfz*/
     },
     {
          2456957.5,
          {-0.0071,0.00011,21.1855,0.3552,0.002894,0.0049}, /*cmx*/
          {2.52885,1.1554,5.4061,-2.6475}, /*cfx*/
          {0.0075,-0.00032,10.2605,0.14544,0.001874,0.0044}, /*cmy*/
          {5.825503,2.5868,0.4661,-3.9554}, /*cfy*/
          {0.0081,-0.00023,23.4269,0.33075,0.002563,0.0026}, /*cmz*/
          {4.130369,2.5257,0.7537,-3.5177} /*cfz*/
     },
     {
          2456997.5,
          {-0.0078,8e-05,23.2969,0.32013,0.002684,0.0032}, /*cmx*/
          {0.042658,4.811,2.8115,-0.5653}, /*cfx*/
          {-0.0049,0.00022,6.9375,0.14614,0.001896,0.0034}, /*cmy*/
          {4.336264,5.7267,3.5222,-0.6456}, /*cfy*/
          {-0.0018,0.00012,22.6097,0.35416,0.002604,0.0047}, /*cmz*/
          {1.649095,6.261,4.4858,-1.2922} /*cfz*/
     },
     {
          2457037.5,
          {-0.0051,0.0,22.9752,0.29976,0.002183,0.0019}, /*cmx*/
          {3.905618,2.1897,0.3655,-1.2549}, /*cfx*/
          {0.0025,-0.00017,10.5715,0.13637,0.001842,0.0021}, /*cmy*/
          {2.762709,2.5493,0.5471,-3.5858}, /*cfy*/
          {0.0019,-0.0002,21.4836,0.3693,0.002556,0.004}, /*cmz*/
          {5.383825,3.7459,1.8881,-5.3565} /*cfz*/
     },
     {
          2457077.5,
          {-0.0076,0.00021,20.8819,0.30713,0.001975,0.0021}, /*cmx*/
          {1.468256,5.9705,4.2832,-1.0839}, /*cfx*/
          {-0.0055,0.00026,14.5051,0.15637,0.001602,0.0043}, /*cmy*/
          {0.612824,5.7693,3.865,-0.6683}, /*cfy*/
          {-0.004,1e-05,21.3367,0.36378,0.002495,0.0045}, /*cmz*/
          {2.801458,1.2579,5.5826,-2.8156} /*cfz*/
     },
     {
          2457117.5,
          {-0.0015,4e-05,18.8634,0.32986,0.002043,0.0006}, /*cmx*/
          {5.220214,3.5504,1.8177,-6.0438}, /*cfx*/
          {0.0042,-0.00015,15.802,0.16664,0.001602,0.0028}, /*cmy*/
          {4.605489,2.9608,0.821,-4.0015}, /*cfy*/
          {-0.0074,0.00012,22.2913,0.34088,0.002362,0.0028}, /*cmz*/
          {0.262379,5.0478,3.0549,-0.7396} /*cfz*/
     },
     {
          2457157.5,
          {-0.001,0.00016,18.9186,0.34396,0.002223,0.0041}, /*cmx*/
          {2.605883,1.1369,5.4661,-2.066}, /*cfx*/
          {-0.0034,0.00024,14.2699,0.1421,0.001662,0.0043}, /*cmy*/
          {2.330339,0.1045,4.1785,-1.2667}, /*cfy*/
          {-0.0037,-6e-05,23.2681,0.31525,0.002173,0.001}, /*cmz*/
          {4.078774,2.5417,0.6042,-5.1548} /*cfz*/
     },
     {
          2457197.5,
          {0.0007,0.00016,21.1372,0.32034,0.002265,0.0047}, /*cmx*/
          {0.053023,4.9529,2.8542,-0.0653}, /*cfx*/
          {0.0045,-0.0002,10.352,0.12082,0.001406,0.0027}, /*cmy*/
          {0.225672,3.3161,1.2225,-4.6183}, /*cfy*/
          {-0.0066,0.00016,23.4216,0.29941,0.001983,0.0011}, /*cmz*/
          {1.657377,0.0437,4.4799,-1.8154} /*cfz*/
     },
     {
          2457237.5,
          {0.0054,0.0,23.1209,0.27498,0.001939,0.0021}, /*cmx*/
          {3.91167,2.4247,0.3867,-2.7567}, /*cfx*/
          {-0.0029,0.00013,7.0822,0.1123,0.001252,0.0029}, /*cmy*/
          {4.892265,0.3237,4.4879,-1.7055}, /*cfy*/
          {-0.0009,0.0,22.7319,0.29543,0.001829,0.0007}, /*cmz*/
          {5.527138,3.8667,2.0611,-2.0786} /*cfz*/
     },
     {
          2457277.5,
          {0.0035,0.00012,23.3517,0.24573,0.001539,0.0043}, /*cmx*/
          {1.567682,6.1924,4.32,-1.4423}, /*cfx*/
          {0.0008,-0.0001,8.9914,0.10053,0.001194,0.0024}, /*cmy*/
          {3.394779,3.6615,1.6617,-5.1249}, /*cfy*/
          {-0.0006,8e-05,21.7987,0.29594,0.001696,0.0014}, /*cmz*/
          {3.096832,1.451,5.8974,-1.8837} /*cfz*/
     },
     {
          2457317.5,
          {0.0051,0.0,22.085,0.23835,0.001311,0.0022}, /*cmx*/
          {5.527391,3.7645,2.019,-0.1858}, /*cfx*/
          {-0.0025,5e-05,12.5493,0.10363,0.001066,0.0018}, /*cmy*/
          {1.419849,0.7405,5.2125,-3.1626}, /*cfy*/
          {-0.0006,0.00016,21.3543,0.29144,0.001561,0.0019}, /*cmz*/
          {0.651324,5.3472,3.4333,-5.8053} /*cfz*/
     },
     {
          2457357.5,
          {0.0026,4e-05,20.242,0.24288,0.001171,0.0011}, /*cmx*/
          {3.177485,1.4137,5.9364,-2.872}, /*cfx*/
          {0.0006,-6e-05,14.8592,0.11531,0.000911,0.0008}, /*cmy*/
          {5.54682,4.2986,2.4084,-5.5916}, /*cfy*/
          {0.0057,-6e-05,21.7029,0.27581,0.001439,0.0023}, /*cmz*/
          {4.504646,2.9775,0.9717,-3.3572} /*cfz*/
     },
     {
          2457397.5,
          {0.0002,9e-05,18.859,0.24523,0.001042,0.0033}, /*cmx*/
          {0.779798,5.3862,3.2966,-1.2185}, /*cfx*/
          {0.0004,-1e-05,15.5104,0.11293,0.000782,0.0011}, /*cmy*/
          {3.350704,1.7144,5.8062,-3.8301}, /*cfy*/
          {0.0032,0.0001,22.5,0.24838,0.001274,0.0036}, /*cmz*/
          {2.126355,0.6157,4.7252,-1.5028} /*cfz*/
     },
     {
          2457437.5,
          {0.0046,-0.0002,18.697,0.21845,0.001313,0.0006}, /*cmx*/
          {4.664796,3.0974,0.2913,-0.0786}, /*cfx*/
          {0.0006,0.0,14.755,0.08896,0.000534,0.0024}, /*cmy*/
          {1.18425,5.457,2.7109,-4.8999}, /*cfy*/
          {0.0068,-7e-05,23.1583,0.20724,0.00127,0.0041}, /*cmz*/
          {6.106328,4.556,1.8432,-5.357} /*cfz*/
     },
     {
          2457477.5,
          {-0.0016,8e-05,19.2733,0.11865,0.002523,0.0014}, /*cmx*/
          {2.398105,0.9056,4.0875,-2.0839}, /*cfx*/
          {0.0022,-8e-05,13.5247,0.05209,0.000799,0.0005}, /*cmy*/
          {5.378459,3.2692,5.7564,-2.6068}, /*cfy*/
          {0.0066,-9e-05,23.4006,0.1198,0.002137,0.0034}, /*cmz*/
          {3.916632,2.3277,5.4944,-3.3932} /*cfz*/
     },
     {
          2457517.5,
          {0.0142,-0.0007,19.2268,0.13723,0.000737,0.0078}, /*cmx*/
          {0.437707,2.1922,5.0534,-3.7939}, /*cfx*/
          {0.0004,0.0,13.6859,0.04652,0.000251,0.0047}, /*cmy*/
          {3.368114,3.2711,0.0879,-5.892}, /*cfy*/
          {0.0103,-0.00029,23.3285,0.08602,0.00042,0.0093}, /*cmz*/
          {1.941931,3.6544,0.216,-5.714} /*cfz*/
     },
     {
          2457557.5,
          {0.001,-2e-05,18.6326,0.03434,0.002762,0.0044}, /*cmx*/
          {5.029127,0.2136,3.409,-6.2406}, /*cfx*/
          {-0.0006,8e-05,15.1141,0.02481,0.001054,0.0021}, /*cmy*/
          {1.446315,0.7107,5.4157,-3.0822}, /*cfy*/
          {0.0023,0.00015,22.8612,0.00888,0.002301,0.0006}, /*cmz*/
          {0.145954,1.9834,4.8656,-4.1828} /*cfz*/
     },
     {
          2457597.5,
          {0.0065,-0.00032,18.7206,0.1931,0.001734,0.0059}, /*cmx*/
          {2.959222,1.5154,0.5584,-3.8822}, /*cfx*/
          {0.0006,1e-05,14.822,0.09306,0.001085,0.0035}, /*cmy*/
          {5.69279,3.7816,2.0709,-6.1765}, /*cfy*/
          {0.0088,-0.00015,22.9633,0.17822,0.001594,0.0038}, /*cmz*/
          {4.374844,2.9241,1.8991,-4.7483} /*cfz*/
     },
     {
          2457637.5,
          {-0.0064,0.0002,19.9737,0.30588,0.002093,0.0035}, /*cmx*/
          {0.556327,5.4511,3.7076,-1.6045}, /*cfx*/
          {-0.0003,6e-05,12.3813,0.12285,0.001657,0.003}, /*cmy*/
          {3.563829,0.9623,5.2337,-2.4588}, /*cfy*/
          {0.0065,-5e-05,23.398,0.26795,0.002086,0.0017}, /*cmz*/
          {2.088378,0.5653,5.2667,-2.9981} /*cfz*/
     },
     {
          2457677.5,
          {0.0006,-0.00028,22.3328,0.32285,0.002547,0.0037}, /*cmx*/
          {4.362669,2.9446,0.953,-4.7403}, /*cfx*/
          {0.0024,-0.00013,7.9749,0.13831,0.001766,0.0037}, /*cmy*/
          {1.659684,4.165,2.0735,-5.6088}, /*cfy*/
          {0.0055,-7e-05,23.2201,0.31654,0.002432,0.0046}, /*cmz*/
          {5.978217,4.3586,2.645,-5.5476} /*cfz*/
     },
     {
          2457717.5,
          {-0.0075,9e-05,23.4911,0.29773,0.002317,0.0003}, /*cmx*/
          {1.933577,0.3377,4.7227,-5.0481}, /*cfx*/
          {-0.0033,8e-05,7.4729,0.13513,0.001874,0.0031}, /*cmy*/
          {0.365723,1.0942,5.2512,-2.2314}, /*cfy*/
          {0.0073,-0.00025,22.229,0.35057,0.002464,0.0052}, /*cmz*/
          {3.505157,1.8395,0.038,-3.5372} /*cfz*/
     },
     {
          2457757.5,
          {-0.0033,-9e-05,22.4143,0.29081,0.002017,0.0017}, /*cmx*/
          {5.813138,4.0671,2.3224,-4.2072}, /*cfx*/
          {-0.0006,-7e-05,11.9666,0.13597,0.00176,0.0028}, /*cmy*/
          {4.793931,4.2314,2.3304,-5.4274}, /*cfy*/
          {-0.0019,6e-05,21.3534,0.36319,0.002393,0.002}, /*cmz*/
          {0.960305,5.6269,3.7312,-0.9835} /*cfz*/
     },
     {
          2457797.5,
          {-0.0029,-4e-05,20.2135,0.30752,0.001936,0.0018}, /*cmx*/
          {3.366239,1.6104,6.2033,-3.1425}, /*cfx*/
          {-0.0019,4e-05,15.0866,0.16007,0.001593,0.0044}, /*cmy*/
          {2.57323,1.2945,5.6243,-2.5203}, /*cfy*/
          {0.0016,-0.00024,21.577,0.35101,0.002329,0.0046}, /*cmz*/
          {4.681295,3.1503,1.1991,-4.8871} /*cfz*/
     },
     {
          2457837.5,
          {-0.0067,0.00022,18.6883,0.33233,0.001996,0.0021}, /*cmx*/
          {0.817962,5.4797,3.6935,-0.0646}, /*cfx*/
          {-0.0018,7e-05,15.5717,0.16294,0.001677,0.004}, /*cmy*/
          {0.277254,4.8094,2.6078,-6.0015}, /*cfy*/
          {-0.0056,4e-05,22.5934,0.32659,0.002255,0.0023}, /*cmz*/
          {2.171071,0.6712,5.0071,-3.7748} /*cfz*/
     },
     {
          2457877.5,
          {0.0032,-0.00014,19.4252,0.33841,0.002168,0.005}, /*cmx*/
          {4.499005,3.0571,1.0753,-4.3989}, /*cfx*/
          {0.0011,-4e-05,13.3844,0.13651,0.001675,0.0038}, /*cmy*/
          {4.31002,1.9184,5.9886,-3.2846}, /*cfy*/
          {-0.003,-9e-05,23.3732,0.30624,0.002126,0.0012}, /*cmz*/
          {6.008283,4.4624,2.5642,-4.9238} /*cfz*/
     },
     {
          2457917.5,
          {0.0003,0.00012,21.7536,0.30766,0.002193,0.0036}, /*cmx*/
          {1.98096,0.5835,4.8064,-2.1668}, /*cfx*/
          {-0.0006,2e-05,9.2309,0.12079,0.001412,0.0028}, /*cmy*/
          {2.279504,5.1337,3.0012,-0.0696}, /*cfy*/
          {-0.0016,-0.00011,23.3272,0.29808,0.001948,0.001}, /*cmz*/
          {3.596134,1.973,0.1313,-3.7966} /*cfz*/
     },
     {
          2457957.5,
          {0.006,-7e-05,23.3363,0.26706,0.001893,0.0025}, /*cmx*/
          {5.861897,4.3415,2.373,-5.7366}, /*cfx*/
          {0.0013,-0.00011,6.8996,0.11213,0.001296,0.0026}, /*cmy*/
          {0.784909,2.1547,0.0138,-3.714}, /*cfy*/
          {-0.0052,0.00014,22.5729,0.29801,0.001804,0.002}, /*cmz*/
          {1.181404,5.8006,4.004,-5.1442} /*cfz*/
     },
     {
          2457997.5,
          {0.0061,-3e-05,23.1533,0.24772,0.001569,0.0034}, /*cmx*/
          {3.521935,1.84,0.0243,-4.091}, /*cfx*/
          {-0.0037,9e-05,9.6843,0.10425,0.001234,0.0015}, /*cmy*/
          {5.463188,5.4645,3.501,-0.8025}, /*cfy*/
          {0.0006,-5e-05,21.7042,0.30012,0.001741,0.0036}, /*cmz*/
          {5.025156,3.388,1.59,-4.2613} /*cfz*/
     },
     {
          2458037.5,
          {0.0047,1e-05,21.6579,0.24853,0.001406,0.0018}, /*cmx*/
          {1.183866,5.6987,4.0402,-3.3618}, /*cfx*/
          {0.0003,-0.00011,13.1864,0.11462,0.001128,0.0007}, /*cmy*/
          {3.415777,2.5541,0.7617,-5.2015}, /*cfy*/
          {0.0016,1e-05,21.3921,0.29992,0.001742,0.0016}, /*cmz*/
          {2.566134,1.0018,5.4311,-2.4552} /*cfz*/
     },
     {
          2458077.5,
          {0.0067,-0.00013,19.775,0.26407,0.001425,0.0014}, /*cmx*/
          {5.077497,3.3412,1.7386,-5.7325}, /*cfx*/
          {-0.0045,0.00016,15.1918,0.13075,0.001085,0.0011}, /*cmy*/
          {1.218999,6.1214,4.2143,-1.2432}, /*cfy*/
          {0.0034,2e-05,21.8913,0.29337,0.001743,0.0031}, /*cmz*/
          {0.117458,4.8955,2.9928,-5.7787} /*cfz*/
     },
     {
          2458117.5,
          {0.0049,-0.0001,18.6745,0.2863,0.001539,0.0017}, /*cmx*/
          {2.604842,1.0111,5.5469,-4.0098}, /*cfx*/
          {0.0005,-5e-05,15.2797,0.12998,0.001193,0.0011}, /*cmy*/
          {5.268308,3.4773,1.3622,-4.3423}, /*cfy*/
          {0.0077,-9e-05,22.7893,0.28108,0.001695,0.0043}, /*cmz*/
          {3.988287,2.4835,0.5757,-4.0076} /*cfz*/
     },
     {
          2458157.5,
          {0.0015,-3e-05,19.3828,0.29356,0.001657,0.0015}, /*cmx*/
          {0.09496,4.9418,2.9423,-4.5819}, /*cfx*/
          {-0.0031,0.00014,13.3534,0.11099,0.001168,0.0028}, /*cmy*/
          {3.072536,0.7049,4.8679,-1.3199}, /*cfy*/
          {0.0043,8e-05,23.408,0.26783,0.001579,0.0015}, /*cmz*/
          {1.613294,0.0553,4.4465,-2.2379} /*cfz*/
     },
     {
          2458197.5,
          {0.0021,-0.00017,21.3952,0.26709,0.001583,0.003}, /*cmx*/
          {3.936098,2.5367,0.3131,-3.4313}, /*cfx*/
          {0.002,-0.0001,9.8924,0.09568,0.000819,0.0018}, /*cmy*/
          {1.027226,4.0951,1.963,-4.9861}, /*cfy*/
          {0.0087,-0.00017,23.389,0.25552,0.00133,0.0039}, /*cmz*/
          {5.546626,3.9201,1.9046,-5.4291} /*cfz*/
     },
     {
          2458237.5,
          {-0.0057,0.00012,23.011,0.21383,0.00134,0.003}, /*cmx*/
          {1.607405,0.0971,3.7103,-6.2002}, /*cfx*/
          {-0.0027,0.00011,6.9639,0.07555,0.000574,0.0025}, /*cmy*/
          {5.58358,1.3848,4.6681,-1.9043}, /*cfy*/
          {0.005,0.0,22.9275,0.23092,0.001321,0.0034}, /*cmz*/
          {3.224138,1.5577,5.1013,-3.2621} /*cfz*/
     },
     {
          2458277.5,
          {-0.0008,-0.00013,23.4583,0.11961,0.002001,0.0045}, /*cmx*/
          {5.691321,4.0922,0.962,-4.2148}, /*cfx*/
          {-0.0021,7e-05,6.2955,0.03031,0.001129,0.0008}, /*cmy*/
          {3.97326,5.8447,1.9376,-4.1305}, /*cfy*/
          {0.004,4e-05,22.628,0.13322,0.00234,0.0005}, /*cmz*/
          {0.990605,5.6686,2.4552,-1.7924} /*cfz*/
     },
     {
          2458317.5,
          {-0.0138,0.00055,23.455,0.07973,0.001094,0.0062}, /*cmx*/
          {3.704454,5.3362,2.0809,-0.9143}, /*cfx*/
          {-0.0037,0.00019,5.1927,0.08817,0.000973,0.005}, /*cmy*/
          {1.983531,6.1939,2.6906,-2.3215}, /*cfy*/
          {0.0003,0.00024,22.8926,0.08415,0.001052,0.0069}, /*cmz*/
          {5.286955,0.4754,3.6155,-2.227} /*cfz*/
     },
     {
          2458357.5,
          {-0.0027,-2e-05,23.2272,0.04683,0.00196,0.0041}, /*cmx*/
          {1.85006,0.5347,0.0457,-3.6449}, /*cfx*/
          {0.0034,-0.00018,5.1409,0.01407,0.00097,0.0027}, /*cmy*/
          {5.942479,0.4895,0.9859,-3.6464}, /*cfy*/
          {0.0096,-0.00023,23.0568,0.04467,0.002178,0.0033}, /*cmz*/
          {3.445389,1.9841,1.5428,-4.1007} /*cfz*/
     },
     {
          2458397.5,
          {-0.0059,7e-05,23.4163,0.19914,0.001478,0.001}, /*cmx*/
          {6.016297,4.4965,3.0561,-0.0183}, /*cfx*/
          {-0.0041,0.00013,6.2073,0.09658,0.000982,0.0014}, /*cmy*/
          {4.331589,5.1961,3.4289,-0.7041}, /*cfy*/
          {0.0009,0.00016,22.6236,0.21876,0.001676,0.0067}, /*cmz*/
          {1.312124,5.9603,4.8014,-1.6953} /*cfz*/
     },
     {
          2458437.5,
          {-0.002,-0.00014,23.0438,0.24518,0.001632,0.0009}, /*cmx*/
          {3.734797,2.0539,0.4004,-2.0507}, /*cfx*/
          {0.0016,-0.0002,9.7748,0.11774,0.001395,0.0027}, /*cmy*/
          {2.591183,2.4208,0.5173,-3.8134}, /*cfy*/
          {0.0029,-4e-05,21.7534,0.29815,0.001922,0.0043}, /*cmz*/
          {5.228564,3.5949,1.9678,-6.1774} /*cfz*/
     },
     {
          2458477.5,
          {-0.0073,0.00011,21.4896,0.26899,0.001674,0.0015}, /*cmx*/
          {1.380257,5.9017,4.2819,-0.0102}, /*cfx*/
          {-0.0054,0.00014,13.5674,0.13747,0.001411,0.0026}, /*cmy*/
          {0.47901,5.8003,3.984,-0.6721}, /*cfy*/
          {-0.0007,2e-05,21.3254,0.32611,0.002074,0.0025}, /*cmz*/
          {2.748731,1.1815,5.6283,-2.9871} /*cfz*/
     },
     {
          2458517.5,
          {-0.0048,1e-05,19.5475,0.2959,0.001807,0.0027}, /*cmx*/
          {5.221327,3.5098,1.875,-4.7388}, /*cfx*/
          {0.0011,-0.00015,15.5258,0.15676,0.001399,0.0047}, /*cmy*/
          {4.506265,3.0394,1.0601,-4.5113}, /*cfy*/
          {-0.0047,8e-05,21.8705,0.3246,0.002101,0.003}, /*cmz*/
          {0.248996,5.0251,3.0954,-1.1885} /*cfz*/
     },
     {
          2458557.5,
          {-0.0035,3e-05,18.709,0.32334,0.001993,0.0036}, /*cmx*/
          {2.676043,1.1249,5.602,-2.751}, /*cfx*/
          {-0.0047,0.00018,15.1347,0.14968,0.001547,0.0028}, /*cmy*/
          {2.221914,0.3114,4.4226,-1.9839}, /*cfy*/
          {-0.0024,-0.00011,22.8689,0.30921,0.002043,0.0025}, /*cmz*/
          {4.071422,2.5612,0.6425,-1.0703} /*cfz*/
     },
     {
          2458597.5,
          {-0.0029,0.0001,20.0128,0.32725,0.002167,0.0044}, /*cmx*/
          {0.109759,4.9847,2.9713,-0.2057}, /*cfx*/
          {0.0032,-0.00018,12.3119,0.12525,0.001505,0.0027}, /*cmy*/
          {0.009573,3.6762,1.5502,-5.1841}, /*cfy*/
          {-0.0084,0.00016,23.4585,0.29579,0.001966,0.0023}, /*cmz*/
          {1.653283,0.0855,4.5152,-0.8911} /*cfz*/
     },
     {
          2458637.5,
          {0.0034,-6e-05,22.2797,0.29598,0.002077,0.0031}, /*cmx*/
          {3.917278,2.4954,0.4463,-4.2497}, /*cfx*/
          {-0.0031,0.00013,8.1083,0.11498,0.001318,0.0025}, /*cmy*/
          {4.36138,0.6458,4.8478,-2.0566}, /*cfy*/
          {-0.0059,5e-05,23.2275,0.29226,0.001907,0.0004}, /*cmz*/
          {5.535134,3.9063,2.1087,-3.1542} /*cfz*/
     },
     {
          2458677.5,
          {0.0006,0.00016,23.4579,0.26177,0.001772,0.0017}, /*cmx*/
          {1.536687,6.2547,4.3304,-2.4544}, /*cfx*/
          {-0.0001,-8e-05,6.9926,0.10731,0.001294,0.0019}, /*cmy*/
          {2.959538,3.9803,1.9064,-5.8751}, /*cfy*/
          {-0.0059,0.0001,22.4089,0.29718,0.001839,0.0035}, /*cmz*/
          {3.121792,1.4686,5.9711,-1.8065} /*cfz*/
     },
     {
          2458717.5,
          {0.005,0.0,22.9306,0.24858,0.001562,0.0017}, /*cmx*/
          {5.481913,3.7773,2.0244,-0.1704}, /*cfx*/
          {-0.0034,4e-05,10.3731,0.10541,0.001286,0.0015}, /*cmy*/
          {1.227989,1.0133,5.4072,-2.2442}, /*cfy*/
          {-0.006,0.0002,21.6241,0.30394,0.001781,0.0041}, /*cmz*/
          {0.678607,5.3377,3.5396,-0.4773} /*cfz*/
     },
     {
          2458757.5,
          {0.0059,-3e-05,21.2673,0.25704,0.001521,0.0012}, /*cmx*/
          {3.130472,1.3701,6.0335,-5.0876}, /*cfx*/
          {-0.0034,3e-05,13.6722,0.1226,0.001243,0.0009}, /*cmy*/
          {5.406136,4.4275,2.6277,-0.393}, /*cfy*/
          {0.0013,-1e-05,21.4777,0.30569,0.001804,0.0011}, /*cmz*/
          {4.495482,2.9392,1.117,-4.133} /*cfz*/
     },
     {
          2458797.5,
          {0.0036,7e-05,19.4484,0.28233,0.00163,0.0012}, /*cmx*/
          {0.709195,5.2891,3.7039,-2.0152}, /*cfx*/
          {-0.0019,-2e-05,15.2975,0.14197,0.001292,0.002}, /*cmy*/
          {3.181007,1.7182,6.0115,-2.6803}, /*cfy*/
          {-0.0002,0.00019,22.1015,0.30276,0.001915,0.005}, /*cmz*/
          {2.036234,0.5356,4.9685,-1.9263} /*cfz*/
     },
     {
          2458837.5,
          {0.0075,-0.00018,18.7803,0.31334,0.001868,0.0005}, /*cmx*/
          {4.470571,2.9283,1.2063,-5.294}, /*cfx*/
          {-0.0049,0.00016,14.8324,0.14063,0.001517,0.0029}, /*cmy*/
          {0.928502,5.2781,3.0991,-0.0566}, /*cfy*/
          {0.002,0.00015,22.9928,0.29935,0.002042,0.0045}, /*cmz*/
          {5.889186,4.3843,2.5285,-0.3376} /*cfz*/
     },
     {
          2458877.5,
          {-0.0002,9e-05,20.212,0.32597,0.002224,0.002}, /*cmx*/
          {1.917432,0.5216,4.8519,-1.4774}, /*cfx*/
          {0.002,-0.00013,11.9832,0.12607,0.001564,0.0038}, /*cmy*/
          {5.026234,2.3194,0.2017,-3.3562}, /*cfy*/
          {0.0063,0.0,23.453,0.30026,0.002095,0.0016}, /*cmz*/
          {3.48013,1.9106,0.0987,-3.8895} /*cfz*/
     },
     {
          2458917.5,
          {0.0004,-8e-05,22.5288,0.30328,0.002324,0.004}, /*cmx*/
          {5.72459,4.3012,2.282,-5.1054}, /*cfx*/
          {-0.0035,0.00013,7.7623,0.12583,0.001413,0.0032}, /*cmy*/
          {3.154403,5.5419,3.4099,-0.321}, /*cfy*/
          {0.003,0.00015,23.1165,0.30927,0.002056,0.0043}, /*cmz*/
          {1.064399,5.7072,3.9355,-1.5977} /*cfz*/
     },
     {
          2458957.5,
          {-0.0019,-5e-05,23.469,0.27548,0.001976,0.0039}, /*cmx*/
          {3.331706,1.7307,6.0808,-2.4726}, /*cfx*/
          {0.0017,-0.00018,7.4044,0.11571,0.001372,0.0037}, /*cmy*/
          {1.80409,2.5625,0.4055,-3.8309}, /*cfy*/
          {0.0076,-0.00014,22.2685,0.31973,0.001955,0.0024}, /*cmz*/
          {4.897794,3.2446,1.4246,-0.7138} /*cfz*/
     },
     {
          2458997.5,
          {-0.0055,6e-05,22.5064,0.26517,0.001497,0.0046}, /*cmx*/
          {0.970578,5.4965,3.5309,-0.4875}, /*cfx*/
          {-0.0043,8e-05,11.1297,0.10642,0.001109,0.0029}, /*cmy*/
          {6.269163,5.8059,3.7991,-0.7837}, /*cfy*/
          {-0.0008,0.00016,21.7277,0.3159,0.001773,0.0025}, /*cmz*/
          {2.418098,0.8136,5.0508,-1.3949} /*cfz*/
     },
     {
          2459037.5,
          {-0.0007,-0.00017,20.7203,0.24806,0.001303,0.0042}, /*cmx*/
          {4.888126,3.0831,0.4776,-4.4552}, /*cfx*/
          {-0.0002,-0.00011,13.8732,0.10348,0.000707,0.0025}, /*cmy*/
          {4.143273,2.9441,0.5767,-4.3793}, /*cfy*/
          {0.0006,-4e-05,21.9789,0.27795,0.001717,0.0021}, /*cmz*/
          {6.254156,4.6944,2.0803,-5.5246} /*cfz*/
     },
     {
          2459077.5,
          {-0.0079,0.00016,19.4371,0.16011,0.002612,0.0045}, /*cmx*/
          {2.573856,0.8331,3.9607,-2.0205}, /*cfx*/
          {-0.0043,8e-05,14.7629,0.0673,0.000804,0.0005}, /*cmy*/
          {2.001894,0.4434,3.6124,-2.9202}, /*cfy*/
          {-0.0004,-6e-05,22.5326,0.1695,0.002659,0.0046}, /*cmz*/
          {3.945109,2.3849,5.5599,-1.789} /*cfz*/
     },
     {
          2459117.5,
          {0.008,-0.00065,19.2669,0.10428,0.000572,0.005}, /*cmx*/
          {0.537176,1.9435,4.9358,-3.5621}, /*cfx*/
          {0.0002,-0.00017,14.8415,0.01228,0.000392,0.0019}, /*cmy*/
          {6.274355,1.7523,4.8061,-2.4113}, /*cfy*/
          {0.0035,-0.00024,22.5665,0.08416,0.000419,0.0118}, /*cmz*/
          {1.915813,3.6841,0.2156,-5.5959} /*cfz*/
     },
     {
          2459157.5,
          {-0.0048,-1e-05,19.9456,0.02067,0.002273,0.0026}, /*cmx*/
          {5.065093,5.7872,3.1987,-5.7645}, /*cfx*/
          {-0.0031,0.0,14.8218,0.03148,0.000832,0.0025}, /*cmy*/
          {4.350904,3.1149,2.7284,-5.972}, /*cfy*/
          {-0.0057,0.00026,21.9249,0.00798,0.002268,0.0029}, /*cmz*/
          {0.11952,3.6985,4.8092,-1.8929} /*cfz*/
     },
     {
          2459197.5,
          {-0.0041,-6e-05,19.6861,0.16411,0.001381,0.0032}, /*cmx*/
          {3.008157,1.3571,0.44,-2.6677}, /*cfx*/
          {-0.0036,3e-05,15.3322,0.099,0.000833,0.0033}, /*cmy*/
          {2.276251,0.9225,5.7727,-2.7085}, /*cfy*/
          {0.0022,-0.00019,21.8104,0.18633,0.001282,0.0029}, /*cmz*/
          {4.321588,2.8234,1.811,-5.6415} /*cfz*/
     }

};

static unsigned idn_list[] = {2,83};
static double freq_list[] = {19.7027,4.9788};
static double delt_list[] = {50.0,40.0};

BDL_Dataset mars_1020 = {
     2, /*nsat*/
     2455197.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};

