import threading
from collections.abc import Sequence
from types import TracebackType
from typing import Any, Protocol

from pykka import ActorRef, Future
from pykka._envelope import Envelope

class ActorInbox(Protocol):
    def put(self, envelope: Envelope) -> None: ...
    def get(self) -> Envelope: ...

class Actor:
    @classmethod
    def start(cls, *args: Any, **kwargs: Any) -> ActorRef: ...
    @staticmethod
    def _create_actor_inbox() -> ActorInbox: ...
    @staticmethod
    def _create_future() -> Future: ...
    def _start_actor_loop(self) -> None: ...
    actor_urn: str
    actor_inbox: ActorInbox
    actor_ref: ActorRef
    actor_stopped: threading.Event
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def stop(self) -> None: ...
    def _stop(self) -> None: ...
    def _actor_loop(self) -> None: ...
    def on_start(self) -> None: ...
    def on_stop(self) -> None: ...
    def _handle_failure(
        self,
        exception_type: type[BaseException],
        exception_value: BaseException,
        traceback: TracebackType,
    ) -> None: ...
    def on_failure(
        self,
        exception_type: type[BaseException],
        exception_value: BaseException,
        traceback: TracebackType,
    ) -> None: ...
    def _handle_receive(self, message: Any) -> Any: ...
    def on_receive(self, message: Any) -> Any: ...
    def _get_attribute_from_path(self, attr_path: Sequence[str]) -> Any: ...
    def _introspect_attribute_from_path(
        self, attr_path: Sequence[str]
    ) -> dict[str, Any]: ...
    def _introspect_attributes(self, obj: Any) -> dict[str, Any]: ...
