# PySNMP SMI module. Autogenerated from smidump -f python RFC1382-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:33 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( EntryStatus, ) = mibBuilder.importSymbols("RFC1271-MIB", "EntryStatus")
( IfIndexType, PositiveInteger, ) = mibBuilder.importSymbols("RFC1381-MIB", "IfIndexType", "PositiveInteger")
( Bits, Counter32, Gauge32, Integer32, Integer32, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "transmission")
( DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString")

# Types

class X121Address(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,17)
    

# Objects

x25 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5))
x25AdmnTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 1))
if mibBuilder.loadTexts: x25AdmnTable.setDescription("This table contains the administratively\nset configuration parameters for an X.25\nPacket Level Entity (PLE).\n\nMost of the objects in this table have\ncorresponding objects in the x25OperTable.\nThis table contains the values as last set\nby the administrator.  The x25OperTable\ncontains the values actually in use by an\nX.25 PLE.\n\nChanging an administrative value may or may\nnot change a current operating value.  The\noperating value may not change until the\ninterface is restarted.  Some\nimplementations may change the values\nimmediately upon changing the administrative\ntable.  All implementations are required to\nload the values from the administrative\ntable when initializing a PLE.")
x25AdmnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 1, 1)).setIndexNames((0, "RFC1382-MIB", "x25AdmnIndex"))
if mibBuilder.loadTexts: x25AdmnEntry.setDescription("Entries of x25AdmnTable.")
x25AdmnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25AdmnIndex.setDescription("The ifIndex value for the X.25 Interface.")
x25AdmnInterfaceMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("dte", 1), ("dce", 2), ("dxe", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnInterfaceMode.setDescription("Identifies DCE/DTE mode in which the\ninterface operates.  A value of dxe\nindicates the mode will be determined by XID\nnegotiation.")
x25AdmnMaxActiveCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4096))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnMaxActiveCircuits.setDescription("The maximum number of circuits this PLE can\nsupport; including PVCs.")
x25AdmnPacketSequencing = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("modulo8", 1), ("modulo128", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnPacketSequencing.setDescription("The modulus of the packet sequence number\nspace.")
x25AdmnRestartTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 5), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRestartTimer.setDescription("The T20 restart timer in milliseconds.")
x25AdmnCallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 6), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnCallTimer.setDescription("The T21 Call timer in milliseconds.")
x25AdmnResetTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 7), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnResetTimer.setDescription("The T22 Reset timer in milliseconds.")
x25AdmnClearTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 8), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnClearTimer.setDescription("The T23 Clear timer in milliseconds.")
x25AdmnWindowTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 9), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnWindowTimer.setDescription("The T24 window status transmission timer in\nmilliseconds.  A value of 2147483647\nindicates no window timer in use.")
x25AdmnDataRxmtTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 10), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnDataRxmtTimer.setDescription("The T25 data retransmission timer in\nmilliseconds.  A value of 2147483647\nindicates no data retransmission timer in\nuse.")
x25AdmnInterruptTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 11), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnInterruptTimer.setDescription("The T26 interrupt timer in milliseconds.  A\nvalue of 2147483647 indicates no interrupt\ntimer in use.")
x25AdmnRejectTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 12), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRejectTimer.setDescription("The T27 Reject retransmission timer in\nmilliseconds.  A value of 2147483647\nindicates no reject timer in use.")
x25AdmnRegistrationRequestTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 13), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRegistrationRequestTimer.setDescription("The T28 registration timer in milliseconds.\nA value of 2147483647 indicates no\nregistration timer in use.")
x25AdmnMinimumRecallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 14), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnMinimumRecallTimer.setDescription("Minimum time interval between unsuccessful\ncall attempts in milliseconds.")
x25AdmnRestartCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRestartCount.setDescription("The R20 restart retransmission count.")
x25AdmnResetCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnResetCount.setDescription("The r22 Reset retransmission count.")
x25AdmnClearCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnClearCount.setDescription("The r23 Clear retransmission count.")
x25AdmnDataRxmtCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnDataRxmtCount.setDescription("The R25 Data retransmission count.  This\nvalue is irrelevant if the\nx25AdmnDataRxmtTimer indicates no timer in\nuse.")
x25AdmnRejectCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRejectCount.setDescription("The R27 reject retransmission count.  This\nvalue is irrelevant if the\nx25AdmnRejectTimer indicates no timer in\nuse.")
x25AdmnRegistrationRequestCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnRegistrationRequestCount.setDescription("The R28 Registration retransmission Count.\nThis value is irrelevant if the\nx25AdmnRegistrationRequestTimer indicates no\ntimer in use.")
x25AdmnNumberPVCs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4096))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnNumberPVCs.setDescription("The number of PVC configured for this PLE.\nThe PVCs use channel numbers from 1 to this\nnumber.")
x25AdmnDefCallParamId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 22), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnDefCallParamId.setDescription("This identifies the instance of the\nx25CallParmIndex for the entry in the\nx25CallParmTable which contains the default\ncall parameters for this PLE.")
x25AdmnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 23), X121Address()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnLocalAddress.setDescription("The local address for this PLE subnetwork.\nA zero length address maybe returned by PLEs\nthat only support PVCs.")
x25AdmnProtocolVersionSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 1, 1, 24), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25AdmnProtocolVersionSupported.setDescription("Identifies the version of the X.25 protocol\nthis interface should support.  Object\nidentifiers for common versions are defined\nbelow in the x25ProtocolVersion subtree.")
x25OperTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 2))
if mibBuilder.loadTexts: x25OperTable.setDescription("The operation parameters in use by the X.25\nPLE.")
x25OperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 2, 1)).setIndexNames((0, "RFC1382-MIB", "x25OperIndex"))
if mibBuilder.loadTexts: x25OperEntry.setDescription("Entries of x25OperTable.")
x25OperIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperIndex.setDescription("The ifIndex value for the X.25 interface.")
x25OperInterfaceMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("dte", 1), ("dce", 2), ("dxe", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperInterfaceMode.setDescription("Identifies DCE/DTE mode in which the\ninterface operates.  A value of dxe\nindicates the role will be determined by XID\nnegotiation at the Link Layer and that\nnegotiation has not yet taken place.")
x25OperMaxActiveCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4096))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperMaxActiveCircuits.setDescription("Maximum number of circuits this PLE can\nsupport.")
x25OperPacketSequencing = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("modulo8", 1), ("modulo128", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperPacketSequencing.setDescription("The modulus of the packet sequence number\nspace.")
x25OperRestartTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 5), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRestartTimer.setDescription("The T20 restart timer in milliseconds.")
x25OperCallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 6), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperCallTimer.setDescription("The T21 Call timer in milliseconds.")
x25OperResetTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 7), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperResetTimer.setDescription("The T22 Reset timer in milliseconds.")
x25OperClearTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 8), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperClearTimer.setDescription("The T23 Clear timer in milliseconds.")
x25OperWindowTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 9), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperWindowTimer.setDescription("The T24 window status transmission timer\nmilliseconds.  A value of 2147483647\nindicates no window timer in use.")
x25OperDataRxmtTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 10), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperDataRxmtTimer.setDescription("The T25 Data Retransmission timer in\nmilliseconds.  A value of 2147483647\nindicates no data retransmission timer in\nuse.")
x25OperInterruptTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 11), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperInterruptTimer.setDescription("The T26 Interrupt timer in milliseconds.  A\nvalue of 2147483647 indicates interrupts are\nnot being used.")
x25OperRejectTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 12), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRejectTimer.setDescription("The T27 Reject retransmission timer in\nmilliseconds.  A value of 2147483647\nindicates no reject timer in use.")
x25OperRegistrationRequestTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 13), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRegistrationRequestTimer.setDescription("The T28 registration timer in milliseconds.\nA value of 2147483647 indicates no\nregistration timer in use.")
x25OperMinimumRecallTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 14), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperMinimumRecallTimer.setDescription("Minimum time interval between unsuccessful\ncall attempts in milliseconds.")
x25OperRestartCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRestartCount.setDescription("The R20 restart retransmission count.")
x25OperResetCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperResetCount.setDescription("The r22 Reset retransmission count.")
x25OperClearCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperClearCount.setDescription("The r23 Clear retransmission count.")
x25OperDataRxmtCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperDataRxmtCount.setDescription("The R25 Data retransmission count.  This\nvalue is undefined if the\nx25OperDataRxmtTimer indicates no timer in\nuse.")
x25OperRejectCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRejectCount.setDescription("The R27 reject retransmission count.  This\nvalue is undefined if the x25OperRejectTimer\nindicates no timer in use.")
x25OperRegistrationRequestCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperRegistrationRequestCount.setDescription("The R28 Registration retransmission Count.\nThis value is undefined if the\nx25OperREgistrationRequestTimer indicates no\ntimer in use.")
x25OperNumberPVCs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4096))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperNumberPVCs.setDescription("The number of PVC configured for this PLE.\nThe PVCs use channel numbers from 1 to this\nnumber.")
x25OperDefCallParamId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 22), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperDefCallParamId.setDescription("This identifies the instance of the\nx25CallParmIndex for the entry in the\nx25CallParmTable that contains the default\ncall parameters for this PLE.")
x25OperLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 23), X121Address()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperLocalAddress.setDescription("The local address for this PLE subnetwork.\nA zero length address maybe returned by PLEs\nthat only support PVCs.")
x25OperDataLinkId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 24), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperDataLinkId.setDescription("This identifies the instance of the index\nobject in the first table of the most device\nspecific MIB for the interface used by this\nPLE.")
x25OperProtocolVersionSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 2, 1, 25), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25OperProtocolVersionSupported.setDescription("Identifies the version of the X.25 protocol\nthis interface supports.  Object identifiers\nfor common versions are defined below in the\nx25ProtocolVersion subtree.")
x25StatTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 3))
if mibBuilder.loadTexts: x25StatTable.setDescription("Statistics information about this X.25\nPLE.")
x25StatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 3, 1)).setIndexNames((0, "RFC1382-MIB", "x25StatIndex"))
if mibBuilder.loadTexts: x25StatEntry.setDescription("Entries of the x25StatTable.")
x25StatIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatIndex.setDescription("The ifIndex value for the X.25 interface.")
x25StatInCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInCalls.setDescription("The number of incoming calls received.")
x25StatInCallRefusals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInCallRefusals.setDescription("The number of incoming calls refused.  This\nincludes calls refused by the PLE and by\nhigher layers.  This also includes calls\ncleared because of restricted fast select.")
x25StatInProviderInitiatedClears = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInProviderInitiatedClears.setDescription("The number of clear requests with a cause\ncode other than DTE initiated.")
x25StatInRemotelyInitiatedResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInRemotelyInitiatedResets.setDescription("The number of reset requests received with\ncause code DTE initiated.")
x25StatInProviderInitiatedResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInProviderInitiatedResets.setDescription("The number of reset requests received with\ncause code other than DTE initiated.")
x25StatInRestarts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInRestarts.setDescription("The number of remotely initiated (including\nprovider initiated) restarts experienced by\nthe PLE excluding the restart associated\nwith bringing up the PLE interface.  This\nonly counts restarts received when the PLE\nalready has an established connection with\nthe remove PLE.")
x25StatInDataPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInDataPackets.setDescription("The number of data packets received.")
x25StatInAccusedOfProtocolErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInAccusedOfProtocolErrors.setDescription("The number of packets received containing a\nprocedure error cause code.  These include\nclear, reset, restart, or diagnostic\npackets.")
x25StatInInterrupts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInInterrupts.setDescription("The number of interrupt packets received by\nthe PLE or over the PVC/VC.")
x25StatOutCallAttempts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutCallAttempts.setDescription("The number of calls attempted.")
x25StatOutCallFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutCallFailures.setDescription("The number of call attempts which failed.\nThis includes calls that were cleared\nbecause of restrictive fast select.")
x25StatOutInterrupts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutInterrupts.setDescription("The number of interrupt packets send by the\nPLE or over the PVC/VC.")
x25StatOutDataPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutDataPackets.setDescription("The number of data packets sent by this\nPLE.")
x25StatOutgoingCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatOutgoingCircuits.setDescription("The number of active outgoing circuits.\nThis includes call requests sent but not yet\nconfirmed.  This does not count PVCs.")
x25StatIncomingCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 16), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatIncomingCircuits.setDescription("The number of active Incoming Circuits.\nThis includes call indications received but\nnot yet acknowledged.  This does not count\nPVCs.")
x25StatTwowayCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 17), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatTwowayCircuits.setDescription("The number of active two-way Circuits.\nThis includes call requests sent but not yet\nconfirmed.  This does not count PVCs.")
x25StatRestartTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatRestartTimeouts.setDescription("The number of times the T20 restart timer\nexpired.")
x25StatCallTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatCallTimeouts.setDescription("The number of times the T21 call timer\nexpired.")
x25StatResetTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatResetTimeouts.setDescription("The number of times the T22 reset timer\nexpired.")
x25StatClearTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatClearTimeouts.setDescription("The number of times the T23 clear timer\nexpired.")
x25StatDataRxmtTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatDataRxmtTimeouts.setDescription("The number of times the T25 data timer\nexpired.")
x25StatInterruptTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatInterruptTimeouts.setDescription("The number of times the T26 interrupt timer\nexpired.")
x25StatRetryCountExceededs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatRetryCountExceededs.setDescription("The number of times a retry counter was\nexhausted.")
x25StatClearCountExceededs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25StatClearCountExceededs.setDescription("The number of times the R23 clear count was\nexceeded.")
x25ChannelTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 4))
if mibBuilder.loadTexts: x25ChannelTable.setDescription("These objects contain information about the\nchannel number configuration in an X.25 PLE.\nThese values are the configured values.\nchanges in these values after the interfaces\nhas started may not be reflected in the\noperating PLE.")
x25ChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 4, 1)).setIndexNames((0, "RFC1382-MIB", "x25ChannelIndex"))
if mibBuilder.loadTexts: x25ChannelEntry.setDescription("Entries of x25ChannelTable.")
x25ChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ChannelIndex.setDescription("The ifIndex value for the X.25 Interface.")
x25ChannelLIC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelLIC.setDescription("Lowest Incoming channel.")
x25ChannelHIC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelHIC.setDescription("Highest Incoming channel.  A value of zero\nindicates no channels in this range.")
x25ChannelLTC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelLTC.setDescription("Lowest Two-way channel.")
x25ChannelHTC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelHTC.setDescription("Highest Two-way channel.  A value of zero\nindicates no channels in this range.")
x25ChannelLOC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelLOC.setDescription("Lowest outgoing channel.")
x25ChannelHOC = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 4, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ChannelHOC.setDescription("Highest outgoing channel.  A value of zero\nindicates no channels in this range.")
x25CircuitTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 5))
if mibBuilder.loadTexts: x25CircuitTable.setDescription("These objects contain general information\nabout a specific circuit of an X.25 PLE.")
x25CircuitEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 5, 1)).setIndexNames((0, "RFC1382-MIB", "x25CircuitIndex"), (0, "RFC1382-MIB", "x25CircuitChannel"))
if mibBuilder.loadTexts: x25CircuitEntry.setDescription("Entries of x25CircuitTable.")
x25CircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 1), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitIndex.setDescription("The ifIndex value for the X.25 Interface.")
x25CircuitChannel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitChannel.setDescription("The channel number for this circuit.")
x25CircuitStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,6,4,9,5,1,3,8,10,7,)).subtype(namedValues=NamedValues(("invalid", 1), ("other", 10), ("closed", 2), ("calling", 3), ("open", 4), ("clearing", 5), ("pvc", 6), ("pvcResetting", 7), ("startClear", 8), ("startPvcResetting", 9), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitStatus.setDescription("This object reports the current status of\nthe circuit.\n\nAn existing instance of this object can only\nbe set to startClear, startPvcResetting, or\ninvalid.  An instance with the value calling\nor open can only be set to startClear and\nthat action will start clearing the circuit.\nAn instance with the value PVC can only be\nset to startPvcResetting or invalid and that\naction resets the PVC or deletes the circuit\nrespectively.  The values startClear or\nstartPvcResetting will never be returned by\nan agent.  An attempt to set the status of\nan existing instance to a value other than\none of these values will result in an error.\n\nA non-existing instance can be set to PVC to\ncreate a PVC if the implementation supports\ndynamic creation of PVCs.  Some\nimplementations may only allow creation and\ndeletion of PVCs if the interface is down.\nSince the instance identifier will supply\nthe PLE index and the channel number,\nsetting this object alone supplies\nsufficient information to create the\ninstance.  All the DEFVAL clauses for the\nother objects of this table are appropriate\nfor creating a PVC; PLEs creating entries\nfor placed or accepted calls will use values\nappropriate for the call rather than the\nvalue of the DEFVAL clause.  Two managers\ntrying to create the same PVC can determine\nfrom the return code which manager succeeded\nand which failed (the failing manager fails\nbecause it can not set a value of PVC for an\nexisting object).\nAn entry in the closed or invalid state may\nbe deleted or reused at the agent's\nconvence.  If the entry is kept in the\nclosed state, the values of the parameters\nassociated with the entry must be correct.\nClosed implies the values in the circuit\ntable are correct.\n\nThe value of invalid indicates the other\nvalues in the table are invalid.  Many\nagents may never return a value of invalid\nbecause they dynamically allocate and free\nunused table entries.  An agent for a\nstatically configured systems can return\ninvalid to indicate the entry has not yet\nbeen used so the counters contain no\ninformation.")
x25CircuitEstablishTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitEstablishTime.setDescription("The value of sysUpTime when the channel was\nassociated with this circuit.  For outgoing\nSVCs, this is the time the first call packet\nwas sent.  For incoming SVCs, this is the\ntime the call indication was received.  For\nPVCs this is the time the PVC was able to\npass data to a higher layer entity without\nloss of data.")
x25CircuitDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("incoming", 1), ("outgoing", 2), ("pvc", 3), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitDirection.setDescription("The direction of the call that established\nthis circuit.")
x25CircuitInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInOctets.setDescription("The number of octets of user data delivered\nto upper layer.")
x25CircuitInPdus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInPdus.setDescription("The number of PDUs received for this\ncircuit.")
x25CircuitInRemotelyInitiatedResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInRemotelyInitiatedResets.setDescription("The number of Resets received for this\ncircuit with cause code of DTE initiated.")
x25CircuitInProviderInitiatedResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInProviderInitiatedResets.setDescription("The number of Resets received for this\ncircuit with cause code other than DTE\ninitiated.")
x25CircuitInInterrupts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInInterrupts.setDescription("The number of interrupt packets received\nfor this circuit.")
x25CircuitOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitOutOctets.setDescription("The number of octets of user data sent for\nthis circuit.")
x25CircuitOutPdus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitOutPdus.setDescription("The number of PDUs sent for this circuit.")
x25CircuitOutInterrupts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitOutInterrupts.setDescription("The number of interrupt packets sent on\nthis circuit.")
x25CircuitDataRetransmissionTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitDataRetransmissionTimeouts.setDescription("The number of times the T25 data\nretransmission timer expired for this\ncircuit.")
x25CircuitResetTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitResetTimeouts.setDescription("The number of times the T22 reset timer\nexpired for this circuit.")
x25CircuitInterruptTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CircuitInterruptTimeouts.setDescription("The number of times the T26 Interrupt timer\nexpired for this circuit.")
x25CircuitCallParamId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 17), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitCallParamId.setDescription("This identifies the instance of the\nx25CallParmIndex for the entry in the\nx25CallParmTable which contains the call\nparameters in use with this circuit.  The\nentry referenced must contain the values\nthat are currently in use by the circuit\nrather than proposed values.  A value of\nNULL indicates the circuit is a PVC or is\nusing all the default parameters.")
x25CircuitCalledDteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 18), X121Address().clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitCalledDteAddress.setDescription("For incoming calls, this is the called\naddress from the call indication packet.\nFor outgoing calls, this is the called\naddress from the call confirmation packet.\nThis will be zero length for PVCs.")
x25CircuitCallingDteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 19), X121Address().clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitCallingDteAddress.setDescription("For incoming calls, this is the calling\naddress from the call indication packet.\nFor outgoing calls, this is the calling\naddress from the call confirmation packet.\nThis will be zero length for PVCs.")
x25CircuitOriginallyCalledAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 20), X121Address().clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitOriginallyCalledAddress.setDescription("For incoming calls, this is the address in\nthe call Redirection or Call Deflection\nNotification facility if the call was\ndeflected or redirected, otherwise it will\nbe called address from the call indication\npacket.  For outgoing calls, this is the\naddress from the call request packet.  This\nwill be zero length for PVCs.")
x25CircuitDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 5, 1, 21), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CircuitDescr.setDescription("A descriptive string associated with this\ncircuit.  This provides a place for the\nagent to supply any descriptive information\nit knows about the use or owner of the\ncircuit.  The agent may return the process\nidentifier and user name for the process\nusing the circuit.  Alternative the agent\nmay return the name of the configuration\nentry that caused a bridge to establish the\ncircuit.  A zero length value indicates the\nagent doesn't have any additional\ninformation.")
x25ClearedCircuitEntriesRequested = MibScalar((1, 3, 6, 1, 2, 1, 10, 5, 6), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25ClearedCircuitEntriesRequested.setDescription("The requested number of entries for the\nagent to keep in the x25ClearedCircuit\ntable.")
x25ClearedCircuitEntriesGranted = MibScalar((1, 3, 6, 1, 2, 1, 10, 5, 7), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitEntriesGranted.setDescription("The actual number of entries the agent will\nkeep in the x25ClearedCircuit Table.")
x25ClearedCircuitTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 8))
if mibBuilder.loadTexts: x25ClearedCircuitTable.setDescription("A table of entries about closed circuits.\nEntries must be made in this table whenever\ncircuits are closed and the close request or\nclose indication packet contains a clearing\ncause other than DTE Originated or a\nDiagnostic code field other than Higher\nLayer Initiated disconnection-normal.  An\nagent may optionally make entries for normal\ncloses (to record closing facilities or\nother information).\n\nAgents will delete the oldest entry in the\ntable when adding a new entry would exceed\nagent resources.  Agents are required to\nkeep the last entry put in the table and may\nkeep more entries.  The object\nx25OperClearEntriesGranted returns the\nmaximum number of entries kept in the\ntable.")
x25ClearedCircuitEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 8, 1)).setIndexNames((0, "RFC1382-MIB", "x25ClearedCircuitIndex"))
if mibBuilder.loadTexts: x25ClearedCircuitEntry.setDescription("Information about a cleared circuit.")
x25ClearedCircuitIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 1), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitIndex.setDescription("An index that uniquely distinguishes one\nentry in the clearedCircuitTable from\nanother.  This index will start at\n2147483647 and will decrease by one for each\nnew entry added to the table.  Upon reaching\none, the index will reset to 2147483647.\nBecause the index starts at 2147483647 and\ndecreases, a manager may do a getnext on\nentry zero and obtain the most recent entry.\nWhen the index has the value of 1, the next\nentry will delete all entries in the table\nand that entry will be numbered 2147483647.")
x25ClearedCircuitPleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 2), IfIndexType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitPleIndex.setDescription("The value of ifIndex for the PLE which\ncleared the circuit that created the entry.")
x25ClearedCircuitTimeEstablished = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitTimeEstablished.setDescription("The value of sysUpTime when the circuit was\nestablished.  This will be the same value\nthat was in the x25CircuitEstablishTime for\nthe circuit.")
x25ClearedCircuitTimeCleared = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitTimeCleared.setDescription("The value of sysUpTime when the circuit was\ncleared.  For locally initiated clears, this\nwill be the time when the clear confirmation\nwas received.  For remotely initiated\nclears, this will be the time when the clear\nindication was received.")
x25ClearedCircuitChannel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitChannel.setDescription("The channel number for the circuit that was\ncleared.")
x25ClearedCircuitClearingCause = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitClearingCause.setDescription("The Clearing Cause from the clear request\nor clear indication packet that cleared the\ncircuit.")
x25ClearedCircuitDiagnosticCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitDiagnosticCode.setDescription("The Diagnostic Code from the clear request\nor clear indication packet that cleared the\ncircuit.")
x25ClearedCircuitInPdus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitInPdus.setDescription("The number of PDUs received on the\ncircuit.")
x25ClearedCircuitOutPdus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitOutPdus.setDescription("The number of PDUs transmitted on the\ncircuit.")
x25ClearedCircuitCalledAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 10), X121Address()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitCalledAddress.setDescription("The called address from the cleared\ncircuit.")
x25ClearedCircuitCallingAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 11), X121Address()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitCallingAddress.setDescription("The calling address from the cleared\ncircuit.")
x25ClearedCircuitClearFacilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 8, 1, 12), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 109))).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25ClearedCircuitClearFacilities.setDescription("The facilities field from the clear request\nor clear indication packet that cleared the\ncircuit.  A size of zero indicates no\nfacilities were present.")
x25CallParmTable = MibTable((1, 3, 6, 1, 2, 1, 10, 5, 9))
if mibBuilder.loadTexts: x25CallParmTable.setDescription("These objects contain the parameters that\ncan be varied between X.25 calls.  The\nentries in this table are independent of the\nPLE.  There exists only one of these tables\nfor the entire system.  The indexes for the\nentries are independent of any PLE or any\ncircuit.  Other tables reference entries in\nthis table.  Entries in this table can be\nused for default PLE parameters, for\nparameters to use to place/answer a call,\nfor the parameters currently in use for a\ncircuit, or parameters that were used by a\ncircuit.\n\nThe number of references to a given set of\nparameters can be found in the\nx25CallParmRefCount object sharing the same\ninstance identifier with the parameters.\nThe value of this reference count also\naffects the access of the objects in this\ntable.  An object in this table with the\nsame instance identifier as the instance\nidentifier of an x25CallParmRefCount must be\nconsider associated with that reference\ncount.  An object with an associated\nreference count of zero can be written (if\nits ACCESS clause allows it).  An object\nwith an associated reference count greater\nthan zero can not be written (regardless of\nthe ACCESS clause).  This ensures that a set\nof call parameters being referenced from\nanother table can not be modified or changed\nin a ways inappropriate for continued use by\nthat table.")
x25CallParmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 5, 9, 1)).setIndexNames((0, "RFC1382-MIB", "x25CallParmIndex"))
if mibBuilder.loadTexts: x25CallParmEntry.setDescription("Entries of x25CallParmTable.")
x25CallParmIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 1), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CallParmIndex.setDescription("A value that distinguishes this entry from\nanother entry.  Entries in this table are\nreferenced from other objects which identify\ncall parameters.\n\nIt is impossible to know which other objects\nin the MIB reference entries in the table by\nlooking at this table.  Because of this,\nchanges to parameters must be accomplished\nby creating a new entry in this table and\nthen changing the referencing table to\nidentify the new entry.\n\nNote that an agent will only use the values\nin this table when another table is changed\nto reference those values.  The number of\nother tables that reference an index object\nin this table can be found in\nx25CallParmRefCount.  The value of the\nreference count will affect the writability\nof the objects as explained above.\n\nEntries in this table which have a reference\ncount of zero maybe deleted at the convence\nof the agent.  Care should be taken by the\nagent to give the NMS sufficient time to\ncreate a reference to newly created entries.\n\nShould a Management Station not find a free\nindex with which to create a new entry, it\nmay feel free to delete entries with a\nreference count of zero.  However in doing\nso the Management Station much realize it\nmay impact other Management Stations.")
x25CallParmStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 2), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmStatus.setDescription("The status of this call parameter entry.\nSee RFC 1271 for details of usage.")
x25CallParmRefCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 3), PositiveInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: x25CallParmRefCount.setDescription("The number of references know by a\nmanagement station to exist to this set of\ncall parameters.  This is the number of\nother objects that have returned a value of,\nand will return a value of, the index for\nthis set of call parameters.  Examples of\nsuch objects are the x25AdmnDefCallParamId,\nx25OperDataLinkId, or x25AdmnDefCallParamId\nobjects defined above.")
x25CallParmInPacketSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4096)).clone(128)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmInPacketSize.setDescription("The maximum receive packet size in octets\nfor a circuit.  A size of zero for a circuit\nmeans use the PLE default size.  A size of\nzero for the PLE means use a default size of\n128.")
x25CallParmOutPacketSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4096)).clone(128)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmOutPacketSize.setDescription("The maximum transmit packet size in octets\nfor a circuit.  A size of zero for a circuit\nmeans use the PLE default size.  A size of\nzero for the PLE default means use a default\nsize of 128.")
x25CallParmInWindowSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 127)).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmInWindowSize.setDescription("The receive window size for a circuit.  A\nsize of zero for a circuit means use the PLE\ndefault size.  A size of zero for the PLE\ndefault means use 2.")
x25CallParmOutWindowSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 127)).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmOutWindowSize.setDescription("The transmit window size for a circuit.  A\nsize of zero for a circuit means use the PLE\ndefault size.  A size of zero for the PLE\ndefault means use 2.")
x25CallParmAcceptReverseCharging = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,4,2,)).subtype(namedValues=NamedValues(("default", 1), ("accept", 2), ("refuse", 3), ("neverAccept", 4), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmAcceptReverseCharging.setDescription("An enumeration defining if the PLE will\naccept or refuse charges.  A value of\ndefault for a circuit means use the PLE\ndefault value.  A value of neverAccept is\nonly used for the PLE default and indicates\nthe PLE will never accept reverse charging.\nA value of default for a PLE default means\nrefuse.")
x25CallParmProposeReverseCharging = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("default", 1), ("reverse", 2), ("local", 3), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmProposeReverseCharging.setDescription("An enumeration defining if the PLE should\npropose reverse or local charging.  The\nvalue of default for a circuit means use the\nPLE default.  The value of default for the\nPLE default means use local.")
x25CallParmFastSelect = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(1,6,3,4,5,2,)).subtype(namedValues=NamedValues(("default", 1), ("notSpecified", 2), ("fastSelect", 3), ("restrictedFastResponse", 4), ("noFastSelect", 5), ("noRestrictedFastResponse", 6), )).clone(5)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmFastSelect.setDescription("Expresses preference for use of fast select\nfacility.  The value of default for a\ncircuit is the PLE default.  A value of\ndefault for the PLE means noFastSelect.  A\nvalue of noFastSelect or\nnoRestrictedFastResponse indicates a circuit\nmay not use fast select or restricted fast\nresponse.")
x25CallParmInThruPutClasSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(7,13,5,6,4,17,10,11,8,2,16,1,12,18,14,15,3,9,)).subtype(namedValues=NamedValues(("tcReserved1", 1), ("tc9600", 10), ("tc19200", 11), ("tc48000", 12), ("tc64000", 13), ("tcReserved14", 14), ("tcReserved15", 15), ("tcReserved0", 16), ("tcNone", 17), ("tcDefault", 18), ("tcReserved2", 2), ("tc75", 3), ("tc150", 4), ("tc300", 5), ("tc600", 6), ("tc1200", 7), ("tc2400", 8), ("tc4800", 9), )).clone(17)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmInThruPutClasSize.setDescription("The incoming throughput class to negotiate.\nA value of tcDefault for a circuit means use\nthe PLE default.  A value of tcDefault for\nthe PLE default means tcNone.  A value of\ntcNone means do not negotiate throughtput\nclass.")
x25CallParmOutThruPutClasSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(7,13,5,6,4,17,10,11,8,2,16,1,12,18,14,15,3,9,)).subtype(namedValues=NamedValues(("tcReserved1", 1), ("tc9600", 10), ("tc19200", 11), ("tc48000", 12), ("tc64000", 13), ("tcReserved14", 14), ("tcReserved15", 15), ("tcReserved0", 16), ("tcNone", 17), ("tcDefault", 18), ("tcReserved2", 2), ("tc75", 3), ("tc150", 4), ("tc300", 5), ("tc600", 6), ("tc1200", 7), ("tc2400", 8), ("tc4800", 9), )).clone(17)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmOutThruPutClasSize.setDescription("The outgoing throughput class to negotiate.\nA value of tcDefault for a circuit means use\nthe PLE default.  A value of tcDefault for\nthe PLE default means use tcNone.  A value\nof tcNone means do not negotiate throughtput\nclass.")
x25CallParmCug = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 13), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 4)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCug.setDescription("The Closed User Group to specify.  This\nconsists of two or four octets containing\nthe characters 0 through 9.  A zero length\nstring indicates no facility requested.  A\nstring length of three containing the\ncharacters DEF for a circuit means use the\nPLE default, (the PLE default parameter may\nnot reference an entry of DEF.)")
x25CallParmCugoa = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 14), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 4)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCugoa.setDescription("The Closed User Group with Outgoing Access\nto specify.  This consists of two or four\noctets containing the characters 0 through\n9.  A string length of three containing the\ncharacters DEF for a circuit means use the\nPLE default (the PLE default parameters may\nnot reference an entry of DEF).  A zero\nlength string indicates no facility\nrequested.")
x25CallParmBcug = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 15), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 3)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmBcug.setDescription("The Bilateral Closed User Group to specify.\nThis consists of two octets containing the\ncharacters 0 through 9.  A string length of\nthree containing the characters DEF for a\ncircuit means use the PLE default (the PLE\ndefault parameter may not reference an entry\nof DEF).  A zero length string indicates no\nfacility requested.")
x25CallParmNui = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 108)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmNui.setDescription("The Network User Identifier facility.  This\nis binary value to be included immediately\nafter the length field.  The PLE will supply\nthe length octet.  A zero length string\nindicates no facility requested.  This value\nis ignored for the PLE default parameters\nentry.")
x25CallParmChargingInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 17), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,4,)).subtype(namedValues=NamedValues(("default", 1), ("noFacility", 2), ("noChargingInfo", 3), ("chargingInfo", 4), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmChargingInfo.setDescription("The charging Information facility.  A value\nof default for a circuit means use the PLE\ndefault.  The value of default for the\ndefault PLE parameters means use noFacility.\nThe value of noFacility means do not include\na facility.")
x25CallParmRpoa = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 18), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 108)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmRpoa.setDescription("The RPOA facility.  The octet string\ncontains n * 4 sequences of the characters\n0-9 to specify a facility with n entries.\nThe octet string containing the 3 characters\nDEF for a circuit specifies use of the PLE\ndefault (the entry for the PLE default may\nnot contain DEF).  A zero length string\nindicates no facility requested.")
x25CallParmTrnstDly = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65537)).clone(65536)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmTrnstDly.setDescription("The Transit Delay Selection and Indication\nvalue.  A value of 65536 indicates no\nfacility requested.  A value of 65537 for a\ncircuit means use the PLE default (the PLE\ndefault parameters entry may not use the\nvalue 65537).  The value 65535 may only be\nused to indicate the value in use by a\ncircuit.")
x25CallParmCallingExt = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 20), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 40)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCallingExt.setDescription("The Calling Extension facility.  This\ncontains one of the following:\n\nA sequence of hex digits with the value to\nbe put in the facility. These digits will be\nconverted to binary by the agent and put in\nthe facility.  These octets do not include\nthe length octet.\n\nA value containing the three character DEF\nfor a circuit means use the PLE default,\n(the entry for the PLE default parameters\nmay not use the value DEF).\n\nA zero length string indicates no facility\nrequested.")
x25CallParmCalledExt = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 21), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 40)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCalledExt.setDescription("The Called Extension facility.  This\ncontains one of the following:\n\nA sequence of hex digits with the value to\nbe put in the facility.  These digits will be\nconverted to binary by the agent and put in\nthe facility.  These octets do not include\nthe length octet.\n\nA value containing the three character DEF\nfor a circuit means use the PLE default,\n(the entry for the PLE default parameters\nmay not use the value DEF).\n\nA zero length string indicates no facility\nrequested.")
x25CallParmInMinThuPutCls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 22), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 17)).clone(17)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmInMinThuPutCls.setDescription("The minimum input throughput Class.  A\nvalue of 16 for a circuit means use the PLE\ndefault (the PLE parameters entry may not\nuse this value).  A value of 17 indicates no\nfacility requested.")
x25CallParmOutMinThuPutCls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 17)).clone(17)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmOutMinThuPutCls.setDescription("The minimum output throughput Class.  A\nvalue of 16 for a circuit means use the PLE\ndefault (the PLE parameters entry may not\nuse this value).  A value of 17 indicates no\nfacility requested.")
x25CallParmEndTrnsDly = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 24), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 6)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmEndTrnsDly.setDescription("The End-to-End Transit Delay to negotiate.\nAn octet string of length 2, 4, or 6\ncontains the facility encoded as specified\nin ISO/IEC 8208 section 15.3.2.4.  An octet\nstring of length 3 containing the three\ncharacter DEF for a circuit means use the\nPLE default (the entry for the PLE default\ncan not contain the characters DEF).  A zero\nlength string indicates no facility\nrequested.")
x25CallParmPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 25), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 6)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmPriority.setDescription("The priority facility to negotiate.  The\noctet string encoded as specified in ISO/IEC\n8208 section 15.3.2.5.  A zero length string\nindicates no facility requested.  The entry\nfor the PLE default parameters must be zero\nlength.")
x25CallParmProtection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 26), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 108)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmProtection.setDescription("A string contains the following:\nA hex string containing the value for the\nprotection facility.  This will be converted\nfrom hex to the octets actually in the\npacket by the agent.  The agent will supply\nthe length field and the length octet is not\ncontained in this string.\n\nAn string containing the 3 characters DEF\nfor a circuit means use the PLE default (the\nentry for the PLE default parameters may not\nuse the value DEF).\n\nA zero length string mean no facility\nrequested.")
x25CallParmExptData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 27), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("default", 1), ("noExpeditedData", 2), ("expeditedData", 3), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmExptData.setDescription("The Expedited Data facility to negotiate.\nA value of default for a circuit means use\nthe PLE default value.  The entry for the\nPLE default parameters may not have the\nvalue default.")
x25CallParmUserData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 28), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmUserData.setDescription("The call user data as placed in the packet.\nA zero length string indicates no call user\ndata.  If both the circuit call parameters\nand the PLE default have call user data\ndefined, the data from the circuit call\nparameters will be used.  If only the PLE\nhas data defined, the PLE entry will be\nused.  If neither the circuit call\nparameters or the PLE default entry has a\nvalue, no call user data will be sent.")
x25CallParmCallingNetworkFacilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 29), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 108)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCallingNetworkFacilities.setDescription("The calling network facilities.  The\nfacilities are encoded here exactly as\nencoded in the call packet.  These\nfacilities do not include the marker\nfacility code.\n\nA zero length string in the entry for the\nparameter to use when establishing a circuit\nmeans use the PLE default.  A zero length\nstring in the entry for PLE default\nparameters indicates no default facilities.")
x25CallParmCalledNetworkFacilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 5, 9, 1, 30), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 108)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: x25CallParmCalledNetworkFacilities.setDescription("The called network facilities.  The\nfacilities are encoded here exactly as\nencoded in the call packet.  These\nfacilities do not include the marker\nfacility code.\n\nA zero length string in the entry for the\nparameter to use when establishing a circuit\nmeans use the PLE default.  A zero length\nstring in the entry for PLE default\nparameters indicates no default facilities.")
x25ProtocolVersion = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10))
x25protocolCcittV1976 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 1))
x25protocolCcittV1980 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 2))
x25protocolCcittV1984 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 3))
x25protocolCcittV1988 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 4))
x25protocolIso8208V1987 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 5))
x25protocolIso8208V1989 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 5, 10, 6))

# Augmentions

# Notifications

x25Restart = NotificationType((1, 3, 6, 1, 2, 1, 10, 5, 0, 1)).setObjects(*(("RFC1382-MIB", "x25OperIndex"), ) )
if mibBuilder.loadTexts: x25Restart.setDescription("This trap means the X.25 PLE sent or\nreceived a restart packet.  The restart that\nbrings up the link should not send a\nx25Restart trap so the interface should send\na linkUp trap.  Sending this trap means the\nagent does not send a linkDown and linkUp\ntrap.")
x25Reset = NotificationType((1, 3, 6, 1, 2, 1, 10, 5, 0, 2)).setObjects(*(("RFC1382-MIB", "x25CircuitChannel"), ("RFC1382-MIB", "x25CircuitIndex"), ) )
if mibBuilder.loadTexts: x25Reset.setDescription("If the PLE sends or receives a reset, the\nagent should send an x25Reset trap.")

# Exports

# Types
mibBuilder.exportSymbols("RFC1382-MIB", X121Address=X121Address)

# Objects
mibBuilder.exportSymbols("RFC1382-MIB", x25=x25, x25AdmnTable=x25AdmnTable, x25AdmnEntry=x25AdmnEntry, x25AdmnIndex=x25AdmnIndex, x25AdmnInterfaceMode=x25AdmnInterfaceMode, x25AdmnMaxActiveCircuits=x25AdmnMaxActiveCircuits, x25AdmnPacketSequencing=x25AdmnPacketSequencing, x25AdmnRestartTimer=x25AdmnRestartTimer, x25AdmnCallTimer=x25AdmnCallTimer, x25AdmnResetTimer=x25AdmnResetTimer, x25AdmnClearTimer=x25AdmnClearTimer, x25AdmnWindowTimer=x25AdmnWindowTimer, x25AdmnDataRxmtTimer=x25AdmnDataRxmtTimer, x25AdmnInterruptTimer=x25AdmnInterruptTimer, x25AdmnRejectTimer=x25AdmnRejectTimer, x25AdmnRegistrationRequestTimer=x25AdmnRegistrationRequestTimer, x25AdmnMinimumRecallTimer=x25AdmnMinimumRecallTimer, x25AdmnRestartCount=x25AdmnRestartCount, x25AdmnResetCount=x25AdmnResetCount, x25AdmnClearCount=x25AdmnClearCount, x25AdmnDataRxmtCount=x25AdmnDataRxmtCount, x25AdmnRejectCount=x25AdmnRejectCount, x25AdmnRegistrationRequestCount=x25AdmnRegistrationRequestCount, x25AdmnNumberPVCs=x25AdmnNumberPVCs, x25AdmnDefCallParamId=x25AdmnDefCallParamId, x25AdmnLocalAddress=x25AdmnLocalAddress, x25AdmnProtocolVersionSupported=x25AdmnProtocolVersionSupported, x25OperTable=x25OperTable, x25OperEntry=x25OperEntry, x25OperIndex=x25OperIndex, x25OperInterfaceMode=x25OperInterfaceMode, x25OperMaxActiveCircuits=x25OperMaxActiveCircuits, x25OperPacketSequencing=x25OperPacketSequencing, x25OperRestartTimer=x25OperRestartTimer, x25OperCallTimer=x25OperCallTimer, x25OperResetTimer=x25OperResetTimer, x25OperClearTimer=x25OperClearTimer, x25OperWindowTimer=x25OperWindowTimer, x25OperDataRxmtTimer=x25OperDataRxmtTimer, x25OperInterruptTimer=x25OperInterruptTimer, x25OperRejectTimer=x25OperRejectTimer, x25OperRegistrationRequestTimer=x25OperRegistrationRequestTimer, x25OperMinimumRecallTimer=x25OperMinimumRecallTimer, x25OperRestartCount=x25OperRestartCount, x25OperResetCount=x25OperResetCount, x25OperClearCount=x25OperClearCount, x25OperDataRxmtCount=x25OperDataRxmtCount, x25OperRejectCount=x25OperRejectCount, x25OperRegistrationRequestCount=x25OperRegistrationRequestCount, x25OperNumberPVCs=x25OperNumberPVCs, x25OperDefCallParamId=x25OperDefCallParamId, x25OperLocalAddress=x25OperLocalAddress, x25OperDataLinkId=x25OperDataLinkId, x25OperProtocolVersionSupported=x25OperProtocolVersionSupported, x25StatTable=x25StatTable, x25StatEntry=x25StatEntry, x25StatIndex=x25StatIndex, x25StatInCalls=x25StatInCalls, x25StatInCallRefusals=x25StatInCallRefusals, x25StatInProviderInitiatedClears=x25StatInProviderInitiatedClears, x25StatInRemotelyInitiatedResets=x25StatInRemotelyInitiatedResets, x25StatInProviderInitiatedResets=x25StatInProviderInitiatedResets, x25StatInRestarts=x25StatInRestarts, x25StatInDataPackets=x25StatInDataPackets, x25StatInAccusedOfProtocolErrors=x25StatInAccusedOfProtocolErrors, x25StatInInterrupts=x25StatInInterrupts, x25StatOutCallAttempts=x25StatOutCallAttempts, x25StatOutCallFailures=x25StatOutCallFailures, x25StatOutInterrupts=x25StatOutInterrupts, x25StatOutDataPackets=x25StatOutDataPackets, x25StatOutgoingCircuits=x25StatOutgoingCircuits, x25StatIncomingCircuits=x25StatIncomingCircuits, x25StatTwowayCircuits=x25StatTwowayCircuits, x25StatRestartTimeouts=x25StatRestartTimeouts, x25StatCallTimeouts=x25StatCallTimeouts, x25StatResetTimeouts=x25StatResetTimeouts, x25StatClearTimeouts=x25StatClearTimeouts, x25StatDataRxmtTimeouts=x25StatDataRxmtTimeouts, x25StatInterruptTimeouts=x25StatInterruptTimeouts, x25StatRetryCountExceededs=x25StatRetryCountExceededs, x25StatClearCountExceededs=x25StatClearCountExceededs, x25ChannelTable=x25ChannelTable, x25ChannelEntry=x25ChannelEntry, x25ChannelIndex=x25ChannelIndex, x25ChannelLIC=x25ChannelLIC, x25ChannelHIC=x25ChannelHIC, x25ChannelLTC=x25ChannelLTC, x25ChannelHTC=x25ChannelHTC, x25ChannelLOC=x25ChannelLOC, x25ChannelHOC=x25ChannelHOC, x25CircuitTable=x25CircuitTable, x25CircuitEntry=x25CircuitEntry, x25CircuitIndex=x25CircuitIndex, x25CircuitChannel=x25CircuitChannel, x25CircuitStatus=x25CircuitStatus, x25CircuitEstablishTime=x25CircuitEstablishTime, x25CircuitDirection=x25CircuitDirection, x25CircuitInOctets=x25CircuitInOctets, x25CircuitInPdus=x25CircuitInPdus, x25CircuitInRemotelyInitiatedResets=x25CircuitInRemotelyInitiatedResets, x25CircuitInProviderInitiatedResets=x25CircuitInProviderInitiatedResets, x25CircuitInInterrupts=x25CircuitInInterrupts, x25CircuitOutOctets=x25CircuitOutOctets, x25CircuitOutPdus=x25CircuitOutPdus, x25CircuitOutInterrupts=x25CircuitOutInterrupts, x25CircuitDataRetransmissionTimeouts=x25CircuitDataRetransmissionTimeouts, x25CircuitResetTimeouts=x25CircuitResetTimeouts, x25CircuitInterruptTimeouts=x25CircuitInterruptTimeouts, x25CircuitCallParamId=x25CircuitCallParamId, x25CircuitCalledDteAddress=x25CircuitCalledDteAddress, x25CircuitCallingDteAddress=x25CircuitCallingDteAddress, x25CircuitOriginallyCalledAddress=x25CircuitOriginallyCalledAddress, x25CircuitDescr=x25CircuitDescr, x25ClearedCircuitEntriesRequested=x25ClearedCircuitEntriesRequested, x25ClearedCircuitEntriesGranted=x25ClearedCircuitEntriesGranted, x25ClearedCircuitTable=x25ClearedCircuitTable, x25ClearedCircuitEntry=x25ClearedCircuitEntry, x25ClearedCircuitIndex=x25ClearedCircuitIndex, x25ClearedCircuitPleIndex=x25ClearedCircuitPleIndex, x25ClearedCircuitTimeEstablished=x25ClearedCircuitTimeEstablished, x25ClearedCircuitTimeCleared=x25ClearedCircuitTimeCleared, x25ClearedCircuitChannel=x25ClearedCircuitChannel, x25ClearedCircuitClearingCause=x25ClearedCircuitClearingCause, x25ClearedCircuitDiagnosticCode=x25ClearedCircuitDiagnosticCode, x25ClearedCircuitInPdus=x25ClearedCircuitInPdus, x25ClearedCircuitOutPdus=x25ClearedCircuitOutPdus)
mibBuilder.exportSymbols("RFC1382-MIB", x25ClearedCircuitCalledAddress=x25ClearedCircuitCalledAddress, x25ClearedCircuitCallingAddress=x25ClearedCircuitCallingAddress, x25ClearedCircuitClearFacilities=x25ClearedCircuitClearFacilities, x25CallParmTable=x25CallParmTable, x25CallParmEntry=x25CallParmEntry, x25CallParmIndex=x25CallParmIndex, x25CallParmStatus=x25CallParmStatus, x25CallParmRefCount=x25CallParmRefCount, x25CallParmInPacketSize=x25CallParmInPacketSize, x25CallParmOutPacketSize=x25CallParmOutPacketSize, x25CallParmInWindowSize=x25CallParmInWindowSize, x25CallParmOutWindowSize=x25CallParmOutWindowSize, x25CallParmAcceptReverseCharging=x25CallParmAcceptReverseCharging, x25CallParmProposeReverseCharging=x25CallParmProposeReverseCharging, x25CallParmFastSelect=x25CallParmFastSelect, x25CallParmInThruPutClasSize=x25CallParmInThruPutClasSize, x25CallParmOutThruPutClasSize=x25CallParmOutThruPutClasSize, x25CallParmCug=x25CallParmCug, x25CallParmCugoa=x25CallParmCugoa, x25CallParmBcug=x25CallParmBcug, x25CallParmNui=x25CallParmNui, x25CallParmChargingInfo=x25CallParmChargingInfo, x25CallParmRpoa=x25CallParmRpoa, x25CallParmTrnstDly=x25CallParmTrnstDly, x25CallParmCallingExt=x25CallParmCallingExt, x25CallParmCalledExt=x25CallParmCalledExt, x25CallParmInMinThuPutCls=x25CallParmInMinThuPutCls, x25CallParmOutMinThuPutCls=x25CallParmOutMinThuPutCls, x25CallParmEndTrnsDly=x25CallParmEndTrnsDly, x25CallParmPriority=x25CallParmPriority, x25CallParmProtection=x25CallParmProtection, x25CallParmExptData=x25CallParmExptData, x25CallParmUserData=x25CallParmUserData, x25CallParmCallingNetworkFacilities=x25CallParmCallingNetworkFacilities, x25CallParmCalledNetworkFacilities=x25CallParmCalledNetworkFacilities, x25ProtocolVersion=x25ProtocolVersion, x25protocolCcittV1976=x25protocolCcittV1976, x25protocolCcittV1980=x25protocolCcittV1980, x25protocolCcittV1984=x25protocolCcittV1984, x25protocolCcittV1988=x25protocolCcittV1988, x25protocolIso8208V1987=x25protocolIso8208V1987, x25protocolIso8208V1989=x25protocolIso8208V1989)

# Notifications
mibBuilder.exportSymbols("RFC1382-MIB", x25Restart=x25Restart, x25Reset=x25Reset)

