#
# PySNMP MIB module POLICY-BASED-MANAGEMENT-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/POLICY-BASED-MANAGEMENT-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:23:59 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueSizeConstraint, SingleValueConstraint, ValueRangeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueSizeConstraint", "SingleValueConstraint", "ValueRangeConstraint", "ConstraintsIntersection")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( Integer32, MibScalar, MibTable, MibTableRow, MibTableColumn, Gauge32, IpAddress, ObjectIdentity, ModuleIdentity, mib_2, TimeTicks, Counter64, iso, Unsigned32, Bits, MibIdentifier, Counter32, NotificationType, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Integer32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Gauge32", "IpAddress", "ObjectIdentity", "ModuleIdentity", "mib-2", "TimeTicks", "Counter64", "iso", "Unsigned32", "Bits", "MibIdentifier", "Counter32", "NotificationType")
( DisplayString, RowStatus, TextualConvention, DateAndTime, RowPointer, StorageType, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "RowStatus", "TextualConvention", "DateAndTime", "RowPointer", "StorageType")
pmMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 124)).setRevisions(("2005-02-07 00:00",))
if mibBuilder.loadTexts: pmMib.setLastUpdated('200502070000Z')
if mibBuilder.loadTexts: pmMib.setOrganization('IETF SNMP Configuration Working Group')
if mibBuilder.loadTexts: pmMib.setContactInfo('\n\n\n\n\n        Steve Waldbusser\n        Phone: +1-650-948-6500\n        Fax:   +1-650-745-0671\n        Email: waldbusser@nextbeacon.com\n\n        Jon Saperia (WG Co-chair)\n        JDS Consulting, Inc.\n        84 Kettell Plain Road.\n        Stow MA 01775\n        USA\n        Phone: +1-978-461-0249\n        Fax:   +1-617-249-0874\n        Email: saperia@jdscons.com\n\n        Thippanna Hongal\n        Riverstone Networks, Inc.\n        5200 Great America Parkway\n        Santa Clara, CA, 95054\n        USA\n\n        Phone: +1-408-878-6562\n        Fax:   +1-408-878-6501\n        Email: hongal@riverstonenet.com\n\n        David Partain (WG Co-chair)\n        Postal: Ericsson AB\n                P.O. Box 1248\n                SE-581 12 Linkoping\n                Sweden\n        Tel: +46 13 28 41 44\n        E-mail: David.Partain@ericsson.com\n\n        Any questions or comments about this document can also be\n        directed to the working group at snmpconf@snmp.com.')
if mibBuilder.loadTexts: pmMib.setDescription('The MIB module for policy-based configuration of SNMP\n        infrastructures.\n\n        Copyright (C) The Internet Society (2005).  This version of\n        this MIB module is part of RFC 4011; see the RFC itself for\n        full legal notices.')
class PmUTF8String(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,65535)

pmPolicyTable = MibTable((1, 3, 6, 1, 2, 1, 124, 1), )
if mibBuilder.loadTexts: pmPolicyTable.setDescription('The policy table.  A policy is a pairing of a\n        policyCondition and a policyAction that is used to apply the\n        action to a selected set of elements.')
pmPolicyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 1, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyAdminGroup"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyIndex"))
if mibBuilder.loadTexts: pmPolicyEntry.setDescription('An entry in the policy table representing one policy.')
pmPolicyAdminGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 1), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(0,32)))
if mibBuilder.loadTexts: pmPolicyAdminGroup.setDescription('An administratively assigned string that can be used to group\n        policies for convenience, for readability, or to simplify\n        configuration of access control.\n\n        The value of this string does not affect policy processing in\n        any way.  If grouping is not desired or necessary, this object\n        may be set to a zero-length string.')
pmPolicyIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: pmPolicyIndex.setDescription('A unique index for this policy entry, unique among all\n         policies regardless of administrative group.')
pmPolicyPrecedenceGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 3), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(0,32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyPrecedenceGroup.setDescription('An administratively assigned string that is used to group\n        policies.  For each element, only one policy in the same\n        precedence group may be active on that element.  If multiple\n        policies would be active on an element (because their\n        conditions return non-zero), the execution environment will\n        only allow the policy with the highest value of\n        pmPolicyPrecedence to be active.\n\n        All values of this object must have been successfully\n        transformed by Stringprep RFC 3454.  Management stations\n        must perform this translation and must only set this object to\n        string values that have been transformed.')
pmPolicyPrecedence = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyPrecedence.setDescription("If, while checking to see which policy conditions match an\n        element, 2 or more ready policies in the same precedence group\n        match the same element, the pmPolicyPrecedence object provides\n        the rule to arbitrate which single policy will be active on\n        'this element'.  Of policies in the same precedence group, only\n        the ready and matching policy with the highest precedence\n        value (e.g., 2 is higher than 1) will have its policy action\n        periodically executed on 'this element'.\n\n        When a policy is active on an element but the condition ceases\n        to match the element, its action (if currently running) will\n        be allowed to finish and then the condition-matching ready\n        policy with the next-highest precedence will immediately\n        become active (and have its action run immediately).  If the\n        condition of a higher-precedence ready policy suddenly begins\n        matching an element, the previously-active policy's action (if\n        currently running) will be allowed to finish and then the\n        higher precedence policy will immediately become active.  Its\n        action will run immediately, and any lower-precedence matching\n        policy will not be active anymore.\n\n        In the case where multiple ready policies share the highest\n        value, it is an implementation-dependent matter as to which\n        single policy action will be chosen.\n\n        Note that if it is necessary to take certain actions after a\n        policy is no longer active on an element, these actions should\n        be included in a lower-precedence policy that is in the same\n        precedence group.")
pmPolicySchedule = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicySchedule.setDescription("This policy will be ready if any of the associated schedule\n         entries are active.\n\n         If the value of this object is 0, this policy is always\n         ready.\n\n         If the value of this object is non-zero but doesn't\n         refer to a schedule group that includes an active schedule,\n         then the policy will not be ready, even if this is due to a\n         misconfiguration of this object or the pmSchedTable.")
pmPolicyElementTypeFilter = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 6), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(0,128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyElementTypeFilter.setDescription("This object specifies the element types for which this policy\n        can be executed.\n\n        The format of this object will be a sequence of\n        pmElementTypeRegOIDPrefix values, encoded in the following\n        BNF form:\n\n        elementTypeFilter:   oid [ ';' oid ]*\n                      oid:   subid [ '.' subid ]*\n                    subid:   '0' | decimal_constant\n\n        For example, to register for the policy to be run on all\n        interface elements, the 'ifEntry' element type will be\n        registered as '1.3.6.1.2.1.2.2.1'.\n\n        If a value is included that does not represent a registered\n        pmElementTypeRegOIDPrefix, then that value will be ignored.")
pmPolicyConditionScriptIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyConditionScriptIndex.setDescription("A pointer to the row or rows in the pmPolicyCodeTable that\n         contain the condition code for this policy.  When a policy\n         entry is created, a pmPolicyCodeIndex value unused by this\n         policy's adminGroup will be assigned to this object.\n\n         A policy condition is one or more PolicyScript statements\n         that result(s) in a boolean value that represents whether\n         an element is a member of a set of elements upon which an\n         action is to be performed.  If a policy is ready and the\n         condition returns true for an element of a proper element\n         type, and if no higher-precedence policy should be active,\n         then the policy is active on that element.\n\n         Condition evaluation stops immediately when any run-time\n         exception is detected, and the policyAction is not executed.\n\n         The policyCondition is evaluated for various elements.  Any\n         element for which the policyCondition returns any nonzero value\n         will match the condition and will have the associated\n\n\n\n         policyAction executed on that element unless a\n         higher-precedence policy in the same precedence group also\n         matches 'this element'.\n\n         If the condition object is empty (contains no code) or\n         otherwise does not return a value, the element will not be\n         matched.\n\n         When this condition is executed, if SNMP requests are made to\n         the local system and secModel/secName/secLevel aren't\n         specified, access to objects is under the security\n         credentials of the requester who most recently modified the\n         associated pmPolicyAdminStatus object.  If SNMP requests are\n         made in which secModel/secName/secLevel are specified, then\n         the specified credentials are retrieved from the local\n         configuration datastore only if VACM is configured to\n         allow access to the requester who most recently modified the\n         associated pmPolicyAdminStatus object.  See the Security\n         Considerations section for more information.")
pmPolicyActionScriptIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyActionScriptIndex.setDescription("A pointer to the row or rows in the pmPolicyCodeTable that\n         contain the action code for this policy.  When a policy entry\n         is created, a pmPolicyCodeIndex value unused by this policy's\n         adminGroup will be assigned to this object.\n\n         A PolicyAction is an operation performed on a\n         set of elements for which the policy is active.\n\n         Action evaluation stops immediately when any run-time\n         exception is detected.\n\n         When this condition is executed, if SNMP requests are made to\n         the local system and secModel/secName/secLevel aren't\n         specified, access to objects is under the security\n         credentials of the requester who most recently modified the\n         associated pmPolicyAdminStatus object.  If SNMP requests are\n         made in which secModel/secName/secLevel are specified, then\n         the specified credentials are retrieved from the local\n         configuration datastore only if VACM is configured to\n         allow access to the requester who most recently modified the\n         associated pmPolicyAdminStatus object.  See the Security\n         Considerations section for more information.")
pmPolicyParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyParameters.setDescription('From time to time, policy scripts may seek one or more\n        parameters (e.g., site-specific constants).  These parameters\n        may be installed with the script in this object and are\n        accessible to the script via the getParameters() function.  If\n        it is necessary for multiple parameters to be passed to the\n        script, the script can choose whatever encoding/delimiting\n        mechanism is most appropriate.')
pmPolicyConditionMaxLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyConditionMaxLatency.setDescription('Every element under the control of this agent is\n        re-checked periodically to see whether it is under control\n        of this policy by re-running the condition for this policy.\n        This object lets the manager control the maximum amount of\n        time that may pass before an element is re-checked.\n\n        In other words, in any given interval of this duration, all\n        elements must be re-checked.  Note that how the policy agent\n        schedules the checking of various elements within this\n        interval is an implementation-dependent matter.\n        Implementations may wish to re-run a condition more\n        quickly if they note a change to the role strings for an\n        element.')
pmPolicyActionMaxLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyActionMaxLatency.setDescription("Every element that matches this policy's condition and is\n        therefore under control of this policy will have this policy's\n        action executed periodically to ensure that the element\n        remains in the state dictated by the policy.\n        This object lets the manager control the maximum amount of\n\n\n\n        time that may pass before an element has the action run on\n        it.\n\n        In other words, in any given interval of this duration, all\n        elements under control of this policy must have the action run\n        on them.  Note that how the policy agent schedules the policy\n        action on various elements within this interval is an\n        implementation-dependent matter.")
pmPolicyMaxIterations = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 12), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyMaxIterations.setDescription("If a condition or action script iterates in loops too many\n        times in one invocation, the execution environment may\n        consider it in an infinite loop or otherwise not acting\n        as intended and may be terminated by the execution\n        environment.  The execution environment will count the\n        cumulative number of times all 'for' or 'while' loops iterated\n        and will apply a threshold to determine when to terminate the\n        script.  What threshold the execution environment uses is an\n        implementation-dependent manner, but the value of\n        this object SHOULD be the basis for choosing the threshold for\n        each script.  The value of this object represents a\n        policy-specific threshold and can be tuned for policies of\n        varying workloads.  If this value is zero, no\n        threshold will be enforced except for any\n        implementation-dependent maximum.  Regardless of this value,\n        the agent is allowed to terminate any script invocation that\n        exceeds a local CPU or memory limitation.\n\n        Note that the condition and action invocations are tracked\n        separately.")
pmPolicyDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 13), PmUTF8String()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyDescription.setDescription('A description of this rule and its significance, typically\n         provided by a human.')
pmPolicyMatches = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 14), Gauge32()).setUnits('elements').setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyMatches.setDescription('The number of elements that, in their most recent execution\n         of the associated condition, were matched by the condition.')
pmPolicyAbnormalTerminations = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 15), Gauge32()).setUnits('elements').setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyAbnormalTerminations.setDescription('The number of elements that, in their most recent execution\n         of the associated condition or action, have experienced a\n         run-time exception and terminated abnormally.  Note that if a\n         policy was experiencing a run-time exception while processing\n         a particular element but runs normally on a subsequent\n         invocation, this number can decline.')
pmPolicyExecutionErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 16), Counter32()).setUnits('errors').setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyExecutionErrors.setDescription("The total number of times that execution of this policy's\n         condition or action has been terminated due to run-time\n         exceptions.")
pmPolicyDebugging = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 17), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("off", 1), ("on", 2),)).clone('off')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyDebugging.setDescription('The status of debugging for this policy.  If this is turned\n         on(2), log entries will be created in the pmDebuggingTable\n         for each run-time exception that is experienced by this\n         policy.')
pmPolicyAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 18), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("disabled", 1), ("enabled", 2), ("enabledAutoRemove", 3),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyAdminStatus.setDescription('The administrative status of this policy.\n\n         The policy will be valid only if the associated\n         pmPolicyRowStatus is set to active(1) and this object is set\n         to enabled(2) or enabledAutoRemove(3).\n\n         If this object is set to enabledAutoRemove(3), the next time\n         the associated schedule moves from the active state to the\n         inactive state, this policy will immediately be deleted,\n         including any associated entries in the pmPolicyCodeTable.\n\n         The following related objects may not be changed unless this\n         object is set to disabled(1):\n             pmPolicyPrecedenceGroup, pmPolicyPrecedence,\n             pmPolicySchedule, pmPolicyElementTypeFilter,\n             pmPolicyConditionScriptIndex, pmPolicyActionScriptIndex,\n             pmPolicyParameters, and any pmPolicyCodeTable row\n             referenced by this policy.\n         In order to change any of these parameters, the policy must\n         be moved to the disabled(1) state, changed, and then\n         re-enabled.\n\n         When this policy moves to either enabled state from the\n         disabled state, any cached values of policy condition must be\n         erased, and any Policy or PolicyElement scratchpad values for\n         this policy should be removed.  Policy execution will begin by\n         testing the policy condition on all appropriate elements.')
pmPolicyStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 19), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyStorageType.setDescription("This object defines whether this policy and any associated\n         entries in the pmPolicyCodeTable are kept in volatile storage\n         and lost upon reboot or if this row is backed up by\n         non-volatile or permanent storage.\n\n\n\n\n         If the value of this object is 'permanent', the values for\n         the associated pmPolicyAdminStatus object must remain\n         writable.")
pmPolicyRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 20), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyRowStatus.setDescription('The row status of this pmPolicyEntry.\n\n         The status may not be set to active if any of the related\n         entries in the pmPolicyCode table do not have a status of\n         active or if any of the objects in this row are not set to\n         valid values.  Only the following objects may be modified\n         while in the active state:\n             pmPolicyParameters\n             pmPolicyConditionMaxLatency\n             pmPolicyActionMaxLatency\n             pmPolicyDebugging\n             pmPolicyAdminStatus\n\n         If this row is deleted, any associated entries in the\n         pmPolicyCodeTable will be deleted as well.')
pmPolicyCodeTable = MibTable((1, 3, 6, 1, 2, 1, 124, 2), )
if mibBuilder.loadTexts: pmPolicyCodeTable.setDescription("The pmPolicyCodeTable stores the code for policy conditions and\n        actions.\n\n        An example of the relationships between the code table and the\n        policy table follows:\n\n        pmPolicyTable\n            AdminGroup  Index   ConditionScriptIndex  ActionScriptIndex\n        A   ''          1       1                     2\n        B   'oper'      1       1                     2\n        C   'oper'      2       3                     4\n\n        pmPolicyCodeTable\n        AdminGroup  ScriptIndex  Segment    Note\n\n\n\n        ''          1            1          Filter for policy A\n        ''          2            1          Action for policy A\n        'oper'      1            1          Filter for policy B\n        'oper'      2            1          Action 1/2 for policy B\n        'oper'      2            2          Action 2/2 for policy B\n        'oper'      3            1          Filter for policy C\n        'oper'      4            1          Action for policy C\n\n        In this example, there are 3 policies: 1 in the '' adminGroup,\n        and 2 in the 'oper' adminGroup.  Policy A has been assigned\n        script indexes 1 and 2 (these script indexes are assigned out of\n        a separate pool per adminGroup), with 1 code segment each for\n        the filter and the action.  Policy B has been assigned script\n        indexes 1 and 2 (out of the pool for the 'oper' adminGroup).\n        While the filter has 1 segment, the action is longer and is\n        loaded into 2 segments.  Finally, Policy C has been assigned\n        script indexes 3 and 4, with 1 code segment each for the filter\n        and the action.")
pmPolicyCodeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 2, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyAdminGroup"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyCodeScriptIndex"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyCodeSegment"))
if mibBuilder.loadTexts: pmPolicyCodeEntry.setDescription('An entry in the policy code table representing one code\n        segment.  Entries that share a common AdminGroup/ScriptIndex\n        pair make up a single script.  Valid values of ScriptIndex are\n        retrieved from pmPolicyConditionScriptIndex and\n        pmPolicyActionScriptIndex after a pmPolicyEntry is\n        created.  Segments of code can then be written to this table\n        with the learned ScriptIndex values.\n\n        The StorageType of this entry is determined by the value of\n        the associated pmPolicyStorageType.\n\n        The pmPolicyAdminGroup element of the index represents the\n        administrative group of the policy of which this code entry is\n        a part.')
pmPolicyCodeScriptIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: pmPolicyCodeScriptIndex.setDescription('A unique index for each policy condition or action.  The code\n         for each such condition or action may be composed of multiple\n         entries in this table if the code cannot fit in one entry.\n         Values of pmPolicyCodeScriptIndex may not be used unless\n         they have previously been assigned in the\n         pmPolicyConditionScriptIndex or pmPolicyActionScriptIndex\n         objects.')
pmPolicyCodeSegment = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 2, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: pmPolicyCodeSegment.setDescription('A unique index for each segment of a policy condition or\n         action.\n\n         When a policy condition or action spans multiple entries in\n         this table, the code of that policy starts from the\n         lowest-numbered segment and continues with increasing segment\n         values until it ends with the highest-numbered segment.')
pmPolicyCodeText = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 2, 1, 3), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(1,1024))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyCodeText.setDescription('A segment of policy code (condition or action).  Lengthy\n         Policy conditions or actions may be stored in multiple\n         segments in this table that share the same value of\n         pmPolicyCodeScriptIndex.  When multiple segments are used, it\n         is recommended that each segment be as large as is practical.\n\n         Entries in this table are associated with policies by values\n         of the pmPolicyConditionScriptIndex and\n         pmPolicyActionScriptIndex objects.  If the status of the\n         related policy is active, then this object may not be\n         modified.')
pmPolicyCodeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 2, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyCodeStatus.setDescription('The status of this code entry.\n\n         Entries in this table are associated with policies by values\n         of the pmPolicyConditionScriptIndex and\n         pmPolicyActionScriptIndex objects.  If the status of the\n         related policy is active, then this object can not be\n         modified (i.e., deleted or set to notInService), nor may new\n         entries be created.\n\n         If the status of this object is active, no objects in this\n         row may be modified.')
pmElementTypeRegTable = MibTable((1, 3, 6, 1, 2, 1, 124, 3), )
if mibBuilder.loadTexts: pmElementTypeRegTable.setDescription("A registration table for element types managed by this\n        system.\n\n        The Element Type Registration table allows the manager to\n        learn what element types are being managed by the system and\n        to register new types, if necessary.  An element type is\n        registered by providing the OID of an SNMP object (i.e.,\n        without the instance).  Each SNMP instance that exists under\n        that object is a distinct element.  The index of the element is\n        the index part of the discovered OID.  This index will be\n        supplied to policy conditions and actions so that this code\n        can inspect and configure the element.\n\n        For example, this table might contain the following entries.\n        The first three are agent-installed, and the 4th was\n        downloaded by a management station:\n\n  OIDPrefix        MaxLatency  Description               StorageType\n  ifEntry          100 mS      interfaces - builtin      readOnly\n  0.0              100 mS      system element - builtin  readOnly\n  frCircuitEntry   100 mS      FR Circuits - builtin     readOnly\n  hrSWRunEntry     60 sec      Running Processes         volatile\n\n\n\n\n        Note that agents may automatically configure elements in this\n        table for frequently used element types (interfaces, circuits,\n        etc.).  In particular, it may configure elements for whom\n        discovery is optimized in one or both of the following ways:\n\n        1. The agent may discover elements by scanning internal data\n           structures as opposed to issuing local SNMP requests.  It is\n           possible to recreate the exact semantics described in this\n           table even if local SNMP requests are not issued.\n\n        2. The agent may receive asynchronous notification of new\n           elements (for example, 'card inserted') and use that\n           information to instantly create elements rather than\n           through polling.  A similar feature might be available for\n           the deletion of elements.\n\n        Note that the disposition of agent-installed entries is\n        described by the pmPolicyStorageType object.")
pmElementTypeRegEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 3, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegOIDPrefix"))
if mibBuilder.loadTexts: pmElementTypeRegEntry.setDescription("A registration of an element type.\n\n        Note that some values of this table's index may result in an\n        instance name that exceeds a length of 128 sub-identifiers,\n        which exceeds the maximum for the SNMP protocol.\n        Implementations should take care to avoid such values.")
pmElementTypeRegOIDPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 2), ObjectIdentifier())
if mibBuilder.loadTexts: pmElementTypeRegOIDPrefix.setDescription("This OBJECT IDENTIFIER value identifies a table in which all\n\n\n\n        elements of this type will be found.  Every row in the\n        referenced table will be treated as an element for the\n        period of time that it remains in the table.  The agent will\n        then execute policy conditions and actions as appropriate on\n        each of these elements.\n\n        This object identifier value is specified down to the 'entry'\n        component (e.g., ifEntry) of the identifier.\n\n        The index of each discovered row will be passed to each\n        invocation of the policy condition and policy action.\n\n        The actual mechanism by which instances are discovered is\n        implementation dependent.  Periodic walks of the table to\n        discover the rows in the table is one such mechanism.  This\n        mechanism has the advantage that it can be performed by an\n        agent with no knowledge of the names, syntax, or semantics\n        of the MIB objects in the table.  This mechanism also serves as\n        the reference design.  Other implementation-dependent\n        mechanisms may be implemented that are more efficient (perhaps\n        because they are hard coded) or that don't require polling.\n        These mechanisms must discover the same elements as would the\n        table-walking reference design.\n\n        This object can contain a OBJECT IDENTIFIER, '0.0'.\n        '0.0' represents the single instance of the system\n        itself and provides an execution context for policies to\n        operate on the 'system element' and on MIB objects\n        modeled as scalars.  For example, '0.0' gives an execution\n        context for policy-based selection of the operating system\n        code version (likely modeled as a scalar MIB object).  The\n        element type '0.0' always exists; as a consequence, no actual\n        discovery will take place, and the pmElementTypeRegMaxLatency\n        object will have no effect for the '0.0' element\n        type.  However, if the '0.0' element type is not registered in\n        the table, policies will not be executed on the '0.0' element.\n\n        When a policy is invoked on behalf of a '0.0' entry in this\n        table, the element name will be '0.0', and there is no index\n        of 'this element' (in other words, it has zero length).\n\n        As this object is used in the index for the\n        pmElementTypeRegTable, users of this table should be careful\n        not to create entries that would result in instance names with\n        more than 128 sub-identifiers.")
pmElementTypeRegMaxLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 3), Unsigned32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmElementTypeRegMaxLatency.setDescription('The PM agent is responsible for discovering new elements of\n        types that are registered.  This object lets the manager\n        control the maximum amount of time that may pass between the\n        time an element is created and when it is discovered.\n\n        In other words, in any given interval of this duration, all\n        new elements must be discovered.  Note that how the policy\n        agent schedules the checking of various elements within this\n        interval is an implementation-dependent matter.')
pmElementTypeRegDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 4), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(0,64))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmElementTypeRegDescription.setDescription('A descriptive label for this registered type.')
pmElementTypeRegStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 5), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmElementTypeRegStorageType.setDescription("This object defines whether this row is kept\n         in volatile storage and lost upon reboot or\n         backed up by non-volatile or permanent storage.\n\n         If the value of this object is 'permanent', no values in the\n         associated row have to be writable.")
pmElementTypeRegRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmElementTypeRegRowStatus.setDescription('The status of this registration entry.\n\n        If the value of this object is active, no objects in this row\n        may be modified.')
pmRoleTable = MibTable((1, 3, 6, 1, 2, 1, 124, 4), )
if mibBuilder.loadTexts: pmRoleTable.setDescription("The pmRoleTable is a read-create table that organizes role\n        strings sorted by element.  This table is used to create and\n        modify role strings and their associations, as well as to allow\n        a management station to learn about the existence of roles and\n        their associations.\n\n        It is the responsibility of the agent to keep track of any\n        re-indexing of the underlying SNMP elements and to continue to\n        associate role strings with the element with which they were\n        initially configured.\n\n        Policy MIB agents that have elements in multiple local SNMP\n        contexts have to allow some roles to be assigned to elements\n        in particular contexts.  This is particularly true when some\n        elements have the same names in different contexts and the\n        context is required to disambiguate them.  In those situations,\n        a value for the pmRoleContextName may be provided.  When a\n        pmRoleContextName value is not provided, the assignment is to\n        the element in the default context.\n\n        Policy MIB agents that discover elements on other systems and\n        execute policies on their behalf need to have access to role\n        information for these remote elements.  In such situations,\n        role assignments for other systems can be stored in this table\n        by providing values for the pmRoleContextEngineID parameters.\n\n    For example:\n    Example:\n    element       role    context ctxEngineID   #comment\n    ifindex.1     gold                          local, default context\n    ifindex.2     gold                          local, default context\n    repeaterid.1  foo     rptr1                 local, rptr1 context\n    repeaterid.1  bar     rptr2                 local, rptr2 context\n    ifindex.1     gold    ''      A             different system\n    ifindex.1     gold    ''      B             different system\n\n         The agent must store role string associations in non-volatile\n         storage.")
pmRoleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 4, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmRoleElement"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmRoleContextName"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmRoleContextEngineID"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmRoleString"))
if mibBuilder.loadTexts: pmRoleEntry.setDescription('A role string entry associates a role string with an\n         individual element.\n\n         Note that some combinations of index values may result in an\n         instance name that exceeds a length of 128 sub-identifiers,\n         which exceeds the maximum for the SNMP\n         protocol.  Implementations should take care to avoid such\n         combinations.')
pmRoleElement = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 1), RowPointer())
if mibBuilder.loadTexts: pmRoleElement.setDescription("The element with which this role string is associated.\n\n         For example, if the element is interface 3, then this object\n         will contain the OID for 'ifIndex.3'.\n\n         If the agent assigns new indexes in the MIB table to\n         represent the same underlying element (re-indexing), the\n         agent will modify this value to contain the new index for the\n         underlying element.\n\n         As this object is used in the index for the pmRoleTable,\n         users of this table should be careful not to create entries\n         that would result in instance names with more than 128\n         sub-identifiers.")
pmRoleContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32)))
if mibBuilder.loadTexts: pmRoleContextName.setDescription('If the associated element is not in the default SNMP context\n        for the target system, this object is used to identify the\n        context.  If the element is in the default context, this object\n        is equal to the empty string.')
pmRoleContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 3), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(5,32),)))
if mibBuilder.loadTexts: pmRoleContextEngineID.setDescription('If the associated element is on a remote system, this object\n        is used to identify the remote system.  This object contains\n        the contextEngineID of the system for which this role string\n        assignment is valid.  If the element is on the local system\n        this object will be the empty string.')
pmRoleString = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 4), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(0,64)))
if mibBuilder.loadTexts: pmRoleString.setDescription('The role string that is associated with an element through\n         this table.  All role strings must have been successfully\n         transformed by Stringprep RFC 3454.  Management stations\n         must perform this translation and must only set this object\n         to string values that have been transformed.\n\n         A role string is an administratively specified characteristic\n         of a managed element (for example, an interface).  It is a\n         selector for policy rules, that determines the applicability of\n         the rule to a particular managed element.')
pmRoleStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmRoleStatus.setDescription('The status of this role string.\n\n\n\n\n\n         If the value of this object is active, no object in this row\n         may be modified.')
pmCapabilitiesTable = MibTable((1, 3, 6, 1, 2, 1, 124, 5), )
if mibBuilder.loadTexts: pmCapabilitiesTable.setDescription("The pmCapabilitiesTable contains a description of\n         the inherent capabilities of the system so that\n         management stations can learn of an agent's capabilities and\n         differentially install policies based on the capabilities.\n\n         Capabilities are expressed at the system level.  There can be\n         variation in how capabilities are realized from one vendor or\n         model to the next.  Management systems should consider these\n         differences before selecting which policy to install in a\n         system.")
pmCapabilitiesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 5, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesType"))
if mibBuilder.loadTexts: pmCapabilitiesEntry.setDescription("A capabilities entry holds an OID indicating support for a\n         particular capability.  Capabilities may include hardware and\n         software functions and the implementation of MIB\n         Modules.  The semantics of the OID are defined in the\n         description of pmCapabilitiesType.\n\n         Entries appear in this table if any element in the system has\n         a specific capability.  A capability should appear in this\n         table only once, regardless of the number of elements in the\n         system with that capability.  An entry is removed from this\n         table when the last element in the system that has the\n         capability is removed.  In some cases, capabilities are\n         dynamic and exist only in software.  This table should have an\n         entry for the capability even if there are no current\n         instances.  Examples include systems with database or WEB\n         services.  While the system has the ability to create new\n         databases or WEB services, the entry should exist.  In these\n         cases, the ability to create these services could come from\n         other processes that are running in the system, even though\n         there are no currently open databases or WEB servers running.\n\n\n\n         Capabilities may include the implementation of MIB Modules\n         but need not be limited to those that represent MIB Modules\n         with one or more configurable objects.  It may also be\n         valuable to include entries for capabilities that do not\n         include configuration objects, as that information, in\n         combination with other entries in this table, might be used\n         by the management software to determine whether to\n         install a policy.\n\n         Vendor software may also add entries in this table to express\n         capabilities from their private branch.\n\n         Note that some values of this table's index may result in an\n         instance name that exceeds a length of 128 sub-identifiers,\n         which exceeds the maximum for the SNMP\n         protocol.  Implementations should take care to avoid such\n         values.")
pmCapabilitiesType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 5, 1, 1), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmCapabilitiesType.setDescription("There are three types of OIDs that may be present in the\n         pmCapabilitiesType object:\n\n         1) The OID of a MODULE-COMPLIANCE macro that represents the\n         highest level of compliance realized by the agent for that\n         MIB Module.  For example, an agent that implements the OSPF\n         MIB Module at the highest level of compliance would have the\n         value of '1.3.6.1.2.1.14.15.2' in the pmCapabilitiesType\n         object.  For software that realizes standard MIB\n         Modules that do not have compliance statements, the base OID\n         of the MIB Module should be used instead.  If the OSPF MIB\n         Module had not been created with a compliance statement, then\n         the correct value of the pmCapabilitiesType would be\n         '1.3.6.1.2.1.14'.  In the cases where multiple compliance\n         statements in a MIB Module are supported by the agent, and\n         where one compliance statement does not by definition include\n         the other, each of the compliance OIDs would have entries in\n         this table.\n\n\n\n\n         MIB Documents can contain more than one MIB Module.  In the\n         case of OSPF, there is a second MIB Module\n         that describes notifications for the OSPF Version 2 Protocol.\n         If the agent also realizes these functions, an entry will\n         also exist for those capabilities in this table.\n\n         2) Vendors should install OIDs in this table that represent\n         vendor-specific capabilities.  These capabilities can be\n         expressed just as those described above for MIB Modules on\n         the standards track.  In addition, vendors may install any\n         OID they desire from their registered branch.  The OIDs may be\n         at any level of granularity, from the root of their entire\n         branch to an instance of a single OID.  There is no\n         restriction on the number of registrations they may make,\n         though care should be taken to avoid unnecessary entries.\n\n         3) OIDs that represent one capability or a collection of\n         capabilities that could be any collection of MIB Objects or\n         hardware or software functions may be created in working\n         groups and registered in a MIB Module.  Other entities (e.g.,\n         vendors) may also make registrations.  Software will register\n         these standard capability OIDs, as well as vendor specific\n         OIDs.\n\n         If the OID for a known capability is not present in the\n         table, then it should be assumed that the capability is not\n         implemented.\n\n         As this object is used in the index for the\n         pmCapabilitiesTable, users of this table should be careful\n         not to create entries that would result in instance names\n         with more than 128 sub-identifiers.")
pmCapabilitiesOverrideTable = MibTable((1, 3, 6, 1, 2, 1, 124, 6), )
if mibBuilder.loadTexts: pmCapabilitiesOverrideTable.setDescription('The pmCapabilitiesOverrideTable allows management stations\n         to override pmCapabilitiesTable entries that have been\n         registered by the agent.  This facility can be used to avoid\n         situations in which managers in the network send policies to\n         a system that has advertised a capability in the\n         pmCapabilitiesTable but that should not be installed on this\n         particular system.  One example could be newly deployed\n\n\n\n         equipment that is still in a trial state in a trial state or\n         resources reserved for some other administrative reason.\n         This table can also be used to override entries in the\n         pmCapabilitiesTable through the use of the\n         pmCapabilitiesOverrideState object.  Capabilities can also be\n         declared available in this table that were not registered in\n         the pmCapabilitiesTable.  A management application can make\n         an entry in this table for any valid OID and declare the\n         capability available by setting the\n         pmCapabilitiesOverrideState for that row to valid(1).')
pmCapabilitiesOverrideEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 6, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesOverrideType"))
if mibBuilder.loadTexts: pmCapabilitiesOverrideEntry.setDescription("An entry in this table indicates whether a particular\n         capability is valid or invalid.\n\n         Note that some values of this table's index may result in an\n         instance name that exceeds a length of 128 sub-identifiers,\n         which exceeds the maximum for the SNMP\n         protocol.  Implementations should take care to avoid such\n         values.")
pmCapabilitiesOverrideType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 6, 1, 1), ObjectIdentifier())
if mibBuilder.loadTexts: pmCapabilitiesOverrideType.setDescription('This is the OID of the capability that is declared valid or\n         invalid by the pmCapabilitiesOverrideState value for this\n         row.  Any valid OID, as described in the pmCapabilitiesTable,\n         is permitted in the pmCapabilitiesOverrideType object.  This\n         means that capabilities can be expressed at any level, from a\n         specific instance of an object to a table or entire module.\n         There are no restrictions on whether these objects are from\n         standards track MIB documents or in the private branch of the\n         MIB.\n\n\n\n         If an entry exists in this table for which there is a\n         corresponding entry in the pmCapabilitiesTable, then this entry\n         shall have precedence over the entry in the\n         pmCapabilitiesTable.  All entries in this table must be\n         preserved across reboots.\n\n         As this object is used in the index for the\n         pmCapabilitiesOverrideTable, users of this table should be\n         careful not to create entries that would result in instance\n         names with more than 128 sub-identifiers.')
pmCapabilitiesOverrideState = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 6, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("invalid", 1), ("valid", 2),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmCapabilitiesOverrideState.setDescription('A pmCapabilitiesOverrideState of invalid indicates that\n         management software should not send policies to this system\n         for the capability identified in the\n         pmCapabilitiesOverrideType for this row of the table.  This\n         behavior is the same whether the capability represented by\n         the pmCapabilitiesOverrideType exists only in this table\n         (that is, it was installed by an external management\n         application) or exists in this table as well as the\n         pmCapabilitiesTable.  This would be the case when a manager\n         wanted to disable a capability that the native management\n         system found and registered in the pmCapabilitiesTable.\n\n         An entry in this table that has a pmCapabilitiesOverrideState\n         of valid should be treated as though it appeared in the\n         pmCapabilitiesTable.  If the entry also exists in the\n         pmCapabilitiesTable in the pmCapabilitiesType object, and if\n         the value of this object is valid, then the system shall\n         operate as though this entry did not exist and policy\n         installations and executions will continue in a normal\n         fashion.')
pmCapabilitiesOverrideRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 6, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmCapabilitiesOverrideRowStatus.setDescription('The row status of this pmCapabilitiesOverrideEntry.\n\n\n\n         If the value of this object is active, no object in this row\n         may be modified.')
pmSchedLocalTime = MibScalar((1, 3, 6, 1, 2, 1, 124, 7), DateAndTime().subtype(subtypeSpec=ValueSizeConstraint(11,11)).setFixedLength(11)).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmSchedLocalTime.setDescription('The local time used by the scheduler.  Schedules that\n         refer to calendar time will use the local time indicated\n         by this object.  An implementation MUST return all 11 bytes\n         of the DateAndTime textual-convention so that a manager\n         may retrieve the offset from GMT time.')
pmSchedTable = MibTable((1, 3, 6, 1, 2, 1, 124, 8), )
if mibBuilder.loadTexts: pmSchedTable.setDescription('This table defines schedules for policies.')
pmSchedEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 8, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmSchedIndex"))
if mibBuilder.loadTexts: pmSchedEntry.setDescription('An entry describing a particular schedule.\n\n        Unless noted otherwise, writable objects of this row can be\n        modified independently of the current value of pmSchedRowStatus,\n        pmSchedAdminStatus and pmSchedOperStatus.  In particular, it\n        is legal to modify pmSchedWeekDay, pmSchedMonth, and\n        pmSchedDay when pmSchedRowStatus is active.')
pmSchedIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: pmSchedIndex.setDescription('The locally unique, administratively assigned index for this\n        scheduling entry.')
pmSchedGroupIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedGroupIndex.setDescription('The locally unique, administratively assigned index for the\n        schedule group this scheduling entry belongs to.\n\n        To assign multiple schedule entries to the same group, the\n        pmSchedGroupIndex of each entry in the group will be set to\n        the same value.  This pmSchedGroupIndex value must be equal to\n        the pmSchedIndex of one of the entries in the group.  If the\n        entry whose pmSchedIndex equals the pmSchedGroupIndex\n        for the group is deleted, the agent will assign a new\n        pmSchedGroupIndex to all remaining members of the group.\n\n        If an entry is not a member of a group, its pmSchedGroupIndex\n        must be assigned to the value of its pmSchedIndex.\n\n        Policies that are controlled by a group of schedule entries\n        are active when any schedule in the group is active.')
pmSchedDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 3), PmUTF8String().clone(hexValue="")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedDescr.setDescription('The human-readable description of the purpose of this\n        scheduling entry.')
pmSchedTimePeriod = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 4), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(0,31))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedTimePeriod.setDescription("The overall range of calendar dates and times over which this\n        schedule is active.  It is stored in a slightly extended version\n        of the format for a 'period-explicit' defined in RFC 2445.\n        This format is expressed as a string representing the\n        starting date and time, in which the character 'T' indicates\n        the beginning of the time portion, followed by the solidus\n        character, '/', followed by a similar string representing an\n        end date and time.  The start of the period MUST be before the\n        end of the period.  Date-Time values are expressed as\n        substrings of the form 'yyyymmddThhmmss'.  For example:\n\n            20000101T080000/20000131T130000\n\n              January 1, 2000, 0800 through January 31, 2000, 1PM\n\n        The 'Date with UTC time' format defined in RFC 2445 in which\n        the Date-Time string ends with the character 'Z' is not\n        allowed.\n\n        This 'period-explicit' format is also extended to allow two\n        special cases in which one of the Date-Time strings is\n        replaced with a special string defined in RFC 2445:\n\n        1. If the first Date-Time value is replaced with the string\n           'THISANDPRIOR', then the value indicates that the schedule\n           is active at any time prior to the Date-Time that appears\n           after the '/'.\n\n        2. If the second Date-Time is replaced with the string\n           'THISANDFUTURE', then the value indicates that the schedule\n           is active at any time after the Date-Time that appears\n           before the '/'.\n\n\n\n\n        Note that although RFC 2445 defines these two strings, they are\n        not specified for use in the 'period-explicit' format.  The use\n        of these strings represents an extension to the\n        'period-explicit' format.")
pmSchedMonth = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 5), Bits().clone(namedValues=NamedValues(("january", 0), ("february", 1), ("march", 2), ("april", 3), ("may", 4), ("june", 5), ("july", 6), ("august", 7), ("september", 8), ("october", 9), ("november", 10), ("december", 11),)).clone(namedValues=NamedValues(("january", 0), ("february", 1), ("march", 2), ("april", 3), ("may", 4), ("june", 5), ("july", 6), ("august", 7), ("september", 8), ("october", 9), ("november", 10), ("december", 11),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedMonth.setDescription('Within the overall time period specified in the\n        pmSchedTimePeriod object, the value of this object specifies\n        the specific months within that time period when the schedule\n        is active.  Setting all bits will cause the schedule to act\n        independently of the month.')
pmSchedDay = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 6), Bits().clone(namedValues=NamedValues(("d1", 0), ("d2", 1), ("d3", 2), ("d4", 3), ("d5", 4), ("d6", 5), ("d7", 6), ("d8", 7), ("d9", 8), ("d10", 9), ("d11", 10), ("d12", 11), ("d13", 12), ("d14", 13), ("d15", 14), ("d16", 15), ("d17", 16), ("d18", 17), ("d19", 18), ("d20", 19), ("d21", 20), ("d22", 21), ("d23", 22), ("d24", 23), ("d25", 24), ("d26", 25), ("d27", 26), ("d28", 27), ("d29", 28), ("d30", 29), ("d31", 30), ("r1", 31), ("r2", 32), ("r3", 33), ("r4", 34), ("r5", 35), ("r6", 36), ("r7", 37), ("r8", 38), ("r9", 39), ("r10", 40), ("r11", 41), ("r12", 42), ("r13", 43), ("r14", 44), ("r15", 45), ("r16", 46), ("r17", 47), ("r18", 48), ("r19", 49), ("r20", 50), ("r21", 51), ("r22", 52), ("r23", 53), ("r24", 54), ("r25", 55), ("r26", 56), ("r27", 57), ("r28", 58), ("r29", 59), ("r30", 60), ("r31", 61),)).clone(namedValues=NamedValues(("d1", 0), ("d2", 1), ("d3", 2), ("d4", 3), ("d5", 4), ("d6", 5), ("d7", 6), ("d8", 7), ("d9", 8), ("d10", 9), ("d11", 10), ("d12", 11), ("d13", 12), ("d14", 13), ("d15", 14), ("d16", 15), ("d17", 16), ("d18", 17), ("d19", 18), ("d20", 19), ("d21", 20), ("d22", 21), ("d23", 22), ("d24", 23), ("d25", 24), ("d26", 25), ("d27", 26), ("d28", 27), ("d29", 28), ("d30", 29), ("d31", 30), ("r1", 31), ("r2", 32), ("r3", 33), ("r4", 34), ("r5", 35), ("r6", 36), ("r7", 37), ("r8", 38), ("r9", 39), ("r10", 40), ("r11", 41), ("r12", 42), ("r13", 43), ("r14", 44), ("r15", 45), ("r16", 46), ("r17", 47), ("r18", 48), ("r19", 49), ("r20", 50), ("r21", 51), ("r22", 52), ("r23", 53), ("r24", 54), ("r25", 55), ("r26", 56), ("r27", 57), ("r28", 58), ("r29", 59), ("r30", 60), ("r31", 61),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedDay.setDescription("Within the overall time period specified in the\n        pmSchedTimePeriod object, the value of this object specifies\n        the specific days of the month within that time period when\n        the schedule is active.\n\n        There are two sets of bits one can use to define the day\n        within a month:\n\n        Enumerations starting with the letter 'd' indicate a\n        day in a month relative to the first day of a month.\n        The first day of the month can therefore be specified\n        by setting the bit d1(0), and d31(30) means the last\n        day of a month with 31 days.\n\n        Enumerations starting with the letter 'r' indicate a\n        day in a month in reverse order, relative to the last\n        day of a month.  The last day in the month can therefore\n        be specified by setting the bit r1(31), and r31(61) means\n        the first day of a month with 31 days.\n\n        Setting multiple bits will include several days in the set\n        of possible days for this schedule.  Setting all bits starting\n        with the letter 'd' or all bits starting with the letter 'r'\n        will cause the schedule to act independently of the day of the\n        month.")
pmSchedWeekDay = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 7), Bits().clone(namedValues=NamedValues(("sunday", 0), ("monday", 1), ("tuesday", 2), ("wednesday", 3), ("thursday", 4), ("friday", 5), ("saturday", 6),)).clone(namedValues=NamedValues(("sunday", 0), ("monday", 1), ("tuesday", 2), ("wednesday", 3), ("thursday", 4), ("friday", 5), ("saturday", 6),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedWeekDay.setDescription('Within the overall time period specified in the\n        pmSchedTimePeriod object, the value of this object specifies\n        the specific days of the week within that time period when\n        the schedule is active.  Setting all bits will cause the\n        schedule to act independently of the day of the week.')
pmSchedTimeOfDay = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 8), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(0,15)).clone(hexValue="543030303030302F54323335393539")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedTimeOfDay.setDescription("Within the overall time period specified in the\n        pmSchedTimePeriod object, the value of this object specifies\n        the range of times in a day when the schedule is active.\n\n        This value is stored in a format based on the RFC 2445 format\n        for 'time': The character 'T' followed by a 'time' string,\n        followed by the solidus character, '/', followed by the\n        character 'T', followed by a second time string.  The first time\n        indicates the beginning of the range, and the second time\n        indicates the end.  Thus, this value takes the following\n        form:\n\n            'Thhmmss/Thhmmss'.\n\n        The second substring always identifies a later time than the\n        first substring.  To allow for ranges that span midnight,\n        however, the value of the second string may be smaller than\n        the value of the first substring.  Thus, 'T080000/T210000'\n        identifies the range from 0800 until 2100, whereas\n        'T210000/T080000' identifies the range from 2100 until 0800 of\n        the following day.\n\n        When a range spans midnight, by definition it includes parts\n        of two successive days.  When one of these days is also\n        selected by either the MonthOfYearMask, DayOfMonthMask, and/or\n        DayOfWeekMask, but the other day is not, then the policy is\n        active only during the portion of the range that falls on the\n        selected day.  For example, if the range extends from 2100\n\n\n\n        until 0800, and the day of week mask selects Monday and\n        Tuesday, then the policy is active during the following three\n        intervals:\n\n            From midnight Sunday until 0800 Monday\n            From 2100 Monday until 0800 Tuesday\n            From 2100 Tuesday until 23:59:59 Tuesday\n\n         Setting this value to 'T000000/T235959' will cause the\n         schedule to act independently of the time of day.")
pmSchedLocalOrUtc = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("localTime", 1), ("utcTime", 2),)).clone('utcTime')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedLocalOrUtc.setDescription('This object indicates whether the times represented in the\n        TimePeriod object and in the various Mask objects represent\n        local times or UTC times.')
pmSchedStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 10), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedStorageType.setDescription("This object defines whether this schedule entry is kept\n         in volatile storage and lost upon reboot or\n         backed up by non-volatile or permanent storage.\n\n         Conceptual rows having the value 'permanent' must allow write\n         access to the columnar objects pmSchedDescr, pmSchedWeekDay,\n         pmSchedMonth, and pmSchedDay.\n\n         If the value of this object is 'permanent', no values in the\n         associated row have to be writable.")
pmSchedRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedRowStatus.setDescription('The status of this schedule entry.\n\n         If the value of this object is active, no object in this row\n         may be modified.')
pmTrackingPETable = MibTable((1, 3, 6, 1, 2, 1, 124, 9), )
if mibBuilder.loadTexts: pmTrackingPETable.setDescription('The pmTrackingPETable describes what elements\n         are active (under control of) a policy.  This table is indexed\n         in order to optimize retrieval of the entire status for a\n         given policy.')
pmTrackingPEEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 9, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyIndex"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEElement"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEContextName"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEContextEngineID"))
if mibBuilder.loadTexts: pmTrackingPEEntry.setDescription('An entry in the pmTrackingPETable.  The pmPolicyIndex in\n         the index specifies the policy tracked by this entry.\n\n         Note that some combinations of index values may result in an\n         instance name that exceeds a length of 128 sub-identifiers,\n         which exceeds the maximum for the SNMP\n         protocol.  Implementations should take care to avoid such\n         combinations.')
pmTrackingPEElement = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 9, 1, 1), RowPointer())
if mibBuilder.loadTexts: pmTrackingPEElement.setDescription('The element that is acted upon by the associated policy.\n\n         As this object is used in the index for the\n         pmTrackingPETable, users of this table should be careful not\n         to create entries that would result in instance names with\n         more than 128 sub-identifiers.')
pmTrackingPEContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 9, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32)))
if mibBuilder.loadTexts: pmTrackingPEContextName.setDescription('If the associated element is not in the default SNMP context\n        for the target system, this object is used to identify the\n        context.  If the element is in the default context, this object\n        is equal to the empty string.')
pmTrackingPEContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 9, 1, 3), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(5,32),)))
if mibBuilder.loadTexts: pmTrackingPEContextEngineID.setDescription('If the associated element is on a remote system, this object\n        is used to identify the remote system.  This object contains\n        the contextEngineID of the system on which the associated\n        element resides.  If the element is on the local system,\n        this object will be the empty string.')
pmTrackingPEInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 9, 1, 4), Bits().clone(namedValues=NamedValues(("actionSkippedDueToPrecedence", 0), ("conditionRunTimeException", 1), ("conditionUserSignal", 2), ("actionRunTimeException", 3), ("actionUserSignal", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmTrackingPEInfo.setDescription("This object returns information about the previous policy\n         script executions.\n\n         If the actionSkippedDueToPrecedence(1) bit is set, the last\n         execution of the associated policy condition returned non-zero,\n         but the action is not active, because it was trumped by a\n         matching policy condition in the same precedence group with a\n         higher precedence value.\n\n         If the conditionRunTimeException(2) bit is set, the last\n         execution of the associated policy condition encountered a\n         run-time exception and aborted.\n\n         If the conditionUserSignal(3) bit is set, the last\n         execution of the associated policy condition called the\n         signalError() function.\n\n         If the actionRunTimeException(4) bit is set, the last\n         execution of the associated policy action encountered a\n         run-time exception and aborted.\n\n         If the actionUserSignal(5) bit is set, the last\n         execution of the associated policy action called the\n         signalError() function.\n\n         Entries will only exist in this table of one or more bits are\n         set.  In particular, if an entry does not exist for a\n         particular policy/element combination, it can be assumed that\n         the policy's condition did not match 'this element'.")
pmTrackingEPTable = MibTable((1, 3, 6, 1, 2, 1, 124, 10), )
if mibBuilder.loadTexts: pmTrackingEPTable.setDescription('The pmTrackingEPTable describes what policies\n         are controlling an element.  This table is indexed in\n         order to optimize retrieval of the status of all policies\n         active for a given element.')
pmTrackingEPEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 10, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingEPElement"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingEPContextName"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingEPContextEngineID"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyIndex"))
if mibBuilder.loadTexts: pmTrackingEPEntry.setDescription("An entry in the pmTrackingEPTable.  Entries exist for all\n         element/policy combinations for which the policy's condition\n         matches and only if the schedule for the policy is active.\n\n         The pmPolicyIndex in the index specifies the policy\n         tracked by this entry.\n\n         Note that some combinations of index values may result in an\n         instance name that exceeds a length of 128 sub-identifiers,\n         which exceeds the maximum for the SNMP protocol.\n         Implementations should take care to avoid such combinations.")
pmTrackingEPElement = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 10, 1, 1), RowPointer())
if mibBuilder.loadTexts: pmTrackingEPElement.setDescription('The element acted upon by the associated policy.\n\n         As this object is used in the index for the\n         pmTrackingEPTable, users of this table should be careful\n         not to create entries that would result in instance names\n         with more than 128 sub-identifiers.')
pmTrackingEPContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 10, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32)))
if mibBuilder.loadTexts: pmTrackingEPContextName.setDescription('If the associated element is not in the default SNMP context\n\n\n\n        for the target system, this object is used to identify the\n        context.  If the element is in the default context, this object\n        is equal to the empty string.')
pmTrackingEPContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 10, 1, 3), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(5,32),)))
if mibBuilder.loadTexts: pmTrackingEPContextEngineID.setDescription('If the associated element is on a remote system, this object\n        is used to identify the remote system.  This object contains\n        the contextEngineID of the system on which the associated\n        element resides.  If the element is on the local system,\n        this object will be the empty string.')
pmTrackingEPStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 10, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("on", 1), ("forceOff", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pmTrackingEPStatus.setDescription("This entry will only exist if the calendar for the policy is\n         active and if the associated policyCondition returned 1 for\n         'this element'.\n\n         A policy can be forcibly disabled on a particular element\n         by setting this value to forceOff(2).  The agent should then\n         act as though the policyCondition failed for 'this element'.\n         The forceOff(2) state will persist (even across reboots) until\n         this value is set to on(1) by a management request.  The\n         forceOff(2) state may be set even if the entry does not\n         previously exist so that future policy invocations can be\n         avoided.\n\n         Unless forcibly disabled, if this entry exists, its value\n         will be on(1).")
pmDebuggingTable = MibTable((1, 3, 6, 1, 2, 1, 124, 11), )
if mibBuilder.loadTexts: pmDebuggingTable.setDescription('Policies that have debugging turned on will generate a log\n         entry in the policy debugging table for every runtime\n         exception that occurs in either the condition or action\n         code.\n\n         The pmDebuggingTable logs debugging messages when\n         policies experience run-time exceptions in either the condition\n         or action code and the associated pmPolicyDebugging object\n         has been turned on.\n\n         The maximum number of debugging entries that will be stored\n         and the maximum length of time an entry will be kept are an\n         implementation-dependent manner.  If entries must\n         be discarded to make room for new entries, the oldest entries\n         must be discarded first.\n\n         If the system restarts, all debugging entries may be deleted.')
pmDebuggingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 11, 1), ).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyIndex"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingElement"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingContextName"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingContextEngineID"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingLogIndex"))
if mibBuilder.loadTexts: pmDebuggingEntry.setDescription('An entry in the pmDebuggingTable.  The pmPolicyIndex in the\n         index specifies the policy that encountered the exception\n         that led to this log entry.\n\n         Note that some combinations of index values may result in an\n         instance name that exceeds a length of 128 sub-identifiers,\n         which exceeds the maximum for the SNMP protocol.\n         Implementations should take care to avoid such combinations.')
pmDebuggingElement = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 1), RowPointer())
if mibBuilder.loadTexts: pmDebuggingElement.setDescription("The element the policy was executing on when it encountered\n         the error that led to this log entry.\n\n         For example, if the element is interface 3, then this object\n         will contain the OID for 'ifIndex.3'.\n\n         As this object is used in the index for the\n         pmDebuggingTable, users of this table should be careful\n         not to create entries that would result in instance names\n         with more than 128 sub-identifiers.")
pmDebuggingContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32)))
if mibBuilder.loadTexts: pmDebuggingContextName.setDescription('If the associated element is not in the default SNMP context\n        for the target system, this object is used to identify the\n        context.  If the element is in the default context, this object\n        is equal to the empty string.')
pmDebuggingContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 3), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(5,32),)))
if mibBuilder.loadTexts: pmDebuggingContextEngineID.setDescription('If the associated element is on a remote system, this object\n        is used to identify the remote system.  This object contains\n        the contextEngineID of the system on which the associated\n        element resides.  If the element is on the local system,\n        this object will be the empty string.')
pmDebuggingLogIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: pmDebuggingLogIndex.setDescription('A unique index for this log entry among other log entries\n         for this policy/element combination.')
pmDebuggingMessage = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 5), PmUTF8String().subtype(subtypeSpec=ValueSizeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmDebuggingMessage.setDescription('An error message generated by the policy execution\n         environment.  It is recommended that this message include the\n         time of day when the message was generated, if known.')
pmNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 0))
pmNewRoleNotification = NotificationType((1, 3, 6, 1, 2, 1, 124, 0, 1)).setObjects(*(("POLICY-BASED-MANAGEMENT-MIB", "pmRoleStatus"),))
if mibBuilder.loadTexts: pmNewRoleNotification.setDescription('The pmNewRoleNotification is sent when an agent is configured\n        with its first instance of a previously unused role string\n        (not every time a new element is given a particular role).\n\n        An instance of the pmRoleStatus object is sent containing\n        the new roleString in its index.  In the event that two or\n        more elements are given the same role simultaneously, it is an\n        implementation-dependent matter as to which pmRoleTable\n        instance will be included in the notification.')
pmNewCapabilityNotification = NotificationType((1, 3, 6, 1, 2, 1, 124, 0, 2)).setObjects(*(("POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesType"),))
if mibBuilder.loadTexts: pmNewCapabilityNotification.setDescription('The pmNewCapabilityNotification is sent when an agent\n        gains a new capability that did not previously exist in any\n        element on the system (not every time an element gains a\n        particular capability).\n\n        An instance of the pmCapabilitiesType object is sent containing\n        the identity of the new capability.  In the event that two or\n        more elements gain the same capability simultaneously, it is an\n        implementation-dependent matter as to which pmCapabilitiesType\n        instance will be included in the notification.')
pmAbnormalTermNotification = NotificationType((1, 3, 6, 1, 2, 1, 124, 0, 3)).setObjects(*(("POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEInfo"),))
if mibBuilder.loadTexts: pmAbnormalTermNotification.setDescription("The pmAbnormalTermNotification is sent when a policy's\n        pmPolicyAbnormalTerminations gauge value changes from zero to\n        any value greater than zero and no such notification has been\n        sent for that policy in the last 5 minutes.\n\n        The notification contains an instance of the pmTrackingPEInfo\n        object where the pmPolicyIndex component of the index\n        identifies the associated policy and the rest of the index\n        identifies an element on which the policy failed.")
pmConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 12))
pmCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 12, 1))
pmGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 12, 2))
pmCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 124, 12, 1, 1)).setObjects(*(("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyManagementGroup"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedGroup"), ("POLICY-BASED-MANAGEMENT-MIB", "pmNotificationGroup"),))
if mibBuilder.loadTexts: pmCompliance.setDescription('Describes the requirements for conformance to\n        the Policy-Based Management MIB')
pmPolicyManagementGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 124, 12, 2, 1)).setObjects(*(("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyPrecedenceGroup"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyPrecedence"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicySchedule"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyElementTypeFilter"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyConditionScriptIndex"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyActionScriptIndex"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyParameters"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyConditionMaxLatency"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyActionMaxLatency"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyMaxIterations"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyDescription"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyMatches"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyAbnormalTerminations"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyExecutionErrors"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyDebugging"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyStorageType"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyAdminStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyRowStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyCodeText"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyCodeStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegMaxLatency"), ("POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegDescription"), ("POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegStorageType"), ("POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegRowStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmRoleStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesType"), ("POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesOverrideState"), ("POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesOverrideRowStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEInfo"), ("POLICY-BASED-MANAGEMENT-MIB", "pmTrackingEPStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingMessage"),))
if mibBuilder.loadTexts: pmPolicyManagementGroup.setDescription('Objects that allow for the creation and management of\n        configuration policies.')
pmSchedGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 124, 12, 2, 2)).setObjects(*(("POLICY-BASED-MANAGEMENT-MIB", "pmSchedLocalTime"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedGroupIndex"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedDescr"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedTimePeriod"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedMonth"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedDay"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedWeekDay"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedTimeOfDay"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedLocalOrUtc"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedStorageType"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedRowStatus"),))
if mibBuilder.loadTexts: pmSchedGroup.setDescription('Objects that allow for the scheduling of policies.')
pmNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 124, 12, 2, 3)).setObjects(*(("POLICY-BASED-MANAGEMENT-MIB", "pmNewRoleNotification"), ("POLICY-BASED-MANAGEMENT-MIB", "pmNewCapabilityNotification"), ("POLICY-BASED-MANAGEMENT-MIB", "pmAbnormalTermNotification"),))
if mibBuilder.loadTexts: pmNotificationGroup.setDescription('Notifications sent by an Policy MIB agent.')
pmBaseFunctionLibrary = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 12, 2, 4))
mibBuilder.exportSymbols("POLICY-BASED-MANAGEMENT-MIB", pmRoleString=pmRoleString, pmSchedIndex=pmSchedIndex, pmCapabilitiesOverrideEntry=pmCapabilitiesOverrideEntry, pmPolicyActionMaxLatency=pmPolicyActionMaxLatency, pmSchedTimeOfDay=pmSchedTimeOfDay, pmTrackingPEContextEngineID=pmTrackingPEContextEngineID, pmPolicyDescription=pmPolicyDescription, PmUTF8String=PmUTF8String, pmDebuggingMessage=pmDebuggingMessage, pmElementTypeRegRowStatus=pmElementTypeRegRowStatus, pmDebuggingContextName=pmDebuggingContextName, pmPolicyCodeSegment=pmPolicyCodeSegment, pmPolicyManagementGroup=pmPolicyManagementGroup, pmPolicyMaxIterations=pmPolicyMaxIterations, pmPolicyExecutionErrors=pmPolicyExecutionErrors, pmCompliance=pmCompliance, PYSNMP_MODULE_ID=pmMib, pmPolicyPrecedenceGroup=pmPolicyPrecedenceGroup, pmPolicyMatches=pmPolicyMatches, pmPolicySchedule=pmPolicySchedule, pmNewRoleNotification=pmNewRoleNotification, pmPolicyDebugging=pmPolicyDebugging, pmAbnormalTermNotification=pmAbnormalTermNotification, pmCapabilitiesOverrideState=pmCapabilitiesOverrideState, pmTrackingEPContextName=pmTrackingEPContextName, pmPolicyAdminStatus=pmPolicyAdminStatus, pmSchedEntry=pmSchedEntry, pmSchedLocalTime=pmSchedLocalTime, pmPolicyConditionScriptIndex=pmPolicyConditionScriptIndex, pmCapabilitiesOverrideRowStatus=pmCapabilitiesOverrideRowStatus, pmPolicyCodeStatus=pmPolicyCodeStatus, pmElementTypeRegTable=pmElementTypeRegTable, pmSchedTimePeriod=pmSchedTimePeriod, pmRoleContextName=pmRoleContextName, pmTrackingEPEntry=pmTrackingEPEntry, pmRoleContextEngineID=pmRoleContextEngineID, pmDebuggingElement=pmDebuggingElement, pmDebuggingContextEngineID=pmDebuggingContextEngineID, pmElementTypeRegMaxLatency=pmElementTypeRegMaxLatency, pmPolicyEntry=pmPolicyEntry, pmPolicyElementTypeFilter=pmPolicyElementTypeFilter, pmMib=pmMib, pmSchedDay=pmSchedDay, pmCapabilitiesTable=pmCapabilitiesTable, pmCompliances=pmCompliances, pmPolicyAdminGroup=pmPolicyAdminGroup, pmCapabilitiesOverrideTable=pmCapabilitiesOverrideTable, pmNotifications=pmNotifications, pmTrackingEPStatus=pmTrackingEPStatus, pmTrackingPEElement=pmTrackingPEElement, pmRoleTable=pmRoleTable, pmConformance=pmConformance, pmDebuggingTable=pmDebuggingTable, pmPolicyPrecedence=pmPolicyPrecedence, pmPolicyCodeEntry=pmPolicyCodeEntry, pmSchedTable=pmSchedTable, pmCapabilitiesType=pmCapabilitiesType, pmSchedGroup=pmSchedGroup, pmPolicyCodeText=pmPolicyCodeText, pmRoleStatus=pmRoleStatus, pmTrackingPETable=pmTrackingPETable, pmRoleElement=pmRoleElement, pmSchedWeekDay=pmSchedWeekDay, pmPolicyCodeTable=pmPolicyCodeTable, pmElementTypeRegEntry=pmElementTypeRegEntry, pmTrackingEPTable=pmTrackingEPTable, pmPolicyIndex=pmPolicyIndex, pmElementTypeRegOIDPrefix=pmElementTypeRegOIDPrefix, pmPolicyActionScriptIndex=pmPolicyActionScriptIndex, pmSchedGroupIndex=pmSchedGroupIndex, pmNewCapabilityNotification=pmNewCapabilityNotification, pmDebuggingEntry=pmDebuggingEntry, pmRoleEntry=pmRoleEntry, pmPolicyCodeScriptIndex=pmPolicyCodeScriptIndex, pmSchedStorageType=pmSchedStorageType, pmTrackingEPContextEngineID=pmTrackingEPContextEngineID, pmPolicyTable=pmPolicyTable, pmTrackingPEContextName=pmTrackingPEContextName, pmPolicyStorageType=pmPolicyStorageType, pmSchedLocalOrUtc=pmSchedLocalOrUtc, pmBaseFunctionLibrary=pmBaseFunctionLibrary, pmNotificationGroup=pmNotificationGroup, pmDebuggingLogIndex=pmDebuggingLogIndex, pmGroups=pmGroups, pmCapabilitiesEntry=pmCapabilitiesEntry, pmPolicyAbnormalTerminations=pmPolicyAbnormalTerminations, pmSchedMonth=pmSchedMonth, pmSchedDescr=pmSchedDescr, pmElementTypeRegDescription=pmElementTypeRegDescription, pmPolicyParameters=pmPolicyParameters, pmElementTypeRegStorageType=pmElementTypeRegStorageType, pmPolicyConditionMaxLatency=pmPolicyConditionMaxLatency, pmTrackingEPElement=pmTrackingEPElement, pmPolicyRowStatus=pmPolicyRowStatus, pmTrackingPEInfo=pmTrackingPEInfo, pmSchedRowStatus=pmSchedRowStatus, pmCapabilitiesOverrideType=pmCapabilitiesOverrideType, pmTrackingPEEntry=pmTrackingPEEntry)
