#
# PySNMP MIB module RSVP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/RSVP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:27:32 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, OctetString, Integer, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "OctetString", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueRangeConstraint, ValueSizeConstraint, SingleValueConstraint, ConstraintsIntersection, ConstraintsUnion, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueRangeConstraint", "ValueSizeConstraint", "SingleValueConstraint", "ConstraintsIntersection", "ConstraintsUnion")
( ifIndex, InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex", "InterfaceIndex")
( MessageSize, Port, Protocol, BurstSize, QosService, BitRate, SessionNumber, intSrvFlowStatus, SessionType, ) = mibBuilder.importSymbols("INTEGRATED-SERVICES-MIB", "MessageSize", "Port", "Protocol", "BurstSize", "QosService", "BitRate", "SessionNumber", "intSrvFlowStatus", "SessionType")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( Unsigned32, TimeTicks, ObjectIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, Gauge32, Bits, Counter32, IpAddress, ModuleIdentity, iso, mib_2, Counter64, NotificationType, Integer32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Unsigned32", "TimeTicks", "ObjectIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Gauge32", "Bits", "Counter32", "IpAddress", "ModuleIdentity", "iso", "mib-2", "Counter64", "NotificationType", "Integer32")
( TextualConvention, TestAndIncr, TimeInterval, DisplayString, TimeStamp, RowStatus, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "TestAndIncr", "TimeInterval", "DisplayString", "TimeStamp", "RowStatus", "TruthValue")
rsvp = ModuleIdentity((1, 3, 6, 1, 2, 1, 51))
if mibBuilder.loadTexts: rsvp.setLastUpdated('9511030500Z')
if mibBuilder.loadTexts: rsvp.setOrganization('IETF RSVP Working Group')
if mibBuilder.loadTexts: rsvp.setContactInfo('       Fred Baker\n           Postal: Cisco Systems\n                   519 Lado Drive\n                   Santa Barbara, California 93111\n           Tel:    +1 805 681 0115\n           E-Mail: fred@cisco.com\n\n                   John Krawczyk\n           Postal: ArrowPoint Communications\n                   235 Littleton Road\n                   Westford, Massachusetts 01886\n           Tel:    +1 508 692 5875\n           E-Mail: jjk@tiac.net\n\n                   Arun Sastry\n           Postal: Cisco Systems\n                   210 W. Tasman Drive\n                   San Jose, California 95134\n           Tel:    +1 408 526 7685\n           E-Mail: arun@cisco.com')
if mibBuilder.loadTexts: rsvp.setDescription('The MIB module to describe the RSVP Protocol')
rsvpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 1))
rsvpGenObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 2))
rsvpNotificationsPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 3))
rsvpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 4))
class RsvpEncapsulation(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3,))
    namedValues = NamedValues(("ip", 1), ("udp", 2), ("both", 3),)

class RefreshInterval(Integer32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

rsvpSessionTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 1), )
if mibBuilder.loadTexts: rsvpSessionTable.setDescription('A table of all sessions seen by a  given  sys-\n           tem.')
rsvpSessionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 1, 1), ).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"))
if mibBuilder.loadTexts: rsvpSessionEntry.setDescription('A single session seen by a given system.')
rsvpSessionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 1), SessionNumber())
if mibBuilder.loadTexts: rsvpSessionNumber.setDescription('The number of this session.  This is for  SNMP\n\n           Indexing  purposes  only and has no relation to\n           any protocol value.')
rsvpSessionType = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 2), SessionType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionType.setDescription('The type of session (IP4, IP6, IP6  with  flow\n           information, etc).')
rsvpSessionDestAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionDestAddr.setDescription("The destination address used by all senders in\n           this  session.   This object may not be changed\n           when the value of the RowStatus object is  'ac-\n           tive'.")
rsvpSessionDestAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionDestAddrLength.setDescription("The CIDR prefix length of the session address,\n           which  is  32  for  IP4  host and multicast ad-\n           dresses, and 128 for IP6 addresses.   This  ob-\n           ject  may  not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpSessionProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 5), Protocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionProtocol.setDescription("The IP Protocol used by  this  session.   This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpSessionPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 6), Port()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionPort.setDescription("The UDP or TCP port number used as a  destina-\n           tion  port for all senders in this session.  If\n           the IP protocol in use, specified  by  rsvpSen-\n           derProtocol,  is  50  (ESP)  or  51  (AH), this\n           represents a virtual destination  port  number.\n           A  value of zero indicates that the IP protocol\n           in use does not have ports.   This  object  may\n           not  be changed when the value of the RowStatus\n           object is 'active'.")
rsvpSessionSenders = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionSenders.setDescription('The number of distinct senders currently known\n           to be part of this session.')
rsvpSessionReceivers = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionReceivers.setDescription('The number of reservations being requested  of\n           this system for this session.')
rsvpSessionRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionRequests.setDescription('The number of reservation requests this system\n           is sending upstream for this session.')
rsvpBadPackets = MibScalar((1, 3, 6, 1, 2, 1, 51, 2, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpBadPackets.setDescription('This object keeps a count of the number of bad\n           RSVP packets received.')
rsvpSenderNewIndex = MibScalar((1, 3, 6, 1, 2, 1, 51, 2, 2), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rsvpSenderNewIndex.setDescription("This  object  is  used  to  assign  values  to\n           rsvpSenderNumber  as described in 'Textual Con-\n           ventions  for  SNMPv2'.   The  network  manager\n           reads  the  object,  and  then writes the value\n           back in the SET that creates a new instance  of\n           rsvpSenderEntry.   If  the  SET  fails with the\n           code 'inconsistentValue', then the process must\n           be  repeated; If the SET succeeds, then the ob-\n           ject is incremented, and the  new  instance  is\n           created according to the manager's directions.")
rsvpSenderTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 2), )
if mibBuilder.loadTexts: rsvpSenderTable.setDescription('Information describing the  state  information\n           displayed by senders in PATH messages.')
rsvpSenderEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 2, 1), ).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"), (0, "RSVP-MIB", "rsvpSenderNumber"))
if mibBuilder.loadTexts: rsvpSenderEntry.setDescription("Information describing the  state  information\n           displayed by a single sender's PATH message.")
rsvpSenderNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 1), SessionNumber())
if mibBuilder.loadTexts: rsvpSenderNumber.setDescription('The number of this sender.  This is  for  SNMP\n           Indexing  purposes  only and has no relation to\n           any protocol value.')
rsvpSenderType = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 2), SessionType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderType.setDescription('The type of session (IP4, IP6, IP6  with  flow\n           information, etc).')
rsvpSenderDestAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderDestAddr.setDescription("The destination address used by all senders in\n           this  session.   This object may not be changed\n           when the value of the RowStatus object is  'ac-\n           tive'.")
rsvpSenderAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAddr.setDescription("The source address used by this sender in this\n           session.   This  object may not be changed when\n           the value of the RowStatus object is 'active'.")
rsvpSenderDestAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderDestAddrLength.setDescription("The length of the destination address in bits.\n           This  is  the CIDR Prefix Length, which for IP4\n           hosts and multicast addresses is 32 bits.  This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpSenderAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAddrLength.setDescription("The length of the sender's  address  in  bits.\n           This  is  the CIDR Prefix Length, which for IP4\n           hosts and multicast addresses is 32 bits.  This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpSenderProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 7), Protocol()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderProtocol.setDescription("The IP Protocol used by  this  session.   This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpSenderDestPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 8), Port()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderDestPort.setDescription("The UDP or TCP port number used as a  destina-\n           tion  port for all senders in this session.  If\n           the IP protocol in use, specified  by  rsvpSen-\n           derProtocol,  is  50  (ESP)  or  51  (AH), this\n           represents a virtual destination  port  number.\n           A  value of zero indicates that the IP protocol\n           in use does not have ports.   This  object  may\n           not  be changed when the value of the RowStatus\n           object is 'active'.")
rsvpSenderPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 9), Port()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderPort.setDescription("The UDP or TCP port number used  as  a  source\n           port  for  this sender in this session.  If the\n           IP protocol in use, specified by rsvpSenderPro-\n           tocol is 50 (ESP) or 51 (AH), this represents a\n           generalized port identifier (GPI).  A value  of\n           zero indicates that the IP protocol in use does\n           not have ports.  This object may not be changed\n           when  the value of the RowStatus object is 'ac-\n           tive'.")
rsvpSenderFlowId = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSenderFlowId.setDescription('The flow ID that  this  sender  is  using,  if\n           this  is  an IPv6 session.')
rsvpSenderHopAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 11), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderHopAddr.setDescription('The address used  by  the  previous  RSVP  hop\n           (which may be the original sender).')
rsvpSenderHopLih = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 12), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderHopLih.setDescription('The Logical Interface Handle used by the  pre-\n           vious  RSVP  hop  (which  may  be  the original\n           sender).')
rsvpSenderInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 13), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderInterface.setDescription('The ifIndex value of the  interface  on  which\n           this PATH message was most recently received.')
rsvpSenderTSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 14), BitRate()).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecRate.setDescription("The Average Bit  Rate  of  the  sender's  data\n           stream.   Within  a transmission burst, the ar-\n           rival rate may be as fast  as  rsvpSenderTSpec-\n           PeakRate  (if  supported by the service model);\n           however, averaged across two or more burst  in-\n           tervals,  the  rate  should not exceed rsvpSen-\n           derTSpecRate.\n\n           Note that this is a prediction, often based  on\n           the  general  capability  of a type of codec or\n           particular encoding; the measured average  rate\n           may be significantly lower.")
rsvpSenderTSpecPeakRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 15), BitRate()).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecPeakRate.setDescription("The Peak Bit Rate of the sender's data stream.\n           Traffic  arrival is not expected to exceed this\n           rate at any time, apart  from  the  effects  of\n           jitter in the network.  If not specified in the\n           TSpec, this returns zero or noSuchValue.")
rsvpSenderTSpecBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 16), BurstSize()).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecBurst.setDescription('The size of the largest  burst  expected  from\n           the sender at a time.')
rsvpSenderTSpecMinTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 17), MessageSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecMinTU.setDescription('The minimum message size for  this  flow.  The\n           policing  algorithm will treat smaller messages\n           as though they are this size.')
rsvpSenderTSpecMaxTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 18), MessageSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecMaxTU.setDescription('The maximum message size for  this  flow.  The\n           admission  algorithm  will  reject TSpecs whose\n           Maximum Transmission Unit, plus  the  interface\n           headers, exceed the interface MTU.')
rsvpSenderInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 19), RefreshInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderInterval.setDescription('The interval between refresh messages  as  ad-\n\n           vertised by the Previous Hop.')
rsvpSenderRSVPHop = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 20), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderRSVPHop.setDescription('If TRUE, the node believes that  the  previous\n           IP  hop is an RSVP hop.  If FALSE, the node be-\n           lieves that the previous IP hop may not  be  an\n           RSVP hop.')
rsvpSenderLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 21), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSenderLastChange.setDescription('The time of the last change in this PATH  mes-\n           sage;  This is either the first time it was re-\n           ceived or the time of the most recent change in\n           parameters.')
rsvpSenderPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 22), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,65536))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderPolicy.setDescription('The contents of the policy  object,  displayed\n           as an uninterpreted string of octets, including\n           the object header.  In the absence of  such  an\n           object, this should be of zero length.')
rsvpSenderAdspecBreak = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 23), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecBreak.setDescription('The global break bit general  characterization\n           parameter  from  the ADSPEC.  If TRUE, at least\n           one non-IS hop was detected in  the  path.   If\n\n           FALSE, no non-IS hops were detected.')
rsvpSenderAdspecHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 24), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecHopCount.setDescription('The hop count general characterization parame-\n           ter  from  the  ADSPEC.   A  return  of zero or\n           noSuchValue indicates one of the following con-\n           ditions:\n\n              the invalid bit was set\n              the parameter was not present')
rsvpSenderAdspecPathBw = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 25), BitRate()).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecPathBw.setDescription('The path bandwidth estimate general character-\n           ization parameter from the ADSPEC.  A return of\n           zero or noSuchValue indicates one of  the  fol-\n           lowing conditions:\n\n              the invalid bit was set\n              the parameter was not present')
rsvpSenderAdspecMinLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 26), Integer32()).setUnits('microseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecMinLatency.setDescription('The minimum path latency general characteriza-\n           tion  parameter  from  the ADSPEC.  A return of\n           zero or noSuchValue indicates one of  the  fol-\n           lowing conditions:\n\n              the invalid bit was set\n              the parameter was not present')
rsvpSenderAdspecMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 27), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecMtu.setDescription('The composed Maximum Transmission Unit general\n           characterization  parameter from the ADSPEC.  A\n           return of zero or noSuchValue indicates one  of\n           the following conditions:\n\n              the invalid bit was set\n              the parameter was not present')
rsvpSenderAdspecGuaranteedSvc = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 28), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedSvc.setDescription('If TRUE, the ADSPEC contains a Guaranteed Ser-\n           vice  fragment.   If FALSE, the ADSPEC does not\n           contain a Guaranteed Service fragment.')
rsvpSenderAdspecGuaranteedBreak = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 29), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedBreak.setDescription("If TRUE, the Guaranteed Service  fragment  has\n           its  'break'  bit  set,  indicating that one or\n           more nodes along the path do  not  support  the\n           guaranteed  service.   If  FALSE,  and rsvpSen-\n           derAdspecGuaranteedSvc is TRUE, the 'break' bit\n           is not set.\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n           returns FALSE or noSuchValue.")
rsvpSenderAdspecGuaranteedCtot = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 30), Integer32()).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedCtot.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\n           is   the  end-to-end  composed  value  for  the\n           guaranteed service 'C' parameter.  A return  of\n           zero  or  noSuchValue indicates one of the fol-\n           lowing conditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n           returns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedDtot = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 31), Integer32()).setUnits('microseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedDtot.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\n           is   the  end-to-end  composed  value  for  the\n           guaranteed service 'D' parameter.  A return  of\n           zero  or  noSuchValue indicates one of the fol-\n           lowing conditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n           returns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedCsum = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 32), Integer32()).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedCsum.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\n           is  the  composed value for the guaranteed ser-\n\n           vice 'C' parameter  since  the  last  reshaping\n           point.   A  return of zero or noSuchValue indi-\n           cates one of the following conditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n           returns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedDsum = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 33), Integer32()).setUnits('microseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedDsum.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\n           is  the  composed value for the guaranteed ser-\n           vice 'D' parameter  since  the  last  reshaping\n           point.   A  return of zero or noSuchValue indi-\n           cates one of the following conditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n           returns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 34), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedHopCount.setDescription('If rsvpSenderAdspecGuaranteedSvc is TRUE, this\n           is  the  service-specific  override  of the hop\n           count general characterization  parameter  from\n           the  ADSPEC.   A  return of zero or noSuchValue\n           indicates one of the following conditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n\n           returns zero or noSuchValue.')
rsvpSenderAdspecGuaranteedPathBw = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 35), BitRate()).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedPathBw.setDescription('If rsvpSenderAdspecGuaranteedSvc is TRUE, this\n           is  the  service-specific  override of the path\n           bandwidth  estimate  general   characterization\n           parameter from the ADSPEC.  A return of zero or\n           noSuchValue indicates one of the following con-\n           ditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n           returns zero or noSuchValue.')
rsvpSenderAdspecGuaranteedMinLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 36), Integer32()).setUnits('microseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedMinLatency.setDescription('If rsvpSenderAdspecGuaranteedSvc is TRUE, this\n           is the service-specific override of the minimum\n           path latency general characterization parameter\n           from  the  ADSPEC.  A return of zero or noSuch-\n           Value indicates one  of  the  following  condi-\n           tions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n           returns zero or noSuchValue.')
rsvpSenderAdspecGuaranteedMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 37), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedMtu.setDescription('If rsvpSenderAdspecGuaranteedSvc is TRUE, this\n           is  the  service-specific  override of the com-\n           posed Maximum Transmission Unit general charac-\n           terization parameter from the ADSPEC.  A return\n           of zero or noSuchValue  indicates  one  of  the\n           following conditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecGuaranteedSvc is FALSE, this\n           returns zero or noSuchValue.')
rsvpSenderAdspecCtrlLoadSvc = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 38), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadSvc.setDescription('If TRUE, the ADSPEC contains a Controlled Load\n           Service  fragment.   If  FALSE, the ADSPEC does\n           not contain a  Controlled  Load  Service  frag-\n           ment.')
rsvpSenderAdspecCtrlLoadBreak = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 39), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadBreak.setDescription("If TRUE, the Controlled Load Service  fragment\n           has its 'break' bit set, indicating that one or\n           more nodes along the path do  not  support  the\n           controlled   load   service.    If  FALSE,  and\n           rsvpSenderAdspecCtrlLoadSvc   is   TRUE,    the\n           'break' bit is not set.\n\n           If rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\n           returns FALSE or noSuchValue.")
rsvpSenderAdspecCtrlLoadHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 40), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadHopCount.setDescription('If rsvpSenderAdspecCtrlLoadSvc is  TRUE,  this\n           is  the  service-specific  override  of the hop\n           count general characterization  parameter  from\n           the  ADSPEC.   A  return of zero or noSuchValue\n           indicates one of the following conditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\n           returns zero or noSuchValue.')
rsvpSenderAdspecCtrlLoadPathBw = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 41), BitRate()).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadPathBw.setDescription('If rsvpSenderAdspecCtrlLoadSvc is  TRUE,  this\n           is  the  service-specific  override of the path\n           bandwidth  estimate  general   characterization\n           parameter from the ADSPEC.  A return of zero or\n           noSuchValue indicates one of the following con-\n           ditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\n           returns zero or noSuchValue.')
rsvpSenderAdspecCtrlLoadMinLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 42), Integer32()).setUnits('microseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadMinLatency.setDescription('If rsvpSenderAdspecCtrlLoadSvc is  TRUE,  this\n\n           is the service-specific override of the minimum\n           path latency general characterization parameter\n           from  the  ADSPEC.  A return of zero or noSuch-\n           Value indicates one  of  the  following  condi-\n           tions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\n           returns zero or noSuchValue.')
rsvpSenderAdspecCtrlLoadMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 43), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadMtu.setDescription('If rsvpSenderAdspecCtrlLoadSvc is  TRUE,  this\n           is  the  service-specific  override of the com-\n           posed Maximum Transmission Unit general charac-\n           terization parameter from the ADSPEC.  A return\n           of zero or noSuchValue  indicates  one  of  the\n           following conditions:\n\n              the invalid bit was set\n              the parameter was not present\n\n           If rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\n           returns zero or noSuchValue.')
rsvpSenderStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 44), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderStatus.setDescription("'active' for all active PATH  messages.   This\n           object  may  be used to install static PATH in-\n           formation or delete PATH information.")
rsvpSenderTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 45), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSenderTTL.setDescription('The TTL value in the RSVP header that was last\n           received.')
rsvpSenderOutInterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 3), )
if mibBuilder.loadTexts: rsvpSenderOutInterfaceTable.setDescription('List of outgoing interfaces that PATH messages\n           use.  The  ifIndex  is the ifIndex value of the\n           egress interface.')
rsvpSenderOutInterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 3, 1), ).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"), (0, "RSVP-MIB", "rsvpSenderNumber"), (0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: rsvpSenderOutInterfaceEntry.setDescription('List of outgoing interfaces that a  particular\n           PATH message has.')
rsvpSenderOutInterfaceStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 3, 1, 1), RowStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSenderOutInterfaceStatus.setDescription("'active' for all active PATH messages.")
rsvpResvNewIndex = MibScalar((1, 3, 6, 1, 2, 1, 51, 2, 3), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rsvpResvNewIndex.setDescription("This  object  is  used  to  assign  values  to\n           rsvpResvNumber as described in 'Textual Conven-\n           tions for SNMPv2'.  The network  manager  reads\n           the  object,  and then writes the value back in\n           the  SET  that  creates  a  new   instance   of\n           rsvpResvEntry.   If the SET fails with the code\n           'inconsistentValue', then the process  must  be\n           repeated;  If the SET succeeds, then the object\n           is incremented, and the new instance is created\n           according to the manager's directions.")
rsvpResvTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 4), )
if mibBuilder.loadTexts: rsvpResvTable.setDescription('Information describing the  state  information\n           displayed by receivers in RESV messages.')
rsvpResvEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 4, 1), ).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"), (0, "RSVP-MIB", "rsvpResvNumber"))
if mibBuilder.loadTexts: rsvpResvEntry.setDescription("Information describing the  state  information\n           displayed  by  a single receiver's RESV message\n           concerning a single sender.")
rsvpResvNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 1), SessionNumber())
if mibBuilder.loadTexts: rsvpResvNumber.setDescription('The number of this reservation request.   This\n           is  for  SNMP Indexing purposes only and has no\n           relation to any protocol value.')
rsvpResvType = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 2), SessionType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvType.setDescription('The type of session (IP4, IP6, IP6  with  flow\n           information, etc).')
rsvpResvDestAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvDestAddr.setDescription("The destination address used by all senders in\n           this  session.   This object may not be changed\n           when the value of the RowStatus object is  'ac-\n           tive'.")
rsvpResvSenderAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvSenderAddr.setDescription("The source address of the sender  selected  by\n           this  reservation.  The value of all zeroes in-\n           dicates 'all senders'.  This object may not  be\n           changed  when the value of the RowStatus object\n           is 'active'.")
rsvpResvDestAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvDestAddrLength.setDescription("The length of the destination address in bits.\n           This  is  the CIDR Prefix Length, which for IP4\n           hosts and multicast addresses is 32 bits.  This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpResvSenderAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvSenderAddrLength.setDescription("The length of the sender's  address  in  bits.\n           This  is  the CIDR Prefix Length, which for IP4\n           hosts and multicast addresses is 32 bits.  This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpResvProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 7), Protocol()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvProtocol.setDescription("The IP Protocol used by  this  session.   This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpResvDestPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 8), Port()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvDestPort.setDescription("The UDP or TCP port number used as a  destina-\n           tion  port for all senders in this session.  If\n           the  IP   protocol   in   use,   specified   by\n           rsvpResvProtocol,  is 50 (ESP) or 51 (AH), this\n           represents a virtual destination  port  number.\n           A  value of zero indicates that the IP protocol\n           in use does not have ports.   This  object  may\n           not  be changed when the value of the RowStatus\n           object is 'active'.")
rsvpResvPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 9), Port()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvPort.setDescription("The UDP or TCP port number used  as  a  source\n           port  for  this sender in this session.  If the\n           IP protocol in use, specified by rsvpResvProto-\n           col  is  50 (ESP) or 51 (AH), this represents a\n           generalized port identifier (GPI).  A value  of\n           zero indicates that the IP protocol in use does\n           not have ports.  This object may not be changed\n           when  the value of the RowStatus object is 'ac-\n           tive'.")
rsvpResvHopAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvHopAddr.setDescription('The address used by the next RSVP  hop  (which\n           may be the ultimate receiver).')
rsvpResvHopLih = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 11), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvHopLih.setDescription('The Logical Interface Handle received from the\n           previous  RSVP  hop  (which may be the ultimate\n           receiver).')
rsvpResvInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 12), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvInterface.setDescription('The ifIndex value of the  interface  on  which\n           this RESV message was most recently received.')
rsvpResvService = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 13), QosService()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvService.setDescription('The QoS Service  classification  requested  by\n           the receiver.')
rsvpResvTSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 14), BitRate()).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecRate.setDescription("The Average Bit  Rate  of  the  sender's  data\n\n           stream.   Within  a transmission burst, the ar-\n           rival rate may be  as  fast  as  rsvpResvTSpec-\n           PeakRate  (if  supported by the service model);\n           however, averaged across two or more burst  in-\n           tervals,    the    rate   should   not   exceed\n           rsvpResvTSpecRate.\n\n           Note that this is a prediction, often based  on\n           the  general  capability  of a type of codec or\n           particular encoding; the measured average  rate\n           may be significantly lower.")
rsvpResvTSpecPeakRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 15), BitRate()).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecPeakRate.setDescription("The Peak Bit Rate of the sender's data stream.\n           Traffic  arrival is not expected to exceed this\n           rate at any time, apart  from  the  effects  of\n           jitter in the network.  If not specified in the\n           TSpec, this returns zero or noSuchValue.")
rsvpResvTSpecBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 16), BurstSize()).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecBurst.setDescription("The size of the largest  burst  expected  from\n           the sender at a time.\n\n           If this is less than  the  sender's  advertised\n           burst  size, the receiver is asking the network\n           to provide flow pacing  beyond  what  would  be\n           provided  under normal circumstances. Such pac-\n           ing is at the network's option.")
rsvpResvTSpecMinTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 17), MessageSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecMinTU.setDescription('The minimum message size for  this  flow.  The\n           policing  algorithm will treat smaller messages\n           as though they are this size.')
rsvpResvTSpecMaxTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 18), MessageSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecMaxTU.setDescription('The maximum message size for  this  flow.  The\n           admission  algorithm  will  reject TSpecs whose\n           Maximum Transmission Unit, plus  the  interface\n           headers, exceed the interface MTU.')
rsvpResvRSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 19), BitRate()).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvRSpecRate.setDescription('If the requested  service  is  Guaranteed,  as\n           specified   by  rsvpResvService,  this  is  the\n           clearing rate that is being requested.   Other-\n           wise,  it  is  zero,  or  the  agent may return\n           noSuchValue.')
rsvpResvRSpecSlack = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 20), Integer32()).setUnits('microseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvRSpecSlack.setDescription('If the requested  service  is  Guaranteed,  as\n           specified by rsvpResvService, this is the delay\n           slack.  Otherwise, it is zero, or the agent may\n           return noSuchValue.')
rsvpResvInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 21), RefreshInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvInterval.setDescription('The interval between refresh messages  as  ad-\n           vertised by the Next Hop.')
rsvpResvScope = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 22), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,65536))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvScope.setDescription('The contents of the scope object, displayed as\n           an  uninterpreted  string  of octets, including\n           the object header.  In the absence of  such  an\n           object, this should be of zero length.\n\n           If the length  is  non-zero,  this  contains  a\n           series of IP4 or IP6 addresses.')
rsvpResvShared = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 23), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvShared.setDescription('If TRUE, a reservation shared among senders is\n           requested.  If FALSE, a reservation specific to\n           this sender is requested.')
rsvpResvExplicit = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 24), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvExplicit.setDescription('If TRUE, individual senders are  listed  using\n           Filter  Specifications.   If FALSE, all senders\n           are implicitly selected.  The Scope Object will\n           contain  a list of senders that need to receive\n           this reservation request  for  the  purpose  of\n           routing the RESV message.')
rsvpResvRSVPHop = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 25), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvRSVPHop.setDescription('If TRUE, the node believes that  the  previous\n           IP  hop is an RSVP hop.  If FALSE, the node be-\n           lieves that the previous IP hop may not  be  an\n           RSVP hop.')
rsvpResvLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 26), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvLastChange.setDescription('The time of the last change in  this  reserva-\n           tion  request; This is either the first time it\n           was received or the time  of  the  most  recent\n           change in parameters.')
rsvpResvPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 27), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,65536))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvPolicy.setDescription('The contents of the policy  object,  displayed\n           as an uninterpreted string of octets, including\n           the object header.  In the absence of  such  an\n           object, this should be of zero length.')
rsvpResvStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 28), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvStatus.setDescription("'active' for all active RESV  messages.   This\n           object  may  be used to install static RESV in-\n           formation or delete RESV information.")
rsvpResvTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 29), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvTTL.setDescription('The TTL value in the RSVP header that was last\n           received.')
rsvpResvFlowId = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 30), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFlowId.setDescription('The flow ID that this receiver  is  using,  if\n           this  is  an IPv6 session.')
rsvpResvFwdNewIndex = MibScalar((1, 3, 6, 1, 2, 1, 51, 2, 4), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rsvpResvFwdNewIndex.setDescription("This  object  is  used  to  assign  values  to\n           rsvpResvFwdNumber as described in 'Textual Con-\n           ventions  for  SNMPv2'.   The  network  manager\n           reads  the  object,  and  then writes the value\n           back in the SET that creates a new instance  of\n           rsvpResvFwdEntry.   If  the  SET fails with the\n           code 'inconsistentValue', then the process must\n           be  repeated; If the SET succeeds, then the ob-\n           ject is incremented, and the  new  instance  is\n           created according to the manager's directions.")
rsvpResvFwdTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 5), )
if mibBuilder.loadTexts: rsvpResvFwdTable.setDescription('Information describing the  state  information\n           displayed upstream in RESV messages.')
rsvpResvFwdEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 5, 1), ).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"), (0, "RSVP-MIB", "rsvpResvFwdNumber"))
if mibBuilder.loadTexts: rsvpResvFwdEntry.setDescription('Information describing the  state  information\n           displayed  upstream in an RESV message concern-\n           ing a single sender.')
rsvpResvFwdNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 1), SessionNumber())
if mibBuilder.loadTexts: rsvpResvFwdNumber.setDescription('The number of this reservation request.   This\n           is  for  SNMP Indexing purposes only and has no\n           relation to any protocol value.')
rsvpResvFwdType = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 2), SessionType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdType.setDescription('The type of session (IP4, IP6, IP6  with  flow\n           information, etc).')
rsvpResvFwdDestAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdDestAddr.setDescription("The destination address used by all senders in\n           this  session.   This object may not be changed\n           when the value of the RowStatus object is  'ac-\n           tive'.")
rsvpResvFwdSenderAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdSenderAddr.setDescription("The source address of the sender  selected  by\n           this  reservation.  The value of all zeroes in-\n           dicates 'all senders'.  This object may not  be\n           changed  when the value of the RowStatus object\n           is 'active'.")
rsvpResvFwdDestAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdDestAddrLength.setDescription("The length of the destination address in bits.\n           This  is  the CIDR Prefix Length, which for IP4\n           hosts and multicast addresses is 32 bits.  This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpResvFwdSenderAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdSenderAddrLength.setDescription("The length of the sender's  address  in  bits.\n           This  is  the CIDR Prefix Length, which for IP4\n           hosts and multicast addresses is 32 bits.  This\n           object may not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpResvFwdProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 7), Protocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdProtocol.setDescription("The IP Protocol used by a session. for  secure\n           sessions, this indicates IP Security.  This ob-\n           ject may not be changed when the value  of  the\n           RowStatus object is 'active'.")
rsvpResvFwdDestPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 8), Port()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdDestPort.setDescription("The UDP or TCP port number used as a  destina-\n           tion  port for all senders in this session.  If\n\n           the  IP   protocol   in   use,   specified   by\n           rsvpResvFwdProtocol,  is  50  (ESP) or 51 (AH),\n           this  represents  a  virtual  destination  port\n           number.   A value of zero indicates that the IP\n           protocol in use does not have ports.  This  ob-\n           ject  may  not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpResvFwdPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 9), Port()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdPort.setDescription("The UDP or TCP port number used  as  a  source\n           port  for  this sender in this session.  If the\n           IP    protocol    in    use,    specified    by\n           rsvpResvFwdProtocol  is  50  (ESP)  or 51 (AH),\n           this represents a generalized  port  identifier\n           (GPI).   A  value of zero indicates that the IP\n           protocol in use does not have ports.  This  ob-\n           ject  may  not be changed when the value of the\n           RowStatus object is 'active'.")
rsvpResvFwdHopAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdHopAddr.setDescription('The address of the (previous) RSVP  that  will\n           receive this message.')
rsvpResvFwdHopLih = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 11), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdHopLih.setDescription('The Logical Interface Handle sent to the (pre-\n           vious) RSVP that will receive this message.')
rsvpResvFwdInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 12), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdInterface.setDescription('The ifIndex value of the  interface  on  which\n           this RESV message was most recently sent.')
rsvpResvFwdService = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 13), QosService()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdService.setDescription('The QoS Service classification requested.')
rsvpResvFwdTSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 14), BitRate()).setUnits('bits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecRate.setDescription("The Average Bit  Rate  of  the  sender's  data\n           stream.   Within  a transmission burst, the ar-\n           rival rate may be as fast as  rsvpResvFwdTSpec-\n           PeakRate  (if  supported by the service model);\n           however, averaged across two or more burst  in-\n           tervals,    the    rate   should   not   exceed\n           rsvpResvFwdTSpecRate.\n\n           Note that this is a prediction, often based  on\n           the  general  capability  of a type of codec or\n           particular encoding; the measured average  rate\n           may be significantly lower.")
rsvpResvFwdTSpecPeakRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 15), BitRate()).setUnits('bits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecPeakRate.setDescription("The Peak Bit Rate of the sender's data  stream\n           Traffic  arrival is not expected to exceed this\n           rate at any time, apart  from  the  effects  of\n\n           jitter in the network.  If not specified in the\n           TSpec, this returns zero or noSuchValue.")
rsvpResvFwdTSpecBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 16), BurstSize()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecBurst.setDescription("The size of the largest  burst  expected  from\n           the sender at a time.\n\n           If this is less than  the  sender's  advertised\n           burst  size, the receiver is asking the network\n           to provide flow pacing  beyond  what  would  be\n           provided  under normal circumstances. Such pac-\n           ing is at the network's option.")
rsvpResvFwdTSpecMinTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 17), MessageSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecMinTU.setDescription('The minimum message size for  this  flow.  The\n           policing  algorithm will treat smaller messages\n           as though they are this size.')
rsvpResvFwdTSpecMaxTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 18), MessageSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecMaxTU.setDescription('The maximum message size for  this  flow.  The\n           admission  algorithm  will  reject TSpecs whose\n           Maximum Transmission Unit, plus  the  interface\n           headers, exceed the interface MTU.')
rsvpResvFwdRSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 19), BitRate()).setUnits('bytes per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdRSpecRate.setDescription('If the requested  service  is  Guaranteed,  as\n           specified   by  rsvpResvService,  this  is  the\n           clearing rate that is being requested.   Other-\n           wise,  it  is  zero,  or  the  agent may return\n           noSuchValue.')
rsvpResvFwdRSpecSlack = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 20), Integer32()).setUnits('microseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdRSpecSlack.setDescription('If the requested  service  is  Guaranteed,  as\n           specified by rsvpResvService, this is the delay\n           slack.  Otherwise, it is zero, or the agent may\n           return noSuchValue.')
rsvpResvFwdInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 21), RefreshInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdInterval.setDescription('The interval between refresh  messages  adver-\n           tised to the Previous Hop.')
rsvpResvFwdScope = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 22), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,65536))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdScope.setDescription('The contents of the scope object, displayed as\n           an  uninterpreted  string  of octets, including\n           the object header.  In the absence of  such  an\n           object, this should be of zero length.')
rsvpResvFwdShared = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 23), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdShared.setDescription('If TRUE, a reservation shared among senders is\n           requested.  If FALSE, a reservation specific to\n           this sender is requested.')
rsvpResvFwdExplicit = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 24), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdExplicit.setDescription('If TRUE, individual senders are  listed  using\n           Filter  Specifications.   If FALSE, all senders\n           are implicitly selected.  The Scope Object will\n           contain  a list of senders that need to receive\n           this reservation request  for  the  purpose  of\n           routing the RESV message.')
rsvpResvFwdRSVPHop = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 25), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdRSVPHop.setDescription('If TRUE, the node believes that  the  next  IP\n           hop  is  an  RSVP  hop.  If FALSE, the node be-\n           lieves that the next IP hop may not be an  RSVP\n           hop.')
rsvpResvFwdLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 26), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdLastChange.setDescription('The time of the last change in  this  request;\n           This  is  either  the first time it was sent or\n           the time of the most recent change  in  parame-\n           ters.')
rsvpResvFwdPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 27), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,65536))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdPolicy.setDescription('The contents of the policy  object,  displayed\n           as an uninterpreted string of octets, including\n           the object header.  In the absence of  such  an\n           object, this should be of zero length.')
rsvpResvFwdStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 28), RowStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rsvpResvFwdStatus.setDescription("'active' for all active RESV  messages.   This\n           object may be used to delete RESV information.")
rsvpResvFwdTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 29), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTTL.setDescription('The TTL value in the RSVP header that was last\n           received.')
rsvpResvFwdFlowId = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 30), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdFlowId.setDescription('The flow ID that this receiver  is  using,  if\n           this  is  an IPv6 session.')
rsvpIfTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 6), )
if mibBuilder.loadTexts: rsvpIfTable.setDescription("The RSVP-specific attributes of  the  system's\n           interfaces.")
rsvpIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 6, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: rsvpIfEntry.setDescription('The RSVP-specific attributes of  the  a  given\n           interface.')
rsvpIfUdpNbrs = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpIfUdpNbrs.setDescription('The number of neighbors perceived to be  using\n           only the RSVP UDP Encapsulation.')
rsvpIfIpNbrs = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpIfIpNbrs.setDescription('The number of neighbors perceived to be  using\n           only the RSVP IP Encapsulation.')
rsvpIfNbrs = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpIfNbrs.setDescription('The number of neighbors  currently  perceived;\n           this  will  exceed rsvpIfIpNbrs + rsvpIfUdpNbrs\n           by the number of neighbors using both  encapsu-\n           lations.')
rsvpIfRefreshBlockadeMultiple = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65536)).clone(4)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfRefreshBlockadeMultiple.setDescription("The value of the RSVP value 'Kb', Which is the\n           minimum   number   of  refresh  intervals  that\n           blockade state will last once entered.")
rsvpIfRefreshMultiple = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65536)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfRefreshMultiple.setDescription("The value of the RSVP value 'K', which is  the\n           number  of  refresh intervals which must elapse\n           (minimum) before a PATH or RESV  message  which\n           is not being refreshed will be aged out.")
rsvpIfTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfTTL.setDescription('The value of SEND_TTL used on  this  interface\n           for  messages  this node originates.  If set to\n           zero, the node determines  the  TTL  via  other\n           means.')
rsvpIfRefreshInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 7), TimeInterval().clone(3000)).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfRefreshInterval.setDescription("The value of the RSVP value 'R', which is  the\n           minimum period between refresh transmissions of\n           a given PATH or RESV message on an interface.")
rsvpIfRouteDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 8), TimeInterval().clone(200)).setUnits('hundredths of a second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfRouteDelay.setDescription('The approximate period from the time  a  route\n           is  changed to the time a resulting message ap-\n           pears on the interface.')
rsvpIfEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 9), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfEnabled.setDescription('If TRUE, RSVP is enabled  on  this  Interface.\n           If  FALSE,  RSVP  is not enabled on this inter-\n           face.')
rsvpIfUdpRequired = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 10), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfUdpRequired.setDescription('If TRUE, manual configuration forces  the  use\n           of  UDP  encapsulation  on  the  interface.  If\n           FALSE, UDP encapsulation is only used if rsvpI-\n           fUdpNbrs is not zero.')
rsvpIfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfStatus.setDescription("'active' on interfaces that are configured for\n           RSVP.")
rsvpNbrTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 7), )
if mibBuilder.loadTexts: rsvpNbrTable.setDescription('Information describing  the  Neighbors  of  an\n           RSVP system.')
rsvpNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 7, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "RSVP-MIB", "rsvpNbrAddress"))
if mibBuilder.loadTexts: rsvpNbrEntry.setDescription('Information describing a  single  RSVP  Neigh-\n           bor.')
rsvpNbrAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 7, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,16)))
if mibBuilder.loadTexts: rsvpNbrAddress.setDescription("The IP4 or IP6 Address used by this  neighbor.\n           This  object  may not be changed when the value\n           of the RowStatus object is 'active'.")
rsvpNbrProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 7, 1, 2), RsvpEncapsulation()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpNbrProtocol.setDescription('The encapsulation being used  by  this  neigh-\n           bor.')
rsvpNbrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 7, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpNbrStatus.setDescription("'active' for all neighbors.  This  object  may\n           be  used  to configure neighbors.  In the pres-\n           ence of configured neighbors,  the  implementa-\n           tion may (but is not required to) limit the set\n           of valid neighbors to those configured.")
rsvpNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 3, 0))
newFlow = NotificationType((1, 3, 6, 1, 2, 1, 51, 3, 0, 1)).setObjects(*(("RSVP-MIB", "intSrvFlowStatus"), ("RSVP-MIB", "rsvpSessionDestAddr"), ("RSVP-MIB", "rsvpResvFwdStatus"), ("RSVP-MIB", "rsvpResvStatus"), ("RSVP-MIB", "rsvpSenderStatus"),))
if mibBuilder.loadTexts: newFlow.setDescription('The newFlow trap indicates that the  originat-\n           ing  system  has  installed  a  new flow in its\n           classifier, or (when reservation  authorization\n           is  in view) is prepared to install such a flow\n           in the classifier and is requesting  authoriza-\n           tion.   The objects included with the Notifica-\n           tion may be used to  read  further  information\n           using  the  Integrated  Services and RSVP MIBs.\n           Authorization  or  non-authorization   may   be\n           enacted by a write to the variable intSrvFlowS-\n           tatus.')
lostFlow = NotificationType((1, 3, 6, 1, 2, 1, 51, 3, 0, 2)).setObjects(*(("RSVP-MIB", "intSrvFlowStatus"), ("RSVP-MIB", "rsvpSessionDestAddr"), ("RSVP-MIB", "rsvpResvFwdStatus"), ("RSVP-MIB", "rsvpResvStatus"), ("RSVP-MIB", "rsvpSenderStatus"),))
if mibBuilder.loadTexts: lostFlow.setDescription('The lostFlow trap indicates that the originat-\n           ing system has removed a flow from its classif-\n           ier.')
rsvpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 4, 1))
rsvpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 4, 2))
rsvpCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 51, 4, 2, 1)).setObjects(*(("RSVP-MIB", "rsvpSessionGroup"), ("RSVP-MIB", "rsvpSenderGroup"), ("RSVP-MIB", "rsvpResvGroup"), ("RSVP-MIB", "rsvpIfGroup"), ("RSVP-MIB", "rsvpNbrGroup"), ("RSVP-MIB", "rsvpResvFwdGroup"), ("RSVP-MIB", "rsvpNotificationGroup"),))
if mibBuilder.loadTexts: rsvpCompliance.setDescription('The compliance statement.  Note that  the  im-\n           plementation  of this module requires implemen-\n           tation of the Integrated Services MIB as well.')
rsvpSessionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 1)).setObjects(*(("RSVP-MIB", "rsvpSessionType"), ("RSVP-MIB", "rsvpSessionDestAddr"), ("RSVP-MIB", "rsvpSessionDestAddrLength"), ("RSVP-MIB", "rsvpSessionProtocol"), ("RSVP-MIB", "rsvpSessionPort"), ("RSVP-MIB", "rsvpSessionSenders"), ("RSVP-MIB", "rsvpSessionReceivers"), ("RSVP-MIB", "rsvpSessionRequests"),))
if mibBuilder.loadTexts: rsvpSessionGroup.setDescription('These objects are required for RSVP Systems.')
rsvpSenderGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 2)).setObjects(*(("RSVP-MIB", "rsvpSenderType"), ("RSVP-MIB", "rsvpSenderDestAddr"), ("RSVP-MIB", "rsvpSenderAddr"), ("RSVP-MIB", "rsvpSenderDestAddrLength"), ("RSVP-MIB", "rsvpSenderAddrLength"), ("RSVP-MIB", "rsvpSenderProtocol"), ("RSVP-MIB", "rsvpSenderDestPort"), ("RSVP-MIB", "rsvpSenderPort"), ("RSVP-MIB", "rsvpSenderHopAddr"), ("RSVP-MIB", "rsvpSenderHopLih"), ("RSVP-MIB", "rsvpSenderInterface"), ("RSVP-MIB", "rsvpSenderTSpecRate"), ("RSVP-MIB", "rsvpSenderTSpecPeakRate"), ("RSVP-MIB", "rsvpSenderTSpecBurst"), ("RSVP-MIB", "rsvpSenderTSpecMinTU"), ("RSVP-MIB", "rsvpSenderTSpecMaxTU"), ("RSVP-MIB", "rsvpSenderInterval"), ("RSVP-MIB", "rsvpSenderLastChange"), ("RSVP-MIB", "rsvpSenderStatus"), ("RSVP-MIB", "rsvpSenderRSVPHop"), ("RSVP-MIB", "rsvpSenderPolicy"), ("RSVP-MIB", "rsvpSenderAdspecBreak"), ("RSVP-MIB", "rsvpSenderAdspecHopCount"), ("RSVP-MIB", "rsvpSenderAdspecPathBw"), ("RSVP-MIB", "rsvpSenderAdspecMinLatency"), ("RSVP-MIB", "rsvpSenderAdspecMtu"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedSvc"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedBreak"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedCtot"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedDtot"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedCsum"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedDsum"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedHopCount"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedPathBw"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedMinLatency"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedMtu"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadSvc"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadBreak"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadHopCount"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadPathBw"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadMinLatency"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadMtu"), ("RSVP-MIB", "rsvpSenderNewIndex"),))
if mibBuilder.loadTexts: rsvpSenderGroup.setDescription('These objects are required for RSVP Systems.')
rsvpResvGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 3)).setObjects(*(("RSVP-MIB", "rsvpResvType"), ("RSVP-MIB", "rsvpResvDestAddr"), ("RSVP-MIB", "rsvpResvSenderAddr"), ("RSVP-MIB", "rsvpResvDestAddrLength"), ("RSVP-MIB", "rsvpResvSenderAddrLength"), ("RSVP-MIB", "rsvpResvProtocol"), ("RSVP-MIB", "rsvpResvDestPort"), ("RSVP-MIB", "rsvpResvPort"), ("RSVP-MIB", "rsvpResvHopAddr"), ("RSVP-MIB", "rsvpResvHopLih"), ("RSVP-MIB", "rsvpResvInterface"), ("RSVP-MIB", "rsvpResvService"), ("RSVP-MIB", "rsvpResvTSpecRate"), ("RSVP-MIB", "rsvpResvTSpecBurst"), ("RSVP-MIB", "rsvpResvTSpecPeakRate"), ("RSVP-MIB", "rsvpResvTSpecMinTU"), ("RSVP-MIB", "rsvpResvTSpecMaxTU"), ("RSVP-MIB", "rsvpResvRSpecRate"), ("RSVP-MIB", "rsvpResvRSpecSlack"), ("RSVP-MIB", "rsvpResvInterval"), ("RSVP-MIB", "rsvpResvScope"), ("RSVP-MIB", "rsvpResvShared"), ("RSVP-MIB", "rsvpResvExplicit"), ("RSVP-MIB", "rsvpResvRSVPHop"), ("RSVP-MIB", "rsvpResvLastChange"), ("RSVP-MIB", "rsvpResvPolicy"), ("RSVP-MIB", "rsvpResvStatus"), ("RSVP-MIB", "rsvpResvNewIndex"),))
if mibBuilder.loadTexts: rsvpResvGroup.setDescription('These objects are required for RSVP Systems.')
rsvpResvFwdGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 4)).setObjects(*(("RSVP-MIB", "rsvpResvFwdType"), ("RSVP-MIB", "rsvpResvFwdDestAddr"), ("RSVP-MIB", "rsvpResvFwdSenderAddr"), ("RSVP-MIB", "rsvpResvFwdDestAddrLength"), ("RSVP-MIB", "rsvpResvFwdSenderAddrLength"), ("RSVP-MIB", "rsvpResvFwdProtocol"), ("RSVP-MIB", "rsvpResvFwdDestPort"), ("RSVP-MIB", "rsvpResvFwdPort"), ("RSVP-MIB", "rsvpResvFwdHopAddr"), ("RSVP-MIB", "rsvpResvFwdHopLih"), ("RSVP-MIB", "rsvpResvFwdInterface"), ("RSVP-MIB", "rsvpResvFwdNewIndex"), ("RSVP-MIB", "rsvpResvFwdService"), ("RSVP-MIB", "rsvpResvFwdTSpecPeakRate"), ("RSVP-MIB", "rsvpResvFwdTSpecMinTU"), ("RSVP-MIB", "rsvpResvFwdTSpecMaxTU"), ("RSVP-MIB", "rsvpResvFwdTSpecRate"), ("RSVP-MIB", "rsvpResvFwdTSpecBurst"), ("RSVP-MIB", "rsvpResvFwdRSpecRate"), ("RSVP-MIB", "rsvpResvFwdRSpecSlack"), ("RSVP-MIB", "rsvpResvFwdInterval"), ("RSVP-MIB", "rsvpResvFwdScope"), ("RSVP-MIB", "rsvpResvFwdShared"), ("RSVP-MIB", "rsvpResvFwdExplicit"), ("RSVP-MIB", "rsvpResvFwdRSVPHop"), ("RSVP-MIB", "rsvpResvFwdLastChange"), ("RSVP-MIB", "rsvpResvFwdPolicy"), ("RSVP-MIB", "rsvpResvFwdStatus"),))
if mibBuilder.loadTexts: rsvpResvFwdGroup.setDescription('These objects are optional, used for some RSVP\n           Systems.')
rsvpIfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 6)).setObjects(*(("RSVP-MIB", "rsvpIfUdpNbrs"), ("RSVP-MIB", "rsvpIfIpNbrs"), ("RSVP-MIB", "rsvpIfNbrs"), ("RSVP-MIB", "rsvpIfEnabled"), ("RSVP-MIB", "rsvpIfUdpRequired"), ("RSVP-MIB", "rsvpIfRefreshBlockadeMultiple"), ("RSVP-MIB", "rsvpIfRefreshMultiple"), ("RSVP-MIB", "rsvpIfRefreshInterval"), ("RSVP-MIB", "rsvpIfTTL"), ("RSVP-MIB", "rsvpIfRouteDelay"), ("RSVP-MIB", "rsvpIfStatus"),))
if mibBuilder.loadTexts: rsvpIfGroup.setDescription('These objects are required for RSVP Systems.')
rsvpNbrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 7)).setObjects(*(("RSVP-MIB", "rsvpNbrProtocol"), ("RSVP-MIB", "rsvpNbrStatus"),))
if mibBuilder.loadTexts: rsvpNbrGroup.setDescription('These objects are required for RSVP Systems.')
rsvpNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 8)).setObjects(*(("RSVP-MIB", "newFlow"), ("RSVP-MIB", "lostFlow"),))
if mibBuilder.loadTexts: rsvpNotificationGroup.setDescription('This notification is required for Systems sup-\n           porting  the  RSVP  Policy Module using an SNMP\n           interface to the Policy Manager.')
mibBuilder.exportSymbols("RSVP-MIB", rsvpCompliance=rsvpCompliance, rsvpSessionRequests=rsvpSessionRequests, rsvpSenderTSpecMaxTU=rsvpSenderTSpecMaxTU, rsvpNbrTable=rsvpNbrTable, rsvpNbrProtocol=rsvpNbrProtocol, rsvpResvSenderAddr=rsvpResvSenderAddr, lostFlow=lostFlow, rsvpResvFwdExplicit=rsvpResvFwdExplicit, rsvpNbrEntry=rsvpNbrEntry, rsvpResvType=rsvpResvType, rsvpResvRSpecRate=rsvpResvRSpecRate, rsvpNbrGroup=rsvpNbrGroup, rsvpSenderTable=rsvpSenderTable, rsvpResvNumber=rsvpResvNumber, rsvpResvFwdTSpecMinTU=rsvpResvFwdTSpecMinTU, rsvpResvFwdNewIndex=rsvpResvFwdNewIndex, rsvpSenderAdspecGuaranteedPathBw=rsvpSenderAdspecGuaranteedPathBw, rsvpConformance=rsvpConformance, rsvpSessionPort=rsvpSessionPort, rsvpResvFwdEntry=rsvpResvFwdEntry, rsvpSenderAdspecGuaranteedCtot=rsvpSenderAdspecGuaranteedCtot, rsvpResvFwdTSpecRate=rsvpResvFwdTSpecRate, rsvpSessionReceivers=rsvpSessionReceivers, rsvpSenderInterval=rsvpSenderInterval, rsvpIfRefreshBlockadeMultiple=rsvpIfRefreshBlockadeMultiple, rsvpResvFwdDestAddrLength=rsvpResvFwdDestAddrLength, rsvpResvPort=rsvpResvPort, rsvpSessionTable=rsvpSessionTable, rsvpResvTSpecMinTU=rsvpResvTSpecMinTU, rsvpResvFwdTTL=rsvpResvFwdTTL, rsvpResvFwdInterval=rsvpResvFwdInterval, rsvpSessionGroup=rsvpSessionGroup, rsvpIfTTL=rsvpIfTTL, rsvpIfStatus=rsvpIfStatus, rsvpNbrStatus=rsvpNbrStatus, rsvpSenderLastChange=rsvpSenderLastChange, rsvpResvExplicit=rsvpResvExplicit, rsvpResvFwdSenderAddrLength=rsvpResvFwdSenderAddrLength, rsvpResvFwdDestAddr=rsvpResvFwdDestAddr, rsvpResvStatus=rsvpResvStatus, rsvpResvFwdTSpecMaxTU=rsvpResvFwdTSpecMaxTU, rsvpIfRouteDelay=rsvpIfRouteDelay, rsvpResvScope=rsvpResvScope, rsvpGenObjects=rsvpGenObjects, rsvpSenderTSpecRate=rsvpSenderTSpecRate, rsvpSenderFlowId=rsvpSenderFlowId, rsvpResvDestPort=rsvpResvDestPort, rsvpResvDestAddrLength=rsvpResvDestAddrLength, rsvpResvFwdDestPort=rsvpResvFwdDestPort, rsvpResvFwdRSVPHop=rsvpResvFwdRSVPHop, rsvpSenderAdspecGuaranteedSvc=rsvpSenderAdspecGuaranteedSvc, rsvpResvFwdSenderAddr=rsvpResvFwdSenderAddr, rsvpSenderAdspecCtrlLoadSvc=rsvpSenderAdspecCtrlLoadSvc, rsvpResvFwdPolicy=rsvpResvFwdPolicy, rsvpIfUdpRequired=rsvpIfUdpRequired, rsvpSenderAddrLength=rsvpSenderAddrLength, rsvpGroups=rsvpGroups, rsvpSenderNewIndex=rsvpSenderNewIndex, rsvpSenderRSVPHop=rsvpSenderRSVPHop, rsvpResvFwdNumber=rsvpResvFwdNumber, rsvpResvFwdFlowId=rsvpResvFwdFlowId, rsvpBadPackets=rsvpBadPackets, rsvpSenderInterface=rsvpSenderInterface, rsvpSenderAdspecMtu=rsvpSenderAdspecMtu, rsvpNotifications=rsvpNotifications, rsvpSenderPolicy=rsvpSenderPolicy, rsvpSenderAdspecCtrlLoadPathBw=rsvpSenderAdspecCtrlLoadPathBw, rsvpCompliances=rsvpCompliances, rsvpSenderAdspecGuaranteedDsum=rsvpSenderAdspecGuaranteedDsum, rsvpResvFwdInterface=rsvpResvFwdInterface, rsvpSenderNumber=rsvpSenderNumber, rsvpSenderAdspecCtrlLoadHopCount=rsvpSenderAdspecCtrlLoadHopCount, rsvpSessionDestAddr=rsvpSessionDestAddr, PYSNMP_MODULE_ID=rsvp, rsvpResvFwdPort=rsvpResvFwdPort, rsvpSenderPort=rsvpSenderPort, rsvpResvFwdTable=rsvpResvFwdTable, rsvpResvFwdLastChange=rsvpResvFwdLastChange, rsvpSenderEntry=rsvpSenderEntry, rsvpSenderType=rsvpSenderType, rsvpSenderAdspecHopCount=rsvpSenderAdspecHopCount, rsvpResvFwdScope=rsvpResvFwdScope, rsvpResvTTL=rsvpResvTTL, rsvpResvFwdService=rsvpResvFwdService, rsvpNotificationGroup=rsvpNotificationGroup, rsvpResvDestAddr=rsvpResvDestAddr, rsvpSenderTSpecPeakRate=rsvpSenderTSpecPeakRate, rsvpSenderAdspecGuaranteedHopCount=rsvpSenderAdspecGuaranteedHopCount, rsvpIfTable=rsvpIfTable, rsvpIfEnabled=rsvpIfEnabled, rsvpResvService=rsvpResvService, rsvpSenderDestAddr=rsvpSenderDestAddr, rsvpSenderOutInterfaceTable=rsvpSenderOutInterfaceTable, rsvpSenderDestAddrLength=rsvpSenderDestAddrLength, rsvpSenderAdspecCtrlLoadBreak=rsvpSenderAdspecCtrlLoadBreak, rsvpSenderGroup=rsvpSenderGroup, rsvpResvTSpecRate=rsvpResvTSpecRate, rsvpResvFwdType=rsvpResvFwdType, rsvpResvEntry=rsvpResvEntry, rsvp=rsvp, rsvpSenderAdspecMinLatency=rsvpSenderAdspecMinLatency, rsvpResvFlowId=rsvpResvFlowId, rsvpResvTSpecPeakRate=rsvpResvTSpecPeakRate, rsvpResvTable=rsvpResvTable, rsvpResvLastChange=rsvpResvLastChange, rsvpResvFwdHopAddr=rsvpResvFwdHopAddr, rsvpSenderAdspecBreak=rsvpSenderAdspecBreak, rsvpSessionDestAddrLength=rsvpSessionDestAddrLength, rsvpResvGroup=rsvpResvGroup, rsvpSenderStatus=rsvpSenderStatus, rsvpIfIpNbrs=rsvpIfIpNbrs, rsvpSessionEntry=rsvpSessionEntry, newFlow=newFlow, rsvpNbrAddress=rsvpNbrAddress, rsvpResvFwdRSpecSlack=rsvpResvFwdRSpecSlack, rsvpIfRefreshMultiple=rsvpIfRefreshMultiple, RefreshInterval=RefreshInterval, rsvpResvNewIndex=rsvpResvNewIndex, rsvpSenderOutInterfaceStatus=rsvpSenderOutInterfaceStatus, rsvpResvSenderAddrLength=rsvpResvSenderAddrLength, rsvpSenderAdspecGuaranteedCsum=rsvpSenderAdspecGuaranteedCsum, rsvpResvTSpecBurst=rsvpResvTSpecBurst, rsvpResvFwdShared=rsvpResvFwdShared, rsvpIfUdpNbrs=rsvpIfUdpNbrs, rsvpResvShared=rsvpResvShared, rsvpSessionType=rsvpSessionType, rsvpSessionProtocol=rsvpSessionProtocol, rsvpObjects=rsvpObjects, rsvpSenderDestPort=rsvpSenderDestPort, rsvpIfGroup=rsvpIfGroup, rsvpSenderTSpecMinTU=rsvpSenderTSpecMinTU, rsvpSenderTSpecBurst=rsvpSenderTSpecBurst, rsvpResvFwdHopLih=rsvpResvFwdHopLih, rsvpIfRefreshInterval=rsvpIfRefreshInterval, RsvpEncapsulation=RsvpEncapsulation, rsvpResvFwdStatus=rsvpResvFwdStatus, rsvpResvFwdProtocol=rsvpResvFwdProtocol, rsvpResvRSpecSlack=rsvpResvRSpecSlack, rsvpSenderAdspecGuaranteedBreak=rsvpSenderAdspecGuaranteedBreak, rsvpResvProtocol=rsvpResvProtocol, rsvpSenderAdspecCtrlLoadMtu=rsvpSenderAdspecCtrlLoadMtu, rsvpSenderTTL=rsvpSenderTTL, rsvpResvHopLih=rsvpResvHopLih, rsvpResvPolicy=rsvpResvPolicy, rsvpSenderHopAddr=rsvpSenderHopAddr, rsvpResvRSVPHop=rsvpResvRSVPHop, rsvpSenderOutInterfaceEntry=rsvpSenderOutInterfaceEntry, rsvpNotificationsPrefix=rsvpNotificationsPrefix, rsvpResvFwdRSpecRate=rsvpResvFwdRSpecRate, rsvpSenderAdspecGuaranteedMtu=rsvpSenderAdspecGuaranteedMtu, rsvpSenderAdspecCtrlLoadMinLatency=rsvpSenderAdspecCtrlLoadMinLatency, rsvpSenderAdspecGuaranteedDtot=rsvpSenderAdspecGuaranteedDtot, rsvpSessionNumber=rsvpSessionNumber, rsvpSessionSenders=rsvpSessionSenders, rsvpSenderHopLih=rsvpSenderHopLih, rsvpSenderAdspecPathBw=rsvpSenderAdspecPathBw, rsvpResvFwdTSpecPeakRate=rsvpResvFwdTSpecPeakRate, rsvpIfEntry=rsvpIfEntry, rsvpResvFwdTSpecBurst=rsvpResvFwdTSpecBurst, rsvpSenderAdspecGuaranteedMinLatency=rsvpSenderAdspecGuaranteedMinLatency, rsvpResvTSpecMaxTU=rsvpResvTSpecMaxTU, rsvpResvFwdGroup=rsvpResvFwdGroup, rsvpResvInterval=rsvpResvInterval, rsvpIfNbrs=rsvpIfNbrs, rsvpResvInterface=rsvpResvInterface, rsvpSenderAddr=rsvpSenderAddr, rsvpSenderProtocol=rsvpSenderProtocol, rsvpResvHopAddr=rsvpResvHopAddr)
