#
# PySNMP MIB module TE-LINK-STD-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/TE-LINK-STD-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:19:51 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, OctetString, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "Integer", "OctetString", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, SingleValueConstraint, ValueSizeConstraint, ConstraintsIntersection, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsIntersection", "ValueRangeConstraint")
( InterfaceIndexOrZero, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero", "ifIndex")
( InetAddressType, InetAddress, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddressType", "InetAddress")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( MibScalar, MibTable, MibTableRow, MibTableColumn, iso, Unsigned32, ModuleIdentity, Bits, Counter32, Counter64, ObjectIdentity, transmission, TimeTicks, NotificationType, Gauge32, MibIdentifier, IpAddress, Integer32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "iso", "Unsigned32", "ModuleIdentity", "Bits", "Counter32", "Counter64", "ObjectIdentity", "transmission", "TimeTicks", "NotificationType", "Gauge32", "MibIdentifier", "IpAddress", "Integer32")
( RowStatus, DisplayString, TextualConvention, StorageType, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "DisplayString", "TextualConvention", "StorageType")
teLinkStdMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 200)).setRevisions(("2005-10-11 00:00",))
if mibBuilder.loadTexts: teLinkStdMIB.setLastUpdated('200510110000Z')
if mibBuilder.loadTexts: teLinkStdMIB.setOrganization('Multiprotocol Label Switching (MPLS) Working Group')
if mibBuilder.loadTexts: teLinkStdMIB.setContactInfo('        Martin Dubuc\n        Email:  mdubuc@ncf.ca\n\n                Thomas D. Nadeau\n        Email:  tnadeau@cisco.com\n\n\n\n\n                Jonathan P. Lang\n        Email:  jplang@ieee.org\n\n        Comments about this document should be emailed directly to\n        the MPLS working group mailing list at mpls@uu.net.')
if mibBuilder.loadTexts: teLinkStdMIB.setDescription("Copyright (C) 2005 The Internet Society.  This version of\n        this MIB module is part of RFC 4220; see the RFC\n        itself for full legal notices.\n\n        This MIB module contains managed object definitions for\n        MPLS traffic engineering links as defined in\n        'Link Bundling in MPLS Traffic Engineering (TE)'.")
class TeLinkBandwidth(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(4,4)
    fixedLength = 4

class TeLinkPriority(Unsigned32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,7)

class TeLinkProtection(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("primary", 1), ("secondary", 2),)

class TeLinkSwitchingCapability(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 51, 100, 150, 200,))
    namedValues = NamedValues(("packetSwitch1", 1), ("packetSwitch2", 2), ("packetSwitch3", 3), ("packetSwitch4", 4), ("layer2Switch", 51), ("tdm", 100), ("lambdaSwitch", 150), ("fiberSwitch", 200),)

class TeLinkEncodingType(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 5, 7, 8, 9, 11,))
    namedValues = NamedValues(("packet", 1), ("ethernet", 2), ("ansiEtsiPdh", 3), ("sdhItuSonetAnsi", 5), ("digitalWrapper", 7), ("lambda", 8), ("fiber", 9), ("fiberChannel", 11),)

class TeLinkSonetSdhIndication(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(0, 1,))
    namedValues = NamedValues(("standard", 0), ("arbitrary", 1),)

teLinkNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 0))
teLinkObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 1))
teLinkConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 2))
teLinkTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 1), )
if mibBuilder.loadTexts: teLinkTable.setDescription('This table specifies the grouping of component links into\n        TE links and the grouping of TE links into bundled links.')
teLinkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: teLinkEntry.setDescription('An entry in this table exists for each ifEntry with an\n        ifType of teLink(200), i.e., for every TE link.  An ifEntry\n        in the ifTable must exist before a teLinkEntry is created\n        with the corresponding ifIndex.  If a TE link entry in the\n        ifTable is destroyed, then so is the corresponding entry\n        in the teLinkTable.  The administrative and operational\n        status values are controlled from the ifEntry.')
teLinkAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 1), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkAddressType.setDescription('The type of Internet address for the TE link.')
teLinkLocalIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 2), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkLocalIpAddr.setDescription('The local Internet address for numbered links.  The type of\n        this address is determined by the value of the\n        teLinkAddressType object.\n\n        For IPv4 and IPv6 numbered links, this object represents the\n        local IP address associated with the TE link.  For an\n        unnumbered link, the local address is of type unknown, this\n        object is set to the zero length string, and the\n        teLinkOutgoingIfId object then identifies the unnumbered\n        address.\n\n        If the TE link is a Forwarding Adjacency (FA), the local\n        IP address is set to the head-end address of the FA-LSP.\n\n        If ipAddrTable is implemented, this object must have the\n        same value as the ipAdEntAddr object that belongs to the\n        row in ipAddrTable where ipAdEntIfIndex is equal to\n\n\n\n        ifIndex.')
teLinkRemoteIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 3), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkRemoteIpAddr.setDescription('The remote Internet address for numbered links.  The type of\n        this address is determined by the value of the\n        teLinkAddressType object.\n\n        The remote IP address associated with the TE link (IPv4 and\n        IPv6 numbered links).  For an unnumbered link, the remote\n        address is of type unknown, this object is set to the\n        zero length string, and the teLinkIncomingIfId object then\n        identifies the unnumbered address.\n\n        If the TE link is a Forwarding Adjacency, the remote IP\n        address is set to the tail-end address of the FA-LSP.')
teLinkMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkMetric.setDescription('The traffic engineering metric for the TE link is\n        derived from its component links.  All component links\n        within the TE link must have the same traffic\n        engineering metric.')
teLinkMaximumReservableBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 5), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: teLinkMaximumReservableBandwidth.setDescription('This attribute specifies the maximum reservable bandwidth on\n        the TE link.  This is the union of the maximum reservable\n        bandwidth of all the component links within the\n        TE link that can be used to carry live traffic.')
teLinkProtectionType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("extraTraffic", 1), ("unprotected", 2), ("shared", 3), ("dedicated1For1", 4), ("dedicated1Plus1", 5), ("enhanced", 6),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkProtectionType.setDescription("This attribute specifies the link protection type of the\n        TE link.  Descriptions of the different protection types can\n        be found in the 'Routing Extensions in Support of\n        Generalized Multi-Protocol Label Switching (GMPLS)'\n        document.")
teLinkWorkingPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 7), TeLinkPriority()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkWorkingPriority.setDescription('This object represents a priority value such that a new\n        connection with a higher priority, i.e., numerically lower\n        than this value, is guaranteed to be setup on a primary\n        link and not on a secondary link.')
teLinkResourceClass = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 8), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkResourceClass.setDescription("This attribute specifies the TE link resource class.\n        The resource class is a 32 bit bitfield.  The resource class\n        for a link bundle is derived from the resource class of its\n\n\n\n        TE links.  All TE links within a link bundle must have the\n        same resource class.  Encoding of the resource class is\n        described in the 'Traffic Engineering (TE) Extensions to\n        OSPF Version 2' document.")
teLinkIncomingIfId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkIncomingIfId.setDescription('For unnumbered links, the incoming interface is set to the\n        outgoing interface identifier chosen by the neighboring LSR\n        for the reverse link corresponding to this TE link.  If the\n        link is numbered, the value of this object is 0 and the\n        address is stored in the teLinkRemoteIpAddr instead.')
teLinkOutgoingIfId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 10), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkOutgoingIfId.setDescription('If the link is unnumbered, the outgoing interface identifier\n        is set to the outgoing interface identifier chosen for the\n        TE link by the advertising LSR.  If the link is numbered, the\n        value of this object is 0 and the address is stored in the\n        teLinkLocalIpAddr instead.')
teLinkRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkRowStatus.setDescription('This variable is used to create, modify, and/or\n        delete a row in this table.  None of the writable objects in\n        a row can be changed if status is active(1).')
teLinkStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 12), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkStorageType.setDescription("The storage type for this conceptual row in the\n        teLinkTable.  Conceptual rows having the value\n        'permanent' need not allow write-access to any\n        columnar object in the row.")
teLinkDescriptorTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 2), )
if mibBuilder.loadTexts: teLinkDescriptorTable.setDescription('This table specifies the interface switching capability\n        descriptors associated with the TE links.')
teLinkDescriptorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "teLinkDescriptorId"))
if mibBuilder.loadTexts: teLinkDescriptorEntry.setDescription('An entry in this table is created for every TE link interface\n        switching capability descriptor.  An ifEntry in the ifTable\n        must exist before a teLinkDescriptorEntry using the same\n        ifIndex is created.  ifType of ifEntry must be teLink(200).\n        If a TE link entry in the ifTable is destroyed, then so are\n        all of the entries in the teLinkDescriptorTable that use the\n        ifIndex of this TE link.')
teLinkDescriptorId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: teLinkDescriptorId.setDescription('This object specifies the link descriptor identifier.')
teLinkDescrSwitchingCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 2), TeLinkSwitchingCapability()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrSwitchingCapability.setDescription('This attribute specifies interface switching capability of\n        the TE link, which is derived from its component links.')
teLinkDescrEncodingType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 3), TeLinkEncodingType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrEncodingType.setDescription('This attribute specifies the TE link encoding type.')
teLinkDescrMinLspBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 4), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMinLspBandwidth.setDescription('This attribute specifies the minimum LSP bandwidth on\n        the TE link.  This is derived from the union of the\n        minimum LSP bandwidth of all the component links\n        associated with the TE link that can be used to carry\n        live traffic.')
teLinkDescrMaxLspBandwidthPrio0 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 5), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio0.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 0 on the TE link.  This is the union of the maximum\n        LSP bandwidth at priority 0 of all the component links within\n        the TE link that can be used to carry live traffic.')
teLinkDescrMaxLspBandwidthPrio1 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 6), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio1.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 1 on the TE link.  This is the union of the maximum\n        LSP bandwidth at priority 1 of all the component links within\n        the TE link that can be used to carry live traffic.')
teLinkDescrMaxLspBandwidthPrio2 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 7), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio2.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 2 on the TE link.  This is the union of the maximum\n\n\n\n        LSP bandwidth at priority 2 of all the component links within\n        the TE link that can be used to carry live traffic.')
teLinkDescrMaxLspBandwidthPrio3 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 8), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio3.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 3 on the TE link.  This is the union of the maximum\n        LSP bandwidth at priority 3 of all the component links within\n        the TE link that can be used to carry live traffic.')
teLinkDescrMaxLspBandwidthPrio4 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 9), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio4.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 4 on the TE link.  This is the union of the maximum\n        LSP bandwidth at priority 4 of all the component links within\n        the TE link that can be used to carry live traffic.')
teLinkDescrMaxLspBandwidthPrio5 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 10), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio5.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 5 on the TE link.  This is the union of the maximum\n        LSP bandwidth at priority 5 of all the component links within\n        the TE link that can be used to carry live traffic.')
teLinkDescrMaxLspBandwidthPrio6 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 11), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio6.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 6 on the TE link.  This is the union of the maximum\n        LSP bandwidth at priority 6 of all the component links within\n        the TE link that can be used to carry live traffic.')
teLinkDescrMaxLspBandwidthPrio7 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 12), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio7.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 7 on the TE link.  This is the union of the maximum\n        LSP bandwidth at priority 7 of all the component links within\n        the TE link that can be used to carry live traffic.')
teLinkDescrInterfaceMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 13), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrInterfaceMtu.setDescription('This attribute specifies the interface MTU for the TE\n        link descriptor.')
teLinkDescrIndication = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 14), TeLinkSonetSdhIndication()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrIndication.setDescription('This attribute specifies whether this interface supports\n        Standard or Arbitrary SONET/SDH.')
teLinkDescrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrRowStatus.setDescription('This variable is used to create, modify, and/or\n        delete a row in this table.  No read-create object\n        can be changed if teLinkDescrRowStatus is in the active(1)\n        state.')
teLinkDescrStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 16), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrStorageType.setDescription("The storage type for this conceptual row in the\n        teLinkDescriptorTable.  Conceptual rows having the value\n        'permanent' need not allow write-access to any\n        columnar object in the row.")
teLinkSrlgTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 3), )
if mibBuilder.loadTexts: teLinkSrlgTable.setDescription('This table specifies the SRLGs associated with TE links.')
teLinkSrlgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 3, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "teLinkSrlg"))
if mibBuilder.loadTexts: teLinkSrlgEntry.setDescription('An entry in this table contains information about an\n        SRLG associated with a TE link.\n        An ifEntry in the ifTable must exist before a\n        teLinkSrlgEntry using the same ifIndex is created.\n        The ifType of ifEntry must be teLink(200).\n        If a TE link entry in the ifTable is destroyed, then so\n        are all of the entries in the teLinkSrlgTable that use the\n        ifIndex of this TE link.')
teLinkSrlg = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: teLinkSrlg.setDescription('This identifies an SRLG supported by the TE link.  An SRLG is\n        identified with a 32-bit number that is unique within an IGP\n        domain.  Zero is a valid SRLG number.')
teLinkSrlgRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 3, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkSrlgRowStatus.setDescription('This variable is used to create, modify, and/or\n        delete a row in this table.  No read-create object can\n        be modified if teLinkSrlgRowStatus is active(1).')
teLinkSrlgStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 3, 1, 3), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkSrlgStorageType.setDescription("The storage type for this conceptual row in the\n\n\n\n        teLinkSrlgTable.  Conceptual rows having the value\n        'permanent' need not allow write-access to any\n        columnar object in the row.")
teLinkBandwidthTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 4), )
if mibBuilder.loadTexts: teLinkBandwidthTable.setDescription('This table specifies the priority-based bandwidth table\n        for TE links.')
teLinkBandwidthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "teLinkBandwidthPriority"))
if mibBuilder.loadTexts: teLinkBandwidthEntry.setDescription('An entry in this table contains information about\n        the priority-based bandwidth of TE links.  An ifEntry in the\n        ifTable must exist before a teLinkBandwidthEntry using the\n        same ifIndex is created.  The ifType of ifEntry must be\n        teLink(200).  If a TE link entry in the ifTable is destroyed,\n        then so are all of the entries in the teLinkBandwidthTable\n        that use the ifIndex of this TE link.')
teLinkBandwidthPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1, 1), TeLinkPriority())
if mibBuilder.loadTexts: teLinkBandwidthPriority.setDescription("This attribute specifies the priority.  A value of 0 is valid\n        as specified in the 'Traffic Engineering (TE) Extensions to\n\n\n\n        OSPF Version 2' document.")
teLinkBandwidthUnreserved = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1, 2), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: teLinkBandwidthUnreserved.setDescription('This attribute specifies the TE link unreserved\n        bandwidth at priority p.  It is the sum of the unreserved\n        bandwidths at priority p of all component links associated\n        with the TE link (excluding all links that are strictly\n        used as protecting links).')
teLinkBandwidthRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkBandwidthRowStatus.setDescription('This variable is used to create, modify, and/or\n        delete a row in this table.  No read-create object\n        can be modified when teLinkBandwidthRowStatus is active(1).')
teLinkBandwidthStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1, 4), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkBandwidthStorageType.setDescription("The storage type for this conceptual row in the\n        teLinkBandwidthTable.  Conceptual rows having the value\n        'permanent' need not allow write-access to any\n        columnar object in the row.")
componentLinkTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 5), )
if mibBuilder.loadTexts: componentLinkTable.setDescription('This table specifies the component link parameters.')
componentLinkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: componentLinkEntry.setDescription("An entry in this table exists for each ifEntry that\n        represents a component link.  An ifEntry must exist in\n        the ifTable before a componentLinkEntry is created with\n        the corresponding ifIndex.  ifEntry's ifType can be\n        of any interface type that has been defined for TE Link\n        interworking.  Examples include ATM, Frame Relay, Ethernet,\n        etc.  If an entry representing a component link is destroyed\n        in the ifTable, then so is the corresponding entry in the\n        componentLinkTable.  The administrative and operational\n        status values are controlled from the ifEntry.")
componentLinkMaxResBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 1), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkMaxResBandwidth.setDescription('This attribute specifies the maximum reservable bandwidth on\n        the component link.')
componentLinkPreferredProtection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 2), TeLinkProtection()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkPreferredProtection.setDescription('This attribute specifies whether this component link is\n        a primary or secondary entity.')
componentLinkCurrentProtection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 3), TeLinkProtection()).setMaxAccess("readonly")
if mibBuilder.loadTexts: componentLinkCurrentProtection.setDescription('This attribute specifies whether this component link is\n        currently used as primary or secondary link.')
componentLinkRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkRowStatus.setDescription('This variable is used to create, modify, and/or\n        delete a row in this table.  No read-create object\n        can be modified when componentLinkRowStatus is active(1).')
componentLinkStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 5), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkStorageType.setDescription("The storage type for this conceptual row in the\n        componentLinkTable.  Conceptual rows having the value\n        'permanent' need not allow write-access to any\n        columnar object in the row.")
componentLinkDescriptorTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 6), )
if mibBuilder.loadTexts: componentLinkDescriptorTable.setDescription('This table specifies the interface switching capability\n        descriptors associated with the component links.')
componentLinkDescriptorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "componentLinkDescrId"))
if mibBuilder.loadTexts: componentLinkDescriptorEntry.setDescription("An entry in this table is created for every component link\n        descriptor.  An ifEntry in the ifTable must exist before a\n        componentLinkDescriptorEntry using the same ifIndex is\n        created.  ifEntry's ifType can be of any interface type that\n        has been defined for TE Link interworking.  Examples include\n        ATM, Frame Relay, Ethernet, etc.  If a component link entry\n        in the ifTable is destroyed, then so are all entries in the\n        componentLinkDescriptorTable that use the ifIndex of this\n        component link.")
componentLinkDescrId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: componentLinkDescrId.setDescription('This object specifies the link descriptor identifier.')
componentLinkDescrSwitchingCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 2), TeLinkSwitchingCapability()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrSwitchingCapability.setDescription('This attribute specifies link multiplexing capabilities of\n        the component link.')
componentLinkDescrEncodingType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 3), TeLinkEncodingType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrEncodingType.setDescription('This attribute specifies the component link encoding type.')
componentLinkDescrMinLspBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 4), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMinLspBandwidth.setDescription('This attribute specifies the minimum LSP bandwidth on\n        the component link.')
componentLinkDescrMaxLspBandwidthPrio0 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 5), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio0.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 0 on the component link.')
componentLinkDescrMaxLspBandwidthPrio1 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 6), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio1.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 1 on the component link.')
componentLinkDescrMaxLspBandwidthPrio2 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 7), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio2.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 2 on the component link.')
componentLinkDescrMaxLspBandwidthPrio3 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 8), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio3.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 3 on the component link.')
componentLinkDescrMaxLspBandwidthPrio4 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 9), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio4.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 4 on the component link.')
componentLinkDescrMaxLspBandwidthPrio5 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 10), TeLinkBandwidth()).setUnits('thousand bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio5.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 5 on the component link.')
componentLinkDescrMaxLspBandwidthPrio6 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 11), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio6.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 6 on the component link.')
componentLinkDescrMaxLspBandwidthPrio7 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 12), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio7.setDescription('This attribute specifies the maximum LSP bandwidth at\n        priority 7 on the component link.')
componentLinkDescrInterfaceMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 13), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrInterfaceMtu.setDescription('This attribute specifies the interface MTU for the component\n        link descriptor.')
componentLinkDescrIndication = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 14), TeLinkSonetSdhIndication()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrIndication.setDescription('This attribute specifies whether this interface supports\n        Standard or Arbitrary SONET/SDH.')
componentLinkDescrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrRowStatus.setDescription('This variable is used to create, modify, and/or\n        delete a row in this table.  No read-create object\n        can be modified when componentLinkDescrRowStatus\n        is active(1).')
componentLinkDescrStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 16), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrStorageType.setDescription("The storage type for this conceptual row in the\n        componentLinkDescriptorTable.  Conceptual rows\n        having the value 'permanent' need not allow write-access\n        to any columnar object in the row.")
componentLinkBandwidthTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 7), )
if mibBuilder.loadTexts: componentLinkBandwidthTable.setDescription('This table specifies the priority-based bandwidth\n        for component links.')
componentLinkBandwidthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "componentLinkBandwidthPriority"))
if mibBuilder.loadTexts: componentLinkBandwidthEntry.setDescription("An entry in this table contains information about\n        the priority-based bandwidth on component links.\n        An ifEntry in the ifTable must exist before a\n        componentLinkBandwidthEntry using the same ifIndex is\n        created.  ifEntry's ifType can be of any interface type that\n        has been defined for TE Link interworking.  Examples\n        include ATM, Frame Relay, Ethernet, etc.  If a component link\n        entry in the ifTable is destroyed, then so are all entries\n        in the componentLinkBandwidthTable that use the ifIndex of\n        this component link.")
componentLinkBandwidthPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1, 1), TeLinkPriority())
if mibBuilder.loadTexts: componentLinkBandwidthPriority.setDescription("This attribute specifies the priority.  A value of 0 is valid\n        as specified in the 'Traffic Engineering (TE) Extensions to\n         OSPF Version 2' document.")
componentLinkBandwidthUnreserved = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1, 2), TeLinkBandwidth()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: componentLinkBandwidthUnreserved.setDescription('This attribute specifies the component link unreserved\n        bandwidth at priority p.')
componentLinkBandwidthRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkBandwidthRowStatus.setDescription('This variable is used to create, modify, and/or\n        delete a row in this table.  No read-create object can\n        be modified when componentLinkBandwidthRowStatus is\n        active(1).')
componentLinkBandwidthStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1, 4), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkBandwidthStorageType.setDescription("The storage type for this conceptual row in the\n        componentLinkBandwidthTable.  Conceptual rows\n        having the value 'permanent' need not allow write-access\n        to any columnar object in the row.")
teLinkCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 2, 1))
teLinkGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 2, 2))
teLinkModuleFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 200, 2, 1, 1)).setObjects(*(("TE-LINK-STD-MIB", "teLinkGroup"), ("TE-LINK-STD-MIB", "teLinkBandwidthGroup"), ("TE-LINK-STD-MIB", "componentLinkBandwidthGroup"), ("TE-LINK-STD-MIB", "teLinkSrlgGroup"), ("TE-LINK-STD-MIB", "teLinkPscGroup"), ("TE-LINK-STD-MIB", "teLinkTdmGroup"),))
if mibBuilder.loadTexts: teLinkModuleFullCompliance.setDescription('Compliance statement for agents that support read-create\n        so that both configuration and monitoring of TE links can\n        be accomplished via this MIB module.')
teLinkModuleReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 200, 2, 1, 2)).setObjects(*(("TE-LINK-STD-MIB", "teLinkGroup"), ("TE-LINK-STD-MIB", "teLinkBandwidthGroup"), ("TE-LINK-STD-MIB", "componentLinkBandwidthGroup"), ("TE-LINK-STD-MIB", "teLinkSrlgGroup"), ("TE-LINK-STD-MIB", "teLinkPscGroup"), ("TE-LINK-STD-MIB", "teLinkTdmGroup"),))
if mibBuilder.loadTexts: teLinkModuleReadOnlyCompliance.setDescription('Compliance statement for agents that support the\n        monitoring of the TE link MIB module.')
teLinkGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 1)).setObjects(*(("TE-LINK-STD-MIB", "teLinkAddressType"), ("TE-LINK-STD-MIB", "teLinkLocalIpAddr"), ("TE-LINK-STD-MIB", "teLinkRemoteIpAddr"), ("TE-LINK-STD-MIB", "teLinkMetric"), ("TE-LINK-STD-MIB", "teLinkProtectionType"), ("TE-LINK-STD-MIB", "teLinkWorkingPriority"), ("TE-LINK-STD-MIB", "teLinkResourceClass"), ("TE-LINK-STD-MIB", "teLinkIncomingIfId"), ("TE-LINK-STD-MIB", "teLinkOutgoingIfId"), ("TE-LINK-STD-MIB", "teLinkRowStatus"), ("TE-LINK-STD-MIB", "teLinkStorageType"), ("TE-LINK-STD-MIB", "teLinkDescrSwitchingCapability"), ("TE-LINK-STD-MIB", "teLinkDescrEncodingType"), ("TE-LINK-STD-MIB", "teLinkDescrRowStatus"), ("TE-LINK-STD-MIB", "teLinkDescrStorageType"), ("TE-LINK-STD-MIB", "componentLinkPreferredProtection"), ("TE-LINK-STD-MIB", "componentLinkCurrentProtection"), ("TE-LINK-STD-MIB", "componentLinkRowStatus"), ("TE-LINK-STD-MIB", "componentLinkStorageType"), ("TE-LINK-STD-MIB", "componentLinkDescrSwitchingCapability"), ("TE-LINK-STD-MIB", "componentLinkDescrEncodingType"), ("TE-LINK-STD-MIB", "componentLinkDescrRowStatus"), ("TE-LINK-STD-MIB", "componentLinkDescrStorageType"),))
if mibBuilder.loadTexts: teLinkGroup.setDescription('Collection of objects needed for the management of\n           resources associated with TE links.')
teLinkSrlgGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 2)).setObjects(*(("TE-LINK-STD-MIB", "teLinkSrlgRowStatus"), ("TE-LINK-STD-MIB", "teLinkSrlgStorageType"),))
if mibBuilder.loadTexts: teLinkSrlgGroup.setDescription('Collection of objects needed for the management of\n           SRLG resources associated with TE links.')
teLinkBandwidthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 3)).setObjects(*(("TE-LINK-STD-MIB", "teLinkMaximumReservableBandwidth"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio0"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio1"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio2"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio3"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio4"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio5"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio6"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio7"), ("TE-LINK-STD-MIB", "teLinkBandwidthUnreserved"), ("TE-LINK-STD-MIB", "teLinkBandwidthRowStatus"), ("TE-LINK-STD-MIB", "teLinkBandwidthStorageType"),))
if mibBuilder.loadTexts: teLinkBandwidthGroup.setDescription('Collection of objects needed for the management of\n           the bandwidth resources associated with TE links and\n           component links.')
componentLinkBandwidthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 4)).setObjects(*(("TE-LINK-STD-MIB", "componentLinkMaxResBandwidth"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio0"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio1"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio2"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio3"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio4"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio5"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio6"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio7"), ("TE-LINK-STD-MIB", "componentLinkBandwidthUnreserved"), ("TE-LINK-STD-MIB", "componentLinkBandwidthRowStatus"), ("TE-LINK-STD-MIB", "componentLinkBandwidthStorageType"),))
if mibBuilder.loadTexts: componentLinkBandwidthGroup.setDescription('Collection of objects needed for the management of the\n           bandwidth parameters associated with component links.')
teLinkPscGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 5)).setObjects(*(("TE-LINK-STD-MIB", "teLinkDescrMinLspBandwidth"), ("TE-LINK-STD-MIB", "teLinkDescrInterfaceMtu"), ("TE-LINK-STD-MIB", "componentLinkDescrMinLspBandwidth"), ("TE-LINK-STD-MIB", "componentLinkDescrInterfaceMtu"),))
if mibBuilder.loadTexts: teLinkPscGroup.setDescription('Collection of objects needed for devices that are\n           packet switch capable.')
teLinkTdmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 6)).setObjects(*(("TE-LINK-STD-MIB", "teLinkDescrMinLspBandwidth"), ("TE-LINK-STD-MIB", "teLinkDescrIndication"), ("TE-LINK-STD-MIB", "componentLinkDescrMinLspBandwidth"), ("TE-LINK-STD-MIB", "componentLinkDescrIndication"),))
if mibBuilder.loadTexts: teLinkTdmGroup.setDescription('Collection of objects needed for devices that are\n           TDM switching capable.')
mibBuilder.exportSymbols("TE-LINK-STD-MIB", teLinkSrlgRowStatus=teLinkSrlgRowStatus, componentLinkBandwidthRowStatus=componentLinkBandwidthRowStatus, teLinkDescrMinLspBandwidth=teLinkDescrMinLspBandwidth, componentLinkDescrMaxLspBandwidthPrio5=componentLinkDescrMaxLspBandwidthPrio5, teLinkStdMIB=teLinkStdMIB, teLinkTdmGroup=teLinkTdmGroup, teLinkSrlgEntry=teLinkSrlgEntry, componentLinkEntry=componentLinkEntry, componentLinkDescrMaxLspBandwidthPrio2=componentLinkDescrMaxLspBandwidthPrio2, TeLinkSonetSdhIndication=TeLinkSonetSdhIndication, componentLinkDescrSwitchingCapability=componentLinkDescrSwitchingCapability, componentLinkDescrMaxLspBandwidthPrio0=componentLinkDescrMaxLspBandwidthPrio0, TeLinkProtection=TeLinkProtection, componentLinkDescrMaxLspBandwidthPrio1=componentLinkDescrMaxLspBandwidthPrio1, teLinkAddressType=teLinkAddressType, teLinkResourceClass=teLinkResourceClass, teLinkBandwidthPriority=teLinkBandwidthPriority, componentLinkDescrEncodingType=componentLinkDescrEncodingType, teLinkTable=teLinkTable, teLinkLocalIpAddr=teLinkLocalIpAddr, teLinkDescrStorageType=teLinkDescrStorageType, teLinkNotifications=teLinkNotifications, teLinkCompliances=teLinkCompliances, teLinkProtectionType=teLinkProtectionType, teLinkBandwidthEntry=teLinkBandwidthEntry, teLinkMaximumReservableBandwidth=teLinkMaximumReservableBandwidth, teLinkDescrMaxLspBandwidthPrio3=teLinkDescrMaxLspBandwidthPrio3, componentLinkBandwidthUnreserved=componentLinkBandwidthUnreserved, teLinkDescrIndication=teLinkDescrIndication, teLinkDescrMaxLspBandwidthPrio4=teLinkDescrMaxLspBandwidthPrio4, teLinkConformance=teLinkConformance, componentLinkBandwidthGroup=componentLinkBandwidthGroup, componentLinkDescrId=componentLinkDescrId, teLinkSrlgGroup=teLinkSrlgGroup, componentLinkDescrMaxLspBandwidthPrio6=componentLinkDescrMaxLspBandwidthPrio6, teLinkDescrSwitchingCapability=teLinkDescrSwitchingCapability, componentLinkDescrMaxLspBandwidthPrio4=componentLinkDescrMaxLspBandwidthPrio4, componentLinkMaxResBandwidth=componentLinkMaxResBandwidth, componentLinkBandwidthStorageType=componentLinkBandwidthStorageType, componentLinkDescrRowStatus=componentLinkDescrRowStatus, TeLinkPriority=TeLinkPriority, teLinkDescrRowStatus=teLinkDescrRowStatus, teLinkBandwidthUnreserved=teLinkBandwidthUnreserved, teLinkGroup=teLinkGroup, teLinkGroups=teLinkGroups, teLinkDescrInterfaceMtu=teLinkDescrInterfaceMtu, teLinkPscGroup=teLinkPscGroup, teLinkOutgoingIfId=teLinkOutgoingIfId, componentLinkBandwidthEntry=componentLinkBandwidthEntry, teLinkDescrMaxLspBandwidthPrio1=teLinkDescrMaxLspBandwidthPrio1, componentLinkBandwidthPriority=componentLinkBandwidthPriority, TeLinkEncodingType=TeLinkEncodingType, teLinkObjects=teLinkObjects, teLinkModuleReadOnlyCompliance=teLinkModuleReadOnlyCompliance, teLinkDescrMaxLspBandwidthPrio0=teLinkDescrMaxLspBandwidthPrio0, teLinkDescrMaxLspBandwidthPrio5=teLinkDescrMaxLspBandwidthPrio5, teLinkRemoteIpAddr=teLinkRemoteIpAddr, teLinkBandwidthGroup=teLinkBandwidthGroup, TeLinkSwitchingCapability=TeLinkSwitchingCapability, teLinkDescriptorTable=teLinkDescriptorTable, teLinkDescrMaxLspBandwidthPrio7=teLinkDescrMaxLspBandwidthPrio7, componentLinkCurrentProtection=componentLinkCurrentProtection, teLinkBandwidthTable=teLinkBandwidthTable, PYSNMP_MODULE_ID=teLinkStdMIB, teLinkBandwidthRowStatus=teLinkBandwidthRowStatus, teLinkSrlg=teLinkSrlg, teLinkDescrMaxLspBandwidthPrio6=teLinkDescrMaxLspBandwidthPrio6, componentLinkDescrStorageType=componentLinkDescrStorageType, componentLinkDescrIndication=componentLinkDescrIndication, componentLinkStorageType=componentLinkStorageType, teLinkSrlgStorageType=teLinkSrlgStorageType, teLinkWorkingPriority=teLinkWorkingPriority, componentLinkBandwidthTable=componentLinkBandwidthTable, componentLinkRowStatus=componentLinkRowStatus, teLinkMetric=teLinkMetric, componentLinkTable=componentLinkTable, teLinkEntry=teLinkEntry, teLinkDescriptorEntry=teLinkDescriptorEntry, componentLinkPreferredProtection=componentLinkPreferredProtection, componentLinkDescriptorEntry=componentLinkDescriptorEntry, teLinkDescrEncodingType=teLinkDescrEncodingType, teLinkSrlgTable=teLinkSrlgTable, componentLinkDescrInterfaceMtu=componentLinkDescrInterfaceMtu, teLinkIncomingIfId=teLinkIncomingIfId, componentLinkDescriptorTable=componentLinkDescriptorTable, teLinkBandwidthStorageType=teLinkBandwidthStorageType, teLinkDescrMaxLspBandwidthPrio2=teLinkDescrMaxLspBandwidthPrio2, teLinkDescriptorId=teLinkDescriptorId, TeLinkBandwidth=TeLinkBandwidth, teLinkStorageType=teLinkStorageType, componentLinkDescrMaxLspBandwidthPrio3=componentLinkDescrMaxLspBandwidthPrio3, componentLinkDescrMaxLspBandwidthPrio7=componentLinkDescrMaxLspBandwidthPrio7, teLinkRowStatus=teLinkRowStatus, teLinkModuleFullCompliance=teLinkModuleFullCompliance, componentLinkDescrMinLspBandwidth=componentLinkDescrMinLspBandwidth)
