% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic-gsva.R
\name{run_gsva}
\alias{run_gsva}
\title{Gene Set Variation Analysis (GSVA)}
\usage{
run_gsva(
  mat,
  network,
  .source = .data$source,
  .target = .data$target,
  verbose = FALSE,
  method = "gsva",
  minsize = 5,
  ...
)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{verbose}{Gives information about each calculation step. Default: FALSE.}

\item{method}{Method to employ in the estimation of gene-set enrichment.
scores per sample. By default this is set to gsva (Hänzelmann et al, 2013).}

\item{minsize}{Integer indicating the minimum number of targets per source.}

\item{...}{
  Arguments passed on to \code{\link[GSVA:gsva]{GSVA::gsva}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
A long format tibble of the enrichment scores for each source
across the samples. Resulting tibble contains the following columns:
\enumerate{
\item \code{statistic}: Indicates which method is associated with which score.
\item \code{source}: Source nodes of \code{network}.
\item \code{condition}: Condition representing each column of \code{mat}.
\item \code{score}: Regulatory activity (enrichment score).
}
}
\description{
Calculates regulatory activities using GSVA.
}
\details{
GSVA (Hänzelmann et al., 2013) starts by transforming the input molecular
readouts in mat to a readout-level statistic using Gaussian kernel estimation
of the cumulative density function. Then, readout-level statistics are
ranked per sample and normalized to up-weight the two tails of the rank
distribution. Afterwards, an enrichment score \code{gsva} is calculated
using a running sum statistic that is normalized by subtracting the largest
negative estimate from the largest positive one.

Hänzelmann S. et al. (2013) GSVA: gene set variation analysis for microarray
and RNA-seq data. BMC Bioinformatics, 14, 7.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")

mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))

run_gsva(mat, net, minsize=0, verbose = FALSE)
}
\seealso{
Other decoupleR statistics: 
\code{\link{decouple}()},
\code{\link{run_aucell}()},
\code{\link{run_fgsea}()},
\code{\link{run_mdt}()},
\code{\link{run_mlm}()},
\code{\link{run_ora}()},
\code{\link{run_udt}()},
\code{\link{run_ulm}()},
\code{\link{run_viper}()},
\code{\link{run_wmean}()},
\code{\link{run_wsum}()}
}
\concept{decoupleR statistics}
