% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exports.R
\name{batchExport}
\alias{batchExport}
\title{Export R object to be available on the slaves.}
\usage{
batchExport(reg, ..., li = list(), overwrite = FALSE)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{...}{[any]\cr
Objects to export. You must provide a valid name.}

\item{li}{[\code{list}]\cr
More objects to export provided as a named list.}

\item{overwrite}{[\code{logical(1)}]\cr
If set to \code{FALSE} (default), exported objects are protected from being overwritten
by multiple calls of this function. Setting this to \code{TRUE} disables this check.}
}
\value{
[\code{character}]. Invisibly returns a character vector of exported objects.
}
\description{
Saves objects as \code{RData} files in the \dQuote{exports} subdirectory of your \code{file.dir}
to be later loaded on the slaves.
}
\seealso{
Other exports: 
\code{\link{addRegistryPackages}()},
\code{\link{addRegistrySourceDirs}()},
\code{\link{addRegistrySourceFiles}()},
\code{\link{batchUnexport}()},
\code{\link{loadExports}()},
\code{\link{removeRegistryPackages}()},
\code{\link{removeRegistrySourceDirs}()},
\code{\link{removeRegistrySourceFiles}()},
\code{\link{setRegistryPackages}()}
}
\concept{exports}
