% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBQ_CV.R
\name{BBQ_CV}
\alias{BBQ_CV}
\title{BBQ_CV}
\usage{
BBQ_CV(actual, predicted, method_for_prediction = 0, n_folds = 10, seed,
  input)
}
\arguments{
\item{actual}{vector of observed class labels (0/1)}

\item{predicted}{vector of uncalibrated predictions}

\item{method_for_prediction}{0=selection, 1=averaging, Default: 0}

\item{n_folds}{number of folds in the cross-validation, Default: 10}

\item{seed}{random seed to alternate the split of data set partitions}

\item{input}{specify if the input was scaled or transformed, scaled=1, transformed=2}
}
\value{
list object containing the following components:
\item{error}{list object that summarizes discrimination and calibration errors obtained during the CV}
\item{pred_idx}{which BBQ prediction method was used during CV, 0=selection, 1=averaging}
\item{type}{"BBQ"}
\item{probs_CV}{vector of calibrated predictions that was used during the CV}
\item{actual_CV}{respective vector of true values (0 or 1) that was used during the CV}
}
\description{
trains and evaluates the BBQ calibration model using \code{folds}-Cross-Validation (CV).
The \code{predicted} values are partitioned into n subsets. A BBQ model is constructed on (n-1) subsets; the remaining set is used
for testing the model. All test set predictions are merged and used to compute error metrics for the model.
}
\examples{
 ## Loading dataset in environment
 data(example)
 actual <- example$actual
 predicted <- example$predicted
 BBQ_model <- CalibratR:::BBQ_CV(actual, predicted, method_for_prediction=0, n_folds=4, 123, 1)
}
