% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkPermutation.R
\name{checkPermutation}
\alias{checkPermutation}
\alias{check_permutation}
\alias{assertPermutation}
\alias{assert_permutation}
\alias{testPermutation}
\alias{test_permutation}
\alias{expect_permutation}
\title{Check if the arguments are permutations of each other.}
\usage{
checkPermutation(x, y, na.ok = TRUE)

check_permutation(x, y, na.ok = TRUE)

assertPermutation(x, y, na.ok = TRUE, .var.name = vname(x), add = NULL)

assert_permutation(x, y, na.ok = TRUE, .var.name = vname(x), add = NULL)

testPermutation(x, y, na.ok = TRUE)

test_permutation(x, y, na.ok = TRUE)

expect_permutation(x, y, na.ok = TRUE, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{y}{[\code{atomic}]\cr
Vector to compare with. Atomic vector of type other than raw.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertPermutation}/\code{assert_permutation} return 
 \code{x} invisibly, whereas
 \code{checkPermutation}/\code{check_permutation} and 
 \code{testPermutation}/\code{test_permutation} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertPermutation}/\code{assert_permutation}
 throws an error message, 
 \code{testPermutation}/\code{test_permutation}
 returns \code{FALSE},
 and \code{checkPermutation}/\code{check_permutation} 
 return a string with the error message.
 The function \code{expect_permutation} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
In contrast to \code{\link{checkSetEqual}}, the function tests for a true
permutation of the two vectors and also considers duplicated values.
Missing values are being treated as actual values by default.
Does not work on raw values.
}
\note{
The object \code{x} must be of the same type as the set w.r.t. \code{\link[base]{typeof}}.
Integers and doubles are both treated as numeric.
}
\examples{
testPermutation(letters[1:2], letters[2:1])
testPermutation(letters[c(1, 1, 2)], letters[1:2])
testPermutation(c(NA, 1, 2), c(1, 2, NA))
testPermutation(c(NA, 1, 2), c(1, 2, NA), na.ok = FALSE)
}
\seealso{
Other set: 
\code{\link{checkChoice}()},
\code{\link{checkDisjunct}()},
\code{\link{checkSetEqual}()},
\code{\link{checkSubset}()}
}
\concept{set}
