% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pager.R
\name{make_blocking}
\alias{make_blocking}
\title{Create a Blocking Version of a Function}
\usage{
make_blocking(fun, msg = "Press ENTER to continue...", invisible.res = TRUE)
}
\arguments{
\item{fun}{a function}

\item{msg}{character(1L) a message to use as the \code{readline} prompt}

\item{invisible.res}{whether to return the result of \code{fun} invisibly}
}
\value{
\code{fun}, wrapped in a function that does the blocking.
}
\description{
Wraps \code{fun} in a function that runs \code{fun} and then issues a
\code{readline} prompt to prevent further R code evaluation until user
presses a key.
}
\examples{
make_blocking(sum, invisible.res=FALSE)(1:10)
}
