% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_r2.R
\name{interpret_r2}
\alias{interpret_r2}
\title{Interpret coefficient of determination (R2)}
\usage{
interpret_r2(r2, rules = "cohen1988")
}
\arguments{
\item{r2}{Value or vector of R2 values.}

\item{rules}{Can be \code{"cohen1988"} (default), \code{"falk1992"}, \code{"chin1998"}, \code{"hair2011"} or custom set of \code{\link[=rules]{rules()}}].}
}
\description{
Interpret coefficient of determination (R2)
}
\section{Rules}{

\subsection{For Linear Regression}{
\itemize{
\item Cohen (1988) (\code{"cohen1988"}; default)
\itemize{
\item \strong{R2 < 0.02} - Very weak
\item \strong{0.02 <= R2 < 0.13} - Weak
\item \strong{0.13 <= R2 < 0.26} - Moderate
\item \strong{R2 >= 0.26} - Substantial
}
\item Falk & Miller (1992) (\code{"falk1992"})
\itemize{
\item \strong{R2 < 0.1} - Negligible
\item \strong{R2 >= 0.1} - Adequate
}
}
}

\subsection{For PLS / SEM R-Squared of \emph{latent} variables}{
\itemize{
\item Chin, W. W. (1998) (\code{"chin1998"})
\itemize{
\item \strong{R2 < 0.19} - Very weak
\item \strong{0.19 <= R2 < 0.33} - Weak
\item \strong{0.33 <= R2 < 0.67} - Moderate
\item \strong{R2 >= 0.67} - Substantial
}
\item Hair et al. (2011) (\code{"hair2011"})
\itemize{
\item \strong{R2 < 0.25} - Very weak
\item \strong{0.25 <= R2 < 0.50} - Weak
\item \strong{0.50 <= R2 < 0.75} - Moderate
\item \strong{R2 >= 0.75} - Substantial
}
}
}
}

\examples{
interpret_r2(.02)
interpret_r2(c(.5, .02))
}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed.). New York: Routledge.
\item Falk, R. F., & Miller, N. B. (1992). A primer for soft modeling. University of Akron Press.
\item Chin, W. W. (1998). The partial least squares approach to structural equation modeling. Modern methods for business research, 295(2), 295-336.
\item Hair, J. F., Ringle, C. M., & Sarstedt, M. (2011). PLS-SEM: Indeed a silver bullet. Journal of Marketing theory and Practice, 19(2), 139-152.
}
}
