% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_process.R
\name{response_process}
\alias{response_process}
\alias{response_as_json}
\alias{gargle_error_message}
\title{Process a Google API response}
\usage{
response_process(
  resp,
  error_message = gargle_error_message,
  remember = TRUE,
  call = caller_env()
)

response_as_json(resp, call = caller_env())

gargle_error_message(resp, call = caller_env())
}
\arguments{
\item{resp}{Object of class \code{response} from \link{httr}.}

\item{error_message}{Function that produces an informative error message from
the primary input, \code{resp}. It must return a character vector.}

\item{remember}{Whether to remember the most recently processed response.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
The content of the request, as a list. An HTTP status code of 204 (No
content) is a special case returning \code{TRUE}.
}
\description{
\code{response_process()} is intended primarily for internal use in client
packages that provide high-level wrappers for users. Typically applied as the
final step in this sequence of calls:
\itemize{
\item Request prepared with \code{\link[=request_build]{request_build()}}.
\item Request made with \code{\link[=request_make]{request_make()}}.
\item Response processed with \code{response_process()}.
}

All that's needed for a successful request is to parse the JSON extracted via
\code{httr::content()}. Therefore, the main point of \code{response_process()} is to
handle less happy outcomes:
\itemize{
\item Status codes in the 400s (client error) and 500s (server error). The
structure of the error payload varies across Google APIs and we try to
create a useful message for all variants we know about.
\item Non-JSON content type, such as HTML.
\item Status code in the 100s (information) or 300s (redirection). These are
unexpected.
}

If \code{process_response()} results in an error, a redacted version of the \code{resp}
input is returned in the condition (auth tokens are removed).
}
\details{
When \code{remember = TRUE} (the default), gargle stores the most recently seen
response internally, for \emph{post hoc} examination. The stored response is
literally just the most recent \code{resp} input, but with auth tokens redacted.
It can be accessed via the unexported function
\code{gargle:::gargle_last_response()}. A companion function
\code{gargle:::gargle_last_content()} returns the content of the last response,
which is probably the most useful form for \emph{post mortem} analysis.

The \code{response_as_json()} helper is exported only as an aid to maintainers who
wish to use their own \code{error_message} function, instead of gargle's built-in
\code{gargle_error_message()}. When implementing a custom \code{error_message}
function, call \code{response_as_json()} immediately on the input in order to
inherit gargle's handling of non-JSON input.
}
\examples{
\dontrun{
# get an OAuth2 token with 'userinfo.email' scope
token <- token_fetch(scopes = "https://www.googleapis.com/auth/userinfo.email")

# see the email associated with this token
req <- gargle::request_build(
  method = "GET",
  path = "v1/userinfo",
  token = token,
  base_url = "https://openidconnect.googleapis.com"
)
resp <- gargle::request_make(req)
response_process(resp)

# make a bad request (this token has incorrect scope)
req <- gargle::request_build(
  method = "GET",
  path = "fitness/v1/users/{userId}/dataSources",
  token = token,
  params = list(userId = 12345)
)
resp <- gargle::request_make(req)
response_process(resp)
}
}
\seealso{
Other requests and responses: 
\code{\link{request_develop}()},
\code{\link{request_make}()}
}
\concept{requests and responses}
