% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggally_cross.R
\name{ggally_table}
\alias{ggally_table}
\alias{ggally_tableDiag}
\title{Display a table of the number of observations}
\usage{
ggally_table(
  data,
  mapping,
  keep.zero.cells = FALSE,
  ...,
  geom_tile_args = NULL
)

ggally_tableDiag(
  data,
  mapping,
  keep.zero.cells = FALSE,
  ...,
  geom_tile_args = NULL
)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{keep.zero.cells}{If \code{TRUE}, display cells with no observation.}

\item{...}{other arguments passed to \code{\link[ggplot2]{geom_text}(...)}}

\item{geom_tile_args}{other arguments passed to \code{\link[ggplot2]{geom_tile}(...)}}
}
\description{
Plot the number of observations as a table. Other statistics computed
by \code{\link{stat_cross}}  could be used (see examples).
}
\note{
The \strong{colour} aesthetic is taken into account only if equal to
\strong{x} or \strong{y}.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips)
p_(ggally_table(tips, mapping = aes(x = smoker, y = sex)))
p_(ggally_table(tips, mapping = aes(x = day, y = time)))
p_(ggally_table(tips, mapping = aes(x = smoker, y = sex, colour = smoker)))

# colour is kept only if equal to x or y
p_(ggally_table(tips, mapping = aes(x = smoker, y = sex, colour = day)))

# diagonal version
p_(ggally_tableDiag(tips, mapping = aes(x = smoker)))

# custom label size and color
p_(ggally_table(tips, mapping = aes(x = smoker, y = sex), size = 16, color = "red"))

# display column proportions
p_(ggally_table(
  tips,
  mapping = aes(x = day, y = sex, label = scales::percent(after_stat(col.prop)))
))

# draw table cells
p_(ggally_table(
  tips,
  mapping = aes(x = smoker, y = sex),
  geom_tile_args = list(colour = "black", fill = "white")
))

# Use standardized residuals to fill table cells
p_(ggally_table(
  as.data.frame(Titanic),
  mapping = aes(
    x = Class, y = Survived, weight = Freq,
    fill = after_stat(std.resid),
    label = scales::percent(after_stat(col.prop), accuracy = .1)
  ),
  geom_tile_args = list(colour = "black")
) +
  scale_fill_steps2(breaks = c(-3, -2, 2, 3), show.limits = TRUE))
}
\author{
Joseph Larmarange
}
\keyword{hplot}
