% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_means.R
\name{plot.ls_means}
\alias{plot.ls_means}
\title{Bar Plots of LS-Means}
\usage{
\method{plot}{ls_means}(x, y = NULL, which = NULL, mult = TRUE, ...)
}
\arguments{
\item{x}{an \code{\link{ls_means}} object.}

\item{y}{not used and ignored with a warning.}

\item{which}{optional character vector naming factors for which LS-means should
be plotted. If \code{NULL} (default) plots for all LS-means are generated.}

\item{mult}{if \code{TRUE} and there is more than one term for which to plot
LS-means the plots are organized in panels with \code{facet_wrap}.}

\item{...}{currently not used.}
}
\value{
generates the desired plots and invisibly returns the plot objects.
}
\description{
Bar plots of LS-means using the \pkg{ggplot2} package.
}
\examples{

# Fit example model with 2 factors:
data("cake", package="lme4")
cake$Temp <- factor(cake$temperature, ordered = FALSE)
model <- lmer(angle ~ recipe * Temp + (1|recipe:replicate), cake)

# Extract LS-means:
(lsm <- ls_means(model))

# Multi-frame plot of the LS-means
plot(lsm)

# Compute list of 'single frame' plots:
res <- plot(lsm, mult=FALSE)

# Display each plot separately:
plot(res[[1]])
plot(res[[2]])

# Example with pairwise differences of LS-means:
(lsm <- ls_means(model, pairwise = TRUE))
plot(lsm, which="Temp")

}
\seealso{
\code{\link{ls_means.lmerModLmerTest}}
}
\author{
Rune Haubo B. Christensen
}
\keyword{internal}
