% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_sided.R
\name{get_level_from_bounds_one_sided}
\alias{get_level_from_bounds_one_sided}
\title{Calculates Global Significance Level From Simultaneous One-Sided Bounds for Rejection Region}
\usage{
get_level_from_bounds_one_sided(bounds)
}
\arguments{
\item{bounds}{Numeric vector where the ith component is the lower bound
for the ith order statistic. The components must lie in [0, 1], and each component must be
greater than or equal to the previous one.}
}
\value{
Global significance level
}
\description{
For a one-sided test of uniformity of i.i.d. observations on the unit interval,
this function will determine the significance level as a function of the rejection region.
Suppose \eqn{n} observations are drawn i.i.d. from some CDF F(x) on the unit interval,
and it is desired to test the null hypothesis that F(x) = x for all x in (0, 1) against
the one-sided alternative F(x) > x. Suppose the acceptance region for the test is
described by a set of lower bounds, one for each order statistic.
Given the lower bounds, this function calculates the significance level of the test where the
null hypothesis is rejected if at least one of the order statistics
falls below its corresponding lower bound.
}
\details{
Uses the method of Moscovich and Nadler (2016) as implemented in Crossprob (Moscovich 2020).
}
\examples{
# For X1, X2, X3 i.i.d. unif(0, 1),
# calculate 1 - P(X(1) > .1 and X(2) > .5 and X(3) > .8),
# where X(1), X(2), and X(3) are the order statistics.
get_level_from_bounds_one_sided(bounds = c(.1, .5, .8))

}
\references{
\itemize{
\item{\href{https://www.sciencedirect.com/science/article/abs/pii/S0167715216302802}{
Moscovich, Amit, and Boaz Nadler. "Fast calculation of boundary crossing probabilities for Poisson processes."
Statistics & Probability Letters 123 (2017): 177-182.}}
\item{\href{https://github.com/mosco/crossing-probability}{
Amit Moscovich (2020). Fast calculation of p-values for one-sided
Kolmogorov-Smirnov type statistics. arXiv:2009.04954}}
}
}
