% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AverageExpression}
\alias{AverageExpression}
\title{Averaged feature expression by identity class}
\usage{
AverageExpression(
  object,
  assays = NULL,
  features = NULL,
  return.seurat = FALSE,
  group.by = "ident",
  add.ident = NULL,
  layer = "data",
  slot = deprecated(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{assays}{Which assays to use. Default is all assays}

\item{features}{Features to analyze. Default is all features in the assay}

\item{return.seurat}{Whether to return the data as a Seurat object. Default is FALSE}

\item{group.by}{Category (or vector of categories) for grouping (e.g, ident, replicate, celltype); 'ident' by default
To use multiple categories, specify a vector, such as c('ident', 'replicate', 'celltype')}

\item{add.ident}{(Deprecated). Place an additional label on each cell prior to pseudobulking}

\item{layer}{Layer(s) to use; if multiple layers are given, assumed to follow
the order of 'assays' (if specified) or object's assays}

\item{slot}{(Deprecated). Slots(s) to use}

\item{verbose}{Print messages and show progress bar}

\item{...}{Arguments to be passed to methods such as \code{\link{CreateSeuratObject}}}
}
\value{
Returns a matrix with genes as rows, identity classes as columns.
If return.seurat is TRUE, returns an object of class \code{\link{Seurat}}.
}
\description{
Returns averaged expression values for each identity class.
}
\details{
If layer is set to 'data', this function assumes that the data has been log
normalized and therefore feature values are exponentiated prior to averaging
so that averaging is done in non-log space. Otherwise, if layer is set to
either 'counts' or 'scale.data', no exponentiation is performed prior to  averaging.
If \code{return.seurat = TRUE} and layer is not 'scale.data', averaged values
are placed in the 'counts' layer of the returned object and 'log1p'
is run on the averaged counts and placed in the 'data' layer \code{\link{ScaleData}}
is then run on the default assay before returning the object.
If \code{return.seurat = TRUE} and layer is 'scale.data', the 'counts' layer contains
average counts and 'scale.data' is set to the averaged values of 'scale.data'.
}
\examples{
data("pbmc_small")
head(AverageExpression(object = pbmc_small)$RNA)
head(AverageExpression(object = pbmc_small, group.by = c('ident', 'groups'))$RNA)

}
\concept{utilities}
