% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\docType{data}
\name{tibble_options}
\alias{tibble_options}
\title{Package options}
\usage{
tibble_options
}
\description{
Options that affect interactive display.
See \link[pillar:pillar_options]{pillar::pillar_options} for options that affect display on the console,
and \code{\link[cli:num_ansi_colors]{cli::num_ansi_colors()}} for enabling and disabling colored output
via ANSI sequences like \verb{[3m[38;5;246m[39m[23m}.
}
\details{
These options can be set via \code{\link[=options]{options()}} and queried via \code{\link[=getOption]{getOption()}}.
For this, add a \code{tibble.} prefix (the package name and a dot) to the option name.
Example: for an option \code{foo}, use \code{options(tibble.foo = value)} to set it
and \code{getOption("tibble.foo")} to retrieve the current value.
An option value of \code{NULL} means that the default is used.
}
\section{Options for the tibble package}{

\itemize{
\item \code{view_max}: Maximum number of rows shown by \code{\link[=view]{view()}}
if the input is not a data frame, passed on to \code{\link[=head]{head()}}. Default: \code{1000}.
}
}

\examples{
# Default setting:
getOption("tibble.view_max")

# Change for the duration of the session:
old <- options(tibble.view_max = 100)

# view() would show only 100 rows e.g. for a lazy data frame

# Change back to the original value:
options(old)

# Local scope:
local({
  rlang::local_options(tibble.view_max = 100)
  # view() would show only 100 rows e.g. for a lazy data frame
})
# view() would show the default 1000 rows e.g. for a lazy data frame
}
\keyword{datasets}
