% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal.R
\name{vec_equal}
\alias{vec_equal}
\title{Equality}
\usage{
vec_equal(x, y, na_equal = FALSE, .ptype = NULL)
}
\arguments{
\item{x, y}{Vectors with compatible types and lengths.}

\item{na_equal}{Should \code{NA} values be considered equal?}

\item{.ptype}{Override to optionally specify common type}
}
\value{
A logical vector the same size as the common size of \code{x} and \code{y}.
Will only contain \code{NA}s if \code{na_equal} is \code{FALSE}.
}
\description{
\code{vec_equal()} tests if two vectors are equal.
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_cast_common]{vec_cast_common()}} with fallback
\item \code{\link[=vec_recycle_common]{vec_recycle_common()}}
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
}
}

\examples{
vec_equal(c(TRUE, FALSE, NA), FALSE)
vec_equal(c(TRUE, FALSE, NA), FALSE, na_equal = TRUE)

vec_equal(5, 1:10)
vec_equal("d", letters[1:10])

df <- data.frame(x = c(1, 1, 2, 1), y = c(1, 2, 1, NA))
vec_equal(df, data.frame(x = 1, y = 2))
}
\seealso{
\code{\link[=vec_detect_missing]{vec_detect_missing()}}
}
