#!/usr/bin/env ruby

# This example demonstrates encoding and decoding a Ruby object.

# Use the current repo if run from the examples directory.
ox_dir = File.dirname(File.dirname(File.expand_path(__FILE__)))
$LOAD_PATH << File.join(ox_dir, 'ext')
$LOAD_PATH << File.join(ox_dir, 'lib')

require 'ox'

# Define a class that will be used for instances that are encoded and decoded.
class Classy
  def initialize(a, b)
    @a = a
    @b = b
  end

  def to_s
    "Classy a: #{@a}, b: #{@b}"
  end
end

obj = Classy.new(23, ['abc', {x: true}])

doc = Ox.dump(obj, mode: :object)

# The encoded format is not important other and should ot be generated by
# hand. It is of interest only for the curious.
puts "encoded object:\n#{doc}"

# Now convert back to a Ruby object.
obj2 = Ox.load(doc, mode: :object)

# Looks the same, print it out to check.
puts "decoded object: #{obj2}"
