# Summary

[Introduction](index.md)

---

- [Getting started](getting_started.md)
- [Python modules](module.md)
- [Python functions](function.md)
  - [Function signatures](function/signature.md)
  - [Error handling](function/error_handling.md)
- [Python classes](class.md)
  - [Class customizations](class/protocols.md)
    - [Basic object customization](class/object.md)
    - [Emulating numeric types](class/numeric.md)
    - [Emulating callable objects](class/call.md)
- [Type conversions](conversions.md)
  - [Mapping of Rust types to Python types](conversions/tables.md)]
  - [Conversion traits](conversions/traits.md)]
- [Python exceptions](exception.md)
- [Calling Python from Rust](python_from_rust.md)
- [GIL, mutability and object types](types.md)
- [Parallelism](parallelism.md)
- [Debugging](debugging.md)
- [Features reference](features.md)
- [Memory management](memory.md)
- [Advanced topics](advanced.md)
- [Building and distribution](building_and_distribution.md)
  - [Supporting multiple Python versions](building_and_distribution/multiple_python_versions.md)
- [Useful crates](ecosystem.md)
  - [Logging](ecosystem/logging.md)
  - [Using `async` and `await`](ecosystem/async-await.md)
- [FAQ and troubleshooting](faq.md)

---

[Appendix A: Migration guide](migration.md)
[Appendix B: PyO3 and rust-cpython](rust_cpython.md)
[Appendix C: Trait bounds](trait_bounds.md)
[Appendix D: Python typing hints](python_typing_hints.md)
[CHANGELOG](changelog.md)

---

[Contributing](contributing.md)
