#!/bin/bash
#
# get-upstream-tarball.sh

CURRENT_VERSION=$(curl -s https://raw.githubusercontent.com/ralph-irving/squeezelite/master/squeezelite.h | grep -E '^#define M...._VERSION' | cut -f3 -d' ' | tr -d '"' | awk --posix '/^[0-9.]+$/{getline x2; getline x3; line=$0 "." x2 "-" x3;print line}')

echo "detected version ${CURRENT_VERSION}"

# update debian/watch-local
sed -i -E "s/^(.*pretty=)(.+)?\+git/\1${CURRENT_VERSION}+git/" debian/watch-local

# download tarball
uscan --verbose --watchfile debian/watch-local
