use core:lang;
use lang:bs;
use lang:bs:macro;

/**
 * A SQL type.
 */
class SQLType {
	// Type in SQL.
	QueryType sqlType;

	// Storm-type.
	Type storm;

	init(QueryType sql, Type storm) {
		init {
			sqlType = sql;
			storm = storm;
		}
	}

	// Change size:
	SQLType sized(Nat size) {
		SQLType(sqlType.sized(size), storm);
	}
	SQLType sized(Str size) {
		sized(size.toNat());
	}

	Str toS() : override {
		QueryStrBuilder b;
		b.type(this);
		b.build.toS;
	}
}

// "put" function for the string builder:
void type(QueryStrBuilder to, SQLType this) {
	to.type(sqlType);
}


SQLType sqlInteger() {
	SQLType(QueryType:integer, named{Int});
}
SQLType sqlReal() {
	SQLType(QueryType:real, named{Double});
}
SQLType sqlText() {
	SQLType(QueryType:text, named{Str});
}

// Get a function for reading a particular type from a Row instance.
Function getColumnFn(Type? type) on Compiler {
	if (type is named{Bool})
		return named{Row:getBool<Row, Nat>};
	else if (type is named{Int})
		return named{Row:getInt<Row, Nat>};
	else if (type is named{Str})
		return named{Row:getStr<Row, Nat>};
	else if (type is named{Double})
		return named{Row:getDouble<Row, Nat>};
	else
		throw NotSupported("The type ${Value(type)} is not supported in the SQL library.");
}
