# 2022-03-01 Triage Log

A relatively noisy week in performance measurements, particularly on the
`externs` incremental benchmark. Based on the timing of the first noise, this
seems to be due to [#93839], which makes me suspect this is related to PGO or
inlining decisions of some kind. [#94373] might help.

Overall a relatively unchanged to slightly good week, with no outright regressions and most
changes relatively small.

[#93839]: https://github.com/rust-lang/rust/pull/93839
[#94373]: https://github.com/rust-lang/rust/pull/94373

Triage done by **@simulacrum**.
Revision range: [1204400ab8da9830f6f77a5e40e7ad3ea459676a..f0c4da49983aa699f715caf681e3154b445fb60b](https://perf.rust-lang.org/?start=1204400ab8da9830f6f77a5e40e7ad3ea459676a&end=f0c4da49983aa699f715caf681e3154b445fb60b&absolute=false&stat=instructions%3Au)

0 Regressions, 5 Improvements, 6 Mixed; 2 of them in rollups
43 comparisons made in total

#### Regressions

- No regressions this week.

#### Improvements

At opt-level=0, apply only ABI-affecting attributes to functions [#94127](https://github.com/rust-lang/rust/issues/94127)
- Arithmetic mean of relevant improvements: -1.2%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d5a9bc947617babe3833458f3e09f3d6d5e3d736&end=8128e910c0b4046afd0a1ef818b60082903bae03&stat=instructions:u): -3.9% on `incr-patched: Job` builds of `regex debug`

Make TLS `__getit` #[inline(always)] on non-Windows [#94373](https://github.com/rust-lang/rust/issues/94373)
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=761e8884858759b21f3374ad610494e68c087a38&end=035a717ee8bf548868fb50b5c7ca562fc4a657a7&stat=instructions:u): -3.0% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo debug`
- Tries to tackle some of the noise we've been seeing in the `externs`
  benchmarks.

Avoid query cache sharding code in single-threaded mode [#94084](https://github.com/rust-lang/rust/issues/94084)
- Arithmetic mean of relevant regressions: 1.1%
- Arithmetic mean of relevant improvements: -0.8%
- Arithmetic mean of all relevant changes: -0.6%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=bab4c13f64b4197abc1a361796be9940ed5b3904&end=3b1fe7e7c95e14dd8a420edf2f8a160c70211e04&stat=instructions:u): -2.3% on `full` builds of `keccak check`
- Primarily focused on bootstrap time improvement, rather than perf improvements
  to benchmarks, but helps slightly with both.

Apply noundef attribute to all scalar types which do not permit raw init [#94157](https://github.com/rust-lang/rust/issues/94157)
- Arithmetic mean of relevant improvements: -1.0%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6a705566166debf5eff88c57140df607fa409aaa&end=9fbff89354ba7a4ec2d1191a3f405cbe408370f6&stat=instructions:u): -1.7% on `incr-full` builds of `coercions debug`
- This may also be noise; the `externs` and `coercions` benchmark are both
  typically relatively noisy.

rustc_errors: let `DiagnosticBuilder::emit` return a "guarantee of emission". [#93368](https://github.com/rust-lang/rust/issues/93368)
- Arithmetic mean of all relevant changes: -0.5%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4e82f35492ea5c78e19609bf4468f0a686d9a756&end=d4de1f230ca30b7ce08fbf453daebf8b2e7ffcc9&stat=instructions:u): -0.5% on `full` builds of `deeply-nested-async debug`
- Improvements in bootstrap time, but not a significant change in compile times
  otherwise.

#### Mixed

Back more metadata using per-query tables [#94129](https://github.com/rust-lang/rust/issues/94129)
- Arithmetic mean of relevant regressions: 0.8%
- Arithmetic mean of relevant improvements: -0.6%
- Arithmetic mean of all relevant changes: -0.5%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1204400ab8da9830f6f77a5e40e7ad3ea459676a&end=7ccfe2ff1d59666dc0188dfd5847304fec257565&stat=instructions:u): -1.0% on `full` builds of `wf-projection-stress-65510 doc`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1204400ab8da9830f6f77a5e40e7ad3ea459676a&end=7ccfe2ff1d59666dc0188dfd5847304fec257565&stat=instructions:u): 0.9% on `incr-unchanged` builds of `externs opt`


Rollup of 9 pull requests [#94333](https://github.com/rust-lang/rust/issues/94333)
- Arithmetic mean of relevant regressions: 0.8%
- Arithmetic mean of relevant improvements: -5.9%
- Arithmetic mean of all relevant changes: -3.3%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4b043faba34ccc053a4d0110634c323f6c03765e&end=4e82f35492ea5c78e19609bf4468f0a686d9a756&stat=instructions:u): -14.4% on `incr-unchanged` builds of `encoding check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=4b043faba34ccc053a4d0110634c323f6c03765e&end=4e82f35492ea5c78e19609bf4468f0a686d9a756&stat=instructions:u): 1.1% on `incr-patched: println` builds of `cargo opt`

Use undef for (some) partially-uninit constants [#94130](https://github.com/rust-lang/rust/issues/94130)
- Arithmetic mean of relevant regressions: 0.7%
- Arithmetic mean of relevant improvements: -1.9%
- Arithmetic mean of all relevant changes: -0.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f6a79936da30702b1c717769a2d12dffbad6d30a&end=ece55d416e65256e4da274988651c20e5d5cb4ea&stat=instructions:u): -2.9% on `full` builds of `ctfe-stress-4 opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f6a79936da30702b1c717769a2d12dffbad6d30a&end=ece55d416e65256e4da274988651c20e5d5cb4ea&stat=instructions:u): 0.9% on `incr-unchanged` builds of `externs opt`

Caching the stable hash of Ty within itself [#94299](https://github.com/rust-lang/rust/issues/94299)
- Arithmetic mean of relevant regressions: 0.9%
- Arithmetic mean of relevant improvements: -1.2%
- Arithmetic mean of all relevant changes: -1.0%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4ce3749235fc31d15ebd444b038a9877e8c700d7&end=8d6f527530f4ba974d922269267fe89050188789&stat=instructions:u): -9.6% on `incr-unchanged` builds of `clap-rs check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=4ce3749235fc31d15ebd444b038a9877e8c700d7&end=8d6f527530f4ba974d922269267fe89050188789&stat=instructions:u): 1.3% on `incr-full` builds of `deeply-nested check`

Revert "Auto merge of #92419 - erikdesjardins:coldland, r=nagisa" [#94402](https://github.com/rust-lang/rust/issues/94402)
- Arithmetic mean of relevant regressions: 0.7%
- Arithmetic mean of relevant improvements: -1.7%
- Arithmetic mean of all relevant changes: 0.5%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6e5a6ffb14fc47051b0a23410c681ad6e4af045f&end=4a56cbec59903a830a5fc06c5c81956de4199584&stat=instructions:u): -3.8% on `full` builds of `ripgrep opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6e5a6ffb14fc47051b0a23410c681ad6e4af045f&end=4a56cbec59903a830a5fc06c5c81956de4199584&stat=instructions:u): 3.3% on `full` builds of `syn opt`

Rollup of 7 pull requests [#94469](https://github.com/rust-lang/rust/issues/94469)
- Arithmetic mean of relevant regressions: 0.3%
- Arithmetic mean of relevant improvements: -0.8%
- Arithmetic mean of all relevant changes: 0.0%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8d6f527530f4ba974d922269267fe89050188789&end=6343edfa11c80ffed02de7e059178d4c1637ecdb&stat=instructions:u): -0.9% on `incr-unchanged` builds of `externs debug`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=8d6f527530f4ba974d922269267fe89050188789&end=6343edfa11c80ffed02de7e059178d4c1637ecdb&stat=instructions:u): 0.3% on `full` builds of `await-call-tree doc`
- Regression across multiple doc benchmarks.
